/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.debug;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.msservice.MsServiceHelper;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class CalcFormulaDebugPlugin
extends AbstractBaseFormPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_calc");
        BasedataEdit f7 = (BasedataEdit)this.getControl("year");
        f7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        f7 = (BasedataEdit)this.getControl("period");
        f7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        if (key.equals("year") || key.equals("period")) {
            if (this.getModel().getValue("model") == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"CalcFormulaDebugPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
            qFilterList.add(new QFilter("model.id", "=", (Object)this.getModel().getDataEntity().getDynamicObject("model").getLong("id")));
            if (key.equals("year")) {
                qFilterList.add(new QFilter("number", "like", (Object)"FY%"));
            }
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("model".equals(e.getProperty().getName())) {
            this.getModel().setValue("year", null);
            this.getModel().setValue("period", null);
        }
    }

    @Override
    public void click(EventObject evt) {
        String opkey = ((Control)evt.getSource()).getKey();
        if ("btn_calc".equals(opkey)) {
            Object v;
            String formula = ((CodeEdit)this.getControl("formulas")).getText();
            if (StringUtils.isEmpty((String)formula)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8981\u8ba1\u7b97\u7684\u516c\u5f0f\u3002", (String)"CalcFormulaDebugPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            formula = formula.replaceAll("\\n", "");
            formula = formula.replaceAll("\\n\\r", "");
            formula = formula.replaceAll(" ", "");
            Map formulas = MapInitHelper.ofMap((Object)"1", (Object)formula.trim());
            HashMap<String, String> args = new HashMap<String, String>();
            DynamicObject model = this.getModel().getDataEntity().getDynamicObject("model");
            DynamicObject year = this.getModel().getDataEntity().getDynamicObject("year");
            DynamicObject period = this.getModel().getDataEntity().getDynamicObject("period");
            if (model != null) {
                args.put("model", model.getString("shownumber"));
            }
            if (year != null) {
                args.put("fy", year.getString("number"));
            }
            if (period != null) {
                args.put("period", period.getString("number"));
            }
            Map argsMap = (v = MsServiceHelper.invokeService((String)"fi", (String)"bcm", (String)"CalculateMsService", (String)"calculateFormulas", (Object[])new Object[]{ObjectSerialUtil.toJson((Object)formulas), ObjectSerialUtil.toJson(args)})) == null ? new HashMap(0) : (Map)ObjectSerialUtil.parseObject((String)v.toString(), Map.class);
            v = ((Map)argsMap.get("1")).get("v");
            this.getModel().setValue("txt_result", (Object)(v == null ? "null" : v.toString()));
            this.getView().updateView("txt_result");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8ba1\u7b97\u5b8c\u6210", (String)"CalcFormulaDebugPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }
}

