/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.debug;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.mq.consumer.MQMessagePublisherServiceHelper;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.common.enums.CacheTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.DebugServiceHelper;
import kd.fi.bcm.common.log.DebugSwitcher;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class DebugSwitcherPlugin
extends AbstractBaseFormPlugin {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, DebugSwitcherPlugin.class);

    @Override
    public void registerListener(EventObject e) {
        this.addItemClickListeners("toolbarap");
        this.addClickListeners("btn_localcache", "btn_redisclear", "btn_tmpldispenseclear", "btn_entitydataclear", "btn_tmplmodelcacheclear");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DebugSwitcher ds = DebugServiceHelper.getDebugSwitcher();
        this.getModel().setValue("invelim_switcher", (Object)ds.isDebug_InvElim());
        this.getModel().setValue("log_switcher", (Object)ds.isDebug_Log());
        this.getModel().setValue("sql_switcher", (Object)ds.isDebugDML());
        ComboEdit combo = (ComboEdit)this.getControl("cachetype");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        for (CacheTypeEnum item : CacheTypeEnum.values()) {
            items.add(new ComboItem(new LocaleString(item.name()), item.name()));
        }
        combo.setComboItems(items);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String opkey = evt.getItemKey();
        if ("confirm".equals(opkey)) {
            DebugSwitcher ds = new DebugSwitcher();
            boolean invlim = this.getModel().getDataEntity().getBoolean("invelim_switcher");
            boolean logs = this.getModel().getDataEntity().getBoolean("log_switcher");
            boolean sql = this.getModel().getDataEntity().getBoolean("sql_switcher");
            ds.setDebug_InvElim(invlim);
            ds.setDebug_Log(logs);
            ds.setDebugDML(sql);
            DebugServiceHelper.saveDebugSwitcher((DebugSwitcher)ds);
            log.error(String.format("Debug switch setting. invelim_switcher:%s,log_switcher:%s,sql_switcher:%s.", invlim, logs, sql));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u6210\u529f", (String)"DebugSwitcherPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void click(EventObject evt) {
        String opkey = ((Control)evt.getSource()).getKey();
        if ("btn_localcache".equals(opkey)) {
            String cacheType = this.getModel().getDataEntity().getString("cachetype");
            if (!StringUtils.isNotEmpty((String)cacheType)) throw new KDBizException(ResManager.loadKDString((String)"\u7f13\u5b58\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DebugSwitcherPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            MQMessagePublisherServiceHelper.publishClearAllCacheByType((CacheTypeEnum)CacheTypeEnum.valueOf((String)cacheType));
            log.error(String.format("Local Cache clean,cacheType:%s.", cacheType));
        } else if ("btn_redisclear".equals(opkey)) {
            String key = this.getModel().getDataEntity().getString("txt_key");
            if (!StringUtils.isNotEmpty((String)key)) throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199key\u3002", (String)"DebugSwitcherPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            if ("all".equalsIgnoreCase(key)) {
                AppCacheServiceHelper.clear();
            } else {
                AppCacheServiceHelper.remove((String)key);
            }
            log.error(String.format("Redis Cache clean,key:%s.", key));
        } else if ("btn_entitydataclear".equals(opkey)) {
            String key = this.getModel().getDataEntity().getString("txt_tablekey");
            if (!StringUtils.isNotEmpty((String)key)) throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199key\u3002", (String)"DebugSwitcherPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)key.trim());
            if (dt == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u7f16\u7801\u201c%s\u201d\u627e\u4e0d\u5230\u5177\u4f53\u7684\u5b9e\u4f53\u3002", (String)"DebugSwitcherPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), key));
            }
            DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)dt);
            cacheManager.removeByDt();
            log.error(String.format("Entity Cache clean,key:%s.", key));
        } else if ("btn_tmpldispenseclear".equals(opkey)) {
            if (this.getModel().getValue("model") == null) throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a", (String)"DebugSwitcherPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            DynamicObjectCollection models = this.getModel().getDataEntity().getDynamicObjectCollection("model");
            for (DynamicObject model : models) {
                AppCacheServiceHelper.removeTemplateDispenseCache((String)model.getDynamicObject("fbasedataid").getString("number"));
            }
            log.error(String.format("Template Cache clean,opkey:%s.", opkey));
        } else if ("btn_tmplmodelcacheclear".equals(opkey)) {
            if (this.getModel().getValue("model4template") == null) throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a", (String)"DebugSwitcherPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            DynamicObjectCollection models = this.getModel().getDataEntity().getDynamicObjectCollection("model4template");
            for (DynamicObject model : models) {
                DynamicObjectCollection tmpls = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])new QFilter("model", "=", (Object)model.getDynamicObject("fbasedataid").getLong("id")).toArray());
                for (DynamicObject d : tmpls) {
                    AppCacheServiceHelper.remove((String)d.getString("id"));
                }
                log.error(String.format("Template Cache clean,opkey:%s.", opkey));
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6e05\u7406\u6210\u529f", (String)"DebugSwitcherPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }
}

