/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.org.model.StatusEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.fel.common.StringUtils;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CustomProImpPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(CustomProImpPlugin.class);
    private static final String IMPORT_BTN = "import";
    private static final List<String> HEADER_VALUE = Arrays.asList("dimension.number", "dimension.name", "member.number", "member.name");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{IMPORT_BTN});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entityName = (String)formShowParameter.getCustomParam("entityName");
        String dimId = (String)formShowParameter.getCustomParam("dimId");
        long modelId = (Long)formShowParameter.getCustomParam("modelId");
        this.getPageCache().put("entity_name", entityName);
        this.getPageCache().put("dim_id", dimId);
        this.getPageCache().put("model_id", String.valueOf(modelId));
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        this.getPageCache().put("CustomProImpPlugin_file_url", (String)((Map)evt.getUrls()[0]).get("url"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (!(source instanceof Button)) return;
        if (!IMPORT_BTN.equals(((Button)source).getKey())) return;
        TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream inputStream = null;
        try {
            TempFileCacheDownloadable.Content content;
            String file_url = this.getPageCache().get("CustomProImpPlugin_file_url");
            if (file_url == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u6587\u4ef6", (String)"CustomProImpPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            String[] reqParams = new URL(file_url).getQuery().split("&");
            HashMap<String, String> map = new HashMap<String, String>(reqParams.length);
            for (String param : reqParams) {
                String[] p = param.split("=");
                map.put(p[0], p[1]);
            }
            try {
                content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
            }
            catch (Exception e1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u6587\u4ef6", (String)"CustomProImpPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (content == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u6587\u4ef6", (String)"CustomProImpPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            inputStream = content.getInputStream();
            Throwable throwable = null;
            try (TXHandle tx = TX.required();){
                String msg = this.importCusProValues(inputStream);
                if (StringUtils.isNotEmpty((CharSequence)msg)) {
                    this.getView().showTipNotification(msg);
                    return;
                }
                this.getView().returnDataToParent((Object)true);
                this.getView().close();
                return;
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)("Failed to save data: " + e.getMessage())), new Object[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Exception e) {
            LOG.error("error", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private String importCusProValues(InputStream inputStream) throws IOException {
        ArrayList<List<String>> list = new ArrayList<List<String>>(128);
        HashMap<String, Long> cusNum2Ids = new HashMap<String, Long>(16);
        HashMap<Integer, String> row2Nums = new HashMap<Integer, String>(16);
        ArrayList<MutableTriple<Long, Long, String>> waitSaveMemNums = new ArrayList<MutableTriple<Long, Long, String>>(128);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entityName = (String)formShowParameter.getCustomParam("entityName");
        String dimId = (String)formShowParameter.getCustomParam("dimId");
        long modelId = (Long)formShowParameter.getCustomParam("modelId");
        DynamicObject dimDy = MemberReader.getDimensionDynById((long)Long.parseLong(dimId));
        Map members = MemberReader.getAllNodeFromCache((String)entityName, (Object)modelId);
        Set<String> memNums = members.values().stream().map(x -> x.getNumber()).collect(Collectors.toSet());
        Map<String, Long> num2Ids = members.values().stream().filter(x -> StorageTypeEnum.SHARE != x.getStorageType()).collect(Collectors.toMap(x -> x.getNumber(), y -> y.getId(), (v1, v2) -> v1));
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and("dimension", "=", (Object)Long.parseLong(dimId));
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_dimcustompro_value", (String)"id", (QFilter[])qf.toArray());
        Set ids = dys.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] customProVs = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_dimcustompro_value").getDynamicObjectType());
        Map<String, Long> id2Combs = Arrays.stream(customProVs).collect(Collectors.toMap(x -> x.getLong("member_id") + "_" + x.getLong("custompro"), y -> y.getLong("id"), (v1, v2) -> v2));
        Map<Long, DynamicObject> id2Dys = Arrays.stream(customProVs).collect(Collectors.toMap(x -> x.getLong("id"), y -> y, (v1, v2) -> v1));
        XSSFWorkbook wb = new XSSFWorkbook(inputStream);
        for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
            String msg;
            Sheet sheet = wb.getSheetAt(i);
            if (sheet == null) continue;
            for (int j = 0; j < sheet.getPhysicalNumberOfRows(); ++j) {
                Row row = sheet.getRow(j);
                int minCells = row.getFirstCellNum();
                short maxCells = row.getLastCellNum();
                ArrayList<String> sl = new ArrayList<String>(10);
                for (int k = minCells; k < maxCells; ++k) {
                    Cell cell = row.getCell(k);
                    if (cell == null) continue;
                    sl.add(cell.toString());
                }
                list.add(sl);
                if (j == 0) {
                    String msg2 = this.checkHeaderOfFile(list, row2Nums);
                    if (StringUtils.isNotEmpty((CharSequence)msg2)) {
                        return msg2;
                    }
                    this.getMappingOfCustomPro(list, Long.parseLong(dimId), cusNum2Ids);
                    list.clear();
                    continue;
                }
                if (j == 1) {
                    list.clear();
                    continue;
                }
                if (list.size() != 1000) continue;
                String msg3 = this.checkDataAndSave(list, memNums, num2Ids, cusNum2Ids, row2Nums, id2Dys, id2Combs, waitSaveMemNums);
                if (StringUtils.isNotEmpty((CharSequence)msg3)) {
                    return msg3;
                }
                list.clear();
            }
            if (list.size() > 0 && StringUtils.isNotEmpty((CharSequence)(msg = this.checkDataAndSave(list, memNums, num2Ids, cusNum2Ids, row2Nums, id2Dys, id2Combs, waitSaveMemNums)))) {
                return msg;
            }
            this.synShareMemValueOfCuss(waitSaveMemNums, entityName, modelId, id2Combs, id2Dys, Long.parseLong(dimId), cusNum2Ids);
        }
        return "";
    }

    private void synShareMemValueOfCuss(List<MutableTriple<Long, Long, String>> waitSaveMemNums, String entityName, long modelId, Map<String, Long> id2Combs, Map<Long, DynamicObject> id2Dys, long dimId, Map<String, Long> cusNum2Ids) {
        if (waitSaveMemNums.size() == 0) {
            return;
        }
        Set memIds = waitSaveMemNums.stream().map(x -> (Long)x.getLeft()).collect(Collectors.toSet());
        List shareNodes = MemberReader.getAllNodeFromCache((String)entityName, (Object)modelId).values().stream().filter(x -> StorageTypeEnum.SHARE == x.getStorageType()).filter(x -> 0L != x.getCopyfromId()).filter(x -> memIds.contains(x.getCopyfromId())).collect(Collectors.toList());
        if (shareNodes.size() == 0) {
            return;
        }
        Map<String, MutableTriple> stoId2Mutables = waitSaveMemNums.stream().collect(Collectors.toMap(x -> x.getLeft() + "_" + x.getMiddle(), y -> y, (v1, v2) -> v1));
        Map<Long, Long> id2CopyIds = shareNodes.stream().collect(Collectors.toMap(x -> x.getId(), y -> y.getCopyfromId(), (v1, v2) -> v1));
        Collection<Long> cusIds = cusNum2Ids.values();
        ArrayList<DynamicObject> dys = new ArrayList<DynamicObject>(10);
        Set<String> idCombs = id2Combs.keySet();
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        for (IDNumberTreeNode shareNode : shareNodes) {
            Long shareId = shareNode.getId();
            Long stoId = id2CopyIds.get(shareId);
            for (Long cusId : cusIds) {
                String combId = stoId + "_" + cusId;
                String combIdSha = shareId + "_" + cusId;
                MutableTriple mutableTriple = stoId2Mutables.get(combId);
                if (mutableTriple == null) continue;
                if (idCombs.contains(combIdSha)) {
                    Long cusValId = id2Combs.get(combIdSha);
                    DynamicObject cusValueDy = id2Dys.get(cusValId);
                    cusValueDy.set("value", mutableTriple.getRight());
                    cusValueDy.set("modifier", (Object)currUserId);
                    cusValueDy.set("modifytime", (Object)date);
                    dys.add(cusValueDy);
                    continue;
                }
                DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_dimcustompro_value");
                dy.set("model", (Object)modelId);
                dy.set("dimension", (Object)dimId);
                dy.set("member", (Object)shareId);
                dy.set("dimtype", (Object)entityName);
                dy.set("custompro", (Object)cusId);
                dy.set("value", mutableTriple.getRight());
                dy.set("creator", (Object)currUserId);
                dy.set("modifier", (Object)currUserId);
                dy.set("createtime", (Object)date);
                dy.set("modifytime", (Object)date);
                dy.set("status", (Object)StatusEnum.Checked.toString());
                dy.set("enable", (Object)"1");
                dys.add(dy);
            }
            if (dys.size() != 1000) continue;
            SaveServiceHelper.save((DynamicObject[])dys.toArray(new DynamicObject[0]));
            dys.clear();
        }
        if (dys.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])dys.toArray(new DynamicObject[0]));
        }
    }

    private void getMappingOfCustomPro(List<List<String>> list, long dimId, Map<String, Long> cusNum2Ids) {
        List<String> headers = list.get(0);
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)dimId, (String)"bcm_dimension");
        DynamicObjectCollection cusPros = dy.getDynamicObjectCollection("entryentity");
        if (cusPros.size() == 0) {
            return;
        }
        Map<String, Long> num2Ids = cusPros.stream().collect(Collectors.toMap(x -> x.getString("entrynumber"), y -> y.getLong("id"), (v1, v2) -> v2));
        for (int i = 4; i < headers.size(); ++i) {
            String number = headers.get(i);
            cusNum2Ids.put(number, num2Ids.get(number));
        }
    }

    private String checkDataAndSave(List<List<String>> list, Set<String> memNums, Map<String, Long> num2Ids, Map<String, Long> cusNum2Ids, Map<Integer, String> row2Nums, Map<Long, DynamicObject> id2Dys, Map<String, Long> id2Combs, List<MutableTriple<Long, Long, String>> waitSaveMemNums) {
        if (list.size() == 0) {
            return "";
        }
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        for (int i = 0; i < list.size(); ++i) {
            List<String> row = list.get(i);
            Long memId = 0L;
            for (int j = 0; j < row.size(); ++j) {
                String value = row.get(j);
                if (j == 0 || j == 1 || j == 2 || j == 3) {
                    if (StringUtils.isEmpty((CharSequence)value)) {
                        return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u7b2c%2$s\u5217\u503c\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165", (String)"CustomProImpPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 3, j + 1);
                    }
                    if (j == 2 && !memNums.contains(value)) {
                        return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165", (String)"CustomProImpPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 3, j + 1);
                    }
                    if (j == 2) {
                        memId = num2Ids.get(value);
                    }
                }
                if (j <= 3) continue;
                Long cusId = cusNum2Ids.get(row2Nums.get(j));
                MutableTriple mutableTriple = new MutableTriple();
                mutableTriple.setLeft((Object)memId);
                mutableTriple.setMiddle((Object)cusId);
                mutableTriple.setRight((Object)value);
                waitSaveMemNums.add((MutableTriple<Long, Long, String>)mutableTriple);
            }
        }
        if (waitSaveMemNums.size() > 0) {
            this.saveCustomProValues(waitSaveMemNums, currUserId, date, id2Dys, id2Combs);
        }
        return "";
    }

    private void saveCustomProValues(List<MutableTriple<Long, Long, String>> waitSaveMemNums, long currUserId, Date date, Map<Long, DynamicObject> id2Dys, Map<String, Long> id2Combs) {
        if (waitSaveMemNums.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> dysAdd = new ArrayList<DynamicObject>(waitSaveMemNums.size());
        ArrayList<DynamicObject> dysUp = new ArrayList<DynamicObject>(waitSaveMemNums.size());
        Long modelId = Long.parseLong(this.getPageCache().get("model_id"));
        Long dimId = Long.parseLong(this.getPageCache().get("dim_id"));
        String entityName = this.getPageCache().get("entity_name");
        Set<String> idCombs = id2Combs.keySet();
        for (int i = 0; i < waitSaveMemNums.size(); ++i) {
            MutableTriple<Long, Long, String> waitSaveMemNum = waitSaveMemNums.get(i);
            Long memId = (Long)waitSaveMemNum.getLeft();
            Long cusId = (Long)waitSaveMemNum.getMiddle();
            String combId = memId + "_" + cusId;
            if (idCombs.contains(combId)) {
                Long cusVId = id2Combs.get(combId);
                DynamicObject cusValueDy = id2Dys.get(cusVId);
                cusValueDy.set("value", waitSaveMemNum.getRight());
                cusValueDy.set("modifier", (Object)currUserId);
                cusValueDy.set("modifytime", (Object)date);
                dysUp.add(cusValueDy);
                continue;
            }
            DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_dimcustompro_value");
            dy.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            dy.set("model", (Object)modelId);
            dy.set("dimension", (Object)dimId);
            dy.set("member", waitSaveMemNum.getLeft());
            dy.set("dimtype", (Object)entityName);
            dy.set("custompro", waitSaveMemNum.getMiddle());
            dy.set("value", waitSaveMemNum.getRight());
            dy.set("creator", (Object)currUserId);
            dy.set("modifier", (Object)currUserId);
            dy.set("createtime", (Object)date);
            dy.set("modifytime", (Object)date);
            dy.set("status", (Object)StatusEnum.Checked.toString());
            dy.set("enable", (Object)"1");
            dysAdd.add(dy);
        }
        if (dysAdd.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])dysAdd.toArray(new DynamicObject[0]));
        }
        if (dysUp.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])dysUp.toArray(new DynamicObject[0]));
        }
    }

    private String checkHeaderOfFile(List<List<String>> list, Map<Integer, String> row2Nums) {
        List<String> headers = list.get(0);
        if (headers.size() == 0) {
            return ResManager.loadKDString((String)"\u6587\u4ef6\u8868\u5934\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u6839\u636e\u6a21\u677f\u8fdb\u884c\u586b\u5199", (String)"CustomProImpPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (headers.size() <= 4) {
            return ResManager.loadKDString((String)"\u6587\u4ef6\u8868\u5934\u4e0d\u6b63\u786e\uff0c\u8bf7\u53c2\u6570\u6a21\u677f\u8fdb\u884c\u586b\u5199", (String)"CustomProImpPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        for (int i = 0; i < headers.size(); ++i) {
            if (i == 0 || i == 1 || i == 2 || i == 3) {
                if (!HEADER_VALUE.contains(headers.get(i))) {
                    return ResManager.loadKDString((String)"\u6587\u4ef6\u8868\u5934\u4e0d\u6b63\u786e\uff0c\u8bf7\u53c2\u6570\u6a21\u677f\u8fdb\u884c\u586b\u5199", (String)"CustomProImpPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                }
            } else if (StringUtils.isEmpty((CharSequence)headers.get(i))) {
                return ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u57fa\u7840\u8d44\u6599\u5c5e\u6027\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u6839\u636e\u6a21\u677f\u8fdb\u884c\u586b\u5199", (String)"CustomProImpPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            if (i < 4) continue;
            row2Nums.put(i, headers.get(i));
        }
        return "";
    }
}

