/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportConfig;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class DemensionEnumImport
extends AbstractBaseFormPlugin
implements IImportPlugin {
    private Long modelId = 0L;
    private Long dimensionId = 0L;
    private String enumitemId;
    private String entityName = "bcm_enum_import";
    private String dimType = "";
    private DynamicObject[] createData;
    private static Map<String, Long> name2Ids = new HashMap<String, Long>(16);
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DemensionEnumImport.class);

    public void init(Map<String, Object> importParams) {
        ImportConfig importConfig = (ImportConfig)importParams.get("ImportConf");
        if (null != importConfig) {
            this.modelId = Long.valueOf((String)importConfig.getView().getParentView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
            this.dimensionId = Long.valueOf((String)importConfig.getView().getParentView().getFormShowParameter().getCustomParam("dimensionID"));
            this.enumitemId = (String)importConfig.getView().getParentView().getPageCache().getAll().get("enumitemID");
            QFilter qFilter = new QFilter("model", "=", (Object)this.modelId);
            qFilter.and(new QFilter("dimension", "=", (Object)this.dimensionId));
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_enumitem", (String)"id,name", (QFilter[])qFilter.toArray());
            name2Ids = query.stream().collect(Collectors.toMap(x -> x.getString("name"), x -> x.getLong("id")));
            this.dimType = QueryServiceHelper.exists((String)"bcm_dimension_ext", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.dimensionId)}) ? "bcm_dimension_ext" : "bcm_dimension";
        }
    }

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        return this.invalidate(data, importlogs);
    }

    private boolean invalidate(Map<String, Object> data, List<ImportLogger.ImportLog> importlogs) {
        DynamicObjectCollection dynamicObjects;
        Object modelNumber = data.get("model_shownumber");
        if (modelNumber == null) {
            String msg = ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DemensionEnumImport_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            importlogs.add(new ImportLogger.ImportLog(msg));
            return false;
        }
        QFilter qFilter = new QFilter("shownumber", "=", modelNumber);
        DynamicObject model = QueryServiceHelper.queryOne((String)"bcm_model", (String)"id", (QFilter[])qFilter.toArray());
        if (model == null) {
            String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u4f53\u7cfb\u7f16\u7801\u3002", (String)"DemensionEnumImport_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            importlogs.add(new ImportLogger.ImportLog(msg));
            return false;
        }
        Long id = model.getLong("id");
        if (!this.modelId.equals(id)) {
            String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u4f53\u7cfb\u7f16\u7801\u548c\u9875\u9762\u9009\u62e9\u7684\u4f53\u7cfb\u7f16\u7801\u4e0d\u4e00\u81f4\u3002", (String)"DemensionEnumImport_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            importlogs.add(new ImportLogger.ImportLog(msg));
            return false;
        }
        QFilter modelIdFilter = new QFilter("model", "=", (Object)this.modelId);
        Object dimensionNumber = data.get("dimension_number");
        QFilter dimensionNumberFilter = new QFilter("number", "=", dimensionNumber);
        String entityName = "bcm_dimension";
        if ("Extends".equals(dimensionNumber)) {
            entityName = "bcm_dimension_ext";
        }
        if ((dynamicObjects = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{modelIdFilter, dimensionNumberFilter})) != null && dynamicObjects.size() > 0) {
            DynamicObject dimensionNumberModel = (DynamicObject)dynamicObjects.get(0);
            long localDimensionId = dimensionNumberModel.getLong("id");
            if (!this.dimensionId.equals(localDimensionId)) {
                String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u7ef4\u5ea6\u548c\u9875\u9762\u9009\u62e9\u7684\u7ef4\u5ea6\u4e0d\u4e00\u81f4\u3002", (String)"DemensionEnumImport_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                importlogs.add(new ImportLogger.ImportLog(msg));
                return false;
            }
        } else {
            String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u7ef4\u5ea6\u4e0d\u5b58\u5728\u3002", (String)"DemensionEnumImport_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            importlogs.add(new ImportLogger.ImportLog(msg));
            return false;
        }
        QFilter modelFilter = new QFilter("model", "=", (Object)this.modelId);
        QFilter dimensionFilter = new QFilter("dimension", "=", (Object)this.dimensionId);
        Object name = data.get("name");
        DynamicObjectCollection dy = QueryServiceHelper.query((String)"bcm_enumitem", (String)"id, name, datatype", (QFilter[])new QFilter[]{modelFilter, dimensionFilter});
        List<DynamicObject> enumItem = null;
        if (dy != null && dy.size() > 0) {
            enumItem = dy.stream().filter(x -> name.equals(x.getString("name"))).collect(Collectors.toList());
            if (enumItem == null || enumItem.size() == 0) {
                String msg = ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u6ca1\u6709\u5bf9\u5e94\u7684\u679a\u4e3e\u9879\uff0c\u8bf7\u65b0\u589e\u540e\u518d\u5bfc\u5165\u3002", (String)"DemensionEnumImport_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                importlogs.add(new ImportLogger.ImportLog(msg));
                return false;
            }
        } else {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u6ca1\u6709\u5bf9\u5e94\u7684\u679a\u4e3e\u9879\uff0c\u8bf7\u65b0\u589e\u540e\u518d\u5bfc\u5165\u3002", (String)"DemensionEnumImport_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            importlogs.add(new ImportLogger.ImportLog(msg));
            return false;
        }
        String key = this.modelId + "_" + this.dimensionId + "_" + name;
        this.cacheDseqOfEnumItem(key, enumItem);
        String datatype = enumItem.get(0).getString("datatype");
        Object type = data.get("datatype");
        if (!type.equals(datatype)) {
            String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6570\u636e\u7c7b\u578b\u548c\u9875\u9762\u6570\u636e\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002", (String)"DemensionEnumImport_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            importlogs.add(new ImportLogger.ImportLog(msg));
            return false;
        }
        Object enumvalue = data.get("enumvalue");
        switch (datatype) {
            case "1": 
            case "5": {
                try {
                    Double.parseDouble(enumvalue.toString());
                    break;
                }
                catch (Exception e) {
                    String msg = ResManager.loadKDString((String)"\u679a\u4e3e\u503c\u8f93\u5165\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"DemensionEnumImport_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    importlogs.add(new ImportLogger.ImportLog(msg));
                    logger.error((Throwable)e);
                    return false;
                }
            }
            case "4": {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    String em = enumvalue.toString();
                    sdf.parse(em);
                    int indexOne = em.indexOf("-");
                    int indexTwo = em.indexOf("-", indexOne + 1);
                    if (em.substring(0, indexOne).length() != 4 || em.substring(indexOne + 1, indexTwo).length() != 2 || em.substring(indexTwo + 1).length() != 2 || !DemensionEnumImport.isValid(em, "yyyy-MM-dd")) {
                        String msg = ResManager.loadKDString((String)"\u679a\u4e3e\u503c\u8f93\u5165\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"DemensionEnumImport_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                        importlogs.add(new ImportLogger.ImportLog(msg));
                        return false;
                    }
                    break;
                }
                catch (ParseException e) {
                    String msg = ResManager.loadKDString((String)"\u679a\u4e3e\u503c\u8f93\u5165\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"DemensionEnumImport_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    importlogs.add(new ImportLogger.ImportLog(msg));
                    logger.error((Throwable)e);
                    return false;
                }
            }
        }
        return true;
    }

    private void cacheDseqOfEnumItem(String key, List<DynamicObject> enumItem) {
        Object dseq = ThreadCache.get((Object)key);
        if (dseq == null) {
            QFilter qf = new QFilter("enumitemid", "=", (Object)enumItem.get(0).getLong("id"));
            DynamicObjectCollection evs = QueryServiceHelper.query((String)"bcm_enumvalue", (String)"dseq", (QFilter[])qf.toArray(), (String)"dseq desc");
            if (evs == null || evs.size() == 0) {
                ThreadCache.put((Object)key, (Object)0);
            } else {
                int maxDseq = ((DynamicObject)evs.get(0)).getInt("dseq");
                ThreadCache.put((Object)key, (Object)maxDseq);
            }
        }
    }

    public List<Object> importData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        String action = (String)option.get("importtype");
        List<Object> list = null;
        switch (action) {
            case "new": {
                list = this.addNew(data, importlogs);
                break;
            }
            default: {
                return new ArrayList<Object>(10);
            }
        }
        return list;
    }

    private List<Object> addNew(Map<String, Object> data, List<ImportLogger.ImportLog> importlogs) {
        ArrayList<Object> success;
        block15: {
            success = new ArrayList<Object>(10);
            QFilter[] qFilters = this.getqFilters(data);
            DynamicObjectCollection dy = QueryServiceHelper.query((String)this.entityName, (String)"id,datatype,enumvalue", (QFilter[])qFilters);
            List dys = dy.stream().filter(x -> this.dataEquals(x.getString("enumvalue"), (String)data.get("enumvalue"), "1".equals(data.get("datatype")))).collect(Collectors.toList());
            try (TXHandle tx = TX.required();){
                try {
                    if (dys == null || dys.size() == 0) {
                        DynamicObject newDyn = this.buildNewDyn(data, false);
                        DynamicObject[] successIds = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDyn});
                        success.add(successIds[0].get("id"));
                        break block15;
                    }
                    String msg = ResManager.loadKDString((String)"\u672c\u6761\u6570\u636e\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"DemensionEnumImport_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    importlogs.add(new ImportLogger.ImportLog(msg));
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    importlogs.add(new ImportLogger.ImportLog(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20)));
                    tx.markRollback();
                }
            }
        }
        return success;
    }

    private boolean dataEquals(String a, String b, boolean isCurrency) {
        BigDecimal data2;
        BigDecimal data1;
        boolean ans = isCurrency ? (data1 = new BigDecimal(a)).compareTo(data2 = new BigDecimal(b)) == 0 : a.equals(b);
        return ans;
    }

    private DynamicObject buildNewDyn(Map<String, Object> data, boolean isModify) {
        DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)this.entityName);
        dyn.set("model", (Object)this.modelId);
        dyn.set("dimension", (Object)this.dimensionId);
        dyn.set("name", data.get("name"));
        dyn.set("datatype", data.get("datatype"));
        dyn.set("dimtype", (Object)this.dimType);
        Long enumId = name2Ids.get(data.get("name"));
        dyn.set("enumitemid", (Object)enumId);
        int dseq = (Integer)ThreadCache.get((Object)(this.modelId + "_" + this.dimensionId + "_" + data.get("name"))) + 1;
        dyn.set("dseq", (Object)dseq);
        ThreadCache.put((Object)(this.modelId + "_" + this.dimensionId + "_" + data.get("name")), (Object)dseq);
        String datatype = (String)data.get("datatype");
        try {
            if ("1".equals(datatype) || "5".equals(datatype)) {
                Object enumvalue = data.get("enumvalue");
                Double aDouble = Double.parseDouble(enumvalue.toString());
                DecimalFormat df = new DecimalFormat("0.00");
                String format = df.format(aDouble);
                dyn.set("enumvalue", (Object)format);
            } else {
                dyn.set("enumvalue", data.get("enumvalue"));
            }
        }
        catch (Exception e) {
            dyn.set("enumvalue", data.get("enumvalue"));
            logger.error((Throwable)e);
        }
        return dyn;
    }

    private QFilter[] getqFilters(Map<String, Object> data) {
        QFilter modelIdFilter = new QFilter("model", "=", (Object)this.modelId);
        QFilter dimensionFilter = new QFilter("dimension", "=", (Object)this.dimensionId);
        QFilter nameFilter = new QFilter("name", "=", data.get("name"));
        return new QFilter[]{modelIdFilter, dimensionFilter, nameFilter};
    }

    public static boolean isValid(String dateStr, String format) {
        DateTimeFormatter ldt = DateTimeFormatter.ofPattern(format.replace("y", "u")).withResolverStyle(ResolverStyle.STRICT);
        try {
            return LocalDate.parse(dateStr, ldt) != null;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return false;
        }
    }
}

