/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.org.model.StatusEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.NetAddressUtils;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.MultiBaseEditElement;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.common.cache.ICache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.factory.CacheGenFactory;
import kd.fi.bcm.common.enums.CacheTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ToStringHelper;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;

public class DimCacheQueryPlugin
extends AbstractBaseFormPlugin
implements DynamicPage {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(DimCacheQueryPlugin.class);
    private static final String MODEL_F7 = "model";
    private static final String DIM_COMB = "dimension";
    private static final String MEMBER_F7 = "member";
    private static final String MEMBER_FLEX = "memberflex";
    private static final String ENTRY_ENTITY = "entryentity";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
        this.addClickListeners("btn_query");
        MulBasedataEdit base = (MulBasedataEdit)this.getControl(MEMBER_F7);
        if (base != null) {
            base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        String key = ((BasedataEdit)evt.getSource()).getKey();
        if (MEMBER_F7.equals(key)) {
            long modelId = this.getModelId();
            String dimNum = (String)this.getModel().getValue(DIM_COMB);
            QFilter qf = new QFilter(MODEL_F7, "=", (Object)modelId);
            qf.and(DIM_COMB, "=", (Object)MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum));
            qf.and("status", "!=", (Object)StatusEnum.TempSave.toString());
            evt.getCustomQFilters().add(qf);
            evt.getFormShowParameter().setCustomParam("plugin", (Object)"MemberReferListPlugin");
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ComboEdit combo = (ComboEdit)this.getControl("cachetype");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        for (CacheTypeEnum item : CacheTypeEnum.values()) {
            if (item == CacheTypeEnum.All || item == CacheTypeEnum.DimMemberCache) continue;
            items.add(new ComboItem(new LocaleString(item.name()), item.name()));
        }
        items.add(new ComboItem(new LocaleString("redis"), "redis"));
        items.add(new ComboItem(new LocaleString("systemPros"), "systemPros"));
        combo.setComboItems(items);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "model": {
                DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL_F7);
                if (model == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"MemberReferListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.initDimCombValues(model.getLong("id"));
                this.getModel().setValue(MEMBER_F7, null);
                this.getModel().deleteEntryData(ENTRY_ENTITY);
                this.getPageCache().put("KEY_MODEL_ID", model.getString("id"));
                break;
            }
            case "dimension": {
                this.addMemberF7ByDim();
                this.getModel().setValue(MEMBER_F7, null);
                this.getModel().deleteEntryData(ENTRY_ENTITY);
                break;
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("bar_search".equals(itemKey)) {
            Object model = this.getModel().getValue(MODEL_F7);
            if (model == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"MemberReferListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            long modelId = ((DynamicObject)model).getLong("id");
            String dimNum = (String)this.getModel().getValue(DIM_COMB);
            Long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum);
            this.queryAllMemberFromCache(modelId, dimId);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("btn_query".equals(key)) {
            this.getModel().setValue("textareafield", (Object)"");
            this.getModel().setValue("node", (Object)"");
            Object cachetype = this.getModel().getValue("cachetype");
            if (cachetype == null) {
                this.getView().showTipNotification("the cache type is null");
                return;
            }
            String txtKey = (String)this.getModel().getValue("txt_key");
            if (StringUtils.isEmpty((CharSequence)txtKey)) {
                this.getView().showTipNotification("the key is null");
                return;
            }
            this.getModel().setValue("node", (Object)NetAddressUtils.getLocalIpAddress());
            if ("redis".equals(cachetype)) {
                Object cache = this.getCache((String)cachetype);
                if (cache != null) {
                    IAppCache appCache = (IAppCache)cache;
                    Object cacheValue = appCache.get(txtKey, Object.class);
                    if (cacheValue == null) {
                        this.getView().showTipNotification("the cache value not exist");
                        return;
                    }
                    String value = ToStringHelper.deepToString((Object)cacheValue);
                    LOG.info("cache value : " + value);
                    this.getModel().setValue("textareafield", (Object)value);
                }
            } else {
                Object cache = this.getCache((String)cachetype);
                if (cache != null) {
                    ICache iCache = (ICache)cache;
                    Object obj = iCache.getIfPresent(txtKey);
                    if (obj == null) {
                        this.getView().showTipNotification("the cache value not exist");
                        return;
                    }
                    String value = ToStringHelper.deepToString((Object)obj);
                    LOG.info("cache value : " + value);
                    this.getModel().setValue("textareafield", (Object)value);
                }
            }
        }
    }

    private void queryAllMemberFromCache(long modelId, Long dimId) {
        DynamicObjectCollection selectMembers = (DynamicObjectCollection)this.getModel().getValue(MEMBER_F7);
        if (selectMembers.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u5458", (String)"MemberReferListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Set selectMemIds = selectMembers.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toSet());
        DynamicObject dimObj = MemberReader.getDimensionDynById((long)dimId);
        String entityName = dimObj.getString("membermodel");
        Map allNodeFromCache = MemberReader.getAllNodeFromCache((String)entityName, (Object)modelId);
        ArrayList list = new ArrayList(10);
        allNodeFromCache.forEach((k, v) -> {
            if (selectMemIds.contains(k)) {
                list.add(v);
            }
        });
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        if (list.size() > 0) {
            String loginIP = NetAddressUtils.getLocalIpAddress();
            int i = this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, list.size())[0];
            for (IDNumberTreeNode idNumberTreeNode : list) {
                this.getModel().setValue("id", (Object)idNumberTreeNode.getId(), i);
                this.getModel().setValue("number", (Object)idNumberTreeNode.getNumber(), i);
                this.getModel().setValue("longnumber", (Object)idNumberTreeNode.getLongNumber(), i);
                this.getModel().setValue("nodeip", (Object)loginIP, i);
                this.getModel().setValue("parentid", (Object)(idNumberTreeNode.getParent() == null ? Long.valueOf(0L) : idNumberTreeNode.getParent().getId()), i);
                this.getModel().setValue("name", (Object)idNumberTreeNode.getName(), i);
                this.getModel().setValue("storagetype", (Object)idNumberTreeNode.getStorageType().getName(), i);
                this.getModel().setValue("aggoprt", (Object)idNumberTreeNode.getAggOprt(), i);
                this.getModel().setValue("copyfromid", (Object)idNumberTreeNode.getCopyfromId(), i);
                this.getModel().setValue("dseq", (Object)idNumberTreeNode.getdSeq(), i);
                ++i;
            }
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.setPageIndex(1);
    }

    private void addMemberF7ByDim() {
        List items = ((Container)this.getControl(MEMBER_FLEX)).getItems();
        if (items.size() > 0) {
            items.remove(0);
        }
        String entityName = SysDimensionEnum.Entity.getMemberTreemodel();
        Object value = this.getModel().getValue(DIM_COMB);
        if (value != null) {
            entityName = SysDimensionEnum.getMemberTreemodelByNumber((String)value.toString());
        }
        MultiBaseEditElement beEle = new MultiBaseEditElement(ResManager.loadKDString((String)"\u6210\u5458", (String)"MemberReferListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MEMBER_F7, entityName);
        beEle.setMustInput(true);
        beEle.setLabelDirection("v");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("30px");
        style.setMargin(margin);
        beEle.setStyle(style);
        Page page = new Page();
        Area area = new Area(MEMBER_FLEX);
        area.addElement((Element)beEle);
        page.addArea(area);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
    }

    private void initDimCombValues(long modelId) {
        QFilter qf = new QFilter(MODEL_F7, "=", (Object)modelId);
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id, name, number", (QFilter[])qf.toArray(), (String)"dseq");
        if (dims.size() > 0) {
            ComboEdit comboEdit = (ComboEdit)this.getControl(DIM_COMB);
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(dims.size());
            for (DynamicObject dynamicObject : dims) {
                String name = dynamicObject.getString("name");
                String number = dynamicObject.getString("number");
                ComboItem comboItem = new ComboItem(new LocaleString(name), number);
                items.add(comboItem);
            }
            comboEdit.setComboItems(items);
            this.getModel().setValue(DIM_COMB, (Object)((DynamicObject)dims.get(0)).getString("number"));
        }
    }

    private Object getCache(String cacheType) {
        if (StringUtils.isEmpty((CharSequence)cacheType)) {
            return null;
        }
        Set cacheEnums = Arrays.stream(CacheTypeEnum.values()).map(x -> x.toString()).collect(Collectors.toSet());
        if (!cacheEnums.contains(cacheType) && !"redis".equals(cacheType)) {
            return null;
        }
        if (CacheTypeEnum.DimMemberCache.toString().equals(cacheType)) {
            return CacheGenFactory.getDimMemberCacheCache();
        }
        if (CacheTypeEnum.CommonCache.toString().equals(cacheType)) {
            return CacheGenFactory.getCommonCache();
        }
        if (CacheTypeEnum.TemporaryCache.toString().equals(cacheType)) {
            return CacheGenFactory.getTemporaryCache();
        }
        if (CacheTypeEnum.TemplateModelReadCache.toString().equals(cacheType)) {
            return CacheGenFactory.getTemplateModelReadCache();
        }
        if (CacheTypeEnum.TemplateAlternateFloatCache.toString().equals(cacheType)) {
            return CacheGenFactory.getTemplateAlternateFloatCache();
        }
        if (CacheTypeEnum.BizStatusCache.toString().equals(cacheType)) {
            return CacheGenFactory.getBizStatusCache();
        }
        return AppCache.get((String)"_bcm.");
    }
}

