/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.fel.common.StringUtils;
import org.apache.commons.lang3.ArrayUtils;

public class DimensionCircleCheckAlgorithm {
    private static final String SPLIT_CHAR = String.valueOf('!');

    public static Optional<String> check(String sourceMemLongNum, Collection<String> childLongNums, String targetMemLongNum) {
        if (StringUtils.isEmpty((CharSequence)sourceMemLongNum) || StringUtils.isEmpty((CharSequence)targetMemLongNum)) {
            return Optional.empty();
        }
        String sourceNumber = DimensionCircleCheckAlgorithm.extractNumber(sourceMemLongNum);
        Set<String> targetMemNumbers = DimensionCircleCheckAlgorithm.splitLongNumber(targetMemLongNum);
        if (targetMemNumbers.contains(sourceNumber)) {
            return Optional.of(sourceNumber);
        }
        if (!CollectionUtils.isEmpty(childLongNums)) {
            LinkedHashSet<String> appendNumbers = new LinkedHashSet<String>();
            for (String oneChildLongNum : childLongNums) {
                appendNumbers.clear();
                appendNumbers.add(sourceNumber);
                String leavingPath = oneChildLongNum.replace(sourceMemLongNum, "");
                appendNumbers.addAll(DimensionCircleCheckAlgorithm.splitLongNumber(leavingPath));
                Optional<String> duplicateNum = DimensionCircleCheckAlgorithm.isIncludeAny(targetMemNumbers, appendNumbers);
                if (!duplicateNum.isPresent()) continue;
                return duplicateNum;
            }
        }
        return Optional.empty();
    }

    public static Optional<String> check(long modelId, String entityName, long sourceMemberId, long targetMemId) {
        IDNumberTreeNode sourceMember = MemberReader.findMemberById((long)modelId, (String)entityName, (Long)sourceMemberId);
        IDNumberTreeNode targetMember = MemberReader.findMemberById((long)modelId, (String)entityName, (Long)targetMemId);
        return DimensionCircleCheckAlgorithm.check(sourceMember.getLongNumber(), DimensionCircleCheckAlgorithm.collectAllDescendantLongNumbers(sourceMember), targetMember.getLongNumber());
    }

    private static Optional<String> isIncludeAny(Set<String> numberPath, Set<String> appendNumberPath) {
        if (CollectionUtils.isEmpty(numberPath)) {
            throw new IllegalArgumentException("param numberPath is empty");
        }
        if (CollectionUtils.isEmpty(appendNumberPath)) {
            return Optional.empty();
        }
        return appendNumberPath.stream().filter(x -> numberPath.contains(x)).findFirst();
    }

    public static Collection<String> staticCheckCycle(Collection<String> batchLongNums) {
        ArrayList<String> cyclesNums = new ArrayList<String>(8);
        if (!CollectionUtils.isEmpty(batchLongNums)) {
            batchLongNums.stream().forEach(x -> {
                if (DimensionCircleCheckAlgorithm.splitLongNumber(x).size() != x.split(SPLIT_CHAR).length) {
                    cyclesNums.add((String)x);
                }
            });
        }
        return cyclesNums;
    }

    private static Set<String> splitLongNumber(String longNumber) {
        Object[] items = longNumber.split(SPLIT_CHAR);
        if (ArrayUtils.isNotEmpty((Object[])items)) {
            LinkedHashSet<String> numbers = new LinkedHashSet<String>(4);
            Arrays.stream(items).forEach(x -> numbers.add((String)x));
            return numbers;
        }
        return Collections.EMPTY_SET;
    }

    private static String extractNumber(String longNumber) {
        if (StringUtils.isEmpty((CharSequence)longNumber)) {
            throw new IllegalArgumentException("param longNumber is required.");
        }
        String[] items = longNumber.split(SPLIT_CHAR);
        return items[items.length - 1];
    }

    private static Collection<String> collectAllDescendantLongNumbers(IDNumberTreeNode member) {
        ArrayList<String> result = new ArrayList<String>(8);
        HashSet history = new HashSet(10);
        ArrayDeque<IDNumberTreeNode> memberQueue = new ArrayDeque<IDNumberTreeNode>(10);
        memberQueue.add(member);
        while (!memberQueue.isEmpty()) {
            IDNumberTreeNode curMember = (IDNumberTreeNode)memberQueue.poll();
            result.add(curMember.getLongNumber());
            List childs = curMember.getChildren();
            if (childs.isEmpty()) continue;
            childs.stream().forEach(x -> {
                if (history.add(x)) {
                    memberQueue.add((IDNumberTreeNode)x);
                }
            });
        }
        return result;
    }

    public static void main(String[] args) {
    }
}

