/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension;

import com.alibaba.fastjson.JSON;
import com.google.common.cache.Cache;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.dimension.util.ModelUtil;
import kd.fi.bcm.business.export.strategy.DimOrgViewExportStrategy;
import kd.fi.bcm.business.export.strategy.ExportExecuteStrategyContext;
import kd.fi.bcm.business.export.strategy.IExport;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.CslSchemeEnum;
import kd.fi.bcm.common.enums.DimShowPropertyEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.dimension.search.DimensionMemberSearch;
import kd.fi.bcm.formplugin.dimension.search.helper.SearchCacheManager;
import kd.fi.bcm.formplugin.dimension.util.DimensionUtil;
import kd.fi.bcm.formplugin.dimension.util.TreeEntryNewUtil;
import kd.fi.bcm.formplugin.dimension.util.VirtualLoadingUtil;
import kd.fi.bcm.formplugin.tree.dimension.ICEntityTreeBuilder;
import kd.fi.bcm.formplugin.tree.dimension.ICEntityTreeNode;

public class DimensionOrgView
extends AbstractBaseListPlugin
implements TreeNodeQueryListener {
    private static final String tree_entryentity = "treeentryentity";
    private static final String treeview_ap = "treeviewap";
    private static final String FLEX_PANEL_AP5 = "flexpanelap5";
    private static final String FLEX_PANEL_AP2 = "flexpanelap2";
    private static final String SPLIT_CONTAINER_AP_IC = "splitcontainerapic";
    private static final String BILLLISTAP = "billlistap";
    private static final String SELECTED_IC_GROUP = "selectedIcGroup";
    private static final String TREE_LEFT = "treeleft";
    protected static final String SELECTED_DIM_ID = "selectedDimId";
    protected static final String SELECTED_DIM_SIGN = "selectedDiSign";
    private static final String SCENARIO_F7 = "scenario";
    private static final String CSLSCHEME_F7 = "cslscheme";
    private static final String YEAR_F7 = "year";
    private static final String PERIOD_F7 = "period";
    private static final List<String> dimKeys = Arrays.asList("year", "period", "scenario");

    @Override
    public void initialize() {
        super.initialize();
        this.getPageCache().put("KEY_MODEL_ID", (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        HashMap map = new HashMap();
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
        this.addClickListeners("searchbefore", "searchnext");
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(tree_entryentity);
        treeEntry.addCellClickListener(evt -> this.queryTreeNodeChildren(evt));
        Search sl = (Search)this.getControl("searchap");
        sl.addEnterListener(event -> {
            Object selectPk = treeEntry.getView().getModel().getValue("memberid");
            int selectRow = treeEntry.getModel().getEntryCurrentRowIndex(tree_entryentity);
            if (selectPk == null) {
                return;
            }
            DynamicObject dyCslScheme = (DynamicObject)this.getModel().getValue(CSLSCHEME_F7);
            DynamicObject dyYear = (DynamicObject)this.getModel().getValue(YEAR_F7);
            DynamicObject dyPeriod = (DynamicObject)this.getModel().getValue(PERIOD_F7);
            DynamicObject dyScene = (DynamicObject)this.getModel().getValue(SCENARIO_F7);
            if (!this.isRPT() && dyCslScheme == null || dyYear == null || dyPeriod == null || dyScene == null) {
                this.getView().showTipNotification(this.getMsgByApi());
                return;
            }
            if (StringUtils.isNotEmpty((String)event.getText())) {
                String searchContent = JSON.toJSONString((Object)event);
                this.getPageCache().put("search", searchContent);
                this.getPageCache().put("searchText", event.getText());
                this.getPageCache().put("lastsearch", selectPk.toString());
                this.getPageCache().put("lastselect", selectRow + "");
                this.dimensionMemberSearchAndUpdateShowView(searchContent, 1);
            }
        });
        BasedataEdit scheme = (BasedataEdit)this.getControl(CSLSCHEME_F7);
        scheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        final TreeView tree = (TreeView)this.getView().getControl(treeview_ap);
        tree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                DimensionOrgView.this.dimTreeNodeClick(tree);
            }
        });
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addSetFilterListener(event -> {
            event.getQFilters().add(this.getFilters());
            event.setOrderBy("level, dseq");
        });
        final TreeView icTree = (TreeView)this.getView().getControl(TREE_LEFT);
        icTree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                DimensionOrgView.this.nodeClick(icTree);
            }
        });
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals(CSLSCHEME_F7)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
            filter.and("nodetype", "=", (Object)Character.valueOf('1'));
            filter.and("number", "!=", (Object)CslSchemeEnum.DefaultRate.getNumber());
            showParameter.getListFilterParameter().setFilter(filter);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("searchbefore".equals(key) || "searchnext".equals(key)) {
            if (StringUtils.isEmpty((String)this.getPageCache().get("search"))) {
                this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                return;
            }
            if ("searchbefore".equals(key)) {
                String text = this.getPageCache().get("search");
                this.dimensionMemberSearchAndUpdateShowView(text, -1);
            } else {
                TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(tree_entryentity);
                Object selectPk = treeEntry.getView().getModel().getValue("memberid");
                int selectRow = treeEntry.getModel().getEntryCurrentRowIndex(tree_entryentity);
                String text = this.getPageCache().get("search");
                if (StringUtils.isNotEmpty((String)text)) {
                    this.getPageCache().put("lastsearch", selectPk.toString());
                    this.getPageCache().put("lastselect", selectRow + "");
                    this.dimensionMemberSearchAndUpdateShowView(text, 1);
                }
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        this.getPageCache().put("model", modelId);
        DimensionUtil.initBizChangeType(this.getModelId(), (ComboEdit)this.getControl("bizchangetype"));
        this.initDimensionTree();
        this.getView().setVisible(Boolean.FALSE, new String[]{SPLIT_CONTAINER_AP_IC});
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_PANEL_AP5, CSLSCHEME_F7});
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName().toLowerCase(Locale.ENGLISH);
        DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
        DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
        if (newValue != null && oldValue != null && newValue.getPkValue().equals(oldValue.getPkValue())) {
            return;
        }
        switch (key) {
            case "scenario": 
            case "year": 
            case "period": 
            case "cslscheme": {
                Boolean isSureReturn = this.propertyChangedDimUse(key, newValue, false, false);
                if (!isSureReturn.booleanValue()) {
                    return;
                }
                String entityName = this.getPageCache().get(SELECTED_DIM_SIGN);
                if ("bcm_icmembertree".equals(entityName)) {
                    this.buildIcDimEffMembers();
                    break;
                }
                this.buildTreeByCslschemeId();
                break;
            }
        }
    }

    private void buildTreeByCslschemeId() {
        DynamicObject dyCslScheme = (DynamicObject)this.getModel().getValue(CSLSCHEME_F7);
        DynamicObject dyYear = (DynamicObject)this.getModel().getValue(YEAR_F7);
        DynamicObject dyPeriod = (DynamicObject)this.getModel().getValue(PERIOD_F7);
        DynamicObject dyScene = (DynamicObject)this.getModel().getValue(SCENARIO_F7);
        if (!this.isRPT() && dyCslScheme == null || dyYear == null || dyPeriod == null || dyScene == null) {
            return;
        }
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(tree_entryentity);
        this.getModel().deleteEntryData(tree_entryentity);
        Long modelId = this.getModelId();
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
        if (this.isRPT()) {
            qf.and(new QFilter(CSLSCHEME_F7, "=", (Object)CslSchemeServiceHelper.getRptDefaultSchemeId((long)modelId)).or("number", "=", (Object)DimTypesEnum.ENTITY.getNumber()));
            qf.and("level", "in", Arrays.asList(1, 2, 3));
        } else {
            qf.and(CSLSCHEME_F7, "=", (Object)dyCslScheme.getLong("id"));
            qf.and("level", "in", Arrays.asList(2, 3));
        }
        DynamicObjectCollection members = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)this.getSelector(), (QFilter[])qf.toArray(), (String)"level, dseq");
        if (members.size() == 0) {
            return;
        }
        FilterOrgStructParam param = new FilterOrgStructParam(this.getModelId(), dyScene.getLong("id"), dyYear.getString("number"), dyPeriod.getLong("id"));
        if ((members = EntityVersioningUtil.filterOrgsByVersion((DynamicObjectCollection)members, (FilterOrgStructParam)param)).size() == 0) {
            return;
        }
        List<String> properties = this.getProperties();
        TreeEntryNewUtil.newTreeEntry(this.getModel(), members, properties);
        treeEntry.setCollapse(true);
        treeEntry.expandOne(0);
        treeEntry.selectRows(0);
        this.getView().updateView(tree_entryentity);
        this.setNameOfRootAndRateOrg((List<DynamicObject>)this.getModel().getEntryEntity(tree_entryentity));
        SearchCacheManager searchCacheManager = new SearchCacheManager();
        searchCacheManager.clearDimensionMemberSearch();
        GlobalCacheServiceHelper.getCommonCache().invalidateStartsWithKey("orgView_memberSearch_");
        String formId = this.getView().getFormShowParameter().getFormId();
        long cslId = this.isRPT() ? CslSchemeServiceHelper.getRptDefaultSchemeId((long)modelId).longValue() : dyCslScheme.getLong("id");
        long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)DimTypesEnum.ENTITY.getNumber());
        GlobalCacheServiceHelper.getCommonCache().invalidateStartsWithKey(formId + "_" + modelId + "_" + dimId + "_" + (cslId == 0L ? "" : Long.valueOf(cslId)));
    }

    private String getSelector() {
        return "id,number,parent,dseq,level,storageType,share,isleaf,copyfrom,aggoprt,modifytime,longnumber,model,dimension,cslscheme,currency.name as currency,ctrlorg.name as ctrlorg,isinnerorg,bizchangerds.id,bizchangerds.changetype as bizchangetype,bizchangerds.changetype, bizchangerds.bizeffdate, bizchangerds.bizexpdate, namechangerds.namerds as name, namechangerds.nameeffdate, namechangerds.nameexpdate";
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        DynamicObject dyCslScheme = (DynamicObject)this.getModel().getValue(CSLSCHEME_F7);
        DynamicObject dyYear = (DynamicObject)this.getModel().getValue(YEAR_F7);
        DynamicObject dyPeriod = (DynamicObject)this.getModel().getValue(PERIOD_F7);
        DynamicObject dyScene = (DynamicObject)this.getModel().getValue(SCENARIO_F7);
        if (!this.isRPT() && dyCslScheme == null || dyYear == null || dyPeriod == null || dyScene == null) {
            return;
        }
        long modelId = this.getModelId();
        DynamicObject obj = this.getModel().getEntryRowEntity(tree_entryentity, evt.getRowKey());
        long pMemberId = obj.getLong("id");
        String storagetype = obj.getString("storageType");
        if (StorageTypeEnum.SHARE.getOIndex().equals(storagetype)) {
            IDNumberTreeNode stoMem = MemberReader.findMemberById((long)modelId, (String)"bcm_entitymembertree", (Long)pMemberId);
            if (stoMem == IDNumberTreeNode.NotFoundTreeNode) {
                throw new KDBizException("DimensionOrgView queryTreeNodeChildren the storage member is not found");
            }
            pMemberId = stoMem.getCopyfromId();
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("parent", "=", (Object)pMemberId).or(new QFilter("id", "=", (Object)pMemberId)));
        qFilter.and(new QFilter("status", "!=", (Object)"A"));
        DynamicObjectCollection members = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)this.getSelector(), (QFilter[])qFilter.toArray(), (String)"level, dseq");
        if (members.size() < 1) {
            return;
        }
        FilterOrgStructParam param = new FilterOrgStructParam(this.getModelId(), dyScene.getLong("id"), dyYear.getString("number"), dyPeriod.getLong("id"));
        EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)param, (List)members);
        if (members.size() < 1) {
            return;
        }
        List<String> properties = this.getProperties();
        TreeEntryNewUtil.insertTreeEntry(this.getModel(), members, properties, evt.getRowKey(), obj.getLong("id"), storagetype, "bcm_entitymembertree");
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(tree_entryentity);
        this.getView().updateView(tree_entryentity, evt.getRowKey());
        this.collapseExpNode(evt.getRowKey() + 1, members.size() - 1, treeEntry);
        int[] selectRows = treeEntry.getSelectRows();
        int[] newSelectRows = new int[selectRows.length + 1];
        System.arraycopy(selectRows, 0, newSelectRows, 0, selectRows.length);
        newSelectRows[newSelectRows.length - 1] = evt.getRowKey();
        treeEntry.selectRows(newSelectRows, evt.getRowKey());
        VirtualLoadingUtil.cacheExpendIds(this.getView(), Long.parseLong(evt.getNodeId().toString()));
    }

    private void collapseExpNode(int beginRow, int rowCount, TreeEntryGrid entryGrid) {
        if (rowCount == 0) {
            return;
        }
        int[] allRowIndexs = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            allRowIndexs[i] = beginRow + i;
        }
        entryGrid.collapseOne(allRowIndexs);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_export": {
                this.exportOrgMembers();
                break;
            }
            case "bar_quit": {
                this.getView().close();
            }
        }
    }

    private void exportOrgMembers() {
        String entityName = this.getPageCache().get(SELECTED_DIM_SIGN);
        boolean isOrg = "bcm_entitymembertree".equals(entityName);
        String msg = this.validate();
        if (StringUtils.isNotEmpty((String)msg)) {
            this.getView().showTipNotification(msg);
            return;
        }
        String entityNameImp = null;
        entityNameImp = isOrg ? "bcm_entitymembertree".replace("tree", "imp") : "bcm_icmembertree".replace("tree", "imp");
        long modelId = this.getModelId();
        long dimId = Long.parseLong(this.getPageCache().get(SELECTED_DIM_ID));
        ArrayList<Long> selectTreeNode = new ArrayList<Long>(16);
        this.getSelectedIds(modelId, entityName, selectTreeNode);
        QFBuilder qb = new QFBuilder("bizobject.number", "=", (Object)entityNameImp);
        qb.add(new QFilter("templatetype", "=", (Object)"IMPT").or(new QFilter("templatetype", "is null", null)));
        String template = "";
        template = isOrg ? (this.isRPT() ? "bcm_entitymemberimp_IMPT_RPT" : "bcm_entitymemberimp_IMPT_S") : "bcm_icmemberimp_IMPT_S";
        qb.add(new QFilter("number", "=", (Object)template));
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"export", (String)"bos_importtemplate", (QFilter[])qb.toArray(), (String)"", (int)-1);
        if (pkIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9884\u5236\u5bfc\u5165\u6a21\u677f\u3002", (String)"DimensionDisplayList_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String schemeId = "";
        if (isOrg) {
            if (this.isCM()) {
                schemeId = ((DynamicObject)this.getValue(CSLSCHEME_F7)).getString("id");
                if (StringUtils.isEmpty((String)schemeId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7\u89c6\u56fe\u6216\u5206\u7c7b\u3002", (String)"DimensionDisplayList_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else if (this.isRPT()) {
                schemeId = String.valueOf(CslSchemeServiceHelper.getRptDefaultSchemeId((long)modelId));
            }
        }
        try {
            DynamicObjectCollection datas;
            FormView formView = (FormView)this.getView();
            String routeAppId = formView.getFormShowParameter().getServiceAppId();
            HashMap<String, Object> outputParams = new HashMap<String, Object>();
            outputParams.put("modelId", modelId);
            outputParams.put("dimId", dimId);
            outputParams.put("schemeId", schemeId);
            outputParams.put("selectData", selectTreeNode);
            ExportExecuteStrategyContext exportExecuteStrategyContext = new ExportExecuteStrategyContext();
            exportExecuteStrategyContext.setExport((IExport)new DimOrgViewExportStrategy());
            String url = exportExecuteStrategyContext.export(routeAppId, ((Long)pkIds.get(0)).longValue(), entityNameImp, entityName, outputParams);
            if (StringUtils.isNotEmpty((String)url)) {
                this.downloadFile(url, "bcm_dimensionmanager", "47150e89000000ac");
            }
            if ((datas = this.getModel().getEntryEntity(tree_entryentity)) != null && !datas.isEmpty()) {
                OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u5bfc\u51fa", (String)"DimensionDisplayList_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f", (String)"DimensionDisplayList_39", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Long)this.getModelId());
            }
        }
        catch (IOException e) {
            log.error((Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", ""), new Object[]{e.getMessage()});
        }
    }

    private void getSelectedIds(long modelId, String entityName, List<Long> selectTreeNode) {
        if ("bcm_icmembertree".equals(entityName)) {
            Object[] primaryKeyValues;
            BillList billlistap = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
            for (Object o : primaryKeyValues = selectedRows.getPrimaryKeyValues()) {
                selectTreeNode.add(LongUtil.toLong((Object)o));
            }
        } else {
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(tree_entryentity);
            int[] selectRows = treeEntryGrid.getSelectRows();
            if (selectRows.length > 0) {
                for (int i : selectRows) {
                    DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(tree_entryentity, i);
                    long id = entryRowEntity.getLong("id");
                    selectTreeNode.add(id);
                }
            } else {
                List<DynamicObject> members = this.getAllMembersOfCsl(modelId);
                for (DynamicObject dynamicObject : members) {
                    selectTreeNode.add(dynamicObject.getLong("id"));
                }
                QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
                qf.and(new QFilter("number", "=", (Object)SysDimensionEnum.Entity.getNumber()));
                DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id", (QFilter[])qf.toArray());
                selectTreeNode.add(dy.getLong("id"));
            }
        }
    }

    private List<DynamicObject> getAllMembersOfCsl(long modelId) {
        DynamicObject dyCslScheme = (DynamicObject)this.getModel().getValue(CSLSCHEME_F7);
        DynamicObject dyYear = (DynamicObject)this.getModel().getValue(YEAR_F7);
        DynamicObject dyPeriod = (DynamicObject)this.getModel().getValue(PERIOD_F7);
        DynamicObject dyScene = (DynamicObject)this.getModel().getValue(SCENARIO_F7);
        if (!this.isRPT() && dyCslScheme == null || dyYear == null || dyPeriod == null || dyScene == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u9875\u9762\u53c2\u6570\uff0c\u5fc5\u5f55\u9879\u4e0d\u80fd\u4e3a\u7a7a", (String)"DimensionOrgView_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
        if (this.isRPT()) {
            qf.and(new QFilter(CSLSCHEME_F7, "=", (Object)CslSchemeServiceHelper.getRptDefaultSchemeId((long)modelId)).or("number", "=", (Object)DimTypesEnum.ENTITY.getNumber()));
        } else {
            qf.and(CSLSCHEME_F7, "=", (Object)dyCslScheme.getLong("id"));
        }
        DynamicObjectCollection members = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)this.getSelector(), (QFilter[])qf.toArray(), (String)"level, dseq");
        if (members.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6210\u5458", (String)"DimensionOrgView_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return members;
        }
        FilterOrgStructParam param = new FilterOrgStructParam(this.getModelId(), dyScene.getLong("id"), dyYear.getString("number"), dyPeriod.getLong("id"));
        if ((members = EntityVersioningUtil.filterOrgsByVersion((DynamicObjectCollection)members, (FilterOrgStructParam)param)).size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6210\u5458", (String)"DimensionOrgView_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return members;
        }
        return members;
    }

    private void dimensionMemberSearchAndUpdateShowView(String searchContent, int searchType) {
        String setResult;
        Long modelId = LongUtil.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"));
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4f53\u7cfb\u3002", (String)"DimensionDisplayList_129", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)DimTypesEnum.ENTITY.getNumber());
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and(new QFilter("dimension", "=", (Object)dimensionId));
        String searchText = this.getPageCache().get("searchText");
        String searchKey = this.getModelId() + searchText + dimensionId;
        if (this.isRPT()) {
            filter.and(new QFilter(CSLSCHEME_F7, "=", (Object)CslSchemeServiceHelper.getRptDefaultSchemeId((long)modelId)).or("number", "=", (Object)DimTypesEnum.ENTITY.getNumber()));
        } else {
            DynamicObject cslData = (DynamicObject)this.getModel().getValue(CSLSCHEME_F7);
            Long cslId = cslData.getLong("id");
            Long parentId = cslData.getLong("parent.id");
            searchKey = searchKey + cslId;
            if (parentId != null && parentId != 0L) {
                filter.and(CSLSCHEME_F7, "=", (Object)cslId);
            }
        }
        filter.and("status", "!=", (Object)"A");
        String selectMemberFields = this.getSelector();
        DynamicObjectCollection members = this.getAllMembersByCache(modelId, "bcm_entitymembertree", selectMemberFields, filter.toArray());
        this.setNameOfRootAndRateOrg((List<DynamicObject>)members);
        FilterOrgStructParam param = new FilterOrgStructParam(this.getModelId(), ((DynamicObject)this.getValue(SCENARIO_F7)).getLong("id"), ((DynamicObject)this.getValue(YEAR_F7)).getString("number"), ((DynamicObject)this.getValue(PERIOD_F7)).getLong("id"));
        EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)param, (List)members);
        if (members.size() < 1) {
            return;
        }
        List<String> properties = this.getProperties();
        SearchCacheManager searchCacheManager = new SearchCacheManager();
        Cache<String, DimensionMemberSearch> dimensionMemberSearchLoadingCache = searchCacheManager.getDimensionMemberSearch();
        DimensionMemberSearch dimensionMemberSearch = null;
        try {
            dimensionMemberSearch = (DimensionMemberSearch)dimensionMemberSearchLoadingCache.get((Object)searchKey, () -> this.createDimensionMemberSearch((DynamicObject[])members.toArray((Object[])new DynamicObject[0]), properties, searchContent, this.getView().getFormShowParameter().getFormId()));
        }
        catch (Exception e) {
            log.error("dimension search error." + ThrowableHelper.toString((Exception)e));
            throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)e.getMessage()), new Object[]{e.getMessage()});
        }
        if (dimensionMemberSearch == null) {
            return;
        }
        if ("true".equals(this.getPageCache().get("dimensionChange"))) {
            dimensionMemberSearch.reSetFindListIndex();
        }
        if (StringUtils.isNotEmpty((String)(setResult = dimensionMemberSearch.setSearchAtFindListIndex(searchType)))) {
            this.getView().showTipNotification(setResult);
            return;
        }
        int focusRowIndex = dimensionMemberSearch.doSearch((AbstractFormDataModel)this.getModel(), properties, tree_entryentity);
        if (focusRowIndex < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"DimensionDisplayList_131", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        dimensionMemberSearch.expandSearchedMemberRow((AbstractFormPlugin)this, this.getModel(), tree_entryentity, focusRowIndex);
        this.getPageCache().put("dimensionChange", "false");
    }

    private DynamicObjectCollection getAllMembersByCache(Long modelId, String entityName, String fields, QFilter[] filters) {
        String key = "orgView_memberSearch_" + entityName + "_" + modelId;
        return (DynamicObjectCollection)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)key, () -> QueryServiceHelper.query((String)entityName, (String)fields, (QFilter[])filters));
    }

    private List<String> getProperties() {
        String appId = this.getView().getFormShowParameter().getAppId();
        List<String> fields = Arrays.asList("number", "name", "storagetype", "currency", "ctrlorg", "isinnerorg", "bizchangetype");
        DimShowPropertyEnum dimEnum = DimShowPropertyEnum.getEnumBySign((String)"bcm_entitymembertree", (String)appId);
        List<String> properties = Arrays.asList(dimEnum.getShowlist()).stream().filter(x -> fields.contains(x)).collect(Collectors.toList());
        properties.add("longnumber");
        return properties;
    }

    private DimensionMemberSearch createDimensionMemberSearch(DynamicObject[] dimensionMembers, List<String> entryFields, String searchText, String formId) {
        return new DimensionMemberSearch(dimensionMembers, entryFields, searchText, formId);
    }

    private String validate() {
        BillList billList;
        DynamicObjectCollection datas;
        String cslscheme;
        String entityName = this.getPageCache().get(SELECTED_DIM_SIGN);
        String msg = this.checkFilterDim(entityName);
        if (StringUtils.isNotEmpty((String)msg)) {
            return msg;
        }
        boolean isOrgDim = "bcm_entitymembertree".equals(entityName);
        if (this.isCM() && isOrgDim && "DefaultRateScheme".equals(cslscheme = ((DynamicObject)this.getModel().getValue(CSLSCHEME_F7)).getString("number"))) {
            return ResManager.loadKDString((String)"\u6c47\u7387\u7ec4\u7ec7\u89c6\u56fe\u4e0d\u652f\u6301\u5bfc\u51fa\u3002", (String)"DimensionOrgView_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (isOrgDim ? (datas = this.getModel().getEntryEntity(tree_entryentity)) == null || datas.size() == 0 : (billList = (BillList)this.getControl(BILLLISTAP)).getCurrentListAllRowCollection().size() == 0) {
            return ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e", (String)"DimensionOrgView_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private void setNameOfRootAndRateOrg(List<DynamicObject> dys) {
        long modelId = this.getModelId();
        for (DynamicObject dy : dys) {
            IDNumberTreeNode memberTree;
            if (!StringUtils.isEmpty((String)dy.getString("name")) || IDNumberTreeNode.NotFoundTreeNode == (memberTree = MemberReader.findMemberById((long)modelId, (String)"bcm_entitymembertree", (Long)dy.getLong("id")))) continue;
            dy.set("name", (Object)memberTree.getName());
        }
        this.getView().updateView(tree_entryentity);
    }

    private String getMsgByApi() {
        if (this.isRPT()) {
            return ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u60c5\u666f\u3001\u8d22\u5e74\u6216\u671f\u95f4\u662f\u5426\u6709\u503c\u3002", (String)"DimensionDisplayList_220", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u89c6\u56fe\u3001\u60c5\u666f\u3001\u8d22\u5e74\u6216\u671f\u95f4\u662f\u5426\u6709\u503c\u3002", (String)"DimensionDisplayList_210", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private void dimTreeNodeClick(TreeView tree) {
        TreeView.TreeState state = tree.getTreeState();
        if (state.getFocusNode() != null) {
            String dimensionKeyID = state.getFocusNode().get("id").toString();
            DynamicObject dimension = MemberReader.getDimensionDynById((long)LongUtil.toLong((Object)dimensionKeyID));
            String dimensionNumber = dimension.getString("membermodel");
            this.getPageCache().put(SELECTED_DIM_ID, dimension.getString("id"));
            this.getPageCache().put(SELECTED_DIM_SIGN, dimensionNumber);
            if ("bcm_icmembertree".equals(dimensionNumber)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_PANEL_AP5, CSLSCHEME_F7});
                this.getView().setVisible(Boolean.TRUE, new String[]{SPLIT_CONTAINER_AP_IC});
                this.getView().setEnable(Boolean.FALSE, new String[]{FLEX_PANEL_AP2});
                this.buildIcDimEffMembers();
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{SPLIT_CONTAINER_AP_IC});
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_PANEL_AP5, CSLSCHEME_F7});
                this.getView().setEnable(Boolean.TRUE, new String[]{FLEX_PANEL_AP2});
                this.buildTreeByCslschemeId();
            }
            String msg = this.checkFilterDim(dimensionNumber);
            if (StringUtils.isNotEmpty((String)msg)) {
                return;
            }
        }
    }

    private void buildIcDimEffMembers() {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("model", "=", (Object)this.getModelId()));
        long dimId = LongUtil.toLong((Object)this.getPageCache().get(SELECTED_DIM_ID));
        qfBuilder.add(new QFilter("dimension", "=", (Object)dimId));
        qfBuilder.add(new QFilter("isleaf", "=", (Object)"0")).or(new QFilter("number", "in", (Object)new String[]{"ICOEntity", "ICEntity", "ICNone"}));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_icmembertree", (String)"id,name,number,parent,isleaf,storagetype,level,dseq", (QFilter[])qfBuilder.toArray(), (String)"level,dseq");
        ICEntityTreeNode root = ICEntityTreeBuilder.getICEntityTreeNode(doc);
        if (root != null) {
            TreeView tree = (TreeView)this.getControl(TREE_LEFT);
            tree.deleteAllNodes();
            this.buildLeftTree(root);
        }
    }

    private void buildLeftTree(AbstractTreeNode<Object> root) {
        TreeView tree = (TreeView)this.getControl(TREE_LEFT);
        if (root != null) {
            TreeModel treeModel = new TreeModel(root);
            TreeNode nodeRoot = treeModel.buildEntryTree(tree);
            nodeRoot.iterate(0, v -> v.setIsOpened(true));
            if (root.getChildren() == null) {
                return;
            }
            String focusNodeId = this.getPageCache().get(SELECTED_IC_GROUP);
            if (StringUtils.isEmpty((String)focusNodeId) || nodeRoot.getTreeNode(focusNodeId, 999) == null) {
                focusNodeId = root.getId();
                this.getPageCache().put(SELECTED_IC_GROUP, focusNodeId);
            }
            TreeNode node = nodeRoot.getTreeNode(focusNodeId, 999);
            tree.focusNode(node);
            this.treeRefresh();
        }
    }

    protected void initDimensionTree() {
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        String selectFields = "id,name,number,shortnumber,membermodel,issysdimension,dseq";
        QFilter qf = new QFilter("model", "=", (Object)ConvertUtil.convertStrToLong((String)modelId));
        qf.and("number", "in", Arrays.asList(SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.InternalCompany.getNumber()));
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])qf.toArray(), (String)"dseq");
        if (dcs != null && dcs.size() > 0) {
            TreeView tree = (TreeView)this.getView().getControl(treeview_ap);
            TreeNode root = new TreeNode();
            root.setId("root");
            HashSet hideDim = new HashSet();
            String sign = ModelUtil.queryApp((IFormView)this.getView()).toString();
            if (sign == null) {
                sign = ApplicationTypeEnum.RPT.toString();
            }
            if (ApplicationTypeEnum.RPT.toString().equals(sign)) {
                hideDim = Sets.newHashSet((Object[])new String[]{DimTypesEnum.PROCESS.getNumber(), DimTypesEnum.AUDITTRIAL.getNumber()});
            }
            for (DynamicObject task : dcs) {
                if (hideDim.contains(task.getString("number"))) continue;
                TreeNode dimensionNode = new TreeNode();
                dimensionNode.setId(task.getString("id"));
                dimensionNode.setText(String.format("%s(%s)", task.getString("name"), task.getString("shortnumber")));
                dimensionNode.setData((Object)task);
                root.addChild(dimensionNode);
            }
            tree.deleteAllNodes();
            tree.addNode(root);
            tree.expand("root");
            tree.focusNode((TreeNode)root.getChildren().get(0));
            String id = ((TreeNode)root.getChildren().get(0)).getId();
            this.getPageCache().put(SELECTED_DIM_ID, id);
            this.getPageCache().put(SELECTED_DIM_SIGN, dcs.stream().filter(x -> id.equals(x.getString("id"))).findFirst().get().getString("membermodel"));
        }
    }

    private String checkFilterDim(String entityName) {
        DynamicObject dyYear = (DynamicObject)this.getModel().getValue(YEAR_F7);
        DynamicObject dyPeriod = (DynamicObject)this.getModel().getValue(PERIOD_F7);
        DynamicObject dyScene = (DynamicObject)this.getModel().getValue(SCENARIO_F7);
        DynamicObject dyCslScheme = null;
        if ("bcm_entitymembertree".equals(entityName)) {
            dyCslScheme = (DynamicObject)this.getModel().getValue(CSLSCHEME_F7);
        }
        if (!this.isRPT() && "bcm_entitymembertree".equals(entityName) && dyCslScheme == null || dyYear == null || dyPeriod == null || dyScene == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"DimensionOrgView_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private QFilter getFilters() {
        String focusNodeId = this.getPageCache().get(SELECTED_IC_GROUP);
        long modelId = this.getModelId();
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        if (StringUtils.isNotEmpty((String)focusNodeId)) {
            String longNumber = MemberReader.findMemberById((long)modelId, (String)"bcm_icmembertree", (Long)Long.parseLong(focusNodeId)).getLongNumber();
            MembRangeItem membRangeItem = new MembRangeItem("bcm_icmembertree", Long.valueOf(Long.parseLong(focusNodeId)), longNumber, RangeEnum.VALUE_50, false, (Object)modelId);
            DynamicObject dyScene = (DynamicObject)this.getModel().getValue(SCENARIO_F7);
            DynamicObject dyYear = (DynamicObject)this.getModel().getValue(YEAR_F7);
            DynamicObject dyPeriod = (DynamicObject)this.getModel().getValue(PERIOD_F7);
            if (dyScene == null || dyYear == null || dyPeriod == null) {
                qFilter.and("1", "=", (Object)0);
            } else {
                VersionParam vp = new VersionParam(modelId, dyScene.getLong("id"), dyYear.getLong("id"), dyPeriod.getLong("id"));
                qFilter.and(membRangeItem.buildFilterByScope4Ic(vp));
            }
        }
        return qFilter;
    }

    private void nodeClick(TreeView tree) {
        TreeView.TreeState state = tree.getTreeState();
        if (state.getFocusNode() != null) {
            String focusNodeId = (String)state.getFocusNode().get("id");
            this.getPageCache().put(SELECTED_IC_GROUP, focusNodeId);
        }
        this.treeRefresh();
    }

    private void treeRefresh() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.setClearSelection(true);
        billList.refresh();
    }
}

