/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.dimension.vo.ReportQuote;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;

public class DimensionQuoteReportPlugin
extends AbstractBaseFormPlugin {
    private static final String SPREAD_KEY = "spreadap";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildSpreadData();
    }

    public String getSpreadKey() {
        return SPREAD_KEY;
    }

    protected void buildSpreadData() {
        this.deleteFirstSheet();
        LinkedHashMap<String, String> currentMap = new LinkedHashMap<String, String>(16);
        LinkedHashMap<String, Map<String, List<Map<String, String>>>> reportMap = new LinkedHashMap<String, Map<String, List<Map<String, String>>>>(16);
        ReportQuote.getInstance().getReportItem().forEach((k, v) -> {
            if (this.getView().getFormShowParameter().getCustomParam(k) != null) {
                currentMap.put((String)k, (String)v);
                Map map = (Map)this.getView().getFormShowParameter().getCustomParam(k);
                reportMap.put((String)k, map);
            }
        });
        this.addSheets(currentMap);
        this.updateSheetsTitleAndStyle(currentMap);
        this.fillReport(currentMap, reportMap);
    }

    private void fillReport(Map<String, String> currentMap, Map<String, Map<String, List<Map<String, String>>>> reportMap) {
        int index = 0;
        for (Map.Entry<String, String> entry : currentMap.entrySet()) {
            int cur = 0;
            ArrayList<Map<String, Object>> cells = new ArrayList<Map<String, Object>>();
            for (String key : reportMap.get(entry.getKey()).keySet()) {
                int col = 0;
                switch (key) {
                    case "col": 
                    case "row": {
                        col = 6;
                        break;
                    }
                    case "filter": {
                        col = 5;
                        break;
                    }
                    case "page": {
                        col = 4;
                        break;
                    }
                    case "view": {
                        col = 3;
                        break;
                    }
                }
                for (int j = 0; j < reportMap.get(entry.getKey()).get(key).size(); ++j) {
                    Map<String, String> report = reportMap.get(entry.getKey()).get(key).get(j);
                    cells.addAll(this.setCellCol(report, entry.getKey(), cur + 1, col));
                    ++cur;
                }
            }
            if (cells.size() > 199) {
                SpreadClientInvoker.appendRows(this.getClientViewProxy(), SPREAD_KEY, index, cells.size() - 199);
            }
            SpreadClientInvoker.updateSheetValue(this.getClientViewProxy(), SPREAD_KEY, index, cells);
            ++index;
        }
    }

    private List<Map<String, Object>> setCellCol(Map<String, String> report, String type, int row, int choose) {
        ArrayList<Map<String, Object>> cells = new ArrayList<Map<String, Object>>();
        if ("reportTemplate".equals(type)) {
            this.setTemplateCells(report, type, row, choose, cells);
        } else if ("bizRule".equals(type)) {
            this.setBizRuleCells(report, type, row, cells);
        } else if ("convertDiff".equals(type)) {
            this.setConvertDiffCells(report, type, row, cells);
        } else if ("convertSetting".equals(type)) {
            this.setConvertSettingCells(report, type, row, cells);
        }
        return cells;
    }

    private void setConvertSettingCells(Map<String, String> report, String type, int row, List<Map<String, Object>> cells) {
        IntStream.range(0, ReportQuote.getInstance().getReportMap().get(type).size()).forEach(index -> {
            HashMap<String, Integer> cell = new HashMap<String, Integer>(4);
            cell.put(SpreadProperties.UpdataValueMethod.R.k(), row);
            cell.put(SpreadProperties.UpdataValueMethod.C.k(), index);
            switch (index) {
                case 0: {
                    cell.put(SpreadProperties.UpdataValueMethod.V.k(), row);
                    break;
                }
                case 1: {
                    cell.put(SpreadProperties.UpdataValueMethod.V.k(), (Integer)report.get("specialName"));
                    break;
                }
                case 2: {
                    cell.put(SpreadProperties.UpdataValueMethod.V.k(), (Integer)report.get("formulaName"));
                }
            }
            cells.add(cell);
        });
    }

    private void setConvertDiffCells(Map<String, String> report, String type, int row, List<Map<String, Object>> cells) {
        IntStream.range(0, ReportQuote.getInstance().getReportMap().get(type).size()).forEach(index -> {
            HashMap<String, Integer> cell = new HashMap<String, Integer>(4);
            cell.put(SpreadProperties.UpdataValueMethod.R.k(), row);
            cell.put(SpreadProperties.UpdataValueMethod.C.k(), index);
            switch (index) {
                case 0: {
                    cell.put(SpreadProperties.UpdataValueMethod.V.k(), row);
                    break;
                }
                case 1: {
                    cell.put(SpreadProperties.UpdataValueMethod.V.k(), (Integer)report.get("number"));
                    break;
                }
                case 2: {
                    cell.put(SpreadProperties.UpdataValueMethod.V.k(), (Integer)report.get("name"));
                    break;
                }
                case 3: {
                    cell.put(SpreadProperties.UpdataValueMethod.V.k(), (Integer)report.get("dimensionName"));
                    break;
                }
                case 4: {
                    cell.put(SpreadProperties.UpdataValueMethod.V.k(), (Integer)report.get("formular"));
                    break;
                }
            }
            cells.add(cell);
        });
    }

    private void setBizRuleCells(Map<String, String> report, String type, int row, List<Map<String, Object>> cells) {
        IntStream.range(0, ReportQuote.getInstance().getReportMap().get(type).size()).forEach(index -> {
            HashMap<String, Integer> cell = new HashMap<String, Integer>(4);
            cell.put(SpreadProperties.UpdataValueMethod.R.k(), row);
            cell.put(SpreadProperties.UpdataValueMethod.C.k(), index);
            switch (index) {
                case 0: {
                    cell.put(SpreadProperties.UpdataValueMethod.V.k(), row);
                    break;
                }
                case 1: {
                    cell.put(SpreadProperties.UpdataValueMethod.V.k(), (Integer)report.get("memberName"));
                    break;
                }
                case 2: {
                    cell.put(SpreadProperties.UpdataValueMethod.V.k(), (Integer)report.get("ruleNumber"));
                    break;
                }
                case 3: {
                    cell.put(SpreadProperties.UpdataValueMethod.V.k(), (Integer)report.get("ruleName"));
                    break;
                }
                case 4: {
                    cell.put(SpreadProperties.UpdataValueMethod.V.k(), (Integer)report.get("ruleRunStatus"));
                    break;
                }
                case 5: {
                    cell.put(SpreadProperties.UpdataValueMethod.V.k(), (Integer)report.get("ruleStatus"));
                    break;
                }
            }
            cells.add(cell);
        });
    }

    private void setTemplateCells(Map<String, String> report, String type, int row, int choose, List<Map<String, Object>> cells) {
        IntStream.range(0, ReportQuote.getInstance().getReportMap().get(type).size()).forEach(index -> {
            HashMap<String, Integer> cell = new HashMap<String, Integer>(4);
            cell.put(SpreadProperties.UpdataValueMethod.R.k(), row);
            cell.put(SpreadProperties.UpdataValueMethod.C.k(), index);
            switch (index) {
                case 0: {
                    cell.put(SpreadProperties.UpdataValueMethod.V.k(), row);
                    break;
                }
                case 1: {
                    cell.put(SpreadProperties.UpdataValueMethod.V.k(), (Integer)report.get("number"));
                    break;
                }
                case 2: {
                    cell.put(SpreadProperties.UpdataValueMethod.V.k(), (Integer)report.get("name"));
                    break;
                }
            }
            if (index == choose) {
                cell.put(SpreadProperties.UpdataValueMethod.V.k(), (Integer)report.get("dimension"));
            }
            if (cell.get(SpreadProperties.UpdataValueMethod.V.k()) != null) {
                cells.add(cell);
            }
        });
    }

    private void updateSheetsTitleAndStyle(Map<String, String> currentMap) {
        int index = 0;
        for (Map.Entry<String, String> entry : currentMap.entrySet()) {
            ArrayList cells = new ArrayList(16);
            List<String> titles = ReportQuote.getInstance().getReportMap().get(entry.getKey());
            for (int j = 0; j < titles.size(); ++j) {
                HashMap<String, Object> cell = new HashMap<String, Object>(4);
                cell.put(SpreadProperties.UpdataValueMethod.R.k(), 0);
                cell.put(SpreadProperties.UpdataValueMethod.C.k(), j);
                cell.put(SpreadProperties.UpdataValueMethod.V.k(), titles.get(j));
                cells.add(cell);
            }
            SpreadClientInvoker.updateSheetValue(this.getClientViewProxy(), SPREAD_KEY, index, cells);
            HashMap<String, Cloneable> backColor = new HashMap<String, Cloneable>(2);
            HashMap<String, Object> styleMap = new HashMap<String, Object>(2);
            ArrayList rangeList = new ArrayList();
            HashMap<String, Integer> rangeMap = new HashMap<String, Integer>(4);
            rangeMap.put("r", 0);
            rangeMap.put("c", 0);
            rangeMap.put("rc", 1);
            rangeMap.put("cc", titles.size());
            rangeList.add(rangeMap);
            styleMap.put("bkc", "#AAAAAA");
            styleMap.put("f", " 12pt Arial");
            HashMap<String, ArrayList> blStyle = new HashMap<String, ArrayList>(2);
            blStyle.put("blc", Lists.newArrayList((Object[])new String[]{"black"}));
            blStyle.put("bls", Lists.newArrayList((Object[])new String[]{"thin"}));
            styleMap.put("bl", blStyle);
            backColor.put("style", styleMap);
            backColor.put("range", rangeList);
            HashMap<String, Serializable> parameters = new HashMap<String, Serializable>(2);
            parameters.put("data", Lists.newArrayList((Object[])new Map[]{backColor}));
            parameters.put("si", Integer.valueOf(index));
            SpreadClientInvoker.invokeSetCellStyleMethod(this.getClientViewProxy(), SPREAD_KEY, parameters);
            ++index;
        }
    }

    private void addSheets(Map<String, String> currentMap) {
        ArrayList result = new ArrayList();
        currentMap.forEach((key, value) -> this.addSheet(result, (String)value));
        SpreadClientInvoker.invokeAddSheets(this.getClientViewProxy(), SPREAD_KEY, result);
    }

    private List<Map<String, Object>> addSheet(List<Map<String, Object>> result, String sheetName) {
        int index = result.size() + 1;
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("index", index);
        map.put("name", sheetName);
        result.add(map);
        return result;
    }

    private void deleteFirstSheet() {
        ArrayList<Integer> index = new ArrayList<Integer>();
        index.add(0);
        SpreadClientInvoker.invokeDeleteSheets(this.getClientViewProxy(), SPREAD_KEY, index);
    }
}

