/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.export.strategy.EnumNewExportStrategy;
import kd.fi.bcm.business.export.strategy.ExportExecuteStrategyContext;
import kd.fi.bcm.business.export.strategy.IExport;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.util.EnumUtils;
import kd.fi.bcm.formplugin.util.TreeEntryEntityUtil;

public class EnumDisplayList
extends AbstractBaseListPlugin
implements HyperLinkClickListener {
    private static final String TREE_VIEW_AP = "treeviewap";
    private static final String ENTRY_ENTITY = "treeentryentity";
    private static final String ITEM_ID = "enumitemId";
    private static final String SHOW_TYPE = "showtype";
    private static final String BILL_LIST = "billlistap";
    private static final String TABLE_TYPE = "tabletype";

    @Override
    public void initialize() {
        super.initialize();
        final TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        final IPageCache pageCache = this.getPageCache();
        tree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                TreeView.TreeState state = tree.getTreeState();
                if (state.getFocusNode() != null) {
                    String itemId = state.getFocusNode().get("id").toString();
                    pageCache.put(EnumDisplayList.ITEM_ID, itemId);
                    EnumDisplayList.this.refreshRightEntity();
                }
            }
        });
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(ENTRY_ENTITY);
        grid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners("btnedit", "btndel", "btnadd", "barlist", "bartree");
        BillList billlist = (BillList)this.getControl(BILL_LIST);
        billlist.setBillFormId("bcm_enumvalue_new");
        billlist.addSetFilterListener(event -> {
            QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
            filter.and(new QFilter("enumitemid", "=", (Object)LongUtil.toLong((Object)pageCache.get(ITEM_ID))));
            event.getQFilters().add(filter);
            event.setOrderBy("number");
        });
        billlist.addHyperClickListener(e -> {
            Long id = (Long)billlist.getFocusRowPkId();
            DynamicObject enumValue = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_enumvalue_new");
            this.openEnumValue(enumValue);
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        this.getModel().setValue("model", (Object)modelId);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"model"});
        this.initLeftTree();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BILL_LIST});
        this.getPageCache().put(TABLE_TYPE, "tree");
    }

    private void initLeftTree() {
        TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        tree.deleteAllNodes();
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_enumitem_new", (String)"id,number,name", (QFilter[])filter.toArray(), (String)"dseq");
        String showType = this.getPageCache().get(SHOW_TYPE);
        TreeNode root = new TreeNode();
        root.setId("root");
        for (DynamicObject obj : docs) {
            TreeNode node = new TreeNode();
            node.setId(obj.getString("id"));
            if ("2".equals(showType)) {
                node.setText(obj.getString("number") + " " + obj.getString("name"));
            } else {
                node.setText(obj.getString("name"));
            }
            node.setData((Object)obj);
            root.addChild(node);
        }
        tree.addNode(root);
        tree.expand("root");
        this.refreshRightEntity();
    }

    private void initRightTree(Long itemId) {
        if (itemId == null || itemId == 0L) {
            return;
        }
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and(new QFilter("enumitemid", "=", (Object)itemId));
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_enumvalue_new", (String)"id,number,enumvalue,parent,parent.number as pnumber,name,datatype,enumitemid,dseq,isleaf", (QFilter[])filter.toArray(), (String)"dseq");
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        if (docs.size() == 0) {
            return;
        }
        if (docs != null && docs.size() > 0) {
            TreeEntryEntityUtil.fillEnumValueEntity(this.getModel(), docs);
            this.getView().updateView();
            TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(ENTRY_ENTITY);
            treeEntry.setCollapse(false);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{ENTRY_ENTITY});
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        DynamicObject rowData = this.getModel().getEntryRowEntity(ENTRY_ENTITY, event.getRowIndex());
        this.openEnumValue(rowData);
    }

    private void openEnumValue(DynamicObject rowData) {
        String itemId = this.getPageCache().get(ITEM_ID);
        HashMap<String, String> openParameter = new HashMap<String, String>(16);
        openParameter.put("pkId", rowData.getString("id"));
        openParameter.put("formId", "bcm_enumvalue_new");
        FormShowParameter showParameter = BaseShowParameter.createFormShowParameter(openParameter);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "refreshEntry");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setCustomParam("enumitemKey", (Object)itemId);
        showParameter.setCaption(ResManager.loadKDString((String)"\u679a\u4e3e\u503c-\u7f16\u8f91", (String)"EnumList_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        this.getView().showForm(showParameter);
    }

    private void addEnumValue() {
        String itemId = this.getPageCache().get(ITEM_ID);
        if (org.apache.commons.lang.StringUtils.isEmpty((String)itemId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u679a\u4e3e\u9879\u3002", (String)"EnumList_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject enumItem = QueryServiceHelper.queryOne((String)"bcm_enumitem_new", (String)"name,datatype", (QFilter[])new QFilter("id", "=", (Object)LongUtil.toLong((Object)itemId)).toArray());
        BaseShowParameter parameter = new BaseShowParameter();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "refreshEntry");
        parameter.setCloseCallBack(closeCallBack);
        parameter.setFormId("bcm_enumvalue_new");
        parameter.setCustomParam("enumitemKey", (Object)itemId);
        parameter.setCustomParam("enumitemname", (Object)enumItem.getString("name"));
        parameter.setCustomParam("datatype", (Object)enumItem.getString("datatype"));
        parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCaption(ResManager.loadKDString((String)"\u679a\u4e3e\u503c-\u65b0\u589e", (String)"EnumList_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)parameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        tree.deleteAllNodes();
        this.initLeftTree();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String opName = operate.getOperateKey();
        if (!this.moveUpAndDown(opName)) {
            args.setCancel(true);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "baritemsearch": {
                this.refreshRightEntity();
                break;
            }
            case "baritemadd": {
                this.addEnumValue();
                break;
            }
            case "baritemdel": {
                List<Long> selectRows = this.getSelectMembers();
                String msg = this.checkEnums(selectRows);
                if (org.apache.commons.lang.StringUtils.isNotEmpty((String)msg)) {
                    this.getView().showTipNotification(msg);
                    return;
                }
                this.getPageCache().put("deleteRows", SerializationUtils.toJsonString(selectRows));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u5f53\u524d\u679a\u4e3e\u503c\u53ca\u5176\u6240\u6709\u4e0b\u7ea7\uff1f", (String)"EnumList_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("deleteenumvalue"));
                break;
            }
            case "resetseq": {
                long itemId = LongUtil.toLong((Object)this.getPageCache().get(ITEM_ID));
                this.resetSeqByNumber(itemId);
                break;
            }
            case "exportenum": {
                this.exportEnumNew();
                break;
            }
            case "importenum": {
                this.importEnumNew();
            }
        }
    }

    private String checkEnums(List<Long> selectRows) {
        if (selectRows.size() == 0) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u679a\u4e3e\u503c\u3002", (String)"EnumList_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        QFilter qf = new QFilter("id", "=", (Object)selectRows.get(0));
        DynamicObject ev = QueryServiceHelper.queryOne((String)"bcm_enumvalue_new", (String)"id,dimension,issysenumvalue,enumitemid", (QFilter[])qf.toArray());
        if (ev == null) {
            return ResManager.loadKDString((String)"\u8981\u5220\u9664\u7684\u679a\u4e3e\u503c\u4e0d\u5b58\u5728\u3002", (String)"EnumList_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        QFilter qfei = new QFilter("id", "=", (Object)ev.getLong("enumitemid"));
        DynamicObject enumitem = QueryServiceHelper.queryOne((String)"bcm_enumitem_new", (String)"name", (QFilter[])qfei.toArray());
        String localeValue = ResManager.getLocaleString((String)"\u4e1a\u52a1\u7c7b\u578b", (String)"ExtDimEditPlugin_8", (String)"fi-bcm-formplugin").getLocaleValue();
        if (!enumitem.getString("name").equals(localeValue) && 1 == ev.getInt("issysenumvalue")) {
            return ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u9884\u7f6e\u679a\u4e3e\u503c\u4e0d\u80fd\u5220\u9664\u3002", (String)"EnumItemEdit_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private void importEnumNew() {
        String enumItemId = this.getPageCache().get(ITEM_ID);
        if (org.apache.commons.lang.StringUtils.isEmpty((String)enumItemId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u679a\u4e3e\u9879", (String)"EnumList_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qf = new QFilter("id", "=", (Object)Long.parseLong(enumItemId));
        DynamicObject enumItemDy = QueryServiceHelper.queryOne((String)"bcm_enumitem_new", (String)"number", (QFilter[])qf.toArray());
        if (enumItemDy == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u679a\u4e3e\u9879\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"EnumList_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (org.apache.commons.lang.StringUtils.isEmpty((String)enumItemDy.getString("number"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u679a\u4e3e\u9879\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u679a\u4e3e\u9879\u7f16\u7801", (String)"EnumList_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.invokeOperation();
    }

    private void invokeOperation() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bcm_batch_bos_importstart");
        HashMap parameter = new HashMap();
        ArrayList plugins = new ArrayList();
        LinkedHashMap<String, Object> plugin = new LinkedHashMap<String, Object>();
        plugin.put("_Type_", "Plugin");
        plugin.put("ClassName", "kd.fi.bcm.formplugin.dimension.batchimp.enums.DimensionEnumNewImport");
        plugin.put("Enabled", true);
        plugin.put("modelid", this.getModelId());
        plugins.add(plugin);
        parameter.put("plugins", plugins);
        showParameter.setCustomParams(parameter);
        showParameter.setCustomParam("BillFormId", (Object)"bcm_enum_new_import");
        showParameter.setCustomParam("ListName", (Object)ResManager.loadKDString((String)"\u679a\u4e3e-\u5217\u8868", (String)"EnumList_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        showParameter.setCustomParam("ServiceAppId", (Object)this.getBizAppId());
        showParameter.setCustomParam("modelid", (Object)this.getModelId());
        showParameter.setCustomParam(ITEM_ID, (Object)this.getPageCache().get(ITEM_ID));
        showParameter.setCustomParam("reporttype", (Object)ApplicationTypeEnum.getApplication((String)this.getBizAppId()).getOIndex());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "import_close_new"));
        this.getView().showForm(showParameter);
    }

    private void exportEnumNew() {
        List<Object> pkIds = EnumUtils.getPreTemplateOfEnum("bcm_enum_new_import_IMPT_S");
        if (pkIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u201c\u5e94\u7528-\u5f15\u5165\u5f15\u51fa\u201d\u9884\u5236\u5bfc\u51fa\u6a21\u677f\u3002", (String)"EnumList_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String enumItemId = this.getPageCache().get(ITEM_ID);
        if (org.apache.commons.lang.StringUtils.isEmpty((String)enumItemId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u679a\u4e3e\u9879", (String)"EnumList_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Long> ids = this.getAllSelectedRows();
        FormView view = (FormView)this.getView();
        String appId = view.getFormShowParameter().getServiceAppId();
        HashMap<String, Object> exportDataParms = new HashMap<String, Object>(16);
        exportDataParms.put("modelId", this.getModelId());
        exportDataParms.put("selectData", ids);
        ExportExecuteStrategyContext exportExecuteStrategyContext = new ExportExecuteStrategyContext();
        exportExecuteStrategyContext.setExport((IExport)new EnumNewExportStrategy());
        OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u679a\u4e3e-\u5bfc\u51fa", "EnumList_37", "fi-bcm-formplugin", "enumExport");
        try {
            String url = exportExecuteStrategyContext.export(appId, ((Long)pkIds.get(0)).longValue(), "bcm_enum_new_import", "bcm_enum_new_import", exportDataParms);
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                this.downloadFile(url, "bcm_dimensionmanager", "3JMWB9DDZVHD");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u5bfc\u51fa\u5931\u8d25\u3002", "EnumList_38", "fi-bcm-formplugin", null);
            this.writeMultiLangLog(opName, opDes);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[]{e.getMessage()});
        }
        OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u5bfc\u51fa\u6210\u529f\u3002", "EnumList_39", "fi-bcm-formplugin", null);
        this.writeMultiLangLog(opName, opDes);
    }

    private List<Long> getAllSelectedRows() {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = treeEntryGrid.getSelectRows();
        IDataModel model = this.getModel();
        if (selectRows.length > 0) {
            return Arrays.stream(selectRows).filter(index -> model.getEntryRowEntity(ENTRY_ENTITY, index) != null).mapToLong(index -> model.getEntryRowEntity(ENTRY_ENTITY, index).getLong("id")).boxed().collect(Collectors.toList());
        }
        return model.getEntryEntity(ENTRY_ENTITY).stream().mapToLong(dy -> dy.getLong("id")).boxed().collect(Collectors.toList());
    }

    private List<Long> getSelectMembers() {
        String type = this.getPageCache().get(TABLE_TYPE);
        if ("list".equals(type)) {
            BillList billList = (BillList)this.getControl(BILL_LIST);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                return new ArrayList<Long>(10);
            }
            return selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
        }
        IDataModel model = this.getModel();
        TreeEntryGrid control = (TreeEntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = control.getSelectRows();
        if (selectRows == null || selectRows.length == 0 || control.getEntryData().getEndIndex() == 0) {
            return new ArrayList<Long>(10);
        }
        return Arrays.stream(selectRows).filter(f -> model.getEntryRowEntity(ENTRY_ENTITY, f) != null).mapToLong(index -> model.getEntryRowEntity(ENTRY_ENTITY, index).getLong("id")).boxed().collect(Collectors.toList());
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Button) {
            String key = ((Control)evt.getSource()).getKey();
            if ("btnadd".equals(key)) {
                BaseShowParameter showParameter = new BaseShowParameter();
                showParameter.setFormId("bcm_enumitem_new");
                showParameter.setCustomParam("dimensionID", this.getView().getFormShowParameter().getCustomParams().get("dimensionID"));
                showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
                showParameter.setStatus(OperationStatus.ADDNEW);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCaption(ResManager.loadKDString((String)"\u679a\u4e3e\u9879-\u65b0\u589e", (String)"EnumList_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "research");
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)showParameter);
            } else if ("btndel".equals(key)) {
                long enumItemId = LongUtil.toLong((Object)this.getPageCache().get(ITEM_ID));
                if (enumItemId == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u679a\u4e3e\u9879\u3002", (String)"EnumList_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                QFilter filter = new QFilter("id", "=", (Object)enumItemId);
                DynamicObject obj = QueryServiceHelper.queryOne((String)"bcm_enumitem_new", (String)"id,issysenumitem", (QFilter[])filter.toArray());
                if (obj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8981\u5220\u9664\u7684\u679a\u4e3e\u9879\u4e0d\u5b58\u5728\u3002", (String)"EnumList_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (1 == obj.getInt("issysenumitem")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u679a\u4e3e\u9879\u4e0d\u80fd\u5220\u9664\u3002", (String)"EnumList_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (QueryServiceHelper.exists((String)"bcm_enumvalue_new", (QFilter[])new QFilter("enumitemid", "=", (Object)enumItemId).toArray())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u679a\u4e3e\u9879\u4e2d\u5b58\u5728\u679a\u4e3e\u503c\uff0c\u5220\u9664\u5931\u8d25\u3002", (String)"EnumList_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                String msg = this.checkDimMemberRefer(this.getModelId(), enumItemId);
                if (org.apache.commons.lang.StringUtils.isNotEmpty((String)msg)) {
                    this.getView().showTipNotification(msg);
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u679a\u4e3e\u9879\uff1f", (String)"EnumList_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("deleteenumitem"));
            } else if ("btnedit".equals(key)) {
                String enumItemId = this.getPageCache().get(ITEM_ID);
                if (org.apache.commons.lang.StringUtils.isEmpty((String)enumItemId) || "0".equals(enumItemId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u4fee\u6539\u7684\u679a\u4e3e\u9879\u3002", (String)"EnumList_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, String> openParameter = new HashMap<String, String>(16);
                openParameter.put("pkId", enumItemId);
                openParameter.put("formId", "bcm_enumitem_new");
                FormShowParameter showParameter = BaseShowParameter.createFormShowParameter(openParameter);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "editresearch");
                showParameter.setCloseCallBack(closeCallBack);
                showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
                showParameter.setCustomParam("enumitemKeyID", (Object)enumItemId);
                showParameter.setCustomParam("dimensionID", this.getView().getFormShowParameter().getCustomParams().get("dimensionID"));
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.setCaption(ResManager.loadKDString((String)"\u679a\u4e3e-\u7f16\u8f91", (String)"EnumList_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
            } else if ("barlist".equals(key)) {
                this.getPageCache().put(TABLE_TYPE, "list");
                this.refreshRightEntity();
            } else if ("bartree".equals(key)) {
                this.getPageCache().put(TABLE_TYPE, "tree");
                this.refreshRightEntity();
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (SHOW_TYPE.equals(propertyName)) {
            String showType = this.getModel().getValue(SHOW_TYPE).toString();
            this.getPageCache().put(SHOW_TYPE, showType);
            this.initLeftTree();
        } else if ("model".equals(propertyName) && e.getChangeSet()[0].getNewValue() != null) {
            this.initLeftTree();
            this.refreshRightEntity();
        }
    }

    private String checkDimMemberRefer(Long modelId, Long enumItemId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("enumitem", "=", (Object)enumItemId);
        DynamicObjectCollection accountDys = QueryServiceHelper.query((String)"bcm_accountmembertree", (String)"number", (QFilter[])qFilter.toArray());
        if (accountDys.size() > 0) {
            String numbers = String.join((CharSequence)",", accountDys.stream().map(x -> x.getString("number")).collect(Collectors.toList()));
            return String.format(ResManager.loadKDString((String)"\u8be5\u679a\u4e3e\u5df2\u88ab\u79d1\u76ee\u6210\u5458\u201c%s\u201d\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"EnumList_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]), numbers);
        }
        DynamicObjectCollection sceneDys = QueryServiceHelper.query((String)"bcm_scenemembertree", (String)"number", (QFilter[])qFilter.toArray());
        if (sceneDys.size() > 0) {
            String numbers = String.join((CharSequence)",", sceneDys.stream().map(x -> x.getString("number")).collect(Collectors.toList()));
            return String.format(ResManager.loadKDString((String)"\u8be5\u679a\u4e3e\u5df2\u88ab\u60c5\u666f\u6210\u5458\u201c%s\u201d\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"EnumList_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]), numbers);
        }
        DynamicObjectCollection ctDys = QueryServiceHelper.query((String)"bcm_changetypemembertree", (String)"number", (QFilter[])qFilter.toArray());
        if (ctDys.size() > 0) {
            String numbers = String.join((CharSequence)",", ctDys.stream().map(x -> x.getString("number")).collect(Collectors.toList()));
            return String.format(ResManager.loadKDString((String)"\u8be5\u679a\u4e3e\u5df2\u88ab\u53d8\u52a8\u7c7b\u578b\u6210\u5458\u201c%s\u201d\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"EnumList_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]), numbers);
        }
        DynamicObjectCollection udeDys = QueryServiceHelper.query((String)"bcm_userdefinedmembertree", (String)"number", (QFilter[])qFilter.toArray());
        if (udeDys.size() > 0) {
            String numbers = String.join((CharSequence)",", udeDys.stream().map(x -> x.getString("number")).collect(Collectors.toList()));
            return String.format(ResManager.loadKDString((String)"\u8be5\u679a\u4e3e\u5df2\u88ab\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u6210\u5458\u201c%s\u201d\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"EnumList_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]), numbers);
        }
        DynamicObjectCollection extDys = QueryServiceHelper.query((String)"bcm_structofextend", (String)"number", (QFilter[])qFilter.toArray());
        if (extDys.size() > 0) {
            String numbers = String.join((CharSequence)",", extDys.stream().map(x -> x.getString("number")).collect(Collectors.toList()));
            return String.format(ResManager.loadKDString((String)"\u8be5\u679a\u4e3e\u5df2\u88ab\u62d3\u5c55\u7ef4\u6210\u5458\u201c%s\u201d\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"EnumList_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]), numbers);
        }
        return "";
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            return;
        }
        if ("deleteenumitem".equals(callBackId)) {
            long enumItemId = LongUtil.toLong((Object)this.getPageCache().get(ITEM_ID));
            QFilter[] filters = new QFilter("id", "=", (Object)enumItemId).toArray();
            DynamicObject enumItem = QueryServiceHelper.queryOne((String)"bcm_enumitem_new", (String)"name", (QFilter[])filters);
            DeleteServiceHelper.delete((String)"bcm_enumitem_new", (QFilter[])filters);
            this.getPageCache().remove(ITEM_ID);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u679a\u4e3e\u9879\u5220\u9664\u6210\u529f\u3002", (String)"EnumList_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u679a\u4e3e\u5220\u9664", "EnumList_40", "fi-bcm-formplugin", "enumDel");
            OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u679a\u4e3e\u9879%s\u5220\u9664\u6210\u529f\u3002", "EnumList_41", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{enumItem.getString("name")}));
            this.writeMultiLangLog(opName, opDes);
            this.initLeftTree();
        } else if ("deleteenumvalue".equals(callBackId)) {
            QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
            Object[] deleteRows = (Long[])SerializationUtils.fromJsonString((String)this.getPageCache().get("deleteRows"), Long[].class);
            DynamicObjectCollection deleteDocs = QueryServiceHelper.query((String)"bcm_enumvalue_new", (String)"parent.id,isleaf,longnumber", (QFilter[])new QFilter("id", "in", (Object)deleteRows).toArray());
            Set<Long> parentIds = deleteDocs.stream().filter(f -> f.getLong("parent.id") != 0L).map(m -> m.getLong("parent.id")).collect(Collectors.toSet());
            Set<String> longNumbers = deleteDocs.stream().map(m -> m.getString("longnumber")).collect(Collectors.toSet());
            HashSet childIds = new HashSet(16);
            longNumbers.forEach(ln -> {
                QFilter filter1 = new QFilter("longnumber", "like", (Object)(ln + "!%"));
                QueryServiceHelper.query((String)"bcm_enumvalue_new", (String)"id", (QFilter[])new QFilter[]{filter, filter1}).forEach(d -> childIds.add(d.getLong("id")));
            });
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bcm_enumvalue_new");
            DeleteServiceHelper.delete((IDataEntityType)entityType, (Object[])deleteRows);
            DeleteServiceHelper.delete((IDataEntityType)entityType, (Object[])childIds.toArray());
            ArrayList docs = new ArrayList(16);
            parentIds.removeIf(arg_0 -> EnumDisplayList.lambda$confirmCallBack$19(childIds, (Long[])deleteRows, arg_0));
            parentIds.forEach(pid -> {
                QFilter idFilter = new QFilter("parent", "=", pid);
                if (!QueryServiceHelper.exists((String)"bcm_enumvalue_new", (QFilter[])new QFilter[]{filter, idFilter})) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pid, (String)"bcm_enumvalue_new");
                    dynamicObject.set("isleaf", (Object)1);
                    docs.add(dynamicObject);
                }
            });
            if (!docs.isEmpty()) {
                SaveServiceHelper.update((DynamicObject[])docs.toArray(new DynamicObject[0]));
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u679a\u4e3e\u503c\u5220\u9664\u6210\u529f\u3002", (String)"EnumList_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.refreshRightEntity();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean moveUpAndDown(String opName) {
        List<Long> selectRows = this.getSelectMembers();
        if (selectRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u679a\u4e3e\u503c\u3002", (String)"EnumList_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject currentDy = BusinessDataServiceHelper.loadSingle((Object)selectRows.get(0), (String)"bcm_enumvalue_new");
        long enumItemId = LongUtil.toLong((Object)this.getPageCache().get(ITEM_ID));
        int seq = currentDy.getInt("dseq");
        QFilter upFilter = new QFilter("dseq", "<", (Object)seq);
        QFilter downFilter = new QFilter("dseq", ">", (Object)seq);
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and(new QFilter("parent", "=", (Object)currentDy.getLong("parent.id")));
        filter.and(new QFilter("id", "!=", (Object)currentDy.getLong("id")));
        filter.and(new QFilter("enumitemid", "=", (Object)enumItemId));
        if ("moveentryup".equals(opName)) {
            DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_enumvalue_new", (String)"id,dseq", (QFilter[])new QFilter[]{filter, upFilter}, (String)"dseq desc", (int)1);
            if (docs != null && docs.size() > 0) {
                DynamicObject changeDy = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)docs.get(0)).getLong("id"), (String)"bcm_enumvalue_new");
                int lastSeq = changeDy.getInt("dseq");
                currentDy.set("dseq", (Object)(lastSeq == seq ? lastSeq - 1 : lastSeq));
                changeDy.set("dseq", (Object)seq);
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{currentDy, changeDy});
                return true;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u5df2\u7ecf\u662f\u8be5\u5c42\u6b21\u7b2c\u4e00\u884c\u3002", (String)"DimensionDisplayList_137", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!"moveentrydown".equals(opName)) return true;
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_enumvalue_new", (String)"id,dseq", (QFilter[])new QFilter[]{filter, downFilter}, (String)"dseq", (int)1);
        if (docs != null && docs.size() > 0) {
            DynamicObject changeDy = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)docs.get(0)).getLong("id"), (String)"bcm_enumvalue_new");
            int nextSeq = changeDy.getInt("dseq");
            currentDy.set("dseq", (Object)(nextSeq == seq ? nextSeq + 1 : nextSeq));
            changeDy.set("dseq", (Object)seq);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{currentDy, changeDy});
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u5df2\u7ecf\u662f\u8be5\u5c42\u6b21\u6700\u540e\u4e00\u884c\u3002", (String)"DimensionDisplayList_139", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        return false;
    }

    private void resetSeqByNumber(Long enumItemId) {
        DynamicObject[] enumValues = BusinessDataServiceHelper.load((String)"bcm_enumvalue_new", (String)"id,number,parent.id,dseq", (QFilter[])new QFilter("enumitemid", "=", (Object)enumItemId).toArray(), (String)"number");
        Comparator<DynamicObject> comparator = Comparator.comparing(o -> o.getString("number"));
        LinkedHashMap<Long, TreeSet> parentChild = new LinkedHashMap<Long, TreeSet>(16);
        TreeSet<DynamicObject> roots = new TreeSet<DynamicObject>(comparator);
        parentChild.put(-1L, roots);
        Arrays.stream(enumValues).forEach(m -> {
            long parent = m.getLong("parent.id");
            if (parent == 0L) {
                roots.add((DynamicObject)m);
            } else {
                TreeSet treeSet = (TreeSet)parentChild.get(parent);
                if (treeSet != null) {
                    treeSet.add(m);
                } else {
                    parentChild.computeIfAbsent(parent, k -> new TreeSet(comparator)).add(m);
                }
            }
        });
        parentChild.forEach((k, v) -> {
            AtomicInteger seq = new AtomicInteger(1);
            v.forEach(d -> d.set("dseq", (Object)seq.getAndIncrement()));
        });
        SaveServiceHelper.save((DynamicObject[])enumValues);
        OperationLogUtil.writeOperationLog((String)OpItemEnum.ENUMITEM.getName(), (String)ResManager.loadKDString((String)"\u679a\u4e3e\u503c\u987a\u5e8f\u91cd\u7f6e\u6210\u529f\u3002", (String)"EnumList_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Long)this.getModelId(), (String)"bcm_enumitem_new");
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u679a\u4e3e\u503c\u987a\u5e8f\u91cd\u7f6e\u6210\u529f\u3002", (String)"EnumList_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.refreshRightEntity();
    }

    private void refreshRightEntity() {
        long itemId = LongUtil.toLong((Object)this.getPageCache().get(ITEM_ID));
        if (itemId == 0L) {
            return;
        }
        String type = this.getPageCache().get(TABLE_TYPE);
        if (org.apache.commons.lang.StringUtils.isEmpty((String)type) || "tree".equals(type)) {
            this.initRightTree(itemId);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ENTRY_ENTITY});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BILL_LIST});
        } else {
            this.getModel().deleteEntryData(ENTRY_ENTITY);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ENTRY_ENTITY});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BILL_LIST});
            this.refreshBillList(itemId);
        }
    }

    private void refreshBillList(Long itemId) {
        BillList billlist = (BillList)this.getControl(BILL_LIST);
        QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
        qf.and(new QFilter("enumitemid", "=", (Object)itemId));
        billlist.setClearSelection(Boolean.TRUE.booleanValue());
        billlist.getEntryState().setColumnQFilter(null);
        billlist.setOrderBy("number");
        billlist.setFilter(qf);
        billlist.refresh();
    }

    private static /* synthetic */ boolean lambda$confirmCallBack$19(Set childIds, Long[] deleteRows, Long p) {
        return childIds.contains(p) || Arrays.stream(deleteRows).anyMatch(m -> m.equals(p));
    }
}

