/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.export.strategy.EnumExportStrategy;
import kd.fi.bcm.business.export.strategy.ExportExecuteStrategyContext;
import kd.fi.bcm.business.export.strategy.IExport;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.util.EnumUtils;

public class EnumList
extends AbstractBaseListPlugin {
    private String dimensionKey = "dimensionID";
    private String enumitemKey = "enumitemID";
    private String ID = "id";
    private String NAME = "name";
    private String ENUMVALUE = "enumvalue";
    private static String ENTRY_ENTITY = "entryentity";
    private static String TREE_VIEW_AP = "treeviewap";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(EnumList.class);

    @Override
    public void initialize() {
        super.initialize();
        final IPageCache pg = this.getPageCache();
        final TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        tree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                TreeView.TreeState state = tree.getTreeState();
                String enumitemKeyID = state.getFocusNode().get("id").toString();
                pg.put(EnumList.this.enumitemKey, enumitemKeyID);
                QFilter qFilter = new QFilter("enumitemid", "=", (Object)Long.parseLong(enumitemKeyID));
                EnumList.this.addEnumValue(qFilter);
            }
        });
        EntryGrid eg = (EntryGrid)this.getControl(ENTRY_ENTITY);
        eg.addHyperClickListener(this::hyperEnumLinkClick);
        this.addClickListeners("btnedit", "btndel", "btnadd", "input", "output");
    }

    private void addEnumValue(QFilter qFilter) {
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRY_ENTITY);
        DynamicObjectCollection dync = QueryServiceHelper.query((String)"bcm_enumvalue", (String)"id, enumvalue, name, datatype, enumitemid, dseq", (QFilter[])qFilter.toArray(), (String)"dseq");
        if (dync.size() == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, dync.size());
        int row = 0;
        for (DynamicObject dyn : dync) {
            DynamicObject rowObj = this.getModel().getEntryRowEntity(ENTRY_ENTITY, row);
            rowObj.set("enumvalue", (Object)dyn.getString("enumvalue"));
            rowObj.set("name", (Object)dyn.getString("name"));
            rowObj.set("datatype", this.setDataTypeValue(dyn.getString("datatype")));
            rowObj.set("dseq", (Object)dyn.getInt("dseq"));
            rowObj.set("entryid", (Object)dyn.getLong("id"));
            ++row;
        }
        this.getView().updateView(ENTRY_ENTITY);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{ENTRY_ENTITY});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity(ENTRY_ENTITY);
        HashMap<Long, Integer> id2Seqs = new HashMap<Long, Integer>(entryEntitys.size());
        for (int i = 0; i < entryEntitys.size(); ++i) {
            id2Seqs.put(((DynamicObject)entryEntitys.get(i)).getLong("entryid"), i + 1);
        }
        String enumitemId = ((TreeView)this.getControl(TREE_VIEW_AP)).getTreeState().getFocusNodeId();
        QFilter qf = new QFilter("enumitemid", "=", (Object)Long.parseLong(enumitemId));
        DynamicObject[] dync = BusinessDataServiceHelper.load((String)"bcm_enumvalue", (String)"id, dseq", (QFilter[])qf.toArray(), (String)"dseq");
        ArrayList<DynamicObject> needSaveDys = new ArrayList<DynamicObject>(16);
        for (int i = 0; i < entryEntitys.size(); ++i) {
            DynamicObject afterOpDy = (DynamicObject)entryEntitys.get(i);
            DynamicObject beforeOpDy = dync[i];
            if (afterOpDy.getLong("entryid") == beforeOpDy.getLong("id")) continue;
            beforeOpDy.set("dseq", id2Seqs.get(beforeOpDy.getLong("id")));
            needSaveDys.add(beforeOpDy);
        }
        SaveServiceHelper.save((DynamicObject[])needSaveDys.toArray(new DynamicObject[0]));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String dimensionID = String.valueOf(this.getView().getFormShowParameter().getCustomParams().get("dimensionID"));
        this.getPageCache().put(this.dimensionKey, String.valueOf(this.getView().getFormShowParameter().getCustomParams().get("dimensionID")));
        this.getPageCache().put("KEY_MODEL_ID", (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        this.searchProperty(this.getTimer(), dimensionID);
        this.refreshEntryEntity();
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Button) {
            if ("btnadd".equals(((Button)evt.getSource()).getKey())) {
                BaseShowParameter showparameter = new BaseShowParameter();
                showparameter.setFormId("bcm_enumitem");
                showparameter.setCustomParam("dimensionID", this.getView().getFormShowParameter().getCustomParams().get("dimensionID"));
                showparameter.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
                showparameter.setStatus(OperationStatus.ADDNEW);
                showparameter.getOpenStyle().setShowType(ShowType.Modal);
                showparameter.setCaption(ResManager.loadKDString((String)"\u679a\u4e3e\u9879-\u65b0\u589e", (String)"EnumList_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "research");
                showparameter.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)showparameter);
            } else if ("btndel".equals(((Button)evt.getSource()).getKey())) {
                String enumitemKeyID = this.getPageCache().get(this.enumitemKey);
                if (enumitemKeyID == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u679a\u4e3e\u9879\u3002", (String)"EnumList_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                } else {
                    QFilter qf = new QFilter("enumitemid", "=", (Object)Long.parseLong(enumitemKeyID));
                    QFilter[] qfs = new QFilter[]{qf};
                    DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)"bcm_enumvalue", (String)"id,name,datatype", (QFilter[])qfs, null);
                    if (dcs != null && dcs.size() > 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u679a\u4e3e\u9879\u4e2d\u5b58\u5728\u679a\u4e3e\u503c\uff0c\u5220\u9664\u5931\u8d25\u3002", (String)"EnumList_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    QFilter qf1 = new QFilter("id", "=", (Object)Long.parseLong(enumitemKeyID));
                    DynamicObject enumitem = QueryServiceHelper.queryOne((String)"bcm_enumitem", (String)"id,issysenumitem", (QFilter[])qf1.toArray());
                    if (enumitem == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8981\u5220\u9664\u7684\u679a\u4e3e\u9879\u4e0d\u5b58\u5728\u3002", (String)"EnumList_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (1 == enumitem.getInt("issysenumitem")) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u679a\u4e3e\u9879\u4e0d\u80fd\u5220\u9664\u3002", (String)"EnumList_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    String msg = this.checkDimMemberRefer(enumitemKeyID);
                    if (kd.bos.util.StringUtils.isNotEmpty((String)msg)) {
                        this.getView().showTipNotification(msg);
                        return;
                    }
                    Object[] pks1 = new Object[]{enumitemKeyID};
                    this.getPageCache().put("pks1", SerializationUtils.toJsonString((Object)pks1));
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u679a\u4e3e\u9879\uff1f", (String)"EnumList_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("deleteenumitem"));
                }
            } else if ("btnedit".equals(((Button)evt.getSource()).getKey())) {
                String enumitemKeyID = this.getPageCache().get(this.enumitemKey);
                if (enumitemKeyID == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u4fee\u6539\u7684\u679a\u4e3e\u9879\u3002", (String)"EnumList_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                } else {
                    HashMap<String, String> openParameter = new HashMap<String, String>();
                    openParameter.put("pkId", enumitemKeyID);
                    openParameter.put("formId", "bcm_enumitem");
                    FormShowParameter showparameter = BaseShowParameter.createFormShowParameter(openParameter);
                    CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "editresearch");
                    showparameter.setCloseCallBack(closeCallBack);
                    showparameter.setCustomParam("enumitemKeyID", (Object)enumitemKeyID);
                    showparameter.setCustomParam("dimensionID", this.getView().getFormShowParameter().getCustomParams().get("dimensionID"));
                    showparameter.setStatus(OperationStatus.EDIT);
                    showparameter.setCaption(ResManager.loadKDString((String)"\u679a\u4e3e-\u7f16\u8f91", (String)"EnumList_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    showparameter.getOpenStyle().setShowType(ShowType.Modal);
                    this.getView().showForm(showparameter);
                }
            } else if ("input".equals(((Button)evt.getSource()).getKey())) {
                this.importDatas();
            } else if ("output".equals(((Button)evt.getSource()).getKey())) {
                this.outputData();
            }
        }
    }

    private String checkDimMemberRefer(String enumitemKeyID) {
        Long modelId = Long.valueOf(this.getPageCache().get("KEY_MODEL_ID"));
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("enumitem", "=", (Object)Long.parseLong(enumitemKeyID));
        DynamicObjectCollection accountDys = QueryServiceHelper.query((String)"bcm_accountmembertree", (String)"number", (QFilter[])qFilter.toArray());
        if (accountDys.size() > 0) {
            String numbers = String.join((CharSequence)",", accountDys.stream().map(x -> x.getString("number")).collect(Collectors.toList()));
            return String.format(ResManager.loadKDString((String)"\u8be5\u679a\u4e3e\u5df2\u88ab\u79d1\u76ee\u6210\u5458\u201c%s\u201d\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"EnumList_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]), numbers);
        }
        DynamicObjectCollection sceneDys = QueryServiceHelper.query((String)"bcm_scenemembertree", (String)"number", (QFilter[])qFilter.toArray());
        if (sceneDys.size() > 0) {
            String numbers = String.join((CharSequence)",", sceneDys.stream().map(x -> x.getString("number")).collect(Collectors.toList()));
            return String.format(ResManager.loadKDString((String)"\u8be5\u679a\u4e3e\u5df2\u88ab\u60c5\u666f\u6210\u5458\u201c%s\u201d\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"EnumList_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]), numbers);
        }
        DynamicObjectCollection ctDys = QueryServiceHelper.query((String)"bcm_changetypemembertree", (String)"number", (QFilter[])qFilter.toArray());
        if (ctDys.size() > 0) {
            String numbers = String.join((CharSequence)",", ctDys.stream().map(x -> x.getString("number")).collect(Collectors.toList()));
            return String.format(ResManager.loadKDString((String)"\u8be5\u679a\u4e3e\u5df2\u88ab\u53d8\u52a8\u7c7b\u578b\u6210\u5458\u201c%s\u201d\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"EnumList_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]), numbers);
        }
        DynamicObjectCollection udeDys = QueryServiceHelper.query((String)"bcm_userdefinedmembertree", (String)"number", (QFilter[])qFilter.toArray());
        if (udeDys.size() > 0) {
            String numbers = String.join((CharSequence)",", udeDys.stream().map(x -> x.getString("number")).collect(Collectors.toList()));
            return String.format(ResManager.loadKDString((String)"\u8be5\u679a\u4e3e\u5df2\u88ab\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u6210\u5458\u201c%s\u201d\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"EnumList_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]), numbers);
        }
        DynamicObjectCollection extDys = QueryServiceHelper.query((String)"bcm_structofextend", (String)"number", (QFilter[])qFilter.toArray());
        if (extDys.size() > 0) {
            String numbers = String.join((CharSequence)",", extDys.stream().map(x -> x.getString("number")).collect(Collectors.toList()));
            return String.format(ResManager.loadKDString((String)"\u8be5\u679a\u4e3e\u5df2\u88ab\u62d3\u5c55\u7ef4\u6210\u5458\u201c%s\u201d\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"EnumList_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]), numbers);
        }
        return "";
    }

    private void importDatas() {
        String dimensionName = this.getView().getFormShowParameter().getCustomParams().get("dimensionName").toString();
        String msg = String.format(ResManager.loadKDString((String)"\u679a\u4e3e-%s\u5217\u8868", (String)"EnumList_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimensionName);
        this.invokeOperation("bcm_enum_import", "kd.fi.bcm.formplugin.dimension.DemensionEnumImport", msg, "IMPORT_CLOSE");
    }

    private void outputData() {
        List<Object> pkIds = EnumUtils.getPreTemplateOfEnum("bcm_enum_import_IMPT_S");
        if (pkIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u201c\u5e94\u7528-\u5f15\u5165\u5f15\u51fa\u201d\u9884\u5236\u5bfc\u51fa\u6a21\u677f\u3002", (String)"EnumList_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        try {
            Long modelId = Long.valueOf(this.getPageCache().get("KEY_MODEL_ID"));
            FormView view = (FormView)this.getView();
            String entityName = "bcm_enum_import";
            String appId = view.getFormShowParameter().getServiceAppId();
            HashMap<String, Long> exportDataParms = new HashMap<String, Long>(16);
            exportDataParms.put("modelId", modelId);
            exportDataParms.put("dimensionId", Long.valueOf(this.getPageCache().get("dimensionID")));
            ExportExecuteStrategyContext exportExecuteStrategyContext = new ExportExecuteStrategyContext();
            exportExecuteStrategyContext.setExport((IExport)new EnumExportStrategy());
            String url = exportExecuteStrategyContext.export(appId, ((Long)pkIds.get(0)).longValue(), entityName, entityName, exportDataParms);
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                this.downloadFile(url, "bcm_dimensionmanager", "3JMWB9DDZVHD");
            }
            OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u679a\u4e3e\u5bfc\u51fa", "EnumList_42", "fi-bcm-formplugin", "enumExport");
            OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u5bfc\u51fa\u6210\u529f\u3002", "EnumList_43", "fi-bcm-formplugin", null);
            this.writeMultiLangLog(opName, opDes);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
    }

    @Override
    public IClientViewProxy getClientViewProxy() {
        return (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("baritemadd".equals(evt.getItemKey())) {
            String enumitemKeyID = this.getPageCache().get(this.enumitemKey);
            if (enumitemKeyID == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u679a\u4e3e\u9879\u3002", (String)"EnumList_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                QFilter q1 = new QFilter("id", "=", (Object)LongUtil.toLong((Object)enumitemKeyID));
                QFilter[] qfs1 = new QFilter[]{q1};
                DynamicObjectCollection dcs1 = QueryServiceHelper.query((String)this.getClass().getName(), (String)"bcm_enumitem", (String)"name,datatype", (QFilter[])qfs1, null);
                Object enumitemname = ((DynamicObject)dcs1.get(0)).get("name");
                Object datatype = ((DynamicObject)dcs1.get(0)).get("datatype");
                BaseShowParameter parameter = new BaseShowParameter();
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "valueresearch");
                parameter.setCloseCallBack(closeCallBack);
                parameter.setFormId("bcm_enumvalue");
                parameter.setCustomParam("enumitemKey", (Object)enumitemKeyID);
                parameter.setCustomParam("enumitemname", enumitemname);
                parameter.setCustomParam("datatype", datatype);
                parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
                parameter.setCustomParam("dimensionID", (Object)this.getPageCache().get(this.dimensionKey));
                parameter.setStatus(OperationStatus.ADDNEW);
                parameter.setCaption(ResManager.loadKDString((String)"\u679a\u4e3e\u503c-\u65b0\u589e", (String)"EnumList_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm((FormShowParameter)parameter);
            }
        } else if ("baritemdel".equals(evt.getItemKey())) {
            int[] nums = ((EntryGrid)this.getControl(ENTRY_ENTITY)).getSelectRows();
            if (nums.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u679a\u4e3e\u503c\u3002", (String)"EnumList_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                ArrayList<DynamicObject> dysc = new ArrayList<DynamicObject>(10);
                for (int num : nums) {
                    dysc.add(this.getModel().getEntryRowEntity(ENTRY_ENTITY, num));
                }
                Set ids = dysc.stream().map(x -> x.getLong("entryid")).collect(Collectors.toSet());
                QFilter qf1 = new QFilter("id", "in", ids);
                DynamicObject enumValue = QueryServiceHelper.queryOne((String)"bcm_enumvalue", (String)"id,dimension,issysenumvalue,enumitemid", (QFilter[])qf1.toArray());
                if (enumValue == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8981\u5220\u9664\u7684\u679a\u4e3e\u503c\u4e0d\u5b58\u5728\u3002", (String)"EnumList_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                QFilter qf = new QFilter("id", "=", (Object)enumValue.getLong("enumitemid"));
                DynamicObject enumitem = QueryServiceHelper.queryOne((String)"bcm_enumitem", (String)"name", (QFilter[])qf.toArray());
                String localeValue = ResManager.getLocaleString((String)"\u4e1a\u52a1\u7c7b\u578b", (String)"ExtDimEditPlugin_8", (String)"fi-bcm-formplugin").getLocaleValue();
                if (!enumitem.getString("name").equals(localeValue) && 1 == enumValue.getInt("issysenumvalue")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u9884\u7f6e\u679a\u4e3e\u503c\u4e0d\u80fd\u5220\u9664\u3002", (String)"EnumItemEdit_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getPageCache().put("pks1", SerializationUtils.toJsonString(ids));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u9009\u62e9\u7684\u679a\u4e3e\u503c\uff1f", (String)"EnumList_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("deleteenumvalue"));
            }
        } else if ("bresearch".equals(evt.getItemKey())) {
            this.refreshEntryEntity();
        } else if ("baritemexit".equals(evt.getItemKey())) {
            this.getView().close();
        }
    }

    private void hyperEnumLinkClick(HyperLinkClickEvent evt) {
        DynamicObject rowData = this.getModel().getEntryRowEntity(ENTRY_ENTITY, evt.getRowIndex());
        String enumitemKeyID = this.getPageCache().get(this.enumitemKey);
        HashMap<String, String> openParameter = new HashMap<String, String>();
        openParameter.put("pkId", rowData.getString("entryid"));
        openParameter.put("formId", "bcm_enumvalue");
        FormShowParameter showparameter = BaseShowParameter.createFormShowParameter(openParameter);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "valueEditResearch");
        showparameter.setCloseCallBack(closeCallBack);
        showparameter.setCustomParam("enumvalueID", (Object)rowData.getString("entryid"));
        showparameter.setCustomParam("enumitemKeyID", (Object)enumitemKeyID);
        showparameter.setStatus(OperationStatus.EDIT);
        showparameter.setCaption(ResManager.loadKDString((String)"\u679a\u4e3e\u503c-\u7f16\u8f91", (String)"EnumList_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        showparameter.getOpenStyle().setShowType(ShowType.Modal);
        showparameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm(showparameter);
    }

    private void searchProperty(String time, String dimensionID) {
        QFilter fmodelid;
        QFilter[] filters;
        String selectFields;
        DynamicObjectCollection dcs;
        if (kd.bos.util.StringUtils.isEmpty((String)dimensionID)) {
            dimensionID = this.getPageCache().get(this.dimensionKey);
        }
        if ((dcs = QueryServiceHelper.query((String)"bcm_enumitem", (String)(selectFields = "id,name"), (QFilter[])(filters = new QFilter[]{fmodelid = new QFilter("dimension", "=", (Object)LongUtil.toLong((Object)dimensionID))}))) != null && dcs.size() > 0) {
            TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
            TreeNode root = new TreeNode();
            root.setId("root");
            for (DynamicObject task : dcs) {
                TreeNode enumitemNode = new TreeNode();
                enumitemNode.setId(task.getString("id"));
                enumitemNode.setText((String)task.get("name"));
                enumitemNode.setData((Object)task);
                root.addChild(enumitemNode);
            }
            tree.addNode(root);
            tree.expand("root");
            if ("A".equals(time)) {
                tree.focusNode((TreeNode)root.getChildren().get(0));
                this.getPageCache().put(this.enumitemKey, ((TreeNode)root.getChildren().get(0)).getId());
                tree.treeNodeClick("root", ((TreeNode)root.getChildren().get(0)).getId());
            }
            if ("B".equals(time)) {
                tree.focusNode((TreeNode)root.getChildren().get(root.getChildren().size() - 1));
                this.getPageCache().put(this.enumitemKey, ((TreeNode)root.getChildren().get(0)).getId());
                tree.treeNodeClick("root", ((TreeNode)root.getChildren().get(root.getChildren().size() - 1)).getId());
            }
            if ("C".equals(time)) {
                tree.focusNode(this.searchTreeNode(root, this.getPageCache().get(this.enumitemKey)));
            }
        } else {
            this.getPageCache().put(this.enumitemKey, null);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("research".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            if ("addSuccess".equalsIgnoreCase(String.valueOf(closedCallBackEvent.getReturnData()))) {
                TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
                tree.deleteAllNodes();
                this.searchProperty("B", null);
            } else {
                this.searchProperty("C", null);
            }
        } else if ("valueresearch".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            this.refreshEntryEntity();
        } else if ("editresearch".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            if ("editSuccess".equalsIgnoreCase(String.valueOf(closedCallBackEvent.getReturnData()))) {
                TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
                tree.deleteAllNodes();
                this.searchProperty("C", null);
                this.refreshEntryEntity();
            } else {
                this.searchProperty("C", null);
            }
        } else if ("valueEditResearch".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            if ("ValueEditSuccess".equalsIgnoreCase(String.valueOf(closedCallBackEvent.getReturnData()))) {
                this.refreshEntryEntity();
            }
        } else if ("IMPORT_CLOSE".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            this.refreshEntryEntity();
        }
    }

    private void refreshEntryEntity() {
        String enumitemId = this.getPageCache().get(this.enumitemKey);
        if (enumitemId != null) {
            QFilter qFilter = new QFilter("enumitemid", "=", (Object)Long.parseLong(enumitemId));
            this.addEnumValue(qFilter);
        }
    }

    private String getTimer() {
        if (kd.bos.util.StringUtils.isNotEmpty((String)this.getPageCache().get("isAlreadyInit"))) {
            return "B";
        }
        this.getPageCache().put("isAlreadyInit", "1");
        return "A";
    }

    private TreeNode searchTreeNode(TreeNode root, String nodeId) {
        for (TreeNode node : root.getChildren()) {
            if (!nodeId.equals(node.getId())) continue;
            return node;
        }
        return (TreeNode)root.getChildren().get(0);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        String result = messageBoxClosedEvent.getResultValue();
        String dimensionName = (String)this.getView().getFormShowParameter().getCustomParams().get("dimensionName");
        if ("deleteenumitem".equals(callBackId) && "Yes".equals(result)) {
            Object[] pks1 = (Object[])SerializationUtils.fromJsonString((String)this.getPageCache().get("pks1"), Object[].class);
            DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_enumitem", (String)"name", (QFilter[])new QFilter[]{new QFilter(this.ID, "=", (Object)Long.parseLong(pks1[0].toString()))});
            MainEntityType idt1 = EntityMetadataCache.getDataEntityType((String)"bcm_enumitem");
            DeleteServiceHelper.delete((IDataEntityType)idt1, (Object[])pks1);
            TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u679a\u4e3e\u9879\u5220\u9664\u6210\u529f\u3002", (String)"EnumList_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            tree.deleteAllNodes();
            this.searchProperty("A", null);
            OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u679a\u4e3e\u5220\u9664", "EnumList_40", "fi-bcm-formplugin", "enumDel");
            OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u679a\u4e3e\u9879%s\u5220\u9664\u6210\u529f\u3002", "EnumList_41", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{dy.getString(this.NAME)}));
            this.writeMultiLangLog(opName, opDes);
        } else if ("deleteenumvalue".equals(callBackId) && "Yes".equals(result)) {
            Object[] pks1 = (Object[])SerializationUtils.fromJsonString((String)this.getPageCache().get("pks1"), Object[].class);
            MainEntityType idt1 = EntityMetadataCache.getDataEntityType((String)"bcm_enumvalue");
            DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_enumvalue", (String)"enumvalue,name", (QFilter[])new QFilter[]{new QFilter(this.ID, "=", (Object)Long.parseLong(pks1[0].toString()))});
            DeleteServiceHelper.delete((IDataEntityType)idt1, (Object[])pks1);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u679a\u4e3e\u503c\u5220\u9664\u6210\u529f\u3002", (String)"EnumList_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u679a\u4e3e\u5220\u9664", "EnumList_40", "fi-bcm-formplugin", "enumDel");
            OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u679a\u4e3e\u9879\u201c%1$s\u201d\u679a\u4e3e\u503c\u201c%2$s\u201d\u5220\u9664\u6210\u529f\u3002", "EnumList_44", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{dy.getString(this.NAME), dy.getString(this.ENUMVALUE)}));
            this.writeMultiLangLog(opName, opDes);
            this.refreshEntryEntity();
        }
    }

    private Object setDataTypeValue(String datatype) {
        switch (datatype) {
            case "1": {
                return DataTypeEnum.CURRENCY.getName();
            }
            case "2": {
                return DataTypeEnum.UNCURRENCY.getName();
            }
            case "3": {
                return DataTypeEnum.TXT.getName();
            }
            case "4": {
                return DataTypeEnum.DATETP.getName();
            }
            case "5": {
                return DataTypeEnum.PROPORTION.getName();
            }
        }
        return null;
    }
}

