/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension;

import com.alibaba.fastjson.JSONArray;
import java.io.IOException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.export.ExportExecute;
import kd.fi.bcm.business.export.strategy.DimensionMemberExportStrategy;
import kd.fi.bcm.business.export.strategy.ExportExecuteStrategyContext;
import kd.fi.bcm.business.export.strategy.IExport;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.MethodOpProxy;
import kd.fi.bcm.formplugin.adjust.report.AbjustExportUtil;

public class ExportTemplatePlugin
extends AbstractFormPlugin {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String MODELID = "modelId";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ExportTemplatePlugin.class);

    private String getOperationExport() {
        return ResManager.loadKDString((String)"\u5bfc\u51fa", (String)"ExportTemplatePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"ExportTemplatePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"ExportTemplatePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam("billFormId");
        if (!StringUtils.isBlank((CharSequence)billFormId)) {
            BillList list = (BillList)this.getControl("billlistap");
            FilterParameter filterParameter = new FilterParameter();
            String templateType = (String)this.getView().getFormShowParameter().getCustomParam("TemplateType");
            filterParameter.setFilter(new QFilter("bizobject.number", "=", (Object)billFormId).and(new QFilter("templatetype", "=", (Object)templateType).or(new QFilter("templatetype", "is null", null))));
            list.setQueryFilterParameter(filterParameter);
        }
    }

    public void click(EventObject evt) {
        if ("btnok".equals(((Control)evt.getSource()).getKey())) {
            DynamicObjectCollection data = this.getView().getParentView().getModel().getEntryEntity("treeentryentity");
            Object selectData = null;
            try {
                String billFormId = (String)this.getView().getFormShowParameter().getCustomParam("billFormId");
                if ("bcm_dimmembermappingimp".equals(billFormId) || "bcm_dimmembwelkin".equals(billFormId)) {
                    Object[] templates;
                    FormView formView = (FormView)this.getView();
                    ExportExecute exportor = new ExportExecute();
                    BillList billList = (BillList)this.getView().getControl("billlistap");
                    for (Object object : templates = billList.getSelectedRows().getPrimaryKeyValues()) {
                        String routeAppId = formView.getFormShowParameter().getServiceAppId();
                        long modelId = (Long)this.getView().getFormShowParameter().getCustomParam(MODELID);
                        long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
                        long template = (Long)object;
                        String url = "";
                        url = "bcm_dimmembwelkin".equals(billFormId) ? exportor.exportDimMemberMappingWelkin(routeAppId, billFormId, Long.valueOf(modelId), Long.valueOf(schemeId), Long.valueOf(template), billFormId) : exportor.exportDimMemberMapping(routeAppId, billFormId, Long.valueOf(modelId), Long.valueOf(schemeId), Long.valueOf(template), billFormId);
                        this.getClientViewProxy().addAction("download", (Object)url);
                    }
                } else if ("bcm_rptadjust".equals(billFormId)) {
                    MethodOpProxy.createInstance(this.getBizAppId(), this.getCurModelNumber(), ((Object)((Object)this)).getClass(), "rptadjust_exportlist").executeWithResult(() -> {
                        String routeAppId = this.getView().getFormShowParameter().getServiceAppId();
                        BillList billList = (BillList)this.getView().getControl("billlistap");
                        JSONArray pkIds = (JSONArray)this.getView().getFormShowParameter().getCustomParam("adjustids");
                        Object[] templates = billList.getSelectedRows().getPrimaryKeyValues();
                        Map<Object, String> resultMap = null;
                        try {
                            long modelId = (Long)this.getView().getFormShowParameter().getCustomParam(MODELID);
                            resultMap = AbjustExportUtil.export(modelId, routeAppId, (List<Object>)pkIds, templates, true, true, "");
                        }
                        catch (IOException e) {
                            logger.error((Throwable)e);
                        }
                        if (resultMap != null) {
                            for (Object url : resultMap.values()) {
                                this.getClientViewProxy().addAction("download", url);
                            }
                        }
                        return null;
                    });
                } else {
                    FormView formView = (FormView)this.getView();
                    BillList billList = (BillList)this.getView().getControl("billlistap");
                    Object[] templates = billList.getSelectedRows().getPrimaryKeyValues();
                    selectData = this.getView().getFormShowParameter().getCustomParam("selectData");
                    for (Object object : templates) {
                        String routeAppId = formView.getFormShowParameter().getServiceAppId();
                        long modelId = (Long)this.getView().getFormShowParameter().getCustomParam(MODELID);
                        long template = (Long)object;
                        String schemeId = (String)this.getView().getFormShowParameter().getCustomParam("schemeId");
                        HashMap<String, Object> outputParams = new HashMap<String, Object>();
                        outputParams.put(MODELID, modelId);
                        outputParams.put("schemeId", schemeId);
                        if (selectData != null) {
                            List selectIds = (List)selectData;
                            outputParams.put("selectData", selectIds);
                        }
                        ExportExecuteStrategyContext exportExecuteStrategyContext = new ExportExecuteStrategyContext();
                        exportExecuteStrategyContext.setExport((IExport)new DimensionMemberExportStrategy());
                        String url = exportExecuteStrategyContext.export(routeAppId, template, billFormId, billFormId.replaceAll("imp", "tree"), outputParams);
                        this.getClientViewProxy().addAction("download", (Object)url);
                    }
                }
                this.writeExportLog(data, selectData, this.getOperationStstusSuccess());
            }
            catch (IOException e) {
                this.writeExportLog(data, selectData, this.getOperationStstusFail());
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
    }

    private void writeExportLog(DynamicObjectCollection data, Object selectData, String status) {
        block4: {
            if (data == null) break block4;
            if (selectData == null) {
                for (int i = 0; i < data.size(); ++i) {
                    this.writeExportLogEntity((DynamicObject)data.get(i), status);
                }
            } else {
                List selectIds = (List)selectData;
                for (int i = 0; i < data.size(); ++i) {
                    if (!selectIds.contains(((DynamicObject)data.get(i)).getLong(ID))) continue;
                    this.writeExportLogEntity((DynamicObject)data.get(i), status);
                }
            }
        }
    }

    private void writeExportLogEntity(DynamicObject dy, String status) {
        String log = String.format("%s %s,%s%s", dy.getString(NUMBER), dy.getString(NAME), this.getOperationExport(), status);
        OperationLogUtil.writeOperationLog((IFormView)this.getView().getParentView(), (String)this.getOperationExport(), (String)log, (Long)((Long)this.getView().getFormShowParameter().getCustomParam(MODELID)));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        BillList list = (BillList)this.getControl("billlistap");
        list.refreshData();
    }

    public IClientViewProxy getClientViewProxy() {
        return (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
    }

    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    public String getCurModelNumber() {
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam(MODELID);
        if (modelId == 0L) {
            return "";
        }
        DynamicObject modelDy = QueryServiceHelper.queryOne((String)"bcm_model", (String)NUMBER, (QFilter[])new QFilter(ID, "=", (Object)modelId).toArray());
        return Objects.isNull(modelDy) ? "" : modelDy.getString(NUMBER);
    }
}

