/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.extdata.ExtDimModelServiceHelper;
import kd.fi.bcm.business.mq.consumer.MQMessagePublisherServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.factory.CacheGenFactory;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.dimension.ExtDimEditConstant;
import kd.fi.bcm.formplugin.template.TemplateImport;

public class ExtDimEditPlugin
extends AbstractFormPlugin {
    private static WatchLogger LOG = BcmLogFactory.getWatchLogInstance(ExtDimEditPlugin.class);
    private static final String FTEXTEXT = "textext";
    private static final String FNUMEXT = "numext";
    private static final String FDATEEXT = "dateext";
    private static final String[] num = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
    private final List<String> numbers = Arrays.asList("INTR_000", "INTR_001", "INTR_002", "INTR_003", "INTR_004", "INTR_005", "INTR_006", "INTR_007", "INTR_008", "INTR_009", "INTR_010", "INTR_011", "INTR_012", "INTR_013", "INTR_014", "INTR_015", "INTR_016", "INTR_017", "INTR_018", "INTR_019", "INTR_020", "INTR_021", "INV_001", "INV_002", "INV_003", "INV_004", "INV_005", "INV_006", "INV_007", "INV_008", "INV_009", "INV_010", "INV_011", "INV_012", "INV_013", "INV_014", "INV_015", "INV_016", "INV_017", "INV_018", "INV_019", "INV_020", "INV_021", "INV_022", "INV_023", "INV_024", "INV_025", "INV_026", "INV_027", "INV_028", "INV_029", "INV_030", "INV_031", "INV_032", "INV_033", "INV_034", "INV_035", "INV_036", "INV_037", "INV_038");
    private final List<String> datatypes = Arrays.asList("6", "6", "1", "1", "1", "0", "1", "1", "1", "1", "1", "0", "5", "1", "1", "2", "2", "0", "6", "6", "6", "6", "5", "1", "5", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1");
    private final List<String> mappingNums = Arrays.asList("1", "2", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "3", "4", "5", "6", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38");
    private final List<String> exchanges = Arrays.asList("0", "0", "2", "2", "2", "0", "1", "1", "2", "2", "1", "0", "0", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0");
    private final List<String> entryrates = Arrays.asList("0", "0", "2", "2", "2", "0", "1", "1", "2", "2", "1", "0", "0", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0");
    private final List<String> periodValueNames = Arrays.asList("M_M01", "M_M02", "M_M03", "M_M04", "M_M05", "M_M06", "M_M07", "M_M08", "M_M09", "M_M10", "M_M11", "M_M12");
    private final List<String> initNumbers = Arrays.asList("INV_AREA", "DatArea", "JnIArea");

    private String getXNoneNumber() {
        Object number = this.getModel().getValue("shortnumber");
        if (Objects.isNull(number)) {
            return "XNone";
        }
        return number + "None";
    }

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        super.registerListener(e);
    }

    public void click(EventObject evt) {
        String key = ((Button)evt.getSource()).getKey();
        long modelId = Long.parseLong(this.getPageCache().get("modelId"));
        QFilter qFilter = new QFilter("id", "=", (Object)modelId);
        DynamicObjectCollection number = QueryServiceHelper.query((String)"bcm_dimension", (String)"number", (QFilter[])new QFilter[]{qFilter});
        if (number.stream().anyMatch(x -> x.get("number").equals(this.getModel().getValue("number")))) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"number"});
            return;
        }
        if (key.equals("btnok")) {
            if ("btnedit".equals(this.getView().getFormShowParameter().getCustomParam("status"))) {
                this.saveExtendEditData();
            } else {
                try (TXHandle tx = TX.required((String)"save_extends_and_default_member");){
                    String checkMsg = this.checkNumberAndShortNum(modelId);
                    if (StringUtils.isNotEmpty((CharSequence)checkMsg)) {
                        this.getView().showTipNotification(checkMsg);
                        return;
                    }
                    try {
                        DynamicObject[] sucessIds = this.seveInExtDim(modelId);
                        long dimId = sucessIds != null && sucessIds.length > 0 ? sucessIds[0].getLong("id") : 0L;
                        DynamicObject[] dynamicObjects = this.seveInExtDimMemTree(dimId, modelId);
                        this.createExtDimEnumItem(modelId, dimId);
                        DynamicObject[] extDimInitProperty = this.createExtDimInitProperty(modelId, dimId);
                        DynamicObject[] extDimBizGroupMem = this.createExtDimBizGroupMem(dynamicObjects[0], dimId, extDimInitProperty, modelId);
                        ExtDimModelServiceHelper.createDefaultExtDimModel((long)modelId, (DynamicObject[])extDimBizGroupMem);
                        CacheGenFactory.getDimMemberCacheCache().invalidateStartsWithKey(MemberReader.findModelNumberById((Object)modelId));
                    }
                    catch (Exception e) {
                        LOG.error("ext_preset_dim_save, error:" + e.getMessage(), (Throwable)e);
                        tx.markRollback();
                        throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)("Failed to save data: " + e.getMessage())), new Object[0]);
                    }
                }
                this.importExtPreTemplate(modelId);
                String record = ResManager.loadKDString((String)"\u65b0\u589e\u62d3\u5c55\u7ef4", (String)"ExtDimEditPlugin_209", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                this.writeOpLog(OpItemEnum.ADD.getName(), record, modelId);
                this.getView().returnDataToParent((Object)"addNew");
                this.getView().close();
            }
        }
    }

    private String checkNumberAndShortNum(long modelId) {
        String number = (String)this.getModel().getValue("number");
        if (number == null || "".equals(number)) {
            return ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExtDimEditPlugin_185", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        String shortnumber = (String)this.getModel().getValue("shortnumber");
        if (shortnumber == null || "".equals(shortnumber)) {
            return ResManager.loadKDString((String)"\u7ef4\u5ea6\u7b80\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExtDimEditPlugin_186", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        String regEx = "^(?!_)[a-zA-Z0-9]+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(number);
        Matcher matcher2 = pattern.matcher(shortnumber);
        if (StringUtils.startsWithAny((CharSequence)number, (CharSequence[])num) || StringUtils.startsWithAny((CharSequence)shortnumber, (CharSequence[])num) || !matcher.matches() || !matcher2.matches()) {
            return ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801\u548c\u7b80\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u548c\u534a\u89d2\u5b57\u6bcd\uff0c\u4e0d\u53ef\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ExtDimEditPlugin_204", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (number.contains(".") || shortnumber.contains(".")) {
            return ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801\u548c\u7b80\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u548c\u534a\u89d2\u5b57\u6bcd\uff0c\u4e0d\u53ef\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ExtDimEditPlugin_204", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        QFilter qNumber = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection results = QueryServiceHelper.query((String)"bcm_dimension", (String)"number,shortnumber", (QFilter[])qNumber.toArray());
        boolean isNum = results.stream().anyMatch(x -> x.getString("number").equalsIgnoreCase(number) || x.getString("shortnumber").equalsIgnoreCase(number));
        if (isNum) {
            return ResManager.loadKDString((String)"\u8be5\u7f16\u7801\u5728\u5f53\u524d\u4f53\u7cfb\u4e2d\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801\u6216\u7b80\u7801\u3002", (String)"ExtDimEditPlugin_187", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        boolean isShortNum = results.stream().anyMatch(x -> x.getString("number").equalsIgnoreCase(shortnumber) || x.getString("shortnumber").equalsIgnoreCase(shortnumber));
        if (isShortNum) {
            return ResManager.loadKDString((String)"\u8be5\u7b80\u7801\u5728\u5f53\u524d\u4f53\u7cfb\u4e2d\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801\u6216\u7b80\u7801\u3002", (String)"ExtDimEditPlugin_188", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private void saveExtendEditData() {
        try (TXHandle tx = TX.required((String)"save_extends_info");){
            try {
                Long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_dimension_ext");
                dynamicObject.set("name", this.getModel().getValue("name"));
                dynamicObject.set("isuseddataperm", this.getModel().getValue("isuseddataperm"));
                dynamicObject.set("description", this.getModel().getValue("description"));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                QFilter qf = new QFilter("dimension", "=", (Object)id);
                qf.and(new QFilter("level", "=", (Object)1));
                DynamicObject dyTree = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_structofextend", (QFilter[])qf.toArray());
                dyTree.set("name", this.getModel().getValue("name"));
                dyTree.set("description", this.getModel().getValue("description"));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyTree});
                long memId = ((DynamicObject)dyTree.get("member")).getLong("id");
                DynamicObject dyMem = BusinessDataServiceHelper.loadSingle((Object)memId, (String)"bcm_membofextend");
                dyMem.set("name", this.getModel().getValue("name"));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyMem});
                GlobalCacheServiceHelper.getCommonCache().invalidateByKey("getDimensionDynById-" + id);
                MQMessagePublisherServiceHelper.publishClearDimMemberCache((String)dyTree.getString("model.number"), (String)"bcm_structofextend");
            }
            catch (Exception e) {
                LOG.error("save_extends_info, error:" + e.getMessage(), (Throwable)e);
                tx.markRollback();
                throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)("Failed to save extends info: " + e.getMessage())), new Object[0]);
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ExtDimEditPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getView().close();
    }

    private void importExtPreTemplate(long modelId) {
        try {
            TemplateImport templateImport = new TemplateImport();
            DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"bcm_model");
            templateImport.importTemplates(model, ApplicationTypeEnum.CM, true);
        }
        catch (Exception e) {
            LOG.error("class:ExtDimEditPlugin,method:importExtPreTemplate import error");
        }
    }

    private void createExtDimEnumItem(long modelId, long dimId) {
        DynamicObject dynamicObject1 = BusinessDataServiceHelper.newDynamicObject((String)"bcm_enumitem");
        dynamicObject1.set("name", (Object)ResManager.getLocaleString((String)"\u4e1a\u52a1\u7c7b\u578b", (String)"ExtDimEditPlugin_8", (String)"fi-bcm-formplugin"));
        dynamicObject1.set("datatype", (Object)"3");
        dynamicObject1.set("dimension", (Object)dimId);
        dynamicObject1.set("model", (Object)modelId);
        dynamicObject1.set("issysenumitem", (Object)1);
        DynamicObject[] texts = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject1});
        DynamicObject dynamicObject2 = BusinessDataServiceHelper.newDynamicObject((String)"bcm_enumitem");
        dynamicObject2.set("name", (Object)ResManager.getLocaleString((String)"\u8d22\u5e74", (String)"ExtDimEditPlugin_3", (String)"fi-bcm-formplugin"));
        dynamicObject2.set("datatype", (Object)"3");
        dynamicObject2.set("dimension", (Object)dimId);
        dynamicObject2.set("model", (Object)modelId);
        dynamicObject2.set("issysenumitem", (Object)1);
        DynamicObject[] years = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject2});
        DynamicObject dynamicObject3 = BusinessDataServiceHelper.newDynamicObject((String)"bcm_enumitem");
        dynamicObject3.set("name", (Object)ResManager.getLocaleString((String)"\u671f\u95f4", (String)"ExtDimEditPlugin_5", (String)"fi-bcm-formplugin"));
        dynamicObject3.set("datatype", (Object)"3");
        dynamicObject3.set("dimension", (Object)dimId);
        dynamicObject3.set("model", (Object)modelId);
        dynamicObject3.set("issysenumitem", (Object)1);
        DynamicObject[] periods = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject3});
        DynamicObject dynamicObject4 = BusinessDataServiceHelper.newDynamicObject((String)"bcm_enumitem");
        dynamicObject4.set("name", (Object)ResManager.getLocaleString((String)"\u662f\u5426\u5dee\u989d", (String)"ExtDimEditPlugin_200", (String)"fi-bcm-formplugin"));
        dynamicObject4.set("datatype", (Object)"3");
        dynamicObject4.set("dimension", (Object)dimId);
        dynamicObject4.set("model", (Object)modelId);
        dynamicObject4.set("issysenumitem", (Object)1);
        DynamicObject[] imbas = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject4});
        DynamicObject[] dynamicObjects = new DynamicObject[4];
        List<LocaleString> enumValueNames = ExtDimEditConstant.enumValueNames;
        for (int i = 0; i < 4; ++i) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_enumvalue");
            dynamicObject.set("enumvalue", (Object)enumValueNames.get(i));
            dynamicObject.set("name", (Object)ResManager.getLocaleString((String)"\u4e1a\u52a1\u7c7b\u578b", (String)"ExtDimEditPlugin_8", (String)"fi-bcm-formplugin"));
            dynamicObject.set("datatype", texts[0].get("datatype"));
            dynamicObject.set("dimension", (Object)dimId);
            dynamicObject.set("model", (Object)modelId);
            dynamicObject.set("enumitemid", texts[0].get("id"));
            dynamicObject.set("issysenumvalue", (Object)0);
            dynamicObject.set("dseq", (Object)(i + 1));
            dynamicObjects[i] = dynamicObject;
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        QFilter qfMem = new QFilter("longnumber", "=", (Object)"Year!AllYear");
        DynamicObject fyMem = QueryServiceHelper.queryOne((String)"bcm_fymembertree", (String)"id", (QFilter[])new QFilter[]{qf, qfMem});
        QFilter qfc = new QFilter("parent", "=", (Object)fyMem.getLong("id"));
        DynamicObjectCollection fyNums = QueryServiceHelper.query((String)"bcm_fymembertree", (String)"number", (QFilter[])new QFilter[]{qf, qfc});
        if (fyNums != null && fyNums.size() > 0) {
            List numbers = fyNums.stream().map(x -> x.getString("number")).collect(Collectors.toList());
            DynamicObject[] fyArr = new DynamicObject[numbers.size()];
            for (int i = 0; i < numbers.size(); ++i) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_enumvalue");
                LocaleString ls = new LocaleString(Lang.zh_CN.toString(), (String)numbers.get(i));
                ls.put(Lang.zh_TW.toString(), numbers.get(i));
                ls.put(Lang.en_US.toString(), numbers.get(i));
                dynamicObject.set("enumvalue", (Object)ls);
                dynamicObject.set("name", (Object)ResManager.getLocaleString((String)"\u8d22\u5e74", (String)"ExtDimEditPlugin_3", (String)"fi-bcm-formplugin"));
                dynamicObject.set("datatype", years[0].get("datatype"));
                dynamicObject.set("dimension", (Object)dimId);
                dynamicObject.set("model", (Object)modelId);
                dynamicObject.set("enumitemid", years[0].get("id"));
                dynamicObject.set("issysenumvalue", (Object)1);
                dynamicObject.set("dseq", (Object)(i + 1));
                fyArr[i] = dynamicObject;
            }
            SaveServiceHelper.save((DynamicObject[])fyArr);
        }
        DynamicObject[] period = new DynamicObject[this.periodValueNames.size()];
        for (int i = 0; i < this.periodValueNames.size(); ++i) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_enumvalue");
            LocaleString ls = new LocaleString(Lang.zh_CN.toString(), this.periodValueNames.get(i));
            ls.put(Lang.zh_TW.toString(), (Object)this.periodValueNames.get(i));
            ls.put(Lang.en_US.toString(), (Object)this.periodValueNames.get(i));
            dynamicObject.set("enumvalue", (Object)ls);
            dynamicObject.set("name", (Object)ResManager.getLocaleString((String)"\u671f\u95f4", (String)"ExtDimEditPlugin_5", (String)"fi-bcm-formplugin"));
            dynamicObject.set("datatype", periods[0].get("datatype"));
            dynamicObject.set("dimension", (Object)dimId);
            dynamicObject.set("model", (Object)modelId);
            dynamicObject.set("enumitemid", periods[0].get("id"));
            dynamicObject.set("issysenumvalue", (Object)1);
            dynamicObject.set("dseq", (Object)(i + 1));
            period[i] = dynamicObject;
        }
        SaveServiceHelper.save((DynamicObject[])period);
        List<LocaleString> enumImbalanceNames = ExtDimEditConstant.enumImbalanceNames;
        DynamicObject[] imbalans = new DynamicObject[enumImbalanceNames.size()];
        for (int i = 0; i < enumImbalanceNames.size(); ++i) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_enumvalue");
            dynamicObject.set("enumvalue", (Object)enumImbalanceNames.get(i));
            dynamicObject.set("name", (Object)ResManager.getLocaleString((String)"\u662f\u5426\u5dee\u989d", (String)"ExtDimEditPlugin_200", (String)"fi-bcm-formplugin"));
            dynamicObject.set("datatype", imbas[0].get("datatype"));
            dynamicObject.set("dimension", (Object)dimId);
            dynamicObject.set("model", (Object)modelId);
            dynamicObject.set("enumitemid", imbas[0].get("id"));
            dynamicObject.set("issysenumvalue", (Object)1);
            dynamicObject.set("dseq", (Object)(i + 1));
            imbalans[i] = dynamicObject;
        }
        SaveServiceHelper.save((DynamicObject[])imbalans);
    }

    private DynamicObject[] createExtDimInitProperty(long modelId, long dimId) {
        DynamicObject dfpPar = BusinessDataServiceHelper.newDynamicObject((String)"bcm_definedproperty");
        dfpPar.set("propertyn", (Object)"dpropertyid1");
        dfpPar.set("name", (Object)ResManager.getLocaleString((String)"\u6743\u76ca\u62b5\u9500\u533a\u57df", (String)"ExtDimEditPlugin_76", (String)"fi-bcm-formplugin"));
        dfpPar.set("dimension", (Object)dimId);
        dfpPar.set("number", (Object)"INV_AREA");
        dfpPar.set("model", (Object)modelId);
        DynamicObject[] save = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dfpPar});
        DynamicObject dfpv0 = BusinessDataServiceHelper.newDynamicObject((String)"bcm_definedpropertyvalue");
        dfpv0.set("name", (Object)ResManager.getLocaleString((String)"\u6743\u76ca\u62b5\u9500\u533a\u57df", (String)"ExtDimEditPlugin_76", (String)"fi-bcm-formplugin"));
        dfpv0.set("number", (Object)"INV_AREA");
        dfpv0.set("property", (Object)ResManager.getLocaleString((String)"\u6743\u76ca\u62b5\u9500\u533a\u57df", (String)"ExtDimEditPlugin_76", (String)"fi-bcm-formplugin"));
        dfpv0.set("parentid", (Object)"0");
        dfpv0.set("longnumber", (Object)"INV_AREA");
        dfpv0.set("level", (Object)0);
        dfpv0.set("propertyid", (Object)save[0].getLong("id"));
        dfpv0.set("model", (Object)modelId);
        dfpv0.set("dimension", (Object)dimId);
        DynamicObject[] treeSavePar = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dfpv0});
        List<LocaleString> initNames = ExtDimEditConstant.initNames;
        DynamicObject[] initPropertys = new DynamicObject[2];
        for (int i = 1; i < this.initNumbers.size(); ++i) {
            DynamicObject dfpv = BusinessDataServiceHelper.newDynamicObject((String)"bcm_definedpropertyvalue");
            dfpv.set("name", (Object)initNames.get(i));
            dfpv.set("number", (Object)this.initNumbers.get(i));
            dfpv.set("property", (Object)initNames.get(i));
            dfpv.set("parentid", (Object)treeSavePar[0].getLong("id"));
            dfpv.set("longnumber", (Object)("INV_AREA!" + this.initNumbers.get(i)));
            dfpv.set("level", (Object)1);
            dfpv.set("propertyid", (Object)save[0].getLong("id"));
            dfpv.set("model", (Object)modelId);
            dfpv.set("dimension", (Object)dimId);
            initPropertys[i - 1] = dfpv;
        }
        DynamicObject[] initResult = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])initPropertys);
        return initResult;
    }

    private DynamicObject[] createExtDimBizGroupMem(DynamicObject dy, long dimId, DynamicObject[] extDimInitProperty, long modelId) {
        DynamicObject[] dynamicObjects = this.saveBizGroupMember(dy, dimId, modelId);
        List<Object> collect = new ArrayList<DynamicObject>();
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            collect = Arrays.stream(dynamicObjects).filter(x -> !x.getString("number").equals(this.getXNoneNumber())).collect(Collectors.toList());
        } else {
            LOG.error("class:ExtDimEditPlugin,method:createExtDimBizGroupMem save error");
        }
        return this.saveFieldMember(collect, dimId, extDimInitProperty, modelId);
    }

    private DynamicObject[] saveFieldMember(List<DynamicObject> dys, long dimId, DynamicObject[] extDimInitProperty, long modelId) {
        DynamicObject[] memlist = new DynamicObject[this.numbers.size()];
        DynamicObject[] memTreelist = new DynamicObject[this.numbers.size()];
        DynamicObject dy = dys.stream().filter(x -> "INTR".equals(x.getString("number"))).findFirst().get();
        DynamicObject dyVest = dys.stream().filter(x -> "INVEST".equals(x.getString("number"))).findFirst().get();
        DynamicObject datArea = Arrays.stream(extDimInitProperty).filter(x -> "DatArea".equals(x.getString("number"))).findFirst().get();
        DynamicObject jnIArea = Arrays.stream(extDimInitProperty).filter(x -> "JnIArea".equals(x.getString("number"))).findFirst().get();
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        List<LocaleString> extMemsNames = ExtDimEditConstant.extMemsNames;
        for (int i = 0; i < this.numbers.size(); ++i) {
            DynamicObject extDimMem = BusinessDataServiceHelper.newDynamicObject((String)"bcm_membofextend");
            extDimMem.set("name", (Object)extMemsNames.get(i));
            extDimMem.set("number", (Object)this.numbers.get(i));
            extDimMem.set("simplename", (Object)extMemsNames.get(i));
            extDimMem.set("dimension", (Object)dimId);
            extDimMem.set("model", (Object)modelId);
            extDimMem.set("creator", (Object)currUserId);
            extDimMem.set("createtime", (Object)date);
            extDimMem.set("modifier", (Object)currUserId);
            extDimMem.set("modifytime", (Object)date);
            extDimMem.set("status", (Object)"C");
            extDimMem.set("enable", (Object)"1");
            memlist[i] = extDimMem;
        }
        DynamicObject[] memResult = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])memlist);
        List<LocaleString> equityOffsetSims = ExtDimEditConstant.equityOffsetSims;
        for (int i = 0; i < this.numbers.size(); ++i) {
            DynamicObject extDimMemTree = BusinessDataServiceHelper.newDynamicObject((String)"bcm_structofextend");
            extDimMemTree.set("name", (Object)extMemsNames.get(i));
            extDimMemTree.set("number", (Object)this.numbers.get(i));
            extDimMemTree.set("description", (Object)extMemsNames.get(i));
            extDimMemTree.set("model", (Object)modelId);
            extDimMemTree.set("isleaf", (Object)"1");
            extDimMemTree.set("level", (Object)"3");
            extDimMemTree.set("issysmember", (Object)1);
            extDimMemTree.set("dimension", (Object)dimId);
            String number = this.numbers.get(i);
            List member = Arrays.stream(memResult).filter(x -> number.equals(x.getString("number"))).collect(Collectors.toList());
            extDimMemTree.set("member", (Object)((DynamicObject)member.get(0)).getLong("id"));
            extDimMemTree.set("creator", (Object)currUserId);
            extDimMemTree.set("createtime", (Object)date);
            extDimMemTree.set("modifier", (Object)currUserId);
            extDimMemTree.set("modifytime", (Object)date);
            extDimMemTree.set("storagetype", (Object)StorageTypeEnum.STORAGE.getOIndex());
            extDimMemTree.set("datatype", (Object)this.datatypes.get(i));
            if ("6".equals(this.datatypes.get(i))) {
                this.setEnumValue(dimId, extDimMemTree, i);
            }
            extDimMemTree.set("exchange", (Object)this.exchanges.get(i));
            extDimMemTree.set("entryrate", (Object)this.entryrates.get(i));
            extDimMemTree.set("status", (Object)"C");
            extDimMemTree.set("enable", (Object)"1");
            extDimMemTree.set("dseq", (Object)(3 + i));
            if (i >= 22) {
                extDimMemTree.set("longnumber", (Object)(dyVest.getString("longnumber") + '!' + this.numbers.get(i)));
                extDimMemTree.set("simplename", (Object)equityOffsetSims.get(i - 22));
                extDimMemTree.set("parent", (Object)dyVest.getLong("id"));
                extDimMemTree.set("fieldmapped", (Object)"");
                if (i < 40) {
                    extDimMemTree.set("dpropertyid1", (Object)datArea.getLong("id"));
                } else {
                    extDimMemTree.set("dpropertyid1", (Object)jnIArea.getLong("id"));
                }
            } else {
                this.mappingFieldassignment(extDimMemTree, this.datatypes.get(i), this.mappingNums.get(i), modelId);
                extDimMemTree.set("longnumber", (Object)(dy.getString("longnumber") + '!' + this.numbers.get(i)));
                extDimMemTree.set("simplename", (Object)extMemsNames.get(i));
                extDimMemTree.set("parent", (Object)dy.getLong("id"));
            }
            memTreelist[i] = extDimMemTree;
        }
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])memTreelist);
    }

    private void setEnumValue(Long dimId, DynamicObject extDimMemTree, int i) {
        QFilter filter = new QFilter("dimension", "=", (Object)dimId);
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_enumitem", (String)"id, name", (QFilter[])new QFilter[]{filter});
        if (dcs == null || dcs.size() < 4) {
            throw new KDBizException("Error in preset enumeration value");
        }
        if (i == 0) {
            List collect = dcs.stream().filter(x -> ResManager.loadKDString((String)"\u662f\u5426\u5dee\u989d", (String)"ExtDimEditPlugin_200", (String)"fi-bcm-formplugin", (Object[])new Object[0]).equals(x.getString("name"))).collect(Collectors.toList());
            extDimMemTree.set("enumitem", (Object)((DynamicObject)collect.get(0)).getLong("id"));
        } else if (i == 1) {
            List collect = dcs.stream().filter(x -> ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b", (String)"ExtDimEditPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]).equals(x.getString("name"))).collect(Collectors.toList());
            extDimMemTree.set("enumitem", (Object)((DynamicObject)collect.get(0)).getLong("id"));
        } else if (i == 18 || i == 20) {
            List collect = dcs.stream().filter(x -> ResManager.loadKDString((String)"\u8d22\u5e74", (String)"ExtDimEditPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]).equals(x.getString("name"))).collect(Collectors.toList());
            extDimMemTree.set("enumitem", (Object)((DynamicObject)collect.get(0)).getLong("id"));
        } else {
            List collect = dcs.stream().filter(x -> ResManager.loadKDString((String)"\u671f\u95f4", (String)"ExtDimEditPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]).equals(x.getString("name"))).collect(Collectors.toList());
            extDimMemTree.set("enumitem", (Object)((DynamicObject)collect.get(0)).getLong("id"));
        }
    }

    private void mappingFieldassignment(DynamicObject extDimMemTree, String datatype, String mappingNum, long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("level", "=", (Object)3));
        String fieldMapping = "";
        switch (datatype) {
            case "3": 
            case "6": {
                fieldMapping = FTEXTEXT + mappingNum;
                break;
            }
            case "0": 
            case "1": 
            case "2": 
            case "5": {
                fieldMapping = FNUMEXT + mappingNum;
                break;
            }
            case "4": {
                fieldMapping = FDATEEXT + mappingNum;
                break;
            }
        }
        extDimMemTree.set("fieldmapped", (Object)fieldMapping);
    }

    private DynamicObject[] saveBizGroupMember(DynamicObject dy, long dimId, long modelId) {
        DynamicObject extDimMem1 = BusinessDataServiceHelper.newDynamicObject((String)"bcm_membofextend");
        extDimMem1.set("name", (Object)ResManager.getLocaleString((String)"\u9ed8\u8ba4\u4e1a\u52a1\u5206\u7ec4", (String)"ExtDimEditPlugin_0", (String)"fi-bcm-formplugin"));
        extDimMem1.set("number", (Object)this.getXNoneNumber());
        extDimMem1.set("simplename", (Object)ResManager.getLocaleString((String)"\u9ed8\u8ba4\u4e1a\u52a1\u5206\u7ec4", (String)"ExtDimEditPlugin_0", (String)"fi-bcm-formplugin"));
        extDimMem1.set("dimension", (Object)dimId);
        extDimMem1.set("model", (Object)modelId);
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        extDimMem1.set("creator", (Object)currUserId);
        extDimMem1.set("createtime", (Object)date);
        extDimMem1.set("modifier", (Object)currUserId);
        extDimMem1.set("modifytime", (Object)date);
        extDimMem1.set("status", (Object)"C");
        extDimMem1.set("enable", (Object)"1");
        DynamicObject extDimMem2 = BusinessDataServiceHelper.newDynamicObject((String)"bcm_membofextend");
        extDimMem2.set("name", (Object)ResManager.getLocaleString((String)"\u5185\u90e8\u4ea4\u6613\u4e1a\u52a1\u5206\u7ec4", (String)"ExtDimEditPlugin_1", (String)"fi-bcm-formplugin"));
        extDimMem2.set("number", (Object)"INTR");
        extDimMem2.set("simplename", (Object)ResManager.getLocaleString((String)"\u5185\u90e8\u4ea4\u6613\u4e1a\u52a1\u5206\u7ec4", (String)"ExtDimEditPlugin_1", (String)"fi-bcm-formplugin"));
        extDimMem2.set("dimension", (Object)dimId);
        extDimMem2.set("model", (Object)modelId);
        extDimMem2.set("creator", (Object)currUserId);
        extDimMem2.set("createtime", (Object)date);
        extDimMem2.set("modifier", (Object)currUserId);
        extDimMem2.set("modifytime", (Object)date);
        extDimMem2.set("status", (Object)"C");
        extDimMem2.set("enable", (Object)"1");
        DynamicObject extDimMem3 = BusinessDataServiceHelper.newDynamicObject((String)"bcm_membofextend");
        extDimMem3.set("name", (Object)ResManager.getLocaleString((String)"\u6743\u76ca\u62b5\u9500\u4e1a\u52a1\u5206\u7ec4", (String)"ExtDimEditPlugin_74", (String)"fi-bcm-formplugin"));
        extDimMem3.set("number", (Object)"INVEST");
        extDimMem3.set("simplename", (Object)ResManager.getLocaleString((String)"\u6743\u76ca\u62b5\u9500\u4e1a\u52a1\u5206\u7ec4", (String)"ExtDimEditPlugin_74", (String)"fi-bcm-formplugin"));
        extDimMem3.set("dimension", (Object)dimId);
        extDimMem3.set("model", (Object)modelId);
        extDimMem3.set("creator", (Object)currUserId);
        extDimMem3.set("createtime", (Object)date);
        extDimMem3.set("modifier", (Object)currUserId);
        extDimMem3.set("modifytime", (Object)date);
        extDimMem3.set("status", (Object)"C");
        extDimMem3.set("enable", (Object)"1");
        DynamicObject[] result = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{extDimMem1, extDimMem2, extDimMem3});
        DynamicObject extDimMemTree1 = BusinessDataServiceHelper.newDynamicObject((String)"bcm_structofextend");
        extDimMemTree1.set("name", (Object)ResManager.getLocaleString((String)"\u9ed8\u8ba4\u4e1a\u52a1\u5206\u7ec4", (String)"ExtDimEditPlugin_0", (String)"fi-bcm-formplugin"));
        extDimMemTree1.set("number", (Object)this.getXNoneNumber());
        extDimMemTree1.set("longnumber", (Object)(dy.getString("longnumber") + '!' + this.getXNoneNumber()));
        extDimMemTree1.set("simplename", (Object)ResManager.getLocaleString((String)"\u9ed8\u8ba4\u4e1a\u52a1\u5206\u7ec4", (String)"ExtDimEditPlugin_0", (String)"fi-bcm-formplugin"));
        extDimMemTree1.set("description", (Object)ResManager.getLocaleString((String)"\u9ed8\u8ba4\u4e1a\u52a1\u5206\u7ec4", (String)"ExtDimEditPlugin_0", (String)"fi-bcm-formplugin"));
        extDimMemTree1.set("storagetype", (Object)StorageTypeEnum.LABEL.getOIndex());
        extDimMemTree1.set("datatype", (Object)DataTypeEnum.TXT.getOIndex());
        extDimMemTree1.set("grouptype", (Object)"1");
        extDimMemTree1.set("isparticipmerge", (Object)Boolean.FALSE);
        extDimMemTree1.set("isaccountoffset", (Object)Boolean.FALSE);
        extDimMemTree1.set("value", (Object)0);
        extDimMemTree1.set("parent", (Object)dy.getLong("id"));
        extDimMemTree1.set("level", (Object)2);
        extDimMemTree1.set("isleaf", (Object)"1");
        extDimMemTree1.set("issysmember", (Object)1);
        extDimMemTree1.set("dimension", (Object)dimId);
        extDimMemTree1.set("model", (Object)modelId);
        List numberXNone = Arrays.stream(result).filter(x -> this.getXNoneNumber().equals(x.getString("number"))).collect(Collectors.toList());
        extDimMemTree1.set("member", (Object)((DynamicObject)numberXNone.get(0)).getLong("id"));
        extDimMemTree1.set("creator", (Object)currUserId);
        extDimMemTree1.set("createtime", (Object)date);
        extDimMemTree1.set("modifier", (Object)currUserId);
        extDimMemTree1.set("modifytime", (Object)date);
        extDimMemTree1.set("status", (Object)"C");
        extDimMemTree1.set("enable", (Object)"1");
        extDimMemTree1.set("dseq", (Object)"1");
        DynamicObject extDimMemTree2 = BusinessDataServiceHelper.newDynamicObject((String)"bcm_structofextend");
        extDimMemTree2.set("name", (Object)ResManager.getLocaleString((String)"\u5185\u90e8\u4ea4\u6613\u4e1a\u52a1\u5206\u7ec4", (String)"ExtDimEditPlugin_1", (String)"fi-bcm-formplugin"));
        extDimMemTree2.set("number", (Object)"INTR");
        extDimMemTree2.set("longnumber", (Object)(dy.getString("longnumber") + '!' + "INTR"));
        extDimMemTree2.set("simplename", (Object)ResManager.getLocaleString((String)"\u5185\u90e8\u4ea4\u6613\u4e1a\u52a1\u5206\u7ec4", (String)"ExtDimEditPlugin_1", (String)"fi-bcm-formplugin"));
        extDimMemTree2.set("description", (Object)ResManager.getLocaleString((String)"\u5185\u90e8\u4ea4\u6613\u4e1a\u52a1\u5206\u7ec4", (String)"ExtDimEditPlugin_1", (String)"fi-bcm-formplugin"));
        extDimMemTree2.set("storagetype", (Object)StorageTypeEnum.LABEL.getOIndex());
        extDimMemTree2.set("datatype", (Object)DataTypeEnum.TXT.getOIndex());
        extDimMemTree2.set("grouptype", (Object)"2");
        extDimMemTree2.set("isparticipmerge", (Object)Boolean.TRUE);
        extDimMemTree2.set("isaccountoffset", (Object)Boolean.TRUE);
        extDimMemTree2.set("value", (Object)0);
        extDimMemTree2.set("parent", (Object)dy.getLong("id"));
        extDimMemTree2.set("level", (Object)2);
        extDimMemTree2.set("isleaf", (Object)"0");
        extDimMemTree2.set("issysmember", (Object)1);
        extDimMemTree2.set("dimension", (Object)dimId);
        extDimMemTree2.set("model", (Object)modelId);
        List numberINTR = Arrays.stream(result).filter(x -> "INTR".equals(x.getString("number"))).collect(Collectors.toList());
        extDimMemTree2.set("member", (Object)((DynamicObject)numberINTR.get(0)).getLong("id"));
        extDimMemTree2.set("creator", (Object)currUserId);
        extDimMemTree2.set("createtime", (Object)date);
        extDimMemTree2.set("modifier", (Object)currUserId);
        extDimMemTree2.set("modifytime", (Object)date);
        extDimMemTree2.set("status", (Object)"C");
        extDimMemTree2.set("enable", (Object)"1");
        extDimMemTree2.set("dseq", (Object)"2");
        DynamicObject extDimMemTree3 = BusinessDataServiceHelper.newDynamicObject((String)"bcm_structofextend");
        extDimMemTree3.set("name", (Object)ResManager.getLocaleString((String)"\u6743\u76ca\u62b5\u9500\u4e1a\u52a1\u5206\u7ec4", (String)"ExtDimEditPlugin_74", (String)"fi-bcm-formplugin"));
        extDimMemTree3.set("number", (Object)"INVEST");
        extDimMemTree3.set("longnumber", (Object)(dy.getString("longnumber") + '!' + "INVEST"));
        extDimMemTree3.set("simplename", (Object)ResManager.getLocaleString((String)"\u6743\u76ca\u62b5\u9500\u4e1a\u52a1\u5206\u7ec4", (String)"ExtDimEditPlugin_74", (String)"fi-bcm-formplugin"));
        extDimMemTree3.set("description", (Object)ResManager.getLocaleString((String)"\u6743\u76ca\u62b5\u9500\u4e1a\u52a1\u5206\u7ec4", (String)"ExtDimEditPlugin_74", (String)"fi-bcm-formplugin"));
        extDimMemTree3.set("storagetype", (Object)StorageTypeEnum.LABEL.getOIndex());
        extDimMemTree3.set("datatype", (Object)DataTypeEnum.TXT.getOIndex());
        extDimMemTree3.set("grouptype", (Object)"3");
        extDimMemTree3.set("isparticipmerge", (Object)Boolean.FALSE);
        extDimMemTree3.set("isaccountoffset", (Object)Boolean.FALSE);
        extDimMemTree3.set("value", (Object)0);
        extDimMemTree3.set("parent", (Object)dy.getLong("id"));
        extDimMemTree3.set("level", (Object)2);
        extDimMemTree3.set("isleaf", (Object)"0");
        extDimMemTree3.set("issysmember", (Object)1);
        extDimMemTree3.set("dimension", (Object)dimId);
        extDimMemTree3.set("model", (Object)modelId);
        List numberINVEST = Arrays.stream(result).filter(x -> "INVEST".equals(x.getString("number"))).collect(Collectors.toList());
        extDimMemTree3.set("member", (Object)((DynamicObject)numberINVEST.get(0)).getLong("id"));
        extDimMemTree3.set("creator", (Object)currUserId);
        extDimMemTree3.set("createtime", (Object)date);
        extDimMemTree3.set("modifier", (Object)currUserId);
        extDimMemTree3.set("modifytime", (Object)date);
        extDimMemTree3.set("status", (Object)"C");
        extDimMemTree3.set("enable", (Object)"1");
        extDimMemTree3.set("dseq", (Object)"3");
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{extDimMemTree1, extDimMemTree2, extDimMemTree3});
    }

    private DynamicObject[] seveInExtDim(long modelId) {
        DynamicObject extDim = BusinessDataServiceHelper.newDynamicObject((String)"bcm_dimension_ext");
        extDim.set("name", this.getModel().getValue("name"));
        extDim.set("number", this.getModel().getValue("number"));
        extDim.set("description", this.getModel().getValue("description"));
        extDim.set("shortnumber", this.getModel().getValue("shortnumber"));
        extDim.set("isuseddataperm", this.getModel().getValue("isuseddataperm"));
        extDim.set("storagetype", (Object)StorageTypeEnum.UNSHARE.getOIndex());
        extDim.set("model", (Object)modelId);
        extDim.set("status", (Object)"C");
        extDim.set("enable", (Object)"1");
        extDim.set("dseq", (Object)30);
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{extDim});
    }

    private DynamicObject[] seveInExtDimMemTree(long dimId, long modelId) {
        DynamicObject extDimMem = BusinessDataServiceHelper.newDynamicObject((String)"bcm_membofextend");
        extDimMem.set("name", this.getModel().getValue("name"));
        extDimMem.set("number", this.getModel().getValue("number"));
        extDimMem.set("simplename", this.getModel().getValue("name"));
        extDimMem.set("dimension", (Object)dimId);
        extDimMem.set("model", (Object)modelId);
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        extDimMem.set("creator", (Object)currUserId);
        extDimMem.set("createtime", (Object)date);
        extDimMem.set("modifier", (Object)currUserId);
        extDimMem.set("modifytime", (Object)date);
        extDimMem.set("status", (Object)"C");
        extDimMem.set("enable", (Object)"1");
        DynamicObject[] save = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{extDimMem});
        DynamicObject extDimMemTree = BusinessDataServiceHelper.newDynamicObject((String)"bcm_structofextend");
        extDimMemTree.set("name", this.getModel().getValue("name"));
        extDimMemTree.set("number", this.getModel().getValue("number"));
        extDimMemTree.set("longnumber", this.getModel().getValue("number"));
        extDimMemTree.set("simplename", this.getModel().getValue("name"));
        extDimMemTree.set("description", this.getModel().getValue("description"));
        extDimMemTree.set("storagetype", (Object)StorageTypeEnum.LABEL.getOIndex());
        extDimMemTree.set("datatype", (Object)DataTypeEnum.TXT.getOIndex());
        extDimMemTree.set("grouptype", (Object)"1");
        extDimMemTree.set("isparticipmerge", (Object)Boolean.FALSE);
        extDimMemTree.set("isaccountoffset", (Object)Boolean.FALSE);
        extDimMemTree.set("value", (Object)0L);
        extDimMemTree.set("parent", (Object)0L);
        extDimMemTree.set("level", (Object)1);
        extDimMemTree.set("isleaf", (Object)"0");
        extDimMemTree.set("issysmember", (Object)1);
        extDimMemTree.set("dimension", (Object)dimId);
        extDimMemTree.set("model", (Object)modelId);
        extDimMemTree.set("member", (Object)(save != null && save.length > 0 ? save[0].getLong("id") : 0L));
        extDimMemTree.set("creator", (Object)currUserId);
        extDimMemTree.set("createtime", (Object)date);
        extDimMemTree.set("modifier", (Object)currUserId);
        extDimMemTree.set("modifytime", (Object)date);
        extDimMemTree.set("status", (Object)"C");
        extDimMemTree.set("enable", (Object)"1");
        extDimMemTree.set("dseq", (Object)"0");
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{extDimMemTree});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"storagetype", "number", "shortnumber", "isuseddataperm"});
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        long modelId = (Long)formShowParameter.getCustomParam("model");
        this.getPageCache().put("modelId", String.valueOf(modelId));
        if ("ADDNEW".equals(formShowParameter.getStatus().toString())) {
            this.getModel().setValue("name", (Object)ResManager.getLocaleString((String)"\u62d3\u5c55\u7ef4", (String)"DimensionDisplayList_191", (String)"fi-bcm-formplugin"));
            this.getModel().setValue("description", (Object)ResManager.getLocaleString((String)"\u53ef\u9009\u9884\u7f6e", (String)"ExtDimEditPlugin_182", (String)"fi-bcm-formplugin"));
            QFilter qf = new QFilter("model", "=", (Object)modelId);
            DynamicObjectCollection bcm_dimension = QueryServiceHelper.query((String)"bcm_dimension", (String)"number,shortnumber", (QFilter[])qf.toArray());
            Iterator iterator = bcm_dimension.iterator();
            boolean flag1 = false;
            boolean flag2 = false;
            this.getModel().setValue("number", (Object)"Extends");
            this.getModel().setValue("shortnumber", (Object)"X");
            while (iterator.hasNext()) {
                DynamicObject next = (DynamicObject)iterator.next();
                if (flag1 && flag2) break;
                if (!flag1 && "Extends".equalsIgnoreCase((String)next.get("number"))) {
                    flag1 = true;
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"number"});
                    this.getModel().setValue("number", (Object)"");
                }
                if (flag2 || !"X".equalsIgnoreCase((String)next.get("shortnumber"))) continue;
                flag2 = true;
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"shortnumber"});
                this.getModel().setValue("shortnumber", (Object)"");
            }
            StringBuilder sb = new StringBuilder();
            if (flag1) {
                sb.append(ResManager.loadKDString((String)"\u3010\u9ed8\u8ba4\u7f16\u7801\u3011", (String)"ExtDimEditPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"number"});
                if (flag2) {
                    sb.append("\u3001");
                    sb.append(ResManager.loadKDString((String)"\u3010\u7b80\u7801\u3011", (String)"ExtDimEditPlugin_60", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"shortnumber"});
                }
            } else if (flag2) {
                sb.append(ResManager.loadKDString((String)"\u3010\u7b80\u7801\u3011", (String)"ExtDimEditPlugin_60", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"shortnumber"});
            }
            if (flag1 || flag2) {
                this.getView().showTipNotification(sb.append(ResManager.loadKDString((String)"\u91cd\u590d\uff0c\u5141\u8bb8\u7f16\u8f91", (String)"ExtDimEditPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0])).toString());
            }
        } else if ("EDIT".equals(formShowParameter.getStatus().toString())) {
            this.getModel().setValue("name", formShowParameter.getCustomParam("name"));
            this.getModel().setValue("number", formShowParameter.getCustomParam("number"));
            this.getModel().setValue("shortnumber", formShowParameter.getCustomParam("shortnumber"));
            this.getModel().setValue("isuseddataperm", formShowParameter.getCustomParam("isuseddataperm"));
            this.getModel().setValue("description", formShowParameter.getCustomParam("description"));
        }
    }

    private void writeOpLog(String op, String logs, Long modelId) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)op, (String)logs, (Long)modelId, (String)this.getModel().getDataEntityType().getName());
        logService.addLog(logInfo);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        this.getPageCache().put("modelId", String.valueOf(modelId));
    }
}

