/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.cache.Cache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.ExtDimensionHelper;
import kd.fi.bcm.business.dimension.helper.MemberServiceHelper;
import kd.fi.bcm.business.dimension.helper.SaveDimMemberHelper;
import kd.fi.bcm.business.dimension.util.ModelUtil;
import kd.fi.bcm.business.export.strategy.ExportExecuteStrategyContext;
import kd.fi.bcm.business.export.strategy.ExtendsPropertyExportStrategy;
import kd.fi.bcm.business.export.strategy.IExport;
import kd.fi.bcm.business.extdata.ExportExtModelServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.mq.consumer.MQMessagePublisherServiceHelper;
import kd.fi.bcm.business.papertemplate.PaperTemplateService;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.LogConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.factory.CacheGenFactory;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.log.DimMemberOperateTypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.dimension.action.DimemberBaseAction;
import kd.fi.bcm.formplugin.dimension.factory.DimensionFactory;
import kd.fi.bcm.formplugin.dimension.search.DimensionMemberSearch;
import kd.fi.bcm.formplugin.dimension.search.helper.SearchCacheManager;
import kd.fi.bcm.formplugin.tree.dimension.ICEntityTreeBuilder;
import kd.fi.bcm.formplugin.tree.dimension.ICEntityTreeNode;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public class ExtendsDisplayList
extends AbstractBaseFormPlugin
implements BeforeF7SelectListener,
ClickListener,
HyperLinkClickListener,
TabSelectListener,
TreeNodeClickListener {
    protected static final WatchLogger log = BcmLogFactory.getWatchLogInstance(ExtendsDisplayList.class);
    protected static final String BAR_ITEM_ADD_SUB = "baritemaddsub";
    protected static final String BAR_ITEM_ADD_LEVEL = "baritemaddlevel";
    protected static final String BAR_ITEM_ADD_SHARE = "baritemaddshare";
    protected static final String BAR_ITEM_DEL = "baritemdel";
    protected static final String BAR_ITEM_CUT = "baritemcut";
    protected static final String BAR_ITEM_PASTE = "baritempaste";
    protected static final String BAR_IMPORT_CC = "barimportcc";
    protected static final String BAR_EXPORT_CC = "barexportcc";
    protected static final String DEFINED_PROPERTY = "definedproperty";
    protected static final String NEW_ENUM_TYPE = "newenumtype";
    protected static final String NEW_ENUM = "newenum";
    protected static final String BAR_ITEM_REFRESH = "baritemrefresh";
    protected static final String BTN_ADD_MODEL = "btn_add";
    protected static final String BTN_DELETE = "btn_delete";
    protected static final String BTN_ENABLE = "btn_enable";
    protected static final String BTN_UNABLE = "btn_unable";
    protected static final String BTN_EXPORT = "btn_export";
    protected static final String BTN_IMPORT = "btn_import";
    protected static final String BTN_DATADUMP = "btn_datadump";
    protected static final String BTN_REFRESH = "btn_refresh";
    protected static final String MODEL_KEY = "model";
    protected static final String TREE_VIEW_AP = "treeviewap";
    protected static final String BTN_ADD = "btnadd";
    protected static final String BTN_EDIT = "btnedit";
    protected static final String TOOL_BARAP_MODEL = "toolbarapmodel";
    protected static final String TOOL_BARAP_MEMBER = "toolbarapmember";
    protected static final String BILL_LIST_MODEL = "billlistapmodel";
    protected static final String BILL_LIST_MEMBER = "billlistapmember";
    protected static final String EXT_TREE_CLICK_CACHE = "extdimtreenodeclick";
    protected static final String CUR_TAB_KEY_CACHE = "currentTabKey";
    protected static final String EXT_DIM_ID = "extDimId";
    private static final String EXTFIELD_NUM = "ExtField_Num";
    private static final String EXTFIELD_TEXT = "ExtField_Text";
    private static final String EXTFIELD_DATE = "ExtField_Date";
    private static final String textPrefix = "textext";
    private static final String numPrefix = "numext";
    private static final String datePrefix = "dateext";

    @Override
    public void initialize() {
        super.initialize();
        TreeView tree = (TreeView)this.getControl(TREE_VIEW_AP);
        tree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                ExtendsDisplayList.this.nodeClick(evt);
            }
        });
        BillList billListMem = (BillList)this.getControl(BILL_LIST_MEMBER);
        billListMem.addPackageDataListener(evt -> this.setDpropertyValue((PackageDataEvent)evt));
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String formId = e.getFormShowParameter().getFormId();
        long currUserId = RequestContext.get().getCurrUserId();
        if (!PermissionServiceHelper.hasViewPermission((long)currUserId, (String)AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.CM.getAppnum()).getId(), (String)formId)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u4efb\u4f55\u62a5\u8868\u4f53\u7cfb\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u4f53\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UserSelectUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(TOOL_BARAP_MODEL, TOOL_BARAP_MEMBER);
        this.addClickListeners(BTN_ADD, BTN_EDIT);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(MODEL_KEY);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BillList billListMem = (BillList)this.getControl(BILL_LIST_MEMBER);
        billListMem.addHyperClickListener(evt -> this.memberHyperLinkClick(evt));
        billListMem.addSetFilterListener(event -> {
            QFilter qFilter = this.addExtEntityFilter();
            event.getQFilters().add(qFilter);
            event.setOrderBy("level,dseq");
        });
        billListMem.addPackageDataListener(evt -> this.setDpropertyValue((PackageDataEvent)evt));
        BillList billListModel = (BillList)this.getControl(BILL_LIST_MODEL);
        billListModel.addHyperClickListener(evt -> this.modelHyperLinkClick(evt));
        billListModel.addSetFilterListener(event -> {
            String groupId = this.getPageCache().get(EXT_TREE_CLICK_CACHE);
            QFilter qf = new QFilter(MODEL_KEY, "=", (Object)this.getModelId());
            if (StringUtils.isNotEmpty((String)groupId) && !"0".equals(groupId)) {
                QFilter qFilter = new QFilter(MODEL_KEY, "=", (Object)this.getModelId());
                qFilter.and("id", "=", (Object)Long.parseLong(groupId));
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_structofextend", (String)"parent", (QFilter[])qFilter.toArray());
                if (dynamicObject != null && dynamicObject.getLong("parent") != 0L) {
                    qf.and("extendsgroup", "=", (Object)Long.parseLong(groupId));
                }
            }
            event.getQFilters().add(qf);
            event.setOrderBy("id");
        });
    }

    private void setDpropertyValue(PackageDataEvent evt) {
        DynamicObject row = evt.getRowData();
        StringBuilder dpropertyId = new StringBuilder();
        for (int i = 1; i <= 10; ++i) {
            String str;
            if (Objects.isNull(row.get("dpropertyid" + i)) || !StringUtils.isNotEmpty((String)(str = row.getString("dpropertyid" + i + ".name")))) continue;
            if (str.contains(";")) break;
            dpropertyId.append(str);
            dpropertyId.append(";");
        }
        if (StringUtils.isNotEmpty((String)dpropertyId.toString())) {
            row.set("status", (Object)dpropertyId.toString());
        } else {
            row.set("status", (Object)"");
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), MODEL_KEY);
        if (modelId == null || modelId.equals("0")) {
            this.setToolBarVisible(Boolean.FALSE);
            return;
        }
        this.getModel().setValue(MODEL_KEY, (Object)modelId);
        this.getPageCache().put("KEY_MODEL_ID", modelId);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String modelStr = this.getPageCache().get("KEY_MODEL_ID");
        if (StringUtils.isEmpty((String)modelStr)) {
            this.setToolBarVisible(Boolean.FALSE);
            return;
        }
        this.updateExtDimCache(this.getPageCache().get("KEY_MODEL_ID"));
        String extDimId = this.getPageCache().get(EXT_DIM_ID);
        if (StringUtils.isEmpty((String)extDimId)) {
            this.setToolBarVisible(Boolean.FALSE);
        }
        this.initExtDimTreeView(null);
        this.setVisiableOfPro();
    }

    private void setToolBarVisible(boolean visible) {
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{BTN_ADD_MODEL, BTN_DELETE, BTN_ENABLE, BTN_UNABLE, BTN_EXPORT, BTN_IMPORT, BTN_DATADUMP, BAR_ITEM_ADD_SUB, BAR_ITEM_ADD_LEVEL, BAR_ITEM_ADD_SHARE, BAR_ITEM_DEL, BAR_ITEM_CUT, BAR_ITEM_PASTE, BAR_IMPORT_CC, BAR_EXPORT_CC, DEFINED_PROPERTY, "baritemmove", "baritemap", "baritemmenberap"});
        this.getView().setVisible(Boolean.valueOf(ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"isOpenNewEnum")), new String[]{NEW_ENUM});
        this.getView().setVisible(Boolean.valueOf(!ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"isOpenNewEnum")), new String[]{NEW_ENUM_TYPE});
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "baritemaddsub": {
                this.addNewExtDim(key);
                break;
            }
            case "baritemaddshare": {
                this.addShare();
                break;
            }
            case "baritemdel": {
                this.deleteMember();
                break;
            }
            case "baritemcut": 
            case "baritempaste": {
                this.memberCutAndPaste(key);
                break;
            }
            case "barexportcc": {
                this.barexportcc();
                break;
            }
            case "barimportcc": {
                this.barimportcc();
                break;
            }
            case "definedproperty": {
                this.definedproperty();
                break;
            }
            case "newenumtype": {
                this.enumEvent();
                break;
            }
            case "newenum": {
                this.newEnum();
                break;
            }
            case "btn_add": {
                if (this.getValue(MODEL_KEY) == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ExtendsModelListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.openNewFormPage();
                break;
            }
            case "btn_delete": {
                BillList billlist = (BillList)this.getControl(BILL_LIST_MODEL);
                ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
                if (selectedRows == null || selectedRows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u6a21\u578b\u3002", (String)"ExtendsModelListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                List selectRowNums = selectedRows.stream().map(o -> o.getNumber()).collect(Collectors.toList());
                if (selectRowNums.contains("INTR_SALE") || selectRowNums.contains("INTR_PURCHASE") || selectRowNums.contains("INTR_CONSOL") || selectRowNums.contains("INVEST")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u7684\u62d3\u5c55\u6570\u636e\u6a21\u578b\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ExtendsModelListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                List selectRowIds = selectedRows.stream().map(o -> (Long)o.getPrimaryKeyValue()).collect(Collectors.toList());
                if (QueryServiceHelper.exists((String)"bcm_isscheme", (QFilter[])new QFilter[]{new QFilter("extendsmodel", "in", selectRowIds)})) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u88ab\u96c6\u6210\u65b9\u6848\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5\u6216\u5220\u9664\u62d3\u5c55\u6570\u636e\u6a21\u578b\u3002", (String)"ExtendsModelListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.checkDeleteStatus(selectedRows)) {
                    ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("model_delete_close", (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u9009\u4e2d\u6570\u636e\u6a21\u578b\u5417\uff1f", (String)"ExtendsModelListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u6570\u636e\u6a21\u578b\u6709\u62a5\u8868\u6a21\u677f\u3001\u6743\u76ca\u62b5\u9500\u5e95\u7a3f\u6a21\u677f\u6216\u5185\u90e8\u4ea4\u6613\u5e95\u7a3f\u6a21\u677f\u5f15\u7528\uff0c\u6216\u5df2\u6709\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"ExtendsModelListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "btn_enable": {
                this.updateStatus("1");
                break;
            }
            case "btn_unable": {
                this.updateStatus("0");
                break;
            }
            case "btn_import": {
                this.openImportFormPage();
                break;
            }
            case "btn_export": {
                BillList billlist1 = (BillList)this.getControl(BILL_LIST_MODEL);
                ListSelectedRowCollection selectedRows1 = billlist1.getSelectedRows();
                if (selectedRows1 == null || selectedRows1.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u6570\u636e\u6a21\u578b\u3002", (String)"ExtendsModelListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.exportModelData(selectedRows1);
                OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u5bfc\u51fa\u62d3\u5c55\u6570\u636e\u6a21\u578b", "ExtendsModelListPlugin_12", "fi-bcm-formplugin", "exportExtModel");
                this.writeOperationLog(opName, "");
                break;
            }
            case "btn_datadump": {
                this.extendsDataDump();
                break;
            }
            case "baritemrefresh": 
            case "btn_refresh": {
                this.initExtDimTreeView(this.getPageCache().get(EXT_TREE_CLICK_CACHE));
                break;
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (this.getModelId() == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ExtendsModelListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qf = new QFilter(MODEL_KEY, "=", (Object)this.getModelId());
        boolean exists = QueryServiceHelper.exists((String)"bcm_dimension_ext", (QFilter[])qf.toArray());
        switch (key) {
            case "btnadd": {
                if (exists) {
                    this.addNewExtDim(BTN_ADD);
                    break;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u4e0d\u53ef\u9006\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ExtendsDisplayList_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("new_extends_model", (IFormPlugin)this));
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "model": {
                Object value = this.getModel().getValue(MODEL_KEY);
                if (value != null) {
                    DynamicObject modelDy = (DynamicObject)value;
                    this.initExtDimTreeView(null);
                    String modelId = modelDy.getString("id");
                    UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
                    this.getPageCache().put("KEY_MODEL_ID", modelId);
                    this.updateExtDimCache(modelId);
                    if (StringUtils.isEmpty((String)this.getPageCache().get(EXT_DIM_ID))) {
                        this.setToolBarVisible(Boolean.FALSE);
                        break;
                    }
                    this.setToolBarVisible(Boolean.TRUE);
                    break;
                }
                Object oldValue = e.getChangeSet()[0].getOldValue();
                this.getModel().setValue(MODEL_KEY, oldValue);
                break;
            }
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put(CUR_TAB_KEY_CACHE, tabKey);
        if ("modelpageap".equals(tabKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TOOL_BARAP_MEMBER});
            this.getView().setVisible(Boolean.TRUE, new String[]{TOOL_BARAP_MODEL});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{TOOL_BARAP_MEMBER});
            this.getView().setVisible(Boolean.FALSE, new String[]{TOOL_BARAP_MODEL});
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name;
        super.beforeF7Select(evt);
        switch (name = evt.getProperty().getName()) {
            case "model": {
                ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
                if (ApplicationTypeEnum.RPT != ModelUtil.queryApp((IFormView)this.getView())) break;
                QFilter qf = new QFilter("ReportType", "in", (Object)new String[]{ApplicationTypeEnum.RPT.getOIndex(), ApplicationTypeEnum.PUB.getOIndex()});
                param.getListFilterParameter().setFilter(qf);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "btn_refresh": {
                boolean flag;
                this.updateExtDimCache(String.valueOf(this.getModelId()));
                String extDimId = this.getPageCache().get(EXT_DIM_ID);
                boolean bl = flag = StringUtils.isNotEmpty((String)extDimId) && !"0".equals(extDimId);
                if (flag) {
                    this.initExtDimTreeView(this.getPageCache().get(EXT_TREE_CLICK_CACHE));
                }
                this.setToolBarVisible(flag);
                break;
            }
            case "open": {
                this.billListModelRefresh();
                break;
            }
            case "import": {
                if (evt.getReturnData() == null) {
                    return;
                }
                FormShowParameter param = new FormShowParameter();
                param.setFormId("bcm_extmodel_import_info");
                param.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
                param.getOpenStyle().setShowType(ShowType.Modal);
                param.setCustomParam("result", evt.getReturnData());
                this.getView().showForm(param);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if ("member_delete_close".equals(callBackId) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.deleteMemberImpl();
        } else if ("paste_comfirm".equals(callBackId) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            DynamicObject[] load;
            String allcutmember = this.getPageCache().get("allcutmember");
            String selectedPasteId = this.getPageCache().get("selectedpasteId");
            String[] ids = allcutmember.split(",");
            Object[] cutIds = Arrays.stream(ids).map(x -> Long.parseLong(x)).collect(Collectors.toList()).toArray();
            DynamicObject pasteMember = BusinessDataServiceHelper.loadSingle((Object)selectedPasteId, (String)"bcm_structofextend");
            for (DynamicObject cutMember : load = BusinessDataServiceHelper.load((Object[])cutIds, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_structofextend").getDynamicObjectType())) {
                SaveDimMemberHelper.savePasteMemberOperateLog((DynamicObject)cutMember, (DynamicObject)pasteMember);
                this.writePasteOpLog(cutMember, pasteMember);
            }
            this.pasteUpdate();
            this.getPageCache().put("cutmember", null);
            this.getPageCache().put("allcutmember", null);
            this.deleteDimCache();
            this.initExtDimTreeView(this.getPageCache().get(EXT_TREE_CLICK_CACHE));
        } else if ("model_delete_close".equals(callBackId) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.deleteRecord();
        } else if ("new_extends_model".equals(callBackId) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.showExtendsForm();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String opName = operate.getOperateKey();
        if ("baritemup".equals(opName) || "baritemdowm".equals(opName)) {
            this.downAndUpMember(opName);
            args.setCancel(true);
        }
    }

    private void updateExtDimCache(String modelId) {
        QFilter qFilter = new QFilter(MODEL_KEY, "=", (Object)Long.parseLong(modelId));
        DynamicObject extDy = QueryServiceHelper.queryOne((String)"bcm_dimension_ext", (String)"id", (QFilter[])qFilter.toArray());
        this.getPageCache().put(EXT_DIM_ID, extDy == null ? "" : extDy.getString("id"));
    }

    private void initExtDimTreeView(String clickId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter(MODEL_KEY, "=", (Object)this.getModelId()));
        qfBuilder.add(new QFilter("level", "!=", (Object)3));
        String selectedFields = "id,name,number,parent,storagetype,dseq";
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_structofextend", (String)selectedFields, (QFilter[])qfBuilder.toArray(), (String)"dseq");
        TreeView tree = (TreeView)this.getControl(TREE_VIEW_AP);
        tree.deleteAllNodes();
        ICEntityTreeNode root = ICEntityTreeBuilder.getICEntityTreeNode(doc);
        if (root != null) {
            this.buildExtDimTree(root, clickId);
        } else {
            BillList billListMem = (BillList)this.getControl(BILL_LIST_MEMBER);
            billListMem.clearData();
            BillList billListModel = (BillList)this.getControl(BILL_LIST_MODEL);
            billListModel.clearData();
        }
    }

    private void buildExtDimTree(AbstractTreeNode<Object> root, String clickId) {
        TreeView tree = (TreeView)this.getControl(TREE_VIEW_AP);
        if (root != null) {
            TreeModel treemodel = new TreeModel(root);
            TreeNode nodeRoot = treemodel.buildEntryTree(tree);
            nodeRoot.iterate(999, v -> v.setIsOpened(false));
            nodeRoot.iterate(0, v -> v.setIsOpened(true));
            if (root.getChildren() == null) {
                return;
            }
            if (StringUtils.isNotEmpty((String)clickId) && !clickId.equals(root.getId())) {
                this.getPageCache().put(EXT_TREE_CLICK_CACHE, clickId);
                tree.treeNodeClick("root", clickId);
                tree.focusNode(new TreeNode(root.getId(), clickId, ""));
            } else {
                this.getPageCache().put(EXT_TREE_CLICK_CACHE, root.getId());
                tree.treeNodeClick("", root.getId());
                tree.focusNode(new TreeNode("0", root.getId(), root.getName()));
            }
        }
    }

    private void setVisiableOfPro() {
        this.getView().setVisible(Boolean.FALSE, new String[]{TOOL_BARAP_MEMBER});
        boolean isOpenNewEnum = ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"isOpenNewEnum");
        this.getView().setVisible(Boolean.valueOf(isOpenNewEnum), new String[]{NEW_ENUM});
        this.getView().setVisible(Boolean.valueOf(!isOpenNewEnum), new String[]{NEW_ENUM_TYPE});
    }

    private QFilter addExtEntityFilter() {
        String extGroupCache = this.getPageCache().get(EXT_TREE_CLICK_CACHE);
        QFilter qFilter = new QFilter(MODEL_KEY, "=", (Object)this.getModelId());
        if (StringUtils.isNotEmpty((String)extGroupCache)) {
            long extGId = StringUtils.isNotEmpty((String)extGroupCache) ? Long.parseLong(extGroupCache) : 0L;
            QFilter qf = new QFilter("id", "=", (Object)extGId);
            DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_structofextend", (String)"id, level", (QFilter[])qf.toArray());
            if ("1".equals(dy.getString("level"))) {
                qFilter.and(new QFilter("level", "in", Arrays.asList(1, 2, 3)));
            } else if (dy != null) {
                qFilter.and(new QFilter("parent.id", "=", (Object)dy.getLong("id")).or(new QFilter("id", "=", (Object)dy.getLong("id"))));
            }
        }
        return qFilter;
    }

    private void nodeClick(TreeNodeEvent evt) {
        this.getPageCache().put(EXT_TREE_CLICK_CACHE, evt.getNodeId().toString());
        this.billListMemRefresh(evt);
        this.billListModelRefresh();
    }

    private void billListModelRefresh() {
        BillList billListModel = (BillList)this.getControl(BILL_LIST_MODEL);
        String groupId = this.getPageCache().get(EXT_TREE_CLICK_CACHE);
        QFilter qf = new QFilter(MODEL_KEY, "=", (Object)this.getModelId());
        if (StringUtils.isNotEmpty((String)groupId) && !"0".equals(groupId)) {
            QFilter qFilter = new QFilter(MODEL_KEY, "=", (Object)this.getModelId());
            qFilter.and("id", "=", (Object)Long.parseLong(groupId));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_structofextend", (String)"parent", (QFilter[])qFilter.toArray());
            if (dynamicObject != null && dynamicObject.getLong("parent") != 0L) {
                qf.and("extendsgroup", "=", (Object)Long.parseLong(groupId));
            }
        }
        billListModel.setClearSelection(Boolean.TRUE.booleanValue());
        billListModel.setOrderBy("id");
        billListModel.setFilter(qf);
        billListModel.refresh();
    }

    private void billListMemRefresh(TreeNodeEvent evt) {
        BillList billListMem = (BillList)this.getControl(BILL_LIST_MEMBER);
        billListMem.setClearSelection(Boolean.TRUE.booleanValue());
        QFilter qf = new QFilter(MODEL_KEY, "=", (Object)this.getModelId());
        if (evt.getParentNodeId() != null && !"".equals(evt.getParentNodeId())) {
            qf.and(new QFilter("parent", "=", (Object)Long.parseLong((String)evt.getNodeId())).or(new QFilter("id", "=", (Object)Long.parseLong((String)evt.getNodeId()))));
        } else {
            qf.and(new QFilter("level", "in", Arrays.asList(1, 2, 3)));
        }
        billListMem.setClearSelection(Boolean.TRUE.booleanValue());
        billListMem.setOrderBy("level,dseq");
        billListMem.setFilter(qf);
        billListMem.refresh();
    }

    private void memberHyperLinkClick(HyperLinkClickEvent evt) {
        super.hyperLinkClick(evt);
        ListSelectedRow currentRow = ((BillListHyperLinkClickEvent)evt).getCurrentRow();
        if (currentRow == null) {
            return;
        }
        QFilter qf = new QFilter("id", "=", currentRow.getPrimaryKeyValue());
        qf.and(new QFilter(MODEL_KEY, "=", (Object)this.getModelId()));
        String selectFields = "id,name,number,simplename,enumitem,permclass,parent.id,member.id,exchange,entryrate,datatype,fieldmapped,level,description,grouptype,isparticipmerge,isaccountoffset,storagetype";
        DynamicObject extDimMem = BusinessDataServiceHelper.loadSingle((String)"bcm_structofextend", (String)selectFields, (QFilter[])qf.toArray());
        if (1 == extDimMem.getInt("level")) {
            DynamicObject extDim = MemberReader.getDimensionDynById((long)LongUtil.toLong((Object)this.getPageCache().get(EXT_DIM_ID)));
            FormShowParameter param = new FormShowParameter();
            param.setStatus(OperationStatus.EDIT);
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.getOpenStyle().setTargetKey("_submaintab_");
            param.setCaption(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u5ea6-\u7f16\u8f91", (String)"ExtDimEditPlugin_183", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            param.setFormId("bcm_extdimedit");
            param.setCustomParam("id", extDim.get("id"));
            param.setCustomParam(MODEL_KEY, (Object)this.getModelId());
            param.setCustomParam("name", extDim.get("name"));
            param.setCustomParam("number", extDim.get("number"));
            param.setCustomParam("shortnumber", extDim.get("shortnumber"));
            param.setCustomParam("isuseddataperm", extDim.get("isuseddataperm"));
            param.setCustomParam("description", extDim.get("description"));
            param.setCustomParam("isExtDim", (Object)this.getPageCache().get("isExtDim"));
            param.setCustomParam("status", (Object)BTN_EDIT);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, BTN_REFRESH);
            param.setCloseCallBack(callBack);
            this.getView().showForm(param);
            return;
        }
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("bcm_structofextend");
        showParameter.setCustomParam("id", (Object)(currentRow.getPrimaryKeyValue() + ""));
        showParameter.setCustomParam("dimensionID", (Object)this.getPageCache().get(EXT_DIM_ID));
        showParameter.setCustomParam("member", extDimMem.get("member.id"));
        showParameter.setCustomParam("name", extDimMem.get("name"));
        showParameter.setCustomParam("number", extDimMem.get("number"));
        showParameter.setCustomParam("simplename", extDimMem.get("simplename"));
        showParameter.setCustomParam("description", extDimMem.get("description"));
        showParameter.setCustomParam("datatype", extDimMem.get("datatype"));
        showParameter.setCustomParam("modelnumber", (Object)this.getCurModelNumber());
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)(this.getModelId() + ""));
        showParameter.setCustomParam("entityId", (Object)"bcm_structofextend");
        showParameter.setCustomParam("parent", extDimMem.get("parent.id"));
        showParameter.setCustomParam("storagetype", extDimMem.get("storagetype"));
        showParameter.setCustomParam("isExtDim", (Object)"true");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submaintab_");
        showParameter.setStatus(OperationStatus.EDIT);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BTN_REFRESH);
        showParameter.setCloseCallBack(closeCallBack);
        if (2 == extDimMem.getInt("level") || 1 == extDimMem.getInt("level")) {
            showParameter.setCustomParam("grouptype", extDimMem.get("grouptype"));
            showParameter.setCustomParam("isparticipmerge", extDimMem.get("isparticipmerge"));
            showParameter.setCustomParam("isaccountoffset", extDimMem.get("isaccountoffset"));
            showParameter.setCustomParam("level", (Object)"2");
            showParameter.setCaption(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u4e1a\u52a1\u5206\u7ec4\u6210\u5458", (String)"ExtDimEditPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else if (3 == extDimMem.getInt("level")) {
            if ("6".equals(extDimMem.get("datatype"))) {
                showParameter.setCustomParam("value", (Object)((DynamicObject)extDimMem.get("enumitem")).getLong("id"));
                showParameter.setCustomParam("enumitem", (Object)((DynamicObject)extDimMem.get("enumitem")).getLong("id"));
            }
            showParameter.setCustomParam("fieldmapped", extDimMem.get("fieldmapped"));
            showParameter.setCustomParam("exchange", extDimMem.get("exchange"));
            showParameter.setCustomParam("datatype", extDimMem.get("datatype"));
            showParameter.setCustomParam("entryrate", extDimMem.get("entryrate"));
            showParameter.setCustomParam("KEY_MODEL_ID", (Object)(this.getModelId() + ""));
            showParameter.setCustomParam("level", (Object)"3");
            showParameter.setCaption(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u5b57\u6bb5\u6210\u5458", (String)"ExtDimEditPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void modelHyperLinkClick(HyperLinkClickEvent evt) {
        super.hyperLinkClick(evt);
        if ("number".equals(evt.getFieldName())) {
            BillList list = (BillList)evt.getSource();
            Object focusId = list.getFocusRowPkId();
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bcm_extendsmodel");
            parameter.setPageId(this.getView().getPageId() + "bcm_extendsmodel" + focusId);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            parameter.setCustomParam("focusId", focusId);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BTN_REFRESH);
            parameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(parameter);
        }
    }

    private void openNewFormPage() {
        if (StringUtils.isEmpty((String)this.getPageCache().get(EXT_TREE_CLICK_CACHE))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5206\u7ec4\u884c\u3002", (String)"ExtDimEditPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)this.getPageCache().get(EXT_TREE_CLICK_CACHE), (String)"bcm_structofextend");
        if (dy == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u7ec4\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ExtDimEditPlugin_184", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (dy.getInt("level") == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5206\u7ec4\u3002", (String)"ExtDimEditPlugin_212", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bcm_extendsmodel");
        parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParam("group", (Object)ObjectSerialUtil.toByteSerialized((Object)dy));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "open");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void addNewExtDim(String key) {
        Map<String, Object> validateResult = this.validate(key);
        if (ResultStatusEnum.FAIL.getCode().equals(validateResult.get("code"))) {
            this.getView().showTipNotification(validateResult.get("msg").toString());
            return;
        }
        DynamicObject dynamicObject = (DynamicObject)validateResult.get("msg");
        this.openView(key, dynamicObject);
    }

    private List<Long> getSelectMembers() {
        BillList billList = (BillList)this.getControl(BILL_LIST_MEMBER);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            return new ArrayList<Long>(10);
        }
        return selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
    }

    private Map<String, Object> validate(String key) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (BAR_ITEM_ADD_SUB.equals(key)) {
            if (StringUtils.isEmpty((String)this.getPageCache().get(EXT_TREE_CLICK_CACHE))) {
                result.put("code", ResultStatusEnum.FAIL.getCode());
                result.put("msg", ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5206\u7ec4\u884c\u3002", (String)"ExtDimEditPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return result;
            }
            QFilter qf = new QFilter("id", "=", (Object)Long.valueOf(this.getPageCache().get(EXT_TREE_CLICK_CACHE)));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_structofextend", (String)"id,number,level,parent.id, grouptype", (QFilter[])qf.toArray());
            if (dynamicObject == null) {
                result.put("code", ResultStatusEnum.FAIL.getCode());
                result.put("msg", ResManager.loadKDString((String)"\u5206\u7ec4\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ExtDimEditPlugin_184", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return result;
            }
            if (1 == dynamicObject.getInt("level")) {
                result.put("code", ResultStatusEnum.FAIL.getCode());
                result.put("msg", ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5206\u7ec4\u3002", (String)"ExtDimEditPlugin_212", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return result;
            }
            result.put("code", ResultStatusEnum.SUCCESS.getCode());
            result.put("msg", dynamicObject);
        }
        return result;
    }

    private void openView(String key, DynamicObject dynamicObject) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("bcm_structofextend");
        showParameter.setCustomParam("isExtDim", (Object)"true");
        showParameter.setCustomParam("modelnumber", (Object)this.getCurModelNumber());
        showParameter.setFormId("bcm_structofextend");
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)(this.getModelId() + ""));
        showParameter.setCustomParam("dimensionID", (Object)this.getPageCache().get(EXT_DIM_ID));
        showParameter.setCustomParam("actionName", (Object)key);
        showParameter.setStatus(OperationStatus.ADDNEW);
        if (BAR_ITEM_ADD_SUB.equals(key)) {
            showParameter.setCustomParam("level", (Object)"3");
            showParameter.setCustomParam("parent", (Object)dynamicObject.getLong("id"));
            showParameter.setCustomParam("grouptype", (Object)dynamicObject.getString("grouptype"));
            showParameter.setCaption(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u5b57\u6bb5\u6210\u5458", (String)"ExtDimEditPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            QFilter qf = new QFilter(MODEL_KEY, "=", (Object)this.getModelId());
            qf.and("level", "=", (Object)1);
            DynamicObject rootDy = QueryServiceHelper.queryOne((String)"bcm_structofextend", (String)"id", (QFilter[])qf.toArray());
            showParameter.setCustomParam("parent", (Object)rootDy.getLong("id"));
            showParameter.setCustomParam("level", (Object)"2");
            showParameter.setCaption(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u4e1a\u52a1\u5206\u7ec4\u6210\u5458", (String)"ExtDimEditPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submaintab_");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BTN_REFRESH);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void addShare() {
        String dimensionID = this.getPageCache().get(EXT_DIM_ID);
        String modelkey = this.getPageCache().get("KEY_MODEL_ID");
        String selectFields = "name,number";
        QFilter fdimenId = new QFilter("id", "=", (Object)LongUtil.toLong((Object)dimensionID));
        QFilter[] filters = new QFilter[]{fdimenId};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_dimension_ext", (String)selectFields, (QFilter[])filters);
        if (dcs != null && !dcs.isEmpty()) {
            String dimensionNumber = ((DynamicObject)dcs.get(0)).getString("number");
            String dimensionName = ((DynamicObject)dcs.get(0)).getString("name");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setCustomParam("opType", (Object)"new");
            showParameter.setFormId("bcm_sharinglist");
            showParameter.setCustomParam("dimensionId", (Object)dimensionID);
            showParameter.setCustomParam("KEY_MODEL_ID", (Object)modelkey);
            showParameter.setCustomParam("memberentity", (Object)"bcm_structofextend");
            showParameter.setCustomParam("dimensionname", (Object)dimensionName);
            showParameter.setCustomParam("dimensionnumber", (Object)dimensionNumber);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BTN_REFRESH);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u3002", (String)"ExtDimEditPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void deleteMember() {
        BillList billList = (BillList)this.getControl(BILL_LIST_MEMBER);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u3002", (String)"ExtDimEditPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Long> ids = selectedRows.stream().map(x -> (Long)x.getPrimaryKeyValue()).collect(Collectors.toList());
        this.checksuperiors(ids);
    }

    protected void checksuperiors(List<Long> selectMembers) {
        QFilter qf = new QFilter("id", "in", selectMembers);
        qf.or(new QFilter("copyfrom", "in", selectMembers));
        String selectFields = "id, number, name, level, issysmember, storagetype, grouptype, parent, parent.grouptype";
        DynamicObjectCollection results = QueryServiceHelper.query((String)"bcm_structofextend", (String)selectFields, (QFilter[])new QFilter[]{qf});
        List bizMem = results.stream().filter(x -> 2 == x.getInt("level")).collect(Collectors.toList());
        if (bizMem.size() > 0) {
            List childIds = bizMem.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("parent", "in", childIds);
            DynamicObjectCollection childMems = QueryServiceHelper.query((String)"bcm_structofextend", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
            results.addAll((Collection)childMems);
            Set sharIds = childMems.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
            QFilter fSids = new QFilter("copyfrom", "in", sharIds);
            DynamicObjectCollection sharMems = QueryServiceHelper.query((String)"bcm_structofextend", (String)selectFields, (QFilter[])new QFilter[]{fSids});
            results.addAll((Collection)sharMems);
        }
        if (results.stream().anyMatch(x -> 1 == x.getInt("issysmember"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u5220\u9664\u9884\u7f6e\u6210\u5458\u3002", (String)"DimensionDisplayList_151", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Set memIds = results.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
        if (PaperTemplateService.existsByExtMem(memIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u88ab\u6743\u76ca\u62b5\u9500\u5e95\u7a3f\u6a21\u677f\u5f15\u7528\u7684\u6210\u5458\u4e0d\u53ef\u5220\u9664\u3002", (String)"ExtDimEditPlugin_205", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Set fieldMems = results.stream().filter(x -> x.getInt("level") == 3).collect(Collectors.toSet());
        Set allIds = fieldMems.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
        if (allIds.size() != 0) {
            DynamicObjectCollection parents = QueryServiceHelper.query((String)"bcm_structofextend", (String)"parent", (QFilter[])new QFilter[]{new QFilter("id", "in", allIds)});
            Set parentIds = parents.stream().map(x -> x.getLong("parent")).collect(Collectors.toSet());
            DynamicObjectCollection parentMems = QueryServiceHelper.query((String)"bcm_structofextend", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", parentIds)});
            String shownumber = MemberReader.findModelSNumberById((Object)this.getModelId());
            HashMap map = new HashMap(16);
            HashMap numMaps = new HashMap(16);
            parentMems.forEach(x -> {
                ArrayList ids = new ArrayList(16);
                ArrayList nums = new ArrayList(16);
                fieldMems.forEach(y -> {
                    long fieldPid;
                    long groupId = x.getLong("id");
                    if (groupId == (fieldPid = y.getLong("parent"))) {
                        ids.add(y.getLong("id"));
                        nums.add(y.getString("number"));
                    }
                });
                map.put(x, ids);
                numMaps.put(x, nums);
            });
            if (map.size() == 0) {
                return;
            }
            for (Map.Entry next : map.entrySet()) {
                DynamicObject dynamicObject = (DynamicObject)next.getKey();
                List fieldIds = (List)next.getValue();
                if (ExtDataServiceHelper.isExistQuoteOfExtModel((List)fieldIds)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u88ab\u6a21\u578b\u5f15\u7528\u7684\u6210\u5458\u4e0d\u53ef\u5220\u9664\u3002", (String)"ExtDimEditPlugin_70", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!ExtDataServiceHelper.isExistDataOfExt((String)shownumber, (List)fieldIds, (DynamicObject)dynamicObject)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6570\u636e\u7684\u6210\u5458\u4e0d\u53ef\u5220\u9664\u3002", (String)"ExtDimEditPlugin_206", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            for (Map.Entry entry : numMaps.entrySet()) {
                List fieldNums = (List)entry.getValue();
                if (!ExtDataServiceHelper.isExistDataOfInvestExtMem((String)shownumber, (String)"", (List)fieldNums)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6570\u636e\u7684\u6210\u5458\u4e0d\u53ef\u5220\u9664\u3002", (String)"ExtDimEditPlugin_206", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        String message = ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"ISSchemeListPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        List intrDys = results.stream().filter(x -> "2".equals(x.getString("parent.grouptype")) && ("INTR_000".equals(x.getString("number")) || "INTR_001".equals(x.getString("number"))) && StorageTypeEnum.SHARE.getOIndex().equals(x.getString("storagetype"))).collect(Collectors.toList());
        Set delIds = results.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
        Set groupIds = results.stream().filter(x -> "2".equals(x.getString("level"))).map(x -> x.getLong("id")).collect(Collectors.toSet());
        List noChoiseParIntrDys = intrDys.stream().filter(x -> !groupIds.contains(x.getLong("parent"))).collect(Collectors.toList());
        if (noChoiseParIntrDys.size() > 0) {
            Map<String, String> num2Names = noChoiseParIntrDys.stream().collect(Collectors.toMap(x -> x.getString("number"), y -> y.getString("name"), (v1, v2) -> v1));
            Iterator<Map.Entry<String, String>> iterator = num2Names.entrySet().iterator();
            StringBuilder sb = new StringBuilder();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                sb.append(entry.getKey()).append(" ");
                sb.append(entry.getValue());
                if (!iterator.hasNext()) continue;
                sb.append(",");
            }
            message = String.format(ResManager.loadKDString((String)"\u5408\u5e76\u65b9\u6570\u636e\u6a21\u578b\u9700\u5305\u542b\u201c%s\u201d\u6210\u5458\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u9700\u8981\u7ee7\u7eed\u5220\u9664\uff1f", (String)"ExtDimEditPlugin_208", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sb);
        }
        ArrayList ids = new ArrayList(delIds);
        StringBuilder st = new StringBuilder();
        for (int i = 0; i < ids.size(); ++i) {
            st.append(ids.get(i));
            if (i == ids.size()) continue;
            st.append(",");
        }
        this.getPageCache().put("delIds", st.toString());
        this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("member_delete_close", (IFormPlugin)this));
    }

    private void deleteMemberImpl() {
        QFilter qf;
        String delIds = this.getPageCache().get("delIds");
        Object[] memIds = delIds.split(",");
        ArrayList<String> ls2 = new ArrayList<String>();
        String dimensionID = this.getPageCache().get(EXT_DIM_ID);
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        try (TXHandle tx = TX.required();){
            try {
                String selectFields = "id,name,member,model,dimension,number,parent.id,level,storagetype";
                DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_structofextend", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)LongUtil.toLongList(Arrays.asList(memIds)))});
                HashMap memmap = new HashMap(16);
                docs.forEach(d -> memmap.put(d.getString("id"), d));
                List<Object> opDescriotions = new ArrayList(10);
                for (int i = 0; i < memIds.length; ++i) {
                    DynamicObject obj = (DynamicObject)memmap.get(memIds[i]);
                    if (obj == null) continue;
                    ls2.add(obj.getString("member"));
                    String number = obj.getString("number");
                    String name = obj.getString("name");
                    String storagetype = obj.getString("storagetype");
                    String stoType = "3".equals(storagetype) ? StorageTypeEnum.SHARE.getName() : "";
                    opDescriotions.add(number + "  " + name + "(" + stoType + ")");
                }
                BusinessDataWriter.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_membofextend"), (Object[])ls2.toArray());
                HashSet<String> treeMemIds = new HashSet<String>(Arrays.asList(memIds));
                SaveDimMemberHelper.saveDeleteLog((String)"bcm_structofextend", treeMemIds, (long)this.getUserId());
                if (opDescriotions.size() > 0) {
                    opDescriotions = opDescriotions.stream().map(desc -> String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5220\u9664\u6210\u529f\u3002", (String)"DimensionDisplayList_94", (String)"fi-bcm-formplugin", (Object[])new Object[0]), desc)).collect(Collectors.toList());
                    OperationLogUtil.batchWriteOperationLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u5220\u9664", (String)"DimensionDisplayList_95", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opDescriotions, (Long)this.getModelId());
                }
                DeleteServiceHelper.delete((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_structofextend").getDataEntityType(), (Object[])memIds);
                QFilter qFilter = new QFilter(MODEL_KEY, "=", (Object)Long.valueOf(modelId));
                qFilter.and(new QFilter("level", "=", (Object)2));
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_structofextend", (String)"id", (QFilter[])new QFilter[]{qFilter});
                for (DynamicObject dynamicObject : dynamicObjects) {
                    this.UpdateParentIsLeafByParent(dynamicObject.getLong("id"), "bcm_structofextend");
                }
                this.deleteMemberPerm(treeMemIds, LongUtil.toLong((Object)dimensionID), LongUtil.toLong((Object)modelId));
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
        this.deleteDimCache();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DimensionDisplayList_96", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        if (StringUtils.isNotEmpty((String)this.getPageCache().get(EXT_TREE_CLICK_CACHE)) && !QueryServiceHelper.exists((String)"bcm_structofextend", (QFilter[])(qf = new QFilter("id", "=", (Object)Long.parseLong(this.getPageCache().get(EXT_TREE_CLICK_CACHE)))).toArray())) {
            this.getPageCache().remove(EXT_TREE_CLICK_CACHE);
        }
        this.initExtDimTreeView(this.getPageCache().get(EXT_TREE_CLICK_CACHE));
    }

    private void UpdateParentIsLeafByParent(long parentId, String entityName) {
        QFilter filter = new QFilter("parent", "=", (Object)parentId);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)entityName, (String)"number", (QFilter[])filters);
        if (dcs == null || dcs.size() == 0) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)entityName);
            dynamicObject.set("isleaf", (Object)1);
            SaveServiceHelper.save((IDataEntityType)dynamicObject.getDataEntityType(), (Object[])new Object[]{dynamicObject});
        }
    }

    protected void deleteMemberPerm(Set<String> deleteTreeMember, Long dimensionID, Long modelId) {
        QFilter qff1 = new QFilter("member", "in", (Object)LongUtil.toLongList(deleteTreeMember)).and("dimension", "=", (Object)dimensionID).and(MODEL_KEY, "=", (Object)modelId);
        QFilter[] filters1 = new QFilter[]{qff1};
        DeleteServiceHelper.delete((String)"bcm_memberperm", (QFilter[])filters1);
    }

    protected void deleteDimCache() {
        SearchCacheManager searchCacheManager = new SearchCacheManager();
        Cache<String, DimensionMemberSearch> dimensionMemberSearchLoadingCache = searchCacheManager.getDimensionMemberSearch();
        dimensionMemberSearchLoadingCache.invalidateAll();
        GlobalCacheServiceHelper.getCommonCache().invalidateStartsWithKey("MemberSearch_");
    }

    private void memberCutAndPaste(String key) {
        List<Long> selectMemberIds = this.getSelectMembers();
        if (selectMemberIds == null || selectMemberIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u3002", (String)"DimensionDisplayList_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (BAR_ITEM_CUT.equals(key)) {
            for (Long selectMemberId : selectMemberIds) {
                DimemberBaseAction action = DimensionFactory.getMemberCutAction(String.valueOf(selectMemberId), "", "bcm_structofextend", "", this.getPageCache().get("KEY_MODEL_ID"), 0L);
                String message = action.checkCutOperation(selectMemberId, null);
                if (StringUtils.isEmpty((String)message)) continue;
                this.getView().showTipNotification(message);
                return;
            }
            QFilter qcf = new QFilter("id", "in", selectMemberIds);
            DynamicObjectCollection datas = QueryServiceHelper.query((String)"bcm_structofextend", (String)"id,number,name,storagetype,parent", (QFilter[])new QFilter[]{qcf});
            HashSet parents = new HashSet();
            datas.stream().map(x -> parents.add(x.getLong("parent")));
            if (parents.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u4e1a\u52a1\u5206\u7ec4\u4e0b\u7684\u6210\u5458\u3002", (String)"ExtDimEditPlugin_69", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (datas != null && datas.size() > 0) {
                for (int i = 0; i < datas.size(); ++i) {
                    SaveDimMemberHelper.saveSingleMemberOperateLog((String)"bcm_structofextend", (long)((DynamicObject)datas.get(i)).getLong("id"), (Long)this.getUserId(), (DimMemberOperateTypeEnum)DimMemberOperateTypeEnum.CUT);
                }
            }
            StringBuilder sb = new StringBuilder();
            if (selectMemberIds != null && selectMemberIds.size() > 0) {
                for (int i = 0; i < selectMemberIds.size(); ++i) {
                    sb.append(selectMemberIds.get(i));
                    if (i == selectMemberIds.size() - 1) continue;
                    sb.append(",");
                }
            }
            this.getPageCache().put("allcutmember", sb.toString());
        } else if (BAR_ITEM_PASTE.equals(key)) {
            if (selectMemberIds.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u884c\u3002", (String)"ExtDimEditPlugin_62", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            Long selectMemberId = selectMemberIds.get(0);
            HashMap<Long, String> id2Mapping = new HashMap<Long, String>(16);
            DimemberBaseAction action = DimensionFactory.getMemberCutAction(String.valueOf(selectMemberId), "", "bcm_structofextend", "", this.getPageCache().get("KEY_MODEL_ID"), 0L);
            if (!StringUtils.isEmpty((String)this.getPageCache().get("allcutmember"))) {
                String message = action.checkPasteOperation(selectMemberId, this.getPageCache().get("allcutmember").split(","));
                if (!StringUtils.isEmpty((String)message)) {
                    this.getView().showTipNotification(message);
                    return;
                }
                List<Long> allcutmember = Arrays.asList(this.getPageCache().get("allcutmember").split(",")).stream().map(x -> Long.parseLong(x)).collect(Collectors.toList());
                if (!this.checkMaxMappingField(allcutmember, id2Mapping, selectMemberId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u4e1a\u52a1\u5206\u7ec4\u6210\u5458\u6570\u636e\u7c7b\u578b\u5df2\u8fbe\u5230\u6700\u5927\u503c\u3002", (String)"NewExtSharingTree_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                Map odmap = BusinessDataServiceHelper.loadFromCache((String)"bcm_structofextend", (String)"grouptype", (QFilter[])new QFilter("id", "=", (Object)selectMemberId).toArray());
                String grouptype = ((DynamicObject)odmap.get(selectMemberId)).getString("grouptype");
                if (!"3".equals(grouptype)) {
                    for (Long id : allcutmember) {
                        String fieldName = (String)id2Mapping.get(id);
                        if (ExtDimensionHelper.checkIsExistOfField((String)fieldName, (String)grouptype)) continue;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u6620\u5c04\u5b57\u6bb5\u5728\u5bf9\u5e94\u6570\u636e\u8868\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"ExtDimEditPlugin_205", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u526a\u5207\u7ef4\u5ea6\u6210\u5458\u3002", (String)"DimensionDisplayList_50", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put("selectedpasteId", String.valueOf(selectMemberId));
            this.getPageCache().put("selectedpastelevel", "2");
            this.getPageCache().put("id2Mapping", JSONObject.toJSONString(id2Mapping));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u5b9a\u5c06\u526a\u5207\u9009\u62e9\u7684\u6210\u5458\u7f16\u7801\u79fb\u52a8\u4f5c\u4e3a\u7c98\u8d34\u9009\u62e9\u7684\u6210\u5458\u7f16\u7801\u7684\u4e0b\u7ea7\u6210\u5458\uff1f", (String)"ExtDimEditPlugin_73", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("paste_comfirm", (IFormPlugin)this));
        }
    }

    private boolean checkMaxMappingField(List<Long> leftChoseNodes, Map<Long, String> id2Mapping, Long parentId) {
        boolean flag = true;
        QFilter qfr = new QFilter("parent", "=", (Object)parentId);
        qfr.or("id", "=", (Object)parentId);
        DynamicObjectCollection rightDy = QueryServiceHelper.query((String)"bcm_structofextend", (String)"id, parent, datatype, enumitem, fieldmapped, grouptype, parent.grouptype", (QFilter[])new QFilter[]{qfr});
        List parent = rightDy.stream().filter(x -> x.getLong("id") == parentId.longValue()).collect(Collectors.toList());
        List<DynamicObject> rightChildDy = rightDy.stream().filter(x -> x.getLong("id") != parentId.longValue()).collect(Collectors.toList());
        QFilter qfl = new QFilter("id", "in", leftChoseNodes);
        DynamicObjectCollection leftFocusDy = QueryServiceHelper.query((String)"bcm_structofextend", (String)"id, parent, datatype, enumitem", (QFilter[])new QFilter[]{qfl});
        if ("3".equals(((DynamicObject)parent.get(0)).getString("grouptype"))) {
            for (DynamicObject dy : leftFocusDy) {
                id2Mapping.put(dy.getLong("id"), "");
            }
            return flag;
        }
        for (DynamicObject leftDy : leftFocusDy) {
            if (!"6".equals(leftDy.getString("datatype"))) continue;
            QFilter qFilter = new QFilter("id", "=", leftDy.get("enumitem"));
            leftDy.set("datatype", (Object)QueryServiceHelper.queryOne((String)"bcm_enumitem", (String)"datatype", (QFilter[])new QFilter[]{qFilter}).getString("datatype"));
        }
        flag = this.extDimDataCheck(leftFocusDy, id2Mapping, rightChildDy, parentId);
        return flag;
    }

    private boolean extDimDataCheck(DynamicObjectCollection leftChoseNodes, Map<Long, String> id2Mapping, List<DynamicObject> rightChildDy, Long parentId) {
        List dataFieldArray = new ArrayList();
        String type = "";
        ArrayList<String> txts = new ArrayList<String>(16);
        ArrayList<String> nums = new ArrayList<String>(16);
        ArrayList<String> dates = new ArrayList<String>(16);
        Map odmap = BusinessDataServiceHelper.loadFromCache((String)"bcm_structofextend", (String)"grouptype", (QFilter[])new QFilter("id", "=", (Object)parentId).toArray());
        Integer numMax = 0;
        Integer textMax = 0;
        Integer dateMax = 0;
        Tuple tuple = ExtDimensionHelper.getTypeDataByGroupType((Integer)numMax, (Integer)textMax, (Integer)dateMax, (String)((DynamicObject)odmap.get(parentId)).getString("grouptype"));
        numMax = (Integer)tuple.p1;
        textMax = (Integer)tuple.p2;
        dateMax = (Integer)tuple.p3;
        block0: for (DynamicObject leftDy : leftChoseNodes) {
            int i;
            ArrayList<String> dataTypeEnums = new ArrayList<String>(8);
            String datatype = leftDy.getString("datatype");
            if (datatype.equals(DataTypeEnum.TXT.getOIndex())) {
                dataTypeEnums.addAll(Arrays.asList(DataTypeEnum.TXT.getOIndex(), DataTypeEnum.DEFAULT.getOIndex(), DataTypeEnum.ENUMTP.getOIndex()));
                dataFieldArray = ExtDataServiceHelper.getSQLFieldArray((String)textPrefix, (int)textMax);
                type = EXTFIELD_TEXT;
            } else if (datatype.equals(DataTypeEnum.CURRENCY.getOIndex()) || datatype.equals(DataTypeEnum.UNCURRENCY.getOIndex()) || datatype.equals(DataTypeEnum.PROPORTION.getOIndex()) || datatype.equals(DataTypeEnum.DEFAULT.getOIndex())) {
                dataTypeEnums.addAll(Arrays.asList(DataTypeEnum.CURRENCY.getOIndex(), DataTypeEnum.UNCURRENCY.getOIndex(), DataTypeEnum.PROPORTION.getOIndex(), DataTypeEnum.DEFAULT.getOIndex()));
                dataFieldArray = ExtDataServiceHelper.getSQLFieldArray((String)numPrefix, (int)numMax);
                type = EXTFIELD_NUM;
            } else if (datatype.equals(DataTypeEnum.DATETP.getOIndex())) {
                dataTypeEnums.add(DataTypeEnum.DATETP.getOIndex());
                dataFieldArray = ExtDataServiceHelper.getSQLFieldArray((String)datePrefix, (int)dateMax);
                type = EXTFIELD_DATE;
            }
            List results = rightChildDy.stream().filter(x -> dataTypeEnums.contains(x.getString("datatype"))).collect(Collectors.toList());
            DynamicObjectCollection dynamicObjects = this.calcEnumDatatypeAmount(parentId, dataTypeEnums);
            List fieldmapped = results.stream().map(x -> (String)x.get("fieldmapped")).collect(Collectors.toList());
            int sum = results.size();
            if (dynamicObjects != null && dynamicObjects.size() > 0) {
                sum += dynamicObjects.size();
                fieldmapped.addAll(dynamicObjects.stream().map(x -> (String)x.get("fieldmapped")).collect(Collectors.toList()));
            }
            if (EXTFIELD_TEXT.equals(type)) {
                if (txts.size() > 0) {
                    sum += txts.size();
                    fieldmapped.addAll(txts);
                }
                if (sum >= textMax) {
                    return false;
                }
                for (i = 1; i <= dataFieldArray.size(); ++i) {
                    if (fieldmapped.contains(dataFieldArray.get(i - 1))) continue;
                    id2Mapping.put(leftDy.getLong("id"), textPrefix + i);
                    txts.add(textPrefix + i);
                    continue block0;
                }
                continue;
            }
            if (EXTFIELD_NUM.equals(type)) {
                if (nums.size() > 0) {
                    sum += nums.size();
                    fieldmapped.addAll(nums);
                }
                if (sum >= numMax) {
                    return false;
                }
                for (i = 1; i <= dataFieldArray.size(); ++i) {
                    if (fieldmapped.contains(dataFieldArray.get(i - 1))) continue;
                    id2Mapping.put(leftDy.getLong("id"), numPrefix + i);
                    nums.add(numPrefix + i);
                    continue block0;
                }
                continue;
            }
            if (dates.size() > 0) {
                sum += dates.size();
                fieldmapped.addAll(dates);
            }
            if (sum >= dateMax) {
                return false;
            }
            for (i = 1; i <= dataFieldArray.size(); ++i) {
                if (fieldmapped.contains(dataFieldArray.get(i - 1))) continue;
                id2Mapping.put(leftDy.getLong("id"), datePrefix + i);
                dates.add(datePrefix + i);
                continue block0;
            }
        }
        return true;
    }

    protected void writePasteOpLog(DynamicObject cutMember, DynamicObject pasteMember) {
        OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u7c98\u8d34", "DimensionDisplayList_228", "fi-bcm-formplugin", "paste");
        OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("%1$s %2$s%3$s\u5230%4$s %5$s\u4e0b\u7ea7,%6$s%7$s\u3002", "DimensionDisplayList_189", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{cutMember.getString("number"), cutMember.getString("name"), OpItemEnum.PASTE.getName(), pasteMember.getString("number"), pasteMember.getString("name"), OpItemEnum.PASTE.getName(), ResultStatusEnum.SUCCESS.getName()}));
        this.writeMultiLangLog(opName, opDes);
    }

    private void pasteUpdate() {
        String[] pk = this.getPageCache().get("allcutmember").split(",");
        Map id2Mapping = (Map)JSONObject.parse((String)this.getPageCache().get("id2Mapping"));
        Long[] pks = LongUtil.toLongList(Arrays.asList(pk)).toArray(new Long[pk.length]);
        long pasteId = LongUtil.toLong((Object)this.getPageCache().get("selectedpasteId"));
        DynamicObject dyTree = BusinessDataServiceHelper.loadSingle((Object)pk[0], (String)"bcm_structofextend");
        DynamicObject pasteDyTree = BusinessDataServiceHelper.loadSingle((Object)pasteId, (String)"bcm_structofextend");
        DynamicObject oldParent = this.updateNoChildTree(dyTree.getString("parent.id"), pks);
        if (oldParent == null) {
            return;
        }
        int dseq = MemberServiceHelper.getMaxSeqByParent((String)"bcm_structofextend", (long)pasteDyTree.getLong("model.id"), (long)pasteId) + 1;
        String longnumber = pasteDyTree.getString("longnumber");
        dyTree.set("dseq", (Object)(dseq + 1));
        DynamicObject[] treeDataEntities = new DynamicObject[pks.length + 1];
        this.assemTreeDataEntities(pks, dyTree, treeDataEntities, this.getPageCache().get("selectedpasteId"), dseq, longnumber, id2Mapping);
        this.getPageCache().remove("id2Mapping");
        pasteDyTree.set("isleaf", (Object)0);
        treeDataEntities[pks.length] = pasteDyTree;
        Predicate<DynamicObject> notNull = a -> a != null;
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (DynamicObject treeDataEntity : treeDataEntities) {
            if (!notNull.test(treeDataEntity)) continue;
            list.add(treeDataEntity);
        }
        try (TXHandle tx = TX.required((String)"bcm_memberPaste");){
            try {
                String modelId = this.getPageCache().get("KEY_MODEL_ID");
                SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
                AppCacheServiceHelper.removeTemplateDispenseCache((String)MemberReader.findModelNumberById((Object)modelId));
                MQMessagePublisherServiceHelper.publishClearDimMemberCache((String)dyTree.getString("model.number"), (String)dyTree.getString("dimension.number"));
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private DynamicObject updateNoChildTree(String parentId, Long[] pks) {
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)"bcm_structofextend", (String)"id", (QFilter[])new QFilter[]{new QFilter(MODEL_KEY, "=", (Object)LongUtil.toLong((Object)UserSelectUtil.getF7SelectId(this.getView(), MODEL_KEY))), new QFilter("parent", "=", (Object)LongUtil.toLong((Object)parentId)), new QFilter("id", "not in", Arrays.stream(pks).map(x -> LongUtil.toLong((Object)x)).collect(Collectors.toSet()))});
        DynamicObject parentTree = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)"bcm_structofextend");
        if (collection != null && collection.length > 0) {
            parentTree.set("isleaf", (Object)0);
        } else {
            parentTree.set("isleaf", (Object)1);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{parentTree});
        return parentTree;
    }

    private void assemTreeDataEntities(Long[] pks, DynamicObject dyTree, DynamicObject[] treeDataEntities, String parentId, int dseq, String longnumber, Map<Long, String> id2Mapping) {
        DynamicObject[] dys = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)dyTree.getDynamicObjectType());
        for (int i = 0; i < dys.length; ++i) {
            DynamicObject dysubTree = dys[i];
            dysubTree.set("longnumber", (Object)(longnumber + '!' + dysubTree.getString("number")));
            dysubTree.set("level", (Object)3);
            dysubTree.set("parent", (Object)parentId);
            dysubTree.set("fieldmapped", (Object)id2Mapping.get(dysubTree.getLong("id")));
            dysubTree.set("dseq", (Object)(dseq + i + 1));
            this.assemSysField(dysubTree);
            if (treeDataEntities[i] != null) continue;
            treeDataEntities[i] = dysubTree;
        }
    }

    protected void assemSysField(DynamicObject dyTree) {
        dyTree.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dyTree.set("modifytime", (Object)TimeServiceHelper.now());
    }

    private DynamicObjectCollection calcEnumDatatypeAmount(Long parentId, List<String> dataTypeEnums) {
        if (dataTypeEnums.contains("0")) {
            dataTypeEnums.remove("0");
        }
        QFilter qf = new QFilter("parent", "=", (Object)parentId);
        qf.and(new QFilter("datatype", "=", (Object)"6"));
        qf.and(new QFilter("enumitem.datatype", "in", dataTypeEnums));
        return QueryServiceHelper.query((String)"bcm_structofextend", (String)"fieldmapped", (QFilter[])qf.toArray());
    }

    private void barexportcc() {
        this.exportData("bcm_structofextend", this.getPageCache().get(EXT_DIM_ID));
    }

    private void exportData(String entityName, String focusNodeId) {
        String entityNameImp = "bcm_extmemberimp";
        List<Long> selectTreeNode = this.getSelectTreeNodeID();
        int size = selectTreeNode.size();
        long modelId = this.getModelId();
        QFBuilder qb = new QFBuilder("bizobject.number", "=", (Object)entityNameImp);
        qb.add(new QFilter("templatetype", "=", (Object)"IMPT").or(new QFilter("templatetype", "is null", null)));
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"export", (String)"bos_importtemplate", (QFilter[])qb.toArray(), (String)"", (int)-1);
        if (pkIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9884\u5236\u5bfc\u5165\u6a21\u677f\u3002", (String)"DimensionDisplayList_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        try {
            FormView formView = (FormView)this.getView();
            String routeAppId = formView.getFormShowParameter().getServiceAppId();
            HashMap<String, Object> outputParams = new HashMap<String, Object>();
            outputParams.put("modelId", modelId);
            outputParams.put("userDimId", focusNodeId);
            if (size > 0) {
                outputParams.put("selectData", selectTreeNode);
            }
            ExportExecuteStrategyContext exportExecuteStrategyContext = new ExportExecuteStrategyContext();
            exportExecuteStrategyContext.setExport((IExport)new ExtendsPropertyExportStrategy());
            String url = exportExecuteStrategyContext.export(routeAppId, ((Long)pkIds.get(0)).longValue(), entityNameImp, entityName, outputParams);
            if (StringUtils.isNotEmpty((String)url)) {
                this.downloadFile(url, "bcm_dimensionmanager", "1G2FW/G3YIL8");
            }
            if (selectTreeNode.size() > 0) {
                OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u5bfc\u51fa", (String)"DimensionDisplayList_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f", (String)"DimensionDisplayList_39", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Long)this.getModelId());
            }
        }
        catch (IOException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    private List<Long> getSelectTreeNodeID() {
        Object[] primaryKeyValues;
        ArrayList<Long> dynamicIds = new ArrayList<Long>(16);
        BillList billlistap = (BillList)this.getControl(BILL_LIST_MEMBER);
        ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
        for (Object o : primaryKeyValues = selectedRows.getPrimaryKeyValues()) {
            dynamicIds.add(LongUtil.toLong((Object)o));
        }
        return dynamicIds;
    }

    private void barimportcc() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bcm_batch_bos_importstart");
        HashMap parameter = new HashMap();
        ArrayList plugins = new ArrayList();
        LinkedHashMap<String, Object> plugin = new LinkedHashMap<String, Object>();
        plugin.put("Type", 0);
        plugin.put("_Type_", "Plugin");
        plugin.put("ClassName", "kd.fi.bcm.formplugin.dimension.batchimp.ExtEntityDimensionBatchImport");
        plugin.put("Enabled", true);
        plugin.put("rowKey", null);
        plugin.put("modelid", this.getModelId());
        plugins.add(plugin);
        parameter.put("plugins", plugins);
        showParameter.setCustomParams(parameter);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)this.getPageCache().get(EXT_DIM_ID), (String)"bcm_dimension_ext");
        if (dynamicObject != null) {
            showParameter.setCustomParam("ListName", (Object)dynamicObject.getLocaleString("name").getLocaleValue());
        }
        showParameter.setCustomParam("BillFormId", (Object)"bcm_extmemberimp");
        showParameter.setCustomParam("ServiceAppId", (Object)this.getBizAppId());
        showParameter.setCustomParam("modelid", (Object)this.getModelId());
        showParameter.setCustomParam("dimensionId", (Object)Long.parseLong(this.getPageCache().get(EXT_DIM_ID)));
        showParameter.setCustomParam("reporttype", (Object)ApplicationTypeEnum.getApplication((String)this.getBizAppId()).getOIndex());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("isfileimport", (Object)"1");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "isfileimport"));
        this.getView().showForm(showParameter);
    }

    private void definedproperty() {
        String dimensionID = this.getPageCache().get(EXT_DIM_ID);
        String modelid = this.getPageCache().get("KEY_MODEL_ID");
        String selectFields = "name";
        QFilter fdimenId = new QFilter("id", "=", (Object)LongUtil.toLong((Object)dimensionID));
        QFilter[] filters = new QFilter[]{fdimenId};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_dimension_ext", (String)selectFields, (QFilter[])filters);
        if (dcs != null && dcs.size() == 1) {
            String dimensionName = ((DynamicObject)dcs.get(0)).getString("name");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bcm_definedpropertyedit");
            showParameter.setCustomParam("dimensionName", (Object)dimensionName);
            showParameter.setCustomParam("dimensionID", (Object)dimensionID);
            showParameter.setCustomParam("KEY_MODEL_ID", (Object)modelid);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCaption(String.format(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5c5e\u6027-%s", (String)"DimensionDisplayList_42", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimensionName));
            this.getView().showForm(showParameter);
        }
    }

    private void enumEvent() {
        String dimensionID = this.getPageCache().get(EXT_DIM_ID);
        String modelid = this.getPageCache().get("KEY_MODEL_ID");
        String selectFields = "name,number";
        QFilter fdimenId = new QFilter("id", "=", (Object)LongUtil.toLong((Object)dimensionID));
        QFilter[] filters = new QFilter[]{fdimenId};
        DynamicObjectCollection dcs2 = QueryServiceHelper.query((String)"bcm_dimension_ext", (String)selectFields, (QFilter[])filters);
        if (dcs2 != null && dcs2.size() == 1) {
            String dimensionName = ((DynamicObject)dcs2.get(0)).getString("name");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bcm_enumedit");
            showParameter.setCustomParam("dimensionName", (Object)dimensionName);
            showParameter.setCustomParam("dimensionID", (Object)dimensionID);
            showParameter.setCustomParam("KEY_MODEL_ID", (Object)modelid);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCaption(String.format(ResManager.loadKDString((String)"\u679a\u4e3e-%s", (String)"DimensionDisplayList_55", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimensionName));
            this.getView().showForm(showParameter);
        }
    }

    protected void newEnum() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bcm_enum_manager");
        showParameter.setPageId(this.getView().getPageId() + "bcm_enum_manager");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submaintab_");
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        showParameter.setCaption(ResManager.loadKDString((String)"\u679a\u4e3e\u8bbe\u7f6e", (String)"EnumList_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    private boolean checkDeleteStatus(ListSelectedRowCollection selectedRows) {
        List selectRowNums = selectedRows.stream().map(o -> o.getNumber()).collect(Collectors.toList());
        List selectRowIds = selectedRows.stream().map(o -> (Long)o.getPrimaryKeyValue()).collect(Collectors.toList());
        boolean extModelExistData = ExtDataServiceHelper.isExtModelExistData((String)MemberReader.findModelSNumberById((Object)this.getModelId()), selectRowNums);
        boolean isExistDataOfInvestExtModel = ExtDataServiceHelper.isExistDataOfInvestExtModel((String)MemberReader.findModelSNumberById((Object)this.getModelId()), selectRowNums);
        Boolean extModelUsed = ExtDataServiceHelper.isExtModelUsed((long)this.getModelId(), selectRowIds);
        return !extModelExistData && !isExistDataOfInvestExtModel && extModelUsed == false;
    }

    private void deleteRecord() {
        try (TXHandle tx = TX.required();){
            try {
                BillList billlist = (BillList)this.getControl(BILL_LIST_MODEL);
                ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
                List pks = selectedRows.stream().map(o -> o.getPrimaryKeyValue()).collect(Collectors.toList());
                StringBuilder sb = new StringBuilder();
                selectedRows.stream().forEach(o -> sb.append(o.getName()).append('\uff08').append(o.getNumber()).append('\uff09').append('\u3001'));
                DynamicObject extmodel = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extendsmodel");
                DeleteServiceHelper.delete((IDataEntityType)extmodel.getDynamicObjectType(), (Object[])pks.toArray());
                QFBuilder qb = new QFBuilder("extmodelid", "in", pks);
                DeleteServiceHelper.delete((String)"bcm_extmodelfield", (QFilter[])qb.toArray());
                DeleteServiceHelper.delete((String)"bcm_extmodeldim", (QFilter[])qb.toArray());
                this.billListModelRefresh();
                sb.deleteCharAt(sb.lastIndexOf("\u3001"));
                OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u5220\u9664\u62d3\u5c55\u6570\u636e\u6a21\u578b", "ExtendsModelListPlugin_13", "fi-bcm-formplugin", "deleteExtModel");
                this.writeOperationLog(opName, sb.toString());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ExtendsModelListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private void updateStatus(String enable) {
        DynamicObject[] object;
        BillList billlist = (BillList)this.getControl(BILL_LIST_MODEL);
        ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
        List pks = selectedRows.stream().map(o -> o.getPrimaryKeyValue().toString()).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(pks)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u3002", (String)"DimensionDisplayList_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qf = new QFilter("id", "in", (Object)LongUtil.toLongList(pks));
        DynamicObjectCollection models = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"id, number, name, enable", (QFilter[])qf.toArray());
        StringBuilder sb = new StringBuilder();
        for (DynamicObject model : models) {
            if (!enable.equals(model.get("enable"))) continue;
            sb.append(model.get("number")).append(" ").append(model.get("name")).append(" ");
        }
        if (sb.length() > 0) {
            if ("1".equals(enable)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b\u201c%s\u201d\u5df2\u542f\u7528\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\u3002", (String)"ExtendsModelListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sb.toString()));
            } else if ("0".equals(enable)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b\u201c%s\u201d\u5df2\u7981\u7528\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\u3002", (String)"ExtendsModelListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sb.toString()));
            }
            return;
        }
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extendsmodel");
        for (DynamicObject dynamicObject : object = BusinessDataServiceHelper.load((Object[])ConvertUtil.convertListToLong(pks).toArray(), (DynamicObjectType)dy.getDynamicObjectType())) {
            dynamicObject.set("enable", (Object)enable);
        }
        SaveServiceHelper.update((DynamicObject[])object);
        for (DynamicObject dynamicObject : object) {
            String number = dynamicObject.getString("number");
            String name = dynamicObject.getString("name");
            if ("1".equals(enable)) {
                this.writeOperationLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.ENABLE.getMultiLangEnumBridge(), (String)"Enable"), number, name, LogConstant.getOperationStatusSuccess());
                continue;
            }
            if (!"0".equals(enable)) continue;
            this.writeOperationLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.DISABLE.getMultiLangEnumBridge(), (String)"Disable"), number, name, LogConstant.getOperationStatusSuccess());
        }
        if ("1".equals(enable)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"ExtendsModelListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else if ("0".equals(enable)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"ExtendsModelListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.billListModelRefresh();
    }

    private void openImportFormPage() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bcm_extendsmodelimport");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "import");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void exportModelData(ListSelectedRowCollection selectedRows) {
        List selectRowNums = selectedRows.stream().map(o -> o.getNumber()).collect(Collectors.toList());
        JSONArray json = ExportExtModelServiceHelper.getModel(selectRowNums, (long)this.getModelId());
        String pretty = JSON.toJSONString((Object)json, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        String url = ExportExtModelServiceHelper.downloadJsonFile((String)pretty);
        this.downloadFile(url, "bcm_dimensionmanager", "2FB5=5G8ZPPY");
    }

    private void extendsDataDump() {
        BillList billList = (BillList)this.getControl(BILL_LIST_MODEL);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u62d3\u5c55\u6570\u636e\u6a21\u578b\u3002", (String)"ExtendsModelListPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection billListSelectedRowCollection = selectedRows.getBillListSelectedRowCollection();
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("bcm_extdatadump");
        param.setCustomParam(MODEL_KEY, (Object)this.getModelId());
        param.setCustomParam("extModelList", (Object)billListSelectedRowCollection);
        this.getView().showForm(param);
    }

    private void downAndUpMember(String key) {
        List<Long> selectMemIds = this.getSelectMembers();
        if (selectMemIds == null || selectMemIds.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u3002", (String)"DimensionDisplayList_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectMemIds.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u884c\u3002", (String)"ExtDimEditPlugin_62", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long clickId = selectMemIds.get(0);
        IDNumberTreeNode member = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_structofextend", (Long)clickId);
        if (member == IDNumberTreeNode.NotFoundTreeNode) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6210\u5458\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ExtDimDisplayList_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (1 == member.getLevel()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u6210\u5458\u4e0d\u5141\u8bb8\u79fb\u52a8\u3002", (String)"ExtDimDisplayList_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        IDNumberTreeNode leftTreeMem = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_structofextend", (Long)Long.valueOf(this.getPageCache().get(EXT_TREE_CLICK_CACHE)));
        if (2 == leftTreeMem.getLevel() && 2 == member.getLevel()) {
            if ("baritemup".equals(key)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u5df2\u7ecf\u662f\u8be5\u5c42\u6b21\u7b2c\u4e00\u884c\u3002", (String)"DimensionDisplayList_137", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u5df2\u7ecf\u662f\u8be5\u5c42\u6b21\u6700\u540e\u4e00\u884c\u3002", (String)"DimensionDisplayList_139", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        if ("baritemup".equals(key)) {
            this.moveUpMember(clickId);
        } else if ("baritemdowm".equals(key)) {
            this.moveDownMember(clickId);
        }
        this.refreshExtDimTreeView();
        ListSelectedRowCollection billlistap = ((BillList)this.getControl(BILL_LIST_MEMBER)).getCurrentListAllRowCollection();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ListSelectedRow obj : billlistap) {
            ids.add((Long)obj.getPrimaryKeyValue());
        }
        int fo = ids.indexOf(clickId);
        fo = "baritemup".equals(key) ? fo - 1 : fo + 1;
        BillList billList = (BillList)this.getControl(BILL_LIST_MEMBER);
        billList.selectRows(fo, true);
        String modelNumber = MemberReader.findModelNumberById((Object)this.getModelId());
        CacheGenFactory.getCommonCache().invalidateStartsWithKey(modelNumber);
    }

    private void moveUpMember(long id) {
        int movedseq;
        DynamicObject dyTree2;
        String parentId;
        QFilter filter;
        DynamicObject dyTree = BusinessDataServiceHelper.newDynamicObject((String)"bcm_structofextend");
        dyTree = BusinessDataReader.loadSingle((Object)id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)dyTree.getDynamicObjectType().getName()));
        int seq = dyTree.getInt("dseq");
        if (seq == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u5df2\u7ecf\u662f\u8be5\u5c42\u6b21\u7b2c\u4e00\u884c\u3002", (String)"DimensionDisplayList_137", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qf1 = new QFilter("dseq", "<", (Object)dyTree.getInt("dseq"));
        QFilter[] filters = new QFilter[]{qf1, filter = new QFilter("parent", "=", (Object)LongUtil.toLong((Object)(parentId = this.queryParentId(String.valueOf(id), "bcm_structofextend"))))};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_structofextend", (String)"id,dseq", (QFilter[])filters, (String)"dseq desc", (int)1);
        if (dcs != null && dcs.size() > 0) {
            dyTree2 = BusinessDataReader.loadSingle((Object)((DynamicObject)dcs.get(0)).get("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)dyTree.getDynamicObjectType().getName()));
            int selectseq = dyTree.getInt("dseq");
            int n = movedseq = dyTree2 != null ? dyTree2.getInt("dseq") : 0;
            if (dyTree2 != null) {
                dyTree2.set("dseq", (Object)selectseq);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u5df2\u7ecf\u662f\u8be5\u5c42\u6b21\u7b2c\u4e00\u884c\u3002", (String)"DimensionDisplayList_137", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        dyTree.set("dseq", (Object)movedseq);
        Object[] objs = new Object[]{dyTree, dyTree2};
        SaveServiceHelper.save((IDataEntityType)dyTree.getDataEntityType(), (Object[])objs);
        SaveDimMemberHelper.saveSingleMemberOperateLog((String)"bcm_structofextend", (long)id, (Long)this.getUserId(), (DimMemberOperateTypeEnum)DimMemberOperateTypeEnum.UP);
    }

    protected String queryParentId(String id, String entityId) {
        String parent = "";
        String selectFields = "parent";
        QFilter filter = new QFilter("id", "=", (Object)LongUtil.toLong((Object)id));
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)entityId, (String)selectFields, (QFilter[])filters, (String)"");
        if (dcs != null && dcs.size() == 1) {
            return ((DynamicObject)dcs.get(0)).getString("parent");
        }
        return parent;
    }

    private void moveDownMember(long id) {
        int maxseq;
        String entityName = "bcm_structofextend";
        DynamicObject dyTree = BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName);
        int seq = dyTree.getInt("dseq");
        if (seq == (maxseq = MemberServiceHelper.getMaxSeqByParent((String)entityName, (long)dyTree.getLong("model.id"), (long)dyTree.getLong("parent.id")) + 1)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u5df2\u7ecf\u662f\u8be5\u5c42\u6b21\u6700\u540e\u4e00\u884c\u3002", (String)"DimensionDisplayList_139", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            QFilter qf1 = new QFilter("dseq", ">", (Object)dyTree.getInt("dseq"));
            String parentId = this.queryParentId(String.valueOf(id), entityName);
            QFilter filter = new QFilter("parent", "=", (Object)LongUtil.toLong((Object)parentId));
            QFilter[] filters = new QFilter[]{filter, qf1};
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)entityName, (String)"id,dseq", (QFilter[])filters, (String)"dseq", (int)1);
            if (dcs != null && dcs.size() > 0) {
                DynamicObject dyTree2 = BusinessDataReader.loadSingle((Object)((DynamicObject)dcs.get(0)).get("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)dyTree.getDynamicObjectType().getName()));
                int selectseq = dyTree.getInt("dseq");
                int movedseq = dyTree2.getInt("dseq");
                dyTree2.set("dseq", (Object)selectseq);
                dyTree.set("dseq", (Object)movedseq);
                Object[] objs = new Object[]{dyTree, dyTree2};
                SaveServiceHelper.save((IDataEntityType)dyTree.getDataEntityType(), (Object[])objs);
                SaveDimMemberHelper.saveSingleMemberOperateLog((String)"bcm_structofextend", (long)id, (Long)this.getUserId(), (DimMemberOperateTypeEnum)DimMemberOperateTypeEnum.DOWN);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u5df2\u7ecf\u662f\u8be5\u5c42\u6b21\u6700\u540e\u4e00\u884c\u3002", (String)"DimensionDisplayList_139", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private void refreshExtDimTreeView() {
        TreeView tree = (TreeView)this.getControl(TREE_VIEW_AP);
        QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(this.getPageCache().get(EXT_TREE_CLICK_CACHE)));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_structofextend", (String)"level", (QFilter[])new QFilter[]{qFilter});
        if (1 == dynamicObject.getInt("level")) {
            tree.treeNodeClick("", this.getPageCache().get(EXT_TREE_CLICK_CACHE));
        } else {
            tree.treeNodeClick("root", this.getPageCache().get(EXT_TREE_CLICK_CACHE));
        }
    }

    private void showExtendsForm() {
        FormShowParameter param = new FormShowParameter();
        param.setStatus(OperationStatus.ADDNEW);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.getOpenStyle().setTargetKey("_submaintab_");
        param.setCaption(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u5ea6-\u65b0\u589e", (String)"ExtDimEditPlugin_181", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        param.setFormId("bcm_extdimedit");
        param.setCustomParam(MODEL_KEY, (Object)this.getModelId());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BTN_REFRESH);
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }
}

