/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.serviceHelper.ModelPermHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.common.util.OpenApiUtil;

public class GetDimensionServerPlugin
extends AbstractBillWebApiPlugin {
    private static final Log log = LogFactory.getLog(GetDimensionServerPlugin.class);
    private static final String appUrl = "/app/cm/dimensionInfo";

    public ApiResult doCustomService(Map<String, Object> params) {
        log.info("into GetDimensionServerPlugin " + JacksonUtils.toJson(params));
        Optional<String> paraValidator = this.validateParam(params);
        if (paraValidator.isPresent()) {
            return ApiResult.fail((String)paraValidator.get(), (String)"000001");
        }
        String reportType = (String)params.get("reportType");
        String modelNumber = (String)params.get("number");
        QFilter numberFilter = new QFilter("model.shownumber", "=", (Object)modelNumber);
        QFilter reporttypeFilter = new QFilter("model.reporttype", "=", (Object)reportType);
        DynamicObject[] data = BusinessDataServiceHelper.load((String)"bcm_dimension", (String)"id,membermodel,number,name,shortnumber,model", (QFilter[])new QFilter[]{numberFilter, reporttypeFilter});
        ArrayList resList = new ArrayList();
        HashMap<String, Object> resMap = null;
        if (data != null && data.length > 0) {
            boolean AuthStatusFlag = OpenApiUtil.getAuthStatus((String)appUrl);
            if (AuthStatusFlag && !ModelPermHelper.hasModelPerm((long)data[0].getLong("model.id"))) {
                String info = String.format(ResManager.loadKDString((String)"\u7528\u6237\u65e0\u5f53\u524d\u4f53\u7cfb\u4f7f\u7528\u6743\u9650\u3002", (String)"AbstractMsService_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new Object[0]);
                return ApiResult.fail((String)info, (String)"000001");
            }
            for (DynamicObject dynamicObject : data) {
                resMap = new HashMap<String, Object>();
                resMap.put("id", dynamicObject.getLong("id"));
                resMap.put("membermodel", dynamicObject.getString("membermodel"));
                resMap.put("number", dynamicObject.getString("number"));
                resMap.put("name", dynamicObject.getString("name"));
                resMap.put("shortnumber", dynamicObject.getString("shortnumber"));
                resList.add(resMap);
            }
        }
        ApiResult res = ApiResult.success(resList);
        return res;
    }

    private Optional<String> validateParam(Map<String, Object> params) {
        if (Objects.isNull(params.get("number"))) {
            return Optional.of("param modelNumber is required.");
        }
        String reportType = (String)params.get("reportType");
        if (Objects.isNull(reportType)) {
            return Optional.of("param reportType is required.");
        }
        if (!ApplicationTypeEnum.CM.getOIndex().equals(reportType) && !ApplicationTypeEnum.RPT.getOIndex().equals(reportType)) {
            return Optional.of("CM or RPT.");
        }
        return Optional.empty();
    }
}

