/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.SaveDimMemberHelper;
import kd.fi.bcm.business.dimension.struct.ShareNodeStructSyncHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.business.util.DimMemberSortUtil;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.localcache.SyncCacheUtil;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.dimension.DimensionDisplayList;
import kd.fi.bcm.formplugin.tree.dimension.ICEntityTreeBuilder;
import kd.fi.bcm.formplugin.tree.dimension.ICEntityTreeNode;

public class ICEntityDisplayList
extends DimensionDisplayList {
    private static final String TREELEFT = "treeleft";
    private static final String LEFT_TREE_FOCUS_NODE_ID = "LeftTreeFocusNodeId";
    private static final String BILLLISTAP = "billlistap";

    @Override
    public void initialize() {
        super.initialize();
        final TreeView tree = (TreeView)this.getView().getControl(TREELEFT);
        tree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                ICEntityDisplayList.this.nodeClick(tree);
            }
        });
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addHyperClickListener(event -> {
            long id = (Long)billList.getFocusRowPkId();
            DynamicObject curMember = QueryServiceHelper.queryOne((String)"bcm_icmembertree", (String)"id,number,name,parent.number,storagetype", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
            this.onhyperLinkClick(event, id, curMember, curMember.getString("parent.number"), StorageTypeEnum.isShare((String)curMember.getString("storagetype")));
        });
        billList.addSetFilterListener(event -> {
            event.getQFilters().add(this.getFilters());
            event.setOrderBy("level,dseq");
        });
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        long dimId = LongUtil.toLong((Object)this.getPageCache().get(dimensionCacheKey));
        String dimNumber = MemberReader.getDimensionNumById((long)dimId);
        if (DimTypesEnum.INTERCOMPANY.getNumber().equals(dimNumber)) {
            switch (key) {
                case "baritemrefresh": {
                    TreeView tree = (TreeView)this.getView().getControl(TREELEFT);
                    this.nodeClick(tree);
                    break;
                }
                default: {
                    super.itemClick(evt);
                    break;
                }
            }
        } else {
            super.itemClick(evt);
        }
    }

    private void moveMember(String key, long dimId) {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u3002", (String)"DimensionDisplayList_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u6682\u4e0d\u652f\u6301\u591a\u884c\u3002", (String)"DimensionDisplayList_54", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        int selectRows = selectedRows.getRowKeys()[0];
        this.updateIcLevel();
        long id = (Long)selectedRows.get(0).getPrimaryKeyValue();
        if ("baritemup".equals(key)) {
            if (this.moveUpMember("bcm_icmembertree", id)) {
                --selectRows;
            }
        } else if ("baritemdowm".equals(key) && this.moveDownMember("bcm_icmembertree", id)) {
            ++selectRows;
        }
        DimMemberSortUtil.upadteDimChangeTime((Long)this.getModelId(), (Long)0L, (Long)dimId, (String)"changetime");
        this.treeRefresh();
        billList.selectRows(selectRows);
    }

    private void updateIcLevel() {
        try {
            long modelId = this.getModelId();
            String modelNum = MemberReader.findModelNumberById((Object)modelId);
            long icId = MemberReader.findMemberByNumber((String)modelNum, (String)"InternalCompany", (String)"ICEntity").getId();
            long icoId = MemberReader.findMemberByNumber((String)modelNum, (String)"InternalCompany", (String)"ICOEntity").getId();
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            filter.and(new QFilter("parent", "in", (Object)Lists.newArrayList((Object[])new Long[]{icoId, icId})));
            filter.and(new QFilter("level", "=", (Object)3));
            if (QueryServiceHelper.exists((String)"bcm_icmembertree", (QFilter[])filter.toArray())) {
                DB.execute((DBRoute)DBRoute.of((String)"bcm"), (String)"update t_bcm_structoficentity set flevel = 4 where fmodelid = ? and fparentid in(?,?)", (Object[])new Object[]{modelId, icId, icoId});
            }
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
        }
    }

    @Override
    protected void treeOnClick(TreeView tree) {
        String dimensionID = this.getSelectDimensionId(tree);
        if (StringUtils.isEmpty((String)dimensionID)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ICEntityDisplayList_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject dimension = this.getDimension(dimensionID);
        String dimensionNumber = dimension.getString("number");
        String dimMemberSign = dimension.getString("membermodel");
        this.handleOnClickCommonEvent(dimensionNumber);
        this.getPageCache().put(dimensionCacheKey, dimensionID);
        if (DimTypesEnum.INTERCOMPANY.getNumber().equals(dimensionNumber)) {
            this.getPageCache().put(memberformCacheKey, "bcm_icmembertree");
            this.getModel().setValue("includesubordinates", (Object)true);
            this.initLeftTree();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"splitcontainerap2"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"splitcontainerap1"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"splitcontainerap3"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap7"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"baritemmove", "baritemap"});
        } else {
            this.getPageCache().put(memberformCacheKey, dimMemberSign);
            this.getPageCache().put("dimensionNum", dimensionNumber);
            String pageItem = this.getPageCache().get("pageItem");
            if ("show_table".equals(pageItem) && ("bcm_entitymembertree".equals(dimMemberSign) || "bcm_accountmembertree".equals(dimMemberSign) || "bcm_userdefinedmembertree".equals(dimMemberSign))) {
                super.treeOnClick(tree);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap7"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"splitcontainerap1", "splitcontainerap2", "splitcontainerap3"});
                if (this.isCM()) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap3"});
                }
            } else if (this.isCM() && "bcm_entitymembertree".equals(dimMemberSign)) {
                this.buildCslTree();
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"splitcontainerap2", "flexpanelap3"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"splitcontainerap1", "splitcontainerap3", "flexpanelap7"});
                SplitContainer container = (SplitContainer)this.getControl("splitcontainerap2");
                container.hidePanel(SplitDirection.left, false);
            } else if (this.isRPT() && "bcm_entitymembertree".equals(dimMemberSign)) {
                super.treeOnClick(tree);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"splitcontainerap2"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"splitcontainerap1"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"splitcontainerap3"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap7"});
                SplitContainer container = (SplitContainer)this.getControl("splitcontainerap2");
                container.hidePanel(SplitDirection.left, true);
            } else {
                super.treeOnClick(tree);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"splitcontainerap2"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"splitcontainerap1"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"splitcontainerap3"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap7"});
                SplitContainer container = (SplitContainer)this.getControl("splitcontainerap2");
                container.hidePanel(SplitDirection.left, true);
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("includesubordinates".equals(e.getProperty().getName())) {
            TreeView tree = (TreeView)this.getView().getControl(TREELEFT);
            this.nodeClick(tree);
        }
    }

    public void initLeftTree() {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("model", "=", (Object)this.getModelId()));
        long dimId = LongUtil.toLong((Object)this.getPageCache().get(dimensionCacheKey));
        qfBuilder.add(new QFilter("dimension", "=", (Object)dimId));
        qfBuilder.add(new QFilter("isleaf", "=", (Object)"0")).or(new QFilter("number", "in", (Object)new String[]{"ICOEntity", "ICEntity", "ICNone"}));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_icmembertree", (String)"id,name,number,parent,isleaf,storagetype,level,dseq", (QFilter[])qfBuilder.toArray(), (String)"level,dseq");
        ICEntityTreeNode root = ICEntityTreeBuilder.getICEntityTreeNode(doc);
        if (root != null) {
            TreeView tree = (TreeView)this.getControl(TREELEFT);
            tree.deleteAllNodes();
            this.buildLeftTree(root);
        }
    }

    private void buildLeftTree(AbstractTreeNode<Object> root) {
        TreeView tree = (TreeView)this.getControl(TREELEFT);
        if (root != null) {
            TreeModel treeModel = new TreeModel(root);
            TreeNode nodeRoot = treeModel.buildEntryTree(tree);
            nodeRoot.iterate(0, v -> v.setIsOpened(true));
            if (root.getChildren() == null) {
                return;
            }
            String focusNodeId = this.getPageCache().get(LEFT_TREE_FOCUS_NODE_ID);
            if (StringUtils.isEmpty((String)focusNodeId) || nodeRoot.getTreeNode(focusNodeId, 999) == null) {
                focusNodeId = root.getId();
                this.getPageCache().put(LEFT_TREE_FOCUS_NODE_ID, focusNodeId);
            }
            TreeNode node = nodeRoot.getTreeNode(focusNodeId, 999);
            tree.focusNode(node);
            this.treeRefresh();
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String entityName = this.getPageCache().get(memberformCacheKey);
        String actionId = closedCallBackEvent.getActionId();
        if ("delete_close".equals(actionId) && MessageBoxResult.Yes.equals(closedCallBackEvent.getReturnData()) && "bcm_icmembertree".equals(entityName)) {
            this.deleteICMember();
            return;
        }
        if ("bcm_icmembertree".equals(entityName) && !"addNewDim".equals(actionId) && !"dimension_quote_report".equals(actionId)) {
            this.treeRefresh();
        } else {
            super.closedCallBack(closedCallBackEvent);
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
    }

    private void deleteICMember() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        HashSet<Long> ids = new HashSet<Long>(16);
        HashSet<String> numbers = new HashSet<String>(16);
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        String modelNum = model.getString("number");
        for (ListSelectedRow row : selectedRows) {
            ids.add((Long)row.getPrimaryKeyValue());
        }
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_icmembertree", (String)"id,issysmember,isleaf,longnumber,number,name,member.id,parent.number,aggoprt", (QFilter[])filter.toArray());
        HashSet<String> strIds = new HashSet<String>(doc.size());
        ArrayList<String> opDescriptions = new ArrayList<String>(10);
        for (DynamicObject object : doc) {
            if (object.getInt("issysmember") == 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u5220\u9664\u9884\u7f6e\u6210\u5458\u3002", (String)"ICEntityDisplayList_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            strIds.add(object.getString("id"));
            numbers.add(object.getString("number"));
            opDescriptions.add(String.format(ResManager.loadKDString((String)"%1$s  %2$s", (String)"DimensionDisplayList_93", (String)"fi-bcm-formplugin", (Object[])new Object[0]), object.getString("number"), object.getString("name")));
        }
        String dimId = this.getPageCache().get(dimensionCacheKey);
        try (TXHandle tx = TX.required();){
            try {
                SaveDimMemberHelper.saveDeleteLog((String)"bcm_icmembertree", strIds, (long)this.getUserId());
                DeleteServiceHelper.delete((String)"bcm_intercompanymember", (QFilter[])filter.toArray());
                DeleteServiceHelper.delete((String)"bcm_icmembertree", (QFilter[])filter.toArray());
                if (SyncCacheUtil.isIncrementCache((String)"bcm_icmembertree")) {
                    SyncCacheUtil.saveMemberCache((Long)model.getLong("id"), (Long)LongUtil.toLong((Object)dimId), ids);
                }
                OlapServiceHelper.batchDropDimensionMembers((String)modelNum, (String)DimTypesEnum.INTERCOMPANY.getNumber(), numbers);
                if (opDescriptions.size() > 0) {
                    List op = opDescriptions.stream().map(desc -> String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5220\u9664\u6210\u529f\u3002", (String)"DimensionDisplayList_94", (String)"fi-bcm-formplugin", (Object[])new Object[0]), desc)).collect(Collectors.toList());
                    OperationLogUtil.batchWriteOperationLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u5220\u9664", (String)"DimensionDisplayList_95", (String)"fi-bcm-formplugin", (Object[])new Object[0]), op, (Long)this.getModelId());
                }
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        ShareNodeStructSyncHelper.syncICNodeStorageType((long)this.getModelId(), (long)LongUtil.toLong((Object)dimId));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ICEntityDisplayList_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        billList.clearSelection();
        this.treeRefresh();
    }

    private QFilter getFilters() {
        String focusNodeId = this.getPageCache().get(LEFT_TREE_FOCUS_NODE_ID);
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        long dimId = LongUtil.toLong((Object)this.getPageCache().get(dimensionCacheKey));
        qFilter.and(new QFilter("dimension", "=", (Object)dimId));
        if (StringUtils.isNotEmpty((String)focusNodeId)) {
            long id = LongUtil.toLong((Object)focusNodeId);
            IDataEntityProperty includeAll = this.getModel().getProperty("includesubordinates");
            boolean includeSubordinates = includeAll == null ? true : (Boolean)this.getModel().getValue("includesubordinates");
            QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
            filter.and(new QFilter("id", "=", (Object)id));
            DynamicObject focusNode = QueryServiceHelper.queryOne((String)"bcm_icmembertree", (String)"longnumber,number", (QFilter[])filter.toArray());
            if (includeSubordinates && focusNode != null) {
                qFilter.and(new QFilter("longnumber", "like", (Object)(focusNode.getString("longnumber") + '!' + "%")).or(new QFilter("number", "=", (Object)focusNode.getString("number"))));
            } else {
                qFilter.and(new QFilter("parent.id", "=", (Object)id));
            }
        }
        return qFilter;
    }

    private void nodeClick(TreeView tree) {
        TreeView.TreeState state = tree.getTreeState();
        if (state.getFocusNode() != null) {
            String focusNodeId = (String)state.getFocusNode().get("id");
            this.getPageCache().put(LEFT_TREE_FOCUS_NODE_ID, focusNodeId);
        }
        this.treeRefresh();
    }

    private void treeRefresh() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        QFilter qFilter = this.getFilters();
        billList.setClearSelection(true);
        billList.getFilterParameter().setFilter(qFilter);
        billList.setOrderBy("level,dseq");
        billList.refresh();
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String opName = operate.getOperateKey();
        if ("baritemup".equals(opName) || "baritemdowm".equals(opName)) {
            this.moveMember(opName, LongUtil.toLong((Object)this.getPageCache().get(dimensionCacheKey)));
            args.setCancel(true);
        } else {
            super.beforeDoOperation(args);
        }
    }
}

