/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.FieldEdit;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.util.ImportAndExportUtil;

public class InvRelaReferReport
extends AbstractBaseFormPlugin {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String BAR_EXPORT = "bar_export";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        List memCombs = (List)this.getView().getFormShowParameter().getCustomParam("memCombs");
        if (memCombs.size() > 0) {
            this.getModel().deleteEntryData(ENTRY_ENTITY);
            for (String memComb : memCombs) {
                String[] members = memComb.split(";");
                if (members.length != 4) continue;
                DynamicObject bizRow = this.getModel().getEntryEntity(ENTRY_ENTITY).addNew();
                bizRow.set("org", (Object)members[0]);
                bizRow.set("scene", (Object)members[1]);
                bizRow.set("period", (Object)members[2]);
                bizRow.set("year", (Object)members[3]);
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BAR_EXPORT.equals(itemKey)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            int size = entryEntity.size();
            if (size == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8981\u5bfc\u51fa\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5", (String)"InvRelaReferReport_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            List fieldEdits = entryGrid.getFieldEdits();
            ArrayList<String> selectFieldList = new ArrayList<String>(size);
            String[] captions = new String[fieldEdits.size()];
            for (int i = 0; i < fieldEdits.size(); ++i) {
                IDataEntityProperty property = ((FieldEdit)fieldEdits.get(i)).getProperty();
                captions[i] = property.getDisplayName().getLocaleValue();
                selectFieldList.add(property.getName());
            }
            ArrayList<String[]> excelList = new ArrayList<String[]>(size);
            for (DynamicObject dynamicObject : entryEntity) {
                int k = 0;
                String[] values = new String[fieldEdits.size()];
                for (String filed : selectFieldList) {
                    values[k++] = dynamicObject.getString(filed);
                }
                excelList.add(values);
            }
            String title = ResManager.loadKDString((String)"\u6240\u6709\u6743\u5f15\u7528\u62a5\u544a", (String)"MemberReferListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            ThreeTuple objectObjectObjectThreeTuple = new ThreeTuple((Object)title, (Object)captions, excelList);
            String url = ImportAndExportUtil.export(title, objectObjectObjectThreeTuple);
            if (url != null) {
                this.downloadFile(url, "bcm_dimensionmanager", "3LAVRDIIQVD/");
            }
        }
    }
}

