/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CommonModelEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.tree.dimension.ICEntityTreeBuilder;
import kd.fi.bcm.formplugin.tree.dimension.ICEntityTreeNode;

public class LTreeRListPlugin
extends AbstractBaseFormPlugin {
    private static final String TREELEFT = "treeleft";
    private static final String LEFT_TREE_FOCUS_NODE_ID = "LeftTreeFocusNodeId";
    private static final String BILLLISTAP = "billlistap";
    private static final long DIM_VAR_NODE_ID = 1234567891L;

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners("btnok");
        final TreeView tree = (TreeView)this.getView().getControl(TREELEFT);
        this.setFormId((String)this.getFormCustomParam("entity"));
        tree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                LTreeRListPlugin.this.treeClick(tree);
            }
        });
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addSetFilterListener(event -> event.getQFilters().add(this.getFilters()));
    }

    @Override
    public void click(EventObject evt) {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRow selectRow = billList.getCurrentSelectedRowInfo();
        if (selectRow == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"LTreeRListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        long id = (Long)selectRow.getPrimaryKeyValue();
        DynamicObject selectedRow = BusinessDataServiceHelper.loadSingle((Object)id, (String)this.getEntityName());
        if (this.getBooleanParam("isAll")) {
            this.getView().setReturnData((Object)selectedRow);
            this.getView().returnDataToParent((Object)selectedRow);
            this.getView().close();
        }
        boolean isLeaf = selectedRow.getBoolean("isleaf");
        String parentView = this.getView().getParentView().getEntityId();
        if ((this.getBooleanParam("isOnlyLeaf") || this.isOnlyLeaf(parentView)) && !isLeaf) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u660e\u7ec6\u6210\u5458\u3002", (String)"LTreeRListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.getBooleanParam("isNotLeaf") && isLeaf) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u975e\u660e\u7ec6\u6210\u5458\u3002", (String)"SingleMemberF74NoLeafPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.getBooleanParam("isNotLabel") && StorageTypeEnum.LABEL.getOIndex().equals(selectedRow.getString("storagetype"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u975e\u6807\u7b7e\u6210\u5458\u3002", (String)"SingleMemberF74CustomPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String shortNum = selectedRow.getString("dimension.shortnumber");
        String number = selectedRow.getString("number");
        if (this.getBooleanParam("isNotNone") && number.equals(shortNum + "None")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9None\u6210\u5458\u3002", (String)"LTreeRListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().setReturnData((Object)selectedRow);
        this.getView().returnDataToParent((Object)selectedRow);
        this.getView().close();
    }

    private boolean getBooleanParam(String param) {
        Object obj = this.getFormCustomParam(param);
        if (obj == null) {
            return false;
        }
        if (obj instanceof String && "true".equalsIgnoreCase((String)obj)) {
            return true;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("includesubordinates", (Object)true);
        this.initLeftTree();
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
    }

    @Override
    public void afterBindData(EventObject e) {
    }

    private void treeClick(TreeView tree) {
        TreeView.TreeState state = tree.getTreeState();
        if (state.getFocusNode() != null) {
            String focusNodeId = (String)state.getFocusNode().get("id");
            this.getPageCache().put(LEFT_TREE_FOCUS_NODE_ID, focusNodeId);
        }
        this.treeRefresh();
    }

    public void initLeftTree() {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("model", "=", (Object)this.getModelId()));
        Long dimId = (Long)this.getFormCustomParam("dimId");
        if (dimId != null) {
            qfBuilder.add(new QFilter("dimension.id", "=", (Object)dimId));
        }
        QFilter filter = new QFilter("isleaf", "=", (Object)"0");
        if ("bcm_icmembertree".equalsIgnoreCase(this.getEntityName())) {
            filter.or(new QFilter("number", "in", (Object)new String[]{"ICOEntity", "ICNone"}));
        }
        qfBuilder.add(filter);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)this.getEntityName(), (String)"id,name,number,longnumber,parent,isleaf,storagetype,level,dseq", (QFilter[])qfBuilder.toArray(), (String)"level,dseq");
        ICEntityTreeNode root = ICEntityTreeBuilder.getICEntityTreeNode(doc);
        if (root != null) {
            TreeView tree = (TreeView)this.getControl(TREELEFT);
            tree.deleteAllNodes();
            this.buildLeftTree(root);
        }
    }

    private void buildLeftTree(AbstractTreeNode<Object> root) {
        TreeView tree = (TreeView)this.getControl(TREELEFT);
        if (root != null) {
            TreeModel treemodel = new TreeModel(root);
            TreeNode nodeRoot = treemodel.buildEntryTree(tree);
            nodeRoot.iterate(999, v -> v.setIsOpened(false));
            nodeRoot.iterate(1, v -> v.setIsOpened(true));
            if (root.getChildren() == null) {
                return;
            }
            List vars = (List)this.getFormCustomParam("isShowSystemVariables");
            if (!CollectionUtils.isEmpty((Collection)vars)) {
                TreeNode varNode = new TreeNode("", String.valueOf(1234567891L), ResManager.loadKDString((String)"\u7ef4\u5ea6\u53d8\u91cf", (String)"LTreeRListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                tree.addNode(varNode);
            }
            this.getPageCache().put(LEFT_TREE_FOCUS_NODE_ID, root.getId());
            tree.treeNodeClick("", root.getId());
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("includesubordinates".equals(e.getProperty().getName())) {
            this.treeClick((TreeView)this.getView().getControl(TREELEFT));
        }
    }

    private void setCustomerFilter(QFilter qFilter) {
        String customFilter;
        boolean isContainShare = this.getFormCustomParam("isContainShare", true);
        if (!isContainShare) {
            qFilter.and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
        }
        if (StringUtils.isNotEmpty((String)(customFilter = (String)this.getView().getFormShowParameter().getCustomParam("customFilter")))) {
            QFilter filter = QFilter.fromSerializedString((String)customFilter);
            qFilter.and(filter);
        }
    }

    private QFilter getFilters() {
        String focusNodeId = this.getPageCache().get(LEFT_TREE_FOCUS_NODE_ID);
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        long dimId = this.getDimId();
        if (dimId != 0L) {
            qFilter.and(new QFilter("dimension.id", "=", (Object)dimId));
        }
        qFilter.and(PermissionServiceImpl.getInstance((Long)this.getModelId()).getReadOrWritePermFilter(Long.valueOf(dimId), this.getEntityName(), "id"));
        this.setCustomerFilter(qFilter);
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        if ("bcm_invsharechange".equals(parentFormId) || "bcm_invrelation_search".equals(parentFormId) || "bcm_invsheetrelationadd".equals(parentFormId)) {
            QFilter invFilter = new QFilter("number", "!=", (Object)"ICNone");
            invFilter.and("isleaf", "=", (Object)"1");
            qFilter.and(invFilter);
        }
        if (StringUtils.isNotEmpty((String)focusNodeId)) {
            boolean includeSubordinates;
            long id = LongUtil.toLong((Object)focusNodeId);
            if (id == 1234567891L) {
                QFilter filter = new QFilter("model", "=", (Object)CommonModelEnum.DIMENSION_VAR.getModelId());
                List vars = (List)this.getFormCustomParam("isShowSystemVariables");
                if (!CollectionUtils.isEmpty((Collection)vars)) {
                    filter.and("number", "in", (Object)vars);
                }
                return filter;
            }
            IDNumberTreeNode focusNode = MemberReader.findMemberById((long)this.getModelId(), (String)this.getEntityName(), (Long)id);
            IDataEntityProperty includeAll = this.getModel().getProperty("includesubordinates");
            boolean bl = includeSubordinates = includeAll == null ? true : (Boolean)this.getModel().getValue("includesubordinates");
            if (includeSubordinates && IDNumberTreeNode.NotFoundTreeNode != focusNode) {
                qFilter.and(new QFilter("longnumber", "like", (Object)(focusNode.getLongNumber() + '!' + "%")).or(new QFilter("id", "=", (Object)id)));
            } else {
                qFilter.and(new QFilter("parent.id", "=", (Object)id).or(new QFilter("id", "=", (Object)id)));
            }
        }
        return qFilter;
    }

    private long getDimId() {
        Long dimId = (Long)this.getFormCustomParam("dimId");
        if (dimId == null || dimId == 0L) {
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
            qFilter.and(new QFilter("membermodel", "=", (Object)this.getEntityName()));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id", (QFilter[])qFilter.toArray());
            if (Objects.nonNull(dynamicObject)) {
                return dynamicObject.getLong("id");
            }
        }
        return 0L;
    }

    private void treeRefresh() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.setFilter(this.getFilters());
        billList.setOrderBy("level,dseq");
        billList.refresh();
    }

    private void setFormId(String entityId) {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        if (StringUtils.isNotEmpty((String)entityId)) {
            billList.setBillFormId(entityId);
            billList.getContext().getEntryEntityDtos().clear();
            billList.setEntityId(entityId);
            billList.setEntryEntity(entityId);
        }
    }

    private String getEntityName() {
        if (StringUtils.isNotEmpty((String)((String)this.getFormCustomParam("entity")))) {
            return (String)this.getFormCustomParam("entity");
        }
        return "bcm_icmembertree";
    }

    private boolean isOnlyLeaf(String parentView) {
        return "bcm_rptadjustdraft_merge".equals(parentView) || "bcm_rptadjustdraft_offset".equals(parentView) || "bcm_rptadjustdraft_adjust".equals(parentView) || "bcm_invsheetttplentrys".equals(parentView) || "bcm_invelimtemplate".equals(parentView);
    }
}

