/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.util.AccountMemberUtil;
import kd.fi.bcm.business.export.strategy.DimDefaultValueExportStrategy;
import kd.fi.bcm.business.export.strategy.ExportExecuteStrategyContext;
import kd.fi.bcm.business.export.strategy.IExport;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.DataEntityUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.domain.view.event.EventConstant;
import kd.fi.bcm.spread.domain.view.event.IAfterEventHandle;

public class MemberDefaultValuePlugin
extends AbstractBaseFormPlugin
implements SingleMemberF7Util.ISingleMemberF7Handle,
IAfterEventHandle,
BasedataFuzzySearchListener {
    private static final String ENTITY = "entity";
    private static final String MODEL = "model";
    private static final String USEDINMENU = "usedinmenu";
    private static final String OLDDATAS = "oldDatas";
    private static final String ENTRYENTITY = "entryentity";
    private static final String HIDEN = "hiden";
    private static final String DIMENSION = "dimension";
    private static final String DEFAULTVALUE = "defaultvalue";
    private static final String DEFAULTVALUEID = "defaultvalueid";
    private static final String DEFAULTNUMBER = "defaultnumber";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String DIMENSIONMAP = "dimensionMap";
    private static final String MODIFIERFIELD = "modifierld";
    private static final String MODIFYTIME = "modifydate";
    private static final String SCOPE = "scope";
    private static final String SCOPEVALUE = "1";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String ISREFRESHENTRY = "isRefreshEntry";
    private static final String DIMENSIONNUM = "dimensionnum";
    private static final String DEFAULTVALUENAME = "defaultvaluename";
    private static final String ENTITY1 = "Entity";
    private static final String ACCOUNT = "Account";
    private static final String SCENARIO = "Scenario";
    private static final String YEAR = "Year";
    private static final String PERIOD = "Period";
    private static final String PROCESS = "Process";
    private static final String CURRENCY = "Currency";
    private static final String AUDITTRAIL = "AuditTrail";
    private static final String CHANGETYPE = "ChangeType";
    private static final String DATASORT = "DataSort";
    private static final String MULTIGAAP = "MultiGAAP";
    private static final String MYCOMPANY = "MyCompany";
    private static final String INTERNALCOMPANY = "InternalCompany";

    private String getAdjustText() {
        return ResManager.loadKDString((String)"\u8c03\u6574\u62b5\u9500\u5206\u5f55", (String)"MemberDefaultValuePlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private String getOlapQueryText() {
        return ResManager.loadKDString((String)"\u5373\u5e2d\u5206\u6790", (String)"MemberDefaultValuePlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private void bindCtrlMapping() {
        String f7MapFields = this.getPageCache().get("f7MapFields");
        if (StringUtils.isEmpty((String)f7MapFields)) {
            return;
        }
        String[] fields = f7MapFields.split(";");
        MainEntityType mainEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection props = mainEntityType.getProperties();
        for (String field : fields) {
            if (props.containsKey((Object)field)) continue;
            DataEntityUtils.addBasedataF7ToMainEntity((Container)((Container)this.getControl("fieldsetpanelap")), (MainEntityType)mainEntityType, (String)field, (String)this.unpackEntityNumber(field), (IDataModel)this.getModel(), (IFormView)this.getView());
        }
    }

    private String unpackEntityNumber(String f7Key) {
        return f7Key.substring(0, f7Key.lastIndexOf(95));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), MODEL);
        this.getModel().setValue(this.getModelSign(), (Object)modelId);
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
        this.changeLable();
        this.refreshEntry();
        this.getPageCache().remove(ISREFRESHENTRY);
    }

    private void refreshEntry() {
        if (this.getModel().getValue(MODEL) == null) {
            this.getView().getPageCache().remove(OLDDATAS);
            return;
        }
        Long modeId = Long.valueOf(((DynamicObject)this.getModel().getValue(MODEL)).getString("id"));
        this.loadDimension(modeId);
        String useDinMenu = (String)this.getModel().getValue(USEDINMENU);
        this.getModel().deleteEntryData(ENTRYENTITY);
        Object[] oldData = this.getOldData(modeId, useDinMenu);
        if (oldData == null || oldData.length == 0) {
            this.getView().getPageCache().remove(OLDDATAS);
            return;
        }
        int count = oldData.length;
        int[] rowIndex = this.getModel().batchCreateNewEntryRow(ENTRYENTITY, count);
        for (int i = 0; i < count; ++i) {
            this.getPageCache().put(ISREFRESHENTRY, "YES");
            DynamicObject oldDataIndex = oldData[i];
            this.getModel().setValue(DIMENSION, oldDataIndex.get(DIMENSION), rowIndex[i]);
            this.getModel().setValue(HIDEN, oldDataIndex.get(HIDEN), rowIndex[i]);
            this.getModel().setValue(DEFAULTVALUE, oldDataIndex.get(DEFAULTVALUE), rowIndex[i]);
            this.getModel().setValue(DEFAULTVALUEID, oldDataIndex.get(DEFAULTVALUEID), rowIndex[i]);
            this.getModel().setValue(DEFAULTNUMBER, oldDataIndex.get(DEFAULTNUMBER), rowIndex[i]);
        }
        DynamicObjectType dynamicObjectType = oldData[0].getDynamicObjectType();
        this.getView().getPageCache().put(OLDDATAS, DynamicObjectSerializeUtil.serialize((Object[])oldData, (DynamicObjectType)dynamicObjectType));
        this.getView().getPageCache().put("dynamicObjectType", dynamicObjectType.toString());
    }

    @Override
    public void registerListener(EventObject e) {
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(MODEL);
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(DEFAULTVALUE);
        this.addItemClickListeners("toolbarap");
    }

    @Override
    public void beforeSingleMemberF7Select(BeforeF7SelectEvent arg0) {
        Object source = arg0.getSource();
        if (source instanceof BasedataEditSingleMemberF7) {
            String menu = (String)this.getModel().getValue(USEDINMENU);
            this.getView().getPageCache().put("menu", menu);
            Object originalValue = arg0.getOriginalValue();
            if (originalValue instanceof DynamicObject) {
                DynamicObject orgVal = (DynamicObject)originalValue;
                String dimNumber = orgVal.getString(NUMBER);
                if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                    BasedataEditSingleMemberF7 f7 = (BasedataEditSingleMemberF7)((Object)source);
                    f7.setCustomFilter(new QFilter("iscaltype", "=", (Object)Boolean.FALSE));
                } else if (SysDimensionEnum.Currency.getNumber().equals(dimNumber)) {
                    BasedataEditSingleMemberF7 f7 = (BasedataEditSingleMemberF7)((Object)source);
                } else {
                    String fieldmapped = orgVal.getString("fieldmapped");
                    if (AccountMemberUtil.dimMapNumbers.contains(dimNumber) || StringUtils.isNotEmpty((String)fieldmapped)) {
                        BasedataEditSingleMemberF7 f7 = (BasedataEditSingleMemberF7)((Object)source);
                        QFilter dimMapFilter = null;
                        if (DimTypesEnum.INTERCOMPANY.getNumber().equals(dimNumber)) {
                            dimMapFilter = new QFilter("isleaf", "=", (Object)SCOPEVALUE);
                        }
                        if (DimTypesEnum.AUDITTRIAL.getNumber().equals(dimNumber) && "bcm_adjustoffset_entry".equals(this.getModel().getValue(USEDINMENU))) {
                            String selectField = "id,number,name,parent,level,isleaf,dimension,dseq,longnumber,datasource";
                            QFBuilder qfBuilder = new QFBuilder();
                            qfBuilder.add(new QFilter(MODEL, "=", (Object)this.getModelId()));
                            DynamicObjectCollection audittrialMembers = QueryServiceHelper.query((String)"bcm_audittrialmembertree", (String)selectField, (QFilter[])qfBuilder.toArray(), (String)"level desc");
                            HashMap<Long, Integer> dataSourceMap = new HashMap<Long, Integer>(audittrialMembers.size());
                            for (DynamicObject audittrialMember : audittrialMembers) {
                                Long id = audittrialMember.getLong("id");
                                if (dataSourceMap.get(id) != null) continue;
                                if (audittrialMember.get("datasource") != null) {
                                    dataSourceMap.put(id, audittrialMember.getInt("datasource"));
                                    continue;
                                }
                                dataSourceMap.put(id, null);
                            }
                            Map relationMap = MemberPermHelper.BuildPCRelation((DynamicObjectCollection)audittrialMembers);
                            Iterator permIt = audittrialMembers.iterator();
                            while (permIt.hasNext()) {
                                DynamicObject audittrialMember = (DynamicObject)permIt.next();
                                boolean flag = this.isAudittrialMemberCanShow(audittrialMember.getLong("id"), dataSourceMap, relationMap);
                                if (flag) continue;
                                permIt.remove();
                            }
                            HashSet<Long> canShowIds = new HashSet<Long>(audittrialMembers.size());
                            for (DynamicObject member : audittrialMembers) {
                                canShowIds.add(member.getLong("id"));
                            }
                            dimMapFilter = new QFilter("id", "in", canShowIds);
                        }
                        if (dimMapFilter != null) {
                            f7.setCustomFilter(dimMapFilter);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (DEFAULTVALUE.equals(key)) {
            this.bindCtrlMapping();
            HashMap map = new HashMap(16);
            this.asMapF7toType(Collections.singletonList(ENTITY), SingleF7TypeEnum.NOLEAF, map);
            this.initSingleMemberF7(map);
            String dimensionID = this.getSelectEntryDimensionNum();
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
            int[] rows = entryGrid.getSelectRows();
            if (dimensionID == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"MemberDefaultValuePlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            String dimensionNumber = (String)this.getModel().getValue(DIMENSION, rows[0]);
            this.spreadF7Click(rows[0], dimensionNumber);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("cellF7".equals(actionId)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
            int[] rows = entryGrid.getSelectRows();
            DynamicObject returnData = (DynamicObject)closedCallBackEvent.getReturnData();
            if (returnData != null && rows.length == 1) {
                this.getModel().setValue(DEFAULTVALUE, (Object)returnData.getString(NAME), rows[0]);
                this.getModel().setValue(DEFAULTVALUEID, (Object)returnData.getString("id"), rows[0]);
                this.getModel().setValue(DEFAULTNUMBER, (Object)returnData.getString(NUMBER), rows[0]);
            }
        } else if ("bar_import_close".equals(actionId)) {
            this.refreshEntry();
        }
    }

    private boolean isAudittrialMemberCanShow(Long audittrialMemberid, Map<Long, Integer> dataSourceMap, Map<Long, List<Long>> relationMap) {
        if (dataSourceMap.get(audittrialMemberid) != null && dataSourceMap.get(audittrialMemberid) == 3) {
            return true;
        }
        if (relationMap.get(audittrialMemberid) != null) {
            boolean isCanShow = false;
            for (long id : relationMap.get(audittrialMemberid)) {
                boolean isChildrenCanShow = this.isAudittrialMemberCanShow(id, dataSourceMap, relationMap);
                if (!isChildrenCanShow) continue;
                isCanShow = true;
                break;
            }
            return isCanShow;
        }
        return false;
    }

    public void spreadF7Click(int row, String number) {
        QFilter numberFilter = new QFilter(NUMBER, "=", (Object)number);
        DynamicObject dimObj = BusinessDataServiceHelper.loadSingle((String)"bcm_dimension", (String)"id,number,name,dseq,membermodel,fieldmapped", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId()), numberFilter});
        if (dimObj == null) {
            return;
        }
        BasedataEditSingleMemberF7 f7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), dimObj.getLong("id"), "cellF7", null, true, SingleF7TypeEnum.LEAF);
        f7.setF7title(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"MemberDefaultValuePlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        f7.setCallBackClassName(this.getClass().getName());
        BeforeF7SelectEvent evt = new BeforeF7SelectEvent((FieldEdit)f7, row, (Object)dimObj);
        this.beforeSingleMemberF7Select(evt);
        f7.click();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (MODEL.equals(propertyName)) {
            this.refreshEntry();
        } else if (USEDINMENU.equals(propertyName)) {
            this.changeLable();
            this.refreshEntry();
        } else if (DIMENSION.equals(propertyName) && StringUtils.isEmpty((String)this.getPageCache().get(ISREFRESHENTRY))) {
            this.dimensionChange();
        }
        this.getPageCache().remove(ISREFRESHENTRY);
    }

    private void changeLable() {
        Label label = (Label)this.getView().getControl("labelap");
        String pagename = "";
        if ("bcm_adjustoffset_entry".equals(this.getModel().getValue(USEDINMENU))) {
            pagename = this.getAdjustText();
        } else if ("bcm_analyticssolutiondata".equals(this.getModel().getValue(USEDINMENU))) {
            pagename = this.getOlapQueryText();
        }
        StringBuilder text = new StringBuilder();
        text.append(String.format(ResManager.loadKDString((String)"\u8bbe\u7f6e%s\u9ed8\u8ba4\u503c", (String)"MemberDefaultValuePlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), pagename));
        label.setText(text.toString());
    }

    private void dimensionChange() {
        String dimensionNumber = this.getSelectEntryDimensionNum();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        int selectedRow = entryGrid.getSelectRows()[0];
        DynamicObject[] entryData = entryGrid.getEntryData().getDataEntitys();
        for (int i = 0; i < entryData.length; ++i) {
            if (i == selectedRow || entryData[i] == null || entryData[i].getString(DIMENSION) == null || !entryData[i].getString(DIMENSION).equals(dimensionNumber) || "".equals(dimensionNumber)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7684\u7ef4\u5ea6\u6709\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MemberDefaultValuePlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            entryGrid.getEntryState().selectRow(selectedRow - 1);
            this.getModel().deleteEntryRow(ENTRYENTITY, selectedRow);
            return;
        }
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            int index = selectRows[0];
            this.getModel().setValue(HIDEN, (Object)Boolean.FALSE, index);
            this.getModel().setValue(DEFAULTVALUE, null, index);
            this.getModel().setValue(DEFAULTNUMBER, null, index);
            this.getModel().setValue(DEFAULTVALUEID, null, index);
        }
    }

    private String getSelectEntryDimensionNum() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        int[] rows = entryGrid.getSelectRows();
        if (rows.length == 0 || this.getModel().getValue(DIMENSION, rows[0]) == null) {
            return null;
        }
        return (String)this.getModel().getValue(DIMENSION, rows[0]);
    }

    private void loadDimension(Long modelID) {
        QFilter fdimenId = new QFilter("model.id", "=", (Object)modelID);
        QFilter qFilter2 = new QFilter("ishide", "=", (Object)Boolean.FALSE);
        QFilter[] filters = new QFilter[]{fdimenId, qFilter2};
        DynamicObjectCollection dy = QueryServiceHelper.query((String)"bcm_dimension", (String)"number,name,id,ishide", (QFilter[])filters, (String)"dseq");
        ComboEdit comboEdit = (ComboEdit)this.getControl(DIMENSION);
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        HashMap<String, String> dimensionMapNow = new HashMap<String, String>(16);
        for (DynamicObject dimension : dy) {
            dimensionMapNow.put(dimension.getString(NUMBER), dimension.getString(NAME));
            data.add(new ComboItem(new LocaleString(dimension.getString(NAME)), dimension.getString(NUMBER)));
        }
        this.getView().getPageCache().put(DIMENSIONMAP, JSON.toJSONString(dimensionMapNow));
        comboEdit.setComboItems(data);
    }

    private DynamicObject[] getOldData(Long modelId, String useDinMenu) {
        QFilter qcf = new QFilter(MODEL, "=", (Object)modelId);
        QFilter qcf1 = new QFilter(USEDINMENU, "=", (Object)useDinMenu);
        QFilter qcf2 = new QFilter(SCOPE, "=", (Object)SCOPEVALUE);
        QFilter qcf4 = new QFilter(HIDEN, "=", (Object)Boolean.FALSE);
        String selectProperties = "id,model,usedinmenu,scope,permclass,creatorid,modifierld,dimension,hiden,defaultvalue,defaultvalueid,defaultnumber,createdate,modifydate";
        DynamicObject[] oldData = null;
        QFilter qcf3 = new QFilter(MODIFIERFIELD, "=", (Object)this.getUserId());
        oldData = BusinessDataServiceHelper.load((String)"bcm_defaultvalue", (String)selectProperties, (QFilter[])new QFilter[]{qcf, qcf1, qcf2, qcf3, qcf4});
        return oldData;
    }

    public void afterSpreadEventHandle(EventConstant.ActionName actionName) {
    }

    public void handleData(BasedataFuzzySearchEvent basedataFuzzySearchEvent) {
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.itemClick((ItemClickEvent)evt);
        String key = evt.getItemKey();
        if ("bar_close".equals(key) && this.getModel().getDataChanged()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u662f\u5426\u8fdb\u884c\u4fdd\u5b58\uff1f", (String)"ConvertSettingPlugin_29", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("CallBack_bar_close", (IFormPlugin)this));
            evt.setCancel(true);
            return;
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getCallBackId().equals("CallBack_bar_close")) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.checkPerm("bar_save");
                String checkPageData = this.checkPageData();
                if (StringUtils.isNotEmpty((String)checkPageData)) {
                    this.getView().showTipNotification(checkPageData);
                    return;
                }
                this.save();
            }
            this.getModel().setDataChanged(false);
            this.getModel().updateCache();
            this.getView().close();
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("bar_save".equals(key)) {
            String tip = this.checkPageData();
            if (StringUtils.isEmpty((String)tip)) {
                this.save();
                Long modelId = Long.valueOf(((DynamicObject)this.getModel().getValue(MODEL)).getString("id"));
                String useDinMenu = (String)this.getModel().getValue(USEDINMENU);
                Object[] oldData = this.getOldData(modelId, useDinMenu);
                if (oldData != null && oldData.length != 0) {
                    DynamicObjectType dynamicObjectType = oldData[0].getDynamicObjectType();
                    this.getView().getPageCache().put(OLDDATAS, DynamicObjectSerializeUtil.serialize((Object[])oldData, (DynamicObjectType)dynamicObjectType));
                } else {
                    this.getView().getPageCache().remove(OLDDATAS);
                }
            } else {
                this.getView().showTipNotification(tip);
            }
            this.getModel().setDataChanged(false);
        } else if ("bar_close".equals(key)) {
            String checkPageData = this.checkPageData();
            if (StringUtils.isNotEmpty((String)checkPageData)) {
                return;
            }
            ArrayList<DynamicObject> addNewList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> deleteList = new ArrayList<DynamicObject>();
            String operationName = ResManager.loadKDString((String)"\u9000\u51fa", (String)"MemberDefaultValuePlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            StringBuilder operationDes = new StringBuilder(operationName);
            StringBuilder changeCon = new StringBuilder();
            this.pageLog(operationDes);
            this.compareData(changeCon, addNewList, updateList, deleteList);
            if (changeCon.length() > 0) {
                operationDes.append(':');
                operationDes.append((CharSequence)changeCon);
            }
            OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u9000\u51fa", "MemberDefaultValuePlugin_9", FI_BCM_FORMPLUGIN, "close");
            String opDes = operationDes.length() > 255 ? operationDes.substring(0, 255) : operationName;
            this.writeMultiLangLog(opName, OPDescMultiLangEnumBridge.genUnTransBridge((String)opDes));
        } else if ("bar_export".equals(key)) {
            if (this.getModel().getValue(MODEL) == null || this.getModel().getValue(USEDINMENU) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u6216\u9002\u7528\u529f\u80fd\u83dc\u5355\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"MemberDefaultValuePlugin_25", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
            if (!this.checkDimensionMemIsDelete((List<DynamicObject>)entryentity, this.getModelId())) {
                String failTips = String.format(ResManager.loadKDString((String)"\u8981\u5bfc\u51fa\u7684\u6570\u636e\u4e2d\u3010%1$s\u3011\u7684\u9ed8\u8ba4\u503c\u3010%2$s\u3011\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u4fee\u590d\u540e\u518d\u6b21\u64cd\u4f5c", (String)"MemberDefaultValuePlugin_26", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), this.getPageCache().get(DIMENSIONNUM), this.getPageCache().get(DEFAULTVALUENAME));
                this.getView().showTipNotification(failTips);
                return;
            }
            this.barExport();
        } else if ("bar_import".equals(key)) {
            String msg = ResManager.loadKDString((String)"\u7ef4\u5ea6\u9ed8\u8ba4\u503c", (String)"MemberDefaultValuePlugin_27", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            this.invokeOperation("bcm_defaultvalue_imp", "kd.fi.bcm.formplugin.dimension.batchimp.defaultValue.DimDefaultValueBatchImport", msg, "bar_import_close");
        }
    }

    private void barExport() {
        DynamicObject modelDy = (DynamicObject)this.getModel().getValue(MODEL);
        long modelId = modelDy.getLong("id");
        String useDinMenu = (String)this.getModel().getValue(USEDINMENU);
        QFilter qb = new QFilter(NUMBER, "=", (Object)"bcm_defaultvalue_imp_IMPT");
        qb.and("bizobject.number", "=", (Object)"bcm_defaultvalue_imp");
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"export", (String)"bos_importtemplate", (QFilter[])qb.toArray(), (String)"", (int)-1);
        if (pkIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9884\u5236\u5bfc\u5165\u6a21\u677f", (String)"MemberDefaultValuePlugin_23", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        try {
            FormView formView = (FormView)this.getView();
            String routeAppId = formView.getFormShowParameter().getServiceAppId();
            HashMap<String, Object> outputParams = new HashMap<String, Object>();
            outputParams.put("modelId", modelId);
            outputParams.put("useDinMenu", useDinMenu);
            ExportExecuteStrategyContext exportExecuteStrategyContext = new ExportExecuteStrategyContext();
            exportExecuteStrategyContext.setExport((IExport)new DimDefaultValueExportStrategy());
            String url = exportExecuteStrategyContext.export(routeAppId, ((Long)pkIds.get(0)).longValue(), "bcm_defaultvalue_imp", "bcm_defaultvalue", outputParams);
            if (StringUtils.isNotEmpty((String)url)) {
                this.downloadFile(url, "bcm_memberdefaultval", "47150e89000000ac");
            }
            OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u5bfc\u51fa\u7ef4\u5ea6\u9ed8\u8ba4\u503c", "MemberDefaultValuePlugin_28", FI_BCM_FORMPLUGIN, "exportDefaultValue");
            OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u5bfc\u51fa\u7ef4\u5ea6\u9ed8\u8ba4\u503c\u6210\u529f", "MemberDefaultValuePlugin_24", FI_BCM_FORMPLUGIN, null);
            this.writeMultiLangLog(opName, opDes);
        }
        catch (IOException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ""), new Object[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void save() {
        block5: {
            ArrayList<DynamicObject> addNewList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> deleteList = new ArrayList<DynamicObject>();
            OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u4fdd\u5b58", "MemberDefaultValuePlugin_14", FI_BCM_FORMPLUGIN, "save");
            String operationName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"MemberDefaultValuePlugin_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            StringBuilder operationDes = new StringBuilder(operationName);
            StringBuilder changeCon = new StringBuilder();
            this.pageLog(operationDes);
            this.compareData(changeCon, addNewList, updateList, deleteList);
            if (changeCon.length() > 0) {
                operationDes.append(':');
                operationDes.append((CharSequence)changeCon);
                DynamicObject[] template = new DynamicObject[]{};
                DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
                QFilter fdimenId = new QFilter(MODEL, "=", (Object)model.getLong("id"));
                QFilter qFilter2 = new QFilter("ishide", "=", (Object)Boolean.TRUE);
                QFilter[] filters = new QFilter[]{fdimenId, qFilter2};
                DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_dimension", (String)"number,name,id,ishide", (QFilter[])filters, (String)"dseq");
                if (!doc.isEmpty()) {
                    for (DynamicObject dy : doc) {
                        String number = dy.getString(NUMBER);
                        List dol = Arrays.stream(addNewList.toArray(template)).filter(d -> number.equals(d.get(DIMENSION))).collect(Collectors.toList());
                        List dol1 = Arrays.stream(updateList.toArray(template)).filter(d -> number.equals(d.get(DIMENSION))).collect(Collectors.toList());
                        List dol2 = Arrays.stream(deleteList.toArray(template)).filter(d -> number.equals(d.get(DIMENSION))).collect(Collectors.toList());
                        if (dol.isEmpty() && dol1.isEmpty() && dol2.isEmpty()) continue;
                        String dimensionMap = this.getView().getPageCache().get(DIMENSIONMAP);
                        HashMap hashMap = (HashMap)JSON.parseObject((String)dimensionMap, HashMap.class);
                        String dimensionName = (String)hashMap.get(number);
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ef4\u5ea6\u5df2\u88ab\u9690\u85cf\uff0c\u4e0d\u53ef\u4fdd\u5b58\u3002", (String)"MemberDefaultValuePlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), dimensionName));
                        return;
                    }
                }
                if (this.checkDimensionMemIsDelete(addNewList, this.getModelId()) && this.checkDimensionMemIsDelete(updateList, this.getModelId())) {
                    SaveServiceHelper.save((DynamicObject[])addNewList.toArray(template));
                    SaveServiceHelper.update((DynamicObject[])updateList.toArray(template));
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_defaultvalue"), (Object[])deleteList.toArray());
                    String opDes = operationDes.length() > 255 ? operationDes.substring(0, 255) : operationName;
                    this.writeMultiLangLog(opName, OPDescMultiLangEnumBridge.genUnTransBridge((String)opDes));
                    break block5;
                } else {
                    String failTips = ResManager.loadKDString((String)"\u5df2\u88ab\u5220\u9664\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"MemberDefaultValuePlugin_22", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                    this.getView().showTipNotification(this.getPageCache().get(DIMENSIONNUM) + this.getPageCache().get(DEFAULTVALUENAME) + failTips);
                    return;
                }
            }
            String opDes = operationDes.length() > 255 ? operationDes.substring(0, 255) : operationName;
            this.writeMultiLangLog(opName, OPDescMultiLangEnumBridge.genUnTransBridge((String)opDes));
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"MemberDefaultValuePlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
    }

    private boolean checkDimensionMemIsDelete(List<DynamicObject> dataList, Long modelid) {
        QFilter qcf = new QFilter(MODEL, "=", (Object)modelid);
        block30: for (DynamicObject dy : dataList) {
            String defaultValue = dy.getString(DEFAULTVALUEID);
            if (!StringUtils.isNotEmpty((String)defaultValue)) continue;
            QFilter qcf1 = new QFilter("id", "=", (Object)Long.parseLong(defaultValue));
            switch (dy.getString(DIMENSION)) {
                case "Entity": {
                    if (this.memberIsDeleted("bcm_entitymembertree", dy, new QFilter[]{qcf, qcf1})) continue block30;
                    return false;
                }
                case "Account": {
                    if (this.memberIsDeleted("bcm_accountmembertree", dy, new QFilter[]{qcf, qcf1})) continue block30;
                    return false;
                }
                case "Scenario": {
                    if (this.memberIsDeleted("bcm_scenemembertree", dy, new QFilter[]{qcf, qcf1})) continue block30;
                    return false;
                }
                case "Year": {
                    if (this.memberIsDeleted("bcm_fymembertree", dy, new QFilter[]{qcf, qcf1})) continue block30;
                    return false;
                }
                case "Period": {
                    if (this.memberIsDeleted("bcm_periodmembertree", dy, new QFilter[]{qcf, qcf1})) continue block30;
                    return false;
                }
                case "Process": {
                    if (this.memberIsDeleted("bcm_processmembertree", dy, new QFilter[]{qcf, qcf1})) continue block30;
                    return false;
                }
                case "Currency": {
                    if (this.memberIsDeleted("bcm_currencymembertree", dy, new QFilter[]{qcf, qcf1})) continue block30;
                    return false;
                }
                case "AuditTrail": {
                    if (this.memberIsDeleted("bcm_audittrialmembertree", dy, new QFilter[]{qcf, qcf1})) continue block30;
                    return false;
                }
                case "ChangeType": {
                    if (this.memberIsDeleted("bcm_changetypemembertree", dy, new QFilter[]{qcf, qcf1})) continue block30;
                    return false;
                }
                case "DataSort": {
                    if (this.memberIsDeleted("bcm_datasortmembertree", dy, new QFilter[]{qcf, qcf1})) continue block30;
                    return false;
                }
                case "MultiGAAP": {
                    if (this.memberIsDeleted("bcm_rulemembertree", dy, new QFilter[]{qcf, qcf1})) continue block30;
                    return false;
                }
                case "MyCompany": {
                    if (this.memberIsDeleted("bcm_mycompanymembertree", dy, new QFilter[]{qcf, qcf1})) continue block30;
                    return false;
                }
                case "InternalCompany": {
                    if (this.memberIsDeleted("bcm_icmembertree", dy, new QFilter[]{qcf, qcf1})) continue block30;
                    return false;
                }
            }
            if (this.memberIsDeleted("bcm_userdefinedmembertree", dy, new QFilter[]{qcf, qcf1})) continue;
            return false;
        }
        return true;
    }

    private boolean memberIsDeleted(String entityName, DynamicObject dy, QFilter[] filters) {
        this.getPageCache().put(DIMENSIONNUM, dy.getString(DIMENSION));
        this.getPageCache().put(DEFAULTVALUENAME, dy.getString(DEFAULTVALUE));
        return QueryServiceHelper.exists((String)entityName, (QFilter[])filters);
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
        if (model != null) {
            String modelId = model.getString("id");
            UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
        }
    }

    private void pageLog(StringBuilder operationDes) {
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
        String pageName = "";
        if ("bcm_adjustoffset_entry".equals(this.getModel().getValue(USEDINMENU))) {
            pageName = this.getAdjustText();
        } else if ("bcm_analyticssolutiondata".equals(this.getModel().getValue(USEDINMENU))) {
            pageName = this.getOlapQueryText();
        }
        String modelName = model.getLocaleString(NAME).getLocaleValue();
        operationDes.append(String.format(ResManager.loadKDString((String)"\u8bbe\u7f6e%1$s%2$s\u9875\u9762\u9ed8\u8ba4\u503c", (String)"MemberDefaultValuePlugin_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), modelName, pageName));
    }

    private void compareData(StringBuilder changeCon, List<DynamicObject> addNewList, List<DynamicObject> updateList, List<DynamicObject> deleteList) {
        Long userId = this.getUserId();
        Date time = TimeServiceHelper.now();
        MainEntityType bcmdefaultvalueType = EntityMetadataCache.getDataEntityType((String)"bcm_defaultvalue");
        String oldDatas = this.getView().getPageCache().get(OLDDATAS);
        DynamicObjectCollection entryentityNew = this.getModel().getEntryEntity(ENTRYENTITY);
        DynamicObjectCollection clone = (DynamicObjectCollection)entryentityNew.clone();
        if (oldDatas != null) {
            Object[] entryentityOld;
            for (Object item : entryentityOld = DynamicObjectSerializeUtil.deserialize((String)oldDatas, (DynamicObjectType)bcmdefaultvalueType)) {
                DynamicObject dy = (DynamicObject)item;
                String dimension = dy.getString(DIMENSION);
                String dimensionMap = this.getView().getPageCache().get(DIMENSIONMAP);
                HashMap hashMap = (HashMap)JSON.parseObject((String)dimensionMap, HashMap.class);
                String dimensionName = (String)hashMap.get(dimension);
                Optional<DynamicObject> ownDoL = entryentityNew.stream().filter(d -> dimension.equals(d.get(DIMENSION))).findFirst();
                if (!ownDoL.isPresent()) {
                    changeCon.append(String.format(ResManager.loadKDString((String)"\u5220\u9664%1$s\u7ef4\u5ea6\u7684\u9ed8\u8ba4\u503c\u4e3a%2$s;", (String)"MemberDefaultValuePlugin_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), dimensionName, dy.get(DEFAULTVALUE)));
                    dy.set(MODIFIERFIELD, (Object)userId);
                    dy.set(MODIFYTIME, (Object)time);
                    deleteList.add(dy);
                    continue;
                }
                DynamicObject dimDy = ownDoL.get();
                if (!dy.get(DEFAULTVALUE).equals(dimDy.getString(DEFAULTVALUE))) {
                    changeCon.append(String.format(ResManager.loadKDString((String)"\u4fee\u6539%1$s\u7ef4\u5ea6\u7684\u9ed8\u8ba4\u503c\u4e3a%2$s\uff1b", (String)"MemberDefaultValuePlugin_18", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), dimensionName, dy.get(DEFAULTVALUE)));
                    dy.set(DEFAULTVALUE, dimDy.get(DEFAULTVALUE));
                    dy.set(DEFAULTVALUEID, dimDy.get(DEFAULTVALUEID));
                    dy.set(DEFAULTNUMBER, dimDy.get(DEFAULTNUMBER));
                    dy.set(MODIFIERFIELD, (Object)userId);
                    dy.set(MODIFYTIME, (Object)time);
                    updateList.add(dy);
                }
                if (!clone.contains((Object)dimDy)) continue;
                clone.remove((Object)dimDy);
            }
        }
        this.addNew(changeCon, addNewList, clone);
    }

    private void addNew(StringBuilder changeCon, List<DynamicObject> addNewList, DynamicObjectCollection leaveDys) {
        if (!leaveDys.isEmpty()) {
            for (DynamicObject dynamicObject : leaveDys) {
                String dimension = dynamicObject.getString(DIMENSION);
                String dimensionMap = this.getView().getPageCache().get(DIMENSIONMAP);
                HashMap hashMap = (HashMap)JSON.parseObject((String)dimensionMap, HashMap.class);
                String dimensionName = (String)hashMap.get(dimension);
                changeCon.append(String.format(ResManager.loadKDString((String)"\u65b0\u589e%1$s\u7ef4\u5ea6\u7684\u9ed8\u8ba4\u503c\u4e3a%2$s\uff1b", (String)"MemberDefaultValuePlugin_19", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), dimensionName, dynamicObject.get(DEFAULTVALUE)));
                DynamicObject newData = BusinessDataServiceHelper.newDynamicObject((String)"bcm_defaultvalue");
                newData.set(MODEL, this.getModel().getValue(MODEL));
                newData.set(USEDINMENU, this.getModel().getValue(USEDINMENU));
                newData.set(DIMENSION, (Object)dynamicObject.getString(DIMENSION));
                newData.set(HIDEN, (Object)dynamicObject.getString(HIDEN));
                newData.set(SCOPE, this.getModel().getValue(SCOPE));
                newData.set(DEFAULTVALUE, (Object)dynamicObject.getString(DEFAULTVALUE));
                newData.set(DEFAULTVALUEID, (Object)dynamicObject.getString(DEFAULTVALUEID));
                newData.set(DEFAULTNUMBER, (Object)dynamicObject.getString(DEFAULTNUMBER));
                newData.set("creatorid", (Object)this.getUserId());
                newData.set("createdate", (Object)TimeServiceHelper.now());
                newData.set(MODIFIERFIELD, (Object)this.getUserId());
                newData.set(MODIFYTIME, (Object)TimeServiceHelper.now());
                addNewList.add(newData);
            }
        }
    }

    private String checkPageData() {
        List ownDoL;
        String checkRsultmessage = null;
        if (this.getModel().getValue(MODEL) == null || this.getModel().getValue(USEDINMENU) == null) {
            checkRsultmessage = ResManager.loadKDString((String)"\u4f53\u7cfb\u6216\u9002\u7528\u529f\u80fd\u83dc\u5355\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"MemberDefaultValuePlugin_25", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            return checkRsultmessage;
        }
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (!entryentity.isEmpty() && !(ownDoL = entryentity.stream().filter(d -> StringUtils.isEmpty((String)d.getString(DIMENSION)) || StringUtils.isEmpty((String)d.getString(DEFAULTVALUE))).collect(Collectors.toList())).isEmpty()) {
            checkRsultmessage = ResManager.loadKDString((String)"\u5b58\u5728\u6ca1\u6709\u5f55\u5165\u7684\u4fe1\u606f\u3002", (String)"MemberDefaultValuePlugin_21", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            return checkRsultmessage;
        }
        if (!this.checkDimensionMemIsDelete((List<DynamicObject>)entryentity, this.getModelId())) {
            String failTips = ResManager.loadKDString((String)"\u5df2\u88ab\u5220\u9664\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"MemberDefaultValuePlugin_22", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            checkRsultmessage = this.getPageCache().get(DIMENSIONNUM) + this.getPageCache().get(DEFAULTVALUENAME) + failTips;
        }
        return checkRsultmessage;
    }

    @Override
    protected void invokeOperation(String entityName, String pluginPath, String name, String closeCallBackKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bcm_batch_bos_importstart");
        HashMap<String, Object> parameter = new HashMap<String, Object>(16);
        ArrayList plugins = new ArrayList(10);
        LinkedHashMap<String, Object> plugin = new LinkedHashMap<String, Object>(16);
        plugin.put("Type", 0);
        plugin.put("_Type_", "Plugin");
        plugin.put("ClassName", pluginPath);
        plugin.put("Enabled", Boolean.TRUE);
        plugin.put("rowKey", null);
        plugin.put("modelid", this.getModelId());
        plugins.add(plugin);
        parameter.put("plugins", plugins);
        parameter.putAll(this.getCustomParam2Import());
        showParameter.setCustomParams(parameter);
        showParameter.setCustomParam("BillFormId", (Object)entityName);
        showParameter.setCustomParam("ListName", (Object)name);
        showParameter.setCustomParam("OperateKey", (Object)"donothing");
        showParameter.setCustomParam("fromDimDefaultValue", (Object)"DimDefaultValueBatchImport");
        showParameter.setCustomParam("ServiceAppId", (Object)this.getView().getFormShowParameter().getServiceAppId());
        showParameter.setCustomParam("modelid", (Object)this.getModelId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBackKey));
        this.getView().showForm(showParameter);
    }
}

