/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.org.model.StatusEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.MultiBaseEditElement;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.BCMBaseFunction;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;

public class MemberReferListPlugin
extends AbstractBaseFormPlugin
implements BCMBaseFunction,
DynamicPage {
    private static final String MODEL_F7 = "model";
    private static final String DIM_COMB = "dimension";
    private static final String MEMBER_F7 = "member";
    private static final String MEMBER_FLEX = "memberflex";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String DIM_NAME = "dimname";
    private static final String MEM_NUM = "number";
    private static final String MEM_NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String DETAIL = "detail";
    private static final String CHECK_TYPE = "type";
    private static final String DIM_NUMBER = "dimnumber";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
        MulBasedataEdit base = (MulBasedataEdit)this.getControl(MEMBER_F7);
        base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        String key = ((BasedataEdit)evt.getSource()).getKey();
        if (MEMBER_F7.equals(key)) {
            long modelId = this.getModelId();
            String dimNum = (String)this.getModel().getValue(DIM_COMB);
            QFilter qf = new QFilter(MODEL_F7, "=", (Object)modelId);
            qf.and(DIM_COMB, "=", (Object)MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum));
            qf.and("status", "!=", (Object)StatusEnum.TempSave.toString());
            evt.getCustomQFilters().add(qf);
            evt.getFormShowParameter().setCustomParam("plugin", (Object)"MemberReferListPlugin");
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Long[] memIds;
        super.afterCreateNewData(e);
        long modelId = (Long)this.getView().getFormShowParameter().getCustomParam(MODEL_F7);
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
        this.getModel().setValue(MODEL_F7, (Object)modelId);
        this.initDimCombValues(modelId);
        long dimId = (Long)this.getView().getFormShowParameter().getCustomParam(DIM_COMB);
        String dimNum = MemberReader.getDimensionNumById((long)dimId);
        this.getModel().setValue(DIM_COMB, (Object)dimNum);
        String entityName = (String)this.getView().getFormShowParameter().getCustomParam("entityName");
        this.addMemberF7ByDim(entityName);
        JSONArray jsonMemIds = (JSONArray)this.getView().getFormShowParameter().getCustomParam("memIds");
        if (jsonMemIds != null && jsonMemIds.size() > 0 && (memIds = (Long[])jsonMemIds.toArray((Object[])new Long[0])).length > 0) {
            this.getModel().setValue(MEMBER_F7, (Object)memIds);
            this.queryAllMemberRefers(modelId, dimId);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "model": {
                Object oldValue = e.getChangeSet()[0].getOldValue();
                DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL_F7);
                if (model == null) {
                    this.getModel().setValue(MODEL_F7, oldValue);
                    return;
                }
                this.initDimCombValues(model.getLong("id"));
                this.getModel().setValue(MEMBER_F7, null);
                this.getModel().deleteEntryData(ENTRY_ENTITY);
                this.getModel().setValue(DIM_COMB, (Object)SysDimensionEnum.Entity.getNumber());
                this.getPageCache().put("KEY_MODEL_ID", model.getString("id"));
                break;
            }
            case "dimension": {
                this.setFormIdOfMemberF7();
                break;
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("bar_search".equals(itemKey) || "refresh".equals(itemKey)) {
            Object model = this.getModel().getValue(MODEL_F7);
            if (model == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"MemberReferListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            long modelId = ((DynamicObject)model).getLong("id");
            String dimNum = (String)this.getModel().getValue(DIM_COMB);
            Long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum);
            this.queryAllMemberRefers(modelId, dimId);
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        super.hyperLinkClick(arg0);
        int rowIndex = arg0.getRowIndex();
        DynamicObject rowDy = this.getModel().getEntryRowEntity(ENTRY_ENTITY, rowIndex);
        Map allReferMapped = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("all_refer_mapped"), Map.class);
        String type = rowDy.getString(CHECK_TYPE);
        if ("bcm_invrelation".equals(type)) {
            Map id2Mapped = (Map)allReferMapped.get(type);
            String sign = "bcm_entitymembertree".equals(rowDy.getString(DIM_NUMBER)) ? "org" : "ic";
            List memCombs = (List)id2Mapped.get(rowDy.getLong("id") + "!" + sign);
            FormShowParameter form = new FormShowParameter();
            form.setFormId("bcm_invrela_refreport");
            form.setCustomParam("memCombs", (Object)memCombs);
            form.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            form.setPageId(this.getView().getPageId() + "_formmemrefer_" + rowDy.getString("id"));
            this.getView().showForm(form);
        } else if ("bcm_templateentity".equals(type)) {
            Map id2Mapped = (Map)allReferMapped.get(type);
            Map tmpRefers = (Map)id2Mapped.get(rowDy.getString("id"));
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bcm_dimensionreport");
            parameter.setCaption(ResManager.loadKDString((String)"\u7ef4\u5ea6\u5f15\u7528\u62a5\u544a", (String)"DimensionDisplayList_110", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCustomParam("reportTemplate", (Object)tmpRefers);
            this.getView().showForm(parameter);
        }
    }

    private void queryAllMemberRefers(long modelId, long dimId) {
        DynamicObjectCollection selectMembers = (DynamicObjectCollection)this.getModel().getValue(MEMBER_F7);
        if (selectMembers.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u5458", (String)"MemberReferListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Long> selectMemIds = selectMembers.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList());
        DynamicObject dimObj = MemberReader.getDimensionDynById((long)dimId);
        String entityName = dimObj.getString("membermodel");
        String dimNum = dimObj.getString(MEM_NUM);
        Set<String> list = this.getALLNodeIds(modelId, dimNum, entityName, selectMemIds);
        String selectField = "id,number,longnumber,storagetype,name";
        if ("bcm_entitymembertree".equals(entityName)) {
            selectField = selectField + ",isinnerorg,parent.storagetype";
        }
        List memberIds = LongUtil.toLongList(list);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)entityName, (String)selectField, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)memberIds)});
        HashMap<Long, String> idNameMap = new HashMap<Long, String>(dys.size());
        for (DynamicObject dy : dys) {
            idNameMap.put(dy.getLong("id"), dy.getString(MEM_NAME));
        }
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        this.checkInvQuery(entityName, modelId, memberIds, result);
        this.checkTemplateEntity(modelId, dimNum, idNameMap, result);
        this.checkInvChange(modelId, dimObj, memberIds, result);
        this.displayResult(dimObj, result);
    }

    private void checkInvChange(long modelId, DynamicObject dimObj, List<Long> memberIds, Map<String, Object> result) {
        String entityName = dimObj.getString("membermodel");
        String dimNum = dimObj.getString(MEM_NUM);
        QFilter qModel = new QFilter(MODEL_F7, "=", (Object)modelId);
        DynamicObjectCollection shareCases = QueryServiceHelper.query((String)"bcm_invsharecase", (String)"id, name", (QFilter[])qModel.toArray());
        Map<Long, String> id2Names = shareCases.stream().collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getString(MEM_NAME), (v1, v2) -> v1));
        if (SysDimensionEnum.getEnumByNumber((String)dimNum) != null) {
            HashMap<String, Set> id2Msg = new HashMap<String, Set>(16);
            String invcp = ResManager.loadKDString((String)"\u88ab\u6295\u8d44\u65b9\u6848", (String)"MemberReferListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String shd = ResManager.loadKDString((String)"\u6295\u8d44\u65b9\u6848", (String)"MemberReferListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            if (DimTypesEnum.ENTITY.getNumber().equals(dimNum)) {
                DynamicObjectCollection shareholders;
                QFilter qFilter = new QFilter("investeecompany", "in", memberIds);
                DynamicObjectCollection invces = QueryServiceHelper.query((String)"bcm_invchangeentry", (String)"investeecompany", (QFilter[])new QFilter[]{qModel, qFilter});
                if (invces.size() > 0) {
                    for (DynamicObject invce : invces) {
                        String msg = String.format("%s;%s;%s", MemberReader.findEntityMemberById((Long)modelId, (Long)invce.getLong("investeecompany")).getNumber(), " ", invcp);
                        long orgId = invce.getLong("investeecompany");
                        String kId = orgId + "!" + "org";
                        id2Msg.computeIfAbsent(kId, k -> new LinkedHashSet(10)).add(msg);
                    }
                    result.put("bcm_invchangeentry", id2Msg);
                }
                String modelNumber = MemberReader.findModelNumberById((Object)modelId);
                Set icIds = memberIds.stream().map(id -> MemberReader.findEntityMemberById((Long)modelId, (Long)id)).filter(orgMember -> orgMember.getStorageType() == StorageTypeEnum.STORAGE).map(IDNumberTreeNode::getNumber).map(number -> MemberReader.findMemberByNumber((String)modelNumber, (String)"InternalCompany", (String)number)).map(IDNumberTreeNode::getId).collect(Collectors.toSet());
                if (!icIds.isEmpty()) {
                    QFilter shareQf = new QFilter("shareholder", "in", icIds);
                    qFilter.or(shareQf);
                }
                if ((shareholders = QueryServiceHelper.query((String)"bcm_invsharerela", (String)"investeecompany, shareholder, sharecase", (QFilter[])new QFilter[]{qModel, qFilter})).size() > 0) {
                    for (DynamicObject sharehol : shareholders) {
                        String kId;
                        String msg = "";
                        long orgId = sharehol.getLong("investeecompany");
                        if (memberIds.contains(orgId)) {
                            IDNumberTreeNode investeecompany = MemberReader.findMemberById((long)modelId, (String)entityName, (Long)sharehol.getLong("investeecompany"));
                            msg = String.format("%s;%s;%s", investeecompany.getNumber(), id2Names.get(sharehol.getLong("sharecase")), invcp);
                            kId = sharehol.getLong("investeecompany") + "!" + "org";
                        } else {
                            IDNumberTreeNode shareholder = MemberReader.findMemberById((long)modelId, (String)"bcm_icmembertree", (Long)sharehol.getLong("shareholder"));
                            msg = String.format("%s;%s;%s", shareholder.getNumber(), sharehol.getString("sharecase"), shd);
                            kId = sharehol.getLong("shareholder") + "!" + "ic";
                        }
                        id2Msg.computeIfAbsent(kId, k -> new LinkedHashSet(10)).add(msg);
                    }
                    result.put("bcm_invchangeentry", id2Msg);
                }
            } else if (DimTypesEnum.INTERCOMPANY.getNumber().equals(dimNum)) {
                QFilter qFilter = new QFilter("shareholder", "in", memberIds);
                DynamicObjectCollection invsharerelas = QueryServiceHelper.query((String)"bcm_invsharerela", (String)"shareholder, sharecase", (QFilter[])new QFilter[]{qModel, qFilter});
                DynamicObjectCollection invchangeentrys = QueryServiceHelper.query((String)"bcm_invchangeentry", (String)"shareholder", (QFilter[])new QFilter[]{qModel, qFilter});
                HashMap<String, DynamicObjectCollection> dys = new HashMap<String, DynamicObjectCollection>(16);
                dys.put("invsharerelas", invsharerelas);
                dys.put("invchangeentrys", invchangeentrys);
                dys.forEach((key, values) -> {
                    if (values.size() > 0) {
                        for (DynamicObject dy : values) {
                            IDNumberTreeNode shareholder = MemberReader.findMemberById((long)modelId, (String)entityName, (Long)dy.getLong("shareholder"));
                            String msg = "";
                            msg = "invsharerelas".equals(key) ? String.format("%s;%s;%s", shareholder.getNumber(), id2Names.get(dy.getString("sharecase")), shd) : String.format("%s;%s;%s", shareholder.getNumber(), " ", shd);
                            String kId = dy.getLong("shareholder") + "!" + "ic";
                            id2Msg.computeIfAbsent(kId, k -> new LinkedHashSet(10)).add(msg);
                        }
                        result.put("bcm_invchangeentry", id2Msg);
                    }
                });
            }
        }
    }

    private void addMemberF7ByDim(String entityName) {
        List items = ((Container)this.getControl(MEMBER_FLEX)).getItems();
        if (items.size() > 0) {
            items.remove(0);
        }
        MultiBaseEditElement beEle = new MultiBaseEditElement(ResManager.loadKDString((String)"\u6210\u5458", (String)"MemberReferListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MEMBER_F7, entityName);
        beEle.setMustInput(true);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("30px");
        margin.setTop("10px");
        margin.setBottom("35px");
        style.setMargin(margin);
        beEle.setStyle(style);
        beEle.setLabelDirection("v");
        Page page = new Page();
        Area area = new Area(MEMBER_FLEX);
        area.addElement((Element)beEle);
        page.addArea(area);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
    }

    private void initDimCombValues(long modelId) {
        QFilter qf = new QFilter(MODEL_F7, "=", (Object)modelId);
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id, name, number", (QFilter[])qf.toArray(), (String)"dseq");
        if (dims.size() > 0) {
            ComboEdit comboEdit = (ComboEdit)this.getControl(DIM_COMB);
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(dims.size());
            for (DynamicObject dynamicObject : dims) {
                String name = dynamicObject.getString(MEM_NAME);
                String number = dynamicObject.getString(MEM_NUM);
                ComboItem comboItem = new ComboItem(new LocaleString(name), number);
                items.add(comboItem);
            }
            comboEdit.setComboItems(items);
        }
    }

    private void setFormIdOfMemberF7() {
        String value = (String)this.getModel().getValue(DIM_COMB);
        QFilter qf = new QFilter(MODEL_F7, "=", (Object)this.getModelId());
        qf.and(MEM_NUM, "=", (Object)value);
        DynamicObject dimDy = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id, membermodel", (QFilter[])qf.toArray());
        this.addMemberF7ByDim(dimDy.getString("membermodel"));
        this.getModel().setValue(MEMBER_F7, null);
        this.getModel().deleteEntryData(ENTRY_ENTITY);
    }

    private Set<String> getALLNodeIds(long modelId, String dimNum, String entityName, List<Long> nodeIds) {
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        HashSet ids = new HashSet(nodeIds.size());
        nodeIds.forEach(id -> this.getChildren(modelId, entityName, (long)id, ids));
        HashSet shareIds = new HashSet(16);
        ((Map)MemberReader.getAllNodeByNumber2ShareNodeFromCache((String)entityName, (String)modelNum).get(dimNum)).values().forEach(v -> v.forEach(d -> {
            if (d.getCopyfromId() != null && ids.contains(d.getCopyfromId())) {
                shareIds.add(d.getId());
            }
        }));
        ids.addAll(shareIds);
        shareIds.forEach(id -> this.getChildren(modelId, entityName, (long)id, ids));
        HashSet<String> allIds = new HashSet<String>(ids.size());
        ids.forEach(id -> allIds.add(String.valueOf(id)));
        return allIds;
    }

    private void getChildren(long modelId, String entityName, long memberId, Set<Long> ids) {
        ids.add(memberId);
        MemberReader.findMemberById((long)modelId, (String)entityName, (Long)memberId).getChildrenIds().forEach(child -> this.getChildren(modelId, entityName, (long)child, ids));
    }

    private void displayResult(DynamicObject dimObj, Map<String, Object> result) {
        long modelId = ((DynamicObject)this.getModel().getValue(MODEL_F7)).getLong("id");
        String entityName = dimObj.getString("membermodel");
        String dimName = dimObj.getString(MEM_NAME);
        HashMap<String, String> dimNum2Name = new HashMap<String, String>(16);
        Collection values = MemberReader.getDimensionNumber2nameMap((String)MemberReader.findModelNumberById((Object)modelId)).values();
        values.forEach(x -> {
            String[] dims = x.split(";");
            dimNum2Name.put(dims[0], dims[1]);
        });
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        Iterator<Map.Entry<String, Object>> iterator = result.entrySet().iterator();
        if (result.size() == 0) {
            return;
        }
        this.getPageCache().put("all_refer_mapped", SerializationUtils.toJsonString(result));
        while (iterator.hasNext()) {
            Map.Entry<String, Object> next = iterator.next();
            String key = next.getKey();
            Object value = next.getValue();
            if (value == null) {
                return;
            }
            if ("bcm_invrelation".equals(key)) {
                this.setInvRelationValues(value, modelId, dimNum2Name);
                continue;
            }
            if ("bcm_templateentity".equals(key)) {
                this.setTemplateValues(value, modelId, entityName, dimName);
                continue;
            }
            if (!"bcm_invchangeentry".equals(key)) continue;
            this.setInvChangeAndShareHolValue(value, modelId, dimNum2Name);
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.setPageIndex(1);
    }

    private void setInvChangeAndShareHolValue(Object value, long modelId, Map<String, String> dimNum2Name) {
        Map id2Msg = (Map)value;
        if (id2Msg.size() == 0) {
            return;
        }
        int i = this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, id2Msg.size())[0];
        Iterator idIte = id2Msg.keySet().iterator();
        while (idIte.hasNext()) {
            long memId;
            String[] id2sign = ((String)idIte.next()).split("!");
            if (id2sign.length != 2) {
                return;
            }
            boolean flag = "org".equals(id2sign[1]);
            String entityId = flag ? "bcm_entitymembertree" : "bcm_icmembertree";
            IDNumberTreeNode memberById = MemberReader.findMemberById((long)modelId, (String)entityId, (Long)(memId = Long.parseLong(id2sign[0])));
            if (memberById == IDNumberTreeNode.NotFoundTreeNode) continue;
            this.getModel().setValue(DIM_NAME, (Object)(flag ? dimNum2Name.get(SysDimensionEnum.Entity.getNumber()) : dimNum2Name.get(SysDimensionEnum.InternalCompany.getNumber())), i);
            this.getModel().setValue(MEM_NUM, (Object)memberById.getNumber(), i);
            this.getModel().setValue(MEM_NAME, (Object)memberById.getName(), i);
            this.getModel().setValue(DESCRIPTION, (Object)ResManager.loadKDString((String)"\u80a1\u6743\u53ca\u6743\u76ca\u4fe1\u606f\u7ef4\u62a4\u5f15\u7528", (String)"MemberReferListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i);
            this.getModel().setValue(DETAIL, (Object)"", i);
            this.getModel().setValue(CHECK_TYPE, (Object)"bcm_invchangeentry", i);
            this.getModel().setValue(DIM_NUMBER, (Object)entityId, i);
            this.getModel().setValue("id", (Object)memId, i);
            ++i;
        }
    }

    private void setTemplateValues(Object value, long modelId, String entityName, String dimName) {
        Map id2Msg = (Map)value;
        if (id2Msg.size() == 0) {
            return;
        }
        int i = this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, id2Msg.size())[0];
        for (Long memId : id2Msg.keySet()) {
            IDNumberTreeNode memberById = MemberReader.findMemberById((long)modelId, (String)entityName, (Long)memId);
            if (memberById == IDNumberTreeNode.NotFoundTreeNode) continue;
            this.getModel().setValue(DIM_NAME, (Object)dimName, i);
            this.getModel().setValue(MEM_NUM, (Object)memberById.getNumber(), i);
            this.getModel().setValue(MEM_NAME, (Object)memberById.getName(), i);
            this.getModel().setValue(DESCRIPTION, (Object)ResManager.loadKDString((String)"\u62a5\u8868\u6a21\u677f\u5f15\u7528", (String)"MemberReferListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i);
            this.getModel().setValue(DETAIL, (Object)ResManager.loadKDString((String)"\u62a5\u8868\u6a21\u677f\u5f15\u7528\u62a5\u544a", (String)"MemberReferListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i);
            this.getModel().setValue(CHECK_TYPE, (Object)"bcm_templateentity", i);
            this.getModel().setValue(DIM_NUMBER, (Object)entityName, i);
            this.getModel().setValue("id", (Object)memId, i);
            ++i;
        }
    }

    private void setInvRelationValues(Object value, long modelId, Map<String, String> dimNum2Name) {
        Map id2Msg = (Map)value;
        if (id2Msg.size() == 0) {
            return;
        }
        int i = this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, id2Msg.size())[0];
        Iterator idIte = id2Msg.keySet().iterator();
        while (idIte.hasNext()) {
            long memId;
            String[] id2sign = ((String)idIte.next()).split("!");
            if (id2sign.length != 2) {
                return;
            }
            boolean flag = "org".equals(id2sign[1]);
            String entityId = flag ? "bcm_entitymembertree" : "bcm_icmembertree";
            IDNumberTreeNode memberById = MemberReader.findMemberById((long)modelId, (String)entityId, (Long)(memId = Long.parseLong(id2sign[0])));
            if (memberById == IDNumberTreeNode.NotFoundTreeNode) continue;
            this.getModel().setValue(DIM_NAME, (Object)(flag ? dimNum2Name.get(SysDimensionEnum.Entity.getNumber()) : dimNum2Name.get(SysDimensionEnum.InternalCompany.getNumber())), i);
            this.getModel().setValue(MEM_NUM, (Object)memberById.getNumber(), i);
            this.getModel().setValue(MEM_NAME, (Object)memberById.getName(), i);
            this.getModel().setValue(DESCRIPTION, (Object)ResManager.loadKDString((String)"\u6240\u6709\u6743\u8bbe\u7f6e\u5f15\u7528", (String)"MemberReferListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i);
            this.getModel().setValue(DETAIL, (Object)ResManager.loadKDString((String)"\u6240\u6709\u6743\u5f15\u7528\u62a5\u544a", (String)"MemberReferListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i);
            this.getModel().setValue(CHECK_TYPE, (Object)"bcm_invrelation", i);
            this.getModel().setValue(DIM_NUMBER, (Object)entityId, i);
            this.getModel().setValue("id", (Object)memId, i);
            ++i;
        }
    }

    private void checkInvQuery(String entityName, long modelId, List<Long> memberIds, Map<String, Object> result) {
        if ("bcm_entitymembertree".equals(entityName) || "bcm_icmembertree".equals(entityName)) {
            QFilter inQf;
            Set<Object> icIds = new HashSet(10);
            if ("bcm_entitymembertree".equals(entityName)) {
                inQf = new QFilter("investeecompany", "in", memberIds);
                String modelNumber = MemberReader.findModelNumberById((Object)modelId);
                icIds = memberIds.stream().map(id -> MemberReader.findEntityMemberById((Long)modelId, (Long)id)).filter(orgMember -> orgMember.getStorageType() == StorageTypeEnum.STORAGE).map(IDNumberTreeNode::getNumber).map(number -> MemberReader.findMemberByNumber((String)modelNumber, (String)"InternalCompany", (String)number)).map(IDNumberTreeNode::getId).collect(Collectors.toSet());
                if (!icIds.isEmpty()) {
                    QFilter shareQf = new QFilter("shareholder", "in", icIds);
                    inQf.or(shareQf);
                }
            } else {
                inQf = new QFilter("shareholder", "in", memberIds);
            }
            QFBuilder qfBuilder = new QFBuilder().add(MODEL_F7, "=", (Object)modelId).and("isdelete", "=", (Object)Character.valueOf('0')).add(inQf);
            if (QueryServiceHelper.exists((String)"bcm_invrelation", (QFilter[])qfBuilder.toArray())) {
                String selectFields = "scenario.number sn,year.number yn,period.number pn,orgunit.number on,investeecompany,shareholder";
                DynamicObjectCollection relations = QueryServiceHelper.query((String)"bcm_invrelation", (String)selectFields, (QFilter[])qfBuilder.toArray());
                HashMap<String, Set> id2Msg = new HashMap<String, Set>(16);
                for (DynamicObject relation : relations) {
                    long orgId;
                    String msg = String.format("%s;%s;%s;%s", relation.getString("on"), relation.getString("sn"), relation.getString("yn"), relation.getString("pn"));
                    String kId = "bcm_entitymembertree".equals(entityName) ? (memberIds.contains(orgId = relation.getLong("investeecompany")) ? relation.getLong("investeecompany") + "!" + "org" : relation.getLong("shareholder") + "!" + "ic") : relation.getLong("shareholder") + "!" + "ic";
                    id2Msg.computeIfAbsent(kId, k -> new LinkedHashSet(10)).add(msg);
                }
                result.put("bcm_invrelation", id2Msg);
            }
        }
    }

    private void checkTemplateEntity(long modelId, String dimNum, Map<Long, String> idNameMap, Map<String, Object> result) {
        DynamicObjectCollection filterDimDyns;
        DynamicObjectCollection viewDyns;
        DynamicObjectCollection pageDyns;
        DynamicObjectCollection rowDyns;
        QFilter qf = new QFilter(MODEL_F7, "=", (Object)modelId);
        Set<Long> list = idNameMap.keySet();
        String fields = "id,number,name,";
        String colIdStr = "areapositionentry.colmembdetail.colmembid";
        String rowIdStr = "areapositionentry.rowmembdetail.rowmembid";
        String pageIdStr = "pagemembentry.pagemembid,pagemembentry.membbound";
        String pageId = "pagemembentry.pagemembid";
        String viewIdStr = "viewpointmembentry.viewmembid";
        String filterDimId = "filtermembentry.filtermembid";
        String filterDimIdStr = "filtermembentry.filtermembid,filtermembentry.filtermemproperty";
        DynamicObjectCollection colDyns = QueryServiceHelper.query((String)"bcm_templateentity", (String)(fields + colIdStr), (QFilter[])new QFilter[]{qf, new QFilter(colIdStr, "in", (Object)list.toArray())});
        int size = (colDyns == null ? 0 : colDyns.size()) + ((rowDyns = QueryServiceHelper.query((String)"bcm_templateentity", (String)(fields + rowIdStr), (QFilter[])new QFilter[]{qf, new QFilter(rowIdStr, "in", (Object)list.toArray())})) == null ? 0 : rowDyns.size()) + ((pageDyns = QueryServiceHelper.query((String)"bcm_templateentity", (String)(fields + pageIdStr), (QFilter[])new QFilter[]{qf, new QFilter(pageId, "in", (Object)list.toArray())})) == null ? 0 : pageDyns.size()) + ((viewDyns = QueryServiceHelper.query((String)"bcm_templateentity", (String)(fields + viewIdStr), (QFilter[])new QFilter[]{qf, new QFilter(viewIdStr, "in", (Object)list.toArray())})) == null ? 0 : viewDyns.size()) + ((filterDimDyns = QueryServiceHelper.query((String)"bcm_templateentity", (String)(fields + filterDimIdStr), (QFilter[])new QFilter[]{qf, new QFilter(filterDimId, "in", (Object)list.toArray())})) == null ? 0 : filterDimDyns.size());
        if (size > 0) {
            String prefix = "";
            if ("InternalCompany".equals(dimNum)) {
                prefix = DimTypesEnum.INTERCOMPANY.getName() + " : ";
            } else if ("MyCompany".equals(dimNum)) {
                prefix = DimTypesEnum.MYCOMPANY.getName() + " : ";
            }
            HashMap<Long, Map<String, List<Map<String, String>>>> memRefers = new HashMap<Long, Map<String, List<Map<String, String>>>>(16);
            if (colDyns != null && colDyns.size() > 0) {
                this.fillReportItems(idNameMap, colDyns, "col", colIdStr, prefix, memRefers);
            }
            if (rowDyns != null && rowDyns.size() > 0) {
                this.fillReportItems(idNameMap, rowDyns, "row", rowIdStr, prefix, memRefers);
            }
            if (pageDyns != null && pageDyns.size() > 0) {
                this.fillReportItems(idNameMap, pageDyns, "page", pageId, prefix, memRefers);
            }
            if (viewDyns != null && viewDyns.size() > 0) {
                this.fillReportItems(idNameMap, viewDyns, "view", viewIdStr, prefix, memRefers);
            }
            if (filterDimDyns != null && filterDimDyns.size() > 0) {
                this.fillReportItems(idNameMap, filterDimDyns, "filter", filterDimId, prefix, memRefers);
            }
            result.put("bcm_templateentity", memRefers);
        }
    }

    private void fillReportItems(Map<Long, String> idNameMap, DynamicObjectCollection dyns, String sign, String field, String prefix, Map<Long, Map<String, List<Map<String, String>>>> memRefers) {
        dyns.forEach(dyn -> {
            Long memId = dyn.getLong(field);
            Map reportMap = memRefers.computeIfAbsent(memId, k -> new HashMap(16));
            HashMap<String, String> map = new HashMap<String, String>(4);
            map.put(MEM_NUM, dyn.getString(MEM_NUM));
            map.put(MEM_NAME, dyn.getString(MEM_NAME));
            map.put(DIM_COMB, prefix + (String)idNameMap.get(memId));
            reportMap.computeIfAbsent(sign, k -> new ArrayList(10)).add(map);
        });
    }
}

