/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension;

import java.util.Arrays;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.exchangeRate.ExchageRateServiceHelper;
import kd.fi.bcm.common.AppUtil;
import kd.fi.bcm.common.enums.CslSchemeEnum;
import kd.fi.bcm.formplugin.database.MultipleMemberF7BasePlugin;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;

public class MultipleMemberF7DimPlugin
extends MultipleMemberF7BasePlugin
implements BeforeF7SelectListener {
    private static final String cslscheme = "cslscheme";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit scheme = (BasedataEdit)this.getControl(cslscheme);
        scheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    protected void setCslscheme(DynamicObject dim) {
        if (this.isCM() && dim.getString("number").equals("Entity")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{cslscheme});
            String schemeId = (String)this.getView().getFormShowParameter().getCustomParam(cslscheme);
            if (schemeId == null) {
                QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
                filter.and("nodetype", "=", (Object)1);
                DynamicObjectCollection coll = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id,number", (QFilter[])new QFilter[]{filter}, (String)"level");
                if (!coll.isEmpty()) {
                    for (DynamicObject dot : coll) {
                        if (!CslSchemeEnum.Default.getNumber().equals(dot.getString("number"))) continue;
                        this.getModel().setValue(cslscheme, (Object)dot.getLong("id"));
                        return;
                    }
                    this.getModel().setValue(cslscheme, (Object)((DynamicObject)coll.get(0)).getLong("id"));
                }
            } else {
                DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"bcm_cslscheme");
                if (scheme.getInt("nodetype") == 1) {
                    this.getModel().setValue(cslscheme, (Object)scheme.getLong("id"));
                } else {
                    QFilter filter2;
                    QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
                    DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id,longnumber", (QFilter[])new QFilter[]{filter, filter2 = new QFilter("nodetype", "=", (Object)1)}, (String)"level,longnumber");
                    if (!collection.isEmpty()) {
                        for (DynamicObject dot : collection) {
                            if (!dot.getString("longnumber").startsWith(CslSchemeEnum.Default.getNumber())) continue;
                            this.getModel().setValue(cslscheme, (Object)dot.getLong("id"));
                            return;
                        }
                        this.getModel().setValue(cslscheme, (Object)((DynamicObject)collection.get(0)).getLong("id"));
                    }
                }
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{cslscheme});
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = event.getProperty().getName();
        if (key.equals(cslscheme)) {
            ListShowParameter l = (ListShowParameter)event.getFormShowParameter();
            ListFilterParameter lsp = l.getListFilterParameter();
            lsp.getQFilters().add(new QFilter("model", "=", (Object)this.getModelId()));
            lsp.getQFilters().add(new QFilter("nodetype", "=", (Object)"1"));
        }
    }

    @Override
    public long getModelId() {
        return Long.parseLong(this.getPageCache().get("modelid"));
    }

    @Override
    protected DynamicObjectCollection getPresetMemberDoc(String dimensionid) {
        String entityName = this.getPageCache().get("membermodel");
        String selectFields = "id,name,number,parent,storagetype,longnumber";
        QFilter filter1 = new QFilter("dimension", "=", (Object)dimensionid);
        if ("bcm_entitymembertree".equals(entityName)) {
            selectFields = selectFields.concat(",level,dseq");
            if (this.isCM()) {
                DynamicObject scheme = (DynamicObject)this.getModel().getValue(cslscheme);
                if (scheme == null) {
                    filter1.and("1", "=", (Object)0);
                } else {
                    filter1.and(cslscheme, "=", (Object)scheme.getLong("id"));
                }
            }
        }
        if (this.getView().getFormShowParameter().getCustomParam("rootid") != null) {
            long rootId = (Long)this.getView().getFormShowParameter().getCustomParam("rootid");
            DynamicObject oo = QueryServiceHelper.queryOne((String)entityName, (String)"longnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)rootId)});
            String longnumber = oo.getString("longnumber");
            filter1.and(new QFilter("longnumber", "like", (Object)(longnumber + "!%")));
            filter1.or(new QFilter("id", "=", (Object)rootId));
        }
        ExchageRateServiceHelper.delExchangeRatePlanFilter((QFilter)filter1, (String)entityName);
        this.filterFyAndPeriod(filter1, entityName);
        if ("bcm_audittrialmembertree".equals(entityName) && AppUtil.isEpmAppId((String)ModelUtil.queryApp(this.getView()).getAppnum())) {
            filter1.and(new QFilter("number", "not in", Arrays.asList("ADJE", "CWP", "ManualJournal", "AutoJournal")));
        }
        QFilter[] filters = new QFilter[]{filter1};
        String orderBys = this.getPresetMemberOrder();
        if (AppUtil.isEpmAppId((String)this.getView().getFormShowParameter().getAppId()) && "bcm_entitymembertree".equals(entityName)) {
            selectFields = selectFields + ",entitypart.isoffsetentry";
            DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys);
            query.removeIf(dy -> dy.getBoolean("entitypart.isoffsetentry"));
            return query;
        }
        return QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (cslscheme.equals(key)) {
            this.setMenberTree();
        }
    }
}

