/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension;

import java.util.Arrays;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.ExtDimensionHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.dimension.util.DimensionUtil;

public class NewEnumItemEdit
extends AbstractFormPlugin
implements ClickListener {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            String enumItemId = (String)this.getView().getFormShowParameter().getCustomParam("enumitemKeyID");
            if (QueryServiceHelper.exists((String)"bcm_enumvalue_new", (QFilter[])new QFilter("enumitemid", "=", (Object)Long.parseLong(enumItemId)).toArray())) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"datatype"});
            }
            String number = (String)this.getModel().getValue("number");
            this.getView().setEnable(Boolean.valueOf(StringUtils.isEmpty((String)number)), new String[]{"number"});
        }
        boolean isAllowMulti = (Boolean)this.getModel().getValue("isallowmulti");
        this.getView().setEnable(Boolean.valueOf(isAllowMulti), new String[]{"multiseparator"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"bar_cancel", "bar_add"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Button) {
            int maxSeq;
            if ("bar_cancel".equals(((Control)evt.getSource()).getKey())) {
                if (!this.getModel().getDataChanged()) {
                    this.getView().close();
                }
                return;
            }
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            long modelId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
            Long enumItemId = LongUtil.toLong((Object)this.getModel().getValue("id"));
            OrmLocaleValue newName = (OrmLocaleValue)this.getModel().getValue("name");
            String number = String.valueOf(this.getModel().getValue("number"));
            String message = DimensionUtil.checkNumber(number);
            if (OperationStatus.ADDNEW == status && StringUtils.isNotEmpty((String)message)) {
                this.getView().showTipNotification(message);
                return;
            }
            QFilter mFilter = new QFilter("model", "=", (Object)modelId);
            QFilter idFilter = new QFilter("id", "!=", (Object)enumItemId);
            QFilter nameFilter = new QFilter("name", "=", (Object)newName.getLocaleValue());
            QFilter numberFilter = new QFilter("number", "=", (Object)number);
            if (QueryServiceHelper.exists((String)"bcm_enumitem_new", (QFilter[])new QFilter[]{mFilter, idFilter, numberFilter})) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\u3002", (String)"EnumItemEdit_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (QueryServiceHelper.exists((String)"bcm_enumitem_new", (QFilter[])new QFilter[]{mFilter, idFilter, nameFilter})) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\u3002", (String)"EnumItemEdit_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            String datatype = String.valueOf(this.getModel().getValue("datatype"));
            boolean isAllowMulti = (Boolean)this.getModel().getValue("isallowmulti");
            if (isAllowMulti && !DataTypeEnum.TXT.getOIndex().equals(datatype)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4ec5\u4e3a\u6587\u672c\u65f6\uff0c\u5141\u8bb8\u679a\u4e3e\u503c\u591a\u9009\u3002", (String)"EnumItemEdit_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_enumitem_new", (String)"dseq", (QFilter[])mFilter.toArray(), (String)"dseq desc");
            int n = maxSeq = docs.size() > 0 ? ((DynamicObject)docs.get(0)).getInt("dseq") : 0;
            if (OperationStatus.ADDNEW == status) {
                DynamicObject enumItem = BusinessDataServiceHelper.newDynamicObject((String)"bcm_enumitem_new");
                enumItem.set("number", this.getModel().getValue("number"));
                enumItem.set("name", (Object)newName);
                enumItem.set("datatype", (Object)datatype);
                enumItem.set("model", (Object)modelId);
                enumItem.set("dseq", (Object)(maxSeq + 1));
                enumItem.set("isonlyleaf", this.getModel().getValue("isonlyleaf"));
                enumItem.set("isallowmulti", this.getModel().getValue("isallowmulti"));
                enumItem.set("multiseparator", this.getModel().getValue("multiseparator"));
                enumItem.set("remark", this.getModel().getValue("remark"));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{enumItem});
                OperationLogUtil.writeOperationLog((String)(OpItemEnum.ENUMITEM.getName() + "-" + OpItemEnum.ADD.getName()), (String)(newName.getLocaleValue() + " " + OpItemEnum.ADD.getName() + ResultStatusEnum.SUCCESS.getName()), (Long)modelId, (String)"bcm_enumitem_new");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"EnumItemEdit_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else if (OperationStatus.EDIT == status) {
                DynamicObject enumItem = BusinessDataServiceHelper.loadSingle((Object)enumItemId, (String)"bcm_enumitem_new");
                String name = enumItem.getString("name");
                Object dataType = this.getModel().getValue("datatype");
                enumItem.set("number", this.getModel().getValue("number"));
                enumItem.set("name", this.getModel().getValue("name"));
                enumItem.set("datatype", dataType);
                enumItem.set("isonlyleaf", this.getModel().getValue("isonlyleaf"));
                enumItem.set("isallowmulti", this.getModel().getValue("isallowmulti"));
                enumItem.set("multiseparator", this.getModel().getValue("multiseparator"));
                enumItem.set("remark", this.getModel().getValue("remark"));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{enumItem});
                DynamicObject[] enumValue = BusinessDataServiceHelper.load((String)"bcm_enumvalue_new", (String)"name,datatype", (QFilter[])new QFilter("enumitemid", "=", (Object)enumItem.getLong("id")).toArray());
                Arrays.stream(enumValue).forEach(v -> {
                    v.set("datatype", (Object)enumItem.getString("datatype"));
                    v.set("name", (Object)enumItem.getString("name"));
                });
                SaveServiceHelper.save((DynamicObject[])enumValue);
                OperationLogUtil.writeOperationLog((String)(OpItemEnum.ENUMITEM.getName() + OpItemEnum.EDIT.getName()), (String)(OpItemEnum.NAME.getName() + name + OpItemEnum.CHANGETO.getName() + newName + " " + OpItemEnum.EDIT.getName() + ResultStatusEnum.SUCCESS.getName()), (Long)enumItem.getLong("model.id"), (String)"bcm_enumitem_new");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f\u3002", (String)"EnumItemEdit_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            ExtDimensionHelper.clearCommonCacheForExtendDimEnumItemDataType((long)modelId);
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("isallowmulti".equals(e.getProperty().getName())) {
            if (((Boolean)e.getChangeSet()[0].getNewValue()).booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"multiseparator"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"multiseparator"});
            }
        }
    }
}

