/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension;

import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.dimension.EnumValueEdit;
import kd.fi.bcm.formplugin.util.RegexUtils;

public class NewEnumValueEdit
extends EnumValueEdit
implements ClickListener,
BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit parent = (BasedataEdit)this.getControl("parent");
        parent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void click(EventObject evt) {
        QFilter itemFilter;
        QFilter numberFilter;
        QFilter idFilter;
        if ("bar_cancel".equals(((Control)evt.getSource()).getKey())) {
            if (!this.getModel().getDataChanged()) {
                this.getView().close();
            }
            return;
        }
        String number = String.valueOf(this.getModel().getValue("number"));
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW == status && !RegexUtils.isOnlyNumberAndString(number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u4e3a\u6570\u5b57\u3002", (String)"EnumList_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        String datatype = (String)this.getModel().getValue("datatype");
        Long enumValueId = LongUtil.toLong((Object)this.getModel().getValue("id"));
        boolean isText = DataTypeEnum.TXT.index.equals(datatype);
        String enumName = this.getEnumValue();
        if (StringUtils.isEmpty((CharSequence)enumName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u7167\u6570\u636e\u7c7b\u578b\uff0c\u8f93\u5165\u679a\u4e3e\u503c\u4fe1\u606f\u3002", (String)"EnumValueEdit_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String enumItemID = (String)this.getView().getFormShowParameter().getCustomParam("enumitemKey");
        QFilter mFilter = new QFilter("model", "=", (Object)modelId);
        if (QueryServiceHelper.exists((String)"bcm_enumvalue_new", (QFilter[])new QFilter[]{mFilter, idFilter = new QFilter("id", "!=", (Object)enumValueId), numberFilter = new QFilter("number", "=", (Object)number), itemFilter = new QFilter("enumitemid", "=", (Object)Long.parseLong(enumItemID))})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\u3002", (String)"EnumItemEdit_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter filter = new QFilter("enumitemid", "=", (Object)Long.parseLong(enumItemID));
        filter.and(idFilter);
        filter.and(new QFilter("enumvalue", "=", (Object)(isText ? ((OrmLocaleValue)this.getModel().getValue("enumvalue")).getLocaleValue() : enumName)));
        if (QueryServiceHelper.exists((String)"bcm_enumvalue_new", (QFilter[])filter.toArray())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\u3002", (String)"EnumValueEdit_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        long parentId = this.getModel().getValue("parent") != null ? ((DynamicObject)this.getModel().getValue("parent")).getLong("id") : 0L;
        DynamicObject parent = null;
        if (parentId != 0L) {
            parent = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)"bcm_enumvalue_new");
        }
        if (OperationStatus.ADDNEW == status) {
            DynamicObject enumItem = BusinessDataServiceHelper.loadSingle((String)"bcm_enumitem_new", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(enumItemID))});
            DynamicObject enumValueObj = ORM.create().newDynamicObject("bcm_enumvalue_new");
            enumValueObj.set("enumvalue", isText ? this.getModel().getValue("enumvalue") : new LocaleString(enumName));
            enumValueObj.set("name", enumItem.get("name"));
            enumValueObj.set("parent", (Object)parentId);
            enumValueObj.set("isleaf", (Object)1);
            enumValueObj.set("number", (Object)number);
            enumValueObj.set("datatype", this.getModel().getValue("datatype"));
            enumValueObj.set("enumitemid", (Object)Long.parseLong(enumItemID));
            enumValueObj.set("model", (Object)modelId);
            DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_enumvalue_new", (String)"dseq", (QFilter[])new QFilter("parent", "=", (Object)parentId).toArray(), (String)"dseq desc");
            int maxSeq = docs.size() > 0 ? ((DynamicObject)docs.get(0)).getInt("dseq") : 0;
            enumValueObj.set("dseq", (Object)(maxSeq + 1));
            if (parent != null) {
                parent.set("isleaf", (Object)0);
                enumValueObj.set("longnumber", (Object)(parent.getString("longnumber") + "!" + number));
                enumValueObj.set("level", (Object)(parent.getInt("level") + 1));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{parent});
            } else {
                enumValueObj.set("level", (Object)1);
                enumValueObj.set("longnumber", (Object)number);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{enumValueObj});
            OperationLogUtil.writeOperationLog((String)(OpItemEnum.ENUM.getName() + "-" + OpItemEnum.ADD.getName()), (String)(OpItemEnum.ENUMITEM.getName() + enumItem.getString("name") + " " + OpItemEnum.ENUMVALUE.getName() + enumName + "," + OpItemEnum.ADD.getName() + ResultStatusEnum.SUCCESS.getName()), (Long)modelId, (String)"bcm_enumvalue_new");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"EnumValueEdit_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else if (OperationStatus.EDIT == status) {
            DynamicObject enumValueObj = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("id"), (String)"bcm_enumvalue_new");
            long oldPid = enumValueObj.getLong("parent.id");
            String oldLongNumber = enumValueObj.getString("longnumber");
            int oldLevel = enumValueObj.getInt("level");
            enumValueObj.set("number", this.getModel().getValue("number"));
            enumValueObj.set("enumvalue", isText ? this.getModel().getValue("enumvalue") : new LocaleString(enumName));
            enumValueObj.set("parent", (Object)parentId);
            if (parent != null) {
                enumValueObj.set("longnumber", (Object)(parent.getString("longnumber") + "!" + number));
                enumValueObj.set("level", (Object)(parent.getInt("level") + 1));
                parent.set("isleaf", (Object)0);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{parent});
            } else {
                enumValueObj.set("level", (Object)1);
                enumValueObj.set("longnumber", (Object)number);
            }
            if (parentId != oldPid) {
                DynamicObjectCollection docs;
                QFilter oFilter = new QFilter("parent", "=", (Object)oldPid);
                oFilter.and(new QFilter("id", "!=", (Object)enumValueObj.getLong("id")));
                if (!QueryServiceHelper.exists((String)"bcm_enumvalue_new", (QFilter[])oFilter.toArray())) {
                    DynamicObject oldParent = BusinessDataServiceHelper.loadSingle((Object)oldPid, (String)"bcm_enumvalue_new");
                    oldParent.set("isleaf", (Object)1);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{oldParent});
                }
                int maxSeq = (docs = QueryServiceHelper.query((String)"bcm_enumvalue_new", (String)"dseq", (QFilter[])new QFilter("parent", "=", (Object)parentId).toArray(), (String)"dseq desc")).size() > 0 ? ((DynamicObject)docs.get(0)).getInt("dseq") : 0;
                enumValueObj.set("dseq", (Object)(maxSeq + 1));
                QFilter lFilter = new QFilter("longnumber", "like", (Object)(oldLongNumber + "!%"));
                DynamicObject[] child = BusinessDataServiceHelper.load((String)"bcm_enumvalue_new", (String)"longnumber,level", (QFilter[])new QFilter[]{mFilter, itemFilter, lFilter});
                int levelDiff = parent == null ? -oldLevel : parent.getInt("level") - oldLevel;
                for (DynamicObject c : child) {
                    c.set("longnumber", (Object)c.getString("longnumber").replaceFirst(oldLongNumber, enumValueObj.getString("longnumber")));
                    c.set("level", (Object)(c.getInt("level") + levelDiff + 1));
                }
                SaveServiceHelper.save((DynamicObject[])child);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{enumValueObj});
            OperationLogUtil.writeOperationLog((String)(OpItemEnum.ENUM.getName() + "-" + OpItemEnum.EDIT.getName()), (String)(OpItemEnum.ENUMITEM.getName() + enumValueObj.getString("name") + " " + OpItemEnum.ENUMVALUE.getName() + enumName + "," + OpItemEnum.EDIT.getName() + ResultStatusEnum.SUCCESS.getName()), (Long)modelId, (String)"bcm_enumvalue_new");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f\u3002", (String)"EnumValueEdit_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.getView().returnDataToParent((Object)"refreshEntry");
        this.getModel().setDataChanged(false);
        this.getView().close();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"enumvalue_double"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"enumvalue_date"});
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            String enumItemId = (String)this.getView().getFormShowParameter().getCustomParam("enumitemKey");
            this.getPageCache().put("enumitemID", enumItemId);
            String enumItemName = (String)this.getView().getFormShowParameter().getCustomParam("enumitemname");
            this.getModel().setValue("name", (Object)enumItemName);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"name"});
            String datatype = (String)this.getView().getFormShowParameter().getCustomParam("datatype");
            this.getModel().setValue("datatype", (Object)datatype);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"datatype"});
            this.changeType(datatype);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            String number = (String)this.getModel().getValue("number");
            this.getView().setEnable(Boolean.valueOf(StringUtils.isEmpty((CharSequence)number)), new String[]{"number"});
            Object issysenumvalue = this.getModel().getValue("issysenumvalue");
            if (issysenumvalue != null) {
                this.getView().setEnable(Boolean.valueOf((Integer)issysenumvalue == 0), new String[]{"enumvalue", "enumvalue_date", "enumvalue_double"});
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        if (e.getProperty().getName().equals("parent")) {
            long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
            long enumItemId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("enumitemKey"));
            long id = LongUtil.toLong((Object)this.getModel().getValue("id"));
            e.getFormShowParameter().setCustomParam("KEY_MODEL_ID", (Object)modelId);
            e.getFormShowParameter().setCustomParam("enumitemKey", (Object)enumItemId);
            QFilter qf = new QFilter("model", "=", (Object)modelId);
            qf.and(new QFilter("enumitemid", "=", (Object)enumItemId));
            qf.and(new QFilter("id", "!=", this.getModel().getValue("id")));
            if (id != 0L) {
                String longNumber = QueryServiceHelper.queryOne((String)"bcm_enumvalue_new", (String)"longnumber", (QFilter[])new QFilter("id", "=", (Object)id).toArray()).getString("longnumber");
                qf.and(new QFilter("longnumber", "not like", (Object)(longNumber + "!%")));
                e.getFormShowParameter().setCustomParam("longNumber", (Object)longNumber);
                e.getFormShowParameter().setCustomParam("pkid", (Object)id);
            }
            ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
            param.getListFilterParameter().setFilter(qf);
        }
    }
}

