/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.dimension.helper.ExtDimensionHelper;
import kd.fi.bcm.business.dimension.helper.SaveDimMemberHelper;
import kd.fi.bcm.business.dimension.struct.ShareNodeStructSyncHelper;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.business.tree.dimension.DimensionTreeNode;
import kd.fi.bcm.business.util.LanguageUtil;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.log.DimMemberOperateTypeEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.formplugin.dimension.NewSharingTree;
import kd.fi.bcm.formplugin.util.ReportListUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class NewExtSharingTree
extends NewSharingTree {
    protected static String dimensionCacheKey = "select";
    private static final String dimensionNumberCacheKey = "dimensionnumber";
    private static final String modelCacheKey = "defaultModel";
    private static final String rightFocusNodeId = "rightFocusNodeId";
    private static final String memberCacheKey = "memberCache";
    private static final String treeentryentity = "treeentryentity";
    private static final String rightTree = "righttree";
    private static final String ISEXTDIM = "isextdim";
    private static final String LLIST = "lrowlist";
    private static final String RLIST = "rrowlist";
    private static final String EXTFIELD_NUM = "ExtField_Num";
    private static final String EXTFIELD_TEXT = "ExtField_Text";
    private static final String EXTFIELD_DATE = "ExtField_Date";
    private static final String textPrefix = "textext";
    private static final String numPrefix = "numext";
    private static final String datePrefix = "dateext";

    @Override
    public void registerListener(EventObject e) {
        if ("bcm_structofextend".equals(this.getView().getFormShowParameter().getCustomParam("memberentity"))) {
            this.addClickListeners(new String[]{"bar_cancel", "bar_add", "btngo", "btnremove", "btnallremove", "vectorap", "vectorap1", "vectorap2", "vectorap11"});
            Search sl = (Search)this.getControl("searchapleft");
            Search sr = (Search)this.getControl("searchapright");
            sl.addEnterListener(new SearchEnterListener(){

                public void search(SearchEnterEvent var1) {
                    if (var1.getText() != null && !"".equals(var1.getText())) {
                        NewExtSharingTree.this.searchLeftMember(var1.getText().toLowerCase(Locale.ENGLISH).trim());
                    } else {
                        NewExtSharingTree.this.getPageCache().put(NewExtSharingTree.LLIST, null);
                        NewExtSharingTree.this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                    }
                }
            });
            sr.addEnterListener(new SearchEnterListener(){

                public void search(SearchEnterEvent var1) {
                    if (var1.getText() != null && !"".equals(var1.getText())) {
                        NewExtSharingTree.this.searchRightMember(var1.getText().toLowerCase(Locale.ENGLISH).trim());
                    } else {
                        NewExtSharingTree.this.getPageCache().put(NewExtSharingTree.RLIST, null);
                        NewExtSharingTree.this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                    }
                }
            });
            TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(treeentryentity);
            treeEntry.addCellClickListener((TreeNodeQueryListener)this);
            TreeView rightTreeV = (TreeView)this.getView().getControl("treeright");
            rightTreeV.addTreeNodeClickListener(new TreeNodeClickListener(){

                public void treeNodeClick(TreeNodeEvent evt) {
                    NewExtSharingTree.this.rightTreeNodeClick(evt);
                }
            });
            rightTreeV.addTreeNodeQueryListener(new TreeNodeQueryListener(){

                public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
                    TreeView treeView = (TreeView)treeNodeEvent.getSource();
                    String curNodeId = (String)treeNodeEvent.getNodeId();
                    NewExtSharingTree.this.pullRightTreeNextLevel(treeView, curNodeId);
                }
            });
        } else {
            super.registerListener(e);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        if (!"bcm_entitymembertree".equals(this.getView().getFormShowParameter().getCustomParam("memberentity"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"userproperty"});
        }
        if ("bcm_structofextend".equals(this.getView().getFormShowParameter().getCustomParam("memberentity"))) {
            this.getPageCache().put(ISEXTDIM, Boolean.TRUE.toString());
            this.cacheParam();
            this.safeCombox();
            SplitContainer container = (SplitContainer)this.getControl("splitcontainerap");
            container.hidePanel(SplitDirection.left, true);
            this.initExtLeftTree(null);
            TreeView treeRight = (TreeView)this.getView().getControl("treeright");
            this.pullRightTreeNextLevel(treeRight, null);
        } else {
            super.afterCreateNewData(e);
        }
    }

    private void cacheParam() {
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        String dimensionId = (String)this.getView().getFormShowParameter().getCustomParam("dimensionId");
        String memberKey = (String)this.getView().getFormShowParameter().getCustomParam("memberentity");
        String dimensionnumber = (String)this.getView().getFormShowParameter().getCustomParam(dimensionNumberCacheKey);
        this.getPageCache().put(dimensionNumberCacheKey, dimensionnumber);
        this.getPageCache().put(modelCacheKey, modelId);
        this.getPageCache().put(dimensionCacheKey, dimensionId);
        this.getPageCache().put(memberCacheKey, memberKey);
    }

    private void rightTreeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        this.getPageCache().put(rightFocusNodeId, nodeId);
    }

    private void safeCombox() {
        ComboEdit edit = (ComboEdit)this.getControl("selectdimension");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(1);
        String selectName = (String)this.getView().getFormShowParameter().getCustomParam("dimensionname");
        items.add(new ComboItem(new LocaleString(selectName), selectName));
        edit.setComboItems(items);
        this.getModel().getDataEntity().set("selectdimension", (Object)selectName);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"selectdimension"});
    }

    private void initExtLeftTree(String cslschemeIdStr) {
        long dimensionId = Long.parseLong(this.getPageCache().get(dimensionCacheKey));
        long modelid = Long.parseLong(this.getPageCache().get(modelCacheKey));
        this.getModel().deleteEntryData(treeentryentity);
        Optional<DynamicObject> root = this.listTreeLevelRoot(dimensionId, "bcm_structofextend", modelid);
        if (root.isPresent()) {
            IDataModel model = this.getModel();
            model.deleteEntryData(treeentryentity);
            model.getDataEntity(true);
            model.beginInit();
            model.batchCreateNewEntryRow(treeentryentity, 1);
            model.endInit();
            DynamicObject rootNodeV = model.getEntryRowEntity(treeentryentity, 0);
            rootNodeV.set("number", (Object)root.get().getString("number"));
            rootNodeV.set("name", (Object)root.get().getString("name"));
            rootNodeV.set("storagetype", (Object)root.get().getString("storagetype"));
            rootNodeV.set("id", (Object)root.get().getLong("id"));
            rootNodeV.set("pid", (Object)0);
            rootNodeV.set("isgroupnode", (Object)(!root.get().getBoolean("isleaf") ? 1 : 0));
            this.updateLeftViewNextLevel(0);
            TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(treeentryentity);
            treeEntry.expandOne(0);
            this.getView().updateView(treeentryentity);
        }
    }

    private Optional<DynamicObject> listTreeLevelRoot(long dimensionid, String entityName, long modelid) {
        QFilter filterdimension = new QFilter("dimension", "=", (Object)dimensionid);
        filterdimension.and("parent", "=", (Object)0L);
        filterdimension.and("model", "=", (Object)modelid);
        DynamicObjectCollection root = QueryServiceHelper.query((String)this.getClass().getName(), (String)entityName, (String)"id", (QFilter[])filterdimension.toArray(), (String)"id asc", (int)1);
        Long parentId = null;
        if (root.isEmpty()) {
            return Optional.empty();
        }
        parentId = ((DynamicObject)root.get(0)).getLong("id");
        return Optional.of(this.getOrgCollectionForShare(entityName, new QFilter("id", "=", (Object)parentId).toArray(), "level").get(0));
    }

    private void updateLeftViewNextLevel(int appendEntryIndex) {
        Long dimensionId = Long.valueOf(this.getPageCache().get(dimensionCacheKey));
        Long modelid = Long.valueOf(this.getPageCache().get(modelCacheKey));
        long parentId = this.getModel().getEntryRowEntity(treeentryentity, appendEntryIndex).getLong("id");
        DynamicObjectCollection child = this.listLeftTreeLevelMembers(modelid, dimensionId, "bcm_structofextend", parentId);
        List<Integer> groupIndexes = this.updateLeftTreeView(child, parentId, appendEntryIndex, "bcm_structofextend");
        if (!groupIndexes.isEmpty()) {
            int[] _index = new int[groupIndexes.size()];
            for (int j = 0; j < groupIndexes.size(); ++j) {
                _index[j] = groupIndexes.get(j);
            }
            TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(treeentryentity);
            treeEntry.collapse(_index);
        }
    }

    private DynamicObjectCollection listLeftTreeLevelMembers(long modelid, long dimensionId, String entityName, Long parentId) {
        if (Objects.isNull(parentId)) {
            throw new IllegalArgumentException("this method requires the param parentId");
        }
        QFilter memberFilter = new QFilter("model.id", "=", (Object)modelid);
        memberFilter.and(new QFilter("dimension.id", "=", (Object)dimensionId));
        memberFilter.and(new QFilter("storagetype", "!=", (Object)"3"));
        memberFilter.and("parent", "=", (Object)parentId);
        return this.getOrgCollectionForShare(entityName, memberFilter.toArray(), "level,dseq");
    }

    private void pullRightTreeNextLevel(TreeView treeView, String clickNodeId) {
        FormShowParameter parameters = this.getView().getFormShowParameter();
        Long dimensionId = Long.valueOf((String)parameters.getCustomParam("dimensionId"));
        Long modelId = Long.valueOf((String)parameters.getCustomParam("KEY_MODEL_ID"));
        String entitynumber = this.getPageCache().get(memberCacheKey);
        if (StringUtils.isEmpty((CharSequence)clickNodeId)) {
            Optional<DynamicObject> root = this.listTreeLevelRoot(dimensionId, entitynumber, modelId);
            if (!root.isPresent()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f3a\u5c11\u6839\u8282\u70b9\u8fdb\u884c\u65b0\u589e\u5171\u4eab\u3002", (String)"NewSharingTree_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            TreeNode rootNode = new TreeNode("", root.get().getString("id"), NewExtSharingTree.buildNodeName(root.get(), false, false), !root.get().getBoolean("isleaf"));
            rootNode.setIsOpened(true);
            treeView.deleteAllNodes();
            treeView.addNode(rootNode);
            clickNodeId = String.valueOf(root.get().getLong("id"));
            this.getPageCache().put(rightFocusNodeId, clickNodeId);
            DimensionTreeNode rootTemp = new DimensionTreeNode("root", "all");
            DynamicObjectCollection rootCollectionWrap = new DynamicObjectCollection();
            rootCollectionWrap.add(0, root.get());
            DimensionTreeNode _root = this.getDimensionTree(rootCollectionWrap, rootTemp, root.get().getString("parent"));
            this.cacheTree(_root);
        }
        String parentId = clickNodeId;
        DynamicObjectCollection child = this.listTreeLevelMembers(dimensionId, entitynumber, modelId, parentId);
        TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)rightTree);
        DimensionTreeNode rightFocusNode = (DimensionTreeNode)treeModel.searchByNodeId(clickNodeId);
        boolean isNew = this.isNeedSave(rightFocusNode);
        this.updateRightTreeModel(parentId, child, false, isNew);
    }

    private DynamicObjectCollection getOrgCollectionForShare(String entityName, QFilter[] filters, String orderBys) {
        return QueryServiceHelper.query((String)ReportListUtil.class.getName(), (String)entityName, (String)"id,name,number,parent,isleaf,storagetype,level,datatype,fieldmapped", (QFilter[])filters, (String)orderBys);
    }

    protected List<Integer> updateLeftTreeView(DynamicObjectCollection childMembers, long parentId, int appendEntryIndex, String entityName) {
        IDataModel model = this.getModel();
        if (childMembers.isEmpty()) {
            DynamicObject parentNodeV = model.getEntryRowEntity(treeentryentity, appendEntryIndex);
            parentNodeV.set("isgroupnode", (Object)false);
            return Collections.EMPTY_LIST;
        }
        model.beginInit();
        int[] newEntries = model.batchInsertEntryRow(treeentryentity, appendEntryIndex, childMembers.size());
        model.endInit();
        ArrayList<Integer> groupLineIndexes = new ArrayList<Integer>(8);
        for (int i = 0; i < childMembers.size(); ++i) {
            int entryIndex = newEntries[i];
            DynamicObject rootNodeV = model.getEntryRowEntity(treeentryentity, entryIndex);
            DynamicObject member = (DynamicObject)childMembers.get(i);
            rootNodeV.set("number", (Object)member.getString("number"));
            rootNodeV.set("name", (Object)member.getString("name"));
            rootNodeV.set("storagetype", (Object)member.getString("storagetype"));
            rootNodeV.set("id", (Object)member.getLong("id"));
            rootNodeV.set("pid", (Object)String.valueOf(parentId));
            boolean isGroup = false;
            if (!member.getBoolean("isleaf")) {
                DynamicObjectCollection members = this.findMemberById(this.getModelId(), entityName, member.getLong("id"));
                for (DynamicObject dynamicObject : members) {
                    if (StorageTypeEnum.SHARE.index.equals(dynamicObject.getString("storagetype"))) continue;
                    isGroup = true;
                    break;
                }
            }
            rootNodeV.set("isgroupnode", (Object)isGroup);
            if (!isGroup) continue;
            groupLineIndexes.add(entryIndex);
        }
        return groupLineIndexes;
    }

    private DynamicObjectCollection findMemberById(long modelId, String entityName, long id) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and(new QFilter("parent", "=", (Object)id));
        return QueryServiceHelper.query((String)entityName, (String)"number,storagetype", (QFilter[])new QFilter[]{qf});
    }

    @Override
    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        if (Boolean.TRUE.toString().equals(this.getPageCache().get(ISEXTDIM))) {
            this.updateLeftViewNextLevel(evt.getRowKey());
            TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(treeentryentity);
            treeEntry.expandOne(evt.getRowKey());
            treeEntry.selectRows(evt.getRowKey());
            treeEntry.focusCell(evt.getRowKey(), "number");
            this.getView().updateView(treeentryentity, evt.getRowKey());
            treeEntry.selectRows(new int[]{evt.getRowKey()}, evt.getRowKey());
        } else {
            super.queryTreeNodeChildren(evt);
        }
    }

    private static String buildNodeName(DynamicObject dy, boolean isChildForShare, boolean isNew) {
        String storageTypeName = isChildForShare || isNew ? DimensionTreeNode.getStorage((String)"3") : DimensionTreeNode.getStorage((String)dy.getString("storagetype"));
        return dy.getString("number") + " " + dy.getString("name") + storageTypeName;
    }

    private void cacheTree(DimensionTreeNode root) {
        TreeModel treemodel = new TreeModel((ITreeNode)root);
        treemodel.ache2page(this.getPageCache(), rightTree);
    }

    private DynamicObjectCollection listTreeLevelMembers(long dimensionid, String entityName, long modelId, String parentId) {
        if (Objects.isNull(parentId)) {
            throw new IllegalArgumentException("this method requires the param parentId");
        }
        QFilter filters = new QFilter("dimension", "=", (Object)dimensionid);
        filters.and("model", "=", (Object)modelId);
        filters.and("parent", "=", (Object)Long.valueOf(parentId));
        return this.getOrgCollectionForShare(entityName, filters.toArray(), "level,dseq");
    }

    private boolean isNeedSave(DimensionTreeNode node) {
        if (node == null) {
            return false;
        }
        if (node.isNeadsave()) {
            return true;
        }
        if (node.getParent() != null) {
            return this.isNeedSave(node.getParent());
        }
        return false;
    }

    private DimensionTreeNode getDimensionTree(DynamicObjectCollection rootNodeList, DimensionTreeNode parent, String rootParentId) {
        Iterator iter = rootNodeList.iterator();
        HashMap<String, DimensionTreeNode> IdNodeMap = new HashMap<String, DimensionTreeNode>(rootNodeList.size());
        ArrayListMultimap parent2ChildMap = ArrayListMultimap.create();
        String rootId = rootParentId;
        String dimensionNumber = ((DynamicObject)rootNodeList.get(0)).getString("number");
        while (iter.hasNext()) {
            DynamicObject map = (DynamicObject)iter.next();
            String childId = map.getString("id");
            DimensionTreeNode child = this.buildDimensionTreeNode(map, dimensionNumber, true);
            IdNodeMap.put(childId, child);
            Long parentId = map.get("parent") instanceof DynamicObject ? Long.valueOf(map.getLong("parent.id")) : Long.valueOf(map.getLong("parent"));
            if (parentId != null && parentId != 0L && !String.valueOf(parentId).equals(rootParentId)) {
                parent2ChildMap.put((Object)String.valueOf(parentId), (Object)childId);
                continue;
            }
            rootId = childId;
        }
        if (parent2ChildMap.size() == 0) {
            parent = (DimensionTreeNode)IdNodeMap.get(rootId);
            parent.SetIsOpened(true);
            parent.setParent(null);
            return parent;
        }
        for (Map.Entry entry : parent2ChildMap.asMap().entrySet()) {
            DimensionTreeNode parentNode = (DimensionTreeNode)IdNodeMap.get(entry.getKey());
            if (parentNode == null) continue;
            for (String childId : (Collection)entry.getValue()) {
                parentNode.addChild((ITreeNode)IdNodeMap.get(childId));
            }
            if (!((String)entry.getKey()).equals(rootId)) continue;
            parent = parentNode;
            parent.SetIsOpened(true);
            parent.setParent(null);
        }
        return parent;
    }

    private DimensionTreeNode buildDimensionTreeNode(DynamicObject memberDy, String rootNumber, boolean fromSync) {
        DimensionTreeNode treeNode = new DimensionTreeNode(memberDy.getString("id"), memberDy.getString("name"), memberDy.getString("number"), memberDy.getString("storagetype"), "", "", 0, memberDy.getInt("level"), 0, memberDy.getBoolean("isleaf"), false, false, "");
        treeNode.setName(treeNode.getNumber() + " " + treeNode.getName() + NewExtSharingTree.getStorage(treeNode.getStoragetype()));
        return treeNode;
    }

    private static String getStorage(String storagetype) {
        switch (storagetype) {
            case "4": {
                return ResManager.loadKDString((String)"\uff08\u4e0d\u5171\u4eab\uff09", (String)"ExtDimEditPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            case "1": {
                return ResManager.loadKDString((String)"\uff08\u6807\u7b7e\uff09", (String)"ExtDimEditPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            case "2": {
                return ResManager.loadKDString((String)"\uff08\u5b58\u50a8\uff09", (String)"ExtDimEditPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            case "3": {
                return ResManager.loadKDString((String)"\uff08\u5171\u4eab\uff09", (String)"ExtDimEditPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
        }
        return null;
    }

    private void updateRightTreeModel(String treeViewParentId, DynamicObjectCollection childMembers, boolean isChildForShare, boolean isNew) {
        if (childMembers.isEmpty()) {
            return;
        }
        HashMap sourceIdShareIdMap = new HashMap(8);
        Map idMap = StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("temp_ids")) ? (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("temp_ids")) : new HashMap(1);
        String oper_key = this.getView().getPageCache().get("oper_key");
        List childNodes = childMembers.stream().map(x -> {
            String nodeId = x.getString("id");
            if (isChildForShare) {
                nodeId = String.valueOf(GlobalIdUtil.genGlobalLongId());
                idMap.put(nodeId, x.getString("id"));
            }
            sourceIdShareIdMap.put(x.getString("id"), nodeId);
            boolean isParent = !x.getBoolean("isleaf");
            TreeNode oneNode = new TreeNode(treeViewParentId, nodeId, NewExtSharingTree.buildNodeName(x, isChildForShare, isNew), false);
            oneNode.setIsOpened(false);
            if (isParent) {
                oneNode.setChildren(new ArrayList(1));
            }
            if (isChildForShare || isNew) {
                oneNode.setColor("blue");
            }
            return oneNode;
        }).collect(Collectors.toList());
        TreeView rightTreeView = (TreeView)this.getView().getControl("treeright");
        rightTreeView.addNodes(childNodes);
        TreeModel treeModel = (TreeModel)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(rightTree));
        DimensionTreeNode treeModelRoot = (DimensionTreeNode)treeModel.getRoot();
        DimensionTreeNode targetNode = (DimensionTreeNode)treeModelRoot.getTreeNode(String.valueOf(treeViewParentId), 999);
        if (targetNode == null) {
            return;
        }
        List dimensionChild = childMembers.stream().map(x -> {
            DimensionTreeNode treeNode = this.buildDimensionTreeNode((DynamicObject)x, null, false);
            if (isChildForShare) {
                treeNode.setCopyfrom(treeNode.getId());
                treeNode.setId((String)sourceIdShareIdMap.get(treeNode.getId()));
                treeNode.setStoragetype(StorageTypeEnum.SHARE.index);
                treeNode.setNeadsave(true);
            }
            return treeNode;
        }).collect(Collectors.toList());
        dimensionChild.stream().forEach(x -> {
            if (!targetNode.getChildren().stream().map(t -> ((DimensionTreeNode)t).getNumber()).filter(t -> x.getNumber().equals(t)).findAny().isPresent()) {
                targetNode.addChild((ITreeNode)x);
            }
        });
        this.cacheTree(treeModelRoot);
        if (StringUtil.isNotEmpty((CharSequence)oper_key)) {
            this.getView().getPageCache().put("temp_ids", SerializationUtils.serializeToBase64(idMap));
        }
    }

    @Override
    public void click(EventObject evt) {
        block69: {
            block68: {
                if (!"true".equals(this.getPageCache().get(ISEXTDIM))) break block68;
                String key = ((Control)evt.getSource()).getKey();
                String dimensionid = this.getPageCache().get(dimensionCacheKey);
                String modelId = this.getPageCache().get(modelCacheKey);
                String entityname = this.getPageCache().get(memberCacheKey);
                TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)rightTree);
                if (treeModel == null) {
                    return;
                }
                TreeView treeright = (TreeView)this.getControl("treeright");
                DimensionTreeNode root = (DimensionTreeNode)treeModel.getRoot();
                String rightFocusId = this.getPageCache().get(rightFocusNodeId);
                DimensionTreeNode rightFocusNode = (DimensionTreeNode)treeModel.searchByNodeId(rightFocusId);
                switch (key) {
                    case "btngo": {
                        TreeView rightTreeV = (TreeView)this.getView().getControl("treeright");
                        rightTreeV.queryTreeNodeChildren(null, rightFocusId);
                        List<DynamicObject> leftChoseNodes = this.getCurrentSelectIds();
                        if (leftChoseNodes == null || leftChoseNodes.size() < 1) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5171\u4eab\u7684\u7ef4\u5ea6\u6210\u5458\u3002", (String)"ExtDimEditPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        if (!this.checkIsFieldMember(leftChoseNodes)) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u975e\u660e\u7ec6\u8282\u70b9\u4e0d\u80fd\u5171\u4eab\u3002", (String)"ExtDimEditPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        if (rightFocusNode != null && StorageTypeEnum.SHARE.index.equals(rightFocusNode.getStoragetype())) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5171\u4eab\u8282\u70b9\u4e0b\u7ea7\u4e0d\u5141\u8bb8\u65b0\u589e\u5171\u4eab\u3002", (String)"NewSharingTree_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        if (StringUtils.isEmpty((CharSequence)rightFocusId) || rightFocusNode == null) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u521b\u5efa\u6839\u8282\u70b9\u7684\u5171\u4eab\u6210\u5458\u3002", (String)"NewSharingTree_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        String msg = this.checkIsBizGroupMember(rightFocusId);
                        if (StringUtils.isNotEmpty((CharSequence)msg)) {
                            this.getView().showTipNotification(msg);
                            return;
                        }
                        Map<Long, Map<String, String>> pid2Id2Mapping = new HashMap<Long, Map<String, String>>(16);
                        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("pid2Id2MappingShare"))) {
                            pid2Id2Mapping = (Map)JSONObject.parseObject((String)this.getPageCache().get("pid2Id2MappingShare"), Map.class);
                        }
                        if (!this.checkMaxMappingField(leftChoseNodes, pid2Id2Mapping, Long.valueOf(rightFocusId))) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u4e1a\u52a1\u5206\u7ec4\u6210\u5458\u6570\u636e\u7c7b\u578b\u5df2\u8fbe\u5230\u6700\u5927\u503c\u3002", (String)"NewExtSharingTree_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        Map odmap = BusinessDataServiceHelper.loadFromCache((String)"bcm_structofextend", (String)"grouptype", (QFilter[])new QFilter("id", "=", (Object)rightFocusId).toArray());
                        String grouptype = ((DynamicObject)odmap.get(Long.parseLong(rightFocusId))).getString("grouptype");
                        if (!"3".equals(grouptype)) {
                            for (DynamicObject leftChoseNode : leftChoseNodes) {
                                long id = leftChoseNode.getLong("id");
                                String fieldName = pid2Id2Mapping.get(Long.parseLong(rightFocusId)).get(String.valueOf(id));
                                if (ExtDimensionHelper.checkIsExistOfField((String)fieldName, (String)grouptype)) continue;
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u6620\u5c04\u5b57\u6bb5\u5728\u5bf9\u5e94\u6570\u636e\u8868\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"NewExtSharingTree_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                                return;
                            }
                        }
                        DynamicObjectCollection child = this.listTreeLevelMembers(Long.parseLong(dimensionid), entityname, Long.parseLong(modelId), rightFocusId);
                        HashSet<Long> selectLeftIds = new HashSet<Long>(16);
                        ArrayList<String> noSaveAndRepeatNums = new ArrayList<String>(10);
                        ArrayList<String> savedAndRepeatNums = new ArrayList<String>(10);
                        long sameParentId = (Long)leftChoseNodes.get(0).get("pid");
                        for (DynamicObject leftChoseNode : leftChoseNodes) {
                            String leftNodeNum = leftChoseNode.getString("number");
                            if (sameParentId != (Long)leftChoseNode.get("pid")) {
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u91cf\u5171\u4eab\u4ec5\u652f\u6301\u540c\u4e00\u7236\u7ea7\u4e0b\u7684\u6210\u5458\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"NewSharingTree_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                                return;
                            }
                            if (child.stream().map(x -> x.getString("number")).filter(x -> leftNodeNum.equals(x)).findAny().isPresent()) {
                                savedAndRepeatNums.add(leftNodeNum);
                                continue;
                            }
                            if (rightFocusNode.getChildren().stream().map(x -> ((DimensionTreeNode)x).getNumber()).filter(x -> leftNodeNum.equals(x)).findAny().isPresent()) {
                                noSaveAndRepeatNums.add(leftNodeNum);
                                continue;
                            }
                            Long selectLeftId = leftChoseNode.getLong("id");
                            selectLeftIds.add(selectLeftId);
                        }
                        if (savedAndRepeatNums.size() > 0 || noSaveAndRepeatNums.size() > 0) {
                            if (savedAndRepeatNums.size() > 0 && noSaveAndRepeatNums.size() == 0) {
                                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53ef\u5171\u4eab%1$s\u6761\u3002%2$s \u5728\u76ee\u6807\u8282\u70b9\u4e0b\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u5171\u4eab\u3002", (String)"NewSharingTree_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]), selectLeftIds.size(), String.join((CharSequence)",", savedAndRepeatNums)));
                            } else if (savedAndRepeatNums.size() == 0 && noSaveAndRepeatNums.size() > 0) {
                                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53ef\u5171\u4eab%1$s\u6761\u3002%2$s \u5df2\u88ab\u9009\u4e2d\uff0c\u4e0d\u80fd\u91cd\u590d\u9009\u62e9\u3002", (String)"NewSharingTree_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]), selectLeftIds.size(), String.join((CharSequence)",", noSaveAndRepeatNums)));
                            } else {
                                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53ef\u5171\u4eab%1$s\u6761\u3002%2$s \u5df2\u88ab\u9009\u4e2d\uff0c\u4e0d\u80fd\u91cd\u590d\u9009\u62e9\uff1b%3$s \u5728\u76ee\u6807\u8282\u70b9\u4e0b\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u5171\u4eab\u3002", (String)"NewSharingTree_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]), selectLeftIds.size(), String.join((CharSequence)",", noSaveAndRepeatNums), String.join((CharSequence)",", savedAndRepeatNums)));
                            }
                        }
                        if (selectLeftIds.size() == 0) {
                            return;
                        }
                        DynamicObjectCollection leftNodeDys = this.getOrgCollectionForShare(entityname, new QFilter("id", "in", selectLeftIds).toArray(), "dseq");
                        this.getView().getPageCache().put("oper_key", key);
                        this.updateRightTreeModel(rightFocusId, leftNodeDys, true, false);
                        this.getPageCache().put("pid2Id2MappingShare", JSONObject.toJSONString(pid2Id2Mapping));
                        this.getPageCache().remove("sourceIdShareIdMap");
                        treeright.expand(rightFocusId);
                        break;
                    }
                    case "btnremove": {
                        if (rightFocusNode == null || !rightFocusNode.isNeadsave()) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u5220\u9664\u975e\u672c\u6b21\u64cd\u4f5c\u65b0\u589e\u8282\u70b9\u3002", (String)"NewSharingTree_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        String focusNodeParentId = rightFocusNode.getParent().getId();
                        HashSet nodes = new HashSet(16);
                        root = DimensionTreeNode.deleteChild((DimensionTreeNode)rightFocusNode, (DimensionTreeNode)root, nodes);
                        this.cacheTree(root);
                        for (DimensionTreeNode node : nodes) {
                            DimensionTreeNode parent = node.getParent();
                            if (parent.getChildren().size() == 0) {
                                String parentId = parent.getParent() == null ? "0" : parent.getParent().getId();
                                TreeNode treeNode = new TreeNode(parentId, parent.getId(), parent.getName(), false);
                                treeright.updateNode(treeNode);
                            }
                            treeright.deleteNode(node.getId());
                        }
                        treeright.focusNode(new TreeNode("0", focusNodeParentId, ""));
                        this.getPageCache().put(rightFocusNodeId, focusNodeParentId);
                        if (!StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("temp_ids")) || !StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("pid2Id2MappingShare"))) break;
                        Map map = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("temp_ids"));
                        String leftNodeId = (String)map.remove(rightFocusId);
                        Map pid2Id2mapped = (Map)JSONObject.parseObject((String)this.getPageCache().get("pid2Id2MappingShare"), Map.class);
                        Map id2Mapped = (Map)pid2Id2mapped.get(Long.parseLong(focusNodeParentId));
                        if (id2Mapped != null) {
                            id2Mapped.remove(leftNodeId);
                        }
                        this.getPageCache().put("pid2Id2MappingShare", JSONObject.toJSONString((Object)pid2Id2mapped));
                        this.getPageCache().put("temp_ids", SerializationUtils.serializeToBase64((Object)map));
                        break;
                    }
                    case "btnallremove": {
                        TreeView treeRight = (TreeView)this.getView().getControl("treeright");
                        this.pullRightTreeNextLevel(treeRight, null);
                        break;
                    }
                    case "bar_add": {
                        Throwable sourceDy;
                        ArrayList<DynamicObject> listobj = new ArrayList<DynamicObject>(10);
                        LinkedList<DimensionTreeNode> queue = new LinkedList<DimensionTreeNode>();
                        queue.add(root);
                        HashMap<String, Integer> parentToChildrenSize = new HashMap<String, Integer>(16);
                        Map pid2Id2MappingShare = (Map)JSONObject.parse((String)this.getPageCache().get("pid2Id2MappingShare"));
                        while (!queue.isEmpty()) {
                            DimensionTreeNode node = (DimensionTreeNode)queue.poll();
                            if (node.getIschanged()) {
                                this.alterIsleaf(node.getId(), entityname);
                                node.setIschanged(false);
                            }
                            if (node.isNeadsave()) {
                                node.setNeadsave(false);
                                sourceDy = BusinessDataServiceHelper.loadSingle((Object)node.getCopyfrom(), (String)entityname);
                                String parentId = node.getParent().getId();
                                DynamicObject shareParentDy = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)entityname);
                                Map trans = LanguageUtil.getTranslate((String)sourceDy.getString("name"), (String)"", (String)"fi-bcm-business");
                                sourceDy.set("name", LanguageUtil.getName((String)sourceDy.getString("name"), (Map)trans));
                                sourceDy.set("longnumber", shareParentDy.getString("longnumber") + '!' + sourceDy.getString("number"));
                                sourceDy.set("level", 3);
                                Integer tempSeq = (Integer)parentToChildrenSize.get(node.getParent().getId());
                                if (tempSeq == null) {
                                    HashSet<String> noRepeatChildren = new HashSet<String>(16);
                                    for (ITreeNode objectITreeNode : node.getParent().getChildren()) {
                                        noRepeatChildren.add(objectITreeNode.getId());
                                    }
                                    parentToChildrenSize.put(node.getParent().getId(), noRepeatChildren.size());
                                } else {
                                    parentToChildrenSize.put(node.getParent().getId(), tempSeq + 1);
                                }
                                int addLaterDseq = this.setSeqValue(modelId);
                                sourceDy.set("dseq", addLaterDseq);
                                this.getPageCache().put("addLaterDseq", String.valueOf(addLaterDseq));
                                sourceDy.set("storagetype", 3);
                                sourceDy.set("issysmember", 4);
                                Date createTime = TimeServiceHelper.now();
                                sourceDy.set("modifytime", createTime);
                                sourceDy.set("createtime", createTime);
                                DynamicObject modifierDy = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
                                modifierDy.set("id", (Object)RequestContext.get().getUserId());
                                sourceDy.set("modifier", modifierDy);
                                sourceDy.set("creator", modifierDy);
                                DynamicObject parent = BusinessDataServiceHelper.newDynamicObject((String)entityname);
                                parent.set("id", (Object)parentId);
                                sourceDy.set("parent", parent);
                                sourceDy.set("isleaf", "1");
                                sourceDy.set("fieldmapped", ((Map)pid2Id2MappingShare.get(Long.parseLong(parentId))).get(sourceDy.getString("id")));
                                DynamicObject newShareDy = (DynamicObject)OrmUtils.clone((Object)sourceDy, (IDataEntityType)sourceDy.getDataEntityType(), (boolean)true, (boolean)true);
                                DynamicObject copyfrom = new DynamicObject(newShareDy.getDynamicObjectType());
                                copyfrom.set("id", (Object)sourceDy.getLong("id"));
                                newShareDy.set("copyfrom", (Object)copyfrom);
                                newShareDy.set("id", (Object)node.getId());
                                listobj.add(newShareDy);
                            }
                            node.getChildren().forEach(e -> queue.add((DimensionTreeNode)e));
                        }
                        if (listobj.isEmpty()) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u672a\u4fdd\u5b58\u6570\u636e\u3002", (String)"NewSharingTree_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        sourceDy = null;
                        try (TXHandle th = TX.requiresNew();){
                            try {
                                SaveDimMemberHelper.saveLog(listobj, (DimMemberOperateTypeEnum)DimMemberOperateTypeEnum.NEW_SHARE);
                                this.updateOriginParentIsLeafProperty(entityname, parentToChildrenSize.keySet());
                                BusinessDataWriter.save((IDataEntityType)((DynamicObject)listobj.get(0)).getDataEntityType(), (Object[])listobj.toArray());
                            }
                            catch (Exception e2) {
                                th.markRollback();
                                if (e2.getMessage().contains("AggFactorMetadataCommand300")) {
                                    throw new KDBizException(ResManager.loadKDString((String)"\u52a8\u6001\u8ba1\u7b97\u7684\u4e0b\u7ea7\u6210\u5458\u7684\u805a\u5408\u7b97\u6cd5\u53ea\u53ef\u4e3a\u52a0\uff08+\uff09\u3001\u51cf\uff08-\uff09\u6216\u5ffd\u7565\uff08~\uff09\u3002", (String)"NewSharingTree_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                                }
                                throw new KDBizException(e2.getMessage());
                            }
                        }
                        catch (Throwable e2) {
                            sourceDy = e2;
                            throw e2;
                        }
                        BatchProcessHelper.handleAsync(() -> ShareNodeStructSyncHelper.resyncShareNodeStructure((String)entityname, (long)Long.parseLong(modelId), (long)Long.parseLong(dimensionid)));
                        this.getPageCache().remove("pid2Id2MappingShare");
                        this.getPageCache().remove("temp_ids");
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"NewSharingTree_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        this.getView().close();
                        break;
                    }
                    case "vectorap": 
                    case "vectorap1": {
                        String rowcache = this.getPageCache().get(LLIST);
                        if (rowcache == null) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u9700\u8981\u641c\u7d22\u7684\u5185\u5bb9\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"NewSharingTree_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        List rowList = (List)SerializationUtils.fromJsonString((String)rowcache, List.class);
                        int rowCount = Integer.parseInt(this.getPageCache().get("lfocus"));
                        Set beforeshowRow = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(allshowrowid), Set.class);
                        if ("vectorap".equals(key)) {
                            if (0 == rowCount) {
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"NewSharingTree_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                                return;
                            }
                            this.getPageCache().put("lfocus", String.valueOf(--rowCount));
                            Long focusID = (Long)rowList.get(rowCount);
                            this.insertAndRefreshTreeEntry(beforeshowRow, "bcm_structofextend", focusID, false);
                            break;
                        }
                        if (rowList.size() - 1 == rowCount) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"NewSharingTree_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        this.getPageCache().put("lfocus", String.valueOf(++rowCount));
                        Long focusID = (Long)rowList.get(rowCount);
                        beforeshowRow.addAll(this.getAllShowRowID(modelId, dimensionid, String.valueOf(focusID), "bcm_structofextend"));
                        this.getPageCache().put(allshowrowid, SerializationUtils.toJsonString((Object)beforeshowRow));
                        this.insertAndRefreshTreeEntry(beforeshowRow, "bcm_structofextend", focusID, false);
                        break;
                    }
                    case "vectorap2": 
                    case "vectorap11": {
                        super.click(evt);
                    }
                }
                break block69;
            }
            super.click(evt);
        }
    }

    private List<DynamicObject> getCurrentSelectIds() {
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(treeentryentity);
        int[] selectIndexs = treeEntry.getSelectRows();
        if (selectIndexs == null || selectIndexs.length == 0) {
            return null;
        }
        DynamicObjectCollection dyc = this.getModel().getEntryEntity(treeentryentity);
        ArrayList<DynamicObject> selectDys = new ArrayList<DynamicObject>(10);
        for (int index : selectIndexs) {
            selectDys.add((DynamicObject)dyc.get(index));
        }
        return selectDys;
    }

    private boolean checkIsFieldMember(List<DynamicObject> leftNodes) {
        List ids = leftNodes.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"bcm_structofextend", (String)"id,level", (QFilter[])new QFilter[]{qFilter});
        List noLeafList = result.stream().filter(x -> 3 != x.getInt("level")).collect(Collectors.toList());
        return !CollectionUtils.isNotEmpty(noLeafList);
    }

    private String checkIsBizGroupMember(String id) {
        QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(id));
        DynamicObject result = QueryServiceHelper.queryOne((String)"bcm_structofextend", (String)"id,level", (QFilter[])new QFilter[]{qFilter});
        if (1 == result.getInt("level")) {
            return ResManager.loadKDString((String)"\u65e0\u6cd5\u521b\u5efa\u6839\u8282\u70b9\u7684\u5171\u4eab\u6210\u5458\u3002", (String)"NewSharingTree_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (3 == result.getInt("level")) {
            return ResManager.loadKDString((String)"\u5b57\u6bb5\u6210\u5458\u4e0d\u5141\u8bb8\u65b0\u589e\u5171\u4eab\u3002", (String)"NewSharingTree_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private int setSeqValue(String modelId) {
        int max = -1;
        String cacheDseq = this.getPageCache().get("addLaterDseq");
        if (StringUtils.isNotEmpty((CharSequence)cacheDseq)) {
            max = Integer.parseInt(cacheDseq);
        } else {
            QFilter qFilter = new QFilter("model", "=", (Object)Long.valueOf(modelId));
            DynamicObjectCollection seqs = QueryServiceHelper.query((String)"bcm_structofextend", (String)"dseq", (QFilter[])new QFilter[]{qFilter});
            for (DynamicObject dynamicObject : seqs) {
                int seq = dynamicObject.getInt("dseq");
                max = max > seq ? max : seq;
            }
        }
        AtomicInteger at = new AtomicInteger(max);
        at.getAndIncrement();
        return at.get();
    }

    private boolean checkMaxMappingField(List<DynamicObject> leftChoseNodes, Map<Long, Map<String, String>> pid2Id2Mapping, Long parentId) {
        boolean flag = true;
        QFilter qfr = new QFilter("parent", "=", (Object)parentId);
        DynamicObjectCollection rightChildDy = QueryServiceHelper.query((String)"bcm_structofextend", (String)"id, parent, datatype, enumitem, fieldmapped, parent.grouptype", (QFilter[])new QFilter[]{qfr});
        QFilter qfp = new QFilter("id", "=", (Object)parentId);
        DynamicObject dyPar = QueryServiceHelper.queryOne((String)"bcm_structofextend", (String)"id, grouptype", (QFilter[])new QFilter[]{qfp});
        QFilter qfl = new QFilter("id", "in", leftChoseNodes.stream().map(x -> x.getLong("id")).collect(Collectors.toList()));
        DynamicObjectCollection leftFocusDy = QueryServiceHelper.query((String)"bcm_structofextend", (String)"id, parent, datatype, enumitem", (QFilter[])new QFilter[]{qfl});
        if ("3".equals(dyPar.getString("grouptype"))) {
            for (DynamicObject dy : leftFocusDy) {
                pid2Id2Mapping.computeIfAbsent(parentId, k -> new HashMap()).put(dy.getString("id"), "");
            }
            return flag;
        }
        for (DynamicObject leftDy : leftFocusDy) {
            if (!"6".equals(leftDy.getString("datatype"))) continue;
            QFilter qFilter = new QFilter("id", "=", leftDy.get("enumitem"));
            leftDy.set("datatype", (Object)QueryServiceHelper.queryOne((String)"bcm_enumitem", (String)"datatype", (QFilter[])new QFilter[]{qFilter}).getString("datatype"));
        }
        flag = this.extDimDataCheck(leftFocusDy, pid2Id2Mapping, rightChildDy, parentId);
        return flag;
    }

    private boolean extDimDataCheck(DynamicObjectCollection leftChoseNodes, Map<Long, Map<String, String>> pid2Id2Mapping, DynamicObjectCollection rightChildDy, Long parentId) {
        List dataFieldArray = new ArrayList();
        String type = "";
        ArrayList<String> txts = new ArrayList<String>(16);
        ArrayList<String> nums = new ArrayList<String>(16);
        ArrayList<String> dates = new ArrayList<String>(16);
        Map odmap = BusinessDataServiceHelper.loadFromCache((String)"bcm_structofextend", (String)"grouptype", (QFilter[])new QFilter("id", "=", (Object)parentId).toArray());
        Integer numMax = 0;
        Integer textMax = 0;
        Integer dateMax = 0;
        Tuple tuple = ExtDimensionHelper.getTypeDataByGroupType((Integer)numMax, (Integer)textMax, (Integer)dateMax, (String)((DynamicObject)odmap.get(parentId)).getString("grouptype"));
        numMax = (Integer)tuple.p1;
        textMax = (Integer)tuple.p2;
        dateMax = (Integer)tuple.p3;
        block0: for (DynamicObject leftDy : leftChoseNodes) {
            Map<String, String> id2Mapping;
            ArrayList<String> dataTypeEnums = new ArrayList<String>(16);
            String datatype = leftDy.getString("datatype");
            if (datatype.equals(DataTypeEnum.TXT.getOIndex())) {
                dataTypeEnums.add(DataTypeEnum.TXT.getOIndex());
                dataFieldArray = ExtDataServiceHelper.getSQLFieldArray((String)textPrefix, (int)textMax);
                type = EXTFIELD_TEXT;
            } else if (datatype.equals(DataTypeEnum.CURRENCY.getOIndex()) || datatype.equals(DataTypeEnum.UNCURRENCY.getOIndex()) || datatype.equals(DataTypeEnum.PROPORTION.getOIndex()) || datatype.equals(DataTypeEnum.DEFAULT.getOIndex())) {
                dataTypeEnums.addAll(Arrays.asList(DataTypeEnum.CURRENCY.getOIndex(), DataTypeEnum.UNCURRENCY.getOIndex(), DataTypeEnum.PROPORTION.getOIndex(), DataTypeEnum.DEFAULT.getOIndex()));
                dataFieldArray = ExtDataServiceHelper.getSQLFieldArray((String)numPrefix, (int)numMax);
                type = EXTFIELD_NUM;
            } else if (datatype.equals(DataTypeEnum.DATETP.getOIndex())) {
                dataTypeEnums.add(DataTypeEnum.DATETP.getOIndex());
                dataFieldArray = ExtDataServiceHelper.getSQLFieldArray((String)datePrefix, (int)dateMax);
                type = EXTFIELD_DATE;
            }
            List results = rightChildDy.stream().filter(x -> dataTypeEnums.contains(x.getString("datatype"))).collect(Collectors.toList());
            List fieldmapped = results.stream().map(x -> (String)x.get("fieldmapped")).collect(Collectors.toList());
            DynamicObjectCollection dynamicObjects = this.calcEnumDatatypeAmount(parentId, dataTypeEnums);
            int sum = results.size();
            if (dynamicObjects != null && dynamicObjects.size() > 0) {
                sum += dynamicObjects.size();
                fieldmapped.addAll(dynamicObjects.stream().map(x -> (String)x.get("fieldmapped")).collect(Collectors.toList()));
            }
            if ((id2Mapping = pid2Id2Mapping.get(parentId)) != null) {
                Iterator<Map.Entry<String, String>> mapping = id2Mapping.entrySet().iterator();
                while (mapping.hasNext()) {
                    String mapped = mapping.next().getValue();
                    if (!StringUtils.isNotEmpty((CharSequence)mapped)) continue;
                    String mapped_pre = mapped.substring(0, mapped.lastIndexOf("ext"));
                    if (!type.split("_")[1].equalsIgnoreCase(mapped_pre)) continue;
                    fieldmapped.add(mapped);
                    ++sum;
                }
            }
            if (EXTFIELD_TEXT.equals(type)) {
                if (txts.size() > 0) {
                    fieldmapped.addAll(txts);
                }
                if (sum >= textMax) {
                    return false;
                }
                for (int i = 1; i <= dataFieldArray.size(); ++i) {
                    if (fieldmapped.contains(dataFieldArray.get(i - 1))) continue;
                    pid2Id2Mapping.computeIfAbsent(parentId, k -> new HashMap(16)).put(leftDy.getString("id"), textPrefix + i);
                    txts.add(textPrefix + i);
                    continue block0;
                }
                continue;
            }
            if (EXTFIELD_NUM.equals(type)) {
                if (nums.size() > 0) {
                    fieldmapped.addAll(nums);
                }
                if (sum >= numMax) {
                    return false;
                }
                for (int i = 1; i <= dataFieldArray.size(); ++i) {
                    if (fieldmapped.contains(dataFieldArray.get(i - 1))) continue;
                    pid2Id2Mapping.computeIfAbsent(parentId, k -> new HashMap(16)).put(leftDy.getString("id"), numPrefix + i);
                    nums.add(numPrefix + i);
                    continue block0;
                }
                continue;
            }
            if (!EXTFIELD_DATE.equals(type)) continue;
            if (dates.size() > 0) {
                fieldmapped.addAll(dates);
            }
            if (sum >= dateMax) {
                return false;
            }
            for (int i = 1; i <= dataFieldArray.size(); ++i) {
                if (fieldmapped.contains(dataFieldArray.get(i - 1))) continue;
                pid2Id2Mapping.computeIfAbsent(parentId, k -> new HashMap(16)).put(leftDy.getString("id"), datePrefix + i);
                dates.add(datePrefix + i);
                continue block0;
            }
        }
        return true;
    }

    private DynamicObjectCollection calcEnumDatatypeAmount(Long parentId, List<String> dataTypeEnums) {
        if (dataTypeEnums.contains("0")) {
            dataTypeEnums.remove("0");
        }
        QFilter qf = new QFilter("parent", "=", (Object)parentId);
        qf.and(new QFilter("datatype", "=", (Object)"6"));
        qf.and(new QFilter("enumitem.datatype", "in", dataTypeEnums));
        return QueryServiceHelper.query((String)"bcm_structofextend", (String)"fieldmapped", (QFilter[])qf.toArray());
    }
}

