/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.DynamicComputingServiceHelper;
import kd.fi.bcm.business.dimension.helper.OlapPresetHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.SaveDimMemberHelper;
import kd.fi.bcm.business.dimension.struct.ShareNodeStructSyncHelper;
import kd.fi.bcm.business.dimension.util.ModelUtil;
import kd.fi.bcm.business.permission.perm.PermCacheKey;
import kd.fi.bcm.business.permission.perm.PermPackageList;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.SearchHelper;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.TreeBuilder;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.business.tree.dimension.DimensionTreeNode;
import kd.fi.bcm.business.util.DimMemberSortUtil;
import kd.fi.bcm.business.util.LanguageUtil;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.CslSchemeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.OrgBizChangeTypeEnum;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.log.DimMemberOperateTypeEnum;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.formplugin.BCMBaseFunction;
import kd.fi.bcm.formplugin.dimension.DimensionCircleCheckAlgorithm;
import kd.fi.bcm.formplugin.dimension.action.DimemberBaseAction;
import kd.fi.bcm.formplugin.util.ReportListUtil;
import kd.fi.bcm.formplugin.util.TreeEntryEntityUtil;
import org.apache.commons.lang3.StringUtils;

public class NewSharingTree
extends AbstractFormPlugin
implements TreeNodeQueryListener,
RowClickEventListener,
BCMBaseFunction {
    protected static final Log LOG = LogFactory.getLog(NewSharingTree.class);
    private static String modelCacheKey = "defaultModel";
    private static String dimensionCacheKey = "select";
    private static String memberCacheKey = "memberCache";
    protected static String allshowrowid = "allshowrowid";
    private static String storeParentCacheKey = "storeParent";
    private static final String LLIST = "lrowlist";
    private static final String RLIST = "rrowlist";
    protected static final String LFOCUS = "lfocus";
    private static final String RFOCUS = "rfocus";
    private static final String treeentryentity = "treeentryentity";
    private static final String rightFocusNodeId = "rightFocusNodeId";
    private static final String cslschemetree = "cslschemetree";
    private static final String CACHEKEY_cslSchemeID = "cslschemeid";
    private static final String rightTree = "righttree";
    private static final String dimensionNumberCacheKey = "dimensionnumber";
    private static final String CSLTREENODECLICK = "csltreenodeclick";
    private static final String BIZEFFDATE = "bizeffdate";
    private static final String BIZMODIFIER = "bizmodifier";
    private static final String BIZMODIFYTIME = "bizmodifytime";
    private static final String SELECTField_USERPROPERTY = "dpropertyid1.number, dpropertyid2.number, dpropertyid3.number, dpropertyid4.number, dpropertyid5.number, dpropertyid6.number, dpropertyid7.number, dpropertyid8.number, dpropertyid9.number, dpropertyid10.number";

    @Override
    public AbstractFormPlugin getPlugin() {
        return this;
    }

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"bar_cancel", "bar_add", "btngo", "btnremove", "btnallremove", "vectorap", "vectorap1", "vectorap2", "vectorap11"});
        Search sl = (Search)this.getControl("searchapleft");
        Search sr = (Search)this.getControl("searchapright");
        sl.addEnterListener(event -> {
            if (StringUtils.isNotEmpty((CharSequence)event.getText())) {
                this.searchLeftMember(event.getText().toLowerCase(Locale.ENGLISH).trim());
            } else {
                this.getPageCache().put(LLIST, null);
                this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
            }
        });
        sr.addEnterListener(event -> {
            if (StringUtils.isNotEmpty((CharSequence)event.getText())) {
                this.searchRightMember(event.getText().toLowerCase(Locale.ENGLISH).trim());
            } else {
                this.getPageCache().put(RLIST, null);
                this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
            }
        });
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(treeentryentity);
        treeEntry.addCellClickListener((TreeNodeQueryListener)this);
        TreeView rightTreeV = (TreeView)this.getView().getControl("treeright");
        rightTreeV.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                NewSharingTree.this.rightTreeNodeClick(evt);
            }
        });
        rightTreeV.addTreeNodeQueryListener(new TreeNodeQueryListener(){

            public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
                TreeView treeView = (TreeView)treeNodeEvent.getSource();
                String curNodeId = (String)treeNodeEvent.getNodeId();
                NewSharingTree.this.pullRightTreeNextLevel(treeView, curNodeId);
            }
        });
        String dimNum = (String)this.getView().getFormShowParameter().getCustomParam(dimensionNumberCacheKey);
        if (this.isCM() && dimNum.equals("Entity")) {
            TreeView schemeTree = (TreeView)this.getView().getControl(cslschemetree);
            schemeTree.addTreeNodeClickListener(new TreeNodeClickListener(){

                public void treeNodeClick(TreeNodeEvent evt) {
                    NewSharingTree.this.cslschemeTreeNodeClick(evt);
                }
            });
        }
    }

    private void rightTreeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        if (this.getView().getFormShowParameter().getCustomParam("schemeName") != null && "DefaultRateScheme".equalsIgnoreCase((String)this.getView().getFormShowParameter().getCustomParam("schemeName"))) {
            QFBuilder range = new QFBuilder("model", "=", (Object)this.getPageCache().get(modelCacheKey));
            range.and("number", "=", (Object)"RateEntity");
            DynamicObject single = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id, number", (QFilter[])range.toArray());
            if (single != null && single.getLong("id") != Long.parseLong(nodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u7387\u7ec4\u7ec7\u53ea\u80fd\u5728RateEntity\u4e0b\u65b0\u589e\u5171\u4eab\u3002", (String)"NewSharingTree_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                TreeView treeright = (TreeView)this.getControl("treeright");
                treeright.focusNode(new TreeNode("", single.getString("id"), ""));
                this.getPageCache().put(rightFocusNodeId, single.getString("id"));
            }
        } else {
            this.getPageCache().put(rightFocusNodeId, nodeId);
        }
    }

    private void cslschemeTreeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        this.initLeftTree(nodeId);
        this.getView().updateView(treeentryentity);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.cacheParam();
        this.safeCombox();
        SplitContainer container = (SplitContainer)this.getControl("splitcontainerap");
        String dimNum = (String)this.getView().getFormShowParameter().getCustomParam(dimensionNumberCacheKey);
        if (this.isCM() && dimNum.equals("Entity")) {
            container.hidePanel(SplitDirection.left, false);
            String cslschemeId = (String)this.getView().getFormShowParameter().getCustomParam("cslscheme");
            String defaultScheme = this.initSchemeTree();
            this.getPageCache().put("defaultCsl", defaultScheme);
            this.getPageCache().put("userSelectOfRightCsl", cslschemeId);
            this.initLeftTree(defaultScheme == null ? cslschemeId : defaultScheme);
        } else {
            container.hidePanel(SplitDirection.left, true);
            this.initLeftTree(null);
        }
        TreeView treeRight = (TreeView)this.getView().getControl("treeright");
        this.pullRightTreeNextLevel(treeRight, null);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        String dimensionId = this.getPageCache().get(dimensionCacheKey);
        String modelId = this.getPageCache().get(modelCacheKey);
        String entityName = this.getPageCache().get(memberCacheKey);
        String dimNum = this.getPageCache().get(dimensionNumberCacheKey);
        String schemeId = (String)this.getView().getFormShowParameter().getCustomParam("cslscheme");
        TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)rightTree);
        if (treeModel == null) {
            return;
        }
        TreeView treeright = (TreeView)this.getControl("treeright");
        DimensionTreeNode root = (DimensionTreeNode)treeModel.getRoot();
        String rightFocusId = this.getPageCache().get(rightFocusNodeId);
        DimensionTreeNode rightFocusNode = (DimensionTreeNode)treeModel.searchByNodeId(rightFocusId);
        String modelNum = MemberReader.findModelNumberById((Object)LongUtil.toLong((Object)modelId));
        IDNumberTreeNode focusNode = MemberReader.findMemberById((String)modelNum, (String)entityName, (Long)LongUtil.toLong((Object)rightFocusId));
        switch (key) {
            case "btngo": {
                TreeView rightTreeV = (TreeView)this.getView().getControl("treeright");
                rightTreeV.queryTreeNodeChildren(null, rightFocusId);
                List<DynamicObject> leftChoseNodes = this.getCurrentSelectIds();
                if (leftChoseNodes == null || leftChoseNodes.size() < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5171\u4eab\u7684\u7ef4\u5ea6\u6210\u5458\u3002", (String)"NewSharingTree_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (rightFocusId == null || rightFocusNode == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u521b\u5efa\u6839\u8282\u70b9\u7684\u5171\u4eab\u6210\u5458\u3002", (String)"NewSharingTree_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (focusNode == IDNumberTreeNode.NotFoundTreeNode) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5171\u4eab\u8282\u70b9\u4e0b\u7ea7\u4e0d\u80fd\u65b0\u589e\u5171\u4eab\u3002", (String)"NewSharingTree_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (StorageTypeEnum.SHARE.index.equals(rightFocusNode.getStoragetype()) || this.isNeedSave(rightFocusNode)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5171\u4eab\u8282\u70b9\u4e0b\u7ea7\u4e0d\u5141\u8bb8\u65b0\u589e\u5171\u4eab\u3002", (String)"NewSharingTree_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.checkCtrlorg(rightFocusId)) {
                    return;
                }
                if (focusNode.isLeaf() && this.checkHasOlapData(dimNum, modelNum, rightFocusNode.getNumber())) {
                    return;
                }
                if (this.checkStorageType(rightFocusNode) || this.checkLeftStorageType(leftChoseNodes)) {
                    return;
                }
                if (!this.checkDefaultMember(rightFocusId, entityName, modelId, dimNum)) {
                    return;
                }
                if (this.checkPreset(dimNum, entityName, rightFocusNode)) {
                    return;
                }
                DynamicObjectCollection child = this.listTreeLevelMembers(Long.parseLong(dimensionId), entityName, Long.parseLong(modelId), StringUtils.isEmpty((CharSequence)schemeId) ? null : Long.valueOf(Long.parseLong(schemeId)), rightFocusId);
                HashSet<Long> selectLeftIds = new HashSet<Long>(16);
                ArrayList<String> noSaveAndRepeatNums = new ArrayList<String>(10);
                ArrayList<String> savedAndRepeatNums = new ArrayList<String>(10);
                long sameParentId = (Long)leftChoseNodes.get(0).get("pid");
                for (DynamicObject leftChoseNode : leftChoseNodes) {
                    String leftNodeNum = leftChoseNode.getString("number");
                    if (sameParentId != (Long)leftChoseNode.get("pid")) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u91cf\u5171\u4eab\u4ec5\u652f\u6301\u540c\u4e00\u7236\u7ea7\u4e0b\u7684\u6210\u5458\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"NewSharingTree_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (child.stream().map(x -> x.getString("number")).filter(x -> leftNodeNum.equals(x)).findAny().isPresent()) {
                        savedAndRepeatNums.add(leftNodeNum);
                        continue;
                    }
                    if (rightFocusNode.getChildren().stream().map(x -> ((DimensionTreeNode)x).getNumber()).filter(x -> leftNodeNum.equals(x)).findAny().isPresent()) {
                        noSaveAndRepeatNums.add(leftNodeNum);
                        continue;
                    }
                    Long selectLeftId = leftChoseNode.getLong("id");
                    Optional<String> conflictNumber = DimensionCircleCheckAlgorithm.check(Long.parseLong(modelId), entityName, selectLeftId, Long.parseLong(rightFocusId));
                    if (conflictNumber.isPresent()) {
                        String message = ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u4e92\u5171\u4eab\u6216\u5faa\u73af\u5171\u4eab,\u4e0d\u53ef\u5171\u4eab\u6210\u4e3a\u4e0b\u7ea7\u6210\u5458\u3002", (String)"NewSharingTree_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                        this.getView().showTipNotification(message);
                        return;
                    }
                    selectLeftIds.add(selectLeftId);
                }
                if (savedAndRepeatNums.size() > 0 || noSaveAndRepeatNums.size() > 0) {
                    if (savedAndRepeatNums.size() > 0 && noSaveAndRepeatNums.size() == 0) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53ef\u5171\u4eab%1$s\u6761\u3002%2$s \u5728\u76ee\u6807\u8282\u70b9\u4e0b\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u5171\u4eab\u3002", (String)"NewSharingTree_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]), selectLeftIds.size(), String.join((CharSequence)",", savedAndRepeatNums)));
                    } else if (savedAndRepeatNums.size() == 0 && noSaveAndRepeatNums.size() > 0) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53ef\u5171\u4eab%1$s\u6761\u3002%2$s \u5df2\u88ab\u9009\u4e2d\uff0c\u4e0d\u80fd\u91cd\u590d\u9009\u62e9\u3002", (String)"NewSharingTree_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]), selectLeftIds.size(), String.join((CharSequence)",", noSaveAndRepeatNums)));
                    } else {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53ef\u5171\u4eab%1$s\u6761\u3002%2$s \u5df2\u88ab\u9009\u4e2d\uff0c\u4e0d\u80fd\u91cd\u590d\u9009\u62e9\uff1b%3$s \u5728\u76ee\u6807\u8282\u70b9\u4e0b\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u5171\u4eab\u3002", (String)"NewSharingTree_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]), selectLeftIds.size(), String.join((CharSequence)",", noSaveAndRepeatNums), String.join((CharSequence)",", savedAndRepeatNums)));
                    }
                }
                if (selectLeftIds.size() == 0) {
                    return;
                }
                DynamicObjectCollection leftNodeDys = ReportListUtil.getOrgCollectionForShare(entityName, null, new QFilter("id", "in", selectLeftIds).toArray(), "dseq");
                this.updateRightTreeModel(rightFocusId, leftNodeDys, true, false);
                treeright.expand(rightFocusId);
                break;
            }
            case "btnremove": {
                if (rightFocusNode == null || !rightFocusNode.isNeadsave()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u5220\u9664\u975e\u672c\u6b21\u64cd\u4f5c\u65b0\u589e\u8282\u70b9\u3002", (String)"NewSharingTree_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                String focusNodeParentId = rightFocusNode.getParent().getId();
                HashSet nodes = new HashSet(16);
                root = DimensionTreeNode.deleteChild((DimensionTreeNode)rightFocusNode, (DimensionTreeNode)root, nodes);
                this.cacheTree(root);
                for (DimensionTreeNode node : nodes) {
                    DimensionTreeNode parent = node.getParent();
                    if (parent.getChildren().size() == 0) {
                        String parentId = parent.getParent() == null ? "0" : parent.getParent().getId();
                        TreeNode treeNode = new TreeNode(parentId, parent.getId(), parent.getName(), false);
                        treeright.updateNode(treeNode);
                    }
                    treeright.deleteNode(node.getId());
                }
                treeright.focusNode(new TreeNode("0", focusNodeParentId, ""));
                this.getPageCache().put(rightFocusNodeId, focusNodeParentId);
                this.removeCacheTmpIds(rightFocusId);
                break;
            }
            case "btnallremove": {
                TreeView treeRight = (TreeView)this.getView().getControl("treeright");
                this.pullRightTreeNextLevel(treeRight, null);
                this.getPageCache().remove("temp_ids");
                break;
            }
            case "bar_add": {
                Throwable sourceDy;
                HashSet<Long> parents = new HashSet<Long>(16);
                HashSet<String> derivenumlist = new HashSet<String>(16);
                ArrayList<DynamicObject> listobj = new ArrayList<DynamicObject>(10);
                LinkedList<DimensionTreeNode> queue = new LinkedList<DimensionTreeNode>();
                queue.add(root);
                HashMap<String, Integer> parentToChildrenSize = new HashMap<String, Integer>(16);
                HashMap<String, Set> orgMap = new HashMap<String, Set>(16);
                while (!queue.isEmpty()) {
                    DimensionTreeNode node = (DimensionTreeNode)queue.poll();
                    if (node.getIschanged()) {
                        this.alterIsleaf(node.getId(), entityName);
                        node.setIschanged(false);
                    }
                    if (node.isNeadsave()) {
                        node.setNeadsave(false);
                        sourceDy = BusinessDataServiceHelper.loadSingle((Object)node.getCopyfrom(), (String)entityName);
                        String parentId = node.getParent().getId();
                        DynamicObject shareParentDy = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)entityName);
                        Map trans = LanguageUtil.getTranslate((String)sourceDy.getString("name"), (String)"", (String)"fi-bcm-business");
                        sourceDy.set("name", LanguageUtil.getName((String)sourceDy.getString("name"), (Map)trans));
                        sourceDy.set("longnumber", shareParentDy.getString("longnumber") + '!' + sourceDy.getString("number"));
                        sourceDy.set("level", shareParentDy.getInt("level") + 1);
                        Integer tempSeq = (Integer)parentToChildrenSize.get(node.getParent().getId());
                        if (tempSeq == null) {
                            HashSet<String> noRepeatChildren = new HashSet<String>(16);
                            for (ITreeNode objectITreeNode : node.getParent().getChildren()) {
                                noRepeatChildren.add(objectITreeNode.getId());
                            }
                            parentToChildrenSize.put(node.getParent().getId(), noRepeatChildren.size());
                        } else {
                            parentToChildrenSize.put(node.getParent().getId(), tempSeq + 1);
                        }
                        sourceDy.set("dseq", parentToChildrenSize.get(node.getParent().getId()));
                        sourceDy.set("storagetype", 3);
                        sourceDy.set("issysmember", 4);
                        Date createTime = TimeServiceHelper.now();
                        sourceDy.set("modifytime", createTime);
                        sourceDy.set("createtime", createTime);
                        DynamicObject modifierDy = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
                        modifierDy.set("id", (Object)RequestContext.get().getUserId());
                        sourceDy.set("modifier", modifierDy);
                        sourceDy.set("creator", modifierDy);
                        sourceDy.set("share", node.getShare());
                        DynamicObject parent = BusinessDataServiceHelper.newDynamicObject((String)entityName);
                        parents.add(Long.parseLong(parentId));
                        parent.set("id", (Object)parentId);
                        sourceDy.set("parent", parent);
                        sourceDy.set("isleaf", node.getIsleaf());
                        DynamicObject newShareDy = (DynamicObject)OrmUtils.clone((Object)sourceDy, (IDataEntityType)sourceDy.getDataEntityType(), (boolean)true, (boolean)true);
                        DynamicObject copyfrom = new DynamicObject(newShareDy.getDynamicObjectType());
                        copyfrom.set("id", (Object)sourceDy.getLong("id"));
                        newShareDy.set("copyfrom", (Object)copyfrom);
                        newShareDy.set("id", (Object)node.getId());
                        if ("bcm_entitymembertree".equals(entityName)) {
                            DimensionTreeNode parentNode;
                            if (this.getView().getFormShowParameter().getCustomParam("schemeName") != null && "DefaultRateScheme".equalsIgnoreCase((String)this.getView().getFormShowParameter().getCustomParam("schemeName"))) {
                                newShareDy.set("isexchangerate", (Object)true);
                            }
                            if (!(parentNode = node.getParent()).getStoragetype().equals("3")) {
                                DynamicObject dynaparent = BusinessDataServiceHelper.loadSingle((Object)parentNode.getId(), (String)entityName);
                                String deriveNum = OlapPresetHelper.getDeriveNum((DynamicObject)sourceDy, (String)dynaparent.getString("number"));
                                derivenumlist.add(deriveNum);
                                orgMap.computeIfAbsent(dynaparent.getString("number"), o -> new HashSet(16)).add(sourceDy.getString("number"));
                            }
                            DynamicObject cslscheme = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_cslscheme"));
                            cslscheme.set("id", (Object)schemeId);
                            newShareDy.set("cslscheme", (Object)cslscheme);
                        }
                        listobj.add(newShareDy);
                    }
                    node.getChildren().forEach(e -> queue.add((DimensionTreeNode)e));
                }
                if (derivenumlist.isEmpty() && listobj.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u672a\u4fdd\u5b58\u6570\u636e\u3002", (String)"NewSharingTree_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if ("bcm_entitymembertree".equals(entityName)) {
                    this.setOrgVersionInfo(listobj);
                    LockScopeServiceHelper.addOrgToLockScope((long)LongUtil.toLong((Object)modelId), orgMap);
                }
                sourceDy = null;
                try (TXHandle th = TX.requiresNew();){
                    try {
                        this.updateOriginParentIsLeafProperty(entityName, parentToChildrenSize.keySet());
                        BusinessDataWriter.save((IDataEntityType)((DynamicObject)listobj.get(0)).getDataEntityType(), (Object[])listobj.toArray());
                        DimensionServiceHelper.syncCustomValuesOfMembers((long)Long.parseLong(modelId), (long)Long.parseLong(dimensionId), (String)entityName, listobj);
                        SaveDimMemberHelper.saveLog(listobj, (DimMemberOperateTypeEnum)DimMemberOperateTypeEnum.NEW_SHARE);
                        if (!derivenumlist.isEmpty()) {
                            OlapServiceHelper.batchCreateDimensionMembers((String)modelNum, (String)dimNum, (String[])derivenumlist.toArray(new String[0]));
                        }
                        DynamicComputingServiceHelper.repairModelByParents((String)modelNum, (String)dimNum, (boolean)false, parents);
                    }
                    catch (Throwable e2) {
                        th.markRollback();
                        if (e2.getMessage().contains("AggFactorMetadataCommand300")) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u52a8\u6001\u8ba1\u7b97\u7684\u4e0b\u7ea7\u6210\u5458\u7684\u805a\u5408\u7b97\u6cd5\u53ea\u53ef\u4e3a\u52a0\uff08+\uff09\u3001\u51cf\uff08-\uff09\u6216\u5ffd\u7565\uff08~\uff09\u3002", (String)"NewSharingTree_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        }
                        throw new KDBizException(e2.getMessage());
                    }
                }
                catch (Throwable e2) {
                    sourceDy = e2;
                    throw e2;
                }
                BatchProcessHelper.handleAsync(() -> ShareNodeStructSyncHelper.resyncShareNodeStructure((String)entityName, (long)Long.parseLong(modelId), (long)Long.parseLong(dimensionId)));
                Long cslscheme = 0L;
                if ("bcm_entitymembertree".equals(entityName)) {
                    cslscheme = Long.parseLong(schemeId);
                }
                DimMemberSortUtil.upadteDimChangeTime((Long)Long.parseLong(modelId), (Long)cslscheme, (Long)Long.parseLong(dimensionId), (String)"changetime");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"NewSharingTree_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getView().close();
                break;
            }
            case "vectorap": 
            case "vectorap1": {
                String rowcache = this.getPageCache().get(LLIST);
                if (rowcache == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u9700\u8981\u641c\u7d22\u7684\u5185\u5bb9\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"NewSharingTree_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                List rowList = (List)SerializationUtils.fromJsonString((String)rowcache, List.class);
                int rowCount = Integer.parseInt(this.getPageCache().get(LFOCUS));
                Set beforeshowRow = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(allshowrowid), Set.class);
                if ("vectorap".equals(key)) {
                    if (0 == rowCount) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"NewSharingTree_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.getPageCache().put(LFOCUS, String.valueOf(--rowCount));
                    Long focusID = (Long)rowList.get(rowCount);
                    this.insertAndRefreshTreeEntry(beforeshowRow, entityName, focusID, false);
                    break;
                }
                if (rowList.size() - 1 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"NewSharingTree_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getPageCache().put(LFOCUS, String.valueOf(++rowCount));
                Long focusID = (Long)rowList.get(rowCount);
                beforeshowRow.addAll(this.getAllShowRowID(modelId, dimensionId, String.valueOf(focusID), entityName));
                this.getPageCache().put(allshowrowid, SerializationUtils.toJsonString((Object)beforeshowRow));
                this.insertAndRefreshTreeEntry(beforeshowRow, entityName, focusID, false);
                break;
            }
            case "vectorap2": 
            case "vectorap11": {
                String matchCache = this.getPageCache().get(RLIST);
                if (matchCache == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u9700\u8981\u641c\u7d22\u7684\u5185\u5bb9\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"NewSharingTree_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                List matchIds = (List)SerializationUtils.fromJsonString((String)matchCache, List.class);
                int rRow = Integer.parseInt(this.getPageCache().get(RFOCUS));
                if ("vectorap2".equals(key)) {
                    if (0 == rRow) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"NewSharingTree_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    --rRow;
                } else {
                    if (matchIds.size() - 1 == rRow) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"NewSharingTree_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    ++rRow;
                }
                this.getPageCache().put(RFOCUS, String.valueOf(rRow));
                Long focusId = (Long)matchIds.get(rRow);
                this.choiseRightNode(focusId);
                break;
            }
        }
    }

    private boolean checkPreset(String dimensionNumber, String entityName, DimensionTreeNode rightFocusNode) {
        boolean bol;
        boolean bl = bol = DimEntityNumEnum.AUDITTRIAL.getNumber().equals(dimensionNumber) || DimEntityNumEnum.CHANGETYPE.getNumber().equals(dimensionNumber);
        if (bol) {
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)entityName, (String)"name,longnumber,issysmember,isleaf", (QFilter[])new QFilter("id", "=", (Object)LongUtil.toLong((Object)rightFocusNode.getId())).toArray());
            boolean isSysBol = dynamicObject.getInt("issysmember") == 1;
            boolean isLeaf = dynamicObject.getBoolean("isleaf");
            if (isSysBol && isLeaf) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6210\u5458\u4e0d\u53ef\u65b0\u589e\u4e0b\u7ea7\u6216\u65b0\u589e\u5171\u4eab\u3002", (String)"NewSharingTree_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    protected void updateOriginParentIsLeafProperty(String entityName, Set<String> keySet) {
        Set ids = keySet.stream().map(Long::valueOf).collect(Collectors.toSet());
        QFilter idQf = new QFilter("id", "in", ids);
        idQf.and(new QFilter("isleaf", "=", (Object)true));
        DynamicObject[] needChangeDy = BusinessDataServiceHelper.load((String)entityName, (String)"id, isleaf", (QFilter[])new QFilter[]{idQf});
        if (needChangeDy != null && needChangeDy.length > 0) {
            for (DynamicObject dynamicObject : needChangeDy) {
                dynamicObject.set("isleaf", (Object)"0");
            }
            SaveServiceHelper.update((DynamicObject[])needChangeDy);
        }
    }

    private boolean checkHasOlapData(String dimNum, String modelNum, String number) {
        if (OlapServiceHelper.hasOlapData((String)modelNum, (List)Lists.newArrayList((Object[])new String[]{number}), (String)dimNum)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ef4\u5ea6\u6210\u5458\u5df2\u5b58\u5728\u591a\u7ef4\u6570\u636e\u5e76\u4e14\u4e3a\u660e\u7ec6\u6210\u5458\uff0c\u65b0\u589e\u5171\u4eab\u5931\u8d25\u3002", (String)"NewSharingTree_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void setOrgVersionInfo(List<DynamicObject> newOrgList) {
        HashSet copyfromIds = new HashSet(10);
        newOrgList.forEach(n -> copyfromIds.add(n.getLong("copyfrom.id")));
        HashMap map = new HashMap(16);
        DynamicObjectCollection copyfromDocs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, longnumber", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)copyfromIds.toArray())});
        copyfromDocs.forEach(c -> map.put(c.getString("id"), c.getString("longnumber")));
        for (DynamicObject dyc : newOrgList) {
            DynamicObjectCollection bizRecords;
            String copyLongnumber = (String)map.get(dyc.getString("copyfrom.id"));
            String changetype = OrgBizChangeTypeEnum.initNewlyAdded.getValue();
            if (copyLongnumber != null) {
                String[] split = copyLongnumber.split("!");
                if (dyc.getString("longnumber").contains(split[0].concat("!").concat(split[1]))) {
                    changetype = OrgBizChangeTypeEnum.sameControlNewlyAdded.getValue();
                }
            }
            if ((bizRecords = dyc.getDynamicObjectCollection("bizchangerds")) == null || bizRecords.size() <= 0) continue;
            DynamicObject bizRecord = new DynamicObject(bizRecords.getDynamicObjectType());
            bizRecord.set("changetype", (Object)changetype);
            int lastOperateSize = bizRecords.size() - 1;
            bizRecord.set(BIZEFFDATE, (Object)((DynamicObject)bizRecords.get(lastOperateSize)).getDate(BIZEFFDATE));
            bizRecord.set(BIZMODIFIER, ((DynamicObject)bizRecords.get(lastOperateSize)).get(BIZMODIFIER));
            bizRecord.set(BIZMODIFYTIME, (Object)((DynamicObject)bizRecords.get(lastOperateSize)).getDate(BIZMODIFYTIME));
            bizRecord.set("seq", (Object)1);
            bizRecords.clear();
            bizRecords.add((Object)bizRecord);
        }
    }

    private void safeCombox() {
        ComboEdit edit = (ComboEdit)this.getControl("selectdimension");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        String selectName = (String)this.getView().getFormShowParameter().getCustomParam("dimensionname");
        items.add(new ComboItem(new LocaleString(selectName), selectName));
        DynamicObjectCollection dcs = QueryDimensionServiceHelper.getDimensionBaseInfos((Object)this.getPageCache().get(modelCacheKey));
        for (DynamicObject entry : dcs) {
            String entryname = entry.get("name").toString();
            if (selectName.equals(entryname)) continue;
            items.add(new ComboItem(new LocaleString(entryname), entryname));
        }
        edit.setComboItems(items);
        if (items.size() > 0) {
            edit.selectedStore((ComboItem)items.get(0));
            this.getModel().getDataEntity().set("selectdimension", (Object)((ComboItem)items.get(0)).getValue());
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"selectdimension"});
    }

    protected void searchLeftMember(String text) {
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(treeentryentity);
        String modelId = this.getPageCache().get(modelCacheKey);
        String dimId = this.getPageCache().get(dimensionCacheKey);
        String entityName = this.getPageCache().get(memberCacheKey);
        long schemeId = LongUtil.toLong((Object)this.getPageCache().get(CSLTREENODECLICK));
        QFilter filter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        filter.and(new QFilter("dimension", "=", (Object)LongUtil.toLong((Object)dimId)));
        if ("bcm_entitymembertree".equals(entityName)) {
            filter.and(new QFilter("isexchangerate", "!=", (Object)"1"));
            if (this.isCM()) {
                filter.and("cslscheme", "=", (Object)schemeId);
            }
        }
        filter.and(new QFilter("storagetype", "!=", (Object)"3"));
        String selectMemberFields = this.getSelectMemberFields(entityName);
        DynamicObjectCollection members = QueryServiceHelper.query((String)entityName, (String)selectMemberFields, (QFilter[])filter.toArray(), (String)"level,dseq");
        if (members.size() == 0) {
            return;
        }
        DynamicObject root = this.getRoot(entityName, LongUtil.toLong((Object)modelId), LongUtil.toLong((Object)dimId), schemeId).get();
        LOG.info(String.format("searchLeftMember text:%s,root number:%s,member number:%s,members size:%s", text, root.getString("number"), ((DynamicObject)members.get(0)).getString("number"), members.size()));
        TreeMap rowTreeMap = SearchHelper.getSearchItemId((String)text, (DynamicObjectCollection)members, (long)root.getLong("parent"));
        if (rowTreeMap.size() == 0) {
            LOG.info(String.format("searchLeftMember not found text:%s,root number:%s,members size:%s", text, root.getString("number"), members.size()));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"NewSharingTree_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            treeEntry.selectRows(0);
            return;
        }
        HashSet storeParent = new HashSet(16);
        members.forEach(m -> {
            if (!StorageTypeEnum.SHARE.getOIndex().equals(m.getString("storagetype"))) {
                storeParent.add(m.getLong("parent"));
            }
        });
        ArrayList rowList = new ArrayList(rowTreeMap.values());
        this.getPageCache().put(LLIST, SerializationUtils.toJsonString(rowList));
        long focusID = (Long)rowList.get(0);
        this.getPageCache().put(LFOCUS, "0");
        Set<String> allRowIds = this.getAllShowRowID(modelId, dimId, String.valueOf(focusID), entityName);
        this.getPageCache().put(allshowrowid, SerializationUtils.toJsonString(allRowIds));
        this.getPageCache().put(storeParentCacheKey, SerializationUtils.serializeToBase64(storeParent));
        this.insertAndRefreshTreeEntry(allRowIds, entityName, focusID, true);
    }

    protected Set<String> getAllShowRowID(String modelId, String dimension, String focusID, String entityName) {
        List parentlist = SearchHelper.getOrgParentNodeList((String)modelId, (String)dimension, (String)focusID, (String)entityName);
        parentlist.add("0");
        HashSet<String> allShowRowid = new HashSet<String>(16);
        allShowRowid.add(String.valueOf(focusID));
        if (parentlist.size() > 0) {
            DynamicObjectCollection theSameLevel;
            QFilter filter = new QFilter("dimension", "=", (Object)LongUtil.toLong((Object)dimension));
            ArrayList<Long> pIds = new ArrayList<Long>(10);
            for (int i = parentlist.size() - 1; i >= 0; --i) {
                long parentId = LongUtil.toLong(parentlist.get(i));
                pIds.add(parentId);
            }
            if (pIds.size() > 0) {
                filter.and("parent", "in", pIds);
            }
            if ("bcm_entitymembertree".equals(entityName)) {
                filter.and(new QFilter("isexchangerate", "!=", (Object)"1"));
                if (this.isCM()) {
                    filter.and("cslscheme", "=", (Object)LongUtil.toLong((Object)this.getPageCache().get(CSLTREENODECLICK)));
                }
            }
            if ((theSameLevel = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])filter.toArray())) != null && theSameLevel.size() > 0) {
                for (DynamicObject dy : theSameLevel) {
                    allShowRowid.add(dy.getString("id"));
                }
            }
        }
        return allShowRowid;
    }

    protected void insertAndRefreshTreeEntry(Set<String> allShowRowid, String entityname, long focusID, boolean col) {
        QFilter qf2 = new QFilter("model", "=", (Object)this.getModelId());
        qf2.and("id", "in", (Object)ConvertUtil.convertListToLong(allShowRowid).toArray());
        qf2.and("storagetype", "!=", (Object)"3");
        DynamicObjectCollection membercolls = QueryServiceHelper.query((String)entityname, (String)this.getSelectMemberFields(entityname), (QFilter[])qf2.toArray(), (String)"level");
        if (membercolls.size() == 0) {
            return;
        }
        List<String> properties = this.getPropertiesAndLeaf(entityname);
        this.getModel().deleteEntryData(treeentryentity);
        String storeIds = this.getPageCache().get(storeParentCacheKey);
        Set ids = (Set)SerializationUtils.deSerializeFromBase64((String)storeIds);
        int focusRow = SearchHelper.fillTreeEntryEntityUserSeq((IDataModel)this.getModel(), (DynamicObjectCollection)membercolls, properties, (String)String.valueOf(focusID), (Long)((DynamicObject)membercolls.get(0)).getLong("parent"), (Set)ids);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(treeentryentity);
        this.getView().updateView(treeentryentity);
        int[] expandIds = TreeEntryEntityUtil.focus(this.getModel(), focusRow);
        if (col) {
            treeEntry.collapse(0);
        }
        treeEntry.expandOne(expandIds);
        treeEntry.selectRows(focusRow);
    }

    private List<String> getPropertiesAndLeaf(String menberentityid) {
        List<String> list = this.getProperties(menberentityid);
        list.add("isleaf");
        return list;
    }

    protected void searchRightMember(String text) {
        TreeMap rowTreeMap;
        TreeView treeView = (TreeView)this.getControl("treeright");
        String entityName = this.getPageCache().get(memberCacheKey);
        long modelId = Long.parseLong(this.getPageCache().get(modelCacheKey));
        long dimId = Long.parseLong(this.getPageCache().get(dimensionCacheKey));
        long schemeId = LongUtil.toLong((Object)this.getPageCache().get(CSLTREENODECLICK));
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        QFilter dimFilter = new QFilter("dimension", "=", (Object)dimId);
        if ("bcm_entitymembertree".equals(entityName)) {
            dimFilter.and(new QFilter("isexchangerate", "!=", (Object)"1"));
            dimFilter.and("cslscheme", "=", (Object)ConvertUtil.convertStrToLong((String)this.getPageCache().get("userSelectOfRightCsl")));
        }
        QFilter[] memberFilters = new QFilter[]{modelFilter, dimFilter};
        String selectMemberFields = this.getRightSelectedFields();
        DynamicObjectCollection members = QueryServiceHelper.query((String)entityName, (String)selectMemberFields, (QFilter[])memberFilters, (String)"level,dseq");
        DynamicObject root = this.getRoot(entityName, modelId, dimId, schemeId).get();
        LOG.info(String.format("searchReftMember text:%s,root number:%s,members size:%s", text, root.getString("number"), members.size()));
        if ("bcm_entitymembertree".equals(entityName) && root.getInt("level") != 2) {
            root = members.stream().filter(m -> m.getInt("level") == 2).findFirst().orElse(root);
            LOG.info(String.format("searchReftMember after text:%s,root number:%s", text, root.getString("number")));
        }
        if ((rowTreeMap = SearchHelper.getSearchItemId((String)text, (DynamicObjectCollection)members, (long)root.getLong("parent"))).size() == 0) {
            LOG.info(String.format("searchLeftMember not found text:%s,root number:%s,members size:%s", text, root.getString("number"), members.size()));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"NewSharingTree_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            treeView.focusNode(new TreeNode(null, root.getString("id"), ""));
            return;
        }
        ArrayList matchIds = new ArrayList(rowTreeMap.values());
        this.choiseRightNode((Long)matchIds.get(0));
        this.getPageCache().put(RFOCUS, "0");
        this.getPageCache().put(RLIST, SerializationUtils.toJsonString(matchIds));
    }

    protected void choiseRightNode(Long targetMemberId) {
        String entityName = this.getPageCache().get(memberCacheKey);
        long modelId = this.getModelId();
        TreeView rightTreeV = (TreeView)this.getControl("treeright");
        TreeModel rightTreeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)rightTree);
        ArrayList<Long> parentPath = new ArrayList<Long>(8);
        parentPath.add(targetMemberId);
        DimensionTreeNode treeNode = (DimensionTreeNode)rightTreeModel.searchByNodeId(targetMemberId.toString());
        for (int curRecursive = 0; Objects.isNull(treeNode) || curRecursive > 100; ++curRecursive) {
            Long curMemberId = (Long)parentPath.get(parentPath.size() - 1);
            Long parentId = MemberReader.findMemberById((long)modelId, (String)entityName, (Long)curMemberId).getParent().getId();
            DynamicObject parentMember = QueryServiceHelper.queryOne((String)entityName, (String)"id,parent", (QFilter[])new QFilter("id", "=", (Object)parentId).toArray());
            parentPath.add(parentId);
            treeNode = (DimensionTreeNode)rightTreeModel.searchByNodeId(parentMember.getString("id"));
        }
        if (Objects.isNull(treeNode)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5f02\u5e38", (String)"NewSharingTree_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (parentPath.size() > 1) {
            for (int i = parentPath.size() - 1; i > 0; --i) {
                String expandNodeId = String.valueOf(parentPath.get(i));
                rightTreeV.queryTreeNodeChildren(null, expandNodeId);
                rightTreeV.expand(expandNodeId);
            }
        }
        rightTreeV.focusNode(new TreeNode(null, targetMemberId.toString(), ""));
        rightTreeV.treeNodeClick(null, targetMemberId.toString());
    }

    private String initSchemeTree() {
        long modelId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        TreeView treeView = (TreeView)this.getControl(cslschemetree);
        CslSchemeServiceHelper.addTreeNode2TreeView((long)modelId, (boolean)true, (TreeView)treeView, (boolean)true);
        QFilter filter = new QFilter("number", "=", (Object)CslSchemeEnum.Default.getNumber());
        filter.and("model", "=", (Object)modelId);
        DynamicObject defaultScheme = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id,parent", (QFilter[])new QFilter[]{filter});
        if (defaultScheme == null) {
            defaultScheme = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id,parent", (QFilter[])new QFilter[]{new QFilter("1", "=", (Object)1)});
        }
        String dimenNum = (String)this.getView().getFormShowParameter().getCustomParam(dimensionNumberCacheKey);
        String cslschemeId = (String)this.getView().getFormShowParameter().getCustomParam("cslscheme");
        if (this.isCM() && dimenNum.equals("Entity")) {
            defaultScheme.set("id", (Object)cslschemeId);
        }
        TreeNode node = new TreeNode(defaultScheme.getString("parent"), defaultScheme.getString("id"), "");
        treeView.focusNode(node);
        treeView.treeNodeClick(node.getParentid(), node.getId());
        return defaultScheme.getString("id");
    }

    private void cacheTree(DimensionTreeNode root) {
        TreeModel treemodel = new TreeModel((ITreeNode)root);
        treemodel.ache2page(this.getPageCache(), rightTree);
    }

    private boolean checkDefaultMember(String selectMemberId, String entityname, String modelid, String dimensionnumber) {
        QFilter qnumber = new QFilter("id", "=", (Object)LongUtil.toLong((Object)selectMemberId));
        QFilter[] qnumbers = new QFilter[]{qnumber};
        DynamicObjectCollection dnumber = QueryServiceHelper.query((String)entityname, (String)"number,issysmember", (QFilter[])qnumbers);
        String message = "";
        if (dnumber != null && dnumber.size() != 0) {
            String fnumber = ((DynamicObject)dnumber.get(0)).getString("number");
            DimemberBaseAction daction = new DimemberBaseAction("", "", entityname, "", modelid);
            message = daction.checkAddEnable(fnumber, modelid, dimensionnumber, entityname, "baritemaddsub", ((DynamicObject)dnumber.get(0)).getString("issysmember"), false);
        }
        if ("AuditTrail" == dimensionnumber && ApplicationTypeEnum.CM == ModelUtil.queryApp((IFormView)this.getView())) {
            message = "";
        }
        if (!StringUtils.isEmpty((CharSequence)message)) {
            this.getView().showTipNotification(message);
            return false;
        }
        return true;
    }

    private boolean checkCtrlorg(String parentselectid) {
        QFilter filter = new QFilter("ctrlorg", "=", (Object)LongUtil.toLong((Object)parentselectid));
        DynamicObject org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"ctrlorg.name, ctrlorg.number", (QFilter[])new QFilter[]{filter});
        if (org != null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s \u201d\u201c%2$s\u201d\u5df2\u88ab\u5176\u4ed6\u7ec4\u7ec7\u6210\u5458\u8bbe\u7f6e\u4e3a\u63a7\u80a1\u7ec4\u7ec7\uff0c\u4e0d\u53ef\u65b0\u589e\u8be5\u7ec4\u7ec7\u6210\u5458\u7684\u4e0b\u7ea7\u3002", (String)"NewSharingTree_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]), org.getString("ctrlorg.number"), org.getString("ctrlorg.name")));
            return true;
        }
        return false;
    }

    private boolean checkStorageType(DimensionTreeNode rightNode) {
        String rightType = rightNode.getStoragetype();
        if (rightType.equals("3")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u521b\u5efa\u5171\u4eab\u6210\u5458\u7684\u4e0b\u7ea7\u6210\u5458\u3002", (String)"NewSharingTree_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (rightType.equals("4")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u50a8\u7c7b\u578b\u4e3a\u4e0d\u5171\u4eab\uff0c\u4e0d\u53ef\u65b0\u589e\u5171\u4eab\u6210\u5458\u3002", (String)"NewSharingTree_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkLeftStorageType(List<DynamicObject> leftNodes) {
        for (DynamicObject leftNode : leftNodes) {
            if (!"4".equals(leftNode.getString("storagetype"))) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u50a8\u7c7b\u578b\u201c\u4e0d\u5171\u4eab\u201d\u7684\u6210\u5458\u4e0d\u80fd\u88ab\u5171\u4eab\u3002", (String)"NewSharingTree_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private List<DynamicObject> getCurrentSelectIds() {
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(treeentryentity);
        int[] selectIndexs = treeEntry.getSelectRows();
        if (selectIndexs == null || selectIndexs.length == 0) {
            return null;
        }
        DynamicObjectCollection dyc = this.getModel().getEntryEntity(treeentryentity);
        ArrayList<DynamicObject> selectDys = new ArrayList<DynamicObject>(10);
        for (int index : selectIndexs) {
            selectDys.add((DynamicObject)dyc.get(index));
        }
        if (!this.isAllHavePerm(selectDys)) {
            return null;
        }
        return selectDys;
    }

    private boolean isAllHavePerm(List<DynamicObject> selectRowEntries) {
        if (selectRowEntries.size() < 1) {
            return false;
        }
        ArrayList<Object> memIds = new ArrayList<Object>(16);
        for (DynamicObject selectRowEntry : selectRowEntries) {
            memIds.add(selectRowEntry.get("memberid"));
        }
        String permMapCache = this.getPageCache().get(PermCacheKey.ORG_PERM_CACHE_KEY);
        if (permMapCache == null || Boolean.parseBoolean(this.getPageCache().get("rootuser"))) {
            return true;
        }
        PermPackageList permMap = (PermPackageList)SerializationUtils.fromJsonString((String)permMapCache, PermPackageList.class);
        for (Object e : memIds) {
            if (PermEnum.NOPERM != permMap.getPermEnum(e.toString())) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u64cd\u4f5c\u5bf9\u5e94\u7684\u6210\u5458\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"NewSharingTree_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void cacheParam() {
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        String dimensionId = (String)this.getView().getFormShowParameter().getCustomParam("dimensionId");
        String entityName = (String)this.getView().getFormShowParameter().getCustomParam("memberentity");
        String dimNum = (String)this.getView().getFormShowParameter().getCustomParam(dimensionNumberCacheKey);
        this.getPageCache().put(dimensionNumberCacheKey, dimNum);
        this.getPageCache().put(modelCacheKey, modelId);
        this.getPageCache().put(dimensionCacheKey, dimensionId);
        this.getPageCache().put(memberCacheKey, entityName);
    }

    public void initLeftTree(String schemeId) {
        this.getPageCache().put(CSLTREENODECLICK, schemeId);
        Long dimensionId = Long.valueOf(this.getPageCache().get(dimensionCacheKey));
        Long modelId = Long.valueOf(this.getPageCache().get(modelCacheKey));
        Long cslSchemeId = StringUtils.isEmpty((CharSequence)schemeId) ? null : Long.valueOf(schemeId);
        DynamicObject dimension = MemberReader.getDimensionDynById((long)dimensionId);
        String entityName = dimension.getString("membermodel");
        this.getModel().deleteEntryData(treeentryentity);
        Optional<DynamicObject> root = this.getRoot(entityName, modelId, dimensionId, cslSchemeId);
        if (root.isPresent()) {
            IDataModel model = this.getModel();
            model.deleteEntryData(treeentryentity);
            model.getDataEntity(true);
            model.beginInit();
            model.batchCreateNewEntryRow(treeentryentity, 1);
            model.endInit();
            DynamicObject rootNodeV = model.getEntryRowEntity(treeentryentity, 0);
            rootNodeV.set("number", (Object)root.get().getString("number"));
            rootNodeV.set("name", (Object)root.get().getString("name"));
            rootNodeV.set("storagetype", (Object)root.get().getString("storagetype"));
            rootNodeV.set("id", (Object)root.get().getLong("id"));
            rootNodeV.set("pid", (Object)0);
            rootNodeV.set("isgroupnode", (Object)(!root.get().getBoolean("isleaf") ? 1 : 0));
            if ("bcm_entitymembertree".equals(entityName)) {
                StringBuilder sb = new StringBuilder();
                for (int j = 1; j <= 10; ++j) {
                    String dp = root.get().getString("dpropertyid" + j + ".number");
                    if (!StringUtils.isNotEmpty((CharSequence)dp)) continue;
                    sb.append(dp).append(";");
                }
                rootNodeV.set("userproperty", (Object)sb.toString());
            }
            this.updateLeftViewNextLevel(cslSchemeId, 0);
            this.getPageCache().put(CACHEKEY_cslSchemeID, schemeId);
            TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(treeentryentity);
            treeEntry.expandOne(0);
            this.getView().updateView(treeentryentity);
        }
    }

    private void updateLeftViewNextLevel(Long cslSchemeId, int appendEntryIndex) {
        Long dimensionId = Long.valueOf(this.getPageCache().get(dimensionCacheKey));
        Long modelId = Long.valueOf(this.getPageCache().get(modelCacheKey));
        DynamicObject dimension = MemberReader.getDimensionDynById((long)dimensionId);
        String entityName = dimension.getString("membermodel");
        long parentId = this.getModel().getEntryRowEntity(treeentryentity, appendEntryIndex).getLong("id");
        DynamicObjectCollection child = this.listLeftTreeLevelMembers(modelId, dimensionId, cslSchemeId, entityName, parentId);
        List<Integer> groupIndexes = this.updateLeftTreeView(child, parentId, appendEntryIndex, entityName);
        if (!groupIndexes.isEmpty()) {
            int[] index = new int[groupIndexes.size()];
            for (int j = 0; j < groupIndexes.size(); ++j) {
                index[j] = groupIndexes.get(j);
            }
            TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(treeentryentity);
            treeEntry.collapse(index);
        }
    }

    private List<Integer> updateLeftTreeView(DynamicObjectCollection childMembers, long parentId, int appendEntryIndex, String entityName) {
        IDataModel model = this.getModel();
        if (childMembers.isEmpty()) {
            DynamicObject parentNodeV = model.getEntryRowEntity(treeentryentity, appendEntryIndex);
            parentNodeV.set("isgroupnode", (Object)false);
            return Collections.EMPTY_LIST;
        }
        int realSize = childMembers.size();
        int maxCount = BCMTreeUtils.getMaxCount((long)this.getModelId());
        if (maxCount > 0 && childMembers.size() > maxCount) {
            realSize = maxCount;
        }
        model.beginInit();
        int[] newEntries = model.batchInsertEntryRow(treeentryentity, appendEntryIndex, realSize);
        model.endInit();
        ArrayList<Integer> groupLineIndexes = new ArrayList<Integer>(8);
        for (int i = 0; i < realSize; ++i) {
            int entryIndex = newEntries[i];
            DynamicObject rootNodeV = model.getEntryRowEntity(treeentryentity, entryIndex);
            DynamicObject member = (DynamicObject)childMembers.get(i);
            rootNodeV.set("number", (Object)member.getString("number"));
            rootNodeV.set("name", (Object)member.getString("name"));
            rootNodeV.set("storagetype", (Object)member.getString("storagetype"));
            rootNodeV.set("id", (Object)member.getLong("id"));
            rootNodeV.set("pid", (Object)String.valueOf(parentId));
            if ("bcm_entitymembertree".equals(entityName)) {
                StringBuilder sb = new StringBuilder();
                for (int j = 1; j <= 10; ++j) {
                    String dp = member.getString("dpropertyid" + j + ".number");
                    if (!StringUtils.isNotEmpty((CharSequence)dp)) continue;
                    sb.append(dp).append(";");
                }
                rootNodeV.set("userproperty", (Object)sb.toString());
            }
            boolean isGroup = false;
            IDNumberTreeNode memberById = MemberReader.findMemberById((long)this.getModelId(), (String)entityName, (Long)member.getLong("id"));
            for (IDNumberTreeNode groupLineIndex : memberById.getChildren()) {
                if (groupLineIndex.isShare()) continue;
                isGroup = true;
                break;
            }
            rootNodeV.set("isgroupnode", (Object)isGroup);
            if (!isGroup) continue;
            groupLineIndexes.add(entryIndex);
        }
        return groupLineIndexes;
    }

    private DynamicObjectCollection listLeftTreeLevelMembers(long modelId, long dimensionId, Long schemeId, String entityName, Long parentId) {
        if (Objects.isNull(parentId)) {
            throw new IllegalArgumentException("this method requires the param parentId");
        }
        String selectFields = "id,name,number,parent,isleaf,storagetype,member.id,share,level,dseq,copyfrom,longnumber";
        QFilter filter = new QFilter("model.id", "=", (Object)modelId);
        filter.and(new QFilter("dimension.id", "=", (Object)dimensionId));
        filter.and(new QFilter("storagetype", "!=", (Object)"3"));
        if ("bcm_entitymembertree".equals(entityName)) {
            filter.and("isexchangerate", "!=", (Object)"1");
            if (this.isCM()) {
                filter.and("cslscheme", "=", (Object)schemeId);
            }
            selectFields = selectFields + "," + SELECTField_USERPROPERTY;
        }
        filter.and("parent", "=", (Object)parentId);
        return QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filter.toArray(), (String)"level,dseq");
    }

    private List<String> getProperties(String menberentityid) {
        ArrayList<String> properties = new ArrayList<String>(10);
        properties.add("number");
        properties.add("name");
        properties.add("memberid");
        properties.add("storagetype");
        return properties;
    }

    private String getSelectMemberFields(String menberentityid) {
        String selectMemberFields = "id,id as memberid,name,number,dseq,parent,aggoprt,storageType,modifier.name as modifier,modifyTime,level,isleaf";
        if (menberentityid.equals("bcm_changetypemembertree")) {
            selectMemberFields = "id,id as memberid,name,number,dseq,parent,aggoprt,storageType,modifier.name as modifier,modifyTime,level,isleaf";
        }
        if ("bcm_structofextend".equals(menberentityid)) {
            selectMemberFields = "id,id as memberid,name,number,dseq,parent,storageType,modifier.name as modifier,modifyTime,level,isleaf";
        }
        return selectMemberFields;
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        String cslSchemeId = this.getPageCache().get(CACHEKEY_cslSchemeID);
        this.updateLeftViewNextLevel(StringUtils.isEmpty((CharSequence)cslSchemeId) ? null : Long.valueOf(cslSchemeId), evt.getRowKey());
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(treeentryentity);
        treeEntry.expandOne(evt.getRowKey());
        treeEntry.selectRows(evt.getRowKey());
        treeEntry.focusCell(evt.getRowKey(), "number");
        this.getView().updateView(treeentryentity, evt.getRowKey());
        treeEntry.selectRows(new int[]{evt.getRowKey()}, evt.getRowKey());
    }

    protected void alterIsleaf(String parentselectid, String entityname) {
        DynamicObject dot = BusinessDataServiceHelper.loadSingle((Object)parentselectid, (String)entityname);
        boolean isleaf = dot.getBoolean("isleaf");
        if (isleaf) {
            dot.set("isleaf", (Object)"0");
            BusinessDataServiceHelper.save((IDataEntityType)dot.getDataEntityType(), (Object[])new Object[]{dot});
        }
    }

    private static String buildNodeName(DynamicObject dy, boolean isChildForShare, boolean isNew) {
        String storageTypeName = isChildForShare || isNew ? DimensionTreeNode.getStorage((String)"3") : DimensionTreeNode.getStorage((String)dy.getString("storagetype"));
        return dy.getString("number") + " " + dy.getString("name") + storageTypeName;
    }

    private void pullRightTreeNextLevel(TreeView treeView, String clickNodeId) {
        Map idMaps;
        String id;
        String temp_ids;
        FormShowParameter parameters = this.getView().getFormShowParameter();
        Long cslschemeId = StringUtils.isEmpty((CharSequence)((CharSequence)parameters.getCustomParam("cslscheme"))) ? null : Long.valueOf((String)parameters.getCustomParam("cslscheme"));
        Long dimensionId = Long.valueOf((String)parameters.getCustomParam("dimensionId"));
        Long modelId = Long.valueOf((String)parameters.getCustomParam("KEY_MODEL_ID"));
        String entitynumber = this.getPageCache().get(memberCacheKey);
        if (StringUtils.isEmpty((CharSequence)clickNodeId)) {
            treeView.deleteAllNodes();
            Optional<DynamicObject> root = this.getRoot(entitynumber, modelId, dimensionId, cslschemeId);
            if (!root.isPresent()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f3a\u5c11\u6839\u8282\u70b9\u8fdb\u884c\u65b0\u589e\u5171\u4eab\u3002", (String)"NewSharingTree_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            TreeNode rootNode = new TreeNode("", root.get().getString("id"), NewSharingTree.buildNodeName(root.get(), false, false), !root.get().getBoolean("isleaf"));
            rootNode.setIsOpened(true);
            treeView.deleteAllNodes();
            treeView.addNode(rootNode);
            clickNodeId = root.get().getString("id");
            this.getPageCache().put(rightFocusNodeId, clickNodeId);
            treeView.focusNode(rootNode);
            DimensionTreeNode rootTemp = new DimensionTreeNode("root", "all");
            DynamicObjectCollection rootCollectionWrap = new DynamicObjectCollection();
            rootCollectionWrap.add(0, root.get());
            DimensionTreeNode _root = TreeBuilder.getDimensionTree((DynamicObjectCollection)rootCollectionWrap, (DimensionTreeNode)rootTemp, (String)root.get().getString("parent"));
            this.cacheTree(_root);
        }
        String parentId = clickNodeId;
        DynamicObjectCollection child = this.listTreeLevelMembers(dimensionId, entitynumber, modelId, cslschemeId, parentId);
        if (child.isEmpty() && !StringUtil.isEmpty((CharSequence)(temp_ids = this.getView().getPageCache().get("temp_ids"))) && StringUtil.isNotEmpty((CharSequence)(id = (String)(idMaps = (Map)SerializationUtils.deSerializeFromBase64((String)temp_ids)).get(parentId)))) {
            child = this.listTreeLevelMembers(dimensionId, entitynumber, modelId, 0L, id);
        }
        TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)rightTree);
        DimensionTreeNode rightFocusNode = (DimensionTreeNode)treeModel.searchByNodeId(clickNodeId);
        boolean isNew = this.isNeedSave(rightFocusNode);
        this.updateRightTreeModel(parentId, child, false, isNew);
    }

    private boolean isNeedSave(DimensionTreeNode node) {
        if (node == null) {
            return false;
        }
        if (node.isNeadsave()) {
            return true;
        }
        if (node.getParent() != null) {
            return this.isNeedSave(node.getParent());
        }
        return false;
    }

    private void updateRightTreeModel(String treeViewParentId, DynamicObjectCollection childMembers, boolean isChildForShare, boolean isNew) {
        if (childMembers.isEmpty()) {
            return;
        }
        HashMap sourceIdShareIdMap = new HashMap(8);
        HashMap<String, String> sid2Ids = new HashMap<String, String>(16);
        List childNodes = childMembers.stream().map(x -> {
            String nodeId = x.getString("id");
            if (isChildForShare) {
                nodeId = String.valueOf(GlobalIdUtil.genGlobalLongId());
                sid2Ids.put(nodeId, x.getString("id"));
            }
            sourceIdShareIdMap.put(x.getString("id"), nodeId);
            boolean isParent = !x.getBoolean("isleaf");
            TreeNode oneNode = new TreeNode(treeViewParentId, nodeId, NewSharingTree.buildNodeName(x, isChildForShare, isNew), isParent);
            if (isParent) {
                oneNode.setChildren(new ArrayList(1));
            }
            oneNode.setIsOpened(false);
            if (isChildForShare || isNew) {
                oneNode.setColor("blue");
            }
            return oneNode;
        }).collect(Collectors.toList());
        TreeView rightTreeView = (TreeView)this.getView().getControl("treeright");
        int maxCount = BCMTreeUtils.getMaxCount((long)this.getModelId());
        if (maxCount > 0 && childNodes.size() > maxCount) {
            childNodes = childNodes.subList(0, maxCount);
        }
        rightTreeView.addNodes(childNodes);
        TreeModel treeModel = (TreeModel)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(rightTree));
        DimensionTreeNode treeModelRoot = (DimensionTreeNode)treeModel.getRoot();
        DimensionTreeNode targetNode = (DimensionTreeNode)treeModelRoot.getTreeNode(String.valueOf(treeViewParentId), 999);
        if (targetNode == null) {
            return;
        }
        List dimensionChild = childMembers.stream().map(x -> {
            DimensionTreeNode treeNode = TreeBuilder.buildDimensionTreeNode((DynamicObject)x, null, (boolean)false);
            if (isChildForShare) {
                treeNode.setCopyfrom(treeNode.getId());
                treeNode.setId((String)sourceIdShareIdMap.get(treeNode.getId()));
                treeNode.setStoragetype(StorageTypeEnum.SHARE.index);
                treeNode.setNeadsave(true);
            }
            return treeNode;
        }).collect(Collectors.toList());
        dimensionChild.stream().forEach(x -> {
            if (!targetNode.getChildren().stream().map(t -> ((DimensionTreeNode)t).getNumber()).filter(t -> x.getNumber().equals(t)).findAny().isPresent()) {
                targetNode.addChild((ITreeNode)x);
            }
        });
        this.cacheTree(treeModelRoot);
        this.cacheTmpIds(sid2Ids);
    }

    private Optional<DynamicObject> getRoot(String entityName, Long modelId, Long dimId, Long schemeId) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and(new QFilter("dimension", "=", (Object)dimId));
        String selectFields = "id,name,number,parent,isleaf,storagetype,member.id,share,level,dseq,copyfrom,longnumber";
        if ("bcm_entitymembertree".equals(entityName)) {
            if (this.isRPT()) {
                filter.and("level", "=", (Object)1);
                filter.and("isexchangerate", "=", (Object)Character.valueOf('0'));
            } else {
                filter.and("cslscheme", "=", (Object)schemeId);
                filter.and("level", "=", (Object)2);
            }
            selectFields = selectFields + "," + SELECTField_USERPROPERTY;
        } else if ("bcm_structofextend".equals(entityName)) {
            selectFields = "id,name,number,parent,isleaf,storagetype,member.id,level,dseq,copyfrom,longnumber";
        } else {
            filter.and("parent", "=", (Object)0L);
        }
        DynamicObjectCollection root = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filter.toArray(), (String)"level,dseq", (int)1);
        if (root.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(root.get(0));
    }

    private DynamicObjectCollection listTreeLevelMembers(long dimensionid, String entityName, long modelId, Long cslschemeId, String parentId) {
        if (Objects.isNull(parentId)) {
            throw new IllegalArgumentException("this method requires the param parentId");
        }
        QFilter filters = new QFilter("dimension", "=", (Object)dimensionid);
        filters.and("model", "=", (Object)modelId);
        if ("bcm_entitymembertree".equals(entityName)) {
            if (this.isRPT()) {
                filters.and("isexchangerate", "!=", (Object)"1");
            }
            if (this.isCM() && cslschemeId != 0L) {
                filters.and("cslscheme", "=", (Object)cslschemeId);
            }
        }
        filters.and("parent", "=", (Object)Long.valueOf(parentId));
        return ReportListUtil.getOrgCollectionForShare(entityName, null, filters.toArray(), "level,dseq");
    }

    private String getRightSelectedFields() {
        return "id,name,number,parent,isleaf,storagetype,member.id,level,dseq,copyfrom,longnumber";
    }

    private void cacheTmpIds(Map<String, String> sid2Ids) {
        if (sid2Ids.size() == 0) {
            return;
        }
        String temp_ids = this.getView().getPageCache().get("temp_ids");
        if (StringUtils.isNotEmpty((CharSequence)temp_ids)) {
            Map oldTmpIds = (Map)SerializationUtils.deSerializeFromBase64((String)temp_ids);
            sid2Ids.putAll(oldTmpIds);
        }
        this.getView().getPageCache().put("temp_ids", SerializationUtils.serializeToBase64(sid2Ids));
    }

    private void removeCacheTmpIds(String rightFocusId) {
        String temp_ids = this.getView().getPageCache().get("temp_ids");
        if (StringUtils.isNotEmpty((CharSequence)temp_ids)) {
            Map tmpIds = (Map)SerializationUtils.deSerializeFromBase64((String)temp_ids);
            tmpIds.remove(rightFocusId);
            this.getView().getPageCache().put("temp_ids", SerializationUtils.serializeToBase64((Object)tmpIds));
        }
    }
}

