/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.dimension.imp.DimensionImportHelper;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections.MapUtils;

public class SetMappingEditPlugin
extends AbstractBaseListPlugin {
    private static final String MEMBER = "member";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String FILTER_DESC = "filterdesc";
    private static final String FILTER_CONDITION = "filtercondition";
    private static final String FILTER_CONDITION_TAG = "filtercondition_tag";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit dimension = (BasedataEdit)this.getControl("dimension");
        BasedataEdit config = (BasedataEdit)this.getControl("config");
        dimension.addBeforeF7SelectListener(this::beforeF7Select);
        config.addBeforeF7SelectListener(this::beforeF7Select);
        this.addClickListeners(MEMBER, FILTER_DESC);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("reporttype", (Object)ApplicationTypeEnum.getEnumByNumber((String)this.getBizAppId()).getOIndex());
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"reporttype"});
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"cslscheme"});
        this.filterControl();
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "member": {
                this.showSingleF7(key);
                break;
            }
            case "filterdesc": {
                EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
                DynamicObject object = this.getModel().getEntryRowEntity(ENTRY_ENTITY, grid.getSelectRows()[0]);
                if (object == null || StringUtils.isEmpty((String)object.getString("config.number"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6620\u5c04\u6e90\u5206\u7c7b\u3002", (String)"SetMappingEditPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("bos_flex_propcondition");
                showParameter.setCustomParam("filterjson", this.getModel().getValue(FILTER_CONDITION_TAG));
                showParameter.setCustomParam("baseformid", (Object)object.getString("config.number"));
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FILTER_DESC));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
            }
        }
    }

    private void showSingleF7(String key) {
        long modelId = this.getModelId();
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        DynamicObject obj = this.getModel().getEntryRowEntity(ENTRY_ENTITY, grid.getSelectRows()[0]);
        long dimensionId = obj.getLong("dimension.id");
        String dimNumber = obj.getString("dimension.number");
        if (modelId == 0L || dimensionId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"SetMappingEditPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (DimEntityNumEnum.INTERCOMPANY.getNumber().equalsIgnoreCase(dimNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f80\u6765\u7ec4\u7ec7\u4e0d\u652f\u6301\u6307\u5b9a\u7ef4\u5ea6\u6210\u5458\u3002", (String)"SetMappingEditPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (DimEntityNumEnum.CURRENCY.getNumber().equalsIgnoreCase(dimNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u652f\u6301\u6307\u5b9a\u7ef4\u5ea6\u6210\u5458\u3002", (String)"SetMappingEditPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        BasedataEditSingleMemberF7 f7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), modelId, dimensionId, key, null, true, SingleF7TypeEnum.CUSTOM);
        f7.setFormId("bcm_singlemember_float");
        HashMap customData = f7.getCustomData();
        if (MapUtils.isEmpty(customData)) {
            customData = Maps.newHashMap();
        }
        if (!DimEntityNumEnum.ENTITY.getNumber().equalsIgnoreCase(dimNumber)) {
            customData.put("isShowCslScheme", "false");
        }
        customData.put("isContainShare", false);
        customData.put("isAll", true);
        f7.setCustomData(customData);
        f7.setF7title(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"TemplateFloatSettingPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        f7.setCallBackClassName(this.getClass().getName());
        f7.setStatus(OperationStatus.EDIT);
        f7.click();
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        EntryGrid eg = (EntryGrid)this.getControl(ENTRY_ENTITY);
        if (FILTER_DESC.equals(actionId)) {
            Map data = (Map)event.getReturnData();
            if (data != null) {
                this.getModel().setValue(FILTER_DESC, data.get("display"));
                this.getModel().setValue(FILTER_CONDITION, data.get("display"));
                this.getModel().setValue(FILTER_CONDITION_TAG, data.get("value"));
            }
        } else {
            DynamicObject result = (DynamicObject)event.getReturnData();
            if (result != null) {
                this.getModel().setValue(actionId, result.get("number"), eg.getSelectRows()[0]);
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = ((BasedataEdit)event.getSource()).getKey();
        if ("model".equals(key)) {
            List<QFilter> qf = ModelUtil.getModelFilter(this.getView());
            String appNum = this.isCM() ? ApplicationTypeEnum.CM.getAppnum() : ApplicationTypeEnum.RPT.getAppnum();
            List<Long> modelIds = ModelUtil.getParPermItemModels(this.getView().getEntityId(), appNum, "3E7+2X6S09FC");
            if (modelIds.size() > 0) {
                qf.add(new QFilter("id", "in", modelIds));
            }
            event.setCustomQFilters(qf);
        } else if ("dimension".equals(key)) {
            if (Objects.isNull(this.getModel().getValue("model"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AbstractBaseListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
                event.setCancel(true);
                return;
            }
            ArrayList filterDimNum = Lists.newArrayList((Object[])new String[]{DimEntityNumEnum.YEAR.getNumber(), DimEntityNumEnum.PERIOD.getNumber(), DimEntityNumEnum.PROCESS.getNumber(), DimEntityNumEnum.SCENARIO.getNumber(), DimEntityNumEnum.AUDITTRIAL.getNumber(), DimEntityNumEnum.CHANGETYPE.getNumber(), DimEntityNumEnum.MULTIGAAP.getNumber(), DimEntityNumEnum.DATASORT.getNumber(), DimEntityNumEnum.DATETYPE.getNumber(), DimEntityNumEnum.MYCOMPANY.getNumber(), DimEntityNumEnum.METRIC.getNumber()});
            QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
            qf.and("number", "not in", (Object)filterDimNum);
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl("dimension")).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>();
            }
            qFilterList.add(qf);
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, "dseq"));
        } else if ("config".equals(key)) {
            QFilter sourceQf = new QFilter("source", "=", this.getModel().getValue("source"));
            sourceQf.and(new QFilter("enable", "=", (Object)"1"));
            event.addCustomQFilter(sourceQf);
        }
    }

    private void checkMappings(BeforeDoOperationEventArgs args, String configNumber, String dimNumber, long cslscheme) {
        if ("bos_org".equals(configNumber) && cslscheme == 0L) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6620\u5c04\u6e90\u5fc5\u987b\u914d\u7f6e\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"SetMappingEditPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("bos_org".equals(configNumber) && !DimEntityNumEnum.ENTITY.getNumber().equals(dimNumber) || DimEntityNumEnum.ENTITY.getNumber().equals(dimNumber) && !"bos_org".equals(configNumber)) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6620\u5c04\u6e90\u53ea\u80fd\u914d\u7f6e\u7ec4\u7ec7\u7ef4\u5ea6\u3002", (String)"SetMappingEditPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("bd_accountview".equals(configNumber) && !DimEntityNumEnum.ACCOUNT.getNumber().equals(dimNumber) || DimEntityNumEnum.ACCOUNT.getNumber().equals(dimNumber) && !"bd_accountview".equals(configNumber)) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u79d1\u76ee\u6620\u5c04\u6e90\u53ea\u80fd\u914d\u7f6e\u79d1\u76ee\u7ef4\u5ea6\u3002", (String)"SetMappingEditPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!DimensionImportHelper.IC_SOURCE.contains(configNumber) && dimNumber.equals(DimEntityNumEnum.INTERCOMPANY.getNumber())) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f80\u6765\u7ec4\u7ec7\u7684\u6620\u5c04\u6e90\u53ea\u80fd\u662f\u5546\u52a1\u4f19\u4f34\uff0c\u5ba2\u6237\uff0c\u4f9b\u5e94\u5546\u3002", (String)"SetMappingEditPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if ("bos_org".equals(configNumber)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue("model");
            long mappingId = (Long)this.getModel().getValue("id");
            QFilter filter = new QFilter("model", "=", (Object)model.getLong("id"));
            filter.and(new QFilter("id", "!=", (Object)mappingId));
            DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"bcm_bdmapping", (String)"id,entryentity.config,cslscheme", (QFilter[])new QFilter[]{filter});
            if (Objects.isNull(dyns)) {
                return;
            }
            for (DynamicObject dyn : dyns) {
                DynamicObjectCollection doc = (DynamicObjectCollection)dyn.get(ENTRY_ENTITY);
                for (DynamicObject d : doc) {
                    if (!"bos_org".equals(d.get("config.number")) || cslscheme == (Long)d.get("cslscheme.id")) continue;
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5176\u4ed6\u6620\u5c04\u5173\u7cfb\u65b9\u6848\u5df2\u7ecf\u914d\u7f6e\u4e86\u4e0d\u540c\u7684\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"SetMappingEditPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            boolean isNew;
            DynamicObject model = (DynamicObject)this.getModel().getValue("model");
            long mappingId = (Long)this.getModel().getValue("id");
            boolean bl = isNew = !QueryServiceHelper.exists((String)"bcm_bdmapping", (Object)mappingId);
            if (isNew && model != null) {
                QFilter filter = new QFilter("model", "=", (Object)model.getLong("id"));
                filter.and(new QFilter("id", "!=", (Object)mappingId));
                if (QueryServiceHelper.exists((String)"bcm_bdmapping", (QFilter[])new QFilter[]{filter})) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u5df2\u5b58\u5728\u6620\u5c04\u5173\u7cfb\u3002", (String)"SetMappingEditPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            DynamicObjectCollection records = this.getModel().getEntryEntity(ENTRY_ENTITY);
            int row = 1;
            HashSet<String> markSet = new HashSet<String>(16);
            for (DynamicObject dy : records) {
                String configNumber = dy.getString("config.number");
                String dimNumber = dy.getString("dimension.number");
                if (StringUtils.isEmpty((String)configNumber) || StringUtils.isEmpty((String)dimNumber)) continue;
                this.checkMappings(args, configNumber, dimNumber, dy.getLong("cslscheme.id"));
                boolean isPass = this.checkMappingsBind(args, dy, row++);
                if (!isPass) {
                    return;
                }
                String mark = dy.getString("cusname");
                if (StringUtil.isEmptyString((String)mark) || markSet.add(mark)) continue;
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6620\u5c04\u6807\u8bc6\u4e0d\u80fd\u91cd\u590d\u3002", (String)"SetMappingEditPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if (args.getSource() instanceof DeleteEntry) {
            this.checkBindByModel(args);
        }
    }

    private void checkBindByModel(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection records = this.getModel().getEntryEntity(ENTRY_ENTITY);
        int[] selectRow = ((EntryGrid)this.getView().getControl(ENTRY_ENTITY)).getSelectRows();
        for (int i = 0; i < selectRow.length; ++i) {
            DynamicObject dynamicObject = (DynamicObject)records.get(selectRow[i]);
            Long id = dynamicObject.getLong("id");
            if (id == 0L) continue;
            Pair<Boolean, String> isBind = this.checkBind(id);
            if (!((Boolean)isBind.p1).booleanValue()) continue;
            args.setCancel(true);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u884c\u88ab%1$s\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"SetMappingEditPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]), isBind.p2));
        }
    }

    private boolean checkMappingsBind(BeforeDoOperationEventArgs args, DynamicObject dy, int row) {
        long id = dy.getLong("id");
        if (id == 0L) {
            return true;
        }
        Pair<Boolean, String> isBind = this.checkBind(id);
        if (!((Boolean)isBind.p1).booleanValue()) {
            return true;
        }
        DynamicObject dny = this.getMappingSetByItemId(id);
        if (dny == null) {
            return true;
        }
        DynamicObject dnyItem = this.getMappingSetItemById(dny, id);
        if (dnyItem == null) {
            return true;
        }
        if (dy.getDynamicObject("config").getLong("id") != dnyItem.getDynamicObject("config").getLong("id") || dy.getDynamicObject("dimension").getLong("id") != dnyItem.getDynamicObject("dimension").getLong("id")) {
            args.setCancel(true);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u88ab%2$s\u5f15\u7528\uff0c\u4e0d\u80fd\u4fee\u6539\u3002", (String)"SetMappingEditPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]), row, isBind.p2));
            return false;
        }
        return true;
    }

    private Pair<Boolean, String> checkBind(Long id) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"scheme.number", (QFilter[])new QFilter("pubmappingid", "=", (Object)id).toArray());
        if (query != null && query.size() > 0) {
            StringBuilder sb = new StringBuilder(16);
            sb.append("[");
            HashSet<String> numberSet = new HashSet<String>(16);
            for (DynamicObject obj : query) {
                if (!numberSet.add(obj.getString("scheme.number"))) continue;
                sb.append(obj.getString("scheme.number"));
                sb.append(";");
            }
            sb.append("]");
            return Pair.onePair((Object)true, (Object)sb.toString());
        }
        DynamicObjectCollection query2 = QueryServiceHelper.query((String)"bcm_dimensionmapnew", (String)"id", (QFilter[])new QFilter("refid", "=", (Object)id).toArray());
        if (query2 != null && query2.size() > 0) {
            String str = ResManager.loadKDString((String)"\u516c\u5f0f\u53d6\u6570-\u7ef4\u5ea6\u6620\u5c04", (String)"DimensionMappingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)true, (Object)str);
        }
        return Pair.onePair((Object)false, (Object)"");
    }

    private DynamicObject getMappingSetByItemId(long selectId) {
        QFilter filters = new QFilter("entryentity.id", "=", (Object)selectId);
        return BusinessDataServiceHelper.loadSingle((String)"bcm_bdmapping", (String)"entryentity.id, entryentity.cusname, entryentity.config, entryentity.dimension", (QFilter[])filters.toArray());
    }

    private DynamicObject getMappingSetById(long id) {
        QFilter filters = new QFilter("id", "=", (Object)id);
        return BusinessDataServiceHelper.loadSingle((String)"bcm_bdmapping", (String)"entryentity.id, entryentity.cusname, entryentity.config, entryentity.dimension", (QFilter[])filters.toArray());
    }

    private DynamicObject getMappingSetItemById(DynamicObject dyn, long selectId) {
        DynamicObjectCollection entryentity = dyn.getDynamicObjectCollection(ENTRY_ENTITY);
        for (DynamicObject obj : entryentity) {
            if (obj.getLong("id") != selectId) continue;
            return obj;
        }
        return null;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        boolean isSuccess;
        super.afterDoOperation(args);
        if (args.getSource() instanceof Save && (isSuccess = args.getOperationResult().getValidateResult().isSuccess())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"reporttype", "model", "number", "source"});
            OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u65b0\u589e", "SetMappingEditPlugin_2", "fi-bcm-formplugin", "add");
            OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u65b0\u589e\u6620\u5c04\u5173\u7cfb\u6210\u529f\u3002", "SetMappingEditPlugin_3", "fi-bcm-formplugin", null);
            this.writeMultiLangLog(opName, opDes);
            GlobalCacheServiceHelper.invalidateCacheByKey((String)"dim-basedata-mapping");
            IntegrationUtil.deleteSingMappingByAll();
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String newValue;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("dimension".equals(name)) {
            this.getModel().setValue(MEMBER, null);
            DynamicObject newValue2 = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (Objects.isNull(newValue2)) {
                return;
            }
            String number = newValue2.getString("number");
            if ("Entity".equals(number)) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"cslscheme"});
            } else {
                this.getModel().setValue("cslscheme", null);
            }
        } else if ("model".equals(name)) {
            EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
            DynamicObjectCollection records = this.getModel().getEntryEntity(ENTRY_ENTITY);
            for (int i = 0; i < records.size(); ++i) {
                grid.getModel().setValue("config", null, i);
                grid.getModel().setValue("dimension", null, i);
                grid.getModel().setValue(MEMBER, null, i);
                grid.getModel().setValue("cslscheme", null, i);
            }
        } else if ("config".equals(name)) {
            this.filterControl();
        } else if (FILTER_DESC.equals(name) && StringUtils.isBlank((String)(newValue = (String)e.getChangeSet()[0].getNewValue()))) {
            this.getModel().setValue(FILTER_CONDITION, (Object)"");
            this.getModel().setValue(FILTER_CONDITION_TAG, (Object)"");
        }
    }

    private void filterControl() {
        IDataModel model = this.getModel();
        DynamicObjectCollection docs = model.getEntryEntity(ENTRY_ENTITY);
        for (int i = 0; i < docs.size(); ++i) {
            model.setValue(FILTER_DESC, model.getValue(FILTER_CONDITION, i), i);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_mapping": {
                this.goMapping();
                break;
            }
            case "btn_metadata": {
                this.goMetaDateInfo();
            }
        }
    }

    private void goMetaDateInfo() {
        String pageId = this.getView().getPageId() + "goMedaDateInfo";
        IFormView view = this.getView();
        IFormView mainPageView = view.getMainView();
        if (ObjectUtils.isEmpty((Object)mainPageView) || ObjectUtils.isEmpty((Object)mainPageView.getView(pageId))) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bcm_bdconfiglist");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setPageId(pageId);
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u5143\u6570\u636e\u5217\u8868", (String)"SetMappingEditPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            IFormView parentView = view.getParentView();
            if (ObjectUtils.isEmpty((Object)parentView)) {
                this.getView().showForm(formShowParameter);
            } else {
                parentView.showForm(formShowParameter);
                view.sendFormAction(parentView);
            }
        } else {
            IFormView childView = mainPageView.getView(pageId);
            childView.activate();
            view.sendFormAction(childView);
        }
    }

    private void goMapping() {
        Long id = (Long)this.getModel().getValue("id");
        if (id == 0L || this.getModel().getDataChanged()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e\u3002", (String)"SetMappingEditPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject mappingSet = this.getMappingSetById(id);
        DynamicObjectCollection records = mappingSet.getDynamicObjectCollection(ENTRY_ENTITY);
        if (records == null || records.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u6620\u5c04\u3002", (String)"SetMappingEditPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        for (DynamicObject re : records) {
            if (!StringUtils.isEmpty((String)re.getString("cusname"))) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5c06\u6240\u6709\u6620\u5c04\u8bbe\u7f6e\u6807\u8bc6\u3002", (String)"SetMappingEditPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_pubmemmapping");
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(formShowParameter);
    }
}

