/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.IntStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.Delete;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bcm.business.event.EventSubscriptionServiceHelper;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;

public class SetMappingListPlugin
extends AbstractBaseListPlugin {
    @Override
    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_import", "bar_export"});
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        Object[] ids = billList.getSelectedRows().getPrimaryKeyValues();
        DynamicObject[] dys = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)billList.getEntityType());
        String numbers = "";
        if (dys != null && dys.length > 0) {
            numbers = this.getNumberList(dys);
            this.getPageCache().put("numbers", numbers);
        }
        if ("bar_enable".equals(key)) {
            if (ids.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MyTemplatePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
                return;
            }
            StringBuilder invalidNum = new StringBuilder();
            HashMap<String, String> repeat = new HashMap<String, String>(16);
            for (DynamicObject obj : dys) {
                if (repeat.containsKey(obj.getString("model.id"))) {
                    if (invalidNum.length() > 0) {
                        invalidNum.append(",");
                    }
                    invalidNum.append(obj.getString("number"));
                    continue;
                }
                repeat.put(obj.getString("model.id"), obj.getString("number"));
                QFilter filter = new QFilter("model", "=", (Object)obj.getLong("model.id"));
                filter.and(new QFilter("id", "!=", (Object)obj.getLong("id")));
                filter.and(new QFilter("status", "=", (Object)"1"));
                if (!QueryServiceHelper.exists((String)"bcm_bdmapping", (QFilter[])new QFilter[]{filter})) continue;
                if (invalidNum.length() > 0) {
                    invalidNum.append(",");
                }
                invalidNum.append(obj.getString("number"));
            }
            if (invalidNum.length() > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u5b58\u5728\u5df2\u542f\u7528\u7684\u65b9\u6848\u3002", (String)"SetMappingEditPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]), invalidNum.toString()));
                return;
            }
            Arrays.stream(dys).forEach(c -> c.set("status", (Object)"1"));
            SaveServiceHelper.save((DynamicObject[])dys);
            billList.refresh();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"TemplateListPlugin_48", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
            OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u542f\u7528", "SetMappingEditPlugin_4", "fi-bcm-formplugin", "enable");
            OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u201c%s\u201d\u542f\u7528\u6620\u5c04\u5173\u7cfb\u6210\u529f\u3002", "SetMappingEditPlugin_5", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{numbers}));
            this.writeMultiLangLog(opName, opDes);
        } else if ("bar_disable".equals(key)) {
            if (ids.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MyTemplatePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
                return;
            }
            Arrays.stream(dys).forEach(c -> c.set("status", (Object)"0"));
            SaveServiceHelper.save((DynamicObject[])dys);
            billList.refresh();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"TemplateListPlugin_49", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
            OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u7981\u7528", "SetMappingEditPlugin_6", "fi-bcm-formplugin", "disable");
            OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u201c%s\u201d\u7981\u7528\u6620\u5c04\u5173\u7cfb\u6210\u529f\u3002", "SetMappingEditPlugin_7", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{numbers}));
            this.writeMultiLangLog(opName, opDes);
        }
        GlobalCacheServiceHelper.invalidateCacheByKey((String)"dim-basedata-mapping");
        try {
            EventSubscriptionServiceHelper.setEventEnableAndDisEnableStatus((boolean)true);
        }
        catch (Exception e) {
            log.error("event subscription error :" + e);
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
    }

    @Override
    public void listRowDoubleClick(ListRowClickEvent evt) {
    }

    private void checkBindByModel(Object[] ids, BeforeDoOperationEventArgs args) {
        for (Object id : ids) {
            Pair<Boolean, String> isBind = this.checkBind(id);
            if (!((Boolean)isBind.p1).booleanValue()) continue;
            args.setCancel(true);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u884c\u88ab%1$s\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"SetMappingEditPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]), isBind.p2));
            return;
        }
    }

    private DynamicObject getMappingSetById(long id) {
        QFilter filters = new QFilter("id", "=", (Object)id);
        return BusinessDataServiceHelper.loadSingle((String)"bcm_bdmapping", (String)"entryentity.id, entryentity.cusname, entryentity.config, entryentity.dimension", (QFilter[])filters.toArray());
    }

    private Pair<Boolean, String> checkBind(Object id) {
        DynamicObject mapSet = this.getMappingSetById((Long)id);
        if (mapSet == null || CollectionUtil.isEmpty((Collection)mapSet.getDynamicObjectCollection("entryentity"))) {
            return Pair.onePair((Object)false, (Object)"");
        }
        ArrayList ids = new ArrayList(16);
        mapSet.getDynamicObjectCollection("entryentity").forEach(e -> ids.add(e.getLong("id")));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"scheme.number", (QFilter[])new QFilter("pubmappingid", "in", ids).toArray());
        if (query != null && query.size() > 0) {
            StringBuilder sb = new StringBuilder(16);
            sb.append("[");
            HashSet<String> numberSet = new HashSet<String>(16);
            for (DynamicObject obj : query) {
                if (!numberSet.add(obj.getString("scheme.number"))) continue;
                sb.append(obj.getString("scheme.number"));
                sb.append(";");
            }
            sb.append("]");
            return Pair.onePair((Object)true, (Object)sb.toString());
        }
        DynamicObjectCollection query2 = QueryServiceHelper.query((String)"bcm_dimensionmapnew", (String)"id", (QFilter[])new QFilter("refid", "in", ids).toArray());
        if (query2 != null && query2.size() > 0) {
            String str = ResManager.loadKDString((String)"\u516c\u5f0f\u53d6\u6570-\u7ef4\u5ea6\u6620\u5c04", (String)"DimensionMappingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)true, (Object)str);
        }
        return Pair.onePair((Object)false, (Object)"");
    }

    public void setFilter(SetFilterEvent e) {
        QFilter qFilter = ModelUtil.getModelQfilterByApp(this.getView());
        HashSet modelIds = new HashSet(10);
        modelIds.addAll(BcmFunPermissionHelper.getRoleModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)"bcm_model", (ApplicationTypeEnum)ModelUtil.queryApp(this.getView()), (String)"bcm_dimensionmanager", (String)"47150e89000000ac"));
        modelIds.addAll(MemberPermHelper.getLimitedModelListByUser());
        if (CollectionUtils.isNotEmpty(modelIds)) {
            qFilter.and(new QFilter("model", "in", modelIds));
        } else {
            qFilter.and(QFilter.of((String)"1 != 1", (Object[])new Object[0]));
        }
        e.getQFilters().add(qFilter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Delete && args.getListSelectedData().size() > 0) {
            Object[] ids = args.getListSelectedData().getPrimaryKeyValues();
            QFBuilder qf = new QFBuilder("id", "in", (Object)ids).and("status", "=", (Object)"1");
            DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_bdmapping", (String)"id", (QFilter[])qf.toArray());
            if (dys.size() > 0) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u518d\u6267\u884c\u5220\u9664\u64cd\u4f5c\u3002", (String)"SetMappingListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.checkBindByModel(ids, args);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        boolean havePer = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getServiceAppId(), (String)"bcm_dimensionmanager", (String)"3E7+2X6S09FC");
        if (!havePer) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u65e0\u6b64\u9875\u9762\u64cd\u4f5c\u6743\u9650\u3002", (String)"SetMappingListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_add", "bar_delete", "bar_enable", "bar_disable", "bar_import", "bar_export", "bar_refresh"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        boolean isSuccess;
        super.afterDoOperation(args);
        if (args.getSource() instanceof Delete && (isSuccess = args.getOperationResult().getValidateResult().isSuccess())) {
            String numbers = this.getPageCache().get("numbers");
            OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u5220\u9664", "SetMappingEditPlugin_8", "fi-bcm-formplugin", "delete");
            OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u201c%s\u201d\u5220\u9664\u6620\u5c04\u5173\u7cfb\u6210\u529f\u3002", "SetMappingEditPlugin_9", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{numbers}));
            this.writeMultiLangLog(opName, opDes);
            this.getPageCache().remove("numbers");
            IntegrationUtil.deleteSingMappingByAll();
        }
    }

    @Override
    public void writeLog(String opName, String opDescription) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)opName, (String)opDescription, (Long)this.getModelId(), (String)"bcm_bdmapping");
        logService.addLog(logInfo);
    }

    private String getNumberList(DynamicObject[] dys) {
        StringBuilder stringBuffer = new StringBuilder();
        IntStream.range(0, dys.length).forEach(i -> {
            stringBuffer.append(dys[i].get("number"));
            if (i != dys.length - 1) {
                stringBuffer.append("\u3001");
            }
        });
        return stringBuffer.toString();
    }
}

