/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.upgrade.DimensionTree;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.cslscheme.CslSchemeUtils;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.util.FormUtils;
import kd.fi.bcm.formplugin.util.OrgUtils;
import kd.fi.bcm.formplugin.util.TreeEntryEntityUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import org.apache.commons.lang3.tuple.Pair;

public class SingleMemberF7Plugin
extends AbstractBaseFormPlugin
implements RowClickEventListener,
TreeNodeQueryListener {
    private static final String dimension = "dimensioncombo";
    private static final String isalls = "isalls";
    protected static final String treeentryentity = "treeentryentity";
    private static final String ROWLIST = "rowlist";
    private static final String FOCUS = "focus";

    @Override
    public void initialize() {
        this.addClickListeners("btnok", "imageup", "imagedown");
        TreeEntryGrid treeentry = (TreeEntryGrid)this.getControl(treeentryentity);
        treeentry.addRowClickListener((RowClickEventListener)this);
        treeentry.addCellClickListener((TreeNodeQueryListener)this);
        String addNewShare = (String)this.getView().getFormShowParameter().getCustomParam("addNewShare");
        FieldEdit fieldEdit = (FieldEdit)this.getView().getControl(isalls);
        if (addNewShare == null) {
            fieldEdit.setVisible("", false);
        }
        Search se = (Search)this.getControl("searchap");
        se.addEnterListener(var1 -> {
            if (var1.getText() != null && !"".equals(var1.getText())) {
                List searchFields = var1.getSearchFields();
                this.getPageCache().put("searchFields", ObjectSerialUtil.toByteSerialized((Object)searchFields));
                this.searchMember(searchFields);
            } else {
                this.getPageCache().batchRemove((List)Lists.newArrayList((Object[])new String[]{"search_list", "expandList", ROWLIST}));
                BaseDataProperties properties = this.prepareProperties(true);
                if (!properties.ready) {
                    return;
                }
                this.handleControlState(properties);
                QueryParam queryParam = this.prepareBuildTree(properties);
                this.setCustomerFilter(queryParam);
                this.buildDimEntryTree(queryParam, properties);
            }
        });
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("cslscheme");
        basedataEdit.addBeforeF7SelectListener(this::beforeF7Select);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        String name = evt.getProperty().getName();
        if ("cslscheme".equals(name)) {
            this.setFilterOfCslScheme(evt);
        }
    }

    protected void setFilterOfCslScheme(BeforeF7SelectEvent evt) {
        String entity = (String)this.getFormCustomParam("entity");
        if ("bcm_entitymembertree".equals(entity)) {
            Object disObj = this.getFormCustomParam("disableRateCls");
            boolean disableRateCls = disObj != null && Boolean.parseBoolean(disObj.toString());
            ArrayList<Long> cslIds = new ArrayList<Long>(10);
            QFilter qf = null;
            if (this.isBcm() && this.getView().getParentView() != null) {
                IDataModel model = this.getView().getParentView().getModel();
                if (model.getProperty("scenario") != null && model.getValue("scenario") != null && model.getValue("scenario") instanceof DynamicObject) {
                    long sceneId = ((DynamicObject)model.getValue("scenario")).getLong("id");
                    cslIds.addAll(DimensionServiceHelper.buildCslschemeFilter((long)this.getModelId(), (long)sceneId));
                    if (!disableRateCls) {
                        cslIds.add(CslSchemeServiceHelper.getRateCslScheme((Long)this.getModelId()).getLong("id"));
                    }
                    if (qf == null) {
                        qf = new QFilter("id", "in", cslIds);
                    }
                } else if (disableRateCls) {
                    qf = new QFilter("number", "!=", (Object)"DefaultRateScheme");
                }
            } else if (disableRateCls) {
                qf = new QFilter("number", "!=", (Object)"DefaultRateScheme");
            }
            ListShowParameter lsp = (ListShowParameter)evt.getFormShowParameter();
            if (qf != null) {
                lsp.getListFilterParameter().setFilter(qf);
            }
            lsp.getListFilterParameter().setOrderBy("id");
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BaseDataProperties properties = this.prepareProperties(true);
        if (!properties.ready) {
            return;
        }
        this.handleControlState(properties);
        QueryParam queryParam = this.prepareBuildTree(properties);
        this.setCustomerFilter(queryParam);
        this.buildDimEntryTree(queryParam, properties);
        this.finish(properties);
    }

    private void setCustomerFilter(QueryParam queryParam) {
        String str = (String)this.getView().getFormShowParameter().getCustomParam("customFilter");
        if (str != null) {
            QFilter qFilter = QFilter.fromSerializedString((String)str);
            queryParam.filters = queryParam.filters.and(qFilter);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String isShowCslScheme = (String)this.getFormCustomParam("isShowCslScheme");
        if (kd.bos.util.StringUtils.isNotEmpty((String)isShowCslScheme)) {
            this.getView().setVisible(Boolean.valueOf(isShowCslScheme), new String[]{"cslscheme"});
        }
    }

    private void handleControlState(BaseDataProperties properties) {
        if (!properties.init) {
            return;
        }
        this.setDimensionCombo(LongUtil.toLong((Object)properties.modelId));
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String showDimCombo = (String)showParameter.getCustomParam("showDimCombo");
        if (showDimCombo != null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{dimension});
        }
        this.cslSchemeCtrl();
    }

    private BaseDataProperties prepareProperties(boolean init) {
        BaseDataProperties properties = new BaseDataProperties(init);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String entity = (String)showParameter.getCustomParam("entity");
        if (entity == null) {
            properties.ready = false;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u7ef4\u5ea6\u5b9e\u4f53\u3002", (String)"SingleMemberF7Plugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return properties;
        }
        properties.entity = entity;
        String modelId = showParameter.getCustomParam("modelId").toString();
        properties.modelId = modelId;
        properties.dimId = (Long)showParameter.getCustomParam("dimId");
        this.getPageCache().put("dimension", showParameter.getCustomParam("dimId").toString());
        return properties;
    }

    private QueryParam prepareBuildTree(BaseDataProperties properties) {
        String fieldsMore;
        boolean isDisplayAllFyOrPeriodMemb;
        String isShowExchangeRate;
        String entity;
        boolean isContainShare;
        QueryParam queryParam = new QueryParam();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Long dimId = properties.dimId;
        QFilter dimFilter = new QFilter("model", "=", (Object)this.getModelId());
        if (dimId != null) {
            dimFilter.and("dimension", "=", (Object)dimId);
        }
        if (!(isContainShare = this.getFormCustomParam("isContainShare", true).booleanValue())) {
            dimFilter.and(QFilter.of((String)"storagetype != ?", (Object[])new Object[]{"3"}));
        }
        if ("bcm_accountmembertree".equals(entity = properties.entity) && (isShowExchangeRate = (String)showParameter.getCustomParam("isShowExchangeRate")) != null) {
            dimFilter.and("accounttype", "!=", (Object)"8");
        }
        dimFilter = this.customerFilter(dimFilter);
        if ("bcm_entitymembertree".equals(entity)) {
            this.addCslSchemeFilter(dimFilter);
        }
        if (!(isDisplayAllFyOrPeriodMemb = this.getFormCustomParam("isDisplayAllFyOrPeriodMemb", false).booleanValue())) {
            if ("bcm_fymembertree".equals(entity)) {
                dimFilter.and("number", "!=", (Object)"LastYear").and("number", "!=", (Object)"CurrentYear");
            } else if ("bcm_periodmembertree".equals(entity)) {
                dimFilter.and("number", "!=", (Object)"LastPeriod").and("number", "!=", (Object)"CurrentPeriod").and("number", "!=", (Object)"LastPeriodX");
            }
        }
        boolean isShowCurrencyPC = this.ifShowCurrencyPC();
        if ("bcm_currencymembertree".equals(entity) && !isShowCurrencyPC) {
            dimFilter.and("number", "!=", (Object)"PC");
        }
        String selectFields = "id,number,name,parent,parent.number,level,isleaf,dimension,dseq,longnumber,storagetype,aggoprt,description";
        if ("bcm_entitymembertree".equals(entity)) {
            selectFields = selectFields + ",entitypart.isoffsetentry,copyfrom";
        } else if ("bcm_audittrialmembertree".equals(entity)) {
            ArrayList<Object> idList = new ArrayList<Object>();
            boolean ifFifterDataSource = this.ifFifterDataSource(idList);
            selectFields = selectFields + ",datasource";
            if (ifFifterDataSource) {
                dimFilter.and("id", "in", idList);
            }
        } else if ("bcm_periodmembertree".equals(entity)) {
            selectFields = selectFields + ",useyear,isadjust";
        } else if ("bcm_structofextend".equals(entity)) {
            selectFields = selectFields.replace("aggoprt,", "");
        }
        String isneedSchemeFlag = (String)this.getFormCustomParam("needSchemeFlag");
        if (kd.bos.util.StringUtils.isNotEmpty((String)isneedSchemeFlag) && !Boolean.parseBoolean(isneedSchemeFlag) && "bcm_entitymembertree".equals(entity)) {
            dimFilter.and("cslscheme", "in", (Object)CslSchemeServiceHelper.getCurrUserHavePermCslSchemeIdNotRateScheme((String)String.valueOf(this.getModelId()), (boolean)true));
        }
        selectFields = kd.bos.util.StringUtils.isNotEmpty((String)(fieldsMore = this.getFieldsFromSubClass())) ? selectFields + "," + fieldsMore : selectFields;
        queryParam.selectFields = selectFields;
        queryParam.filters = dimFilter;
        try {
            if (this.isBcm() && "bcm_cslreportprocess".equals(this.getView().getParentView().getEntityId())) {
                this.setCustomerFilter(queryParam);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return queryParam;
    }

    private boolean ifShowCurrencyPC() {
        Map customParamMap;
        Object showCurrencyPC;
        boolean isShowCurrencyPC = false;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        JSONObject customParamJson = (JSONObject)showParameter.getCustomParam("customData");
        if (customParamJson != null && (showCurrencyPC = (customParamMap = customParamJson.getInnerMap()).get("showCurrencyPC")) != null) {
            isShowCurrencyPC = true;
        }
        return isShowCurrencyPC;
    }

    private boolean ifFifterDataSource(List<Object> idList) {
        boolean isFifterDataSource = false;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        JSONObject customParamJson = (JSONObject)showParameter.getCustomParam("customData");
        if (customParamJson != null) {
            Map customParamMap = customParamJson.getInnerMap();
            Object fifterDataSource = customParamMap.get("ifFifterDataSource");
            List fifterId = (List)customParamMap.get("fifterId");
            if (fifterDataSource != null) {
                isFifterDataSource = true;
                idList.addAll(fifterId);
            }
        }
        return isFifterDataSource;
    }

    private void buildDimEntryTree(QueryParam queryParam, BaseDataProperties properties) {
        this.fillEntryData(this.queryDimDoc(queryParam, properties), properties);
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        BaseDataProperties properties = this.prepareProperties(false);
        if (!"bcm_accountmembertree".equals(properties.entity) || kd.bos.util.StringUtils.isNotEmpty((String)this.getPageCache().get("noVirtual"))) {
            return;
        }
        if (this.getModel().getEntryEntity(treeentryentity).size() < evt.getRowKey() + 1) {
            return;
        }
        QueryParam queryParam = this.prepareBuildTree(properties);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(treeentryentity);
        DynamicObject obj = this.getModel().getEntryRowEntity(treeentryentity, evt.getRowKey());
        if (obj == null) {
            return;
        }
        this.cacheExpandList(obj.getLong("id"));
        TreeMultimap<Long, MemberIndex> multiMap = this.getAccountFromCache(queryParam, properties);
        if (multiMap == null || !multiMap.containsKey((Object)obj.getLong("id"))) {
            return;
        }
        DynamicObjectCollection newcoll = this.trans2DynamicObjectCollection((Collection)multiMap.asMap().get(obj.getLong("id")));
        Pair<List<String>, List<String>> propertiyPair = this.getPropertyList(properties);
        TreeEntryEntityUtil.fillTreeEntryEntity4Virture(this.getView(), this.getModel(), newcoll, (List)propertiyPair.getLeft(), (List)propertiyPair.getRight(), evt.getRowKey());
        this.getView().updateView(treeentryentity, evt.getRowKey());
        this.collapseExpNode(evt.getRowKey() + 1, newcoll.size(), treeEntry);
        treeEntry.expandOne(evt.getRowKey());
        treeEntry.selectRows(evt.getRowKey());
        treeEntry.focusCell(evt.getRowKey(), "number");
    }

    private void collapseExpNode(int beginRow, int rowCount, TreeEntryGrid entryGrid) {
        if (rowCount == 0) {
            return;
        }
        int[] rows = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            rows[i] = beginRow + i;
        }
        entryGrid.collapseOne(rows);
    }

    private void cacheExpandList(long ... ids) {
        Set<Long> expandList = this.getCachExpandList();
        long[] lArray = ids;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long id = lArray[i];
            expandList.add(id);
        }
        this.getPageCache().put("expandList", ObjectSerialUtil.toByteSerialized(expandList));
    }

    private Set<Long> getCachExpandList() {
        String serial = this.getPageCache().get("expandList");
        HashSet<Long> expandList = null;
        expandList = kd.bos.util.StringUtils.isNotEmpty((String)serial) ? (HashSet<Long>)ObjectSerialUtil.deSerializedBytes((String)serial) : new HashSet<Long>();
        return expandList;
    }

    private DynamicObjectCollection queryAccountDimDoc(QueryParam queryParam, BaseDataProperties properties) {
        TreeMultimap<Long, MemberIndex> multiMap2 = this.getAccountFromCache(queryParam, properties);
        DynamicObjectCollection newcoll = new DynamicObjectCollection();
        if (multiMap2 != null && multiMap2.size() > 0) {
            Map.Entry entry = multiMap2.asMap().firstEntry();
            boolean isVirtual = true;
            for (MemberIndex val : (Collection)entry.getValue()) {
                if (multiMap2.get((Object)val.getDynObj().getLong("id")) != null && multiMap2.get((Object)val.getDynObj().getLong("id")).size() != 0) continue;
                this.getPageCache().put("noVirtual", "true");
                isVirtual = false;
                break;
            }
            if (!isVirtual) {
                return this.queryDimDoc(queryParam, properties);
            }
            ((Collection)multiMap2.asMap().firstEntry().getValue()).forEach(e -> {
                newcoll.add((Object)((MemberIndex)e).getDynObj());
                if (multiMap2.get((Object)((MemberIndex)e).getDynObj().getLong("id")) != null) {
                    NavigableSet inds = multiMap2.get((Object)((MemberIndex)e).getDynObj().getLong("id"));
                    for (MemberIndex ind : inds) {
                        newcoll.add((Object)ind.getDynObj());
                    }
                }
            });
        }
        if (!CollectionUtils.isEmpty((Collection)newcoll)) {
            this.cacheExpandList(((DynamicObject)newcoll.get(0)).getLong("id"));
        }
        return newcoll;
    }

    private String getCacheKey(QueryParam queryParam, BaseDataProperties properties) {
        return "" + MemberReader.findModelNumberById((Object)this.getModelId()) + queryParam.selectFields + queryParam.filters.toString();
    }

    private TreeMultimap<Long, MemberIndex> getAccountFromCache(QueryParam queryParam, BaseDataProperties p) {
        String cacheKey = this.getCacheKey(queryParam, p);
        this.getPageCache().put(p.entity + "_f7_cache", cacheKey);
        return (TreeMultimap)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)cacheKey, () -> {
            DynamicObjectCollection memberColl = QueryServiceHelper.query((String)this.getClass().getName(), (String)p.entity, (String)queryParam.selectFields, (QFilter[])queryParam.filters.toArray(), (String)"level asc");
            TreeMultimap multiMap = TreeMultimap.create((Comparator)Ordering.natural(), (d1, d2) -> {
                if (((MemberIndex)d1).getDynObj().getInt("dseq") == ((MemberIndex)d2).getDynObj().getInt("dseq")) {
                    return 1;
                }
                return ((MemberIndex)d1).getDynObj().getInt("dseq") - ((MemberIndex)d2).getDynObj().getInt("dseq");
            });
            memberColl.forEach(dyna -> multiMap.put((Object)dyna.getLong("parent"), (Object)new MemberIndex((DynamicObject)dyna)));
            return multiMap;
        });
    }

    private DynamicObjectCollection getAccountDOFromCache(QueryParam queryParam, BaseDataProperties p) {
        String cacheKey = this.getCacheKey(queryParam, p) + "accounttree";
        this.getPageCache().put(p.entity + "_accountf7_cache", cacheKey);
        return (DynamicObjectCollection)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)cacheKey, () -> QueryServiceHelper.query((String)this.getClass().getName(), (String)p.entity, (String)queryParam.selectFields, (QFilter[])queryParam.filters.toArray(), (String)"level,dseq"));
    }

    private DynamicObjectCollection queryDimDoc(QueryParam queryParam, BaseDataProperties properties) {
        Map customData;
        DynamicObjectCollection members;
        if ("bcm_accountmembertree".equals(properties.entity) && kd.bos.util.StringUtils.isEmpty((String)this.getPageCache().get("noVirtual"))) {
            return this.queryAccountDimDoc(queryParam, properties);
        }
        String entity = properties.entity;
        if ("bcm_periodmembertree".equals(entity)) {
            members = QueryServiceHelper.query((String)this.getClass().getName(), (String)entity, (String)queryParam.selectFields, (QFilter[])queryParam.filters.toArray(), (String)"level,number,dseq");
            this.checkSPConfig(members);
            this.useYearFilter(members, this.getYear());
        } else {
            members = QueryServiceHelper.query((String)this.getClass().getName(), (String)entity, (String)queryParam.selectFields, (QFilter[])queryParam.filters.toArray(), (String)"level,dseq");
        }
        if (entity.equals("bcm_entitymembertree") && (customData = (Map)this.getFormCustomParam("customData")) != null && customData.get("yearNum") != null && customData.get("periodId") != null) {
            long sceneId = this.getScenarioId();
            FilterOrgStructParam param = new FilterOrgStructParam(this.getModelId(), sceneId, customData.get("yearNum").toString(), LongUtil.toLong(customData.get("periodId")).longValue());
            EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)param, (List)members);
            OrgServiceHelper.dealNoMergeOrgList((DynamicObjectCollection)members, (Long)this.getModelId(), (Long)sceneId, (Long)((Long)customData.get("yearId")), (Long)LongUtil.toLong(customData.get("periodId")));
        }
        if ("bcm_accountmembertree".equals(properties.entity)) {
            Set ids = members.stream().map(m -> m.getLong("id")).collect(Collectors.toSet());
            this.getPageCache().put("account_ids_cache", ObjectSerialUtil.toByteSerialized(ids));
        }
        return members;
    }

    @Override
    public long getScenarioId() {
        Long scenarioId = super.getScenarioId();
        if (scenarioId == 0L) {
            Map customData = (Map)this.getFormCustomParam("customData");
            scenarioId = customData.getOrDefault("scenarioId", 0L);
        }
        if (scenarioId == 0L && this.isBcm() && this.getView().getParentView() != null) {
            scenarioId = OrgUtils.getF7Id(this.getView().getParentView().getModel(), "scenario");
        }
        return scenarioId == null ? 0L : scenarioId;
    }

    private void fillEntryData(DynamicObjectCollection members, BaseDataProperties properties) {
        this.addEntryData(members, properties);
        this.handleEntryState(properties);
    }

    private Pair<List<String>, List<String>> getPropertyList(BaseDataProperties properties) {
        ArrayList propertyList = Lists.newArrayList((Object[])new String[]{"number", "name", "memberid", "isleaf", "dimension", "aggoprt", "description"});
        ArrayList dynamicObjecPpropertyList = Lists.newArrayList((Object[])new String[]{"number", "name", "id", "isleaf", "dimension", "aggoprt", "description"});
        if ("bcm_singlemember_custom".equals(this.getView().getFormShowParameter().getFormId())) {
            propertyList.add("storagetype");
            dynamicObjecPpropertyList.add("storagetype");
        }
        if ("bcm_singlemember_rate".equals(this.getView().getFormShowParameter().getFormId()) && "bcm_audittrialmembertree".equals(properties.entity)) {
            propertyList.add("datasource");
            dynamicObjecPpropertyList.add("datasource");
        }
        if ("bcm_structofextend".equals(properties.entity)) {
            propertyList.remove("aggoprt");
            dynamicObjecPpropertyList.remove("aggoprt");
        }
        this.settingFromSubClass(propertyList, dynamicObjecPpropertyList);
        return Pair.of((Object)propertyList, (Object)dynamicObjecPpropertyList);
    }

    private void addEntryData(DynamicObjectCollection members, BaseDataProperties properties) {
        if (members != null && members.size() > 0) {
            this.getModel().deleteEntryData(treeentryentity);
            String entity = properties.entity;
            long modelId = LongUtil.toLong((Object)properties.modelId);
            long dimId = properties.dimId;
            boolean noRoot = false;
            Pair<List<String>, List<String>> propertyList = this.getPropertyList(properties);
            PermissionService service = PermissionServiceImpl.getInstance((Long)modelId);
            PairList mergeList = new PairList();
            if ("bcm_entitymembertree".equals(entity) && !ObjectUtils.isEmpty((Object)this.getValue("cslscheme"))) {
                Map customData;
                if (DimTypesEnum.ENTITY.getNumber().equals(((DynamicObject)members.get(0)).getString("number"))) {
                    noRoot = true;
                }
                if ((customData = (Map)this.getFormCustomParam("customData")) != null && customData.containsKey("isApplyCM030") && !ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM030")) {
                    Long scenarioId = LongUtil.toLong(customData.get("scenarioId"));
                    Long yearId = LongUtil.toLong(customData.get("yearId"));
                    Long periodId = LongUtil.toLong(customData.get("periodId"));
                    if (scenarioId != 0L && yearId != 0L && periodId != 0L) {
                        QFilter filter = new QFilter("model", "=", (Object)modelId);
                        filter.and(new QFilter("scenario", "=", (Object)scenarioId));
                        filter.and(new QFilter("year", "=", (Object)yearId));
                        filter.and(new QFilter("period", "=", (Object)periodId));
                        filter.and(new QFilter("ismerge", "=", (Object)false));
                        DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_mergestructinfo", (String)"orgpnumber,orgnumber", (QFilter[])filter.toArray());
                        docs.forEach(d -> mergeList.addPair((Object)d.getString("orgpnumber"), (Object)d.getString("orgnumber")));
                    }
                }
            }
            if ("bcm_accountmembertree".equals(properties.entity) && kd.bos.util.StringUtils.isEmpty((String)this.getPageCache().get("noVirtual"))) {
                TreeEntryEntityUtil.fillTreeEntryEntity4Virture(this.getView(), this.getModel(), members, (List)propertyList.getLeft(), (List)propertyList.getRight(), 0);
            } else {
                boolean noPermission = this.getView().getFormShowParameter().getCustomParam("isNotPermFilterF7") != null;
                List filterIds = (List)this.getFormCustomParam("filter");
                boolean isAdmin = service.isAdmin();
                if ((isAdmin || noPermission || entity.startsWith("epm_")) && CollectionUtils.isEmpty((Collection)filterIds)) {
                    TreeEntryEntityUtil.fillTreeEntryEntityUserSeq(this.getModel(), members, (List<String>)((List)propertyList.getLeft()), (List)propertyList.getRight(), noRoot, (PairList<String, String>)mergeList);
                } else {
                    Map relationMap = MemberPermHelper.BuildPCRelation((DynamicObjectCollection)members);
                    Iterator iterator = members.iterator();
                    while (iterator.hasNext()) {
                        DynamicObject member = (DynamicObject)iterator.next();
                        Long id = member.getLong("id");
                        if (service.memberCanShow(Long.valueOf(dimId), id, relationMap) && (CollectionUtils.isEmpty((Collection)filterIds) || filterIds.contains(id))) continue;
                        iterator.remove();
                    }
                    TreeEntryEntityUtil.fillTreeEntryEntityUserSeq(this.getModel(), members, (List<String>)((List)propertyList.getLeft()), (List)propertyList.getRight(), noRoot, (PairList<String, String>)mergeList);
                }
            }
            List vars = (List)this.getFormCustomParam("isShowSystemVariables");
            if (!CollectionUtils.isEmpty((Collection)vars)) {
                Map dimVars = MemberReader.getDimVariables((String)properties.entity);
                dimVars.values().forEach(dim -> {
                    if (vars.contains(dim.getNumber())) {
                        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(treeentryentity, this.getModel().createNewEntryRow(treeentryentity));
                        entryRowEntity.set("id", (Object)dim.getId());
                        entryRowEntity.set("memberid", (Object)dim.getId());
                        entryRowEntity.set("number", (Object)dim.getNumber());
                        entryRowEntity.set("name", (Object)dim.getName());
                        entryRowEntity.set("isleaf", (Object)1);
                    }
                });
            }
            this.getView().updateView(treeentryentity);
        }
    }

    private void handleEntryState(BaseDataProperties properties) {
        int count;
        String entity = properties.entity;
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(treeentryentity);
        treeEntryGrid.setCollapse(false);
        if ((entity.equals("bcm_entitymembertree") || entity.equals("bcm_accountmembertree") || entity.equals("bcm_changetypemembertree") || entity.equals("bcm_userdefinedmembertree")) && (count = this.getModel().getEntryRowCount(treeentryentity)) > 1) {
            int[] col = this.getModel().getEntryNextRows(treeentryentity, 1, true);
            IClientViewProxy po = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            po.invokeControlMethod(treeentryentity, "collapseAllNode", new Object[]{col});
        }
    }

    private void finish(BaseDataProperties properties) {
        if (!properties.init) {
            return;
        }
        Object obj = this.getFormCustomParam("isFromExcel");
        if (obj != null) {
            this.getPageCache().put("isFromExcel", obj.toString());
        }
    }

    private void cslSchemeCtrl() {
        Map customData;
        String entity = (String)this.getFormCustomParam("entity");
        boolean showCslScheme = (this.isCM() || this.isRPT() || this.isFIDM() || this.isFAR()) && "bcm_entitymembertree".equals(entity);
        String isShowCslScheme = (String)this.getFormCustomParam("isShowCslScheme");
        if (kd.bos.util.StringUtils.isNotEmpty((String)isShowCslScheme)) {
            showCslScheme = showCslScheme && Boolean.parseBoolean(isShowCslScheme);
        }
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(showCslScheme), new String[]{"cslscheme"});
        if (showCslScheme) {
            this.setCslSchemeValue();
        }
        if ((customData = (Map)this.getFormCustomParam("customData")) != null && customData.get("enableScheme") != null && !((Boolean)customData.get("enableScheme")).booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"cslscheme"});
        }
    }

    private void setCslSchemeValue() {
        long modelId = this.getModelId();
        IDataModel model = this.getModel();
        Long schemeId = (Long)this.getFormCustomParam("cslscheme");
        if (schemeId == null) {
            CslSchemeUtils.setDefaultCslSchemeValue(String.valueOf(modelId), false, this.getView());
            this.getView().updateView("cslscheme");
        } else {
            model.setValue("cslscheme", (Object)schemeId);
            if (this.isGuideMenu()) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"cslscheme"});
            }
        }
        if (this.getFormCustomParam("cslschemeisselect") != null && ((Boolean)this.getFormCustomParam("cslschemeisselect")).booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"cslscheme"});
        }
    }

    @Override
    protected boolean isGuideMenu() {
        return this.getView() != null && GuidePageUtils.isFromGuide(this.getView());
    }

    private void addCslSchemeFilter(QFilter dimFilter) {
        String isneedSchemeFlag;
        boolean needSchemeFlag;
        Map customData = (Map)this.getFormCustomParam("customData");
        CslSchemeServiceHelper.QueryOrgParam param = CslSchemeServiceHelper.QueryOrgParam.of((String)"model", (Object)String.valueOf(this.getModelId()));
        boolean bl = needSchemeFlag = this.isCM() || this.isRPT();
        if (this.isRPT() && (customData == null || customData.get("sourcePage") != null)) {
            needSchemeFlag = false;
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)(isneedSchemeFlag = (String)this.getFormCustomParam("needSchemeFlag")))) {
            needSchemeFlag = needSchemeFlag && Boolean.parseBoolean(isneedSchemeFlag);
        }
        param.setNeedSchemeFilter(needSchemeFlag);
        DynamicObject schemeDyn = (DynamicObject)this.getModel().getValue("cslscheme");
        if (schemeDyn == null) {
            if (this.isBcm() && this.getView().getParentView() != null) {
                IDataModel model = this.getView().getParentView().getModel();
                if (model.getProperty("scenario") != null && model.getValue("scenario") != null && model.getValue("scenario") instanceof DynamicObject) {
                    long sceneId = ((DynamicObject)model.getValue("scenario")).getLong("id");
                    param.setCslSchemeSet(new HashSet(DimensionServiceHelper.buildCslschemeFilter((long)this.getModelId(), (long)sceneId)));
                }
            } else {
                Set cslSet = CslSchemeServiceHelper.getCurrUserHavePermCslSchemeIdNotRateScheme((String)String.valueOf(this.getModelId()), (boolean)false);
                param.setCslSchemeSet(cslSet);
            }
        }
        if (schemeDyn != null) {
            param.setCslScheme(Pair.of((Object)schemeDyn.getLong("id"), (Object)schemeDyn.getString("number")));
        }
        if (customData != null && customData.get("yearNum") != null && customData.get("periodId") != null) {
            param.setYearNum(String.valueOf(customData.get("yearNum")));
            param.setPeriodId(String.valueOf(customData.get("periodId")));
        }
        dimFilter.and(CslSchemeServiceHelper.genQueryFilter((CslSchemeServiceHelper.QueryOrgParam)param));
    }

    @SDKMark
    protected QFilter customerFilter(QFilter dimFilter) {
        return dimFilter;
    }

    private void checkSPConfig(DynamicObjectCollection memberColls) {
        Object periodFilterObj = this.getView().getFormShowParameter().getCustomParam("periodFilter");
        if (periodFilterObj != null) {
            QFilter periodFilter = (QFilter)ObjectSerialUtil.deSerializedBytes((String)periodFilterObj.toString());
            DynamicObjectCollection realcol = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"id, longnumber", (QFilter[])new QFilter[]{periodFilter});
            memberColls.removeIf(meb -> {
                for (DynamicObject real : realcol) {
                    if (real.getLong("id") != meb.getLong("id") && !real.getString("longnumber").contains(meb.getString("longnumber"))) continue;
                    return false;
                }
                return true;
            });
        }
    }

    private void setDimensionCombo(Long modelId) {
        ComboEdit dimensioncombo = (ComboEdit)this.getView().getControl(dimension);
        List<String[]> dimensionlist = this.getDimensionComData(modelId);
        FormUtils.customDynamicEnum(dimensionlist, dimensioncombo);
        int f7Value = (Integer)this.getView().getFormShowParameter().getCustomParam("f7Value");
        if (f7Value == -1) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{dimension});
        } else {
            this.getModel().setValue(dimension, (Object)f7Value);
        }
    }

    private List<String[]> getDimensionComData(Long modelId) {
        String algoKey = this.getClass().getName();
        String selectFields = "name,dseq,membermodel,membertable";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{fmodelid};
        DynamicObjectCollection colls = QueryServiceHelper.query((String)algoKey, (String)"bcm_dimension", (String)selectFields, (QFilter[])filters, (String)"dseq");
        ArrayList<String[]> listDimension = new ArrayList<String[]>();
        if (colls != null && colls.size() > 0) {
            for (DynamicObject task : colls) {
                String[] dimensionMap = new String[]{task.getString("name"), task.getString("dseq"), task.getString("membermodel"), task.getString("membertable")};
                listDimension.add(dimensionMap);
            }
        }
        return listDimension;
    }

    protected void exitAndReturn(IDataModel iDataModel) {
        int row = iDataModel.getEntryCurrentRowIndex(treeentryentity);
        DynamicObject selectedRow = iDataModel.getEntryRowEntity(treeentryentity, row);
        if (selectedRow == null) {
            this.getView().close();
            return;
        }
        if (!SystemVarsEnum.isDimVars((String)selectedRow.getString("id"))) {
            if (this.getControl("scope") != null) {
                selectedRow.set("scopeval", this.getModel().getValue("scope"));
            }
            boolean isSelectMemberCheckPerm = this.getFormCustomParam("selectMemberCheckPerm", true);
            PermissionService service = PermissionServiceImpl.getInstance((Long)this.getModelId());
            long dimensionId = LongUtil.toLong((Object)this.getPageCache().get("dimension"));
            if (!service.isAdmin() && isSelectMemberCheckPerm && service.hasNoPerm(Long.valueOf(dimensionId), Long.valueOf(selectedRow.getLong("id")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u6210\u5458\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SingleMemberF7Plugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            Map customParams = (Map)this.getView().getFormShowParameter().getCustomParam("customData");
            if (customParams != null && customParams.get("fromPage") != null && "rptAdjust".equals(customParams.get("fromPage").toString()) && !service.isAdmin() && service.hasReadPerm(Long.valueOf(dimensionId), Long.valueOf(selectedRow.getLong("id")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u6210\u5458\u7684\u8bfb\u5199\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SingleMemberF7Plugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        this.getView().setReturnData((Object)selectedRow);
        if (this.isFromExcel()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", String.valueOf(selectedRow.get("id")));
            map.put("memberid", String.valueOf(selectedRow.get("memberid")));
            map.put("pid", String.valueOf(selectedRow.get("pid")));
            map.put("name", String.valueOf(selectedRow.get("name")));
            map.put("number", String.valueOf(selectedRow.get("number")));
            this.getView().setClientReturnData(map);
        }
        this.getView().returnDataToParent((Object)selectedRow);
        this.getView().close();
    }

    private boolean isFromExcel() {
        String isFromExcel = this.getPageCache().get("isFromExcel");
        return isFromExcel != null;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        String key = Control2.getKey();
        if (key.equals("btnok")) {
            Object isMul = this.getView().getFormShowParameter().getCustomParam("isMul");
            if (isMul != null && Boolean.parseBoolean(isMul.toString())) {
                this.exitAndReturnMul(this.getModel());
            } else {
                this.exitAndReturn(this.getModel());
            }
        }
        if ("imageup".equals(key) || "imagedown".equals(key)) {
            BaseDataProperties properties = this.prepareProperties(false);
            if ("bcm_accountmembertree".equals(properties.entity)) {
                this.searchPreOrNext4Account(key, properties);
                return;
            }
            String serial = this.getPageCache().get(ROWLIST);
            if (kd.bos.util.StringUtils.isEmpty((String)serial)) {
                String searchSerial = this.getPageCache().get("searchFields");
                if (!kd.bos.util.StringUtils.isEmpty((String)searchSerial)) {
                    List searchFields = (List)ObjectSerialUtil.deSerializedBytes((String)searchSerial);
                    Search search = (Search)this.getView().getControl("searchap");
                    search.search(searchFields);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"SingleMemberF7Plugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                return;
            }
            List list = (List)ObjectSerialUtil.deSerializedBytes((String)serial);
            if (list == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"SingleMemberF7Plugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            serial = this.getPageCache().get(FOCUS);
            int focusrow = (Integer)ObjectSerialUtil.deSerializedBytes((String)serial);
            if ("imageup".equals(key)) {
                if ((focusrow = ((Integer)list.get(list.indexOf(focusrow) - 1)).intValue()) == -1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"SingleMemberF7Plugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else if ("imagedown".equals(key) && (focusrow = ((Integer)list.get(list.indexOf(focusrow) + 1)).intValue()) == -1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"SingleMemberF7Plugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put(FOCUS, ObjectSerialUtil.toByteSerialized((Object)focusrow));
            int[] eids = TreeEntryEntityUtil.focus(this.getModel(), focusrow);
            TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(treeentryentity);
            treeEntry.expandOne(eids);
            treeEntry.selectRows(focusrow);
        }
    }

    private void searchPreOrNext4Account(String key, BaseDataProperties properties) {
        String serial = this.getPageCache().get("search_list");
        if (kd.bos.util.StringUtils.isEmpty((String)serial)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"SingleMemberF7Plugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Pair searchList = (Pair)ObjectSerialUtil.deSerializedBytes((String)serial);
        QueryParam queryParam = this.prepareBuildTree(properties);
        if ("imageup".equals(key)) {
            if (((List)searchList.getValue()).size() <= 1 || (Integer)searchList.getKey() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"SingleMemberF7Plugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.findOrLoadRow((Pair<Long, Long>)((Pair)((List)searchList.getValue()).get((Integer)searchList.getKey() - 1)), properties, queryParam);
            this.getPageCache().put("search_list", ObjectSerialUtil.toByteSerialized((Object)Pair.of((Object)((Integer)searchList.getKey() - 1), (Object)searchList.getValue())));
        } else if ("imagedown".equals(key)) {
            if (((List)searchList.getValue()).size() <= 1 || ((List)searchList.getValue()).size() - 1 == (Integer)searchList.getKey()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"SingleMemberF7Plugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.findOrLoadRow((Pair<Long, Long>)((Pair)((List)searchList.getValue()).get((Integer)searchList.getKey() + 1)), properties, queryParam);
            this.getPageCache().put("search_list", ObjectSerialUtil.toByteSerialized((Object)Pair.of((Object)((Integer)searchList.getKey() + 1), (Object)searchList.getValue())));
        }
    }

    protected void exitAndReturnMul(IDataModel model) {
        int i;
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(treeentryentity);
        int[] rows = treeEntryGrid.getSelectRows();
        DynamicObjectCollection c = new DynamicObjectCollection();
        DynamicObject[] selectRows = new DynamicObject[rows.length];
        for (i = 0; i < rows.length; ++i) {
            selectRows[i] = model.getEntryRowEntity(treeentryentity, rows[i]);
            c.add((Object)model.getEntryRowEntity(treeentryentity, i));
        }
        for (i = 0; i < rows.length; ++i) {
            DynamicObject selectedRow = selectRows[i];
            if (selectedRow == null) {
                this.getView().close();
                return;
            }
            if (this.getControl("scope") != null) {
                selectedRow.set("scopeval", this.getModel().getValue("scope"));
            }
            PermissionService service = PermissionServiceImpl.getInstance((Long)this.getModelId());
            long dimensionId = LongUtil.toLong((Object)this.getPageCache().get("dimension"));
            if (service.isAdmin() || "bcm_accountmembertree".equals(this.getFormCustomParam("entity")) || !service.hasNoPerm(Long.valueOf(dimensionId), Long.valueOf(selectedRow.getLong("id")))) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u6210\u5458\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SingleMemberF7Plugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Object isalls = this.getModel().getValue(isalls);
        HashMap resultMap = Maps.newHashMap();
        resultMap.put(isalls, isalls);
        resultMap.put("selectRows", selectRows);
        this.getView().setReturnData((Object)resultMap);
        this.getView().returnDataToParent((Object)resultMap);
        this.getView().close();
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        super.entryRowDoubleClick(evt);
        Object isMul = this.getView().getFormShowParameter().getCustomParam("isMul");
        if (isMul != null && Boolean.parseBoolean(isMul.toString())) {
            this.exitAndReturnMul(this.getModel());
        } else {
            this.exitAndReturn(this.getModel());
        }
    }

    private List<Pair<Long, Long>> findIndexListDeep(DimensionTree<String, DynamicObject> dimensionTreeRoot, List<Map<String, Object>> searchFields) {
        ArrayList<Pair<Long, Long>> findList = new ArrayList<Pair<Long, Long>>(16);
        ArrayList<Pair<Long, Long>> fullMatch = new ArrayList<Pair<Long, Long>>(16);
        this.addThisOneOrNot(dimensionTreeRoot, searchFields, fullMatch, findList);
        this.preOrderTravel(dimensionTreeRoot, searchFields, fullMatch, findList);
        if (fullMatch.size() > 0) {
            findList.addAll(0, fullMatch);
        }
        return findList;
    }

    private void preOrderTravel(DimensionTree<String, DynamicObject> tempTreeNode, List<Map<String, Object>> searchFields, List<Pair<Long, Long>> fullMatch, List<Pair<Long, Long>> findList) {
        if (tempTreeNode.getParent() == null) {
            this.addThisOneOrNot(tempTreeNode, searchFields, fullMatch, findList);
        }
        for (DimensionTree child : tempTreeNode.getChildren()) {
            this.addThisOneOrNot((DimensionTree<String, DynamicObject>)child, searchFields, fullMatch, findList);
        }
        for (DimensionTree child : tempTreeNode.getChildren()) {
            this.preOrderTravel((DimensionTree<String, DynamicObject>)child, searchFields, fullMatch, findList);
        }
    }

    private void addThisOneOrNot(DimensionTree<String, DynamicObject> tempTreeNode, List<Map<String, Object>> searchFields, List<Pair<Long, Long>> fullMatch, List<Pair<Long, Long>> findList) {
        String name = ((DynamicObject)tempTreeNode.getData()).getString("name").toLowerCase();
        String number = ((DynamicObject)tempTreeNode.getData()).getString("number").toLowerCase();
        Long memberId = ((DynamicObject)tempTreeNode.getData()).getLong("id");
        Long parentId = ((DynamicObject)tempTreeNode.getData()).getLong("parent");
        for (Map<String, Object> searchField : searchFields) {
            Set<String> texts = ((List)searchField.get("value")).stream().map(text -> text.toLowerCase()).collect(Collectors.toSet());
            List fieldNames = (List)searchField.get("fieldName");
            if (fieldNames.size() == 1) {
                if ("number".equals(fieldNames.get(0))) {
                    if (this.strEqualsTexts(number, texts)) {
                        fullMatch.add((Pair<Long, Long>)Pair.of((Object)memberId, (Object)parentId));
                        continue;
                    }
                    if (!this.strContainTexts(number, texts)) continue;
                    findList.add((Pair<Long, Long>)Pair.of((Object)memberId, (Object)parentId));
                    continue;
                }
                if (!"name".equals(fieldNames.get(0))) continue;
                if (this.strEqualsTexts(name, texts)) {
                    fullMatch.add((Pair<Long, Long>)Pair.of((Object)memberId, (Object)parentId));
                    continue;
                }
                if (!this.strContainTexts(name, texts)) continue;
                findList.add((Pair<Long, Long>)Pair.of((Object)memberId, (Object)parentId));
                continue;
            }
            if (fieldNames.size() != 2) continue;
            if (this.strEqualsTexts(number, texts) || this.strEqualsTexts(name, texts)) {
                fullMatch.add((Pair<Long, Long>)Pair.of((Object)memberId, (Object)parentId));
                continue;
            }
            if (!this.strContainTexts(number, texts) && !this.strContainTexts(name, texts)) continue;
            findList.add((Pair<Long, Long>)Pair.of((Object)memberId, (Object)parentId));
        }
    }

    private void searchMember(List<Map<String, Object>> searchFields) {
        BaseDataProperties properties = this.prepareProperties(false);
        if ("bcm_accountmembertree".equals(properties.entity)) {
            this.search4Account(searchFields);
            return;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(10);
        list.add(-1);
        QueryParam queryParam = this.prepareBuildTree(properties);
        DynamicObjectCollection dynamicObjects = this.queryDimDoc(queryParam, properties);
        if (dynamicObjects.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"SingleMemberF7Plugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DimensionTree searchTree = DimensionTree.createTreeFromDyn((DynamicObject[])((DynamicObject[])dynamicObjects.toArray((Object[])new DynamicObject[0])));
        if (searchTree == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"SingleMemberF7Plugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Pair<Long, Long>> findList = this.findIndexListDeep((DimensionTree<String, DynamicObject>)searchTree, searchFields);
        DynamicObjectCollection collection = this.getModel().getEntryEntity(treeentryentity);
        findList.forEach(find -> {
            DynamicObject dynamicObject = collection.stream().filter(c -> ((Long)find.getLeft()).longValue() == c.getLong("id")).findFirst().orElse(null);
            if (dynamicObject != null && kd.bos.util.StringUtils.isNotEmpty((String)dynamicObject.getString("seq"))) {
                String seq = dynamicObject.getString("seq");
                list.add(Integer.parseInt(seq) - 1);
            }
        });
        list.add(-1);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(treeentryentity);
        if (list.size() > 2) {
            this.getPageCache().put(ROWLIST, ObjectSerialUtil.toByteSerialized(list));
            int focusRow = (Integer)list.get(1);
            this.getPageCache().put(FOCUS, ObjectSerialUtil.toByteSerialized((Object)focusRow));
            int[] ids = TreeEntryEntityUtil.focus(this.getModel(), focusRow);
            treeEntry.collapse(0);
            treeEntry.expandOne(ids);
            treeEntry.selectRows(focusRow);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"SingleMemberF7Plugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void search4Account(List<Map<String, Object>> searchFields) {
        BaseDataProperties properties = this.prepareProperties(false);
        QueryParam queryParam = this.prepareBuildTree(properties);
        DynamicObjectCollection dynamicObjects = this.getAccountDOFromCache(queryParam, properties);
        DimensionTree searchTree = DimensionTree.createTreeFromDyn((DynamicObject[])((DynamicObject[])dynamicObjects.toArray((Object[])new DynamicObject[0])));
        if (searchTree == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"SingleMemberF7Plugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Pair<Long, Long>> findList = this.findIndexListDeep((DimensionTree<String, DynamicObject>)searchTree, searchFields);
        String serial = this.getPageCache().get("account_ids_cache");
        if (kd.bos.util.StringUtils.isNotEmpty((String)serial)) {
            Set ids = (Set)ObjectSerialUtil.deSerializedBytes((String)serial);
            findList.removeIf(f -> !ids.contains(f.getLeft()));
        }
        if (findList.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"SingleMemberF7Plugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put("search_list", ObjectSerialUtil.toByteSerialized((Object)Pair.of((Object)0, findList)));
        this.findOrLoadRow(findList.get(0), properties, queryParam);
    }

    private boolean strContainTexts(String str, Set<String> texts) {
        boolean flag = false;
        for (String text : texts) {
            if (!str.toLowerCase(Locale.ENGLISH).contains(text)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private boolean strEqualsTexts(String str, Set<String> texts) {
        boolean flag = false;
        for (String text : texts) {
            if (!str.toLowerCase(Locale.ENGLISH).equals(text)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private void findOrLoadRow(Pair<Long, Long> pair, BaseDataProperties properties, QueryParam queryParam) {
        TreeMultimap<Long, MemberIndex> multiMap = this.getAccountFromCache(queryParam, properties);
        Set<Long> expandList = this.getCachExpandList();
        Stack<Object> expendPath = new Stack<Object>();
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(treeentryentity);
        if (!expandList.contains(pair.getValue())) {
            expendPath.push(pair.getValue());
            long pid = (Long)pair.getValue();
            while (true) {
                IDNumberTreeNode pnode;
                long l = pid = (pnode = MemberReader.findMemberById((long)this.getModelId(), (String)properties.entity, (Long)pid).getParent()) == null ? 0L : pnode.getId();
                if (expandList.contains(pid) || pid == 0L) break;
                expendPath.push(pid);
            }
            this.cacheExpandList(expendPath.stream().mapToLong(Long::valueOf).toArray());
            Pair<List<String>, List<String>> propertiyPair = this.getPropertyList(properties);
            ArrayList<Integer> expandRows = new ArrayList<Integer>();
            while (!expendPath.isEmpty()) {
                pid = (Long)expendPath.pop();
                int insertIndex = this.findEntryIndex(pid);
                if (insertIndex <= -1) continue;
                TreeEntryEntityUtil.fillTreeEntryEntity4Virture(this.getView(), this.getModel(), this.trans2DynamicObjectCollection((Collection)multiMap.asMap().get(pid)), (List)propertiyPair.getLeft(), (List)propertiyPair.getRight(), insertIndex);
                expandRows.add(insertIndex);
            }
            treeEntry.expandOne(expandRows.stream().mapToInt(Integer::valueOf).toArray());
            this.getView().updateView(treeentryentity);
        } else {
            int[] eids = TreeEntryEntityUtil.focus(this.getModel(), this.findEntryIndex((Long)pair.getKey()));
            treeEntry.expandOne(eids);
        }
        treeEntry.selectRows(this.findEntryIndex((Long)pair.getKey()));
    }

    private DynamicObjectCollection trans2DynamicObjectCollection(Collection<MemberIndex> coll) {
        DynamicObjectCollection colls = new DynamicObjectCollection();
        if (coll != null) {
            coll.forEach(e -> colls.add((Object)((MemberIndex)e).getDynObj()));
        }
        return colls;
    }

    private int findEntryIndex(Long findId) {
        int i = 0;
        DynamicObjectCollection entries = this.getModel().getEntryEntity(treeentryentity);
        for (DynamicObject o : entries) {
            if (findId.longValue() == o.getLong("id")) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "cslscheme": {
                this.buildDimEntryTree();
            }
        }
    }

    private void buildDimEntryTree() {
        this.getPageCache().remove(ROWLIST);
        BaseDataProperties properties = this.prepareProperties(false);
        QueryParam queryParam = this.prepareBuildTree(properties);
        this.buildDimEntryTree(queryParam, properties);
        DynamicObject schemeDyn = (DynamicObject)this.getModel().getValue("cslscheme");
        if (schemeDyn != null) {
            UserSelectModel userSelectModel = new UserSelectModel();
            userSelectModel.setModel(properties.modelId);
            userSelectModel.setApplication(ApplicationTypeEnum.CM);
            userSelectModel.setOnlyModel(false);
            userSelectModel.setModifier(RequestContext.get().getUserId());
            userSelectModel.setCslScheme(schemeDyn.getString("id"));
            UserSelectUtil.savetUserSelect(userSelectModel);
        }
    }

    protected String getFieldsFromSubClass() {
        return "";
    }

    protected void settingFromSubClass(List<String> propertyList, List<String> dynamicObjectPropertyList) {
    }

    private void useYearFilter(DynamicObjectCollection memberCells, String year) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)year)) {
            memberCells.removeIf(m -> m.getBoolean("isadjust") && !m.getString("useyear").contains(year));
        }
    }

    private String getYear() {
        DynamicObject yearObj = null;
        if (this.getView().getModel().getDataEntityType().getProperties().containsKey((Object)"year")) {
            yearObj = (DynamicObject)this.getView().getModel().getValue("year");
        } else if (this.isBcm() && this.getView().getParentView().getModel().getDataEntityType().getProperties().containsKey((Object)"year")) {
            yearObj = (DynamicObject)this.getView().getParentView().getModel().getValue("year");
        }
        return Objects.isNull(yearObj) ? null : yearObj.getString("number");
    }

    public boolean isBcm() {
        String entityNumber = this.getView().getFormShowParameter().getParentFormId();
        return StringUtils.isNotEmpty((CharSequence)entityNumber) && (entityNumber.startsWith("bcm_") || entityNumber.startsWith("di_"));
    }

    private static class MemberIndex {
        private String number;
        private String name;
        private DynamicObject dynObj;

        private MemberIndex(DynamicObject dynObj) {
            this.number = dynObj.getString("number").toLowerCase(Locale.ENGLISH);
            this.name = dynObj.getString("name").toLowerCase(Locale.ENGLISH);
            this.dynObj = dynObj;
        }

        private String getNumber() {
            return this.number;
        }

        private String getName() {
            return this.name;
        }

        private DynamicObject getDynObj() {
            return this.dynObj;
        }
    }

    private static class BaseDataProperties {
        private String modelId;
        private Long dimId;
        private String entity;
        private boolean ready = true;
        private boolean init;

        public BaseDataProperties(boolean init) {
            this.init = init;
        }
    }

    private static class QueryParam {
        private String selectFields;
        private QFilter filters;

        private QueryParam() {
        }
    }
}

