/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.entity.EntityTreeUtil;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.dimension.factory.DimensionFactory;

public class DimemberBaseAction {
    protected String id;
    protected String dimensionName;
    protected String dimensionNumber;
    protected String actionId;
    protected String entityid;
    protected String memberName;
    protected String modelid;
    protected String AppId;
    protected Set<String> noCutAccountMember = new HashSet<String>(Arrays.asList("Account", "RPTItem", "ExchangeRate", "BOYRate", "BOYAverageRate", "BOYUserdefinedRate", "ClosingRate", "AverageRate", "UserdefinedRate"));
    protected String modelNum;
    protected Long schemeId = 0L;
    private static String[] canaddsubStr = new String[]{"FYIncrease", "FYDecrease", "CPIncrease", "CPDecrease", "BBOY", "ChangeType", "FYChanges", "CPChanges"};
    private static String[] canaddlevelStr = new String[]{"BBOY", "BOP", "BFLY", "BBOY01", "BBOY02", "BBOY03", "BBOY04", "EndingBalance", "YTD", "CurrentPeriod"};

    public DimemberBaseAction() {
    }

    public DimemberBaseAction(String id, String dimensionNumber, String entityName, String actionId) {
        this.id = id;
        this.dimensionNumber = dimensionNumber;
        this.entityid = entityName;
        this.actionId = actionId;
    }

    public DimemberBaseAction(String entityid, String memberName, String modelid) {
        this.entityid = entityid;
        this.memberName = memberName;
        this.modelid = modelid;
    }

    public DimemberBaseAction(String id, String dimensionNumber, String entityName, String actionId, String modelid) {
        this.id = id;
        this.dimensionNumber = dimensionNumber;
        this.entityid = entityName;
        this.actionId = actionId;
        this.modelid = modelid;
        if (!StringUtils.isEmpty((String)modelid)) {
            this.modelNum = MemberReader.findModelNumberById((Object)Long.valueOf(modelid));
        }
    }

    public String getAppId() {
        return this.AppId;
    }

    public void setAppId(String appId) {
        this.AppId = appId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String checkOpen(String memberId) {
        String selectFields = "storagetype,parent,level,number,model";
        if ("bcm_entitymembertree".equals(this.entityid)) {
            selectFields = selectFields + ",cslscheme";
        }
        QFilter filter = new QFilter("id", "=", (Object)LongUtil.toLong((Object)memberId));
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)this.entityid, (String)selectFields, (QFilter[])filters, (String)"");
        if (dcs == null || dcs.size() != 1) return "";
        int storagetype = ((DynamicObject)dcs.get(0)).getInt("storagetype");
        long parent = ((DynamicObject)dcs.get(0)).getLong("parent");
        int level = ((DynamicObject)dcs.get(0)).getInt("level");
        long modelId = ((DynamicObject)dcs.get(0)).getLong("model");
        if ("baritemaddsub".equals(this.actionId)) {
            if (storagetype != 3) return "";
            if (!"bcm_entitymembertree".equals(this.entityid)) return ResManager.loadKDString((String)"\u4e0d\u53ef\u521b\u5efa\u5171\u4eab\u6210\u5458\u7684\u4e0b\u7ea7\u6210\u5458\u3002", (String)"DimemberBaseAction_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            long schemeId = ((DynamicObject)dcs.get(0)).getLong("cslscheme");
            if (EntityTreeUtil.isBelongCurSchemeOfShareMem((long)modelId, (long)schemeId, (long)Long.parseLong(memberId))) return "";
            return ResManager.loadKDString((String)"\u4e0d\u53ef\u521b\u5efa\u5171\u4eab\u6210\u5458\u7684\u4e0b\u7ea7\u6210\u5458\u3002", (String)"DimemberBaseAction_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (!"baritemaddlevel".equals(this.actionId)) return "";
        if (level == 1 && parent == 0L) {
            return ResManager.loadKDString((String)"\u4e0d\u53ef\u521b\u5efa\u4e0e\u6839\u6210\u5458\u5e73\u7ea7\u7684\u6210\u5458\u3002", (String)"DimemberBaseAction_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (!"eb_datetypemembertree".equals(this.entityid) || !((DynamicObject)dcs.get(0)).getString("number").equals("Actual") && !((DynamicObject)dcs.get(0)).getString("number").equals("Budget")) return "";
        return ResManager.loadKDString((String)"\u4e0d\u53ef\u521b\u5efa\u5e73\u7ea7\u6210\u5458\u3002", (String)"DimemberBaseAction_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public String checkEnable(String modelid, String selectedRowNumber) {
        return "";
    }

    public String getId() {
        return this.id;
    }

    public String getDimensionName() {
        return this.dimensionName;
    }

    public String getActionId() {
        return this.actionId;
    }

    public String getEntityid() {
        return this.entityid;
    }

    public String getDimensionNumber() {
        return this.dimensionNumber;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public String getModelid() {
        return this.modelid;
    }

    public String getModelNum() {
        return this.modelNum;
    }

    public String checkAddEnable(String number, String modelId, String dimNum, String entityName, String actionName, String issysmember, boolean ispaste) {
        DimemberBaseAction action;
        String enable;
        IDNumberTreeNode node = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)LongUtil.toLong((Object)modelId)), (String)dimNum, (String)number);
        if (node != IDNumberTreeNode.NotFoundTreeNode && node.getLongNumber().contains("!IFRS!")) {
            return "";
        }
        if (DimTypesEnum.CHANGETYPE.getNumber().equals(dimNum) && "1".equals(issysmember)) {
            if ("baritemaddsub".equals(actionName) || "baritemaddshare".equals(actionName)) {
                if (!Arrays.asList(canaddsubStr).contains(number)) {
                    return ResManager.loadKDString((String)"\u8be5\u6210\u5458\u4e0d\u53ef\u65b0\u589e\u4e0b\u7ea7\u6216\u65b0\u589e\u5171\u4eab\u3002", (String)"DimemberBaseAction_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                }
            } else if (!Arrays.asList(canaddlevelStr).contains(number)) {
                return ResManager.loadKDString((String)"\u8be5\u6210\u5458\u4e0d\u53ef\u65b0\u589e\u5e73\u7ea7\u3002", (String)"DimemberBaseAction_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
        }
        if ("3".equals(enable = (action = DimensionFactory.getDimesionMemberAction("", dimNum, entityName, null)).checkEnable(modelId, number))) {
            return ispaste ? ResManager.loadKDString((String)"\u8be5\u6210\u5458\u65e0\u6cd5\u8fdb\u884c\u7c98\u8d34\u64cd\u4f5c\u3002", (String)"DimemberBaseAction_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u671f\u95f4\u7ef4\u5ea6\u53ea\u53ef\u5728\u90e8\u5206\u6307\u5b9a\u6210\u5458\u4e0b\u521b\u5efa\u65b0\u6210\u5458\u3002", (String)"DimemberBaseAction_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (enable.startsWith("0")) {
            if ("baritemaddlevel".equals(actionName)) {
                return ispaste ? ResManager.loadKDString((String)"\u8be5\u6210\u5458\u65e0\u6cd5\u8fdb\u884c\u7c98\u8d34\u64cd\u4f5c\u3002", (String)"DimemberBaseAction_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u671f\u95f4\u7ef4\u5ea6\u53ea\u53ef\u5728\u90e8\u5206\u6307\u5b9a\u6210\u5458\u4e0b\u521b\u5efa\u65b0\u6210\u5458\u3002", (String)"DimemberBaseAction_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
        } else if (enable.startsWith("1")) {
            if ("baritemaddsub".equals(actionName)) {
                return ispaste ? ResManager.loadKDString((String)"\u8be5\u6210\u5458\u65e0\u6cd5\u8fdb\u884c\u7c98\u8d34\u64cd\u4f5c\u3002", (String)"DimemberBaseAction_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u671f\u95f4\u7ef4\u5ea6\u53ea\u53ef\u5728\u90e8\u5206\u6307\u5b9a\u6210\u5458\u4e0b\u521b\u5efa\u65b0\u6210\u5458\u3002", (String)"DimemberBaseAction_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            if ("baritemaddlevel".equals(actionName)) {
                return "";
            }
        }
        return "";
    }

    public String checkCutOperation(Long memberId, Long schemeId) {
        DynamicObject dy;
        if ("bcm_scenemembertree".equals(this.entityid)) {
            return ResManager.loadKDString((String)"\u6210\u5458\u526a\u5207\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\u5982\u4e0b\uff1a\u4e0d\u53ef\u526a\u5207\u60c5\u666f\u6210\u5458\u3002", (String)"DimemberBaseAction_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if ("bcm_mycompanymembertree".equals(this.entityid)) {
            return ResManager.loadKDString((String)"\u6210\u5458\u526a\u5207\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\u5982\u4e0b\uff1a\u4e0d\u53ef\u526a\u5207\u6211\u65b9\u7ec4\u7ec7\u6210\u5458\u3002", (String)"DimemberBaseAction_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        String selectFields = "number,storagetype,issysmember,longnumber,parent.id,parent.storagetype";
        QFilter filter = new QFilter("id", "=", (Object)memberId);
        if ("bcm_periodmembertree".equals(this.entityid)) {
            selectFields = selectFields + ",isadjust";
        }
        if ((dy = QueryServiceHelper.queryOne((String)this.entityid, (String)selectFields, (QFilter[])filter.toArray())) != null) {
            QFilter qf;
            DynamicObject scheme;
            String longNumber = dy.getString("longnumber");
            if (longNumber.contains("!IFRS!")) {
                return "";
            }
            if ("bcm_periodmembertree".equals(this.entityid) && dy.getBoolean("isadjust")) {
                return ResManager.loadKDString((String)"\u6210\u5458\u526a\u5207\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\u5982\u4e0b\uff1a\u4e0d\u53ef\u526a\u5207\u8c03\u6574\u671f\u6210\u5458\u3002", (String)"DimemberBaseAction_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            if (StorageTypeEnum.SHARE.index.equals(dy.getString("storagetype"))) {
                return ResManager.loadKDString((String)"\u6210\u5458\u526a\u5207\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5171\u4eab\u6210\u5458\u4e0d\u5141\u8bb8\u88ab\u526a\u5207\u3002", (String)"DimemberBaseAction_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            long sysMember = dy.getInt("issysmember");
            String number = dy.getString("number");
            if (sysMember == 1L) {
                if ("bcm_accountmembertree".equals(this.entityid)) {
                    if (this.noCutAccountMember.contains(number)) {
                        return ResManager.loadKDString((String)"\u6210\u5458\u526a\u5207\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\u5982\u4e0b\uff1a\u4e0d\u53ef\u526a\u5207\u9884\u7f6e\u6210\u5458\u3002", (String)"DimemberBaseAction_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    }
                } else {
                    return ResManager.loadKDString((String)"\u6210\u5458\u526a\u5207\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\u5982\u4e0b\uff1a\u4e0d\u53ef\u526a\u5207\u9884\u7f6e\u6210\u5458\u3002", (String)"DimemberBaseAction_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                }
            }
            String pType = dy.getString("parent.storagetype");
            long parentId = dy.getLong("parent.id");
            if ("bcm_entitymembertree".equals(this.entityid) && StorageTypeEnum.STORAGE.index.equals(pType) && (scheme = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"islegalorgview", (QFilter[])(qf = new QFilter("id", "=", (Object)schemeId)).toArray())) != null && !scheme.getBoolean("islegalorgview")) {
                QFilter qModel = new QFilter("model", "=", (Object)LongUtil.toLong((Object)this.modelid));
                QFilter qMembers = new QFilter("id", "!=", (Object)LongUtil.toLong((Object)memberId));
                QFilter qParent = new QFilter("parent", "=", (Object)parentId);
                if (!QueryServiceHelper.exists((String)this.entityid, (QFilter[])new QFilter[]{qModel, qParent, qMembers})) {
                    return ResManager.loadKDString((String)"\u6210\u5458\u526a\u5207\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\u5982\u4e0b\uff1a\u975e\u6cd5\u5b9a\u89c6\u56fe\u4e0d\u5141\u8bb8\u526a\u5207\u6210\u5458\u540e\u4ea7\u751f\u5b58\u50a8\u7c7b\u578b\u4e3a\u5b58\u50a8\u7684\u660e\u7ec6\u6210\u5458\u3002", (String)"DimemberBaseAction_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                }
            }
        }
        return "";
    }

    public String checkPasteOperation(Long memberId, String[] pks) {
        QFilter filter;
        QFilter[] filters;
        boolean isOrg = "bcm_entitymembertree".equals(this.entityid);
        String selectFields = "number,storagetype,parent,issysmember,level,longnumber" + (isOrg ? ", cslscheme" : "");
        DynamicObject member = QueryServiceHelper.queryOne((String)this.entityid, (String)selectFields, (QFilter[])(filters = new QFilter[]{filter = new QFilter("id", "=", (Object)LongUtil.toLong((Object)memberId))}));
        if (member != null) {
            int storagetype = member.getInt("storagetype");
            long issysmember = member.getInt("issysmember");
            String parentid = member.getString("parent");
            long level = member.getInt("level");
            String longnumber = member.getString("longnumber");
            if (longnumber.contains("!IFRS!")) {
                return "";
            }
            if (level != 1L) {
                if (issysmember == 1L && !longnumber.startsWith("Account!RPTItem") && !longnumber.startsWith("InternalCompany!ICTotal!ICOEntity")) {
                    return ResManager.loadKDString((String)"\u6210\u5458\u7c98\u8d34\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\u5982\u4e0b\uff1a\u4e0d\u53ef\u5c06\u4efb\u4f55\u6210\u5458\u7c98\u8d34\u5230\u9884\u7f6e\u6210\u5458\u4e0b\u3002", (String)"DimemberBaseAction_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                }
                if (storagetype == 3) {
                    return ResManager.loadKDString((String)"\u6210\u5458\u7c98\u8d34\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\u5982\u4e0b\uff1a\u4e0d\u53ef\u5c06\u4efb\u4f55\u6210\u5458\u7c98\u8d34\u5230\u5171\u4eab\u6210\u5458\u4e0b\u3002", (String)"DimemberBaseAction_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                }
                boolean containStorageMember = false;
                boolean containSelectedid = false;
                boolean isparentToChrild = false;
                Long orgCslSchemeId = null;
                Map allNodeFromCache = MemberReader.getAllNodeFromCache((String)this.entityid, (String)this.modelNum);
                for (int i = 0; i < pks.length; ++i) {
                    IDNumberTreeNode dysubTree = (IDNumberTreeNode)allNodeFromCache.get(Long.parseLong(pks[i]));
                    if (isOrg && orgCslSchemeId == null) {
                        orgCslSchemeId = (Long)dysubTree.getProperty("cslscheme.id");
                    }
                    if (pks[i].trim().equals(memberId.toString()) && !"3".equals(dysubTree.getStorageType().getOIndex())) {
                        containSelectedid = true;
                        if (containStorageMember) break;
                    }
                    if ("3".equals(dysubTree.getStorageType().getOIndex())) {
                        if (dysubTree.getNumber().equals(member.getString("number")) && "2".equals(member.getString("storagetype"))) {
                            containStorageMember = true;
                        }
                        if (containSelectedid) break;
                    }
                    if (!pks[i].equals(parentid)) continue;
                    isparentToChrild = true;
                }
                if (isparentToChrild || containSelectedid) {
                    return ResManager.loadKDString((String)"\u4e0d\u53ef\u7c98\u8d34\u5230\u81ea\u8eab\u6210\u5458\u53ca\u5176\u4e0b\u7ea7\u6210\u5458\u4e0b\u3002", (String)"DimemberBaseAction_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                }
                if (containStorageMember || containSelectedid) {
                    return ResManager.loadKDString((String)"\u6210\u5458\u7c98\u8d34\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\u5982\u4e0b\uff1a\u4e0d\u53ef\u5c06\u5305\u542b\u5171\u4eab\u6210\u5458\u7684\u6210\u5458\u7c98\u8d34\u5230\u5176\u5bf9\u5e94\u7684\u57fa\u672c\u6210\u5458\u4e0b\u3002", (String)"DimemberBaseAction_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                }
                if (isOrg) {
                    DynamicObjectCollection dys = QueryServiceHelper.query((String)this.entityid, (String)"id", (QFilter[])new QFilter[]{new QFilter("ctrlorg", "=", (Object)LongUtil.toLong((Object)memberId))});
                    if (dys != null && !dys.isEmpty()) {
                        return ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u88ab\u8bbe\u7f6e\u4e3a\u63a7\u80a1\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u518d\u88ab\u526a\u5207\u7c98\u8d34\u3002", (String)"DimemberBaseAction_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    }
                    if (orgCslSchemeId != null && !orgCslSchemeId.equals(member.get("cslscheme"))) {
                        return ResManager.loadKDString((String)"\u4e0d\u80fd\u8de8\u7ec4\u7ec7\u89c6\u56fe\u8fdb\u884c\u7c98\u8d34\u3002", (String)"DimemberBaseAction_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    }
                }
            }
            List<Long> list = this.getShareMemberId(memberId);
            Set ids = Arrays.stream(pks).map(x -> ConvertUtil.convertStrToLong((String)x)).collect(Collectors.toSet());
            ids.retainAll(list);
            if (!ids.isEmpty()) {
                return ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u4e92\u5171\u4eab\u6216\u5faa\u73af\u5171\u4eab\uff0c\u7c98\u8d34\u4e0d\u6210\u529f\u3002", (String)"DimemberBaseAction_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private List<Long> getShareMemberId(Long nodeId) {
        QFilter filter = new QFilter("storagetype", "=", (Object)StorageTypeEnum.SHARE.getOIndex());
        QFilter filter1 = new QFilter("parent", "=", (Object)nodeId);
        QFilter[] filters = new QFilter[]{filter, filter1};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)this.entityid, (String)"id,parent,copyfrom.id", (QFilter[])filters, null);
        ArrayList<Map<String, Long>> treeList = new ArrayList<Map<String, Long>>(10);
        for (DynamicObject a : dcs) {
            HashMap<String, Long> map = new HashMap<String, Long>(16);
            map.put("id", a.getLong("id"));
            map.put("parent", a.getLong("parent"));
            map.put("copyfrom", a.getLong("copyfrom.id"));
            treeList.add(map);
        }
        ArrayList<Long> allnodelist = new ArrayList<Long>(16);
        allnodelist.add(nodeId);
        return this.queryAllChildNodeList2(nodeId, treeList, allnodelist);
    }

    private List<Long> queryAllChildNodeList2(Long nodeid, List<Map<String, Long>> treeList, List<Long> allnodelist) {
        for (Map<String, Long> m : treeList) {
            if (!m.get("parent").equals(nodeid)) continue;
            allnodelist.add(m.get("copyfrom"));
            this.queryAllChildNodeList2(m.get("id"), treeList, allnodelist);
        }
        return allnodelist;
    }

    public String checkImpOperation(String memberId) {
        return "";
    }
}

