/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.webapi.DefaultOperate;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.datalock.DataLockHelper;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.DynamicComputingServiceHelper;
import kd.fi.bcm.business.dimension.helper.ExtDimensionHelper;
import kd.fi.bcm.business.dimension.helper.OlapPresetHelper;
import kd.fi.bcm.business.dimension.struct.ShareNodeStructSyncHelper;
import kd.fi.bcm.business.olap.shield.ShieldRuleBulider;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.util.DimMemberSortUtil;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.LocalCacheHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.DimMemTypeEnum;
import kd.fi.bcm.common.enums.log.DimMemberOperateTypeEnum;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.IOperationLog;
import kd.fi.bcm.formplugin.dimension.batchimp.bos.BcmBatchImportPlugin;
import kd.fi.bcm.formplugin.dimension.batchimp.event.FailLogSubscriber;
import kd.fi.bcm.formplugin.dimension.batchimp.event.ImportEventHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.event.ImportFinishEvent;
import kd.fi.bcm.formplugin.dimension.batchimp.handlers.CommonPostImportHandler;
import kd.fi.bcm.formplugin.dimension.batchimp.handlers.EntityPostImportHandler;
import kd.fi.bcm.formplugin.dimension.batchimp.handlers.IDimensionImportHandler;
import kd.fi.bcm.formplugin.dimension.batchimp.handlers.PermClassImportHandler;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.BatchImportReadOnlyCache;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.DimensionDependencyResolver;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.DimensionImportContext;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportBillIndexWrap;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportResultEntry;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportText2DateUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.OverrideResultEntry;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.PersistEntry;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ShareMemberHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.SilentJSONUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.CacheStoreManager;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.PersistProxy;
import kd.fi.bcm.formplugin.dimension.batchimp.plugins.lastimportlist.HistoryRecord;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.IDimensionImportValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.CheckFieldNullValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.CircleValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.DataIntegrationValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.DynamicSettingValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.LastLogicValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.MemberNumExistValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.ModelAndDimensionConsistentValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.NonShareMemberValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.PageHasPermClassAllowInValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.ParentNumberExistAndSetValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.PropertyValueValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.ShareMemberValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.ShieldRuleContentValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.SupportValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.SystemMemberValidator;
import kd.fi.bcm.formplugin.impexport.BillResult;

public abstract class AbstractDimensionBatchImport
extends BcmBatchImportPlugin
implements IOperationLog {
    protected static WatchLogger LOG = BcmLogFactory.getWatchLogInstance((boolean)true, AbstractDimensionBatchImport.class);
    protected int timeout = 604800;
    protected String entityName;
    protected volatile long modelId = 0L;
    protected volatile DynamicObject model = null;
    protected String appId;
    protected boolean isCM = false;
    protected boolean isRpt = false;
    protected boolean isModelManager = false;
    protected volatile long dimensionId = 0L;
    protected volatile DynamicObject dimension = null;
    private static final String ACCOUNTNUMBER = "accountnumber";
    private static final String ACCOUNTSCALE = "accountscale";
    private String memberEntityName;
    protected final Map<String, String> newMembNums = new ConcurrentHashMap<String, String>(128);
    private int curBatch = 0;
    protected List<IDimensionImportValidator> validators;
    protected List<IDimensionImportHandler> handlers;
    private final Set<ImportBillData> allImportBills = new HashSet<ImportBillData>(128);

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        super.setContext(rc, ctx, startArgs);
        String keyFields = (String)ctx.getOption().get("KeyFields");
        if (StringUtils.isNotEmpty((CharSequence)keyFields) && !keyFields.contains("number")) {
            throw new KDBizException(ImportMsgUtils.onlySupportNumberAsUniqueKey());
        }
        this.entityName = ctx.getBillFormId().replaceAll("imp", "tree");
        this.memberEntityName = this.getMemberName();
        this.appId = ctx.getAppId();
        this.isCM = ApplicationTypeEnum.CM.appnum.equals(this.appId);
        this.isRpt = ApplicationTypeEnum.RPT.appnum.equals(this.appId);
        return this;
    }

    public String getDefaultKeyFields() {
        return "number";
    }

    protected int getBatchImportSize() {
        return 1000000;
    }

    protected int getMaxSaveBatchSize() {
        return 5000;
    }

    protected boolean isForceBatch() {
        return true;
    }

    public AbstractOperateWebApi getSaveWebApi() {
        return new DefaultOperate();
    }

    @Override
    public void beforeImport() {
        super.beforeImport();
        long tick = System.currentTimeMillis();
        this.initImportContext();
        LOG.info(this.genLogPrefix("init.beforeImport") + String.format(" cost time: %s", System.currentTimeMillis() - tick));
    }

    protected ApiResult save(List<ImportBillData> rowData, ImportLogger logger) {
        long tick = System.currentTimeMillis();
        FailLogSubscriber.importLogger.set(logger);
        ++this.curBatch;
        this.beforeValidation(rowData);
        LOG.info(this.genLogPrefix("save.beforeValid") + String.format(" imported: %s,batch size: %s, cost time: %s", this.allImportBills.size(), rowData.size(), System.currentTimeMillis() - tick));
        tick = System.currentTimeMillis();
        List allValidateResults = BatchProcessHelper.batchHandle(rowData, (int)2000, (int)500, this::validateBatchBills, null, (BatchProcessHelper.Scene)BatchProcessHelper.Scene.CPU);
        LOG.info(this.genLogPrefix("save.valid") + String.format(" imported: %s,batch size: %s, cost time: %s", this.allImportBills.size(), rowData.size(), System.currentTimeMillis() - tick));
        ArrayList<BillResult> savedBillResults = new ArrayList<BillResult>(rowData.size());
        ArrayList<ImportBillData> validatedBillData = new ArrayList<ImportBillData>(rowData.size());
        Iterator<ImportBillData> iterator = rowData.iterator();
        int index = 0;
        int validIndex = 0;
        while (iterator.hasNext()) {
            ImportBillData data = iterator.next();
            Optional validMsg = (Optional)allValidateResults.get(index);
            if (validMsg.isPresent()) {
                logger.log(Integer.valueOf(data.getStartIndex()), (String)validMsg.get()).fail();
                iterator.remove();
                ImportEventHelper.sendImportFinishEvent(new ImportFinishEvent(ImportFinishEvent.ImportStatus.FAIL, this.modelId, this.dimensionId, data.getData().getString("number")));
            } else {
                validatedBillData.add(data);
                BillResult result = new BillResult();
                result.setIndex(validIndex++);
                result.setNumber(data.getData().getString("number"));
                result.setSucess(true);
                result.setData((Map<String, Object>)data.getData());
                savedBillResults.add(result);
            }
            ++index;
        }
        this.allImportBills.addAll(rowData);
        long aTick = System.currentTimeMillis();
        List<Object> resultEntries = new ArrayList(validatedBillData.size());
        if (!validatedBillData.isEmpty()) {
            resultEntries = this.saveBatch(validatedBillData);
            for (int i = 0; i < resultEntries.size(); ++i) {
                if (((ImportResultEntry)resultEntries.get(i)).isErr()) {
                    ((BillResult)savedBillResults.get(i)).setSucess(false);
                    ((BillResult)savedBillResults.get(i)).setMessage(((ImportResultEntry)resultEntries.get(i)).getErrMsg());
                }
                ImportEventHelper.sendImportFinishEvent(new ImportFinishEvent(((ImportResultEntry)resultEntries.get(i)).isErr() ? ImportFinishEvent.ImportStatus.FAIL : ImportFinishEvent.ImportStatus.SUCCESS, this.modelId, this.dimensionId, ((BillResult)savedBillResults.get(i)).getNumber()));
            }
        }
        LOG.info(this.genLogPrefix("save.save") + String.format(" imported: %s,batch size: %s, cost time: %s", this.allImportBills.size(), rowData.size(), System.currentTimeMillis() - aTick));
        if (savedBillResults.size() != resultEntries.size()) {
            throw new IllegalStateException("the count of saved result not equals the process count");
        }
        if (!ImportContextHolder.isDryRun()) {
            this.afterSaveBatch(validatedBillData, resultEntries);
        }
        ApiResult apiResult = new ApiResult();
        ArrayList<Map<String, Object>> apiResultData = new ArrayList<Map<String, Object>>(savedBillResults.size());
        for (int i = 0; i < savedBillResults.size(); ++i) {
            if (((ImportResultEntry)resultEntries.get(i)).isErr()) {
                apiResult.setSuccess(false);
            }
            apiResultData.add(((BillResult)savedBillResults.get(i)).toMap());
        }
        apiResult.setData(apiResultData);
        this.refreshDimChangeTime(validatedBillData);
        LOG.info(this.genLogPrefix("save.total") + String.format(" imported: %s,batch size: %s, cost time: %s", this.allImportBills.size(), rowData.size(), System.currentTimeMillis() - tick));
        return apiResult;
    }

    private void refreshDimChangeTime(List<ImportBillData> validatedBillData) {
        try {
            Set<Long> cslIds = new HashSet<Long>(1);
            if ("bcm_entitymembertree".equals(this.dimension.getString("membermodel"))) {
                QFilter filter = new QFilter("model.id", "=", (Object)this.modelId);
                if (this.isRpt) {
                    filter.and(new QFilter("number", "=", (Object)"DefaultScheme"));
                } else {
                    Set cslNums = validatedBillData.stream().map(x -> SilentJSONUtils.cast(x.getData().get((Object)"cslscheme").toString(), LinkedHashMap.class).get("number").toString()).collect(Collectors.toSet());
                    if (!CollectionUtils.isEmpty(cslNums)) {
                        filter.and(new QFilter("number", "in", cslNums));
                    }
                }
                DynamicObjectCollection cslDys = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id", (QFilter[])filter.toArray());
                cslIds = cslDys.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
            } else {
                cslIds.add(0L);
            }
            for (Long cslId : cslIds) {
                DimMemberSortUtil.upadteDimChangeTime((Long)this.modelId, (Long)cslId, (Long)this.dimensionId, (String)"changetime");
            }
        }
        catch (Exception ex) {
            LOG.error("Refresh dimension change time error." + ex.getMessage());
        }
    }

    @Override
    protected void beforeEndLogStatistic(ImportLogger logger) {
    }

    @Override
    protected void afterImport() {
        super.afterImport();
        BatchImportReadOnlyCache.clear();
        if (!ImportContextHolder.isDryRun()) {
            if ("bcm_icmembertree".equalsIgnoreCase(ImportContextHolder.getEntityName())) {
                ShareNodeStructSyncHelper.syncICNodeStorageType((long)ImportContextHolder.getModelId(), (long)ImportContextHolder.getDimensionId());
            } else {
                ShareNodeStructSyncHelper.resyncShareNodeStructure((String)ImportContextHolder.getEntityName(), (long)ImportContextHolder.getModelId(), (long)ImportContextHolder.getDimensionId());
                try {
                    PersistProxy.instance.syncMemberNodeIsLeaf();
                }
                catch (Exception e) {
                    LOG.error("bcm_dimension_batch_import failed to sync member node leaf error: " + e.getMessage(), (Throwable)e);
                }
            }
            try {
                BatchProcessHelper.handleAsync(() -> DynamicComputingServiceHelper.repairModelByDim((String)ImportHelper.getNumber(this.model), (String)ImportHelper.getNumber(this.dimension), (boolean)true));
            }
            catch (Exception e) {
                LOG.error(this.genLogPrefix("import.final.rebuild-agg") + "failed to rebuild:" + e.getMessage(), (Throwable)e);
            }
        } else {
            LocalDateTime nowTime = LocalDateTime.now();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String time = df.format(nowTime);
            try {
                String serializeResult = CacheStoreManager.serializeCurrentWorkStore();
                this.setFileCache(serializeResult, time);
                CacheStoreManager.clearStore();
            }
            catch (Exception e) {
                LOG.error("bcm_dimension_batch_import clear dry run cache  error: " + e.getMessage(), (Throwable)e);
            }
            RowDataExtUtil.clearAllExtProps(this.allImportBills);
            this.setFileCacheForExcelData(this.allImportBills, time);
        }
        ImportContextHolder.clearBatchCache();
        ImportContextHolder.removeCurrent();
    }

    private void setFileCacheForExcelData(Set<ImportBillData> allImportBills, String time) {
        if (!CollectionUtils.isEmpty(allImportBills)) {
            String historyRdStr;
            HashSet<JSONObject> allJson = new HashSet<JSONObject>(16);
            for (ImportBillData allImportBill : allImportBills) {
                DynamicObject currency = (DynamicObject)allImportBill.getData().get((Object)"currency");
                if (currency != null) {
                    allImportBill.getData().put("currency", (Object)currency.getString("number"));
                }
                allJson.add(allImportBill.getData());
            }
            String importExcelData = JacksonUtils.toJson(allJson);
            String contentKey = "dim_import_ret1" + RequestContext.get().getUserId() + this.dimensionId + time;
            String logLookKey = "dim_import_ret1_log" + RequestContext.get().getUserId() + this.dimensionId + time;
            AppCacheServiceHelper.put((String)contentKey, (Object)importExcelData, (int)this.timeout);
            AppCacheServiceHelper.put((String)logLookKey, (Object)this.ctx.getLogId(), (int)this.timeout);
            this.cacheExecuteDryRumParams(this.ctx, time);
            HistoryRecord historyRecord = new HistoryRecord();
            historyRecord.setModelId(String.valueOf(this.modelId));
            historyRecord.setDimensionName(this.dimension.getString("name"));
            historyRecord.setDimensionId(this.dimensionId + "");
            historyRecord.setUserId(RequestContext.get().getUserId());
            String[] urlInfo = ((String)this.ctx.getAllUrls().iterator().next()).split("/");
            String fileName = urlInfo[urlInfo.length - 1];
            historyRecord.setFileName(fileName);
            historyRecord.setTime(time);
            AppCacheServiceHelper.put((String)"view_import_time", (Object)time, (int)6000);
            String historyRecordKey = "dim_import_ret1historyContent";
            Object lastCacheStr = AppCacheServiceHelper.get((String)historyRecordKey);
            if (lastCacheStr != null) {
                Set alreadyRecords = (Set)JacksonUtils.fromJson((String)((String)lastCacheStr), Set.class);
                alreadyRecords.add(historyRecord);
                historyRdStr = JacksonUtils.toJson((Object)alreadyRecords);
            } else {
                HashSet<HistoryRecord> allRecord = new HashSet<HistoryRecord>(16);
                allRecord.add(historyRecord);
                historyRdStr = JacksonUtils.toJson(allRecord);
            }
            AppCacheServiceHelper.put((String)historyRecordKey, (Object)historyRdStr, (int)this.timeout);
        }
    }

    private void cacheExecuteDryRumParams(ImportContext ctx, String time) {
        String dryRunParamsKey = "dryRun_import_parms" + RequestContext.get().getUserId() + this.dimensionId + time + "dryRumParams";
        Object viewObject = ctx.getOption().get("dimension_manager_view");
        if (viewObject != null) {
            String dryRunParams = ((IFormView)viewObject).getPageCache().get("dryRun_import_parms");
            AppCacheServiceHelper.put((String)dryRunParamsKey, (Object)dryRunParams);
        }
    }

    private void setFileCache(String serializeResult, String time) {
        AppCacheServiceHelper.put((String)("dim_import_ret1" + RequestContext.get().getUserId() + this.dimensionId + time + "content"), (Object)serializeResult, (int)this.timeout);
    }

    public void initImportContext() {
        if (Objects.isNull(this.model)) {
            this.model = this.getCurrentModel();
            if (Objects.isNull(this.model)) {
                throw new KDBizException(ImportMsgUtils.specificModelFirst(), new Object[0]);
            }
            this.modelId = this.model.getLong("id");
        }
        if (Objects.isNull(this.dimension)) {
            this.dimension = this.getCurrentDimension();
            if (Objects.isNull(this.dimension)) {
                throw new KDBizException(ImportMsgUtils.specificDimensionFirst(), new Object[0]);
            }
            this.dimensionId = this.dimension.getLong("id");
        }
        DimensionImportContext context = new DimensionImportContext(this.model, this.dimension, this.entityName, ImportHelper.getImportType(this.ctx), this.appId, this.isModelManager, this.newMembNums, null);
        ImportContextHolder.setImportContext(context);
        this.validators = new ArrayList<IDimensionImportValidator>(16);
        this.validators.add(new MemberNumExistValidator());
        this.validators.add(new SupportValidator());
        this.validators.add(new ModelAndDimensionConsistentValidator());
        this.validators.add(new CheckFieldNullValidator());
        this.validators.add(new ParentNumberExistAndSetValidator());
        if (!"bcm_icmembertree".equals(context.getEntityName())) {
            this.validators.add(new SystemMemberValidator());
            this.validators.add(new ShareMemberValidator());
            this.validators.add(new CircleValidator());
            this.validators.add(new DataIntegrationValidator());
            this.validators.add(new PageHasPermClassAllowInValidator());
            this.validators.add(new NonShareMemberValidator());
            this.validators.add(new DynamicSettingValidator());
        }
        this.validators.add(new PropertyValueValidator());
        this.validators.add(new LastLogicValidator());
        this.validators.add(new ShieldRuleContentValidator());
        this.customizeValidators(context, this.validators);
        this.validators.sort((o1, o2) -> o2.getWeight() - o1.getWeight());
        this.handlers = new ArrayList<IDimensionImportHandler>(5);
        this.handlers.add(new CommonPostImportHandler(context));
        this.handlers.add(new EntityPostImportHandler(context));
        this.handlers.add(new PermClassImportHandler(context));
        this.customizeHandlers(context, this.handlers);
        BatchProcessHelper.handleAsync(PersistProxy.instance::preInitData);
    }

    protected DynamicObject getCurrentModel() {
        Long importModelId = (Long)this.ctx.getOption().get("BcmModelId");
        if (Objects.isNull(importModelId) || importModelId == 0L) {
            throw new KDBizException(ImportMsgUtils.specificModelFirst(), new Object[0]);
        }
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (String)"id,number,shownumber", (QFilter[])new QFilter("id", "=", (Object)importModelId).toArray());
    }

    private DynamicObject getCurrentDimension() {
        Long importDimensionId = (Long)this.ctx.getOption().get("BcmDimensionId");
        if (Objects.isNull(importDimensionId) || importDimensionId == 0L) {
            throw new KDBizException(ImportMsgUtils.specificDimensionFirst(), new Object[0]);
        }
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_dimension", (String)"id,number,membermodel", (QFilter[])new QFilter("id", "=", (Object)importDimensionId).toArray());
    }

    private List<Optional<String>> validateBatchBills(List<ImportBillData> bills) {
        ArrayList<Optional<String>> billValidateResults = new ArrayList<Optional<String>>(bills.size());
        for (ImportBillData bill : bills) {
            try {
                billValidateResults.add(this.validateBillData(bill));
            }
            catch (Exception e) {
                LOG.error("Failed to validate bill: " + bill.getData() + " for " + e.getMessage(), (Throwable)e);
                billValidateResults.add(Optional.of(e.getMessage()));
            }
        }
        return billValidateResults;
    }

    protected void beforeValidation(List<ImportBillData> importedBills) {
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        switch (importType) {
            case NEW: {
                this.updateWithNewId(importedBills);
                break;
            }
            case OVERRIDE: {
                this.updateWithExistId(importedBills, false);
                break;
            }
            case OVERRIDENEW: {
                this.updateWithExistId(importedBills, true);
                break;
            }
        }
    }

    private void updateWithNewId(List<ImportBillData> newBills) {
        if (CollectionUtils.isEmpty(newBills)) {
            return;
        }
        long[] ids = DBServiceHelper.genLongIds((String)this.entityName, (int)newBills.size());
        for (int j = 0; j < newBills.size(); ++j) {
            RowDataExtUtil.addId(newBills.get(j), ids[j]);
        }
    }

    private void updateWithExistId(List<ImportBillData> existBills, boolean isOverrideNew) {
        ArrayList nonSharedBills = new ArrayList(existBills.size());
        ArrayList sharedBills = new ArrayList(16);
        existBills.forEach(x -> {
            if (ImportHelper.isShareType((Map<String, Object>)x.getData())) {
                sharedBills.add(x);
            } else {
                nonSharedBills.add(x);
            }
        });
        if (!CollectionUtils.isEmpty(sharedBills)) {
            sharedBills.forEach(x -> {
                String parentNum = ImportHelper.getImportBillProp(x, "parent.number").toString();
                String longNumber = ImportHelper.getImportBillProp(x, "longnumber").toString();
                Optional<DynamicObject> existingOpt = PersistProxy.instance.getEditableShareMember(x.getData().getString("number"), parentNum, longNumber);
                if (existingOpt.isPresent()) {
                    RowDataExtUtil.addId(x, existingOpt.get().getLong("id"));
                    RowDataExtUtil.addExistingRecord(x, existingOpt.get());
                } else {
                    this.updateWithNewId(Collections.singletonList(x));
                }
            });
        }
        if (!CollectionUtils.isEmpty(nonSharedBills)) {
            nonSharedBills.forEach(x -> {
                String number = (String)x.getData().get((Object)"number");
                Optional<DynamicObject> nonShareMember = PersistProxy.instance.getNonShareMember(number, false);
                if (nonShareMember.isPresent()) {
                    RowDataExtUtil.addId(x, nonShareMember.get().getLong("id"));
                    RowDataExtUtil.addExistingRecord(x, nonShareMember.get());
                } else if (isOverrideNew) {
                    RowDataExtUtil.addId(x, DBServiceHelper.genGlobalLongId());
                } else {
                    RowDataExtUtil.addId(x, 0L);
                }
            });
        }
    }

    protected void afterSaveBatch(List<ImportBillData> importedBills, List<ImportResultEntry> resultEntries) {
    }

    private List<ImportResultEntry> saveBatch(List<ImportBillData> billDataList) {
        long sTick = System.currentTimeMillis();
        List<Object> resultEntries = new ArrayList(billDataList.size());
        List<ImportBillIndexWrap> billWraps = ImportBillIndexWrap.buildWrapList(billDataList);
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        try {
            if (ImportOperateType.NEW == importType) {
                resultEntries = this.insertNewBatch(billWraps);
            } else if (ImportOperateType.OVERRIDE == importType) {
                resultEntries = this.overrideBatch(billWraps);
            } else if (ImportOperateType.OVERRIDENEW == importType) {
                List<ImportResultEntry> rawOverrideResults = this.overrideBatch(billWraps);
                List<ImportBillIndexWrap> failedOverrideBillWraps = rawOverrideResults.stream().filter(ImportResultEntry::isErr).map(x -> new ImportBillIndexWrap((ImportBillData)billDataList.get(x.getIndex()), x.getIndex())).collect(Collectors.toList());
                List<ImportResultEntry> insertResults = this.insertNewBatch(failedOverrideBillWraps);
                resultEntries.addAll(rawOverrideResults.stream().filter(x -> !x.isErr()).collect(Collectors.toList()));
                resultEntries.addAll(insertResults);
            }
        }
        catch (Exception e) {
            LOG.error("dimension_import_submit allfailed:" + e.getMessage(), (Throwable)e);
            resultEntries = billWraps.stream().map(x -> ImportResultEntry.error(e, x.getListIndex())).collect(Collectors.toList());
        }
        resultEntries.sort(Comparator.comparingInt(ImportResultEntry::getIndex));
        LOG.info(this.genLogPrefix("saveBatch.operate") + String.format(" batchSize: %s, cost time: %s", billDataList.size(), System.currentTimeMillis() - sTick));
        resultEntries.forEach(x -> {
            if (x.getImportedMemTreeDy().isPresent()) {
                DynamicObject persistentMemberTreeDy = x.getImportedMemTreeDy().get();
                if (ImportHelper.isShareType(String.valueOf(persistentMemberTreeDy.get("storagetype")))) {
                    LocalCacheHelper.put((String)(this.getClass().getSimpleName() + "checkParentNumber" + this.entityName + "longnumber" + persistentMemberTreeDy.getString("longnumber")), (Object)x);
                } else {
                    LocalCacheHelper.put((String)(this.getClass().getSimpleName() + "checkParentNumber" + this.entityName + "number" + persistentMemberTreeDy.getString("number")), (Object)x);
                }
            }
        });
        return resultEntries;
    }

    protected Optional<String> validateBillData(ImportBillData billData) {
        for (IDimensionImportValidator validator : this.validators) {
            try {
                Optional<String> failedMsg = validator.proxyValidate(billData);
                if (!failedMsg.isPresent()) continue;
                return failedMsg;
            }
            catch (Exception e) {
                LOG.error("Failed to import on exception:" + e.getMessage(), (Throwable)e);
                return Optional.of(ImportHelper.buildExceptionMsg(e, 2, true));
            }
        }
        return Optional.empty();
    }

    protected void customizeValidators(DimensionImportContext context, List<IDimensionImportValidator> existingValidators) {
    }

    protected void customizeHandlers(DimensionImportContext context, List<IDimensionImportHandler> existingHandlers) {
    }

    @Override
    protected void filterFromLeftRowDatas(List<ImportBillData> leftRowdatas, List<ImportBillData> rowdatas) {
        int batchSize = this.getMaxSaveBatchSize();
        int needRowsCount = batchSize - this.countBatchRows(rowdatas);
        try (DimensionDependencyResolver dependencyResolver = new DimensionDependencyResolver(leftRowdatas);){
            Iterator<ImportBillData> leftRowdataIter = leftRowdatas.iterator();
            while (leftRowdataIter.hasNext() && needRowsCount > 0) {
                ImportBillData billdata = leftRowdataIter.next();
                int billRowSpan = billdata.getEndIndex() - billdata.getStartIndex() + 1;
                if (dependencyResolver.checkBillIsDependPrevious(billdata)) continue;
                dependencyResolver.notifyBillSelected(billdata);
                rowdatas.add(billdata);
                leftRowdataIter.remove();
                needRowsCount -= Math.max(1, billRowSpan);
            }
        }
        if (rowdatas.isEmpty() && !leftRowdatas.isEmpty()) {
            rowdatas.add(leftRowdatas.remove(0));
        }
    }

    private List<ImportResultEntry> insertNewBatch(List<ImportBillIndexWrap> billDataList) {
        if (CollectionUtils.isEmpty(billDataList)) {
            return Collections.emptyList();
        }
        long packDataTick = System.currentTimeMillis();
        List persistEntries = BatchProcessHelper.batchHandle(billDataList, (int)2000, (int)500, this::handleAssembleNewMemberEntity, null, (BatchProcessHelper.Scene)BatchProcessHelper.Scene.CPU);
        persistEntries.sort(Comparator.comparingInt(o -> o.getBillWrap().getListIndex()));
        for (PersistEntry persistEntry : persistEntries) {
            ImportBillData bill = persistEntry.getBillWrap().getBill();
            Optional<DynamicObject> existingDy = RowDataExtUtil.getExistingRecord(bill);
            if (existingDy.isPresent()) continue;
            DynamicObject parent = RowDataExtUtil.getParent(bill).get();
            long parentId = parent.getLong("id");
            persistEntry.getMemberTreeDy().set("dseq", (Object)BatchImportReadOnlyCache.getNexMemberMaxSeq(parentId));
        }
        LOG.info(this.genLogPrefix("insert.packData") + String.format("batchSize: %s, cost time: %s", billDataList.size(), System.currentTimeMillis() - packDataTick));
        List extShareMems = null;
        try (TXHandle tx = TX.requiresNew((String)"insertNewBatch");){
            try {
                List intrGroups;
                PersistProxy.instance.batchSave(persistEntries);
                if (!ImportContextHolder.isDryRun() && !"bcm_structofextend".equals(this.entityName)) {
                    List<String> batchMembers = persistEntries.stream().map(x -> x.getBillWrap().getBill().getData().get((Object)"number").toString().trim()).collect(Collectors.toList());
                    long oTick = System.currentTimeMillis();
                    try {
                        OlapServiceHelper.batchCreateDimensionMembers((String)ImportHelper.getNumber(this.model), (String)ImportHelper.getNumber(this.dimension), (String[])batchMembers.toArray(new String[0]));
                    }
                    catch (Exception ex) {
                        LOG.error(String.format("failed to update OLAP on model: %s, dimension: %s with params: %s", ImportHelper.getNumber(this.model), ImportHelper.getNumber(this.dimension), String.join((CharSequence)"|", batchMembers)), (Throwable)ex);
                        throw ex;
                    }
                    LOG.info(this.genLogPrefix("insert.create.olap") + String.format(" batchSize: %s, cost time: %s", batchMembers.size(), System.currentTimeMillis() - oTick));
                    if (ImportHelper.getNumber(this.dimension).equalsIgnoreCase("Entity")) {
                        List<String> memberNums = persistEntries.stream().map(x -> OlapPresetHelper.getDeriveNum((DynamicObject)x.getMemberTreeDy(), (String)SilentJSONUtils.cast(x.getBillWrap().getBill().getData().get((Object)"parent").toString(), LinkedHashMap.class).get("number").toString().trim())).collect(Collectors.toList());
                        OlapServiceHelper.batchCreateDimensionMembers((String)ImportHelper.getNumber(this.model), (String)ImportHelper.getNumber(this.dimension), (String[])memberNums.toArray(new String[0]));
                        HashMap orgMap = new HashMap(16);
                        memberNums.stream().filter(f -> f.contains("_")).forEach(n -> {
                            String[] str = n.split("_");
                            if (str.length == 2) {
                                orgMap.computeIfAbsent(str[0], o -> new HashSet(16)).add(str[1]);
                            }
                        });
                        LockScopeServiceHelper.addOrgToLockScope((long)this.modelId, orgMap);
                    }
                }
                if ("bcm_structofextend".equals(this.entityName) && (intrGroups = persistEntries.stream().filter(x -> "2".equals(x.getMemberTreeDy().getString("level")) && "2".equals(x.getMemberTreeDy().getString("grouptype"))).map(x -> x.getMemberTreeDy()).collect(Collectors.toList())).size() > 0) {
                    extShareMems = ExtDimensionHelper.savePreSharedMembers(intrGroups);
                }
            }
            catch (Throwable e) {
                LOG.error("dimension_import_submit rollback, error:" + e.getMessage(), e);
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
            if ("bcm_accountmembertree".equals(this.entityName) || "bcm_userdefinedmembertree".equals(this.entityName)) {
                DataLockHelper.synchroStageSetting((long)this.modelId);
            }
        }
        long tick = System.currentTimeMillis();
        if (!ImportContextHolder.isDryRun()) {
            ImportContextHolder.getOrCreateBatchDbCacheInstance().updateMembers(persistEntries.stream().map(PersistEntry::getMemberTreeDy).collect(Collectors.toList()));
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)extShareMems)) {
                ImportContextHolder.getOrCreateBatchDbCacheInstance().updateMembers(extShareMems);
            }
        }
        LOG.info(this.genLogPrefix("db.cache.updateMembers") + String.format(" batchSize: %s, cost time: %s", persistEntries.size(), System.currentTimeMillis() - tick));
        if (!ImportContextHolder.isDryRun()) {
            for (IDimensionImportHandler handler : this.handlers) {
                tick = System.currentTimeMillis();
                handler.postInsert(persistEntries);
                LOG.info(this.genLogPrefix("insert.postInsert" + handler.getClass().getSimpleName()) + String.format(" batchSize: %s, cost time: %s", persistEntries.size(), System.currentTimeMillis() - tick));
            }
        }
        ArrayList<ImportResultEntry> resultEntries = new ArrayList<ImportResultEntry>(billDataList.size());
        for (PersistEntry persistEntry : persistEntries) {
            DynamicObject memberTreeDy = persistEntry.getMemberTreeDy();
            int billListIndex = persistEntry.getBillWrap().getListIndex();
            long curSucId = memberTreeDy.getLong("id");
            if (curSucId == 0L) {
                resultEntries.add(ImportResultEntry.error(ImportMsgUtils.unexpectedInsertFail(), billListIndex));
                continue;
            }
            resultEntries.add(ImportResultEntry.success(curSucId, memberTreeDy, billListIndex));
        }
        ImportContextHolder.addBatchNewIds(persistEntries.stream().map(x -> x.getMemberTreeDy().getLong("id")).collect(Collectors.toSet()));
        return resultEntries;
    }

    private List<PersistEntry> handleAssembleNewMemberEntity(List<ImportBillIndexWrap> billDataList) {
        ArrayList<PersistEntry> persistEntries = new ArrayList<PersistEntry>(billDataList.size());
        ArrayList<DynamicObject> memberTreeDys = new ArrayList<DynamicObject>(billDataList.size());
        for (ImportBillIndexWrap billIndexWrap : billDataList) {
            JSONObject data = billIndexWrap.getBill().getData();
            DynamicObject memberTreeDy = BusinessDataServiceHelper.newDynamicObject((String)this.entityName);
            DynamicObject memberDy = BusinessDataServiceHelper.newDynamicObject((String)this.memberEntityName);
            this.assemMemberDySysField((Map<String, Object>)data, memberDy);
            this.assemMemberDySysField((Map<String, Object>)data, memberTreeDy);
            this.assemMemberTree(billIndexWrap.getBill(), memberTreeDy, memberDy, true);
            this.assemEffDate(billIndexWrap.getBill(), memberTreeDy, true);
            this.assemCopyfrom(billIndexWrap.getBill(), memberTreeDy);
            memberTreeDys.add(memberTreeDy);
            persistEntries.add(new PersistEntry(billIndexWrap, memberTreeDy, memberDy));
        }
        AbstractDimensionBatchImport.batchSetEnPartValue(this.entityName, memberTreeDys);
        return persistEntries;
    }

    private List<ImportResultEntry> overrideBatch(List<ImportBillIndexWrap> billDataList) {
        ArrayList<ImportBillIndexWrap> shareBills = new ArrayList<ImportBillIndexWrap>(16);
        ArrayList<ImportBillIndexWrap> nonshareBills = new ArrayList<ImportBillIndexWrap>(32);
        billDataList.forEach(x -> {
            if (ImportHelper.isShareType((Map<String, Object>)x.getBill().getData())) {
                shareBills.add((ImportBillIndexWrap)x);
            } else {
                nonshareBills.add((ImportBillIndexWrap)x);
            }
        });
        List<ImportResultEntry> shareImportEntries = this.overrideShareMemberBatch(shareBills);
        List<ImportResultEntry> nonShareImportEntries = this.overrideNonShareMemberBatch(nonshareBills);
        ArrayList<ImportResultEntry> allEntries = new ArrayList<ImportResultEntry>(nonShareImportEntries.size());
        allEntries.addAll(shareImportEntries);
        allEntries.addAll(nonShareImportEntries);
        return allEntries;
    }

    private List<ImportResultEntry> overrideShareMemberBatch(List<ImportBillIndexWrap> billDataList) {
        if (CollectionUtils.isEmpty(billDataList)) {
            return Collections.emptyList();
        }
        if (billDataList.stream().anyMatch(x -> !ImportHelper.isShareType((Map<String, Object>)x.getBill().getData()))) {
            throw new IllegalStateException("current data has non share members.");
        }
        ArrayList<ImportResultEntry> importEntries = new ArrayList<ImportResultEntry>(billDataList.size());
        ArrayList validBills = new ArrayList(billDataList.size());
        billDataList.forEach(x -> {
            Optional<String> invalidMsg = this.isShareMemberValidForOverride((ImportBillIndexWrap)x);
            if (invalidMsg.isPresent()) {
                importEntries.add(new ImportResultEntry(0L, invalidMsg.get(), x.getListIndex()));
            } else {
                validBills.add(x);
            }
        });
        if (!CollectionUtils.isEmpty(validBills)) {
            List<DynamicObject> waitingImportDys;
            boolean aggStatus = ConfigServiceHelper.getBoolParam((Long)this.modelId, (String)"CM039");
            ArrayList<DynamicObject> needSyncAgg = new ArrayList<DynamicObject>(16);
            ArrayList<DynamicObject> needSyncBizRecord = new ArrayList<DynamicObject>(16);
            List<Pair<DynamicObject, DynamicObject>> originUpdatePairDys = validBills.stream().map(x -> {
                DynamicObject updateMember = BusinessDataServiceHelper.loadSingle((Object)x.getBill().getData().getLong("id"), (String)this.entityName);
                DynamicObject originDy = (DynamicObject)OrmUtils.clone((Object)updateMember, (IDataEntityType)updateMember.getDataEntityType(), (boolean)true, (boolean)false);
                if (!StorageTypeEnum.SHARE.index.equals(updateMember.getString("parent.storagetype"))) {
                    if (aggStatus && updateMember.getInt("aggoprt") != x.getBill().getData().getInteger("aggoprt").intValue()) {
                        updateMember.set("aggoprt", (Object)x.getBill().getData().getInteger("aggoprt"));
                        needSyncAgg.add(updateMember);
                    }
                    if ("bcm_entitymembertree".equals(this.entityName) && this.setBizChangeRecord((ImportBillIndexWrap)x, updateMember)) {
                        needSyncBizRecord.add(updateMember);
                    }
                }
                return new Pair((Object)originDy, (Object)updateMember);
            }).collect(Collectors.toList());
            if (!needSyncAgg.isEmpty()) {
                ShareMemberHelper.syncSameParentMembers(needSyncAgg);
            }
            if (!needSyncBizRecord.isEmpty()) {
                this.synchroBizRecords(needSyncBizRecord);
            }
            if (!CollectionUtils.isEmpty(waitingImportDys = originUpdatePairDys.stream().map(x -> (DynamicObject)x.p2).collect(Collectors.toList()))) {
                try (TXHandle tx = TX.requiresNew((String)"overrideShareMemberBatch");){
                    try {
                        PersistProxy.instance.batchSaveOrUpdate(waitingImportDys);
                    }
                    catch (Throwable e) {
                        LOG.error("dimension_import_submit share_member rollback, error:" + e.getMessage(), e);
                        tx.markRollback();
                        throw new KDBizException(e.getMessage());
                    }
                }
                if (!ImportContextHolder.isDryRun()) {
                    ImportContextHolder.getOrCreateBatchDbCacheInstance().updateMembers(waitingImportDys);
                    CommonPostImportHandler.handModifyLogAsync(originUpdatePairDys, DimMemberOperateTypeEnum.IMPORT_EDIT);
                }
            }
            for (int i = 0; i < validBills.size(); ++i) {
                DynamicObject updateDy = (DynamicObject)waitingImportDys.get(i);
                importEntries.add(ImportResultEntry.success(updateDy.getLong("id"), updateDy, ((ImportBillIndexWrap)validBills.get(i)).getListIndex()));
            }
        }
        return importEntries;
    }

    protected void synchroBizRecords(List<DynamicObject> members) {
        ArrayList updateMembers = new ArrayList(16);
        members.forEach(member -> {
            QFilter filter = new QFilter("model", "=", (Object)this.modelId);
            filter.and("number", "=", (Object)member.getString("number"));
            filter.and("parent.number", "=", (Object)member.getString("parent.number"));
            filter.and("id", "!=", (Object)member.getLong("id"));
            Set<Long> ids = QueryServiceHelper.query((String)this.entityName, (String)"id,parent.number", (QFilter[])filter.toArray()).stream().map(m -> m.getLong("id")).collect(Collectors.toSet());
            DynamicObject[] updateObj = (DynamicObject[])BusinessDataReader.load((Object[])ids.toArray(new Long[0]), (IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_entitymembertree"));
            if (updateObj == null || updateObj.length == 0) {
                return;
            }
            for (DynamicObject doc : updateObj) {
                DynamicObjectCollection bizChangeRds = member.getDynamicObjectCollection("bizchangerds");
                DynamicObjectCollection bizRecords = new DynamicObjectCollection();
                bizChangeRds.forEach(biz -> bizRecords.add((Object)((DynamicObject)OrmUtils.clone((IDataEntityBase)biz, (boolean)true, (boolean)true))));
                doc.set("bizchangerds", (Object)bizRecords);
                updateMembers.add(doc);
            }
        });
        if (!updateMembers.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])updateMembers.toArray(new DynamicObject[0]));
        }
    }

    private boolean setBizChangeRecord(ImportBillIndexWrap billIndexWrap, DynamicObject updateMember) {
        String bizRecordsFromExcel = (String)billIndexWrap.getBill().getData().get((Object)"bizchangerds");
        if (StringUtils.isNotEmpty((CharSequence)bizRecordsFromExcel)) {
            String bizRecordsStr = bizRecordsFromExcel.substring(0, bizRecordsFromExcel.length() - 1);
            String[] bizStr = bizRecordsStr.split(";\n");
            DynamicObjectCollection bizRecords = updateMember.getDynamicObjectCollection("bizchangerds");
            DynamicObjectCollection newRecords = new DynamicObjectCollection();
            for (int i = 0; i < bizStr.length; ++i) {
                String[] bizJson = bizStr[i].split("\\|");
                DynamicObject oldRecord = i < bizRecords.size() ? (DynamicObject)bizRecords.get(i) : null;
                DynamicObject bizRecordNew = oldRecord != null && oldRecord.getString("changetype").equals(bizJson[0]) ? oldRecord : new DynamicObject(bizRecords.getDynamicObjectType());
                bizRecordNew.set("changetype", (Object)bizJson[0]);
                bizRecordNew.set("bizeffdate", (Object)ImportText2DateUtils.dateStr2Date(bizJson[1]));
                if (bizJson.length > 2) {
                    bizRecordNew.set("bizexpdate", (Object)ImportText2DateUtils.dateStr2Date(bizJson[2]));
                }
                bizRecordNew.set("seq", (Object)(i + 1));
                newRecords.add((Object)bizRecordNew);
            }
            bizRecords.clear();
            bizRecords.addAll((Collection)newRecords);
        }
        return true;
    }

    private Optional<String> isShareMemberValidForOverride(ImportBillIndexWrap billIndexWrap) {
        if (!RowDataExtUtil.getExistingRecord(billIndexWrap.getBill()).isPresent()) {
            return Optional.of(ImportMsgUtils.sourceMemberNotExistOrNonShareType());
        }
        return Optional.empty();
    }

    private boolean isShareMemberDataChangedForOverride(ImportBillIndexWrap billIndexWrap) {
        DynamicObject oldRecord = RowDataExtUtil.getExistingRecord(billIndexWrap.getBill()).get();
        return billIndexWrap.getBill().getData().getInteger("aggoprt").intValue() != oldRecord.getInt("aggoprt");
    }

    private List<ImportResultEntry> overrideNonShareMemberBatch(List<ImportBillIndexWrap> billDataList) {
        if (CollectionUtils.isEmpty(billDataList)) {
            return Collections.emptyList();
        }
        if (billDataList.stream().anyMatch(x -> ImportHelper.isShareType((Map<String, Object>)x.getBill().getData()))) {
            throw new IllegalStateException("current data has share members.");
        }
        List rawOverrideEntries = BatchProcessHelper.batchHandle(billDataList, (int)2000, (int)500, this::handleAssembleOverrideMemberEntity, null, (BatchProcessHelper.Scene)BatchProcessHelper.Scene.CPU);
        List<OverrideResultEntry> needOverrideEntries = rawOverrideEntries.stream().filter(OverrideResultEntry::isNeedOverride).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(needOverrideEntries)) {
            TXHandle tx = TX.requiresNew((String)"overrideNonShareMemberBatch");
            Object object = null;
            try {
                try {
                    List<DynamicObject> overrideDys = needOverrideEntries.stream().map(OverrideResultEntry::getOverridDy).collect(Collectors.toList());
                    PersistProxy.instance.batchSaveOrUpdate(overrideDys);
                    if (ImportHelper.getNumber(this.dimension).equalsIgnoreCase("Account")) {
                        List overrideDysNumber = needOverrideEntries.stream().map(x -> x.getBillWrap().getBill().getData().get((Object)"number").toString().trim()).collect(Collectors.toList());
                        String selectFields = "id,model,accountnumber,scale";
                        QFBuilder accountQFBuilder = new QFBuilder();
                        accountQFBuilder.add(new QFilter("model", "=", (Object)this.modelId));
                        accountQFBuilder.add(new QFilter(ACCOUNTNUMBER, "in", overrideDysNumber));
                        DynamicObject[] accountscale = BusinessDataServiceHelper.load((String)"bcm_accountscale", (String)selectFields, (QFilter[])accountQFBuilder.toArray());
                        HashMap<String, Integer> accountMap = new HashMap<String, Integer>(accountscale.length);
                        for (Object account : accountscale) {
                            accountMap.put(account.getString(ACCOUNTNUMBER), account.getInt("scale"));
                        }
                        for (OverrideResultEntry overrideResultEntry : needOverrideEntries) {
                            if (overrideResultEntry.getBillWrap().getBill().getData().get((Object)ACCOUNTSCALE) == null) continue;
                            String number = overrideResultEntry.getBillWrap().getBill().getData().getString("number");
                            if (accountMap.get(number) != null) {
                                if (overrideResultEntry.getBillWrap().getBill().getData().getInteger(ACCOUNTSCALE) != null) {
                                    accountMap.replace(number, overrideResultEntry.getBillWrap().getBill().getData().getInteger(ACCOUNTSCALE));
                                    continue;
                                }
                                accountMap.replace(number, null);
                                continue;
                            }
                            if (overrideResultEntry.getBillWrap().getBill().getData().getInteger(ACCOUNTSCALE) == null) continue;
                            accountMap.put(number, overrideResultEntry.getBillWrap().getBill().getData().getInteger(ACCOUNTSCALE));
                        }
                        for (Object account : accountscale) {
                            if (accountMap.get(account.getString(ACCOUNTNUMBER)) != null) {
                                account.set("scale", accountMap.get(account.getString(ACCOUNTNUMBER)));
                                SaveServiceHelper.update((DynamicObject)account);
                                accountMap.remove(account.getString(ACCOUNTNUMBER));
                                continue;
                            }
                            QFBuilder qfBuilder = new QFBuilder();
                            qfBuilder.add(new QFilter("model", "=", (Object)this.modelId));
                            qfBuilder.add(new QFilter(ACCOUNTNUMBER, "=", (Object)account.getString(ACCOUNTNUMBER)));
                            DeleteServiceHelper.delete((String)"bcm_accountscale", (QFilter[])qfBuilder.toArray());
                        }
                        for (Map.Entry entry : accountMap.entrySet()) {
                            DynamicObject newData = BusinessDataServiceHelper.newDynamicObject((String)"bcm_accountscale");
                            newData.set("model", (Object)this.modelId);
                            newData.set(ACCOUNTNUMBER, entry.getKey());
                            newData.set("scale", entry.getValue());
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newData});
                        }
                    }
                }
                catch (Throwable e) {
                    LOG.error("dimension_import_submit nonshare_member rollback, error:" + e.getMessage(), e);
                    tx.markRollback();
                    throw new KDBizException(e.getMessage());
                }
            }
            catch (Throwable e) {
                object = e;
                throw e;
            }
            finally {
                if (tx != null) {
                    if (object != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable e) {
                            ((Throwable)object).addSuppressed(e);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            if (!ImportContextHolder.isDryRun()) {
                long upCacheTick = System.currentTimeMillis();
                ImportContextHolder.getOrCreateBatchDbCacheInstance().updateMembers(needOverrideEntries.stream().map(OverrideResultEntry::getOverridDy).collect(Collectors.toList()));
                LOG.info(this.genLogPrefix("override.nonsharemember.updateCache") + String.format("batchSize: %s, cost time: %s", needOverrideEntries.size(), System.currentTimeMillis() - upCacheTick));
            }
            if (!ImportContextHolder.isDryRun()) {
                for (IDimensionImportHandler handler : this.handlers) {
                    long handlerStartTick = System.currentTimeMillis();
                    handler.postOverride(needOverrideEntries);
                    LOG.info(this.genLogPrefix("override.handler." + handler.getClass().getSimpleName()) + String.format("log-size: %s, cost time: %s", needOverrideEntries.size(), System.currentTimeMillis() - handlerStartTick));
                }
            }
        }
        ArrayList<ImportResultEntry> importEntries = new ArrayList<ImportResultEntry>(rawOverrideEntries.size());
        for (OverrideResultEntry entry : rawOverrideEntries) {
            if (entry.isNeedOverride()) {
                DynamicObject overrideDy = entry.getOverridDy();
                importEntries.add(ImportResultEntry.success(overrideDy.getLong("id"), overrideDy, entry.getBillWrap().getListIndex()));
                continue;
            }
            importEntries.add(ImportResultEntry.error(ImportMsgUtils.currentNumberNotExists(), entry.getBillWrap().getListIndex()));
        }
        return importEntries;
    }

    private List<OverrideResultEntry> handleAssembleOverrideMemberEntity(List<ImportBillIndexWrap> billDataList) {
        ArrayList<OverrideResultEntry> rawOverrideEntries = new ArrayList<OverrideResultEntry>(billDataList.size());
        for (ImportBillIndexWrap billIndexWrap : billDataList) {
            Optional<DynamicObject> existRecordDy = RowDataExtUtil.getExistingRecord(billIndexWrap.getBill());
            if (existRecordDy.isPresent()) {
                DynamicObject partDy;
                DynamicObject existDy = BusinessDataServiceHelper.loadSingle((Object)existRecordDy.get().getLong("id"), (String)this.entityName);
                DynamicObject existRecordBak = (DynamicObject)OrmUtils.clone((Object)existDy, (IDataEntityType)existDy.getDataEntityType(), (boolean)false, (boolean)false);
                if ("bcm_accountmembertree".equals(ImportContextHolder.getEntityName()) && (partDy = existRecordBak.getDynamicObject("accountpart")) != null) {
                    DynamicObject newPartDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_structofaccountp");
                    newPartDy.set("id", partDy.get("id"));
                    newPartDy.set("isaccountoffset", partDy.get("isaccountoffset"));
                    existRecordBak.set("accountpart", (Object)newPartDy);
                }
                String oldParentNumber = this.getParentNumberByDyn(existDy);
                this.assemMemberTree(billIndexWrap.getBill(), existDy, null, false);
                this.assemEffDate(billIndexWrap.getBill(), existDy, false);
                String newParentNumber = this.getParentNumberByDyn(existDy);
                rawOverrideEntries.add(new OverrideResultEntry(billIndexWrap, oldParentNumber, newParentNumber, existRecordBak, existDy, true));
                continue;
            }
            rawOverrideEntries.add(OverrideResultEntry.isSkip(billIndexWrap));
        }
        return rawOverrideEntries;
    }

    public void assemMemberTree(ImportBillData bill, DynamicObject memberTreeDy, DynamicObject memberDy, boolean isNew) {
        JSONObject data = bill.getData();
        if (data.get("name") != null) {
            memberTreeDy.set("name", data.get("name"));
        }
        if (memberDy != null) {
            memberTreeDy.set("member", (Object)memberDy);
        }
        if (data.get("simplename") != null) {
            memberTreeDy.set("simplename", data.get("simplename"));
        }
        DynamicObject parent = RowDataExtUtil.getParent(bill).get();
        Object aggoprt = data.get("aggoprt");
        long parentId = parent.getLong("id");
        int parentLevel = parent.getInt("level");
        String parentLongNum = parent.getString("longnumber");
        Optional<DynamicObject> existingDy = RowDataExtUtil.getExistingRecord(bill);
        if (existingDy.isPresent()) {
            int storageType = data.get("storagetype") == null ? 2 : Integer.parseInt(data.get("storagetype").toString());
            memberTreeDy.set("parent", (Object)parentId);
            memberTreeDy.set("storagetype", (Object)storageType);
            if (storageType == 3) {
                this.assemByBaseMember(memberTreeDy, (String)data.get("number"));
            } else {
                this.assemBySpecialExcel(bill, memberTreeDy);
            }
            if (aggoprt == null) {
                aggoprt = existingDy.get().get("aggoprt");
            }
            memberTreeDy.set("level", (Object)(parentLevel + 1));
            memberTreeDy.set("longnumber", (Object)(parentLongNum + '!' + data.get("number")));
            this.setShieldRuleProperty(memberTreeDy, bill, storageType);
        } else {
            memberTreeDy.set("id", (Object)RowDataExtUtil.getId(bill));
            memberTreeDy.set("parent", (Object)parentId);
            memberTreeDy.set("storagetype", (Object)(data.get("storagetype") == null ? Integer.valueOf(2) : data.get("storagetype")));
            if (Objects.isNull(parentLevel)) {
                DynamicObject dy = PersistProxy.instance.getById(parentId, false);
                parent.set("level", (Object)dy.getString("level"));
                parent.set("longnumber", (Object)dy.getString("longnumber"));
            }
            memberTreeDy.set("level", (Object)(parentLevel + 1));
            memberTreeDy.set("isleaf", (Object)true);
            memberTreeDy.set("longnumber", (Object)(parentLongNum + '!' + data.get("number")));
            if (ImportHelper.isShareType((Map<String, Object>)data)) {
                DynamicObject existingStoreData = PersistProxy.instance.getNonShareMember(ImportHelper.getNumber(memberTreeDy), false).get();
                this.assemBySpecialExcelForShareMember(existingStoreData, memberTreeDy);
            } else {
                this.assemBySpecialExcel(bill, memberTreeDy);
            }
            if (aggoprt == null) {
                aggoprt = 1;
            }
        }
        boolean updateAgg = ConfigServiceHelper.getBoolParam((Long)this.modelId, (String)"CM039");
        if (aggoprt != null && (updateAgg || !existingDy.isPresent())) {
            memberTreeDy.set("aggoprt", aggoprt);
        }
        Map<String, Pair<Integer, Long>> definedPropSeqIdMap = RowDataExtUtil.getDefinedProps(bill);
        for (Map.Entry<String, Pair<Integer, Long>> seqIdEntry : definedPropSeqIdMap.entrySet()) {
            Integer seq = (Integer)seqIdEntry.getValue().p1;
            Long propValueId = (Long)seqIdEntry.getValue().p2;
            memberTreeDy.set("dpropertyid" + seq, (Object)propValueId);
        }
    }

    protected void setShieldRuleProperty(DynamicObject memberTreeDy, ImportBillData bill, int storageType) {
        if (ImportContextHolder.isDryRun()) {
            return;
        }
        boolean hasColOfShieldDim = bill.getEntityMapping().getCols().containsKey("shielddim");
        if (!hasColOfShieldDim) {
            return;
        }
        Object excelShieldDim = bill.getData().get((Object)"shielddim");
        this.saveShieldRule(String.valueOf(this.modelId), this.dimensionId, String.valueOf(storageType), excelShieldDim, memberTreeDy.getLong("id"));
    }

    protected void saveShieldRule(String modelId, long dimId, String storageType, Object shielddim, long memberId) {
        if (StorageTypeEnum.STORAGE.index.equals(storageType) || StorageTypeEnum.UNSHARE.index.equals(storageType)) {
            ShieldRuleBulider srb = new ShieldRuleBulider((Object)modelId);
            long srId = 0L;
            if (shielddim != null) {
                Set<String> shieldDimSet = ShieldRuleContentValidator.excelDimsFormatFilter(shielddim, modelId, dimId);
                if (shieldDimSet.size() > 0) {
                    String shields = String.join((CharSequence)",", shieldDimSet);
                    srId = srb.getShieldRule((Object)this.dimensionId, shields);
                }
                srb.save(dimId, memberId, srId);
            }
        }
    }

    private void assemCopyfrom(ImportBillData bill, DynamicObject memberTreeDy) {
        Optional<DynamicObject> existingMemberOpt;
        if (ImportHelper.isShareType((Map<String, Object>)bill.getData()) && (existingMemberOpt = PersistProxy.instance.getNonShareMember(ImportHelper.getNumber(memberTreeDy), false)).isPresent()) {
            memberTreeDy.set("copyfrom", (Object)existingMemberOpt.get().getLong("id"));
            memberTreeDy.set("name", (Object)existingMemberOpt.get().getString("name"));
            if ("bcm_entitymembertree".equals(ImportContextHolder.getEntityName())) {
                memberTreeDy.set("isindependentorg", (Object)existingMemberOpt.get().getString("isindependentorg"));
            }
        }
    }

    public abstract void assemByBaseMember(DynamicObject var1, String var2);

    public void assemBySpecialExcel(ImportBillData bill, DynamicObject memberTreeDy) {
        if (bill.getData().keySet().contains("description")) {
            memberTreeDy.set("description", bill.getData().get((Object)"description"));
        }
        if (memberTreeDy.getLong("id") == 0L) {
            memberTreeDy.set("issysmember", (Object)DimMemTypeEnum.IMPORTMEM.getIndex());
        }
        memberTreeDy.set("modifier", (Object)RequestContext.get().getUserId());
    }

    public abstract void assemBySpecialExcelForShareMember(DynamicObject var1, DynamicObject var2);

    public void assemMemberDySysField(Map<String, Object> data, DynamicObject memberDy) {
        memberDy.set("id", (Object)DBServiceHelper.genGlobalLongId());
        memberDy.set("number", data.get("number"));
        memberDy.set("name", data.get("name"));
        memberDy.set("model", (Object)this.modelId);
        memberDy.set("dimension", (Object)this.dimensionId);
        DimensionServiceHelper.initCommonDyObject((DynamicObject)memberDy);
    }

    private String getParentNumberByDyn(DynamicObject dy) {
        String oldLongNumber = dy.getString("longnumber");
        String[] split = oldLongNumber.split("!");
        return split[split.length - 2];
    }

    public void assemEffDate(ImportBillData bill, DynamicObject treeMem, boolean isInit) {
    }

    public static void setEnPartValue(String entityName, DynamicObject memberTreeDy) {
        if ("bcm_entitymembertree".equals(entityName)) {
            Long id = DBServiceHelper.genGlobalLongId();
            if (!ImportContextHolder.isDryRun()) {
                DynamicObject part = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymemberpart");
                part.set("id", (Object)id);
                part.set("mergernode", (Object)0);
                part.set("isoffsetentry", (Object)0);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{part});
            }
            memberTreeDy.set("entitypart", (Object)id);
        }
    }

    public abstract String getMemberName();

    public String genLogPrefix(String operationName) {
        return String.format("dimension_import:: entity: %s, batch: %s, operate: %s", this.entityName, this.curBatch, operationName);
    }

    @Override
    @Deprecated
    public void writeLog(String opName, String opDescriotion) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)opName, (String)opDescriotion, (Long)this.modelId, (String)this.dimension.getString("membermodel"));
        logService.addLog(logInfo);
    }

    @Override
    public String getBizEntityNumber() {
        return null;
    }

    @Override
    public String getBizAppId() {
        return null;
    }

    protected void setAssoValue(ImportBillData bill, DynamicObject memberTreeDy) {
        memberTreeDy.set("assostoremem", null);
        Optional<DynamicObject> assoDy = RowDataExtUtil.getAssoDy(bill);
        if (assoDy.isPresent()) {
            memberTreeDy.set("assostoremem", (Object)assoDy.get());
        }
    }

    public static void batchSetEnPartValue(String entityName, List<DynamicObject> memberTreeDys) {
        if ("bcm_entitymembertree".equals(entityName)) {
            long[] ids = GlobalIdUtil.genGlobalLongIds((int)memberTreeDys.size());
            ArrayList<DynamicObject> orgParts = new ArrayList<DynamicObject>(memberTreeDys.size());
            for (int i = 0; i < memberTreeDys.size(); ++i) {
                if (ImportContextHolder.isDryRun()) continue;
                DynamicObject part = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymemberpart");
                part.set("id", (Object)ids[i]);
                part.set("mergernode", (Object)0);
                part.set("isoffsetentry", (Object)0);
                orgParts.add(part);
                memberTreeDys.get(i).set("entitypart", (Object)ids[i]);
            }
            if (orgParts.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])orgParts.toArray(new DynamicObject[0]));
            }
        }
    }
}

