/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.enums.AccountTypeEnum;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.dimension.batchimp.AbstractDimensionBatchImport;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.DimensionImportContext;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.IDimensionImportValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.account.AccountChangeRecordInputFormatValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.account.DimensionEffectiveCombinationValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.account.DynamicAccountIllegalValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.account.ScaleValueValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.account.StorageValueValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.AssoStorageValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.EnumAndDataTypeValidator;

public class AccountDimensionBatchImport
extends AbstractDimensionBatchImport {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(AccountDimensionBatchImport.class);

    @Override
    protected void customizeValidators(DimensionImportContext context, List<IDimensionImportValidator> existingValidators) {
        existingValidators.add(new EnumAndDataTypeValidator());
        existingValidators.add(new DynamicAccountIllegalValidator());
        existingValidators.add(new StorageValueValidator());
        existingValidators.add(new DimensionEffectiveCombinationValidator());
        existingValidators.add(new AccountChangeRecordInputFormatValidator());
        existingValidators.add(new ScaleValueValidator());
        existingValidators.add(new AssoStorageValidator());
    }

    @Override
    public void assemByBaseMember(DynamicObject memberTreeDy, String memberEntityNumber) {
    }

    @Override
    public void assemMemberTree(ImportBillData bill, DynamicObject memberTreeDy, DynamicObject memberDy, boolean isNew) {
        super.assemMemberTree(bill, memberTreeDy, memberDy, isNew);
    }

    @Override
    public void assemBySpecialExcel(ImportBillData bill, DynamicObject memberTreeDy) {
        super.assemBySpecialExcel(bill, memberTreeDy);
        JSONObject data = bill.getData();
        Set keySet = data.keySet();
        if (keySet.contains("simplename")) {
            memberTreeDy.set("simplename", data.get("simplename"));
        }
        memberTreeDy.set("accountuse", (Object)(data.get("accountuse") == null ? Integer.valueOf(1) : data.get("accountuse")));
        memberTreeDy.set("accounttype", (Object)(data.get("accounttype") == null ? Integer.valueOf(1) : data.get("accounttype")));
        this.dealDmEntry((Map<String, Object>)data, memberTreeDy);
        memberTreeDy.set("iscaltype", (Object)(data.get("iscaltype") == null ? 0 : ((Boolean)data.get("iscaltype") != false ? 1 : 0)));
        Integer drcrdirect = null;
        Integer exchange = null;
        if (data.get("drcrdirect") == null || data.get("exchange") == null) {
            String accounttype = memberTreeDy.getString("accounttype");
            if (accounttype.equals(AccountTypeEnum.DEBT.index) || accounttype.equals(AccountTypeEnum.RIGHTS.index) || accounttype.equals(AccountTypeEnum.LOSS.index)) {
                drcrdirect = 2;
                exchange = accounttype.equals(AccountTypeEnum.DEBT.index) ? 1 : 2;
            } else if (accounttype.equals(AccountTypeEnum.EXCHANGERATE.index)) {
                drcrdirect = 0;
                exchange = 0;
            } else {
                drcrdirect = 1;
                exchange = accounttype.equals(AccountTypeEnum.ASSET.index) ? 1 : (accounttype.equals(AccountTypeEnum.CASHFLOW.index) ? 2 : 0);
            }
        }
        memberTreeDy.set("drcrdirect", (Object)(data.get("drcrdirect") == null ? drcrdirect : data.get("drcrdirect")));
        memberTreeDy.set("datatype", (Object)(data.get("datatype") == null ? DataTypeEnum.DEFAULT.index : data.get("datatype")));
        memberTreeDy.set("value", RowDataExtUtil.getValue(bill));
        memberTreeDy.set("enumitem", RowDataExtUtil.getValue(bill));
        memberTreeDy.set("exchange", (Object)(data.get("exchange") == null ? exchange : data.get("exchange")));
        memberTreeDy.set("isparticipmerge", (Object)(data.get("isparticipmerge") == null ? Boolean.valueOf(true) : data.get("isparticipmerge")));
        memberTreeDy.set("isrelateorg", (Object)(data.get("isrelateorg") == null ? Boolean.valueOf(false) : data.get("isrelateorg")));
        memberTreeDy.set("isyearendcarried", (Object)(data.get("isyearendcarried") == null ? Boolean.valueOf(false) : data.get("isyearendcarried")));
        memberTreeDy.set("entryrate", (Object)(data.get("entryrate") == null ? "1" : data.get("entryrate")));
        if (!ImportContextHolder.isDryRun()) {
            boolean userDefinedIsAccountOffset = ImportHelper.getImportBillBooleanProp(bill, "isaccountoffset");
            DynamicObject accountPartDy = memberTreeDy.getDynamicObject("accountpart");
            if (Objects.isNull(accountPartDy)) {
                DynamicObject newPart = this.createNewAccountPart(userDefinedIsAccountOffset);
                memberTreeDy.set("accountpart", (Object)newPart);
            } else {
                accountPartDy.set("isaccountoffset", (Object)userDefinedIsAccountOffset);
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{accountPartDy});
            }
        }
        this.setAssoValue(bill, memberTreeDy);
        memberTreeDy.set("status", (Object)"C");
        memberTreeDy.set("enable", (Object)"1");
    }

    private DynamicObject createNewAccountPart(boolean userDefinedIsAccountOffset) {
        DynamicObject newPartDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_structofaccountp");
        newPartDy.set("id", (Object)DBServiceHelper.genGlobalLongId());
        newPartDy.set("isaccountoffset", (Object)userDefinedIsAccountOffset);
        DynamicObject part = (DynamicObject)SaveServiceHelper.save((IDataEntityType)newPartDy.getDynamicObjectType(), (Object[])new DynamicObject[]{newPartDy})[0];
        return part;
    }

    @Override
    public void assemBySpecialExcelForShareMember(DynamicObject existingStoreMemTree, DynamicObject currentMemTreeDy) {
        currentMemTreeDy.set("simplename", existingStoreMemTree.get("simplename"));
        currentMemTreeDy.set("accountuse", existingStoreMemTree.get("accountuse"));
        currentMemTreeDy.set("accounttype", existingStoreMemTree.get("accounttype"));
        currentMemTreeDy.set("iscaltype", existingStoreMemTree.get("iscaltype"));
        currentMemTreeDy.set("drcrdirect", existingStoreMemTree.get("drcrdirect"));
        currentMemTreeDy.set("datatype", existingStoreMemTree.get("datatype"));
        currentMemTreeDy.set("value", existingStoreMemTree.get("value"));
        currentMemTreeDy.set("enumitem", existingStoreMemTree.get("value"));
        currentMemTreeDy.set("exchange", existingStoreMemTree.get("exchange"));
        currentMemTreeDy.set("isparticipmerge", existingStoreMemTree.get("isparticipmerge"));
        currentMemTreeDy.set("isrelateorg", existingStoreMemTree.get("isrelateorg"));
        currentMemTreeDy.set("isyearendcarried", existingStoreMemTree.get("isyearendcarried"));
        currentMemTreeDy.set("description", existingStoreMemTree.get("description"));
        currentMemTreeDy.set("isaccountoffset", existingStoreMemTree.get("isaccountoffset"));
        currentMemTreeDy.set("accountpart", existingStoreMemTree.get("accountpart"));
        currentMemTreeDy.set("entryrate", existingStoreMemTree.get("entryrate"));
        ImportHelper.syncDimmEffectiveSetting(existingStoreMemTree.getDynamicObjectCollection("dm_entry"), currentMemTreeDy);
        currentMemTreeDy.set("status", (Object)"C");
        currentMemTreeDy.set("enable", (Object)"1");
        currentMemTreeDy.set("issysmember", (Object)2);
    }

    private void dealDmEntry(Map<String, Object> data, DynamicObject memberTreeDy) {
        DynamicObjectCollection dynamicObjectCollection = memberTreeDy.getDynamicObjectCollection("dm_entry");
        dynamicObjectCollection.clear();
        List dynamicObjects = (List)data.get("existingDmEntry");
        if (dynamicObjects != null && dynamicObjects.size() != 0) {
            for (Map sing : dynamicObjects) {
                DynamicObject dynamicObject = dynamicObjectCollection.addNew();
                dynamicObject.set("dm_val", sing.get("dm_val"));
                dynamicObject.set("dm_dim", sing.get("dm_dim"));
                if (!dynamicObject.getDataEntityType().getProperties().containsKey((Object)"seq")) continue;
                dynamicObject.set("seq", sing.get("seq"));
            }
        }
    }

    @Override
    public String getMemberName() {
        return "bcm_accountmember";
    }
}

