/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.dimension.batchimp.AbstractDimensionBatchImport;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.DimensionImportContext;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.IDimensionImportValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.changetype.NewMemberValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.DataFromValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.EnumAndDataTypeValidator;

public class ChangeTypeDimensionBatchImport
extends AbstractDimensionBatchImport {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(ChangeTypeDimensionBatchImport.class);

    @Override
    protected void customizeValidators(DimensionImportContext context, List<IDimensionImportValidator> existingValidators) {
        existingValidators.add(new NewMemberValidator());
        existingValidators.add(new EnumAndDataTypeValidator());
        existingValidators.add(new DataFromValidator());
    }

    @Override
    public void assemByBaseMember(DynamicObject memberTreeDy, String memberEntityNumber) {
    }

    @Override
    public void assemBySpecialExcel(ImportBillData bill, DynamicObject memberTreeDy) {
        super.assemBySpecialExcel(bill, memberTreeDy);
        JSONObject data = bill.getData();
        Set keySet = data.keySet();
        if (keySet.contains("simplename")) {
            memberTreeDy.set("simplename", data.get("simplename"));
        }
        memberTreeDy.set("changeway", (Object)(Objects.isNull(data.get("changeway")) ? Integer.valueOf(4) : data.get("changeway")));
        memberTreeDy.set("datatype", (Object)(Objects.isNull(data.get("datatype")) ? DataTypeEnum.DEFAULT.index : data.get("datatype")));
        memberTreeDy.set("isyearendchargeagaint", (Object)(Objects.isNull(data.get("isyearendchargeagaint")) ? Boolean.valueOf(false) : data.get("isyearendchargeagaint")));
        memberTreeDy.set("ismerge", (Object)(Objects.isNull(data.get("ismerge")) ? Boolean.valueOf(false) : data.get("ismerge")));
        memberTreeDy.set("isexchange", (Object)(Objects.isNull(data.get("isexchange")) ? Boolean.valueOf(false) : data.get("isexchange")));
        memberTreeDy.set("enumitem", RowDataExtUtil.getValue(bill));
        memberTreeDy.set("value", RowDataExtUtil.getValue(bill));
        memberTreeDy.set("status", (Object)"C");
        memberTreeDy.set("enable", (Object)"1");
    }

    @Override
    public void assemBySpecialExcelForShareMember(DynamicObject existingStoreMemTree, DynamicObject currentMemTreeDy) {
        currentMemTreeDy.set("simplename", existingStoreMemTree.get("simplename"));
        currentMemTreeDy.set("changeway", existingStoreMemTree.get("changeway"));
        currentMemTreeDy.set("datatype", existingStoreMemTree.get("datatype"));
        currentMemTreeDy.set("isyearendchargeagaint", existingStoreMemTree.get("isyearendchargeagaint"));
        currentMemTreeDy.set("description", existingStoreMemTree.get("description"));
        currentMemTreeDy.set("status", (Object)"C");
        currentMemTreeDy.set("enable", (Object)"1");
        currentMemTreeDy.set("issysmember", (Object)2);
        currentMemTreeDy.set("value", existingStoreMemTree.get("value"));
        currentMemTreeDy.set("enumitem", existingStoreMemTree.get("value"));
    }

    @Override
    public String getMemberName() {
        return "bcm_changetypemember";
    }

    @Override
    public void assemMemberTree(ImportBillData bill, DynamicObject memberTreeDy, DynamicObject memberDy, boolean isNew) {
        super.assemMemberTree(bill, memberTreeDy, memberDy, isNew);
        Optional<DynamicObject> existingDy = RowDataExtUtil.getExistingRecord(bill);
        if (ConfigServiceHelper.getBoolParam((Long)ImportContextHolder.getModelId(), (String)"isCusConfigDataFromOfCT")) {
            memberTreeDy.set("datafromnum", bill.getData().get((Object)"datafromnum"));
        } else if (Objects.isNull(bill.getData().get((Object)"datafrom"))) {
            if (!existingDy.isPresent()) {
                memberTreeDy.set("datafrom", (Object)"0");
            }
        } else {
            memberTreeDy.set("datafrom", bill.getData().get((Object)"datafrom"));
        }
    }
}

