/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.dimension.batchimp.AbstractDimensionBatchImport;
import kd.fi.bcm.formplugin.dimension.batchimp.handlers.CurrencyPostImportHandler;
import kd.fi.bcm.formplugin.dimension.batchimp.handlers.IDimensionImportHandler;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.DimensionImportContext;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.IDimensionImportValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.ParentNumberExistAndSetValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.currency.IsNotSystemCurrencyValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.currency.UnifyParentCurrencyValidator;

public class CurrencyDimensionBatchImport
extends AbstractDimensionBatchImport {
    @Override
    protected void customizeValidators(DimensionImportContext context, List<IDimensionImportValidator> existingValidators) {
        existingValidators.removeIf(x -> ParentNumberExistAndSetValidator.class.equals(x.getClass()));
        existingValidators.add(new UnifyParentCurrencyValidator());
        existingValidators.add(new IsNotSystemCurrencyValidator());
    }

    @Override
    protected void customizeHandlers(DimensionImportContext context, List<IDimensionImportHandler> existingHandlers) {
        existingHandlers.add(new CurrencyPostImportHandler(context));
    }

    @Override
    public void assemMemberTree(ImportBillData bill, DynamicObject memberTreeDy, DynamicObject memberDy, boolean isNew) {
        super.assemMemberTree(bill, memberTreeDy, memberDy, isNew);
        QFBuilder qfBuilder = new QFBuilder("number", "=", (Object)bill.getData().getString("number"));
        DynamicObject curr = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"id,name", (QFilter[])qfBuilder.toArray());
        memberTreeDy.set("name", (Object)curr.getString("name"));
    }

    @Override
    public void assemByBaseMember(DynamicObject memberTreeDy, String memberEntityNumber) {
    }

    @Override
    public void assemBySpecialExcel(ImportBillData bill, DynamicObject memberTreeDy) {
        super.assemBySpecialExcel(bill, memberTreeDy);
        JSONObject data = bill.getData();
        Set keySet = data.keySet();
        memberTreeDy.set("status", (Object)"C");
        memberTreeDy.set("enable", (Object)"1");
    }

    @Override
    public void assemBySpecialExcelForShareMember(DynamicObject existingStoreMemTree, DynamicObject currentMemTreeDy) {
        currentMemTreeDy.set("name", existingStoreMemTree.get("name"));
        currentMemTreeDy.set("description", existingStoreMemTree.get("description"));
        currentMemTreeDy.set("issysmember", existingStoreMemTree.get("issysmember"));
        currentMemTreeDy.set("status", (Object)"C");
        currentMemTreeDy.set("enable", (Object)"1");
    }

    @Override
    public String getMemberName() {
        return "bcm_currencymember";
    }
}

