/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.mq.consumer.MQMessagePublisherServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.AbstractDimensionBatchImport;
import kd.fi.bcm.formplugin.dimension.batchimp.handlers.CommonPostImportHandler;
import kd.fi.bcm.formplugin.dimension.batchimp.handlers.PermClassImportHandler;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.BatchImportReadOnlyCache;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.DimensionImportContext;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.SilentJSONUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.PersistProxy;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.IDimensionImportValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.CheckFieldNullValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.LastLogicValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.MemberNumExistValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.ModelAndDimensionConsistentValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.NonShareMemberValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.ParentNumberExistAndSetValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.PropertyValueValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.SupportValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.SystemMemberValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.extend.ExtendsCommonValidator;

public class ExtEntityDimensionBatchImport
extends AbstractDimensionBatchImport {
    @Override
    public void beforeImport() {
        super.beforeImport();
        this.initImportContext();
    }

    @Override
    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        super.setContext(rc, ctx, startArgs);
        String keyFields = (String)ctx.getOption().get("KeyFields");
        if (Objects.nonNull(keyFields) && !keyFields.contains("number")) {
            throw new KDBizException(ImportMsgUtils.onlySupportNumberAsUniqueKey());
        }
        this.entityName = "bcm_structofextend";
        return this;
    }

    @Override
    protected void customizeValidators(DimensionImportContext context, List<IDimensionImportValidator> existingValidators) {
    }

    @Override
    public void assemByBaseMember(DynamicObject memberTreeDy, String memberEntityNumber) {
    }

    @Override
    public void assemBySpecialExcel(ImportBillData bill, DynamicObject memberTreeDy) {
        super.assemBySpecialExcel(bill, memberTreeDy);
        memberTreeDy.set("status", (Object)"C");
        memberTreeDy.set("enable", (Object)"1");
    }

    @Override
    public void assemBySpecialExcelForShareMember(DynamicObject existingStoreMemTree, DynamicObject currentMemTreeDy) {
        currentMemTreeDy.set("status", (Object)"C");
        currentMemTreeDy.set("enable", (Object)"1");
        currentMemTreeDy.set("issysmember", existingStoreMemTree.get("issysmember"));
    }

    @Override
    public String getMemberName() {
        return "bcm_membofextend";
    }

    @Override
    public void initImportContext() {
        if (Objects.isNull(this.model)) {
            this.model = this.getCurrentModel();
            if (Objects.isNull(this.model)) {
                throw new KDBizException(ImportMsgUtils.specificModelFirst(), new Object[0]);
            }
            this.modelId = this.model.getLong("id");
        }
        if (Objects.isNull(this.dimension)) {
            this.dimension = this.getCurrentDimension();
            if (Objects.isNull(this.dimension)) {
                throw new KDBizException(ImportMsgUtils.specificDimensionFirst(), new Object[0]);
            }
            this.dimensionId = this.dimension.getLong("id");
        }
        DimensionImportContext context = new DimensionImportContext(this.model, this.dimension, this.entityName, ImportHelper.getImportType(this.ctx), this.appId, this.isModelManager, this.newMembNums, null);
        ImportContextHolder.setImportContext(context);
        this.validators = new ArrayList(10);
        this.validators.add(new MemberNumExistValidator());
        this.validators.add(new SupportValidator());
        this.validators.add(new ModelAndDimensionConsistentValidator());
        this.validators.add(new ParentNumberExistAndSetValidator());
        this.validators.add(new CheckFieldNullValidator());
        this.validators.add(new SystemMemberValidator());
        this.validators.add(new NonShareMemberValidator());
        this.validators.add(new LastLogicValidator());
        this.validators.add(new PropertyValueValidator());
        this.validators.add(new ExtendsCommonValidator());
        this.customizeValidators(context, this.validators);
        this.validators.sort((o1, o2) -> o2.getWeight() - o1.getWeight());
        this.handlers = new ArrayList(5);
        this.handlers.add(new CommonPostImportHandler(context));
        this.handlers.add(new PermClassImportHandler(context));
        this.customizeHandlers(context, this.handlers);
        BatchProcessHelper.handleAsync(PersistProxy.instance::preInitData);
    }

    private DynamicObject getCurrentDimension() {
        Long importDimensionId = (Long)this.ctx.getOption().get("BcmDimensionId");
        if (Objects.isNull(importDimensionId) || importDimensionId == 0L) {
            throw new KDBizException(ImportMsgUtils.specificDimensionFirst(), new Object[0]);
        }
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_dimension_ext", (String)"id,number,name", (QFilter[])new QFilter("id", "=", (Object)importDimensionId).toArray());
    }

    @Override
    public void assemMemberTree(ImportBillData bill, DynamicObject memberTreeDy, DynamicObject memberDy, boolean isNew) {
        DynamicObject existingStoreData;
        DynamicObject dynamicObject;
        String enumName;
        JSONObject data = bill.getData();
        if (data.get("name") != null) {
            memberTreeDy.set("name", data.get("name"));
        }
        if (memberDy != null) {
            memberTreeDy.set("member", (Object)memberDy);
        }
        Long dimId = ImportContextHolder.getImportContext().getImportDimension().getLong("id");
        DynamicObject parent = RowDataExtUtil.getParent(bill).get();
        long parentId = parent.getLong("id");
        int parentLevel = parent.getInt("level");
        String parentLongNum = parent.getString("longnumber");
        Optional<DynamicObject> existingDy = RowDataExtUtil.getExistingRecord(bill);
        Object cache = ThreadCache.get((Object)dimId);
        if (existingDy.isPresent()) {
            memberTreeDy.set("parent", (Object)parentId);
            memberTreeDy.set("level", (Object)(parentLevel + 1));
            memberTreeDy.set("longnumber", (Object)(parentLongNum + '!' + data.get("number")));
            memberTreeDy.set("datatype", data.get("datatype"));
            memberTreeDy.set("description", data.get("description"));
            memberTreeDy.set("simplename", data.get("simplename"));
            if (1 == parentLevel) {
                memberTreeDy.set("storagetype", (Object)(data.get("storagetype") == null ? Integer.valueOf(1) : data.get("storagetype")));
                memberTreeDy.set("grouptype", data.get("grouptype"));
                memberTreeDy.set("isparticipmerge", data.get("isparticipmerge"));
                memberTreeDy.set("isaccountoffset", data.get("isaccountoffset"));
            } else if (2 == parentLevel) {
                String fieldmapped;
                memberTreeDy.set("storagetype", (Object)(data.get("storagetype") == null ? Integer.valueOf(2) : data.get("storagetype")));
                memberTreeDy.set("exchange", (Object)(data.get("exchange") == null ? "1" : data.get("exchange")));
                memberTreeDy.set("entryrate", (Object)(data.get("entryrate") == null ? "1" : data.get("entryrate")));
                if ("6".equals(data.get("datatype")) && data.get("enumitem") != null) {
                    enumName = SilentJSONUtils.cast(data.get("enumitem").toString(), LinkedHashMap.class).get("name").toString();
                    dynamicObject = BatchImportReadOnlyCache.getEnumItem(enumName, dimId);
                    memberTreeDy.set("enumitem", (Object)dynamicObject.getLong("id"));
                }
                if (cache != null && StringUtils.isNotEmpty((CharSequence)(fieldmapped = (String)((Map)cache).get(memberTreeDy.getLong("id"))))) {
                    memberTreeDy.set("fieldmapped", (Object)fieldmapped);
                }
            }
            if (ImportHelper.isShareType((Map<String, Object>)data)) {
                existingStoreData = PersistProxy.instance.getNonShareMember(ImportHelper.getNumber(memberTreeDy), false).get();
                this.assemBySpecialExcelForShareMember(existingStoreData, memberTreeDy);
            } else {
                this.assemBySpecialExcel(bill, memberTreeDy);
            }
        } else {
            memberTreeDy.set("id", (Object)RowDataExtUtil.getId(bill));
            memberTreeDy.set("parent", (Object)parentId);
            memberTreeDy.set("level", (Object)(parentLevel + 1));
            memberTreeDy.set("isleaf", (Object)true);
            memberTreeDy.set("longnumber", (Object)(parentLongNum + '!' + data.get("number")));
            memberTreeDy.set("datatype", data.get("datatype"));
            memberTreeDy.set("description", data.get("description"));
            memberTreeDy.set("simplename", data.get("simplename"));
            if (1 == parentLevel) {
                memberTreeDy.set("storagetype", (Object)(data.get("storagetype") == null ? Integer.valueOf(1) : data.get("storagetype")));
                memberTreeDy.set("grouptype", data.get("grouptype"));
                memberTreeDy.set("isparticipmerge", data.get("isparticipmerge"));
                memberTreeDy.set("isaccountoffset", data.get("isaccountoffset"));
            } else if (2 == parentLevel) {
                memberTreeDy.set("storagetype", (Object)(data.get("storagetype") == null ? Integer.valueOf(2) : data.get("storagetype")));
                memberTreeDy.set("exchange", (Object)(data.get("exchange") == null ? "1" : data.get("exchange")));
                memberTreeDy.set("entryrate", (Object)(data.get("entryrate") == null ? "1" : data.get("entryrate")));
                if (cache != null) {
                    memberTreeDy.set("fieldmapped", ((Map)cache).get(memberTreeDy.getLong("id")));
                }
                if ("6".equals(data.get("datatype")) && data.get("enumitem") != null) {
                    enumName = SilentJSONUtils.cast(data.get("enumitem").toString(), LinkedHashMap.class).get("name").toString();
                    dynamicObject = BatchImportReadOnlyCache.getEnumItem(enumName, dimId);
                    memberTreeDy.set("enumitem", (Object)dynamicObject.getLong("id"));
                }
            }
            if (ImportHelper.isShareType((Map<String, Object>)data)) {
                existingStoreData = PersistProxy.instance.getNonShareMember(ImportHelper.getNumber(memberTreeDy), false).get();
                this.assemBySpecialExcelForShareMember(existingStoreData, memberTreeDy);
            } else {
                this.assemBySpecialExcel(bill, memberTreeDy);
            }
        }
        Map<String, Pair<Integer, Long>> definedPropSeqIdMap = RowDataExtUtil.getDefinedProps(bill);
        for (Map.Entry<String, Pair<Integer, Long>> seqIdEntry : definedPropSeqIdMap.entrySet()) {
            Integer seq = (Integer)seqIdEntry.getValue().p1;
            Long propValueId = (Long)seqIdEntry.getValue().p2;
            memberTreeDy.set("dpropertyid" + seq, (Object)propValueId);
        }
        this.setAssoDimMember((Map<String, Object>)data, memberTreeDy);
    }

    private void setAssoDimMember(Map<String, Object> data, DynamicObject memberTreeDy) {
        Object assodimmemberObj = data.get("assodimmember");
        if (!Objects.isNull(assodimmemberObj)) {
            List assodimmember = (List)assodimmemberObj;
            DynamicObjectCollection entryentityasso = memberTreeDy.getDynamicObjectCollection("entryentityasso");
            DynamicObjectType entryDyType = entryentityasso.getDynamicObjectType();
            entryentityasso.clear();
            ArrayList<DynamicObject> entryDys = new ArrayList<DynamicObject>(10);
            int seq = 1;
            for (Map map : assodimmember) {
                DynamicObject entryDy = new DynamicObject(entryDyType);
                entryDy.set("assodim", map.get("dimId"));
                entryDy.set("assomem", map.get("id"));
                String pid = (String)map.get("pid");
                entryDy.set("dproperty", (Object)(StringUtils.isEmpty((CharSequence)pid) ? Integer.valueOf(0) : (Serializable)map.get("pid")));
                entryDy.set("scope", map.get("scope"));
                entryDy.set("subtype", (Object)(StringUtils.isEmpty((CharSequence)pid) ? "0" : "1"));
                entryDy.set("seq", (Object)seq);
                entryDys.add(entryDy);
                ++seq;
            }
            entryentityasso.addAll(entryDys);
        }
    }

    @Override
    protected void afterImport() {
        super.afterImport();
        MQMessagePublisherServiceHelper.publishClearDimMemberCache((String)MemberReader.findModelNumberById((Object)this.modelId), (String)"bcm_structofextend");
    }
}

