/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp;

import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionEditHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.DynamicComputingServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.AggOprtEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.OrgBizChangeTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.AbstractDimensionBatchImport;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.BatchImportReadOnlyCache;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.DimensionImportContext;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportResultEntry;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportText2DateUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.PersistProxy;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.IDimensionImportValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.ParentNumberExistAndSetValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.org.CslSchemeValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.org.CtrlOrgValidators;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.org.EffDateValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.org.InjectOrgCurrencyNumberValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.org.InnerOrgValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.org.NumberStyleValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.org.OrgChangeRecordInputFormatValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.org.OrgCheckParentNumberValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.org.OrgNullFieldValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.org.RootICMemberValidator;
import kd.fi.bcm.formplugin.dimension.util.DimensionUtil;
import kd.fi.bcm.spread.common.util.DateTimeUtils;

public class OrgDimensionBatchImport
extends AbstractDimensionBatchImport {
    private long rptCslSchemeId = 0L;
    private long icParentId = 0L;
    private long mcParentId = 0L;
    private int icMaxSeq = 0;
    private int mcMaxSeq = 0;

    @Override
    protected void customizeValidators(DimensionImportContext context, List<IDimensionImportValidator> existingValidators) {
        existingValidators.add(new OrgNullFieldValidator());
        existingValidators.add(new CslSchemeValidator());
        existingValidators.removeIf(x -> ParentNumberExistAndSetValidator.class.equals(x.getClass()));
        existingValidators.add(new OrgCheckParentNumberValidator());
        existingValidators.add(new NumberStyleValidator());
        existingValidators.add(new RootICMemberValidator());
        existingValidators.add(new InnerOrgValidator());
        existingValidators.add(new InjectOrgCurrencyNumberValidator());
        existingValidators.add(new EffDateValidator());
        existingValidators.add(new CtrlOrgValidators());
        existingValidators.add(new OrgChangeRecordInputFormatValidator());
    }

    @Override
    public void afterSaveBatch(List<ImportBillData> importedBills, List<ImportResultEntry> resultEntries) {
        ArrayList<BillTuple> handleDataWraps = new ArrayList<BillTuple>(importedBills.size());
        for (int i = 0; i < importedBills.size(); ++i) {
            ImportBillData bill = importedBills.get(i);
            ImportResultEntry resultEntry = resultEntries.get(i);
            if (resultEntry.isErr()) continue;
            handleDataWraps.add(new BillTuple(bill, resultEntry));
        }
        long micDimentionID = ImportHelper.getIcDimensionID(ImportContextHolder.getModelId());
        long myOrgDimentionID = ImportHelper.getMyOrgDimensionID(ImportContextHolder.getModelId());
        String modelNum = ImportHelper.getNumber(this.model);
        ArrayList newIcOlapMembers = new ArrayList(16);
        List newMyOlapMembers = Collections.synchronizedList(new ArrayList(16));
        try (TXHandle tx = TX.required();){
            try {
                List nonShareTuples = handleDataWraps.stream().filter(x -> !ImportHelper.isShareType((Map<String, Object>)x.getBill().getData())).collect(Collectors.toList());
                BatchProcessHelper.batchHandle(nonShareTuples, (int)2000, (int)500, billTuples -> {
                    try {
                        billTuples.stream().forEach(tuple -> {
                            boolean isOuterOrg;
                            ImportBillData bill = tuple.getBill();
                            ImportResultEntry resultEntry = tuple.getResultEntry();
                            String billNumber = bill.getData().getString("number");
                            Object billName = bill.getData().get((Object)"name");
                            Object billSimpleName = bill.getData().get((Object)"simplename");
                            DynamicObject importedOrgMember = resultEntry.getImportedMemTreeDy().get();
                            boolean isinnerorg = importedOrgMember.getBoolean("isinnerorg");
                            boolean bl = isOuterOrg = ObjectUtils.isEmpty((Object)bill.getData().get((Object)"isouterorg")) ? false : (Boolean)bill.getData().get((Object)"isouterorg");
                            if (isinnerorg || isOuterOrg) {
                                Optional<DynamicObject> icDyo = BatchImportReadOnlyCache.getIcMemberByNumber(micDimentionID, billNumber, this.modelId);
                                if (!icDyo.isPresent()) {
                                    this.createICMember(importedOrgMember, micDimentionID, true);
                                    newIcOlapMembers.add(importedOrgMember.getString("number"));
                                } else {
                                    String parentNumber = icDyo.get().getString("parent.number");
                                    if (isinnerorg && parentNumber.equals("ICOEntity") || isOuterOrg && parentNumber.equals("ICEntity")) {
                                        DimensionEditHelper.updateICParent((long)this.modelId, (long)icDyo.get().getLong("id"), (Object)billName, (boolean)isinnerorg);
                                    } else {
                                        DimensionEditHelper.updateDimensionName((String)"bcm_icmembertree", (long)this.modelId, (String)billNumber, (Object)billName, (Object)billSimpleName);
                                    }
                                }
                            }
                            if (myOrgDimentionID != 0L) {
                                boolean exists = QueryServiceHelper.exists((String)"bcm_mycompanymembertree", (QFilter[])new QFBuilder("model", "=", (Object)this.modelId).add("number", "=", importedOrgMember.get("number")).toArray());
                                if (!exists) {
                                    this.createICMember(importedOrgMember, myOrgDimentionID, false);
                                    newMyOlapMembers.add(new Tuple((Object)importedOrgMember.getString("number"), (Object)importedOrgMember.getInt("aggoprt"), (Object)"MyCompany"));
                                } else {
                                    DimensionEditHelper.updateDimensionName((String)"bcm_mycompanymembertree", (long)this.modelId, (String)billNumber, (Object)billName, (Object)billSimpleName);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        LOG.error(this.genLogPrefix("createICEntity") + " on " + e.getMessage());
                    }
                    return Collections.EMPTY_LIST;
                }, null, (BatchProcessHelper.Scene)BatchProcessHelper.Scene.IO);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        if (!newIcOlapMembers.isEmpty()) {
            try {
                OlapServiceHelper.batchCreateDimensionMembers((String)modelNum, (String)DimTypesEnum.INTERCOMPANY.getNumber(), (String[])newIcOlapMembers.toArray(new String[0]));
            }
            catch (Exception ex) {
                LOG.error(String.format("failed to update OLAP on model: %s, dimension: %s with params: %s", modelNum, ImportHelper.getNumber(this.dimension), String.join((CharSequence)"|", newIcOlapMembers.stream().map(String::toString).collect(Collectors.toList()))), (Throwable)ex);
            }
        }
        if (!newMyOlapMembers.isEmpty()) {
            try {
                OlapServiceHelper.batchCreateDimensionMembers((String)modelNum, (String)"MyCompany", newMyOlapMembers);
            }
            catch (Exception e) {
                LOG.error(String.format("failed to batch create dimension members for MC_MyCompany on model: %s", modelNum), (Throwable)e);
            }
        }
        BatchProcessHelper.handleAsync(() -> {
            try {
                TimeUnit.SECONDS.sleep(10L);
                DynamicComputingServiceHelper.repairModelByDim((String)modelNum, (String)DimTypesEnum.INTERCOMPANY.getNumber(), (boolean)true);
            }
            catch (Exception e) {
                LOG.error(String.format("failed to repair model and dim on INTERCOMPANY on model: %s, dimension: %s", modelNum, DimTypesEnum.INTERCOMPANY.getNumber()), (Throwable)e);
            }
        });
        if (!newIcOlapMembers.isEmpty()) {
            BatchImportReadOnlyCache.clearIcMemberCache();
        }
    }

    @Override
    public void assemEffDate(ImportBillData bill, DynamicObject treeMem, boolean isInit) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date nowDate = TimeServiceHelper.now();
        String userId = RequestContext.get().getUserId();
        Date effdate = null;
        JSONObject data = bill.getData();
        try {
            effdate = data.get("effdate") == null ? EntityVersioningUtil.getModelBeginDate((Object)this.modelId) : format.parse(data.get("effdate").toString());
        }
        catch (ParseException e) {
            throw new KDBizException((Throwable)e, ImportMsgUtils.getSysErrCode(), new Object[0]);
        }
        DynamicObjectCollection bizRecords = treeMem.getDynamicObjectCollection("bizchangerds");
        DynamicObjectCollection nameRecords = treeMem.getDynamicObjectCollection("namechangerds");
        DynamicObjectCollection currRecords = treeMem.getDynamicObjectCollection("currencychangerds");
        this.bizAssemble(bizRecords, (Map<String, Object>)data, userId, nowDate, effdate, isInit);
        this.nameAssemble(nameRecords, (Map<String, Object>)data, userId, nowDate, effdate, treeMem, isInit);
        if (isInit) {
            this.currAssemble(currRecords, effdate, treeMem);
        }
    }

    @Override
    public void assemMemberTree(ImportBillData bill, DynamicObject memberTreeDy, DynamicObject memberDy, boolean isNew) {
        Object isouterorg;
        super.assemMemberTree(bill, memberTreeDy, memberDy, isNew);
        JSONObject data = bill.getData();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            memberTreeDy.set("effdate", (Object)(data.get("effdate") == null ? new Date() : format.parse(data.get("effdate").toString())));
            memberTreeDy.set("expdate", data.get("expdate") == null ? null : format.parse(data.get("expdate").toString()));
        }
        catch (ParseException e) {
            throw new KDBizException((Throwable)e, ImportMsgUtils.getSysErrCode(), new Object[0]);
        }
        if (this.isCM) {
            memberTreeDy.set("cslscheme", (Object)RowDataExtUtil.getCslScheme(bill).get().getLong("id"));
            memberTreeDy.set("belongscheme", (Object)(RowDataExtUtil.getBelongCslScheme(bill).isPresent() ? RowDataExtUtil.getBelongCslScheme(bill).get().getLong("id") : 0L));
        } else if (this.isRpt) {
            if (this.rptCslSchemeId == 0L) {
                this.rptCslSchemeId = CslSchemeServiceHelper.getRptDefaultSchemeId((long)this.modelId);
            }
            memberTreeDy.set("cslscheme", (Object)this.rptCslSchemeId);
        }
        if (!ImportContextHolder.isDryRun() && (isouterorg = data.get("isouterorg")) != null) {
            DynamicObject entitypart = null;
            entitypart = memberTreeDy.get("entitypart") instanceof DynamicObject ? memberTreeDy.getDynamicObject("entitypart") : BusinessDataServiceHelper.loadSingle((String)"bcm_entitymemberpart", (String)"id,isouterorg", (QFilter[])new QFilter("id", "=", (Object)memberTreeDy.getLong("entitypart")).toArray());
            if (entitypart != null) {
                memberTreeDy.set("entitypart.isouterorg", isouterorg);
            } else {
                entitypart = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymemberpart");
                entitypart.set("isouterorg", isouterorg);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entitypart});
                memberTreeDy.set("entitypart", (Object)entitypart);
            }
        }
        memberTreeDy.set("currency", (Object)RowDataExtUtil.getCurrency(bill).get());
        memberTreeDy.set("status", (Object)"C");
        memberTreeDy.set("enable", (Object)"1");
        String showNumber = bill.getData().getString("shownumber");
        memberTreeDy.set("shownumber", (Object)(StringUtils.isEmpty((CharSequence)showNumber) ? memberTreeDy.getString("number") : showNumber));
        memberTreeDy.set("creditcode", data.get("creditcode"));
    }

    @Override
    public void assemByBaseMember(DynamicObject memberTreeDy, String memberEntityNumber) {
        if (memberTreeDy != null) {
            DynamicObject existingMemberDy = PersistProxy.instance.getNonShareMember(memberEntityNumber, false).get();
            memberTreeDy.set("ctrlorg", (Object)existingMemberDy.getDynamicObject("ctrlorg"));
            memberTreeDy.set("simplename", existingMemberDy.get("simplename"));
            memberTreeDy.set("currency", (Object)existingMemberDy.getDynamicObject("currency"));
            memberTreeDy.set("isinnerorg", (Object)existingMemberDy.getBoolean("isinnerorg"));
            memberTreeDy.set("isclearorg", (Object)existingMemberDy.getBoolean("isclearorg"));
            memberTreeDy.set("description", (Object)existingMemberDy.getString("description"));
            memberTreeDy.set("status", (Object)existingMemberDy.getString("status"));
            memberTreeDy.set("enable", (Object)existingMemberDy.getString("enable"));
            memberTreeDy.set("issysmember", (Object)2);
            memberTreeDy.set("isexchangerate", (Object)0);
        }
    }

    @Override
    public void assemBySpecialExcel(ImportBillData bill, DynamicObject memberTreeDy) {
        super.assemBySpecialExcel(bill, memberTreeDy);
        JSONObject data = bill.getData();
        Set keySet = data.keySet();
        memberTreeDy.set("ctrlorg", null);
        Optional<DynamicObject> ctrlOrgIdOpt = RowDataExtUtil.getCtrlOrgId(bill);
        if (ctrlOrgIdOpt.isPresent()) {
            memberTreeDy.set("ctrlorg", (Object)ctrlOrgIdOpt.get());
        } else {
            Optional<DynamicObject> ctrlMemberOpt;
            Object ctrlNumber = ImportHelper.getImportBillProp(bill, "ctrlorg.number");
            if (StringUtils.isNotEmpty((CharSequence)ctrlNumber.toString()) && (ctrlMemberOpt = PersistProxy.instance.getNonShareMember(ctrlNumber.toString(), false)).isPresent()) {
                memberTreeDy.set("ctrlorg", (Object)ctrlMemberOpt.get());
            }
        }
        if (keySet.contains("simplename")) {
            memberTreeDy.set("simplename", data.get("simplename"));
        }
        memberTreeDy.set("currency", (Object)RowDataExtUtil.getCurrency(bill).get().getLong("id"));
        memberTreeDy.set("isinnerorg", (Object)(data.get("isinnerorg") == null ? Boolean.valueOf(false) : data.get("isinnerorg")));
        memberTreeDy.set("isindependentorg", (Object)(data.get("isindependentorg") == null ? Integer.valueOf(0) : data.get("isindependentorg")));
        memberTreeDy.set("isclearorg", (Object)(data.get("isclearorg") == null ? Integer.valueOf(0) : data.get("isclearorg")));
        memberTreeDy.set("status", (Object)"C");
        memberTreeDy.set("enable", (Object)"1");
        memberTreeDy.set("isexchangerate", (Object)0);
    }

    @Override
    public void assemBySpecialExcelForShareMember(DynamicObject existingStoreMemTree, DynamicObject currentMemTreeDy) {
    }

    @Override
    public String getMemberName() {
        return "bcm_entitymember";
    }

    private void createICMember(DynamicObject importedOrgMember, long micDimentionID, boolean isIc) {
        int n;
        String orgNumber = importedOrgMember.getString("number");
        ILocaleString orgName = importedOrgMember.getLocaleString("name");
        Object simplename = importedOrgMember.get("simplename");
        DynamicObject member = ORM.create().newDynamicObject(isIc ? "bcm_intercompanymember" : "bcm_mycompanymember");
        DimensionServiceHelper.initDimensionDyObjectWithOrg((DynamicObject)member);
        member.set("number", (Object)orgNumber);
        member.set("name", (Object)orgName);
        member.set("simplename", simplename);
        DynamicObject dimension = BusinessDataServiceHelper.newDynamicObject((String)"bcm_dimension");
        dimension.set("id", (Object)(isIc ? (micDimentionID == 0L ? ImportHelper.getIcDimensionID(this.modelId) : micDimentionID) : micDimentionID));
        DynamicObject model = BusinessDataServiceHelper.newDynamicObject((String)"bcm_model");
        model.set("id", (Object)this.modelId);
        member.set("model", (Object)model);
        member.set("dimension", (Object)dimension);
        BusinessDataWriter.save((IDataEntityType)member.getDynamicObjectType(), (Object[])new DynamicObject[]{member});
        DynamicObject memberTree = ORM.create().newDynamicObject(isIc ? "bcm_icmembertree" : "bcm_mycompanymembertree");
        DimensionServiceHelper.initDimensionDyObject((DynamicObject)memberTree);
        memberTree.set("member", (Object)member);
        memberTree.set("number", (Object)orgNumber);
        memberTree.set("name", (Object)orgName);
        memberTree.set("simplename", simplename);
        StringBuilder longnumber = new StringBuilder();
        if (isIc) {
            longnumber.append("InternalCompany").append('!').append("ICTotal").append('!').append(importedOrgMember.getBoolean("isinnerorg") ? "ICEntity" : "ICOEntity").append('!').append(orgNumber);
        } else {
            longnumber.append("MyCompany").append('!').append(orgNumber);
        }
        memberTree.set("longnumber", (Object)longnumber.toString());
        memberTree.set("storagetype", (Object)4);
        memberTree.set("aggoprt", isIc ? importedOrgMember.get("aggoprt") : AggOprtEnum.ADD.sign);
        memberTree.set("description", importedOrgMember.get("description"));
        memberTree.set("model", (Object)model);
        memberTree.set("dimension", (Object)dimension);
        memberTree.set("issysmember", (Object)0);
        memberTree.set("isleaf", (Object)1);
        memberTree.set("level", (Object)(isIc ? 4 : 2));
        if (this.icParentId == 0L || this.mcParentId == 0L) {
            QFBuilder filterParent = new QFBuilder("model", "=", (Object)this.modelId);
            String isinnerorg = isIc ? (importedOrgMember.getBoolean("isinnerorg") ? "ICEntity" : "ICOEntity") : "MyCompany";
            filterParent.add("number", "=", (Object)isinnerorg);
            DynamicObject parent = BusinessDataServiceHelper.loadSingle((String)(isIc ? "bcm_icmembertree" : "bcm_mycompanymembertree"), (String)"id,isleaf", (QFilter[])filterParent.toArray());
            if (Objects.isNull(parent)) {
                return;
            }
            if (parent.getBoolean("isleaf")) {
                parent.set("isleaf", (Object)false);
                BusinessDataWriter.save((IDataEntityType)parent.getDynamicObjectType(), (Object[])new DynamicObject[]{parent});
            }
            if (isIc) {
                this.icParentId = parent.getLong("id");
            } else {
                this.mcParentId = parent.getLong("id");
            }
        }
        long parentId = isIc ? this.icParentId : this.mcParentId;
        memberTree.set("parent", (Object)parentId);
        if (this.icMaxSeq == 0 || this.mcMaxSeq == 0) {
            int seq = DimensionUtil.getDSeq(parentId, isIc ? "bcm_icmembertree" : "bcm_mycompanymembertree");
            if (isIc) {
                this.icMaxSeq = seq;
            } else {
                this.mcMaxSeq = seq;
            }
        }
        if (isIc) {
            int n2 = this.icMaxSeq;
            n = n2;
            this.icMaxSeq = n2 + 1;
        } else {
            int n3 = this.mcMaxSeq;
            n = n3;
            this.mcMaxSeq = n3 + 1;
        }
        memberTree.set("dseq", (Object)n);
        BusinessDataWriter.save((IDataEntityType)memberTree.getDynamicObjectType(), (Object[])new Object[]{memberTree});
    }

    private void bizAssemble(DynamicObjectCollection bizRecords, Map<String, Object> data, String userId, Date nowDate, Date effdate, boolean isInit) {
        String bizChangeRdsFromExcel = (String)data.get("bizchangerds");
        if (StringUtils.isNotEmpty((CharSequence)bizChangeRdsFromExcel)) {
            String noTailBizChangeRdsFromExcel = bizChangeRdsFromExcel.substring(0, bizChangeRdsFromExcel.length() - 1);
            String[] bizStr = noTailBizChangeRdsFromExcel.split(";\n");
            DynamicObjectCollection newRecords = new DynamicObjectCollection();
            for (int i = 0; i < bizStr.length; ++i) {
                DynamicObject bizRecordNew;
                DynamicObject oldRecord;
                String[] bizJson = bizStr[i].split("\\|");
                DynamicObject dynamicObject = oldRecord = i < bizRecords.size() ? (DynamicObject)bizRecords.get(i) : null;
                if (oldRecord != null && oldRecord.getString("changetype").equals(bizJson[0])) {
                    bizRecordNew = oldRecord;
                    if (bizStr.length == 1) {
                        bizRecordNew.set("bizexpdate", null);
                    }
                } else {
                    bizRecordNew = new DynamicObject(bizRecords.getDynamicObjectType());
                }
                bizRecordNew.set("changetype", (Object)bizJson[0]);
                bizRecordNew.set("bizeffdate", (Object)ImportText2DateUtils.dateStr2Date(bizJson[1]));
                if (bizJson.length > 2) {
                    bizRecordNew.set("bizexpdate", (Object)ImportText2DateUtils.dateStr2Date(bizJson[2]));
                }
                bizRecordNew.set("seq", (Object)(i + 1));
                newRecords.add((Object)bizRecordNew);
            }
            bizRecords.clear();
            bizRecords.addAll((Collection)newRecords);
        } else if (isInit) {
            bizRecords.clear();
            DynamicObject bizRecord = new DynamicObject(bizRecords.getDynamicObjectType());
            bizRecord.set("changetype", (Object)OrgBizChangeTypeEnum.initNewlyAdded.getValue());
            bizRecord.set("bizeffdate", (Object)effdate);
            bizRecord.set("bizmodifier", (Object)userId);
            bizRecord.set("bizmodifytime", (Object)nowDate);
            bizRecord.set("seq", (Object)1);
            bizRecords.add((Object)bizRecord);
        }
    }

    private void nameAssemble(DynamicObjectCollection nameRecords, Map<String, Object> data, String userId, Date nowDate, Date effdate, DynamicObject treeMem, boolean isInit) {
        String nameChangeRdsFromExcel = (String)data.get("namechangerds");
        if (StringUtils.isNotEmpty((CharSequence)nameChangeRdsFromExcel)) {
            String noTailNameChangeRdsFromExcel = nameChangeRdsFromExcel.substring(0, nameChangeRdsFromExcel.length() - 1);
            String[] nameStr = noTailNameChangeRdsFromExcel.split(";\n");
            DynamicObjectCollection newRecords = new DynamicObjectCollection();
            for (int i = 0; i < nameStr.length; ++i) {
                DynamicObject nameRecordNew;
                boolean dateEqual;
                String[] nameRd = nameStr[i].split("\\|");
                DynamicObject oldRecord = i < nameRecords.size() ? (DynamicObject)nameRecords.get(i) : null;
                boolean bl = dateEqual = oldRecord != null && DateTimeUtils.dayEquals((Date)oldRecord.getDate("nameeffdate"), (Date)ImportText2DateUtils.dateStr2Date(nameRd[2]));
                if (dateEqual && oldRecord.getString("namerds").equals(nameRd[0]) && oldRecord.getString("simplenamerds").equals(nameRd[1])) {
                    nameRecordNew = oldRecord;
                } else {
                    nameRecordNew = new DynamicObject(nameRecords.getDynamicObjectType());
                    nameRecordNew.set("namerds", (Object)nameRd[0]);
                    nameRecordNew.set("simplenamerds", (Object)nameRd[1]);
                    nameRecordNew.set("nameeffdate", (Object)ImportText2DateUtils.dateStr2Date(nameRd[2]));
                }
                if (nameRd.length > 3) {
                    nameRecordNew.set("nameexpdate", (Object)ImportText2DateUtils.dateStr2Date(nameRd[3]));
                }
                nameRecordNew.set("seq", (Object)(i + 1));
                newRecords.add((Object)nameRecordNew);
            }
            nameRecords.clear();
            nameRecords.addAll((Collection)newRecords);
        } else if (isInit) {
            nameRecords.clear();
            DynamicObject nameRecord = new DynamicObject(nameRecords.getDynamicObjectType());
            nameRecord.set("namerds", treeMem.get("name"));
            nameRecord.set("simplenamerds", treeMem.get("simplename"));
            nameRecord.set("nameeffdate", (Object)effdate);
            nameRecord.set("namemodifier", (Object)userId);
            nameRecord.set("namemodifytime", (Object)nowDate);
            nameRecord.set("seq", (Object)1);
            nameRecords.add((Object)nameRecord);
        }
    }

    private void currAssemble(DynamicObjectCollection currRecords, Date effDate, DynamicObject treeMem) {
        currRecords.clear();
        DynamicObject currencyRecord = new DynamicObject(currRecords.getDynamicObjectType());
        currencyRecord.set("currencyrds", treeMem.get("currency"));
        currencyRecord.set("currencyeffdate", (Object)effDate);
        currencyRecord.set("currencymodifier", (Object)RequestContext.get().getCurrUserId());
        currencyRecord.set("currencymodifytime", (Object)TimeServiceHelper.now());
        currencyRecord.set("seq", (Object)1);
        currRecords.add((Object)currencyRecord);
    }

    private static class BillTuple {
        private ImportBillData bill;
        private ImportResultEntry resultEntry;

        public BillTuple(ImportBillData bill, ImportResultEntry resultEntry) {
            this.bill = bill;
            this.resultEntry = resultEntry;
        }

        public ImportBillData getBill() {
            return this.bill;
        }

        public void setBill(ImportBillData bill) {
            this.bill = bill;
        }

        public ImportResultEntry getResultEntry() {
            return this.resultEntry;
        }
    }
}

