/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.olap.metadata.MemberStorageTypes;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.formplugin.dimension.batchimp.AbstractDimensionBatchImport;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.DimensionImportContext;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.IDimensionImportValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.scene.ScaleTxtValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.scene.SceneCslschemeValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.scene.ScenePeriodDchangetypeValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.scene.ScenePeriodValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.scene.SceneQuoteValidator;

public class SceneDimensionBatchImport
extends AbstractDimensionBatchImport {
    private List<Pair<String, String>> toDropFactors = new ArrayList<Pair<String, String>>();
    private List<Pair<String, String>> toCreateFactors = new ArrayList<Pair<String, String>>();

    @Override
    protected void customizeValidators(DimensionImportContext context, List<IDimensionImportValidator> existingValidators) {
        super.customizeValidators(context, existingValidators);
        existingValidators.add(new ScaleTxtValidator());
        existingValidators.add(new ScenePeriodValidator());
        existingValidators.add(new ScenePeriodDchangetypeValidator());
        existingValidators.add(new SceneQuoteValidator());
        existingValidators.add(new SceneCslschemeValidator());
    }

    @Override
    public void assemByBaseMember(DynamicObject memberTreeDy, String memberEntityNumber) {
    }

    @Override
    public void assemBySpecialExcel(ImportBillData bill, DynamicObject memberTreeDy) {
        this.setScaleTxt(bill, memberTreeDy);
        this.setScenePeriod(bill, memberTreeDy);
        if (this.isCM) {
            this.setSceneCsl(bill, memberTreeDy);
        }
        memberTreeDy.set("enumitem", RowDataExtUtil.getValue(bill));
        memberTreeDy.set("value", RowDataExtUtil.getValue(bill));
        memberTreeDy.set("status", (Object)"C");
        memberTreeDy.set("enable", (Object)"1");
        memberTreeDy.set("datatype", (Object)bill.getData().getString("datatype"));
        memberTreeDy.set("dchangetype", (Object)bill.getData().getString("dchangetype"));
        this.setSceneQuote(bill, memberTreeDy);
    }

    @Override
    public void assemBySpecialExcelForShareMember(DynamicObject existingStoreMemTree, DynamicObject currentMemTreeDy) {
    }

    @Override
    public String getMemberName() {
        return "bcm_scenemember";
    }

    private void setScaleTxt(ImportBillData bill, DynamicObject memberTreeDy) {
        String scaletext = bill.getData().getString("scaletext");
        if (StringUtils.isNotEmpty((String)StringUtils.trim((String)scaletext))) {
            String[] scaletextArr;
            DynamicObjectCollection scaleEntry = memberTreeDy.getDynamicObjectCollection("scaleentry");
            ArrayList<String> currencyNumber = new ArrayList<String>(10);
            for (String currencyNumberScale : scaletextArr = scaletext.split(",")) {
                currencyNumber.add(currencyNumberScale.split(":")[0].trim());
            }
            DynamicObjectCollection curs = QueryServiceHelper.query((String)"bcm_currencymembertree", (String)"id,number", (QFilter[])new QFilter("model", "=", (Object)this.modelId).and("number", "in", currencyNumber).toArray());
            Map<String, Long> curMap = curs.stream().collect(Collectors.toMap(dyn -> dyn.getString("number"), dyn -> dyn.getLong("id")));
            scaleEntry.clear();
            for (String currencyNameScale : scaletextArr) {
                String[] nameAndScale = currencyNameScale.trim().split(":");
                String number = nameAndScale[0];
                String scale = nameAndScale[1];
                if (!curMap.containsKey(number)) continue;
                DynamicObject scaleEntryObj = scaleEntry.addNew();
                scaleEntryObj.set("scale", (Object)scale);
                scaleEntryObj.set("currency_id", (Object)curMap.get(number));
            }
        }
    }

    private void setScenePeriod(ImportBillData bill, DynamicObject memberTreeDy) {
        JSONObject scenePeriodJson = bill.getData().getJSONObject("sceneperiod");
        DynamicObjectCollection scenePeriods = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"id,number", (QFilter[])new QFilter("model", "=", (Object)this.modelId).and("number", "in", (Object)scenePeriodJson.getString("number").split(",")).toArray(), (String)"number");
        DynamicObjectCollection dyCol = memberTreeDy.getDynamicObjectCollection("sceneperiod");
        dyCol.clear();
        for (DynamicObject period : scenePeriods) {
            DynamicObject dynamicObject = dyCol.addNew();
            dynamicObject.set("fbasedataid_id", (Object)period.getLong("id"));
        }
    }

    private void setSceneCsl(ImportBillData bill, DynamicObject memberTreeDy) {
        JSONObject scenePeriodJson = bill.getData().getJSONObject("scenecslscheme");
        QFilter qf = new QFilter("model", "=", (Object)this.modelId);
        QFilter qfCsl1 = new QFilter("number", "in", (Object)scenePeriodJson.getString("number").split(","));
        QFilter qfCsl2 = new QFilter("nodetype", "=", (Object)"1");
        DynamicObjectCollection cslDys = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id,number", (QFilter[])new QFilter[]{qf, qfCsl1, qfCsl2});
        DynamicObjectCollection dyCol = memberTreeDy.getDynamicObjectCollection("scenecslscheme");
        dyCol.clear();
        for (DynamicObject csl : cslDys) {
            DynamicObject dynamicObject = dyCol.addNew();
            dynamicObject.set("fbasedataid_id", (Object)csl.getLong("id"));
        }
    }

    private void setSceneQuote(ImportBillData bill, DynamicObject memberTreeDy) {
        Optional<DynamicObject> existingDy = RowDataExtUtil.getExistingRecord(bill);
        Boolean isversioned = bill.getData().getBoolean("isversioned");
        JSONObject scenequote = bill.getData().getJSONObject("scenequote");
        if (existingDy.isPresent()) {
            Boolean oldIsversioned = existingDy.get().getBoolean("isversioned");
            if (isversioned != null && oldIsversioned != null) {
                if (!isversioned.booleanValue() && oldIsversioned.booleanValue()) {
                    this.toDropFactors.add((Pair<String, String>)Pair.onePair((Object)existingDy.get().getString("scenequote.number"), (Object)existingDy.get().getString("number")));
                } else if (isversioned.booleanValue() && oldIsversioned.booleanValue()) {
                    String newSceneQuoteNumber = scenequote.getString("number");
                    if (!existingDy.get().getString("scenequote.number").equals(newSceneQuoteNumber)) {
                        this.toDropFactors.add((Pair<String, String>)Pair.onePair((Object)existingDy.get().getString("scenequote.number"), (Object)existingDy.get().getString("number")));
                    }
                }
            }
        }
        if (isversioned != null && isversioned.booleanValue()) {
            String newSceneQuoteNumber = scenequote.getString("number");
            DynamicObject sceneQuote = QueryServiceHelper.queryOne((String)"bcm_scenemembertree", (String)"id", (QFilter[])new QFilter("model", "=", (Object)this.model.getLong("id")).and("number", "=", (Object)newSceneQuoteNumber).toArray());
            memberTreeDy.set("isversioned", (Object)true);
            memberTreeDy.set("scenequote", (Object)sceneQuote.getLong("id"));
            memberTreeDy.set("alonemergeconfig", (Object)bill.getData().getBoolean("alonemergeconfig"));
            this.toCreateFactors.add((Pair<String, String>)Pair.onePair((Object)newSceneQuoteNumber, (Object)bill.getData().getString("number")));
        }
    }

    @Override
    protected void afterImport() {
        super.afterImport();
        if (this.toDropFactors.size() > 0) {
            for (Pair<String, String> factor : this.toDropFactors) {
                OlapServiceHelper.dropAggFactor((String)this.model.getString("number"), (String)this.dimension.getString("number"), (String)((String)factor.p1), (int)1, (String)((String)factor.p2));
            }
        }
        if (this.toCreateFactors.size() > 0) {
            for (Pair<String, String> factor : this.toCreateFactors) {
                OlapServiceHelper.alterMemberStorageType((String)this.model.getString("number"), (String)this.dimension.getString("number"), (String)((String)factor.p2), (MemberStorageTypes)MemberStorageTypes.DynamicCalc);
                OlapServiceHelper.createAggFactor((String)this.model.getString("number"), (String)this.dimension.getString("number"), (String)((String)factor.p1), (int)1, (String)((String)factor.p2));
            }
        }
    }
}

