/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.dimension.batchimp.AbstractDimensionBatchImport;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.DimensionImportContext;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.IDimensionImportValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.AssoStorageValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.common.EnumAndDataTypeValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.udefinedim.NewMemberValidator;

public class UserDefindDimensionBatchImport
extends AbstractDimensionBatchImport {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(UserDefindDimensionBatchImport.class);

    @Override
    protected void customizeValidators(DimensionImportContext context, List<IDimensionImportValidator> existingValidators) {
        existingValidators.add(new EnumAndDataTypeValidator());
        existingValidators.add(new NewMemberValidator());
        existingValidators.add(new AssoStorageValidator());
    }

    @Override
    public void assemMemberTree(ImportBillData bill, DynamicObject memberTreeDy, DynamicObject memberDy, boolean isNew) {
        super.assemMemberTree(bill, memberTreeDy, memberDy, isNew);
    }

    @Override
    public void assemByBaseMember(DynamicObject memberTreeDy, String memberEntityNumber) {
    }

    @Override
    public void assemBySpecialExcel(ImportBillData bill, DynamicObject memberTreeDy) {
        super.assemBySpecialExcel(bill, memberTreeDy);
        JSONObject data = bill.getData();
        Set keySet = data.keySet();
        if (keySet.contains("simplename")) {
            memberTreeDy.set("simplename", data.get("simplename"));
        }
        memberTreeDy.set("datatype", (Object)(data.get("datatype") == null ? DataTypeEnum.DEFAULT.index : data.get("datatype")));
        memberTreeDy.set("value", RowDataExtUtil.getValue(bill));
        memberTreeDy.set("enumitem", RowDataExtUtil.getValue(bill));
        memberTreeDy.set("status", (Object)"C");
        memberTreeDy.set("enable", (Object)"1");
        this.setAssoValue(bill, memberTreeDy);
    }

    @Override
    public void assemBySpecialExcelForShareMember(DynamicObject existingStoreMemTree, DynamicObject currentMemTreeDy) {
        currentMemTreeDy.set("name", existingStoreMemTree.get("name"));
        currentMemTreeDy.set("simplename", existingStoreMemTree.get("simplename"));
        currentMemTreeDy.set("datatype", existingStoreMemTree.get("datatype"));
        currentMemTreeDy.set("value", existingStoreMemTree.get("value"));
        currentMemTreeDy.set("enumitem", existingStoreMemTree.get("value"));
        currentMemTreeDy.set("description", existingStoreMemTree.get("description"));
        currentMemTreeDy.set("status", (Object)"C");
        currentMemTreeDy.set("enable", (Object)"1");
        currentMemTreeDy.set("issysmember", existingStoreMemTree.get("issysmember"));
    }

    @Override
    public String getMemberName() {
        return "bcm_userdefinedmember";
    }
}

