/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.bos;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.xml.sax.SAXException;

public class BatchImportFailedSheetHandler
extends SheetHandler {
    private static Log log = LogFactory.getLog(kd.bos.form.plugin.impt.BatchImportFailedSheetHandler.class);
    private SXSSFWorkbook book;
    private Map<String, CellStyle> styles = new HashMap<String, CellStyle>(16);
    private ImportLogger importLogger;
    private FileService service;
    private ImportContext ctx;
    private int cursorRowNum;
    private SheetHandler.ParsedRow currentRow;
    private Map<String, SXSSFSheet> sheets = new HashMap<String, SXSSFSheet>(16);
    private boolean hasErrorCol;
    private static final int ERR_ROW_COUNT = 5000;
    private boolean isDropdownItemsSheet = false;
    private Map<String, SXSSFRow> nameRows = new HashMap<String, SXSSFRow>(16);

    public SheetHandler.ParsedRow getCurrentRow() {
        return this.currentRow;
    }

    public void setCurrentRow(SheetHandler.ParsedRow currentRow) {
        this.currentRow = currentRow;
    }

    BatchImportFailedSheetHandler(ImportContext ctx, ImportLogger importLogger, FileService service) {
        this.setInterrupt(false);
        this.ctx = ctx;
        this.importLogger = importLogger;
        this.service = service;
        importLogger.getDelRows().sort((o1, o2) -> o1[0] - o2[0]);
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        SXSSFSheet sheet = this.sheets.get(row.getSheetName());
        if (sheet == null) {
            if (this.book == null) {
                this.book = new SXSSFWorkbook(1000);
                this.book.setCompressTempFiles(true);
            }
            sheet = this.book.createSheet(row.getSheetName());
            if (this.sheets.size() == 0) {
                sheet.setColumnWidth(0, 10000);
            }
            this.isDropdownItemsSheet = "dropdown_items_sheet".equals(row.getSheetName());
            this.sheets.put(row.getSheetName(), sheet);
        }
        this.currentRow = row;
        int currRowNum = this.currentRow.getRowNum();
        if (this.isDropdownItemsSheet) {
            this.handleDropdownSheet(sheet, currRowNum);
            return;
        }
        if (this.sheets.size() > 1) {
            this.handleSheet(sheet, currRowNum);
            return;
        }
        this.handleWorkSheet(row, sheet, currRowNum);
    }

    private void handleWorkSheet(SheetHandler.ParsedRow row, SXSSFSheet sheet, int currRowNum) {
        String entityName;
        JSONObject styleObj;
        SXSSFCell cell;
        if (currRowNum > 2) {
            if (this.isRowSucceed(this.importLogger.getDelRows(), currRowNum)) {
                return;
            }
            List logs = (List)this.importLogger.getLogCache().get(currRowNum);
            if (logs != null && !logs.isEmpty()) {
                String mergeLogStr;
                if (this.cursorRowNum - 2 <= 5000) {
                    StringBuilder sb = new StringBuilder();
                    for (ImportLogger.ImportLog log : logs) {
                        sb.append(log.toString()).append("\n\t");
                        if (sb.length() <= 4000) continue;
                        sb.replace(3997, 4000, "...").setLength(4000);
                        break;
                    }
                    mergeLogStr = sb.toString();
                } else {
                    mergeLogStr = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u884c\u6570\u636e\u3002", (String)"BatchImportFailedSheetHandler_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                }
                cell = this.getRow(sheet, this.cursorRowNum).createCell(0);
                styleObj = new JSONObject();
                styleObj.put("color", (Object)IndexedColors.RED.getIndex());
                cell.setCellStyle(this.getCellStyle(styleObj));
                cell.setCellValue(mergeLogStr);
            }
        } else if (currRowNum == 2) {
            SXSSFRow nameRow = this.getRow(sheet, this.cursorRowNum);
            this.nameRows.put(row.getSheetName(), nameRow);
            cell = nameRow.createCell(0);
            cell.setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"BatchImportFailedSheetHandler_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else if (currRowNum == 0 && (StringUtils.isBlank((CharSequence)(entityName = this.currentRow.get(Integer.valueOf(0)))) || !entityName.contains(" # "))) {
            this.hasErrorCol = true;
        }
        for (Map.Entry entry : this.currentRow.getData().entrySet()) {
            String fmt;
            CellStyle style;
            if (this.hasErrorCol && (Integer)entry.getKey() == 0) continue;
            styleObj = (JSONObject)this.currentRow.getStyles().get(entry.getKey());
            int cellIndex = this.countIndex((Integer)entry.getKey());
            cell = this.getRow(sheet, this.cursorRowNum).createCell(cellIndex);
            if (currRowNum == 2) {
                styleObj.put("bg", (Object)IndexedColors.GREY_25_PERCENT.getIndex());
                if (((String)entry.getValue()).startsWith("*")) {
                    styleObj.put("color", (Object)IndexedColors.RED.getIndex());
                }
                sheet.setColumnWidth(cellIndex, Math.min(((String)entry.getValue()).getBytes(StandardCharsets.US_ASCII).length * 2 * 160, 51200));
            }
            if ((style = this.getCellStyle(styleObj)) != null) {
                cell.setCellStyle(style);
            }
            if (StringUtils.isNotBlank((CharSequence)(fmt = styleObj.getString("fmt")))) {
                try {
                    cell.setCellValue(new BigDecimal((String)entry.getValue()).doubleValue());
                }
                catch (Throwable e) {
                    cell.setCellValue((String)entry.getValue());
                }
                continue;
            }
            cell.setCellValue((String)entry.getValue());
        }
        ++this.cursorRowNum;
    }

    private void handleSheet(SXSSFSheet sheet, int currRowNum) {
        this.hasErrorCol = true;
        for (Map.Entry entry : this.currentRow.getData().entrySet()) {
            String fmt;
            JSONObject styleObj = (JSONObject)this.currentRow.getStyles().get(entry.getKey());
            SXSSFCell cell = this.getRow(sheet, currRowNum).createCell(((Integer)entry.getKey()).intValue());
            CellStyle style = this.getCellStyle(styleObj);
            if (style != null) {
                cell.setCellStyle(style);
            }
            if (StringUtils.isNotBlank((CharSequence)(fmt = styleObj.getString("fmt")))) {
                try {
                    cell.setCellValue(new BigDecimal((String)entry.getValue()).doubleValue());
                }
                catch (Throwable e) {
                    cell.setCellValue((String)entry.getValue());
                }
                continue;
            }
            cell.setCellValue((String)entry.getValue());
        }
    }

    private void handleDropdownSheet(SXSSFSheet sheet, int currRowNum) {
        for (Map.Entry entry : this.currentRow.getData().entrySet()) {
            SXSSFCell cell = this.getRow(sheet, currRowNum).createCell(((Integer)entry.getKey()).intValue());
            cell.setCellType(CellType.STRING);
            cell.setCellValue((String)entry.getValue());
        }
    }

    private int countIndex(int index) {
        if (this.hasErrorCol) {
            return index;
        }
        return ++index;
    }

    private CellStyle getCellStyle(JSONObject style) {
        String fmt = (String)style.getOrDefault((Object)"fmt", (Object)"@");
        String align = style.getString("align");
        Short bg = style.getShort("bg");
        Short color = style.getShort("color");
        String styleStr = String.format("%s_-_%d_-_%d_-_%s", fmt, bg, color, align);
        CellStyle cellStyle = this.styles.get(styleStr);
        if (cellStyle == null) {
            cellStyle = this.book.createCellStyle();
            this.styles.put(styleStr, cellStyle);
            cellStyle.setDataFormat(this.book.createDataFormat().getFormat(fmt));
            if (bg != null) {
                cellStyle.setFillForegroundColor(bg.shortValue());
                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
            if (color != null) {
                Font font = this.book.createFont();
                font.setColor(color.shortValue());
                cellStyle.setFont(font);
            }
            cellStyle.setAlignment(this.getAlignment(align));
        }
        return cellStyle;
    }

    private HorizontalAlignment getAlignment(String align) {
        try {
            return HorizontalAlignment.valueOf((String)align.toUpperCase(Locale.ENGLISH));
        }
        catch (Throwable e) {
            return HorizontalAlignment.GENERAL;
        }
    }

    private CellType convertCellType(SheetHandler.XSSFDataType xssfDataType, String fmt) {
        if (xssfDataType != null) {
            switch (xssfDataType) {
                case BOOL: {
                    return CellType.BOOLEAN;
                }
                case ERROR: {
                    return CellType.ERROR;
                }
                case FORMULA: {
                    return CellType.FORMULA;
                }
                case INLINESTR: 
                case SSTINDEX: {
                    if (StringUtils.isNotBlank((CharSequence)fmt)) {
                        return CellType.NUMERIC;
                    }
                    return CellType.STRING;
                }
                case NUMBER: {
                    return CellType.NUMERIC;
                }
            }
        }
        return CellType.BLANK;
    }

    private boolean isRowSucceed(List<int[]> delRows, int currRowNum) {
        for (int[] rs : delRows) {
            if (rs[1] < rs[0]) {
                return currRowNum >= rs[0];
            }
            if (currRowNum > rs[1]) continue;
            return currRowNum >= rs[0];
        }
        return false;
    }

    public SXSSFRow getRow(SXSSFSheet sheet, int r) {
        SXSSFRow row = sheet.getRow(r);
        if (row == null) {
            row = sheet.createRow(r);
        }
        return row;
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        Set sheetNames = this.getSheetNames();
        sheetNames.remove(this.getSheetName());
        if (sheetNames.isEmpty()) {
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                int indexDropdownItemsSheet = this.book.getSheetIndex("dropdown_items_sheet");
                if (indexDropdownItemsSheet >= 0) {
                    this.book.setSheetHidden(indexDropdownItemsSheet, true);
                }
                this.book.write((OutputStream)os);
                byte[] data = os.toByteArray();
                TempFileCache tempFile = CacheFactory.getCommonCacheFactory().getTempFileCache();
                LocalDate now = LocalDate.now();
                String fileName = String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25_%1$s_%2$02d%3$02d.xlsx", (String)"BatchImportFailedSheetHandler_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.ctx.getListName(), now.getMonthValue(), now.getDayOfMonth()).replaceAll("[\n`~!@#$%^&*()+=|{}':;',\\[\\]<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c \u3001\uff1f]", "");
                String url = tempFile.saveAsUrl(fileName, data, data.length);
                RequestContext rc = RequestContext.getOrCreate();
                String path = FileNameUtils.getExportFileName((String)rc.getTenantId(), (String)rc.getAccountId(), (String)this.ctx.getAppId(), (String)(this.ctx.getBillFormId() + UUID.randomUUID().toString()), (String)fileName);
                url = this.service.upload(new FileItem(fileName, path, tempFile.getInputStream(url)));
                this.importLogger.setErrFile(UrlService.getAttachmentFullUrl((String)url));
            }
            catch (Throwable e) {
                throw new KDBizException(e, new ErrorCode("", e instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u9519\u8bef\u6570\u636e\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"BatchImportFailedSheetHandler_3", (String)"fi-bcm-formplugin", (Object[])new Object[0])), new Object[0]);
            }
            finally {
                try {
                    if (this.book != null) {
                        this.book.close();
                    }
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
                this.ctx = null;
                this.sheets.clear();
                this.book = null;
                this.importLogger = null;
            }
        }
    }

    public void handleDataValidation(Set<SheetHandler.CellValidation> cellValidations) {
        for (SheetHandler.CellValidation validation : cellValidations) {
            SXSSFSheet sheet = this.sheets.get(validation.getSheetName());
            DataValidationHelper helper = sheet.getDataValidationHelper();
            String[] rangeStrs = validation.getRange().toUpperCase(Locale.ENGLISH).split(" ");
            if (rangeStrs == null || rangeStrs.length <= 0) continue;
            for (String rg : rangeStrs) {
                List<Integer> ranges = this.splitRange(rg.split(":"));
                int rangeSize = ranges.size();
                CellRangeAddressList addressList = null;
                if (!ranges.contains(-1)) {
                    if (rangeSize == 2) {
                        addressList = new CellRangeAddressList(ranges.get(1) - 1, ranges.get(1) - 1, ranges.get(0).intValue(), ranges.get(0).intValue());
                    } else if (rangeSize == 4) {
                        addressList = new CellRangeAddressList(ranges.get(1) - 1, ranges.get(3) - 1, ranges.get(0).intValue(), ranges.get(2).intValue());
                    }
                }
                if (addressList == null) continue;
                DataValidationConstraint constraint = helper.createFormulaListConstraint(validation.getValidation());
                DataValidation dataValidation = helper.createValidation(constraint, addressList);
                if (dataValidation instanceof XSSFDataValidation) {
                    dataValidation.setSuppressDropDownArrow(true);
                    dataValidation.setShowErrorBox(true);
                } else {
                    dataValidation.setSuppressDropDownArrow(false);
                }
                sheet.addValidationData(dataValidation);
            }
        }
    }

    public void handleSheetComments(Map<String, CommentsTable> comments) {
        if (!comments.isEmpty()) {
            for (Map.Entry<String, CommentsTable> entry : comments.entrySet()) {
                String sheetName = entry.getKey();
                SXSSFSheet sheet = this.book.getSheet(sheetName);
                SXSSFRow row = this.nameRows.get(entry.getKey());
                if (row == null) continue;
                SXSSFDrawing p = sheet.createDrawingPatriarch();
                Iterator sheetcomments = entry.getValue().getCellAddresses();
                while (sheetcomments.hasNext()) {
                    CellAddress addr = (CellAddress)sheetcomments.next();
                    SXSSFCell cell = row.getCell(this.countIndex(addr.getColumn()));
                    XSSFComment comment = entry.getValue().findCellComment(addr);
                    if (comment.getRow() != 2) continue;
                    Comment temp = p.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, (int)((short)this.countIndex(comment.getColumn())), 2, (short)this.countIndex(comment.getColumn()) + 2, 5));
                    temp.setString((RichTextString)comment.getString());
                    cell.setCellComment(temp);
                }
            }
            comments.clear();
        }
    }

    private List<Integer> splitRange(String[] subRanges) {
        ArrayList<Integer> ranges = new ArrayList<Integer>(10);
        try {
            for (int i = 0; i < subRanges.length; ++i) {
                char c;
                int k;
                int j = 0;
                int len = subRanges[i].length();
                for (k = 1; k < len && (c = subRanges[i].charAt(k)) >= 'A' && c <= 'Z'; ++k) {
                }
                ranges.add(this.CharsToNumber(subRanges[i].substring(j, k)));
                ranges.add(Integer.parseInt(subRanges[i].substring(k)));
            }
        }
        catch (Throwable e) {
            log.error(e);
        }
        return ranges;
    }

    private int CharsToNumber(String letter) {
        if (letter == null || letter.isEmpty()) {
            return -1;
        }
        String upperLetter = letter.toUpperCase(Locale.ENGLISH);
        if (!upperLetter.matches("[A-Z]+")) {
            return -1;
        }
        long num = 0L;
        long base = 1L;
        for (int i = upperLetter.length() - 1; i >= 0; --i) {
            char ch = upperLetter.charAt(i);
            if ((num += (long)(ch - 65 + this.countIndex(0)) * (base *= 26L)) <= Integer.MAX_VALUE) continue;
            return -1;
        }
        return (int)num;
    }
}

