/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.bos;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.HeartBeat;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionLockHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.bos.BatchImportFailedSheetHandler;
import kd.fi.bcm.formplugin.dimension.batchimp.bos.BcmBatchImportSheetHandler;
import org.apache.commons.lang3.StringUtils;

public class BcmBatchImportPlugin
extends BatchImportPlugin {
    private static Log log = LogFactory.getLog(BcmBatchImportPlugin.class);
    private HeartBeat heartbeat = new HeartBeat();

    protected void importData() {
        Long dimensionId = Long.parseLong(this.ctx.getOption().get("BcmDimensionId").toString());
        DimensionLockHelper.executeWithDimensionLock((long)dimensionId, (int)10, (TimeUnit)TimeUnit.MILLISECONDS, (String)String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6b63\u5728\u6267\u884c\u6570\u636e\u5bfc\u5165\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"BcmBatchImportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), RequestContext.get().getUserName()), () -> {
            this._importData();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _importData() {
        try {
            long aTick = System.currentTimeMillis();
            this.beforeImport();
            boolean isShowStackTrace = SystemParamServiceHelper.isShowStackTrace();
            for (String url : this.ctx.getAllUrls()) {
                LinkedBlockingQueue dataQ = this.ctx.getDataQueue(url);
                ArrayList delRows = new ArrayList(this.getBatchImportSize());
                ImportLogger logger = this.ctx.getLogger(url);
                logger.setDelRows((List)delRows);
                ArrayList<ImportBillData> leftRowdatas = new ArrayList<ImportBillData>(this.getBatchImportSize());
                ArrayList<ImportBillData> billdatas = new ArrayList<ImportBillData>(this.getBatchImportSize());
                ArrayList tempBilldatas = new ArrayList(this.getBatchImportSize());
                while (this.checkHasDataLeft(url, dataQ, leftRowdatas)) {
                    IAppCache cache = AppCache.get((String)EntityMetadataCache.getDataEntityType((String)this.getBillFormId()).getAppId());
                    if (cache.get("IMPT_SUSPEND_" + this.getBillFormId(), String.class) != null) {
                        cache.remove("IMPT_SUSPEND_" + this.getBillFormId());
                        break;
                    }
                    int leftRowDatasCount = this.countBatchRows(leftRowdatas);
                    int needCount = this.getBatchImportSize() - leftRowDatasCount;
                    if (needCount > 0 && this.checkHasDataLeft(url, dataQ, null) || leftRowDatasCount <= 0) {
                        ImportBillData billdata = (ImportBillData)dataQ.poll(3L, TimeUnit.SECONDS);
                        if (billdata == null || billdata.isEmpty()) continue;
                        leftRowdatas.add(billdata);
                        if ((needCount -= Math.max(1, billdata.getEndIndex() - billdata.getStartIndex() + 1)) > 0) {
                            dataQ.drainTo(tempBilldatas, needCount);
                            for (ImportBillData tempBill : tempBilldatas) {
                                if (tempBill == null || tempBill.isEmpty()) continue;
                                leftRowdatas.add(tempBill);
                                needCount -= Math.max(1, tempBill.getEndIndex() - tempBill.getStartIndex() + 1);
                            }
                            tempBilldatas.clear();
                        }
                        if (this.isForceBatch() && needCount > 0 && this.checkHasDataLeft(url, dataQ, null)) continue;
                        log.info("------needCount = " + needCount + "-------ctx.isResolveComplete(url) = " + this.ctx.isResolveComplete(url) + "--------dataQ.size = " + dataQ.size() + "-------leftRowdatas.size() = " + leftRowdatas.size());
                    }
                    this.filterFromLeftRowDatas(leftRowdatas, billdatas);
                    log.info(String.format("----BatchImportPlugin--\u5f53\u524d\u5206\u6279\uff1a\u5171%d\u884c%d\u5355", this.countBatchRows(billdatas), billdatas.size()));
                    this.beforeSave(billdatas, logger);
                    if (!billdatas.isEmpty()) {
                        int firstRow = ((ImportBillData)billdatas.get(0)).getStartIndex();
                        ApiResult apiResult = null;
                        try {
                            apiResult = this.save(billdatas, logger);
                        }
                        catch (KDBizException kdexp) {
                            logger.log(Integer.valueOf(firstRow), kdexp.getMessage()).setFailed(logger.getFailed() + billdatas.size());
                        }
                        catch (Throwable exp) {
                            log.error(exp);
                            if (isShowStackTrace) {
                                logger.log(Integer.valueOf(firstRow), exp).setFailed(logger.getFailed() + billdatas.size());
                            } else {
                                String importErrMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5f02\u5e38\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"BcmBatchImportPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                                logger.log(Integer.valueOf(firstRow), exp instanceof KDBizException ? exp.getMessage() : importErrMsg).setFailed(logger.getFailed() + billdatas.size());
                            }
                        }
                        finally {
                            this.buildResult(apiResult, delRows, billdatas, url);
                        }
                    }
                    logger.setTotal(logger.getFailed() + logger.getDelRows().size());
                    if (billdatas.isEmpty()) continue;
                    int lastEndIndex = ((ImportBillData)billdatas.get(billdatas.size() - 1)).getEndIndex();
                    billdatas.clear();
                    this.ctx.feedbackProgress(Math.min(99, lastEndIndex * 100 / logger.getLastRowIndex()), logger, null);
                }
                log.info(String.format("----BatchImportPlugin--\uff1actx=%s url:%s logger:%s", this.ctx, url, logger == null));
                this.ctx.feedbackProgress(99, logger, !this.ctx.isResolveComplete(url) ? ResManager.loadKDString((String)"\u89e3\u6790\u7ebf\u7a0b\u8d85\u65f6,\u672a\u5b8c\u6210\u3002", (String)"BcmBatchImportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : null);
                this.beforeEndLogStatistic(logger);
            }
            int total = 0;
            int failed = 0;
            for (String url : this.ctx.getAllUrls()) {
                ImportLogger logger = this.ctx.getLogger(url);
                log.info(String.format("----BatchImportPlugin--\uff1atotal=%s failed:%s logger.getRowIndex():%s", total += logger.getTotal(), failed += logger.getRowIndex() < logger.getLastRowIndex() - 1 ? logger.getTotal() - logger.getDelRows().size() : logger.getFailed(), logger.getRowIndex()));
                if (logger.getFailed() <= 0 && logger.getRowIndex() >= logger.getLastRowIndex() - 1) continue;
                this.outputFailedData(url, logger);
            }
            HashMap<String, Object> retdata = new HashMap<String, Object>(16);
            retdata.put("complete", Boolean.TRUE);
            retdata.put("info", this.ctx.getUrlLoggers());
            try {
                ImportLogHelper.logAll((Object)this.ctx.getLogId(), (String)JSON.toJSONString(retdata), (int)total, (int)failed);
            }
            catch (Exception e) {
                log.error("Failed to persistent import log for " + e.getMessage(), (Throwable)e);
            }
            this.ctx.feedbackProgress(100, null, null);
            log.info(String.format("----BatchImportPlugin--end\uff1acost time: %s", System.currentTimeMillis() - aTick));
        }
        catch (Throwable e) {
            log.error(e);
        }
        finally {
            this.getSaveWebApi().clear();
            this.afterImport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveExcel() {
        FileService service = FileServiceFactory.getAttachmentFileService();
        ExcelReader reader = new ExcelReader();
        Map option = this.ctx.getOption();
        for (String url : this.ctx.getAllUrls()) {
            try {
                InputStream in = service.getInputStream(url);
                Throwable throwable = null;
                try {
                    MainEntityType mainEntityType = this.buildMainEntityType(null);
                    if (mainEntityType instanceof QueryEntityType) {
                        mainEntityType = ((QueryEntityType)mainEntityType).getMainEntityType();
                    }
                    reader.read(in, (SheetHandler)new BcmBatchImportSheetHandler(this.ctx, mainEntityType, url, option, this.heartbeat));
                }
                catch (Throwable mainEntityType) {
                    throwable = mainEntityType;
                    throw mainEntityType;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable mainEntityType) {
                            throwable.addSuppressed(mainEntityType);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Throwable e) {
                log.error(e);
                if (SystemParamServiceHelper.isShowStackTrace()) {
                    this.ctx.getLogger(url).log(Integer.valueOf(0), e);
                } else {
                    Throwable cause = e.getCause();
                    String importErrMsg = cause instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"BcmBatchImportPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    this.ctx.getLogger(url).log(Integer.valueOf(0), importErrMsg);
                }
                this.ctx.addBillData(url, new ImportBillData(new JSONObject(), 0, 0));
            }
            finally {
                this.ctx.setResolveComplete(url);
            }
        }
    }

    protected void beforeImport() {
    }

    protected void beforeEndLogStatistic(ImportLogger logger) {
    }

    protected void afterImport() {
    }

    private boolean checkHasDataLeft(String url, LinkedBlockingQueue<ImportBillData> dataQ, List<ImportBillData> leftRowdatas) {
        return !this.ctx.isResolveComplete(url) || !dataQ.isEmpty() || leftRowdatas != null && !leftRowdatas.isEmpty();
    }

    protected int countBatchRows(List<ImportBillData> billdatas) {
        int countRows = 0;
        for (ImportBillData billdata : billdatas) {
            if (billdata.getEndIndex() < billdata.getStartIndex()) continue;
            countRows += billdata.getEndIndex() - billdata.getStartIndex() + 1;
        }
        return countRows;
    }

    protected void filterFromLeftRowDatas(List<ImportBillData> leftRowdatas, List<ImportBillData> rowdatas) {
        ImportBillData billdata;
        int billRowSpan;
        int batchSize = this.getBatchImportSize();
        int i = 0;
        for (int needRowsCount = batchSize - this.countBatchRows(rowdatas); i < leftRowdatas.size() && needRowsCount > 0 && !this.checkIfRefPrevData(billdata, (billRowSpan = (billdata = leftRowdatas.get(i)).getEndIndex() - billdata.getStartIndex() + 1) > batchSize); needRowsCount -= Math.max(1, billRowSpan)) {
            billdata = leftRowdatas.remove(i);
            rowdatas.add(billdata);
        }
        if (rowdatas.isEmpty() && !leftRowdatas.isEmpty()) {
            rowdatas.add(leftRowdatas.remove(0));
        }
    }

    protected boolean checkIfRefPrevData(ImportBillData importBillData, boolean isBigData) {
        return false;
    }

    private void buildResult(ApiResult apiResult, List<int[]> delRows, List<ImportBillData> billdatas, String url) {
        if (apiResult != null) {
            List billResults = (List)apiResult.getData();
            for (Map billResult : billResults) {
                Object dindex;
                if (((Boolean)billResult.get("success")).booleanValue()) {
                    ArrayList successIds = new ArrayList(10);
                    successIds.add(billResult.get("id"));
                    dindex = (Integer)billResult.get("dindex");
                    delRows.add(new int[]{billdatas.get((Integer)dindex).getStartIndex(), billdatas.get((Integer)dindex).getEndIndex()});
                    continue;
                }
                if (billResult.containsKey("convertResult")) {
                    Map convertResult = (Map)billResult.get("convertResult");
                    for (Map.Entry entry : convertResult.entrySet()) {
                        this.ctx.getLogger(url).log((Integer)entry.getKey(), StringUtils.join((Object[])((List)entry.getValue()).toArray(), (String)";"));
                    }
                    this.ctx.getLogger(url).fail();
                    continue;
                }
                String msg = (String)billResult.get("message");
                if (StringUtils.isBlank((CharSequence)msg)) {
                    List list;
                    Object objData = billResult.get("data");
                    if (objData instanceof Map) {
                        List errList;
                        Map map = (Map)objData;
                        if (map != null && ((Boolean)map.get("success")).booleanValue() && (errList = (List)map.get("AllErrorOrValidateInfo")) != null && !errList.isEmpty()) {
                            StringBuilder stb = new StringBuilder();
                            for (Map errinfo : errList) {
                                stb.append(errinfo.get("message"));
                            }
                            msg = stb.toString();
                        }
                    } else if (objData instanceof List && !(list = (List)objData).isEmpty()) {
                        StringBuilder stb = new StringBuilder();
                        for (OperateErrorInfo errinfo : list) {
                            stb.append(errinfo.getMessage());
                        }
                        msg = stb.toString();
                    }
                }
                dindex = (Integer)billResult.get("dindex");
                this.ctx.getLogger(url).log(Integer.valueOf(billdatas.get((Integer)dindex).getStartIndex()), msg).fail();
            }
        }
    }

    private void outputFailedData(String url, ImportLogger logger) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream in = service.getInputStream(url);){
            new ExcelReader().read(in, (SheetHandler)new BatchImportFailedSheetHandler(this.ctx, logger, service));
        }
        catch (Throwable e) {
            log.error(e);
            if (SystemParamServiceHelper.isShowStackTrace()) {
                logger.log(Integer.valueOf(0), e);
            }
            logger.log(Integer.valueOf(0), e instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"BcmBatchImportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        ArrayList<ComboItem> onlyNumberShow = new ArrayList<ComboItem>(10);
        for (ComboItem item : super.getOverrideFieldsConfig()) {
            if (!"number".equals(item.getValue())) continue;
            onlyNumberShow.add(item);
        }
        return onlyNumberShow;
    }
}

