/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.bos;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.HeartBeat;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.form.plugin.impt.ImportEntityMapping;
import kd.bos.impt.SheetHandler;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.common.enums.ExchangeEnum;
import org.apache.commons.collections.CollectionUtils;
import org.xml.sax.SAXException;

public class BcmBatchImportSheetHandler
extends SheetHandler {
    private String url;
    private ImportContext ctx;
    private MainEntityType mainEntityType;
    private LinkedBlockingQueue<ImportBillData> dataQueue;
    private ImportLogger logger;
    private Map<Integer, String> nameRow;
    private ImportEntityMapping entityMapping;
    private int dataIndex = 0;
    private int startRowNum = 0;
    private int lastStartRowNum = 0;
    private int startEntryRowNum = 0;
    private boolean errorData = false;
    private boolean isNewFormat = true;
    private boolean hasErrorCol;
    private JSONObject data;
    private Set<Integer> forceInjectedCols = new HashSet<Integer>(8);
    private SheetHandler.ParsedRow currentRow;
    private Map<String, Object> option = new HashMap<String, Object>(16);
    private HeartBeat heartbeat;

    public SheetHandler.ParsedRow getCurrentRow() {
        return this.currentRow;
    }

    public void setCurrentRow(SheetHandler.ParsedRow currentRow) {
        this.currentRow = currentRow;
    }

    public Map<String, Object> getOption() {
        return this.option;
    }

    public void setOption(Map<String, Object> option) {
        this.option = option;
    }

    @Deprecated
    public BcmBatchImportSheetHandler(ImportContext ctx, MainEntityType mainEntityType, String url) {
        this.ctx = ctx;
        this.url = url;
        this.mainEntityType = mainEntityType;
        this.dataQueue = ctx.getDataQueue(url);
        this.logger = ctx.getLogger(url);
    }

    public BcmBatchImportSheetHandler(ImportContext ctx2, MainEntityType mainEntityType2, String url2, HeartBeat heartbeat) {
        this(ctx2, mainEntityType2, url2);
        this.heartbeat = heartbeat;
    }

    public BcmBatchImportSheetHandler(ImportContext ctx2, MainEntityType mainEntityType2, String url2, Map<String, Object> option, HeartBeat heartbeat) {
        this(ctx2, mainEntityType2, url2);
        this.option = option;
        this.heartbeat = heartbeat;
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        if (this.heartbeat != null) {
            this.heartbeat.refresh();
        }
        int currRowNum = row.getRowNum();
        this.logger.setRowIndex(currRowNum);
        if (currRowNum == 0) {
            this.logger.setLastRowIndex(this.getRowCount());
            if (row.isEmpty()) {
                return;
            }
            String entityName = row.get(Integer.valueOf(0));
            if (StringUtils.isEmpty((CharSequence)entityName)) {
                entityName = row.get(Integer.valueOf(1));
                this.hasErrorCol = true;
            }
            if (entityName == null || !entityName.contains(" # ") || !this.mainEntityType.getName().equalsIgnoreCase(entityName.split(" # ", -1)[1])) {
                this.addBillData(new ImportBillData(this.data, this.startRowNum, currRowNum));
                this.ctx.setResolveComplete(this.url);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u4e0e\u5355\u636e\u4e0d\u5339\u914d\uff0c\u5bfc\u5165\u5931\u8d25\uff0c\u6570\u636e\uff1a\u201c%s\u201d\u3002", (String)"BcmBatchImportSheetHandler_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), entityName));
            }
        }
        if (currRowNum == 2) {
            this.nameRow = row.getData();
            this.initForceColumns(this.nameRow);
            this.isNewFormat = !this.nameRow.get(this.hasErrorCol ? 1 : 0).contains(" # ");
            this.ctx.setNewFormat(this.isNewFormat);
        }
        if (currRowNum >= 2) {
            if (this.isNewFormat) {
                this.buildBill(row);
            } else {
                this.buildBillOld(row);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildBill(SheetHandler.ParsedRow row) {
        int currRowNum = row.getRowNum();
        if (currRowNum == 3) {
            this.entityMapping = ImportEntityMapping.create((DynamicObjectType)this.mainEntityType, this.nameRow, (Map)row.getData());
            if ("bcm_accountmemberimp".equals(this.mainEntityType.getName()) || "bcm_extmemberimp".equals(this.mainEntityType.getName())) {
                this.addExchangeAndEntryrate();
            }
        } else if (currRowNum > 3) {
            try {
                if (!this.entityMapping.isSameOne(this.currentRow, row.getData()) ? !this.addNewBillData(row) : this.ctx.isBatchByEntry() && currRowNum - this.startEntryRowNum >= this.ctx.getBatchEntryRowSize() && !this.addNewEntryBatch(row)) {
                    return;
                }
                List errMsg = this.entityMapping.push(this.currentRow, row, this.data != null ? this.data : new JSONObject());
                this.forceInjectedCols.stream().forEach(colIndex -> this.data.put(this.nameRow.get(colIndex), (Object)row.get(colIndex)));
                if (!errMsg.isEmpty()) {
                    this.errorData = true;
                    this.logger.log(Integer.valueOf(currRowNum), String.join((CharSequence)"; ", errMsg) + ";");
                }
            }
            finally {
                this.currentRow = row;
            }
        }
    }

    private void addExchangeAndEntryrate() {
        if ("bcm_accountmemberimp".equals(this.mainEntityType.getName())) {
            DynamicObjectCollection accMems = ExportUtil.getAllRates((Long)((Long)this.ctx.getOption().get("BcmModelId")));
            if (CollectionUtils.isNotEmpty((Collection)accMems)) {
                ArrayList newAdds = new ArrayList(10);
                accMems.forEach(x -> {
                    Map name2Index = ExportUtil.createMappingOfAccount();
                    String number = (String)name2Index.get(x.getString("number"));
                    newAdds.add(new ValueMapItem("", StringUtils.isEmpty((CharSequence)number) ? x.getString("number") : number, new LocaleString(x.getString("name"))));
                });
                List excComboItems = ((ComboProp)((ImportEntityMapping.ColInfo)this.entityMapping.getCols().get("exchange")).getProperty()).getComboItems();
                excComboItems.clear();
                excComboItems.addAll(newAdds);
                ValueMapItem valueMapItem = new ValueMapItem("", ExchangeEnum.NONE.index, new LocaleString(ExchangeEnum.NONE.getName()));
                ValueMapItem valueMapItem1 = new ValueMapItem("", ExchangeEnum.ONE.index, new LocaleString(ExchangeEnum.ONE.getName()));
                excComboItems.add(valueMapItem1);
                excComboItems.add(valueMapItem);
                List entComboItems = ((ComboProp)((ImportEntityMapping.ColInfo)this.entityMapping.getCols().get("entryrate")).getProperty()).getComboItems();
                entComboItems.clear();
                entComboItems.addAll(newAdds);
            }
        } else {
            DynamicObjectCollection accMems = ExportUtil.getAllRatesOfExtend((Long)((Long)this.ctx.getOption().get("BcmModelId")));
            if (CollectionUtils.isNotEmpty((Collection)accMems)) {
                List<ValueMapItem> rateCombsOfExtend = this.createRateCombsOfExtend((List<DynamicObject>)accMems);
                List excComboItems = ((ComboProp)((ImportEntityMapping.ColInfo)this.entityMapping.getCols().get("exchange")).getProperty()).getComboItems();
                excComboItems.clear();
                excComboItems.addAll(rateCombsOfExtend);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildBillOld(SheetHandler.ParsedRow row) {
        int currRowNum = row.getRowNum();
        if (currRowNum == 2) {
            this.nameRow = row.getData();
            this.initForceColumns(this.nameRow);
            this.entityMapping = ImportEntityMapping.create((DynamicObjectType)this.mainEntityType, this.nameRow);
        } else if (currRowNum > 2) {
            try {
                if (!this.entityMapping.isSameOne(this.currentRow, row.getData()) ? !this.addNewBillData(row) : this.ctx.isBatchByEntry() && currRowNum - this.startEntryRowNum >= this.ctx.getBatchEntryRowSize() && !this.addNewEntryBatch(row)) {
                    return;
                }
                List errMsg = this.entityMapping.push(this.currentRow, row, this.data != null ? this.data : new JSONObject());
                this.forceInjectedCols.stream().forEach(colIndex -> this.data.put(this.nameRow.get(colIndex), (Object)row.get(colIndex)));
                if (!errMsg.isEmpty()) {
                    if (!this.errorData) {
                        // empty if block
                    }
                    this.errorData = true;
                    this.logger.log(Integer.valueOf(currRowNum), String.join((CharSequence)"; ", errMsg) + ";");
                }
            }
            finally {
                this.currentRow = row;
            }
        }
    }

    private boolean addNewBillData(SheetHandler.ParsedRow row) {
        int currRowNum = row.getRowNum();
        if (this.entityMapping.isEntityEmpty(row.getData())) {
            return false;
        }
        if (this.data != null) {
            if (this.errorData) {
                this.logger.fail().tick();
            } else {
                ImportBillData billData = new ImportBillData(this.data, this.startEntryRowNum, currRowNum - 1, this.entityMapping);
                billData.setDataIndex(this.dataIndex);
                billData.setStartRowIndex(this.startEntryRowNum - this.startRowNum);
                this.addBillData(billData);
            }
            this.errorData = false;
            ++this.dataIndex;
        }
        this.data = new JSONObject();
        this.startRowNum = currRowNum;
        this.startEntryRowNum = currRowNum;
        return true;
    }

    private boolean addNewEntryBatch(SheetHandler.ParsedRow row) {
        int currRowNum = row.getRowNum();
        JSONObject lastData = this.data;
        if (this.data != null) {
            if (this.errorData) {
                this.logger.fail().tick();
            } else {
                ImportBillData billData = new ImportBillData(this.data, this.startEntryRowNum, currRowNum - 1, this.entityMapping);
                billData.setDataIndex(this.dataIndex);
                billData.setStartRowIndex(this.startEntryRowNum - this.startRowNum);
                this.addBillData(billData);
            }
            this.errorData = false;
        }
        this.data = new JSONObject();
        if (lastData != null) {
            for (Map.Entry fieldItem : lastData.entrySet()) {
                if (fieldItem.getValue() instanceof JSONArray) continue;
                this.data.put((String)fieldItem.getKey(), fieldItem.getValue());
            }
        }
        this.startEntryRowNum = currRowNum;
        return true;
    }

    private void addBillData(ImportBillData billData) {
        block8: {
            block7: {
                try {
                    if (!this.dataQueue.offer(billData, 10L, TimeUnit.MINUTES)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e\u7684\u7f13\u5b58\u6c60\u5f02\u5e38\u3002", (String)"BcmBatchImportSheetHandler_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                }
                catch (Throwable e) {
                    throw new KDBizException(e instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u89e3\u6790\u7ebf\u7a0b\u5f02\u5e38\u3002", (String)"BcmBatchImportSheetHandler_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                if (this.lastStartRowNum == 0) break block7;
                if (billData.getEndIndex() - this.lastStartRowNum < 1000) break block8;
            }
            this.ctx.feedbackProgress(0, this.logger, null);
            this.lastStartRowNum = billData.getEndIndex();
        }
    }

    public void endDocument() throws SAXException {
        this.setInterrupt(this.currentRow != null);
        if (this.currentRow != null) {
            ImportBillData lastBillData;
            int currRowNum = this.currentRow.getRowNum();
            if (this.errorData) {
                this.logger.fail().tick();
                lastBillData = new ImportBillData(new JSONObject(), this.startRowNum, currRowNum);
            } else {
                lastBillData = new ImportBillData(this.data, this.startRowNum, currRowNum, this.entityMapping);
            }
            lastBillData.setDataIndex(this.dataIndex);
            lastBillData.setStartRowIndex(this.startEntryRowNum - this.startRowNum);
            this.addBillData(lastBillData);
        }
        this.ctx.setResolveComplete(this.url);
    }

    private void initForceColumns(Map<Integer, String> nameRow) {
        if (Objects.nonNull(nameRow) && !nameRow.isEmpty()) {
            nameRow.forEach((index, colName) -> {
                if (ExportUtil.isValueDefinedPropertyColumnName((String)colName)) {
                    this.forceInjectedCols.add((Integer)index);
                }
            });
        }
    }

    private List<ValueMapItem> createRateCombsOfExtend(List<DynamicObject> accMems) {
        ArrayList<ValueMapItem> accountComs = new ArrayList<ValueMapItem>(10);
        ValueMapItem valueMapItemTerm = new ValueMapItem("", ExchangeEnum.TERMINAL.index, new LocaleString(ExchangeEnum.TERMINAL.getName()));
        accountComs.add(valueMapItemTerm);
        ValueMapItem valueMapItemAve = new ValueMapItem("", ExchangeEnum.AVERAGE.index, new LocaleString(ExchangeEnum.AVERAGE.getName()));
        accountComs.add(valueMapItemAve);
        ValueMapItem valueMapItemDef = new ValueMapItem("", ExchangeEnum.UserdefinedRate.index, new LocaleString(ExchangeEnum.UserdefinedRate.getName()));
        accountComs.add(valueMapItemDef);
        accMems.forEach(x -> {
            ValueMapItem valueMapItem = new ValueMapItem("", x.getString("number"), new LocaleString(x.getString("name")));
            accountComs.add(valueMapItem);
        });
        ValueMapItem valueMapItemOne = new ValueMapItem("", ExchangeEnum.ONE.index, new LocaleString(ExchangeEnum.ONE.getName()));
        accountComs.add(valueMapItemOne);
        ValueMapItem valueMapItemNone = new ValueMapItem("", ExchangeEnum.NONE.index, new LocaleString(ExchangeEnum.NONE.getName()));
        accountComs.add(valueMapItemNone);
        return accountComs;
    }
}

