/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.bos;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Operations;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.ImportStartPlugin;
import kd.fi.bcm.business.dimension.helper.DimensionLockHelper;

public class BcmBatchImportStartPlugin
extends ImportStartPlugin {
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private final List<String> UN_HAVE_BTN_PRE_VIEW = Lists.newArrayList((Object[])new String[]{"bcm_permissionclass", "bcm_auth_import", "bcm_memberperm", "bcm_perm_roleperm", "bcm_exchagerate", "bcm_convertdiffentity", "bcm_commadjust_tpl_import", "bcm_chkformulasetting", "fidm_dataset_single"});
    private final Set<String> SHOW_DOWNLOAD_TMPL_FORM = Sets.newHashSet((Object[])new String[]{"bcm_memberlistimp", "bcm_commadjust_tpl_import"});

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btndownload", "btnresetfile", "btnpreview"});
        Image label = (Image)this.getControl("btnupload");
        label.addUploadListener((UploadListener)this);
    }

    public void afterBindData(EventObject e) {
        String billFormId;
        super.afterBindData(e);
        IFormView view = this.getView();
        FormShowParameter showParam = view.getFormShowParameter();
        String userDefinedPro = (String)showParam.getCustomParam("fromUserDefinedPropertyImport");
        String defaultValue = (String)showParam.getCustomParam("fromDimDefaultValue");
        if (StringUtils.isNotEmpty((CharSequence)userDefinedPro) || StringUtils.isNotEmpty((CharSequence)defaultValue)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnpreview"});
        }
        if (this.UN_HAVE_BTN_PRE_VIEW.contains(billFormId = (String)showParam.getCustomParam("BillFormId")) || "bcm_distributionentity".equals(billFormId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnpreview"});
        }
        if (!this.SHOW_DOWNLOAD_TMPL_FORM.contains(billFormId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btndownload"});
        }
        if ("bcm_distributionentity".equals(billFormId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"radiofield"});
            this.getModel().setValue("radiofield2", (Object)true);
            this.getModel().setValue("importtype", (Object)"overridenew");
            this.getModel().setValue("keyfields", (Object)"id");
            this.getView().updateView("flexpanelap6");
            this.getView().updateView("flexpanelap7");
        }
        if ("bcm_enum_new_import".equals(billFormId)) {
            this.getModel().setValue("keyfields", (Object)"name");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelap4", "btndownload", "btnpreview"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"keyfields"});
        }
        if ("bcm_datalocksettingimpt".equals(billFormId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"radiofield"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"radiofield1"});
            this.getModel().setValue("importtype", (Object)"overridenew");
            this.getView().updateView("importtype");
            this.getModel().setValue("keyfields", (Object)"name");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelap4", "btndownload", "btnpreview"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"keyfields"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam("BillFormId");
        if ("bcm_enum_new_import".equals(billFormId) || "bcm_datalocksettingimpt".equals(billFormId)) {
            this.getModel().setValue("keyfields", (Object)"name");
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"keyfields"});
        }
    }

    public void click(EventObject evt) {
        String eventKey = ((Control)evt.getSource()).getKey();
        if ("btnok".equalsIgnoreCase(eventKey)) {
            this.importData(false);
        } else if ("btnpreview".equalsIgnoreCase(eventKey)) {
            this.importData(true);
        } else {
            super.click(evt);
        }
    }

    private void importData(boolean isDryRun) {
        long dimensionId;
        Optional lockInfo;
        String url = (String)this.getModel().getValue("filepath");
        if (StringUtils.isBlank((CharSequence)url)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)"BcmBatchImportStartPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (!Objects.equals("new", this.getModel().getValue("importtype")) && StringUtils.isBlank((Object)this.getModel().getValue("keyfields"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5339\u914d\u89c4\u5219\u3002", (String)"BcmBatchImportStartPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (this.getView().getFormShowParameter().getCustomParam("dimensionId") != null && (lockInfo = DimensionLockHelper.getWorkingLockInfo((long)(dimensionId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("dimensionId").toString())))).isPresent()) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6b63\u5728\u6267\u884c\u6570\u636e\u5bfc\u5165\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"BcmBatchImportPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), RequestContext.get().getUserName()));
            return;
        }
        this.importData(url, isDryRun);
    }

    private void importData(String url, boolean isDryRun) {
        IFormView view = this.getView();
        FormShowParameter showParam = view.getFormShowParameter();
        String billFormId = (String)showParam.getCustomParam("BillFormId");
        if ("bcm_distributionentity".equals(billFormId)) {
            view.getParentView().getPageCache().put("isImport", "true");
        }
        String listName = (String)showParam.getCustomParam("ListName");
        String serviceAppId = view.getFormShowParameter().getServiceAppId();
        String checkRightAppId = (String)showParam.getCustomParam("CheckRightAppId");
        Operations ops = EntityMetadataCache.getDataEntityOperations((String)FormMetadataCache.getFormConfig((String)billFormId).getEntityTypeId());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bcm_batch_bos_importing");
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        String importType = (String)this.getModel().getValue("importtype");
        params.put("Type", importType);
        if (!Objects.equals("new", importType)) {
            params.put("KeyFields", this.getModel().getValue("keyfields"));
        }
        params.put("IsDryRunPattern", isDryRun);
        params.put("ServiceAppId", serviceAppId);
        params.put("CheckRightAppId", checkRightAppId);
        params.put("BillFormId", billFormId);
        params.put("RealPermissionEntityId", showParam.getCustomParam("RealPermissionEntityId"));
        params.put("ListName", listName);
        params.put("OpSave", ops.getSave());
        params.put("Url", url);
        params.put("ImportPlugin", this.getImportPlugin(showParam));
        params.put("enumitemId", showParam.getCustomParam("enumitemId"));
        params.put("BcmModelId", showParam.getCustomParam("modelid"));
        params.put("BcmDimensionId", showParam.getCustomParam("dimensionId"));
        String definedPro = (String)showParam.getCustomParam("fromUserDefinedPropertyImport");
        String defaultValue = (String)showParam.getCustomParam("fromDimDefaultValue");
        if (StringUtils.isNotEmpty((CharSequence)definedPro)) {
            params.put("fromUserDefinedPropertyImport", "userDefinedPropertyImport");
        }
        if (StringUtils.isNotEmpty((CharSequence)defaultValue)) {
            params.put("fromDimDefaultValue", "DimDefaultValueBatchImport");
        }
        params.put("OperateKey", showParam.getCustomParam("OperateKey"));
        showParameter.setCustomParams(params);
        showParameter.setParentPageId(view.getFormShowParameter().getParentPageId());
        showParameter.setCloseCallBack(view.getFormShowParameter().getCloseCallBack());
        view.showForm(showParameter);
    }

    private String getImportPlugin(FormShowParameter showParam) {
        List plugins;
        String pluginName = (String)showParam.getCustomParam("ImportPlugin");
        if (StringUtils.isBlank((CharSequence)pluginName) && (plugins = (List)showParam.getCustomParam("plugins")) != null) {
            for (Map p : plugins) {
                if (!Boolean.TRUE.equals(p.get("Enabled"))) continue;
                return (String)p.get("ClassName");
            }
        }
        return pluginName;
    }
}

