/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.defaultValue;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class DefaultValueDBCache {
    private static Map<String, DynamicObject> defaultValuesCache;
    private static volatile DefaultValueDBCache dbCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultValueDBCache getDBBatchCacheOfDefaultValue(long modelId) {
        if (dbCache != null) return dbCache;
        Class<DefaultValueDBCache> clazz = DefaultValueDBCache.class;
        synchronized (DefaultValueDBCache.class) {
            if (dbCache != null) return dbCache;
            DefaultValueDBCache.initDBBatchCacheOfDefaultValue(modelId);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return dbCache;
        }
    }

    private static void initDBBatchCacheOfDefaultValue(long modelId) {
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        String selectFields = "id,dimension,usedinmenu,defaultvalue,defaultvalueid,defaultnumber,creatorid,createdate,modifierld,modifydate";
        DynamicObject[] defaultValues = BusinessDataServiceHelper.load((String)"bcm_defaultvalue", (String)selectFields, (QFilter[])modelQf.toArray());
        defaultValuesCache = new HashMap<String, DynamicObject>(32);
        for (DynamicObject defaultValue : defaultValues) {
            String key = defaultValue.getString("dimension") + "_" + defaultValue.getString("usedinmenu");
            defaultValuesCache.put(key, defaultValue);
        }
        dbCache = new DefaultValueDBCache();
    }

    public static void updateDBBatchCacheOfDefaultValue(long modelId, List<DynamicObject> defaultDys) {
        if (CollectionUtils.isEmpty(defaultDys)) {
            return;
        }
        dbCache = DefaultValueDBCache.getDBBatchCacheOfDefaultValue(modelId);
        defaultDys.forEach(ele -> {
            String usedinmenu;
            String dimension = ele.getString("dimension");
            if (dbCache.getDefaultValue(dimension, usedinmenu = ele.getString("usedinmenu")) == null) {
                dbCache.setDefaultValue(dimension, usedinmenu, (DynamicObject)ele);
            }
        });
    }

    public DynamicObject getDefaultValue(String dimensionNum, String usedinmenu) {
        return defaultValuesCache.get(dimensionNum + "_" + usedinmenu);
    }

    public DynamicObject setDefaultValue(String dimensionNum, String usedinmenu, DynamicObject dy) {
        return defaultValuesCache.put(dimensionNum + "_" + usedinmenu, dy);
    }

    public Map<String, DynamicObject> getDefaultValuesCache() {
        return defaultValuesCache;
    }

    public DynamicObject[] getAllValues() {
        return defaultValuesCache.values().toArray(new DynamicObject[defaultValuesCache.size()]);
    }

    public void clearDbCache() {
        defaultValuesCache.clear();
        dbCache = null;
    }
}

