/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.defaultValue;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.webapi.DefaultOperate;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.ModelLockHelper;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.bos.BcmBatchImportPlugin;
import kd.fi.bcm.formplugin.dimension.batchimp.defaultValue.DefaultValueDBCache;
import kd.fi.bcm.formplugin.dimension.batchimp.event.FailLogSubscriber;
import kd.fi.bcm.formplugin.dimension.batchimp.event.ImportEventHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.event.ImportFinishEvent;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.DimensionImportContext;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportBillIndexWrap;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportResultEntry;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.OverrideResultEntry;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.PersistEntry;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.IDimensionImportValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.defaultvalue.DefaultValueImportValidator;
import kd.fi.bcm.formplugin.impexport.BillResult;
import org.apache.commons.compress.utils.Lists;

public class DimDefaultValueBatchImport
extends BcmBatchImportPlugin {
    protected static final Log LOG = LogFactory.getLog(DimDefaultValueBatchImport.class);
    protected String entityName;
    protected String appId;
    private int curBatch = 0;
    protected volatile long modelId = 0L;
    protected volatile DynamicObject model = null;
    protected boolean isModelManager = false;
    protected DefaultValueDBCache defaultValueDBCache;
    private List<IDimensionImportValidator> validators;
    private List<String> curBatchDims = Lists.newArrayList();

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        super.setContext(rc, ctx, startArgs);
        this.entityName = ctx.getBillFormId();
        this.appId = ctx.getAppId();
        return this;
    }

    protected int getBatchImportSize() {
        return 10000;
    }

    protected boolean isForceBatch() {
        return true;
    }

    public AbstractOperateWebApi getSaveWebApi() {
        return new DefaultOperate();
    }

    public String getDefaultKeyFields() {
        return "defaultnumber";
    }

    @Override
    protected void importData() {
        Long modelId = Long.parseLong(this.ctx.getOption().get("BcmModelId").toString());
        ModelLockHelper.executeWithModelLock((long)modelId, (String)this.entityName, (int)10, (TimeUnit)TimeUnit.MILLISECONDS, (String)String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6b63\u5728\u6267\u884c\u6570\u636e\u5bfc\u5165\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"BcmBatchImportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), RequestContext.get().getUserName()), () -> {
            this._importData();
            return null;
        });
    }

    @Override
    public void beforeImport() {
        super.beforeImport();
        long tick = System.currentTimeMillis();
        this.initImportContext();
        LOG.info(this.genLogPrefix("init.beforeImport") + String.format(" cost time: %s", System.currentTimeMillis() - tick));
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        FailLogSubscriber.importLogger.set(logger);
        ++this.curBatch;
        int batchSize = rowdatas.size();
        LOG.info(this.genLogPrefix("ready") + "size: " + batchSize);
        long sTick = System.currentTimeMillis();
        this.beforeValidation(rowdatas);
        List allValidateResults = BatchProcessHelper.batchHandle(rowdatas, (int)2000, (int)500, x -> this.validateBatchBills((List<ImportBillData>)x), null, (BatchProcessHelper.Scene)BatchProcessHelper.Scene.CPU);
        ArrayList<BillResult> savedBillResults = new ArrayList<BillResult>(16);
        ArrayList<ImportBillData> validatedBillData = new ArrayList<ImportBillData>(16);
        Iterator<ImportBillData> rowDataIter = rowdatas.iterator();
        int index = 0;
        int validIndex = 0;
        while (rowDataIter.hasNext()) {
            ImportBillData data = rowDataIter.next();
            Optional validMsg = (Optional)allValidateResults.get(index);
            if (validMsg.isPresent()) {
                logger.log(Integer.valueOf(data.getStartIndex()), (String)validMsg.get()).fail();
                rowDataIter.remove();
                ImportEventHelper.sendImportFinishEvent(new ImportFinishEvent(ImportFinishEvent.ImportStatus.FAIL, this.modelId, 0L, data.getData().getString("number")));
            } else {
                validatedBillData.add(data);
                BillResult result = new BillResult();
                result.setIndex(validIndex++);
                result.setNumber(data.getData().getString("number"));
                result.setSucess(true);
                result.setData((Map<String, Object>)data.getData());
                savedBillResults.add(result);
            }
            ++index;
        }
        LOG.info(this.genLogPrefix("validation") + String.format("batchSize: %s, cost time: %s", batchSize, System.currentTimeMillis() - sTick));
        long duTick = System.currentTimeMillis();
        List<Object> resultEntries = new ArrayList(validatedBillData.size());
        if (!validatedBillData.isEmpty()) {
            resultEntries = this.saveBatch(validatedBillData);
            for (int i = 0; i < resultEntries.size(); ++i) {
                if (((ImportResultEntry)resultEntries.get(i)).isErr()) {
                    ((BillResult)savedBillResults.get(i)).setSucess(false);
                    ((BillResult)savedBillResults.get(i)).setMessage(((ImportResultEntry)resultEntries.get(i)).getErrMsg());
                }
                ImportEventHelper.sendImportFinishEvent(new ImportFinishEvent(((ImportResultEntry)resultEntries.get(i)).isErr() ? ImportFinishEvent.ImportStatus.FAIL : ImportFinishEvent.ImportStatus.SUCCESS, this.modelId, 0L, ((BillResult)savedBillResults.get(i)).getNumber()));
            }
        }
        LOG.info(this.genLogPrefix("dataUpdated") + String.format("size: %s, cost time: %s", validatedBillData.size(), System.currentTimeMillis() - duTick));
        if (savedBillResults.size() != resultEntries.size()) {
            throw new IllegalStateException("the count of saved result not equals the process count");
        }
        long puTick = System.currentTimeMillis();
        ApiResult apiResult = new ApiResult();
        ArrayList<Map<String, Object>> apiResultData = new ArrayList<Map<String, Object>>(10);
        for (int i = 0; i < savedBillResults.size(); ++i) {
            if (((ImportResultEntry)resultEntries.get(i)).isErr()) {
                apiResult.setSuccess(false);
            }
            apiResultData.add(((BillResult)savedBillResults.get(i)).toMap());
        }
        apiResult.setData(apiResultData);
        LOG.info(this.genLogPrefix("postUpdated") + String.format("size: %s, cost time: %s", validatedBillData.size(), System.currentTimeMillis() - puTick));
        return apiResult;
    }

    private List<ImportResultEntry> saveBatch(List<ImportBillData> billDataList) {
        List<Object> resultEntries = new ArrayList(billDataList.size());
        List<ImportBillIndexWrap> billWraps = ImportBillIndexWrap.buildWrapList(billDataList);
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        try {
            if (ImportOperateType.NEW == importType) {
                resultEntries = this.insertNewBatch(billWraps);
            } else if (ImportOperateType.OVERRIDE == importType) {
                resultEntries = this.overrideBatch(billWraps);
            } else if (ImportOperateType.OVERRIDENEW == importType) {
                List<ImportResultEntry> rawOverrideResults = this.overrideBatch(billWraps);
                List<ImportBillIndexWrap> failedOverrideBillWraps = rawOverrideResults.stream().filter(x -> x.isErr()).map(x -> new ImportBillIndexWrap((ImportBillData)billDataList.get(x.getIndex()), x.getIndex())).collect(Collectors.toList());
                List<ImportResultEntry> insertResults = this.insertNewBatch(failedOverrideBillWraps);
                resultEntries.addAll(rawOverrideResults.stream().filter(x -> !x.isErr()).collect(Collectors.toList()));
                resultEntries.addAll(insertResults);
            }
        }
        catch (Exception e) {
            LOG.error("dimension_import_submit allfailed:" + e.getMessage(), (Throwable)e);
            resultEntries = billWraps.stream().map(x -> ImportResultEntry.error(ImportMsgUtils.unexpectedError() + e.getMessage(), x.getListIndex())).collect(Collectors.toList());
        }
        return resultEntries;
    }

    private List<ImportResultEntry> overrideBatch(List<ImportBillIndexWrap> billDataList) {
        List<ImportBillIndexWrap> nonshareBills = billDataList;
        List<ImportResultEntry> nonShareImportEntries = this.overrideNonShareMemberBatch(nonshareBills);
        ArrayList<ImportResultEntry> allEntries = new ArrayList<ImportResultEntry>(nonShareImportEntries.size());
        allEntries.addAll(nonShareImportEntries);
        return allEntries;
    }

    private List<ImportResultEntry> overrideNonShareMemberBatch(List<ImportBillIndexWrap> billDataList) {
        if (CollectionUtils.isEmpty(billDataList)) {
            return Collections.EMPTY_LIST;
        }
        long tick = System.currentTimeMillis();
        List rawOverrideEntries = BatchProcessHelper.batchHandle(billDataList, (int)2000, (int)500, x -> this.handleAssembleOverrideMemberEntity((List<ImportBillIndexWrap>)x), null, (BatchProcessHelper.Scene)BatchProcessHelper.Scene.CPU);
        LOG.info(this.genLogPrefix("override.packData") + String.format("batchSize: %s, cost time: %s", rawOverrideEntries.size(), System.currentTimeMillis() - tick));
        List needOverrideEntries = rawOverrideEntries.stream().filter(x -> x.isNeedOverride()).collect(Collectors.toList());
        List<DynamicObject> dynamicObjects = needOverrideEntries.stream().map(x -> x.getOverridDy()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(dynamicObjects)) {
            TXHandle tx = TX.required();
            Object object = null;
            try {
                try {
                    long tempTick = System.currentTimeMillis();
                    SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
                    LOG.info(this.genLogPrefix("override.update") + String.format("batchSize: %s, cost time: %s", needOverrideEntries.size(), System.currentTimeMillis() - tempTick));
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw new KDBizException(e.getMessage());
                }
            }
            catch (Throwable e) {
                object = e;
                throw e;
            }
            finally {
                if (tx != null) {
                    if (object != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable e) {
                            ((Throwable)object).addSuppressed(e);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        DefaultValueDBCache.updateDBBatchCacheOfDefaultValue(this.modelId, dynamicObjects);
        ArrayList<ImportResultEntry> importEntries = new ArrayList<ImportResultEntry>(rawOverrideEntries.size());
        for (OverrideResultEntry entry : rawOverrideEntries) {
            if (entry.isNeedOverride()) {
                DynamicObject overrideDy = entry.getOverridDy();
                importEntries.add(ImportResultEntry.success(overrideDy.getLong("id"), overrideDy, entry.getBillWrap().getListIndex()));
                continue;
            }
            importEntries.add(ImportResultEntry.error(ImportMsgUtils.currentNumberNotExists(), entry.getBillWrap().getListIndex()));
        }
        return importEntries;
    }

    private List<OverrideResultEntry> handleAssembleOverrideMemberEntity(List<ImportBillIndexWrap> billDataList) {
        Map<String, DynamicObject> defaultValues = this.defaultValueDBCache.getDefaultValuesCache();
        ArrayList<OverrideResultEntry> rawOverrideEntries = new ArrayList<OverrideResultEntry>(billDataList.size());
        for (ImportBillIndexWrap billIndexWrap : billDataList) {
            JSONObject data = billIndexWrap.getBill().getData();
            DynamicObject existRecordDy = defaultValues.get(data.get("dimensionnum") + "_" + data.get("usedinmenu"));
            if (existRecordDy != null && RequestContext.get().getCurrUserId() == existRecordDy.getDynamicObject("creatorid").getLong("id")) {
                this.assemMemberTree(billIndexWrap.getBill(), existRecordDy, false);
                rawOverrideEntries.add(new OverrideResultEntry(billIndexWrap, null, null, existRecordDy, true));
                continue;
            }
            rawOverrideEntries.add(OverrideResultEntry.isSkip(billIndexWrap));
        }
        return rawOverrideEntries;
    }

    private List<ImportResultEntry> insertNewBatch(List<ImportBillIndexWrap> billDataList) {
        if (CollectionUtils.isEmpty(billDataList)) {
            return Collections.EMPTY_LIST;
        }
        long packDataTick = System.currentTimeMillis();
        List persistEntries = BatchProcessHelper.batchHandle(billDataList, (int)2000, (int)500, x -> this.handleAssembleNewMemberEntity((List<ImportBillIndexWrap>)x), null, (BatchProcessHelper.Scene)BatchProcessHelper.Scene.CPU);
        LOG.info(this.genLogPrefix("insert.packData") + String.format("batchSize: %s, cost time: %s", billDataList.size(), System.currentTimeMillis() - packDataTick));
        try (TXHandle tx = TX.required();){
            try {
                Object[] dynamicObjects = new DynamicObject[persistEntries.size()];
                int i = 0;
                for (PersistEntry persistEntry : persistEntries) {
                    dynamicObjects[i] = persistEntry.getMemberTreeDy();
                    ++i;
                }
                if (dynamicObjects.length > 0) {
                    SaveServiceHelper.save((IDataEntityType)dynamicObjects[0].getDynamicObjectType(), (Object[])dynamicObjects);
                }
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        DefaultValueDBCache.updateDBBatchCacheOfDefaultValue(this.modelId, persistEntries.stream().map(PersistEntry::getMemberTreeDy).collect(Collectors.toList()));
        ArrayList<ImportResultEntry> resultEntries = new ArrayList<ImportResultEntry>(billDataList.size());
        for (int i = 0; i < persistEntries.size(); ++i) {
            DynamicObject memberTreeDy = ((PersistEntry)persistEntries.get(i)).getMemberTreeDy();
            int billListIndex = ((PersistEntry)persistEntries.get(i)).getBillWrap().getListIndex();
            long curSucId = memberTreeDy.getLong("id");
            if (curSucId == 0L) {
                resultEntries.add(ImportResultEntry.error(ImportMsgUtils.unexpectedInsertFail(), billListIndex));
                continue;
            }
            resultEntries.add(ImportResultEntry.success(curSucId, memberTreeDy, billListIndex));
        }
        return resultEntries;
    }

    private List<PersistEntry> handleAssembleNewMemberEntity(List<ImportBillIndexWrap> billDataList) {
        ArrayList<PersistEntry> persistEntries = new ArrayList<PersistEntry>(billDataList.size());
        for (ImportBillIndexWrap billIndexWrap : billDataList) {
            DynamicObject defaultValueDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_defaultvalue");
            this.assemMemberTree(billIndexWrap.getBill(), defaultValueDy, true);
            persistEntries.add(new PersistEntry(billIndexWrap, defaultValueDy, null));
        }
        return persistEntries;
    }

    public void assemMemberTree(ImportBillData bill, DynamicObject defaultValueDy, boolean isNew) {
        JSONObject data = bill.getData();
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        if (isNew) {
            defaultValueDy.set("model", (Object)this.modelId);
            defaultValueDy.set("usedinmenu", data.get("usedinmenu"));
            defaultValueDy.set("dimension", data.get("dimensionnum"));
            defaultValueDy.set("scope", (Object)"1");
            defaultValueDy.set("defaultnumber", data.get("defaultnumber"));
            defaultValueDy.set("defaultvalue", data.get("defaultvalue"));
            defaultValueDy.set("defaultvalueid", data.get("defaultvalueid"));
            defaultValueDy.set("creatorid", (Object)currUserId);
            defaultValueDy.set("createdate", (Object)date);
            defaultValueDy.set("modifierld", (Object)currUserId);
            defaultValueDy.set("modifydate", (Object)date);
        } else {
            defaultValueDy.set("defaultnumber", data.get("defaultnumber"));
            defaultValueDy.set("defaultvalue", data.get("defaultvalue"));
            defaultValueDy.set("defaultvalueid", data.get("defaultvalueid"));
            defaultValueDy.set("modifierld", (Object)currUserId);
            defaultValueDy.set("modifydate", (Object)date);
        }
    }

    private void initImportContext() {
        if (Objects.isNull(this.model)) {
            this.model = this.getCurrentModel();
            if (Objects.isNull(this.model)) {
                throw new KDBizException(ImportMsgUtils.specificModelFirst(), new Object[0]);
            }
            this.modelId = this.model.getLong("id");
        }
        DimensionImportContext context = new DimensionImportContext(this.model, null, this.entityName, ImportHelper.getImportType(this.ctx), this.appId, this.isModelManager, null, null);
        ImportContextHolder.setImportContext(context);
        this.defaultValueDBCache = DefaultValueDBCache.getDBBatchCacheOfDefaultValue(this.modelId);
        this.validators = new ArrayList<IDimensionImportValidator>(10);
        this.validators.add(new DefaultValueImportValidator());
    }

    @Override
    protected void afterImport() {
        super.afterImport();
        this.defaultValueDBCache.clearDbCache();
    }

    protected DynamicObject getCurrentModel() {
        Long importModelId = (Long)this.ctx.getOption().get("BcmModelId");
        if (Objects.isNull(importModelId) || importModelId == 0L) {
            throw new KDBizException(ImportMsgUtils.specificModelFirst(), new Object[0]);
        }
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (String)"id,number,shownumber", (QFilter[])new QFilter("id", "=", (Object)importModelId).toArray());
    }

    private String genLogPrefix(String operationName) {
        return String.format("dimension_import:: entity: %s, batch: %s, operate: %s, ", this.curBatch, this.entityName, operationName);
    }

    protected void beforeValidation(List<ImportBillData> importedBills) {
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        switch (importType) {
            case NEW: {
                this.updateWithNewId(importedBills);
                break;
            }
            case OVERRIDE: {
                this.updateWithExistId(importedBills, false);
                break;
            }
            case OVERRIDENEW: {
                this.updateWithExistId(importedBills, true);
                break;
            }
        }
    }

    private void updateWithNewId(List<ImportBillData> newBills) {
        if (CollectionUtils.isEmpty(newBills)) {
            return;
        }
        long[] ids = DBServiceHelper.genLongIds((String)this.entityName, (int)newBills.size());
        for (int j = 0; j < newBills.size(); ++j) {
            RowDataExtUtil.addId(newBills.get(j), ids[j]);
        }
    }

    private void updateWithExistId(List<ImportBillData> existBills, boolean isOverrideNew) {
        if (!CollectionUtils.isEmpty(existBills)) {
            Map<String, DynamicObject> defaultValueEntities = ImportHelper.queryDefaultValueEntities(this.modelId);
            existBills.forEach(x -> {
                JSONObject data = x.getData();
                String dimension = data.getString("dimension");
                String usedinmenu = data.getString("usedinmenu");
                String key = dimension + "_" + usedinmenu;
                if (defaultValueEntities.containsKey(key)) {
                    RowDataExtUtil.addId(x, ((DynamicObject)defaultValueEntities.get(key)).getLong("id"));
                    RowDataExtUtil.addExistingRecord(x, (DynamicObject)defaultValueEntities.get(key));
                } else if (isOverrideNew) {
                    RowDataExtUtil.addId(x, DBServiceHelper.genGlobalLongId());
                } else {
                    RowDataExtUtil.addId(x, 0L);
                }
            });
        }
    }

    private List<Optional<String>> validateBatchBills(List<ImportBillData> bills) {
        ArrayList<Optional<String>> billValidateResults = new ArrayList<Optional<String>>(bills.size());
        for (int i = 0; i < bills.size(); ++i) {
            try {
                billValidateResults.add(this.validateBillData(bills.get(i)));
                continue;
            }
            catch (Exception e) {
                LOG.error("Failed to validate bill: " + bills.get(i).getData() + " for " + e.getMessage(), (Throwable)e);
                billValidateResults.add(Optional.of(e.getMessage()));
            }
        }
        return billValidateResults;
    }

    protected Optional<String> validateBillData(ImportBillData billData) {
        for (IDimensionImportValidator validator : this.validators) {
            try {
                Optional<String> failedMsg = validator.validate(billData);
                if (!failedMsg.isPresent()) continue;
                return failedMsg;
            }
            catch (Exception e) {
                LOG.error("Failed to import on exception:" + e.getMessage(), (Throwable)e);
                return Optional.of(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5f02\u5e38\u4e3a%s\uff1a", (String)"DimDefaultValueBatchImport_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e));
            }
        }
        return Optional.empty();
    }

    @Override
    protected void filterFromLeftRowDatas(List<ImportBillData> leftRowdatas, List<ImportBillData> rowdatas) {
        Iterator<ImportBillData> leftRowdataIter = leftRowdatas.iterator();
        while (leftRowdataIter.hasNext()) {
            ImportBillData billdata = leftRowdataIter.next();
            if (this.curBatchDims.contains(billdata.getData().getString("dimension"))) continue;
            this.curBatchDims.add(billdata.getData().getString("dimension"));
            rowdatas.add(billdata);
            leftRowdataIter.remove();
        }
        if (rowdatas.isEmpty() && !leftRowdatas.isEmpty()) {
            rowdatas.add(leftRowdatas.remove(0));
        }
    }
}

