/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.enums;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.webapi.DefaultOperate;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.ModelLockHelper;
import kd.fi.bcm.common.cache.LocalCacheHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.dimension.batchimp.bos.BcmBatchImportPlugin;
import kd.fi.bcm.formplugin.dimension.batchimp.enums.EnumNewValueValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.enums.EnumValueDBCache;
import kd.fi.bcm.formplugin.dimension.batchimp.enums.PersistEntryEnum;
import kd.fi.bcm.formplugin.dimension.batchimp.event.FailLogSubscriber;
import kd.fi.bcm.formplugin.dimension.batchimp.event.ImportEventHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.event.ImportFinishEvent;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.DimensionImportContext;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportBillIndexWrap;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportResultEntry;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.OverrideResultEntry;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.SilentJSONUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.IDimensionImportValidator;
import kd.fi.bcm.formplugin.impexport.BillResult;
import kd.fi.bcm.formplugin.util.EnumUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DimensionEnumNewImport
extends BcmBatchImportPlugin {
    protected static WatchLogger LOG = BcmLogFactory.getWatchLogInstance(DimensionEnumNewImport.class);
    protected volatile DynamicObject model = null;
    protected volatile long modelId = 0L;
    protected long enumItemId = 0L;
    protected volatile DynamicObject enumItem = null;
    protected String appId;
    protected boolean isCM;
    protected boolean isRpt;
    private int curBatch = 0;
    protected static final String enum_item_Id = "enumitemId";
    protected Map<String, String> num2Name = new HashMap<String, String>(16);
    protected List<String> numbers = new ArrayList<String>(10);
    protected List<String> enumValueList = new ArrayList<String>(10);
    private List<IDimensionImportValidator> validators;

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        super.setContext(rc, ctx, startArgs);
        this.appId = ctx.getAppId();
        this.isCM = ApplicationTypeEnum.CM.appnum.equals(this.appId);
        this.isRpt = ApplicationTypeEnum.RPT.appnum.equals(this.appId);
        return this;
    }

    protected int getBatchImportSize() {
        return 10000;
    }

    protected boolean isForceBatch() {
        return true;
    }

    public AbstractOperateWebApi getSaveWebApi() {
        return new DefaultOperate();
    }

    @Override
    protected void importData() {
        Long modelId = Long.parseLong(this.ctx.getOption().get("BcmModelId").toString());
        ModelLockHelper.executeWithModelLock((long)modelId, (String)"bcm_enumvalue_new", (int)10, (TimeUnit)TimeUnit.MILLISECONDS, (String)String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6b63\u5728\u6267\u884c\u6570\u636e\u5bfc\u5165\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"BcmBatchImportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), RequestContext.get().getUserName()), () -> {
            this._importData();
            return null;
        });
    }

    @Override
    public void beforeImport() {
        long tick = System.currentTimeMillis();
        this.initImportContext();
        LOG.info(this.genLogPrefix("init.beforeImport") + String.format(" cost time: %s", System.currentTimeMillis() - tick));
    }

    protected void initImportContext() {
        if (Objects.isNull(this.model)) {
            this.model = this.getCurrentModel();
            if (Objects.isNull(this.model)) {
                throw new KDBizException(ImportMsgUtils.specificModelFirst(), new Object[0]);
            }
            this.modelId = this.model.getLong("id");
        }
        if (Objects.isNull(this.enumItem)) {
            this.enumItem = this.getCurrentEnumItem();
            if (Objects.isNull(this.model)) {
                throw new KDBizException(ImportMsgUtils.noEnumItemValid(), new Object[0]);
            }
            this.enumItemId = this.enumItem.getLong("id");
        }
        DimensionImportContext context = new DimensionImportContext(this.model, this.enumItem, "bcm_enumvalue_new", ImportHelper.getImportType(this.ctx), this.appId, false, null, null);
        ImportContextHolder.setImportContext(context);
        this.validators = new ArrayList<IDimensionImportValidator>(16);
        this.validators.add(new EnumNewValueValidator());
        EnumValueDBCache.getDBBatchCacheOfEnumValues(this.modelId, this.enumItemId);
    }

    @Override
    protected void afterImport() {
        super.afterImport();
        EnumValueDBCache.clearDbCache();
    }

    protected void beforeValidation(List<ImportBillData> importedBills) {
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        switch (importType) {
            case NEW: {
                this.updateWithNewId(importedBills);
                break;
            }
            case OVERRIDE: {
                this.updateWithExistId(importedBills, false);
                break;
            }
            case OVERRIDENEW: {
                this.updateWithExistId(importedBills, true);
                break;
            }
        }
    }

    private void updateWithExistId(List<ImportBillData> existBills, boolean isOverrideNew) {
        if (!CollectionUtils.isEmpty(existBills)) {
            Map<String, DynamicObject> name2Enum = EnumValueDBCache.getName2Enum();
            Map<String, DynamicObject> num2Enum = EnumValueDBCache.getNum2Enum();
            existBills.forEach(x -> {
                JSONObject data = x.getData();
                String enumvalue = data.getString("enumvalue");
                String number = data.getString("number");
                if (num2Enum.containsKey(number)) {
                    DynamicObject enumDy = (DynamicObject)num2Enum.get(number);
                    RowDataExtUtil.addId(x, enumDy.getLong("id"));
                    RowDataExtUtil.addExistingRecord(x, enumDy);
                } else if (name2Enum.containsKey(enumvalue)) {
                    DynamicObject enumDy = (DynamicObject)name2Enum.get(enumvalue);
                    RowDataExtUtil.addId(x, enumDy.getLong("id"));
                    RowDataExtUtil.addExistingRecord(x, enumDy);
                } else if (isOverrideNew) {
                    RowDataExtUtil.addId(x, DBServiceHelper.genGlobalLongId());
                } else {
                    RowDataExtUtil.addId(x, 0L);
                }
            });
        }
    }

    @Override
    protected void filterFromLeftRowDatas(List<ImportBillData> leftRowdatas, List<ImportBillData> rowdatas) {
        ArrayList<String> existEnumNums = new ArrayList<String>(leftRowdatas.size());
        ArrayList<String> curEnumNums = new ArrayList<String>(16);
        ArrayList<String> curEnumNames = new ArrayList<String>(16);
        this.anaDependencyResolverOfEnum(leftRowdatas, existEnumNums);
        Iterator<ImportBillData> leftRowdataIter = leftRowdatas.iterator();
        while (leftRowdataIter.hasNext()) {
            ImportBillData billdata = leftRowdataIter.next();
            if (this.checkBillIsDependPrevious(billdata, existEnumNums, curEnumNums, curEnumNames)) continue;
            this.notifyBillSelected(billdata, curEnumNums, curEnumNames);
            rowdatas.add(billdata);
            leftRowdataIter.remove();
        }
        if (rowdatas.isEmpty() && !leftRowdatas.isEmpty()) {
            rowdatas.add(leftRowdatas.remove(0));
        }
    }

    public void notifyBillSelected(ImportBillData selectedBill, List<String> curEnumNums, List<String> curEnumNames) {
        curEnumNums.add(selectedBill.getData().getString("number"));
        curEnumNames.add(selectedBill.getData().getString("name"));
    }

    private void anaDependencyResolverOfEnum(List<ImportBillData> leftRowdatas, List<String> existEnumNums) {
        leftRowdatas.stream().forEach(x -> {
            String memNumber = x.getData().getString("number");
            if (!existEnumNums.contains(memNumber)) {
                existEnumNums.add(memNumber);
            }
        });
    }

    protected ApiResult save(List<ImportBillData> rowData, ImportLogger logger) {
        long tick = System.currentTimeMillis();
        FailLogSubscriber.importLogger.set(logger);
        this.beforeValidation(rowData);
        LOG.info(this.genLogPrefix("save.beforeValid") + String.format("batch size: %s, cost time: %s", rowData.size(), System.currentTimeMillis() - tick));
        tick = System.currentTimeMillis();
        List<Optional<String>> allValidateResults = this.validateBatchBills(rowData);
        LOG.info(this.genLogPrefix("save.valid") + String.format("batch size: %s, cost time: %s", rowData.size(), System.currentTimeMillis() - tick));
        ArrayList<BillResult> savedBillResults = new ArrayList<BillResult>(rowData.size());
        ArrayList<ImportBillData> validatedBillData = new ArrayList<ImportBillData>(rowData.size());
        Iterator<ImportBillData> iterator = rowData.iterator();
        int index = 0;
        int validIndex = 0;
        while (iterator.hasNext()) {
            ImportBillData data = iterator.next();
            Optional<String> validMsg = allValidateResults.get(index);
            if (validMsg.isPresent()) {
                logger.log(Integer.valueOf(data.getStartIndex()), validMsg.get()).fail();
                iterator.remove();
                ImportEventHelper.sendImportFinishEvent(new ImportFinishEvent(ImportFinishEvent.ImportStatus.FAIL, this.modelId, this.enumItemId, data.getData().getString("number")));
            } else {
                validatedBillData.add(data);
                BillResult result = new BillResult();
                result.setIndex(validIndex++);
                result.setNumber(data.getData().getString("number"));
                result.setSucess(true);
                result.setData((Map<String, Object>)data.getData());
                savedBillResults.add(result);
            }
            ++index;
        }
        long aTick = System.currentTimeMillis();
        List<Object> resultEntries = new ArrayList(validatedBillData.size());
        if (!validatedBillData.isEmpty()) {
            resultEntries = this.saveBatch(validatedBillData);
            for (int i = 0; i < resultEntries.size(); ++i) {
                if (((ImportResultEntry)resultEntries.get(i)).isErr()) {
                    ((BillResult)savedBillResults.get(i)).setSucess(false);
                    ((BillResult)savedBillResults.get(i)).setMessage(((ImportResultEntry)resultEntries.get(i)).getErrMsg());
                }
                ImportEventHelper.sendImportFinishEvent(new ImportFinishEvent(((ImportResultEntry)resultEntries.get(i)).isErr() ? ImportFinishEvent.ImportStatus.FAIL : ImportFinishEvent.ImportStatus.SUCCESS, this.modelId, this.enumItemId, ((BillResult)savedBillResults.get(i)).getNumber()));
            }
        }
        LOG.info(this.genLogPrefix("save.save") + String.format("batch size: %s, cost time: %s", rowData.size(), System.currentTimeMillis() - aTick));
        if (savedBillResults.size() != resultEntries.size()) {
            throw new IllegalStateException("the count of saved result not equals the process count");
        }
        this.afterSaveBatch();
        ApiResult apiResult = new ApiResult();
        ArrayList<Map<String, Object>> apiResultData = new ArrayList<Map<String, Object>>(savedBillResults.size());
        for (int i = 0; i < savedBillResults.size(); ++i) {
            if (((ImportResultEntry)resultEntries.get(i)).isErr()) {
                apiResult.setSuccess(false);
            }
            apiResultData.add(((BillResult)savedBillResults.get(i)).toMap());
        }
        apiResult.setData(apiResultData);
        LOG.info(this.genLogPrefix("save.total") + String.format("batch size: %s, cost time: %s", rowData.size(), System.currentTimeMillis() - tick));
        return apiResult;
    }

    protected void afterSaveBatch() {
        EnumUtils.buildIsLeafAndLnumberAllEnumValue(this.modelId, this.enumItemId);
    }

    private List<ImportResultEntry> saveBatch(List<ImportBillData> billDataList) {
        long sTick = System.currentTimeMillis();
        List<Object> resultEntries = new ArrayList(billDataList.size());
        List<ImportBillIndexWrap> billWraps = ImportBillIndexWrap.buildWrapList(billDataList);
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        try {
            if (ImportOperateType.NEW == importType) {
                resultEntries = this.insertNewBatch(billWraps);
            } else if (ImportOperateType.OVERRIDE == importType) {
                resultEntries = this.overrideBatch(billWraps);
            } else if (ImportOperateType.OVERRIDENEW == importType) {
                List<ImportResultEntry> rawOverrideResults = this.overrideBatch(billWraps);
                List<ImportBillIndexWrap> failedOverrideBillWraps = rawOverrideResults.stream().filter(ImportResultEntry::isErr).map(x -> new ImportBillIndexWrap((ImportBillData)billDataList.get(x.getIndex()), x.getIndex())).collect(Collectors.toList());
                List<ImportResultEntry> insertResults = this.insertNewBatch(failedOverrideBillWraps);
                resultEntries.addAll(rawOverrideResults.stream().filter(x -> !x.isErr()).collect(Collectors.toList()));
                resultEntries.addAll(insertResults);
            }
        }
        catch (Exception e) {
            LOG.error("enum_import_submit allfailed:" + e.getMessage(), (Throwable)e);
            resultEntries = billWraps.stream().map(x -> ImportResultEntry.error(e, x.getListIndex())).collect(Collectors.toList());
        }
        resultEntries.sort(Comparator.comparingInt(ImportResultEntry::getIndex));
        LOG.info(this.genLogPrefix("saveBatch.operate") + String.format(" batchSize: %s, cost time: %s", billDataList.size(), System.currentTimeMillis() - sTick));
        resultEntries.forEach(x -> {
            if (x.getImportedMemTreeDy().isPresent()) {
                DynamicObject persistentEnumTreeDy = x.getImportedMemTreeDy().get();
                LocalCacheHelper.put((String)(((Object)((Object)this)).getClass().getSimpleName() + " checkEnumNumber " + "bcm_enumvalue_new" + " number " + persistentEnumTreeDy.getString("number")), (Object)x);
            }
        });
        return resultEntries;
    }

    private List<ImportResultEntry> overrideBatch(List<ImportBillIndexWrap> billDataList) {
        List<ImportResultEntry> importEnumEntries = this.overrideEnumValueBatch(billDataList);
        ArrayList<ImportResultEntry> allEntries = new ArrayList<ImportResultEntry>(billDataList.size());
        allEntries.addAll(importEnumEntries);
        return allEntries;
    }

    private List<ImportResultEntry> overrideEnumValueBatch(List<ImportBillIndexWrap> billDataList) {
        if (CollectionUtils.isEmpty(billDataList)) {
            return Collections.emptyList();
        }
        long tick = System.currentTimeMillis();
        List<OverrideResultEntry> rawOverrideEntries = this.handleAssembleOverrideEnumEntity(billDataList);
        LOG.info(this.genLogPrefix("override.packData") + String.format("batchSize: %s, cost time: %s", rawOverrideEntries.size(), System.currentTimeMillis() - tick));
        List needOverrideEntries = rawOverrideEntries.stream().filter(OverrideResultEntry::isNeedOverride).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(needOverrideEntries)) {
            TXHandle tx = TX.requiresNew((String)"overrideNonShareEnumBatch");
            Object object = null;
            try {
                try {
                    List<DynamicObject> overrideDys = needOverrideEntries.stream().map(OverrideResultEntry::getOverridDy).collect(Collectors.toList());
                    SaveServiceHelper.save((DynamicObject[])overrideDys.toArray(new DynamicObject[0]));
                }
                catch (Throwable e) {
                    LOG.error("enum_import_submit rollback, error:" + e.getMessage(), e);
                    tx.markRollback();
                    throw new KDBizException(e.getMessage());
                }
            }
            catch (Throwable e) {
                object = e;
                throw e;
            }
            finally {
                if (tx != null) {
                    if (object != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable e) {
                            ((Throwable)object).addSuppressed(e);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            long upCacheTick = System.currentTimeMillis();
            EnumValueDBCache.updateDBBatchCacheOfEnumValues(needOverrideEntries.stream().map(OverrideResultEntry::getOverridDy).collect(Collectors.toList()));
            LOG.info(this.genLogPrefix("override.enum.updateCache") + String.format("batchSize: %s, cost time: %s", needOverrideEntries.size(), System.currentTimeMillis() - upCacheTick));
        }
        ArrayList<ImportResultEntry> importEntries = new ArrayList<ImportResultEntry>(rawOverrideEntries.size());
        for (OverrideResultEntry entry : rawOverrideEntries) {
            if (entry.isNeedOverride()) {
                DynamicObject overrideDy = entry.getOverridDy();
                importEntries.add(ImportResultEntry.success(overrideDy.getLong("id"), overrideDy, entry.getBillWrap().getListIndex()));
                continue;
            }
            importEntries.add(ImportResultEntry.error(ImportMsgUtils.currentNumberNotExists(), entry.getBillWrap().getListIndex()));
        }
        return importEntries;
    }

    private List<OverrideResultEntry> handleAssembleOverrideEnumEntity(List<ImportBillIndexWrap> billDataList) {
        ArrayList<OverrideResultEntry> rawOverrideEntries = new ArrayList<OverrideResultEntry>(billDataList.size());
        for (ImportBillIndexWrap billIndexWrap : billDataList) {
            Optional<DynamicObject> existRecordDy = RowDataExtUtil.getExistingRecord(billIndexWrap.getBill());
            if (existRecordDy.isPresent()) {
                DynamicObject existRecordBak = (DynamicObject)OrmUtils.clone((Object)existRecordDy.get(), (IDataEntityType)existRecordDy.get().getDataEntityType(), (boolean)false, (boolean)false);
                this.assemEnumTree(billIndexWrap.getBill(), existRecordDy.get());
                rawOverrideEntries.add(new OverrideResultEntry(billIndexWrap, "", "", existRecordBak, existRecordDy.get(), true));
                continue;
            }
            rawOverrideEntries.add(OverrideResultEntry.isSkip(billIndexWrap));
        }
        return rawOverrideEntries;
    }

    private List<ImportResultEntry> insertNewBatch(List<ImportBillIndexWrap> billDataList) {
        if (CollectionUtils.isEmpty(billDataList)) {
            return Collections.emptyList();
        }
        long packDataTick = System.currentTimeMillis();
        List<PersistEntryEnum> persistEntries = this.handleAssembleNewEnumEntity(billDataList);
        persistEntries.sort(Comparator.comparingInt(o -> o.getBillWrap().getListIndex()));
        for (PersistEntryEnum persistEntry : persistEntries) {
            ImportBillData bill = persistEntry.getBillWrap().getBill();
            Optional<DynamicObject> existingDy = RowDataExtUtil.getExistingRecord(bill);
            if (existingDy.isPresent()) continue;
            Optional<DynamicObject> parentOp = RowDataExtUtil.getParent(bill);
            if (parentOp.isPresent()) {
                DynamicObject parent = parentOp.get();
                long parentId = parent.getLong("id");
                persistEntry.getEnumValueDy().set("dseq", (Object)EnumUtils.getAndIncreDseqOfEnum(parentId));
                continue;
            }
            LinkedHashSet<Integer> enumValues = EnumValueDBCache.getpId2Dseqs().get(0L);
            int index = CollectionUtils.isEmpty(enumValues) ? 1 : (Integer)enumValues.stream().sorted().collect(Collectors.toList()).get(enumValues.size() - 1);
            persistEntry.getEnumValueDy().set("dseq", (Object)new AtomicInteger(++index));
        }
        LOG.info(this.genLogPrefix("insert.packData") + String.format("batchSize: %s, cost time: %s", billDataList.size(), System.currentTimeMillis() - packDataTick));
        try (TXHandle tx = TX.requiresNew((String)"insertNewBatch");){
            try {
                SaveServiceHelper.save((DynamicObject[])persistEntries.stream().map(x -> x.getEnumValueDy()).collect(Collectors.toList()).toArray(new DynamicObject[0]));
            }
            catch (Throwable e) {
                LOG.error("enum_import_submit rollback, error:" + e.getMessage(), e);
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        long tick = System.currentTimeMillis();
        EnumValueDBCache.updateDBBatchCacheOfEnumValues(persistEntries.stream().map(PersistEntryEnum::getEnumValueDy).collect(Collectors.toList()));
        LOG.info(this.genLogPrefix("db.cache.updateenums") + String.format(" batchSize: %s, cost time: %s", persistEntries.size(), System.currentTimeMillis() - tick));
        ArrayList<ImportResultEntry> resultEntries = new ArrayList<ImportResultEntry>(billDataList.size());
        for (PersistEntryEnum persistEntry : persistEntries) {
            DynamicObject enumValueDy = persistEntry.getEnumValueDy();
            int billListIndex = persistEntry.getBillWrap().getListIndex();
            long curSucId = enumValueDy.getLong("id");
            if (curSucId == 0L) {
                resultEntries.add(ImportResultEntry.error(ImportMsgUtils.unexpectedInsertFail(), billListIndex));
                continue;
            }
            resultEntries.add(ImportResultEntry.success(curSucId, enumValueDy, billListIndex));
        }
        ImportContextHolder.addBatchNewIds(persistEntries.stream().map(x -> x.getEnumValueDy().getLong("id")).collect(Collectors.toSet()));
        return resultEntries;
    }

    private List<PersistEntryEnum> handleAssembleNewEnumEntity(List<ImportBillIndexWrap> billDataList) {
        ArrayList<PersistEntryEnum> persistEntries = new ArrayList<PersistEntryEnum>(billDataList.size());
        for (ImportBillIndexWrap billIndexWrap : billDataList) {
            DynamicObject enumValue = BusinessDataServiceHelper.newDynamicObject((String)"bcm_enumvalue_new");
            this.assemEnumTree(billIndexWrap.getBill(), enumValue);
            persistEntries.add(new PersistEntryEnum(billIndexWrap, enumValue));
        }
        return persistEntries;
    }

    public void assemEnumTree(ImportBillData bill, DynamicObject enumValue) {
        Optional<DynamicObject> existingDy;
        JSONObject data = bill.getData();
        Optional<DynamicObject> parent = RowDataExtUtil.getParent(bill);
        long parentId = 0L;
        int parentLevel = 0;
        if (parent.isPresent()) {
            DynamicObject pDy = parent.get();
            parentId = pDy.getLong("id");
            parentLevel = pDy.getInt("level");
        }
        if ((existingDy = RowDataExtUtil.getExistingRecord(bill)).isPresent()) {
            String number = existingDy.get().getString("number");
            if (StringUtils.isNotEmpty((CharSequence)number)) {
                enumValue.set("number", (Object)number);
                enumValue.set("enumvalue", data.get("enumvalue"));
            } else {
                enumValue.set("number", data.get("number"));
                enumValue.set("enumvalue", existingDy.get().get("enumvalue"));
            }
            enumValue.set("id", (Object)existingDy.get().getLong("id"));
        } else {
            enumValue.set("id", data.get("id"));
            enumValue.set("enumvalue", data.get("enumvalue"));
            enumValue.set("number", data.get("number"));
            enumValue.set("model", (Object)this.modelId);
        }
        DynamicObject enumItem = ImportContextHolder.getImportContext().getImportDimension();
        enumValue.set("name", enumItem.get("name"));
        enumValue.set("enumitemid", (Object)enumItem.getLong("id"));
        enumValue.set("datatype", data.get("datatype"));
        enumValue.set("issysenumvalue", (Object)"0");
        enumValue.set("parent", (Object)parentId);
        enumValue.set("level", (Object)(parentLevel + 1));
    }

    private List<Optional<String>> validateBatchBills(List<ImportBillData> bills) {
        ArrayList<Optional<String>> billValidateResults = new ArrayList<Optional<String>>(bills.size());
        for (ImportBillData bill : bills) {
            try {
                billValidateResults.add(this.validateBillData(bill));
            }
            catch (Exception e) {
                LOG.error("Failed to validate bill: " + bill.getData() + " for " + e.getMessage(), (Throwable)e);
                billValidateResults.add(Optional.of(e.getMessage()));
            }
        }
        return billValidateResults;
    }

    protected Optional<String> validateBillData(ImportBillData billData) {
        for (IDimensionImportValidator validator : this.validators) {
            try {
                Optional<String> failedMsg = validator.proxyValidate(billData);
                if (!failedMsg.isPresent()) continue;
                return failedMsg;
            }
            catch (Exception e) {
                LOG.error("Failed to import on exception:" + e.getMessage(), (Throwable)e);
                return Optional.of(ImportHelper.buildExceptionMsg(e, 2, true));
            }
        }
        return Optional.empty();
    }

    public boolean checkBillIsDependPrevious(ImportBillData importBillData, List<String> existEnumNums, List<String> curEnumNums, List<String> curEnumNames) {
        String parentNumber = this.getParentNumber(importBillData);
        if (existEnumNums.contains(parentNumber)) {
            return true;
        }
        String memNumber = importBillData.getData().getString("number");
        if (curEnumNums.contains(memNumber)) {
            return true;
        }
        String memName = importBillData.getData().getString("name");
        return curEnumNames.contains(memName);
    }

    private String getParentNumber(ImportBillData importBillData) {
        Object parentNumberObj;
        String parentStr = importBillData.getData().getString("parent");
        String parentNumber = "";
        if (StringUtils.isNotEmpty((CharSequence)parentStr) && Objects.nonNull(parentNumberObj = SilentJSONUtils.cast(parentStr, LinkedHashMap.class).get("number"))) {
            parentNumber = parentNumberObj.toString();
        }
        return parentNumber;
    }

    private void updateWithNewId(List<ImportBillData> newBills) {
        if (CollectionUtils.isEmpty(newBills)) {
            return;
        }
        long[] ids = DBServiceHelper.genLongIds((String)"bcm_enumvalue_new", (int)newBills.size());
        for (int j = 0; j < newBills.size(); ++j) {
            RowDataExtUtil.addId(newBills.get(j), ids[j]);
        }
    }

    private DynamicObject getCurrentEnumItem() {
        Long enumItemId = Long.parseLong((String)this.ctx.getOption().get(enum_item_Id));
        if (Objects.isNull(enumItemId) || enumItemId == 0L) {
            throw new KDBizException(ImportMsgUtils.noEnumItemValid(), new Object[0]);
        }
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_enumitem_new", (String)"id, number, name, datatype", (QFilter[])new QFilter("id", "=", (Object)enumItemId).toArray());
    }

    private String genLogPrefix(String operationName) {
        return String.format("enum_import:: entity: %s, batch: %s, operate: %s, ", "bcm_enumvalue_new", this.curBatch, operationName);
    }

    protected DynamicObject getCurrentModel() {
        Long importModelId = (Long)this.ctx.getOption().get("BcmModelId");
        if (Objects.isNull(importModelId) || importModelId == 0L) {
            throw new KDBizException(ImportMsgUtils.specificModelFirst(), new Object[0]);
        }
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (String)"id,number,shownumber", (QFilter[])new QFilter("id", "=", (Object)importModelId).toArray());
    }
}

