/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.enums;

import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.bcm.formplugin.dimension.DemensionEnumImport;
import kd.fi.bcm.formplugin.dimension.batchimp.enums.EnumValueDBCache;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.DimensionImportContext;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.IDimensionImportValidator;
import kd.fi.bcm.formplugin.util.RegexUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class EnumNewValueValidator
implements IDimensionImportValidator {
    private static final String pattern = "^\\d+\\.\\d{3,}$";

    @Override
    public Optional<String> validate(ImportBillData bill) {
        DimensionImportContext context = ImportContextHolder.getImportContext();
        Optional<DynamicObject> existingRecord = RowDataExtUtil.getExistingRecord(bill);
        JSONObject billData = bill.getData();
        Map<String, DynamicObject> name2Enum = EnumValueDBCache.getName2Enum();
        Map<String, DynamicObject> num2Enum = EnumValueDBCache.getNum2Enum();
        String number = billData.get("number").toString();
        String enumvalue = billData.get("enumvalue").toString();
        String eiNumber = ((JSONObject)billData.get("enumitemid")).get((Object)"number").toString();
        String datatype = billData.get("datatype").toString();
        if (StringUtils.isEmpty((CharSequence)number)) {
            return Optional.of(ImportMsgUtils.noNumberOfEnumValue());
        }
        if (number.length() > 50) {
            return Optional.of(ImportMsgUtils.checkLengthOfEnumValueNum());
        }
        if (!RegexUtils.isOnlyNumberAndString(number)) {
            return Optional.of(ImportMsgUtils.numberOfEnumValueNumber());
        }
        if (StringUtils.isEmpty((CharSequence)enumvalue)) {
            return Optional.of(ImportMsgUtils.noNameOfEnumValue());
        }
        if (enumvalue.length() > 200) {
            return Optional.of(ImportMsgUtils.checkLengthOfEnumValueName());
        }
        Object parent = billData.get("parent");
        if (parent != null) {
            Object pEnumValue = ((JSONObject)parent).get((Object)"enumvalue");
            if (pEnumValue == null) {
                return Optional.of(ImportMsgUtils.isNullOfPNameOfEnumValue());
            }
            if (!name2Enum.containsKey(pEnumValue)) {
                return Optional.of(ImportMsgUtils.noParentNameOfEnumValue());
            }
            Object pNumObj = ((JSONObject)parent).get((Object)"number");
            if (pNumObj != null && StringUtils.isNotEmpty((CharSequence)pNumObj.toString()) && !num2Enum.containsKey(pNumObj)) {
                return Optional.of(ImportMsgUtils.noParentNumberOfEnumValue());
            }
            RowDataExtUtil.addParent(bill, name2Enum.get(pEnumValue.toString()));
        }
        if (StringUtils.isEmpty((CharSequence)eiNumber)) {
            return Optional.of(ImportMsgUtils.noNumberOfEnumItem());
        }
        DynamicObject enumItemDy = context.getImportDimension();
        String enumNumber = enumItemDy.getString("number");
        String datatypeOld = enumItemDy.getString("datatype");
        if (!enumNumber.equals(eiNumber)) {
            return Optional.of(ImportMsgUtils.incorrectNumOfEnumItem());
        }
        if (StringUtils.isEmpty((CharSequence)datatype)) {
            return Optional.of(ImportMsgUtils.noDatatypeOfEnumValue());
        }
        if (!datatypeOld.equals(datatype)) {
            return Optional.of(ImportMsgUtils.incorrectDtOfEnumItem());
        }
        String msg = this.checkMateOfNameAndDataType(enumvalue, datatype);
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            return Optional.of(msg);
        }
        if (existingRecord.isPresent()) {
            DynamicObject evDy;
            if (!num2Enum.containsKey(number)) {
                if (!name2Enum.containsKey(enumvalue)) {
                    return Optional.of(ImportMsgUtils.noExistsOfEnumValue());
                }
                evDy = name2Enum.get(enumvalue);
                if (evDy == null) {
                    return Optional.of(ImportMsgUtils.noExistsOfEnumValue());
                }
                String oldNum = evDy.getString("number");
                if (StringUtils.isNotEmpty((CharSequence)oldNum)) {
                    return Optional.of(ImportMsgUtils.notMateNameAndNumberOfEnumValue());
                }
            } else {
                evDy = num2Enum.get(number);
                if (evDy == null) {
                    return Optional.of(ImportMsgUtils.notFoundEnumValue());
                }
                int issysenumvalue = evDy.getInt("issysenumvalue");
                String localeValue = ResManager.getLocaleString((String)"\u4e1a\u52a1\u7c7b\u578b", (String)"ExtDimEditPlugin_8", (String)"fi-bcm-formplugin").getLocaleValue();
                if (issysenumvalue == 1 && !evDy.getString("name").equals(localeValue)) {
                    return Optional.of(ImportMsgUtils.unableOverrideSysEnum());
                }
                String name = evDy.getString("name");
                Set<String> otherNames = name2Enum.keySet();
                otherNames.remove(name);
                if (otherNames.contains(enumvalue)) {
                    return Optional.of(ImportMsgUtils.existSameNameOfEnumValue());
                }
            }
            if (parent != null) {
                Set<String> enumValues;
                String pNumber = ((JSONObject)parent).get((Object)"number").toString();
                String pName = ((JSONObject)parent).get((Object)"enumvalue").toString();
                if (StringUtils.isNotEmpty((CharSequence)pNumber) && CollectionUtils.isNotEmpty(enumValues = EnumValueDBCache.getpId2Names().get(billData.get("id"))) && enumValues.contains(pName)) {
                    return Optional.of(ImportMsgUtils.existCircleRefer());
                }
            }
        } else {
            if (num2Enum.containsKey(number)) {
                return Optional.of(ImportMsgUtils.numberExistsOfEnumValue());
            }
            if (name2Enum.containsKey(enumvalue)) {
                return Optional.of(ImportMsgUtils.nameExistsOfEnumValue());
            }
        }
        return Optional.empty();
    }

    private String checkMateOfNameAndDataType(String enumvalue, String datatype) {
        switch (datatype) {
            case "1": 
            case "5": {
                try {
                    Double.parseDouble(enumvalue);
                }
                catch (Exception e) {
                    return ResManager.loadKDString((String)"\u679a\u4e3e\u503c\u8f93\u5165\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"DemensionEnumImport_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                }
                if (!enumvalue.matches(pattern)) break;
                return ResManager.loadKDString((String)"\u679a\u4e3e\u503c\u8f93\u5165\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"DemensionEnumImport_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            case "4": {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    sdf.parse(enumvalue);
                    int indexOne = enumvalue.indexOf("-");
                    int indexTwo = enumvalue.indexOf("-", indexOne + 1);
                    if (enumvalue.substring(0, indexOne).length() != 4 || enumvalue.substring(indexOne + 1, indexTwo).length() != 2 || enumvalue.substring(indexTwo + 1).length() != 2 || !DemensionEnumImport.isValid(enumvalue, "yyyy-MM-dd")) {
                        return ResManager.loadKDString((String)"\u679a\u4e3e\u503c\u8f93\u5165\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"DemensionEnumImport_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    }
                    break;
                }
                catch (ParseException e) {
                    return ResManager.loadKDString((String)"\u679a\u4e3e\u503c\u8f93\u5165\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"DemensionEnumImport_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                }
            }
        }
        return "";
    }
}

