/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.enums;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import org.apache.commons.lang3.StringUtils;

public class EnumValueDBCache {
    protected static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance((boolean)true, EnumValueDBCache.class);
    protected static Map<String, DynamicObject> name2Enum = Collections.synchronizedMap(new HashMap(128));
    protected static Map<String, DynamicObject> num2Enum = Collections.synchronizedMap(new HashMap(128));
    protected static Map<Long, LinkedHashSet<Integer>> pId2Dseqs = Collections.synchronizedMap(new HashMap(128));
    protected static Map<Long, Set<String>> pId2Names = Collections.synchronizedMap(new HashMap(128));
    protected static volatile EnumValueDBCache dbCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EnumValueDBCache getDBBatchCacheOfEnumValues(long modelId, long enumItemId) {
        if (dbCache != null) return dbCache;
        Class<EnumValueDBCache> clazz = EnumValueDBCache.class;
        synchronized (EnumValueDBCache.class) {
            if (dbCache != null) return dbCache;
            EnumValueDBCache.initDBBatchCacheOfEnumValues(modelId, enumItemId);
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return dbCache;
        }
    }

    private static void initDBBatchCacheOfEnumValues(long modelId, long enumItemId) {
        DynamicObject[] enumValues;
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        modelQf.and("enumitemid", "=", (Object)enumItemId);
        String selectFields = "id, enumvalue, number, name, longnumber, parent, enumitemid, dseq, datatype, issysenumvalue, level, issysenumvalue";
        for (DynamicObject enumvalue : enumValues = BusinessDataServiceHelper.load((String)"bcm_enumvalue_new", (String)selectFields, (QFilter[])modelQf.toArray())) {
            String enumvalueName = enumvalue.getString("enumvalue");
            String number = enumvalue.getString("number");
            name2Enum.put(enumvalueName, enumvalue);
            if (StringUtils.isNotEmpty((CharSequence)number)) {
                num2Enum.put(number, enumvalue);
            }
            int dseq = enumvalue.getInt("dseq");
            Object parent = enumvalue.get("parent");
            if (parent == null) {
                pId2Dseqs.computeIfAbsent(0L, k -> new LinkedHashSet(10)).add(dseq);
                continue;
            }
            pId2Dseqs.computeIfAbsent(((DynamicObject)parent).getLong("id"), k -> new LinkedHashSet(10)).add(dseq);
            pId2Names.computeIfAbsent(((DynamicObject)parent).getLong("id"), k -> new HashSet(10)).add(enumvalueName);
        }
        dbCache = new EnumValueDBCache();
    }

    public static synchronized void updateDBBatchCacheOfEnumValues(List<DynamicObject> savedEnums) {
        savedEnums.forEach(ele -> {
            name2Enum.put(ele.getString("enumvalue"), (DynamicObject)ele);
            num2Enum.put(ele.getString("number"), (DynamicObject)ele);
            pId2Dseqs.computeIfAbsent(ele.getLong("parent"), k -> new LinkedHashSet(10)).add(ele.getInt("dseq"));
            pId2Names.computeIfAbsent(ele.getLong("parent"), k -> new LinkedHashSet(10)).add(ele.getString("enumvalue"));
        });
    }

    public static Map<String, DynamicObject> getName2Enum() {
        return name2Enum;
    }

    public static Map<String, DynamicObject> getNum2Enum() {
        return num2Enum;
    }

    public static Map<Long, LinkedHashSet<Integer>> getpId2Dseqs() {
        return pId2Dseqs;
    }

    public static Map<Long, Set<String>> getpId2Names() {
        return pId2Names;
    }

    public static void clearDbCache() {
        name2Enum.clear();
        num2Enum.clear();
        pId2Dseqs.clear();
        pId2Names.clear();
        dbCache = null;
    }
}

