/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.event;

import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.formplugin.dimension.batchimp.event.FailLogEvent;
import kd.fi.bcm.formplugin.dimension.batchimp.event.IEventSubscriber;
import kd.fi.bcm.formplugin.dimension.batchimp.event.ImportEventHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.event.ImportFinishEvent;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.PersistProxy;
import org.apache.commons.lang3.StringUtils;

public class AssoImportSuccessSubscriber
implements IEventSubscriber {
    protected static final Log LOG = LogFactory.getLog(AssoImportSuccessSubscriber.class);
    private static ThreadLocal<List<MemberFollower>> assoInfos = new ThreadLocal();

    public static void addDependCtrlOrgListener(long curMemberId, String assoNumber, ImportBillData billData) {
        if (Objects.isNull(assoInfos.get())) {
            assoInfos.set(new ArrayList(10));
        }
        assoInfos.get().add(new MemberFollower(curMemberId, assoNumber, billData));
    }

    @Subscribe
    public void handle(ImportFinishEvent event) {
        if (Objects.isNull(event)) {
            LOG.error("handle null event");
            return;
        }
        if (Objects.nonNull(assoInfos.get()) && !assoInfos.get().isEmpty()) {
            assoInfos.get().stream().filter(x -> StringUtils.equals((CharSequence)x.getAssoNumber(), (CharSequence)event.getMemberNumber())).forEach(x -> {
                if (ImportFinishEvent.ImportStatus.SUCCESS == event.getStatus()) {
                    String assoMember;
                    DynamicObject member = PersistProxy.instance.getById(x.getMemberId(), false);
                    Long memberId = x.getMemberId();
                    DynamicObject dy = this.filterAssoMember(memberId, assoMember = event.getMemberNumber(), member);
                    if (dy != null) {
                        member.set("assostoremem", (Object)dy);
                        List<DynamicObject> shareMembers = PersistProxy.instance.listShareMembers(ImportHelper.getNumber(member));
                        shareMembers.forEach(s -> s.set("assostoremem", (Object)dy));
                        ArrayList<DynamicObject> allMembers = new ArrayList<DynamicObject>(shareMembers.size() + 1);
                        allMembers.add(member);
                        allMembers.addAll(shareMembers);
                        PersistProxy.instance.batchSaveOrUpdate(allMembers);
                        LOG.info("handle event success, update depend assostoremem. Event: " + event);
                    }
                } else {
                    ImportEventHelper.sendLogEvent(new FailLogEvent(x.getBillData(), ImportMsgUtils.dependCtrlOrgFail()));
                }
            });
            assoInfos.get().removeIf(x -> StringUtils.equals((CharSequence)x.getAssoNumber(), (CharSequence)event.getMemberNumber()));
        }
    }

    private DynamicObject filterAssoMember(Long memberId, String assoMember, DynamicObject member) {
        Collection<DynamicObject> dynamicObjects = PersistProxy.instance.listChildMembers(memberId);
        List<DynamicObject> assoDys = dynamicObjects.stream().filter(y -> assoMember.equals(y.getString("number"))).filter(y -> y.getBoolean("isleaf")).filter(y -> !StorageTypeEnum.LABEL.getOIndex().equals(y.getString("storagetype"))).filter(y -> !StorageTypeEnum.DYNAMIC.getOIndex().equals(y.getString("storagetype"))).collect(Collectors.toList());
        if (assoDys.size() == 0) {
            return null;
        }
        DynamicObject dynamicObject = null;
        String entityName = ((DynamicObject)assoDys.get(0)).getDynamicObjectType().getName();
        if ("bcm_accountmembertree".equals(entityName) || "bcm_userdefinedmembertree".equals(entityName)) {
            dynamicObject = this.filterDatatypeOfMem(assoDys, member);
        } else if (assoDys.size() > 0) {
            dynamicObject = assoDys.get(0);
        }
        return dynamicObject;
    }

    private DynamicObject filterDatatypeOfMem(List<DynamicObject> assoMems, DynamicObject member) {
        String datatype = member.getString("datatype");
        for (DynamicObject assoMem : assoMems) {
            String assoMemDt = assoMem.getString("datatype");
            if ("6".equals(assoMemDt) || "6".equals(datatype)) {
                Optional<DynamicObject> enumitem;
                String enumName = assoMem.getString("enumitem.name");
                Map<Object, DynamicObject> enumDts = this.queryAllEnumOfDim();
                if ("6".equals(assoMemDt) && (enumitem = enumDts.values().stream().filter(y -> enumName.equals(y.getString("name"))).findFirst()).isPresent()) {
                    assoMemDt = enumitem.get().getString("datatype");
                }
                if ("6".equals(datatype)) {
                    long enumItemId = member.getLong("enumitem");
                    Optional<DynamicObject> enumitem2 = enumDts.values().stream().filter(y -> enumItemId == y.getLong("id")).findFirst();
                    if (enumitem2.isPresent()) {
                        datatype = enumitem2.get().getString("datatype");
                    }
                }
            }
            if ((!"0".equals(datatype) && !"1".equals(datatype) || !"0".equals(assoMemDt) && !"1".equals(assoMemDt)) && !datatype.equals(assoMemDt)) continue;
            return assoMem;
        }
        return null;
    }

    private Map<Object, DynamicObject> queryAllEnumOfDim() {
        String dimNum = ImportContextHolder.getImportContext().getImportDimension().getString("number");
        String modelNum = ImportContextHolder.getImportContext().getImportModel().getString("number");
        Long modelId = MemberReader.findModelIdByNum((String)modelNum);
        Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum);
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and("dimension", "=", (Object)dimensionId);
        return BusinessDataServiceHelper.loadFromCache((String)"bcm_enumitem", (String)"id, name, datatype", (QFilter[])qf.toArray());
    }

    private static class MemberFollower {
        private Long memberId;
        private String assoNumber;
        private ImportBillData billData;

        public MemberFollower(Long memberId, String assoNumber, ImportBillData billData) {
            this.memberId = memberId;
            this.assoNumber = assoNumber;
            this.billData = billData;
        }

        public Long getMemberId() {
            return this.memberId;
        }

        public String getAssoNumber() {
            return this.assoNumber;
        }

        public ImportBillData getBillData() {
            return this.billData;
        }
    }
}

