/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.event;

import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bcm.formplugin.dimension.batchimp.event.FailLogEvent;
import kd.fi.bcm.formplugin.dimension.batchimp.event.IEventSubscriber;
import kd.fi.bcm.formplugin.dimension.batchimp.event.ImportEventHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.event.ImportFinishEvent;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.PersistProxy;
import org.apache.commons.lang3.StringUtils;

public class CtrlOrgImportSuccessSubscriber
implements IEventSubscriber {
    protected static final Log LOG = LogFactory.getLog(CtrlOrgImportSuccessSubscriber.class);
    private static ThreadLocal<List<MemberFollower>> ctrlOrgInfos = new ThreadLocal();

    public static void addDependCtrlOrgListener(long curMemberId, String ctrlOrgNumber, ImportBillData billData) {
        if (Objects.isNull(ctrlOrgInfos.get())) {
            ctrlOrgInfos.set(new ArrayList(10));
        }
        ctrlOrgInfos.get().add(new MemberFollower(curMemberId, ctrlOrgNumber, billData));
    }

    @Subscribe
    public void handle(ImportFinishEvent event) {
        if (Objects.isNull(event)) {
            LOG.error("handle null event");
            return;
        }
        if (Objects.nonNull(ctrlOrgInfos.get()) && !ctrlOrgInfos.get().isEmpty()) {
            ctrlOrgInfos.get().stream().filter(x -> StringUtils.equals((CharSequence)x.getCtrlOrgNumber(), (CharSequence)event.getMemberNumber())).forEach(x -> {
                if (ImportFinishEvent.ImportStatus.SUCCESS == event.getStatus()) {
                    DynamicObject ctrlOrgDy = PersistProxy.instance.getNonShareMember(event.getMemberNumber(), true).get();
                    DynamicObject orgDy = PersistProxy.instance.getById(x.getMemberId(), false);
                    orgDy.set("ctrlorg", (Object)ctrlOrgDy);
                    List<DynamicObject> shareMembers = PersistProxy.instance.listShareMembers(ImportHelper.getNumber(orgDy));
                    shareMembers.forEach(s -> s.set("ctrlorg", (Object)ctrlOrgDy));
                    ArrayList<DynamicObject> allMembers = new ArrayList<DynamicObject>(shareMembers.size() + 1);
                    allMembers.add(orgDy);
                    allMembers.addAll(shareMembers);
                    PersistProxy.instance.batchSaveOrUpdate(allMembers);
                    LOG.info("handle event success, update depend ctrol orgnization. Event: " + event.toString());
                } else {
                    ImportEventHelper.sendLogEvent(new FailLogEvent(x.getBillData(), ImportMsgUtils.dependCtrlOrgFail()));
                }
            });
            ctrlOrgInfos.get().removeIf(x -> StringUtils.equals((CharSequence)x.getCtrlOrgNumber(), (CharSequence)event.getMemberNumber()));
        }
    }

    private static class MemberFollower {
        private Long memberId;
        private String ctrlOrgNumber;
        private ImportBillData billData;

        public MemberFollower(Long memberId, String ctrlOrgNumber, ImportBillData billData) {
            this.memberId = memberId;
            this.ctrlOrgNumber = ctrlOrgNumber;
            this.billData = billData;
        }

        public Long getMemberId() {
            return this.memberId;
        }

        public String getCtrlOrgNumber() {
            return this.ctrlOrgNumber;
        }

        public ImportBillData getBillData() {
            return this.billData;
        }
    }
}

