/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.dimension.helper.SaveDimMemberHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.log.DimMemberOperateTypeEnum;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.handlers.AbstractDimensionImportHandler;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.DimensionImportContext;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.OverrideResultEntry;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.PersistEntry;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ShareMemberHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.PersistProxy;

public class CommonPostImportHandler
extends AbstractDimensionImportHandler {
    public CommonPostImportHandler(DimensionImportContext context) {
        super(context);
    }

    @Override
    public void postInsert(List<PersistEntry> persistEntries) {
        List newShareEntries = persistEntries.stream().filter(x -> ImportHelper.isShareType(x.getMemberTreeDy())).collect(Collectors.toList());
        BatchProcessHelper.batchHandle(newShareEntries, (int)2000, subNewEntries -> {
            subNewEntries.stream().forEach(x -> {
                try {
                    DynamicObject shareMember = x.getMemberTreeDy();
                    DynamicObject storeMember = PersistProxy.instance.getNonShareMember(ImportHelper.getNumber(shareMember), false).get();
                    long parentId = ImportHelper.getBaseDataIdCompatible(shareMember, "parent");
                    DynamicObject parentDy = PersistProxy.instance.getById(parentId, false);
                    long dimensionId = this.context.getImportDimension().getLong("id");
                    ShareMemberHelper.syncStorageSourcePropertyToShare(dimensionId, storeMember, shareMember, Objects.nonNull(parentDy) && ImportHelper.isShareType(parentDy), storeMember.getString("name"));
                }
                catch (Exception e) {
                    LOG.error("failed to sync the properties of source memebers to new share member", (Throwable)e);
                    throw e;
                }
            });
            if (subNewEntries.size() > 0) {
                try (TXHandle tx = TX.requiresNew((String)"postinsertBatch");){
                    try {
                        PersistProxy.instance.batchSaveOrUpdate(subNewEntries.stream().map(x -> x.getMemberTreeDy()).collect(Collectors.toList()));
                    }
                    catch (Throwable e) {
                        LOG.error("dimension_import_postinsert share_member rollback, error:" + e.getMessage(), e);
                        tx.markRollback();
                        throw new KDBizException(e.getMessage());
                    }
                }
            }
            return Collections.EMPTY_LIST;
        }, null, (int)4);
        DynamicObject[] memberDds = new DynamicObject[persistEntries.size()];
        for (int i = 0; i < persistEntries.size(); ++i) {
            memberDds[i] = persistEntries.get(i).getMemberTreeDy();
        }
        BatchProcessHelper.handleAsync(() -> SaveDimMemberHelper.batchSaveLog((DynamicObject[])memberDds));
    }

    @Override
    public void postOverride(List<OverrideResultEntry> overrideEntries) {
        List originDys = overrideEntries.stream().map(x -> x.getOriginDy()).collect(Collectors.toList());
        Map<String, String> originNames = originDys.stream().collect(Collectors.toMap(d -> d.getString("number"), d -> d.getString("name")));
        List<DynamicObject> overrideDys = overrideEntries.stream().map(x -> x.getOverridDy()).collect(Collectors.toList());
        this.updateShareMember(originNames, overrideDys);
        CommonPostImportHandler.handModifyLogAsync(overrideEntries.stream().map(x -> new Pair((Object)x.getOriginDy(), (Object)x.getOverridDy())).collect(Collectors.toList()), DimMemberOperateTypeEnum.IMPORT_EDIT);
    }

    public static void handModifyLogAsync(List<Pair<DynamicObject, DynamicObject>> originUpdatedDys, DimMemberOperateTypeEnum type) {
        if (CollectionUtils.isEmpty(originUpdatedDys)) {
            return;
        }
        Map<Long, DynamicObject> oldMemberMap = originUpdatedDys.stream().collect(Collectors.toMap(x -> ((DynamicObject)x.p2).getLong("id"), x -> (DynamicObject)x.p1));
        Function<Long, DynamicObject> getOriginDyByIdFunc = id -> {
            DynamicObject oldMember = (DynamicObject)oldMemberMap.get(id);
            if (Objects.isNull(oldMember)) {
                oldMember = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)((DynamicObject)((Pair)originUpdatedDys.get((int)0)).p2).getDynamicObjectType());
            }
            return oldMember;
        };
        BatchProcessHelper.handleAsync(() -> SaveDimMemberHelper.saveBatchImportUpdateLog(originUpdatedDys.stream().map(x -> (DynamicObject)x.p2).collect(Collectors.toList()), (DimMemberOperateTypeEnum)type, (Function)getOriginDyByIdFunc));
    }

    private void updateShareMember(Map<String, String> originNames, List<DynamicObject> overridedStoreMembers) {
        if (CollectionUtils.isEmpty(overridedStoreMembers)) {
            return;
        }
        BatchProcessHelper.batchHandle(overridedStoreMembers, (int)2000, subOverrideMems -> {
            ArrayList<DynamicObject> needOverrideShareMems = new ArrayList<DynamicObject>(16);
            subOverrideMems.stream().forEach(x -> {
                List<DynamicObject> shareMembers = PersistProxy.instance.listShareMembers(ImportHelper.getNumber(x));
                for (DynamicObject shareMember : shareMembers) {
                    try {
                        long parentId = ImportHelper.getBaseDataIdCompatible(x, "parent");
                        DynamicObject parentDy = PersistProxy.instance.getById(parentId, false);
                        long dimensionId = this.context.getImportDimension().getLong("id");
                        String sourceParentNum = Objects.nonNull(parentDy) ? parentDy.getString("number") : "";
                        String shareParentNum = shareMember.getString("parent.number");
                        needOverrideShareMems.add(ShareMemberHelper.syncStorageSourcePropertyToShare(dimensionId, x, shareMember, sourceParentNum.equals(shareParentNum), (String)originNames.get(shareMember.getString("number"))));
                    }
                    catch (Exception e) {
                        LOG.error("failed to sync the properties of source memebers to new share member", (Throwable)e);
                        throw e;
                    }
                }
            });
            if (needOverrideShareMems.size() > 0) {
                try (TXHandle tx = TX.requiresNew((String)"updateShareMemberBatch");){
                    try {
                        PersistProxy.instance.batchSaveOrUpdate(needOverrideShareMems);
                    }
                    catch (Throwable e) {
                        LOG.error("dimension_import_postoverride share_member rollback, error:" + e.getMessage(), e);
                        tx.markRollback();
                        throw new KDBizException(e.getMessage());
                    }
                }
            }
            return Collections.EMPTY_LIST;
        }, null, (int)4);
    }
}

