/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.handlers;

import java.util.HashSet;
import java.util.List;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.handlers.AbstractDimensionImportHandler;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.DimensionImportContext;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.OverrideResultEntry;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.PersistEntry;

public class EntityPostImportHandler
extends AbstractDimensionImportHandler {
    public EntityPostImportHandler(DimensionImportContext context) {
        super(context);
    }

    @Override
    public void postInsert(List<PersistEntry> persistEntries) {
    }

    @Override
    public void postOverride(List<OverrideResultEntry> overrideEntries) {
        String modelNumber = ImportHelper.getNumber(this.context.getImportModel());
        String dimensionNumber = ImportHelper.getNumber(this.context.getImportDimension());
        if (!"Entity".equalsIgnoreCase(dimensionNumber)) {
            return;
        }
        HashSet waitingCreateMems = new HashSet(overrideEntries.size());
        HashSet waitingDropMems = new HashSet(overrideEntries.size());
        overrideEntries.stream().forEach(x -> {
            if (!x.getNewParentNumber().equals(x.getOldParentNumber())) {
                String number = ImportHelper.getNumber(x.getOverridDy());
                waitingCreateMems.add(x.getNewParentNumber() + "_" + number);
                waitingDropMems.add(x.getOldParentNumber() + "_" + number);
            }
        });
        if (waitingCreateMems.size() > 0) {
            OlapServiceHelper.batchCreateDimensionMembers((String)modelNumber, (String)dimensionNumber, (String[])waitingCreateMems.toArray(new String[0]));
        }
        if (waitingDropMems.size() > 0) {
            OlapServiceHelper.batchDropDimensionMembers((String)modelNumber, (String)dimensionNumber, waitingDropMems);
        }
    }
}

