/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.handlers.IDimensionImportHandler;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.OverrideResultEntry;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.PersistEntry;

public class MemberAssignmentPermissionHandler
implements IDimensionImportHandler {
    @Override
    public void postInsert(List<PersistEntry> persistEntries) {
        long modelId = 0L;
        ArrayList<Map<String, Object>> rowDataLit = new ArrayList<Map<String, Object>>(persistEntries.size());
        for (PersistEntry persistEntry : persistEntries) {
            rowDataLit.add((Map<String, Object>)persistEntry.getBillWrap().getBill().getData());
            modelId = persistEntry.getMemberTreeDy().getLong("model");
        }
        this.dealMemberAssignmentPermission(rowDataLit, modelId);
    }

    @Override
    public void postOverride(List<OverrideResultEntry> overrideEntries) {
        ArrayList<Map<String, Object>> rowDataLit = new ArrayList<Map<String, Object>>(overrideEntries.size());
        long modelId = 0L;
        for (OverrideResultEntry overrideResultEntry : overrideEntries) {
            rowDataLit.add((Map<String, Object>)overrideResultEntry.getBillWrap().getBill().getData());
            modelId = ((DynamicObject)overrideResultEntry.getOverridDy().get("model")).getLong("id");
        }
        this.dealMemberAssignmentPermission(rowDataLit, modelId);
    }

    private void dealMemberAssignmentPermission(List<Map<String, Object>> rowDataLit, long modelId) {
        DeleteServiceHelper.delete((String)"bcm_memberperm", (QFilter[])new QFilter[]{new QFilter("member", "in", rowDataLit.stream().map(x -> x.get("id")).collect(Collectors.toList())).and("model", "=", (Object)modelId)});
        ArrayList allMemPermissions = new ArrayList(rowDataLit.size());
        for (Map<String, Object> singMap : rowDataLit) {
            List memPermissions = (List)singMap.get("memberAssignmentPermission");
            if (memPermissions == null || memPermissions.size() == 0) continue;
            allMemPermissions.addAll(memPermissions);
        }
        if (allMemPermissions.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])allMemPermissions.toArray(new DynamicObject[allMemPermissions.size()]));
        }
    }
}

